local base = _G

module('me_trigrules')

local loader = base.require('dialog_loader')
local U = base.require('me_utilities')
local Form = base.require('me_trigrules_form')
local mission = base.require('me_mission')
local predicates = base.require('me_predicates')
local S = base.require('Serializer')
local failures = base.require('me_failures')

base.require('i18n').setup(_M)

cdata = {
    triggers = _("TRIGGERS"),
    new = _("NEW"),
    open = _("OPN"),
    update = _("UPDATE"),
    delete = _("DELETE"),
    rules = _("RULES"),
    rule = _("TYPE:"),
    type = _("TYPE:"),
    actions = _("ACTIONS"),
    action = _("ACTION:"),


    predicates = {
        trigger = _("TRIGGER"),
        triggerOnce = _("ONCE"),
        triggerContinious = _("CONTINUOUS"),
        triggerStart = _("MISSION START"),
        triggerFront = _("FRONT CONDITION"),
        score = _("SCORE"),
        a_out_text_delay = _("MESSAGE"),
        a_out_text_delay_c = _("COUNTRY MSG"),
        a_out_text_delay_s = _("COALITION MSG"),
        a_out_sound = _("SOUND"),
        a_out_sound_c = _("COUNTRY SND"),
        a_out_sound_s = _("COALITION SND"),
        a_activate_group = _("ACTIVATE GROUP"),
        a_deactivate_group = _("DEACTIVATE GROUP"),
        a_end_mission = _("END MISSION"),
        a_set_flag = _("SET FLAG"),
        a_clear_flag = _("CLEAR FLAG"),
        a_set_failure = _("SET FAILURE"),
        
        a_explosion = _("EXPLOSION"),
        a_explosion_unit = _("EXPLODE UNIT"),
        a_explosion_marker = _("EXPLODE WP MARKER"),
        a_explosion_marker_unit = _("EXPLODE WP MARKER ON UNIT"),
        a_illumination_bomb = _("ILLUMINATING BOMB"),
        a_signal_flare = _("SIGNAL FLARE"),
        a_signal_flare_unit = _("SIGNAL FLARE ON UNIT"),

        a_load_mission = _("LOAD MISSION"),
    },
    values = {
        score = _("SCORE:"),
        comment = _("NAME:"),
        text = _("TEXT:"),
        flag = _("FLAG:"),
        seconds = _("SECONDS:"),
        file = _("FILE:"),
        group = _("GROUP:"),
        random_pause = _("Within(mm)"),
        probability = _("Probability(%)"),
        failure = _("FAILURE:"),
        coalitionlist = _("COALITION:"),
        countrylist = _("COUNTRY:"),
        volume = _("VOLUME:"),
        altitude = _("ALTITUDE:"),
        winner = _("WINNER:"),
    }

};

function convertMultilineText(p1, text)
    text = base.string.gsub(text, '\n', ' ');
    text = base.string.sub(text, 1, 30);
    return text;
end;

function convertMultilineText2(p1, text)
    return text;
end;

-- descripption of triggers
triggersDescr = {
    {
        name = "triggerOnce";
        firstValueAsName = false;
        fields = {
            {
                id = "comment",
                type = "edit",
                default = "",
            },
        }
    },
    {
        name = "triggerContinious";
        firstValueAsName = false;
        fields = {
            {
                id = "comment",
                type = "edit",
                default = "",
            },
        }
    },
    {
        name = "triggerStart";
        firstValueAsName = false;
        fields = {
            {
                id = "comment",
                type = "edit",
                default = "",
            },
        }
    },
    {
        name = "triggerFront";
        firstValueAsName = false;
        fields = {
            {
                id = "comment",
                type = "edit",
                default = "",
            },
        }
    },
}

function failureLister()
	--base.print('failureLister()')
    local failure = { }
    for k, v in base.pairs(failures.vdata) do
        base.table.insert(failure, { id=k, name=v.label })
    end
	
	--base.U.traverseTable(failure)
    return failure
end

function failureIdToName(cdata, id)
    for k, v in base.pairs(failures.vdata) do	
        if id == k then return v.label end
    end
    return ""    
end

function isActionFailures()
	result = false
	
	if (mission.mission.trigrules) then
		for _tmp, trigger in base.ipairs(mission.mission.trigrules)do
			for _tmp, action in base.ipairs(trigger.actions) do
				if (action.predicate.name == "a_set_failure") then
					--base.U.traverseTable(action)
					result = true
				end
			end
		end
	end
				
	return result
end

-- conver groupId to group name
function groupIdToName(cdata, id)
    if not id then
        return ""
    else
        local group = mission.group_by_id[id]
        if group then
            return group.name
        else
            return ""
        end
    end
end

-- return true if group with specified ID exists
function isGroupExists(id)
    return nil ~= mission.group_by_id[id]
end

function null_transform(cdata,param) -- to make sure we will use serializeFunc instead of displayFunc
    return param 
end 

function countryLister()
    local countries = { }
    for k, v in base.pairs(base.me_db.country_by_id) do
        base.table.insert(countries, { id=k, name=v.Name })
    end
    return countries
end

function countryIdToName(cdata, id)
    for k, v in base.pairs(base.me_db.country_by_id) do
        if id == k then return v.Name end
    end
    return ""    
end

function coalitionLister()
    return {{id="red",name=_("RED"),},{id="blue",name=_("BLUE")}}
end

function coalitionIdToName(cdata, id)
    if id == "red" then return _("RED") elseif id == "blue" then return _("BLUE") else return _("UNKNOWN") end
end

function winnerLister()
    return {{id="",name=""},{id="red",name=_("RED"),},{id="blue",name=_("BLUE")}}
end

function winnerIdToName(cdata, id)
    if id == "" then return "" elseif id == "red" then return _("RED") elseif id == "blue" then return _("BLUE") else return _("UNKNOWN") end
end

-- groups names enumerator
function groupsLister()
    local groups = { }
    for k, v in base.pairs(mission.group_by_id) do
        if v and ('static' ~= v['type']) then
            base.table.insert(groups, { id=k, name=v.name })
        end
    end
    base.table.sort(groups, U.namedTableComparator)
    return groups
end

function colorLister()
    return {{id="0",name=_("GREEN"),},{id="1",name=_("RED")},{id="2",name=_("WHITE")},{id="3",name=_("YELLOW")},}
end

function colorIdToName(cdata, id)
    if id == "0" then return _("GREEN") 
    elseif id == "1" then return _("RED") 
    elseif id == "2" then return _("WHITE") 
    elseif id == "3" then return _("YELLOW") 
    else return _("UNKNOWN") end
end


-- list of available actions for score calculation and their arguments
-- list of available actions for triggers and their arguments
actionsDescr = {
--[[    
    {
        name = "a_out_text";
        fields = {
            {
                id = "text",
                type = "medit",
                default = "",
                displayFunc = convertMultilineText,
                serializeFunc = convertMultilineText2,
            },
        }
    },
]]
    {
        name = "a_out_text_delay";
        fields = {
            {
                id = "text",
                type = "medit",
                default = "",
                displayFunc = convertMultilineText,
                serializeFunc = convertMultilineText2,
            },
            {
                id = "seconds",
                type = "spin",
                default = 10,
            },
        },
    },

    {
        name = "a_out_text_delay_s";
        fields = {
            {
                id = "coalitionlist",
                type = "combo",
                comboFunc = coalitionLister,
                displayFunc = coalitionIdToName,
                serializeFunc = null_transform,
                default = "",
            },
            {
                id = "text",
                type = "medit",
                default = "",
                displayFunc = convertMultilineText,
                serializeFunc = convertMultilineText2,
            },
            {
                id = "seconds",
                type = "spin",
                default = 10,
            },
        },
    },

    {
        name = "a_out_text_delay_c";
        fields = {
            {
                id = "countrylist",
                type = "combo",
                comboFunc = countryLister,
                displayFunc = countryIdToName,
                serializeFunc = null_transform,
                default = "",
            },
            {
                id = "text",
                type = "medit",
                default = "",
                displayFunc = convertMultilineText,
                serializeFunc = convertMultilineText2,
            },
            {
                id = "seconds",
                type = "spin",
                default = 10,
            },
        }
    },

    {
        name = "a_set_flag";
        fields = {
            {
                id = "flag",
                type = "spin",
                default = 1,
                min = 1,
                max = 1000000000,
            },
        }
    },

    {
        name = "a_clear_flag";
        fields = {
            {
                id = "flag",
                type = "spin",
                default = 1,
                min = 1,
                max = 1000000000,
            },
        }
    },

    {
        name = "a_out_sound";
        fields = {
            {
                id = "file",
                type = "file_edit",
                default = "",
                --buttonFunc = chooseSoundFile,
            },
        }
    },

    {
        name = "a_out_sound_s";
        fields = {
            {
                id = "coalitionlist",
                type = "combo",
                comboFunc = coalitionLister,
                displayFunc = coalitionIdToName,
                serializeFunc = null_transform,
                default = "",
            },
            {
                id = "file",
                type = "file_edit",
                default = "",
            },
        }
    },
    
    {
        name = "a_out_sound_c";
        fields = {
            {
                id = "countrylist",
                type = "combo",
                comboFunc = countryLister,
                displayFunc = countryIdToName,
                serializeFunc = null_transform,
                default = "",
            },
            {
                id = "file",
                type = "file_edit",
                default = "",
            },
        }
    },
    
    {
        name = "a_activate_group";
        fields = {
            {
                id = "group",
                type = "combo",
                default = "",
                comboFunc = groupsLister,
                displayFunc = groupIdToName,
                existsFunc = isGroupExists,
            },
        }
    },

    {
        name = "a_deactivate_group";
        fields = {
            {
                id = "group",
                type = "combo",
                default = "",
                comboFunc = groupsLister,
                displayFunc = groupIdToName,
                existsFunc = isGroupExists,
            },
        }
    },

    {
        name = "a_end_mission";
        fields = {
            {
                id = "winner",
                type = "combo",
                default = "",
                comboFunc = winnerLister,
                displayFunc = winnerIdToName,
                serializeFunc = null_transform,
            },
            {
                id = "text",
                type = "medit",
                default = "",
                displayFunc = convertMultilineText,
                serializeFunc = convertMultilineText2,
            },
        }
    },

    {
        name = "a_set_failure";
        fields = {
            {
                id = "failure",
                type = "combo",
                comboFunc = failureLister,
                displayFunc = failureIdToName,
                serializeFunc = null_transform,
                default = "",
            },
            {
                id = "probability",
                type = "spin",
                default = 100,
                min = 1,
                max = 100,
            },
            {
                id = "random_pause",
                type = "spin",
                default = 0,
                min = 0,
                max = 999,
            }
        }
    },

    {
        name = "a_explosion",
        fields = {
            {
                id = "zone",
                type = "combo",
                comboFunc = predicates.zonesLister,
                displayFunc = predicates.zoneIdToName,
                existsFunc = predicates.isZoneExists,
                default = "",
            },
            {
                id = "altitude",
                type = "spin",
                default = 1,
                min = 1,
                max = 100000,
            },
            {
                id = "volume",
                type = "spin",
                default = 1000,
                min = 1,
                max = 10000,
            },
        }
    },

    {
        name = "a_explosion_unit",
        fields = {
            {
                id = "unit",
                type = "combo",
                comboFunc = predicates.unitsLister,
                displayFunc = predicates.unitIdToName,
                existsFunc = predicates.isUnitExists,
                serializeFunc = null_transform,
                default = "",
            },
            {
                id = "volume",
                type = "spin",
                default = 1000,
                min = 1,
                max = 10000,
            },
        }
    },
    {
        name = "a_explosion_marker",
        fields = {
            {
                id = "zone",
                type = "combo",
                comboFunc = predicates.zonesLister,
                displayFunc = predicates.zoneIdToName,
                existsFunc = predicates.isZoneExists,
                default = "",
            },
            {
                id = "altitude",
                type = "spin",
                default = 1,
                min = 1,
                max = 100000,
            },
        }
    },
    {
        name = "a_explosion_marker_unit",
        fields = {
            {
                id = "unit",
                type = "combo",
                comboFunc = predicates.unitsLister,
                displayFunc = predicates.unitIdToName,
                existsFunc = predicates.isUnitExists,
                serializeFunc = null_transform,
                default = "",
            },
        }
    },
    {
        name = "a_illumination_bomb",
        fields = {
            {
                id = "zone",
                type = "combo",
                comboFunc = predicates.zonesLister,
                displayFunc = predicates.zoneIdToName,
                existsFunc = predicates.isZoneExists,
                default = "",
            },
            {
                id = "altitude",
                type = "spin",
                default = 1,
                min = 1,
                max = 100000,
            },
        }
    },
    {
        name = "a_signal_flare",
        fields = {
            {
                id = "zone",
                type = "combo",
                comboFunc = predicates.zonesLister,
                displayFunc = predicates.zoneIdToName,
                existsFunc = predicates.isZoneExists,
                default = "",
            },
            {
                id = "altitude",
                type = "spin",
                default = 1,
                min = 1,
                max = 100000,
            },
            {
                id = "color",
                type = "combo",
                comboFunc = colorLister,
                displayFunc = colorIdToName,
                serializeFunc = null_transform,
                default = "0",
            },
        }
    },
    {
        name = "a_signal_flare_unit",
        fields = {
            {
                id = "unit",
                type = "combo",
                comboFunc = predicates.unitsLister,
                displayFunc = predicates.unitIdToName,
                existsFunc = predicates.isUnitExists,
                serializeFunc = null_transform,
                default = "",
            },
            {
                id = "color",
                type = "combo",
                comboFunc = colorLister,
                displayFunc = colorIdToName,
                serializeFunc = null_transform,
                default = "0",
            },
        }
    },
    {
        name = "a_load_mission";
        fields = {
            {
                id = "file",
                type = "file_miz",
                default = "",
            },
        }
    },

}



-- create dialog
function create(x, y, w, h)
    U.copyTable(cdata, predicates.cdata)
    triggersWindow = Form.create(x, y, w, h, cdata)
	
	--Blindspot
    triggersWindow.btn_TriggerDown = U.create_arrow_button('down')
    triggersWindow.btn_TriggerDown:setBounds(271, 21, 17, 17)
    triggersWindow:addChild(triggersWindow.btn_TriggerDown)

    triggersWindow.btn_TriggerUp = U.create_arrow_button('up')
    triggersWindow.btn_TriggerUp:setBounds(250, 21, 17, 17)
    triggersWindow:addChild(triggersWindow.btn_TriggerUp)

	triggersWindow.btn_RuleDown = U.create_arrow_button('down')
    triggersWindow.btn_RuleDown:setBounds(571, 21, 17, 17)
    triggersWindow:addChild(triggersWindow.btn_RuleDown)

	triggersWindow.btn_RuleUp = U.create_arrow_button('up')
    triggersWindow.btn_RuleUp:setBounds(550, 21, 17, 17)
    triggersWindow:addChild(triggersWindow.btn_RuleUp)

	triggersWindow.btn_GoalDown = U.create_arrow_button('down')
    triggersWindow.btn_GoalDown:setBounds(871, 21, 17, 17)
    triggersWindow:addChild(triggersWindow.btn_GoalDown)

	triggersWindow.btn_GoalUp = U.create_arrow_button('up')
    triggersWindow.btn_GoalUp:setBounds(850, 21, 17, 17)
    triggersWindow:addChild(triggersWindow.btn_GoalUp)
	--/Blindspot
	
    if 1 == #triggersDescr then
        hideTriggerType(triggersWindow)
    end
end


-- show triggers dialog
function show(b)
    if b then
        if not mission.mission.trigrules then
            mission.mission.trigrules = { }
        end
        fixTriggers(mission.mission.trigrules)
        setupCallbacks(triggersWindow, mission.mission.trigrules, 
                 triggersDescr, actionsDescr, predicates.rulesDescr, cdata)
    end
    triggersWindow:setVisible(b)
end


-- create widgets for rule predicate editing
function createRuleArgumentsWidgets(window, rule, list, cdata)
    local labelX, _tmp, labelW, _tmp1 = window.ruleTypeLabel:getBounds()
    local comboX, _tmp, comboW, comboH = window.ruleTypeCombo:getBounds()
    predicates.updateArgumentsPanel(rule, list, window.argsContainer, labelX, 
        comboX, labelW, comboW, comboH, cdata, window.ruleTypeLabel:getTheme())
end


-- create widgets for action editing
function createActionArgumentsWidgets(window, rule, cdata)
	--base.U.traverseTable(rule)
    local labelX, _tmp, labelW, _tmp1 = window.goalTypeLabel:getBounds()
    local comboX, _tmp, comboW, comboH = window.goalTypeCombo:getBounds()
    predicates.updateArgumentsPanel(rule, window.goalsList, 
        window.goalArgsContainer, labelX, comboX, labelW, comboW, comboH, 
        cdata, window.ruleTypeLabel:getTheme())
end

-- create widgets for trigger editing
function createTriggerArgumentsWidgets(window, rule, cdata)
    local labelX, _tmp, labelW, _tmp1 = window.triggerTypeLabel:getBounds()
    local comboX, _tmp, comboW, comboH = window.triggerTypeCombo:getBounds()
    predicates.updateArgumentsPanel(rule, window.triggersList, 
        window.triggerArgsContainer, labelX, comboX, labelW, comboW, comboH, 
        cdata, window.ruleTypeLabel:getTheme())
end


-- Create action from description
function createAction(descr)
    return predicates.createRule(descr)
end


-- Create trigger from description
function createTrigger(descr)
    local res = predicates.createRule(descr)
    res.actions = { }
    res.rules = { }
    return res
end



-- show or hide rules widgets
function showRulesWidgets(window, visible)
    predicates.showWidgets(visible, window.argsContainer, window.ruleTypeCombo,
        window.ruleTypeLabel, window.delRuleBtn, window.btn_RuleUp, window.btn_RuleDown, window.cloneRuleBtn)
end


-- show or hide goals widgets
function showGoalsWidgets(window, visible)
    predicates.showWidgets(visible, window.goalArgsContainer, 
        window.goalTypeCombo, window.goalTypeLabel, window.delGoalBtn, window.btn_GoalUp, window.btn_GoalDown, window.cloneGoalBtn)
end


-- show or hide triggers widgets
function showTriggersWidgets(window, visible, noActionChoice)
    if noActionChoice then
        predicates.showWidgets(visible, window.triggerArgsContainer, 
                window.delTriggerBtn, window.btn_TriggerUp, window.btn_TriggerDown, window.duplicateTriggerBtn)
    else
        predicates.showWidgets(visible, window.triggerArgsContainer, 
                window.triggerTypeCombo, window.triggerTypeLabel, 
                window.delTriggerBtn, window.btn_TriggerUp, window.btn_TriggerDown, window.duplicateTriggerBtn)
    end
end



-- hide action type combo
function hideTriggerType(window)

    window.triggerTypeLabel:setVisible(false)
    window.triggerTypeCombo:setVisible(false)
    local x, y, w, h = window.triggerArgsContainer:getBounds()
    local _tmp, _tmp1, _tmp2, offset = window.triggerTypeCombo:getBounds()
    offset = offset + 10
    window.triggerArgsContainer:setBounds(x, y - offset, w, h + offset)

end



-- setup callbacks
function setupCallbacks(window, triggers, triggersDesc, actionsDescr, 
                rulesDescr, cdata)

    -- close form
    function window.container.closeBtn:onChange()
        base.toolbar.untoggle_all_except()
    end

    local noTriggerChoice = (1 == #triggersDescr)

    -- add new trigger on new button pressed
	-- changed by Blindspot to insert after current position
    function window.newTriggerBtn:onChange()

		-- Blind:
		-- get current selection index if anything selected
		local idxInsert = #window.triggersList:getChildren()+1
		local item = window.triggersList:getSelectedItem()
        if item then
			local trigger = item.itemId
			idxInsert = predicates.getIndex(triggers, trigger)+1
		end

		-- create trigger
		local trigger = createTrigger(triggersDescr[1])
        base.table.insert(triggers, idxInsert, trigger)
		
		--local item = U.addListBoxItem(window.triggersList, predicates.getRuleAsText(trigger, cdata), nil, trigger)

		-- refresh list
		predicates.rulesToList(window.triggersList, triggers, cdata)

		-- select new item
		item = window.triggersList:getChildren()[idxInsert]
        window.triggersList:selectItem(item)
        window.triggersList:onChange(item)
    end
	
    -- move up trigger button pressed (by Blindspot)
    function window.btn_TriggerUp:onChange()
        local item = window.triggersList:getSelectedItem()
        if item then
			-- reorder within triggers list
			local trigger = item.itemId
            local idx = predicates.getIndex(triggers, trigger)
            if(idx > 1) then
				base.table.insert(triggers, (idx-1), base.table.remove(triggers, idx))

				-- update list box
				predicates.rulesToList(window.triggersList, triggers, cdata)
				
				item = window.triggersList:getChildren()[idx-1]
				window.triggersList:selectItem(item)
				window.triggersList:onChange(item)
			end
		end
    end

    -- move down trigger button pressed (by Blindspot)
    function window.btn_TriggerDown:onChange()
        local item = window.triggersList:getSelectedItem()
        if item then
			-- reorder within triggers list
			local trigger = item.itemId
            local idx = predicates.getIndex(triggers, trigger)
            if idx < #window.triggersList:getChildren() then
				base.table.insert(triggers, (idx+1), base.table.remove(triggers, idx))

				-- update list box
				predicates.rulesToList(window.triggersList, triggers, cdata)
				
				item = window.triggersList:getChildren()[idx+1]
				window.triggersList:selectItem(item)
				window.triggersList:onChange(item)
			end
		end
    end


	-- move up goal button pressed (by Blindspot)
    function window.btn_GoalUp:onChange()
        local itemTrigger = window.triggersList:getSelectedItem()
		local itemGoal = window.goalsList:getSelectedItem()
        if itemTrigger and itemGoal then
			-- get goals list
			local trigger = itemTrigger.itemId
			local goal = itemGoal.itemId
			local goals = trigger.actions
			if goals then
				-- reorder within goals list
				local idx = predicates.getIndex(goals, goal)
				if(idx > 1) then
					base.table.insert(goals, (idx-1), base.table.remove(goals, idx))

					-- update list box
					predicates.rulesToList(window.goalsList, goals, cdata)
					local item = window.goalsList:getChildren()[idx-1]
					window.goalsList:selectItem(item)
					window.goalsList:onChange(item)
				end
			end
		end
    end

    -- move down goal button pressed (by Blindspot)
    function window.btn_GoalDown:onChange()
        local itemTrigger = window.triggersList:getSelectedItem()
		local itemGoal = window.goalsList:getSelectedItem()
        if itemTrigger and itemGoal then
			-- get goals list
			local trigger = itemTrigger.itemId
			local goal = itemGoal.itemId
			local goals = trigger.actions
			if goals then
				-- reorder within goals list
				local idx = predicates.getIndex(goals, goal)
				if idx < #window.goalsList:getChildren() then
					base.table.insert(goals, (idx+1), base.table.remove(goals, idx))

					-- update list box
					predicates.rulesToList(window.goalsList, goals, cdata)
					local item = window.goalsList:getChildren()[idx+1]
					window.goalsList:selectItem(item)
					window.goalsList:onChange(item)
				end
			end
		end
    end
	
	
	-- move up rule button pressed (Blindspot)
    function window.btn_RuleUp:onChange()
        local itemTrigger = window.triggersList:getSelectedItem()
		local itemRule = window.rulesList:getSelectedItem()
		local block = "A"

		if itemRule == nil then
			itemRule = window.rulesList2:getSelectedItem()
			block = "B"
		end
		
		if itemRule and itemTrigger then
			local trigger = itemTrigger.itemId
			local rule = itemRule.itemId
			local idxData = predicates.getIndex(trigger.rules, rule)
			local idxNext = findPrevRule(trigger.rules, idxData-1, block)
			
			if idxNext > 0 then
				base.table.insert(trigger.rules, idxNext, base.table.remove(trigger.rules, idxData))
		
				predicates.rulesToList2(window.rulesList, window.rulesList2, trigger.rules, cdata)

				if block == "A" then
					local item = window.rulesList:getChildren() [findRuleBlockIndex(trigger.rules, rule, block)]
					window.rulesList:selectItem( item)
					window.rulesList:onChange(item)
				else
					local item = window.rulesList2:getChildren() [findRuleBlockIndex(trigger.rules, rule, block)]
					window.rulesList2:selectItem( item)
					window.rulesList2:onChange(item)
				end
			end
		end
		
		
	end
	
	-- move down rule button pressed (Blindspot)
    function window.btn_RuleDown:onChange()
        local itemTrigger = window.triggersList:getSelectedItem()
		local itemRule = window.rulesList:getSelectedItem()
		local block = "A"

		if itemRule == nil then
			itemRule = window.rulesList2:getSelectedItem()
			block = "B"
		end
		
		if itemRule and itemTrigger then
			local trigger = itemTrigger.itemId
			local rule = itemRule.itemId
			local idxData = predicates.getIndex(trigger.rules, rule)
			local idxNext = findNextRule(trigger.rules, idxData+1, block)
			
			if idxNext > 0 then
				base.table.insert(trigger.rules, idxNext, base.table.remove(trigger.rules, idxData))
		
				predicates.rulesToList2(window.rulesList, window.rulesList2, trigger.rules, cdata)

				if block == "A" then
					local item = window.rulesList:getChildren() [findRuleBlockIndex(trigger.rules, rule, block)]
					window.rulesList:selectItem( item)
					window.rulesList:onChange(item)
				else
					local item = window.rulesList2:getChildren() [findRuleBlockIndex(trigger.rules, rule, block)]
					window.rulesList2:selectItem( item)
					window.rulesList2:onChange(item)
				end
			end
		end
		
		
	end
	
	function findPrevRule(rules, idxFrom, block)
		for i=idxFrom , 1, -1 do
			if ((block == "A") and (rules[i].logicBlock == nil)) or (rules[i].logicBlock == block) then
				return i
			end
		end
		return 0
	end

	function findNextRule(rules, idxFrom, block)
		for i=idxFrom , #rules, 1 do
			if ((block == "A") and (rules[i].logicBlock == nil)) or (rules[i].logicBlock == block) then
				return i
			end
		end
		return 0
	end

	function findRuleBlockIndex(rules, rule, block)
		local idxBlock = 1
		for i=1, #rules, 1 do
			if rules[i] == rule then
				return idxBlock
			else
				if ((rules[i].logicBlock == nil) and (block == "A")) or (rules[i].logicBlock == block) then
					idxBlock = idxBlock + 1
				end
			end
		end
		return 0 -- not found
	end
	
	
    -- duplicate button pressed (by Blindspot)
    function window.duplicateTriggerBtn:onChange()
        local item = window.triggersList:getSelectedItem()
        if item then
			-- selected trigger
			local trigger = item.itemId
            local idx = predicates.getIndex(triggers, trigger)

			-- create new trigger as copy of selected one
			local triggerNew = createTrigger(trigger.predicate)
			U.copyTable(triggerNew, trigger)
			
			-- autonum 
			local apdx = base.string.match(triggerNew.comment, " #%d+$")
			if apdx then			
				-- the copied name is already numbered
			else
				-- are there numbered versions of this base string?
				for i=1, #triggers do
					local v = triggers[i]
					if(base.string.match(v.comment, triggerNew.comment .. " #%d+$")) then
						apdx = ""
						break
					end
				end
			end
			
			-- new name for copy
			if apdx then
				local nMax = 0
				local strBase = base.string.sub(triggerNew.comment, 1, base.string.len(triggerNew.comment) - base.string.len(apdx))
				local expBase = strBase .. " #%d+$"
				for i=1, #triggers do
					local v = triggers[i]
					if(base.string.match(v.comment, expBase)) then
						apdx = base.string.sub(v.comment, base.string.len(strBase)+3)
						nMax = base.math.max(nMax, apdx)
					end
				end
				triggerNew.comment = strBase .. base.string.format(" #%.3d", nMax+1)
			else
				triggerNew.comment = triggerNew.comment .. " #001"
			end
			
			base.table.insert(triggers, (idx+1), triggerNew)
			
			-- update list box
			predicates.rulesToList(window.triggersList, triggers, cdata)

			-- select new trigger
			item = window.triggersList:getChildren()[idx+1]
			window.triggersList:selectItem(item)
			window.triggersList:onChange(item)
		end
    end

	function window.cloneRuleBtn:onChange()
		local itemTrig = window.triggersList:getSelectedItem()
		local itemRule = window.rulesList:getSelectedItem()
		local bA = true
		if itemRule == nil then
			itemRule = window.rulesList2:getSelectedItem()
			bA = false
		end
		
		if itemTrig and itemRule then
			local trigger = itemTrig.itemId
			local rule = itemRule.itemId
			local clone = { }
			U.copyTable(clone, rule)
			
			local idxData = predicates.getIndex(trigger.rules, rule)
			base.table.insert(trigger.rules, (idxData+1), clone)
			
			if bA then
				local item = U.addListBoxItem(window.rulesList, predicates.getRuleAsText(clone, cdata), nil, clone)
				window.rulesList:selectItem(item)
				window.rulesList:onChange(item)
			else
				local item = U.addListBoxItem(window.rulesList2, predicates.getRuleAsText(clone, cdata), nil, clone)
				window.rulesList2:selectItem(item)
				window.rulesList2:onChange(item)
			end
		end
	end
	
	function window.cloneGoalBtn:onChange()
		local itemTrig = window.triggersList:getSelectedItem()
		local itemGoal = window.goalsList:getSelectedItem()
		
		if itemTrig and itemGoal then
			local trigger = itemTrig.itemId
			local goal = itemGoal.itemId
			local clone = { }
			U.copyTable(clone, goal)
			
			local idxData = predicates.getIndex(trigger.actions, goal)
			base.table.insert(trigger.actions, (idxData+1), clone)

			predicates.rulesToList(window.goalsList, trigger.actions, cdata)

			-- select new trigger
			item = window.goalsList:getChildren()[idxData+1]
			window.goalsList:selectItem(item)
			window.goalsList:onChange(item)
		end
	end
	
	
    -- delete current trigger
    function window.delTriggerBtn:onChange()
		--base.print('delTriggerBtn:onChange()')
        local item = window.triggersList:getSelectedItem()
        if item then
            local trigger = item.itemId
            --base.U.traverseTable(trigger);
			
            --               
            
			-- entfernen aller Dateien, die in dateibezogener Aktion verwendet werden und deren refcnt insgesamt nun 0 ist
            for _tmp, action in base.ipairs(trigger.actions) do
              for _tmp, field in base.ipairs(action.predicate.fields) do
					if (field.type == 'file_edit') and (action.file ~= '') then
						local num = 0
						for _tmp, trigger2 in base.ipairs(triggers)do
							for _tmp, action2 in base.ipairs(trigger2.actions) do
								if ((action2.file == action.file) and (action2 ~= action)) then
									num = num + 1
								end
							end
						end

						if (num == 0) then
							--base.print("delFile")
							mission.removeFileFromMission(action.file);														
						end
						action.file = '';
					end;
              end
            end
			
          
            local idx = predicates.getIndex(triggers, trigger)
            base.table.remove(triggers, idx)
            window.triggersList:removeWidget(item)
            if idx > #window.triggersList:getChildren() then
                idx = idx - 1
            end
            item = window.triggersList:getChildren()[idx]
            window.triggersList:selectItem(item)
            window.triggersList:onChange(item)
        end
    end

    -- called on new trigger selected 
    function window.triggersList:onChange(item)		
        if item then
            showTriggersWidgets(window, true, noTriggerChoice)
            local trigger = item.itemId
            predicates.rulesToList(window.goalsList, trigger.actions, cdata)
            predicates.rulesToList2(window.rulesList, window.rulesList2, trigger.rules, cdata)
            window.triggerTypeCombo.selectedItem = trigger
            window.triggerTypeCombo:setText(predicates.getPredicateName(trigger.predicate, 
                        cdata))
            createTriggerArgumentsWidgets(window, trigger, cdata)

			--blind:
			if trigger.triggerLogic then setOrLogic("OR" == trigger.triggerLogic) else setOrLogic(true) end
        else
            showTriggersWidgets(window, false, noTriggerChoice)
            predicates.rulesToList(window.goalsList, nil, cdata)
            predicates.rulesToList2(window.rulesList, window.rulesList2, nil, cdata)
            showTriggersWidgets(window, false)
			setOrLogic(true) --default
        end
    end
    
    -- called on new goal selected 
    function window.goalsList:onChange(item)
		--base.print('goalsList:onChange')
        if item then
            showGoalsWidgets(window, true)
            local goal = item.itemId
            window.goalTypeCombo.selectedItem = goal
            window.goalTypeCombo:setText(predicates.getPredicateName(goal.predicate, cdata))
            createActionArgumentsWidgets(window, goal, cdata)
        else
            showGoalsWidgets(window, false)
        end
    end
    
    -- add new goal on new button pressed
    function window.newGoalBtn:onChange()
		--base.print('newGoalBtn:onChange()')
        local item = window.triggersList:getSelectedItem()
        if item then
            local trigger = item.itemId
            local goal = createAction(actionsDescr[1])
            base.table.insert(trigger.actions, goal)
            local item = U.addListBoxItem(window.goalsList, 
                    predicates.getRuleAsText(goal, cdata), nil, goal)
            window.goalsList:selectItem(item)
            window.goalsList:onChange(item)
        end
    end

    -- delete current action
    function window.delGoalBtn:onChange()
		--base.print('delGoalBtn:onChange()')
        local triggerItem = window.triggersList:getSelectedItem()
        local item = window.goalsList:getSelectedItem()
        if item and triggerItem then
            local goal = item.itemId
            local goals = triggerItem.itemId.actions
            if (goal ~= nil) and (goal.file ~= nil) and (goal.file ~= '') then
                --mission.removeFileFromMission(goal.file);
				--                          			
				local num = 0
				for _tmp, trigger2 in base.ipairs(triggers)do
					for _tmp, action2 in base.ipairs(trigger2.actions) do
						if ((action2.file == goal.file) and (action2 ~= goal)) then
							--base.print('trigger2=',action2,'  goal=',goal)
							num = num + 1
						end
					end
				end
				base.print('num=',num)
				if (num == 0) then
					--base.print("delFile")
					mission.removeFileFromMission(goal.file);														
				end
				
						
            end;
            local idx = predicates.getIndex(goals, goal)
            base.table.remove(goals, idx)
            window.goalsList:removeWidget(item)
            if idx > #window.goalsList:getChildren() then
                idx = idx - 1
            end
            item = window.goalsList:getChildren()[idx]
            window.goalsList:selectItem(item)
            window.goalsList:onChange(item)
        end
    end
    
    -- if action type was changed 
    function window.goalTypeCombo:onChange(item)
		--base.print('goalTypeCombo:onChange')
        self.selectedItem = item.itemId
        if window.goalsList:getSelectedItem() then
            local goal = window.goalsList:getSelectedItem().itemId			
            goal.predicate = item.itemId
            predicates.setRuleDefaults(goal, item.itemId)
            createActionArgumentsWidgets(window, goal, cdata)
            predicates.updateListRow(window.goalsList, predicates.ruleTextFunc(cdata))
        end
    end
    
    -- if trigger type was changed 
    function window.triggerTypeCombo:onChange(item)
		--base.print('window.triggerTypeCombo:onChange(item)')
        self.selectedItem = item.itemId
        if window.triggersList:getSelectedItem() then
            local trigger = window.triggersList:getSelectedItem().itemId
            trigger.predicate = item.itemId
            createTriggerArgumentsWidgets(window, trigger, cdata)
            predicates.updateListRow(window.triggersList, predicates.ruleTextFunc(cdata))
        end
    end
    
    -- called on new rule (A) selected 
    function window.rulesList:onChange(item)
		--base.print('window.rulesList:onChange(item)')
        window.rulesList2:selectItem(nil)
        if item then
            showRulesWidgets(window, true)
            local rule = item.itemId
            createRuleArgumentsWidgets(window, rule, window.rulesList, cdata)
            window.ruleTypeCombo.selectedItem = rule
            window.ruleTypeCombo:setText(predicates.getPredicateName(rule.predicate, cdata))
        else
            showRulesWidgets(window, false)
        end
    end

    -- called on new rule (B) selected 
    function window.rulesList2:onChange(item)
		--base.print('window.rulesList2:onChange(item)')
        window.rulesList:selectItem(nil)
		if item then
            showRulesWidgets(window, true)
            local rule = item.itemId
            createRuleArgumentsWidgets(window, rule, window.rulesList2, cdata)
            window.ruleTypeCombo.selectedItem = rule
            window.ruleTypeCombo:setText(predicates.getPredicateName(rule.predicate, cdata))
        else
            showRulesWidgets(window, false)
        end
    end

	
	function window.btnAorB:onChange()
		setOrLogic(true)
	end

	function window.btnAandB:onChange()
		setOrLogic(false)
	end
    
	function setOrLogic(bOr)
		window.btnAorB:setState(bOr)
		window.btnAandB:setState(not bOr)
		window.labelConditionsA:setText(bOr and "A: AND" or "A: OR")
		window.labelConditionsB:setText(bOr and "B: AND" or "B: OR")
		
        local item = window.triggersList:getSelectedItem()
        if item then
			-- selected trigger
			local trigger = item.itemId
			if bOr then trigger.triggerLogic = "OR" else trigger.triggerLogic = "AND" end
		end
	end

    function window.newRuleBtn:onChange()
		--base.print('window.newRuleBtn:onChange())')
        local goalItem = window.triggersList:getSelectedItem()
        if goalItem then
            local rule = predicates.createRule(rulesDescr[1])
			rule.logicBlock = "A"
            base.table.insert(goalItem.itemId.rules, rule)
            local item = U.addListBoxItem(window.rulesList, 
                        predicates.getRuleAsText(rule, cdata), nil, rule)
            window.rulesList:selectItem(item)
            window.rulesList:onChange(item)
        end
    end
	
	function window.newRuleBtnB:onChange()
        local goalItem = window.triggersList:getSelectedItem()
        if goalItem then
            local rule = predicates.createRule(rulesDescr[1])
			rule.logicBlock = "B"
            base.table.insert(goalItem.itemId.rules, rule)
            local item = U.addListBoxItem(window.rulesList2, 
                        predicates.getRuleAsText(rule, cdata), nil, rule)
            window.rulesList2:selectItem(item)
            window.rulesList2:onChange(item)
        end
	end

    -- if predicate type was changed 
    function window.ruleTypeCombo:onChange(item)
		--base.print('ruleTypeCombo:onChange(item)')
        self.selectedItem = item.itemId
        if window.rulesList:getSelectedItem() then
            local rule = window.rulesList:getSelectedItem().itemId
            rule.predicate = item.itemId
            predicates.setRuleDefaults(rule, item.itemId)
            createRuleArgumentsWidgets(window, rule, window.rulesList, cdata)
            predicates.updateListRow(window.rulesList, predicates.ruleTextFunc(cdata))
        elseif window.rulesList2:getSelectedItem() then
            local rule = window.rulesList2:getSelectedItem().itemId
            rule.predicate = item.itemId
            predicates.setRuleDefaults(rule, item.itemId)
            createRuleArgumentsWidgets(window, rule, window.rulesList2, cdata)
            predicates.updateListRow(window.rulesList2, predicates.ruleTextFunc(cdata))
        end
    end
    
    -- delete rule
    function window.delRuleBtn:onChange()
        local currentGoal = window.triggersList:getSelectedItem()
        local item = nil
		if window.rulesList:getSelectedItem() then
			item = window.rulesList:getSelectedItem()
			if currentGoal and item and (0 < #window.rulesList:getChildren()) then
				local rule = item.itemId
				local goal = currentGoal.itemId
				local idxData = predicates.getIndex(goal.rules, rule)
				local idxBlock = findRuleBlockIndex(goal.rules, rule, "A")
				base.table.remove(goal.rules, idxData)
				window.rulesList:removeWidget(item)
			
				if idxBlock > #window.rulesList:getChildren() then idxBlock = idxBlock - 1 end
				
				item = window.rulesList:getChildren()[idxBlock]
				window.rulesList:selectItem(item)
				window.rulesList:onChange(item)
			end
		else
			item = window.rulesList2:getSelectedItem()
			if currentGoal and item and (0 < #window.rulesList2:getChildren()) then
				local rule = item.itemId
				local goal = currentGoal.itemId
				local idxData = predicates.getIndex(goal.rules, rule)
				local idxBlock = findRuleBlockIndex(goal.rules, rule, "B")
				base.table.remove(goal.rules, idxData)
				window.rulesList2:removeWidget(item)
				
				if idxBlock > #window.rulesList2:getChildren() then	idxBlock = idxBlock - 1	end
				
				item = window.rulesList2:getChildren()[idxBlock]
				window.rulesList2:selectItem(item)
				window.rulesList2:onChange(item)
			end
		end
    end

    predicates.rulesToList(window.triggersList, triggers, cdata)
    predicates.fillPredicatesCombo(window.triggerTypeCombo, triggersDescr, cdata)
    predicates.fillPredicatesCombo(window.goalTypeCombo, actionsDescr, cdata)
    predicates.fillPredicatesCombo(window.ruleTypeCombo, rulesDescr, cdata)

    predicates.rulesToList2(window.rulesList, window.rulesList2, nil, cdata)
    showRulesWidgets(window, false)
end


-- convert goals to serializable description
function saveTriggers(triggers)
  if not triggers then
      return { }
  end
  local result = { }
  U.copyTable(result, triggers)
  for _tmp, goal in base.ipairs(result) do
      goal.predicate = goal.predicate.name
      for _tmp, rule in base.ipairs(goal.rules) do
          rule.predicate = rule.predicate.name
      end
      for _tmp, goal in base.ipairs(goal.actions) do
          goal.predicate = goal.predicate.name
      end
  end
  return result
end


-- convert triggers from serializable desctiption to internal representation
function loadTriggers(triggers)
    if not triggers then
        return { }
    end

    local triggersByName = predicates.getRulesIndex(triggersDescr)
    local actionsByName = predicates.getRulesIndex(actionsDescr)
    local predicatesByName = predicates.getRulesIndex(predicates.rulesDescr)
    local result = { }
    U.copyTable(result, triggers)
    for _tmp, goal in base.ipairs(result) do
        goal.predicate = triggersByName[goal.predicate]
        for _tmp, rule in base.ipairs(goal.rules) do
            rule.predicate = predicatesByName[rule.predicate]
        end
        for _tmp, rule in base.ipairs(goal.actions) do
            rule.predicate = actionsByName[rule.predicate]
        end
    end
    return result
end


-- Generate Lua functions from rules list.  
-- All functions returned in array as strings
function generateTriggerFunc(triggers, startup_) -- Dmut: obsolete, to be removed in A-10
  if not triggers then
      return { }
  end
  local result = { }
  local idx = 1
  for _tmp, trigger in base.ipairs(triggers) do
    if trigger.rules and (0 < #trigger.rules) then

      local save = (startup_ and (trigger.predicate.name == "triggerStart")) or (not startup_ and (trigger.predicate.name ~= "triggerStart"))

      local str = "if "
      local firstA = true
	  local firstB = true
	  local strA = ""
	  local strB = ""

      if save then
        for _tmp, rule in base.ipairs(trigger.rules) do
			if rule.logicBlock == "B" then
				if not firstB then
					if trigger.triggerLogic == "AND" then
						strB = strB .. 'or '
					else
						strB = strB .. 'and '
					end
				else
					firstB = false
				end
				strB = strB .. predicates.actionToString(rule) .. ' '
			else
				-- unmodded default: all in first block
				if not firstA then
					if trigger.triggerLogic == "AND" then
						strA = strA .. 'or '
					else
						-- unmodded default: inner-block is AND
						strA = strA .. 'and '
					end
				else
					firstA = false
				end
				strA = strA .. predicates.actionToString(rule) .. ' '
			end
		end
		
		if strA ~= "" then str = str .. "(" end
		if strB ~= "" then str = str .. "(" end
		if strA ~= "" then str = str .. strA end
		if (strA ~= "") and (strB ~= "") then
			if trigger.triggerLogic == "AND" then
				str = str .. ") and ("
			else
				str = str .. ") or ("
			end
		end
		if strB ~= "" then str = str .. strB end
		if strA ~= "" then str = str .. ")" end
		if strB ~= "" then str = str .. ")" end
		str = str .. " "
		--[[
        for _tmp, rule in base.ipairs(trigger.rules) do
          if not first then
            str = str .. 'and '
          else
            first = false
          end
          str = str .. predicates.actionToString(rule) .. ' '
        end
		]]--
		
        str = str .. 'then '

        if trigger.predicate.name == "triggerFront" then
          str = str .. 'if not mission.trigflag['..base.tostring(idx)..'] then '
        end

        for _tmp, action in base.ipairs(trigger.actions) do
          str = str .. predicates.actionToString(action) .. ';'
        end

        if trigger.predicate.name == "triggerOnce" then
          str = str .. ' mission.trigfunc[' .. base.tostring(idx) .. ']=\'\';'
        end

        if trigger.predicate.name == "triggerFront" then
          str = str .. ' mission.trigflag[' .. base.tostring(idx) .. ']=true; end; else mission.trigflag[' .. base.tostring(idx) .. ']=false;'
        end

        str = str .. 'end;'
        base.table.insert(result, str)
        idx = idx + 1
      end -- if save
    end 
  end
  return result
end

function generateTriggerConditions(triggers) 
	if not triggers then return { } end
  
	local result = { }
	local idx = 1
	for _tmp, trigger in base.ipairs(triggers) do
		if trigger.rules and (0 < #trigger.rules) then
			local str = "return("
			local firstA = true
			local firstB = true
			local strA = ""
			local strB = ""

			for _tmp, rule in base.ipairs(trigger.rules) do
				if rule.logicBlock == "B" then
					if not firstB then
						if trigger.triggerLogic == "AND" then
							strB = strB .. 'or '
						else
							strB = strB .. 'and '
						end
					else
						firstB = false
					end
					strB = strB .. predicates.actionToString(rule) .. ' '
				else
					-- unmodded default: all in first block
					if not firstA then
						if trigger.triggerLogic == "AND" then
							strA = strA .. 'or '
						else
							-- unmodded default: inner-block is AND
							strA = strA .. 'and '
						end
					else
						firstA = false
					end
					strA = strA .. predicates.actionToString(rule) .. ' '
				end
			end
		
			if strA ~= "" then str = str .. "(" end
			if strB ~= "" then str = str .. "(" end
			if strA ~= "" then str = str .. strA end
			if (strA ~= "") and (strB ~= "") then
				if trigger.triggerLogic == "AND" then
					str = str .. ") and ("
				else
					str = str .. ") or ("
				end
			end
			if strB ~= "" then str = str .. strB end
			if strA ~= "" then str = str .. ")" end
			if strB ~= "" then str = str .. ")" end
			str = str .. ')'
			result[idx] = str
			idx = idx + 1
		end
	end
	return result
end

function generateTriggerActions(triggers, startup_) 
  if not triggers then
      return { }
  end
  local result = { }
  local idx = 1
  for _tmp, trigger in base.ipairs(triggers) do
    if trigger.rules and (0 < #trigger.rules) then

	  local str = ""

        if trigger.predicate.name == "triggerFront" then
          str = str .. 'if not mission.trig.flag['..base.tostring(idx)..'] then '
        end

        for _tmp, action in base.ipairs(trigger.actions) do
          str = str .. predicates.actionToString(action) .. ';'
        end

        if trigger.predicate.name == "triggerOnce" then
          str = str .. ' mission.trig.func[' .. base.tostring(idx) .. ']=\'\';'
        end

        if trigger.predicate.name == "triggerFront" then
          str = str .. ' mission.trig.flag[' .. base.tostring(idx) .. ']=true; end; else mission.trig.flag[' .. base.tostring(idx) .. ']=false;'
        end

        result[idx] = str
        idx = idx + 1
    end 
  end
  return result
end

function generateTriggerFunc2(triggers, startup_) -- Dmut: new format, conditions and actions separated
  if not triggers then
      return { }
  end
  local result = { }
  local idx = 1
  for _tmp, trigger in base.ipairs(triggers) do
    if trigger.rules and (0 < #trigger.rules) then

      local save = (startup_ and (trigger.predicate.name == "triggerStart")) or (not startup_ and (trigger.predicate.name ~= "triggerStart"))

      local str = "if mission.trig.conditions["..base.tostring(idx).."]() then mission.trig.actions["..base.tostring(idx).."]() end"

      if save then
        result[idx] = str
      end -- if save

      idx = idx + 1
    end 
  end
  return result
end

-- remove invalid rules and actions from triggers
function fixTriggers(triggers)
  if triggers then
    for _tmp, trigger in base.ipairs(triggers) do
        predicates.removeInvalidRules(trigger.rules)
        predicates.removeInvalidRules(trigger.actions)
    end
  end -- if
end

