local base = _G

module('me_toolbar_form') -- left toolbar form

local Window = base.require('Window')
local Widget = base.require('Widget')
local Button = base.require('Button')
local ToggleButton = base.require('ToggleButton')
local Theme = base.require('Theme')
local Tooltip = base.require('Tooltip')

local U = base.require('me_utilities')
local i18n = base.require('i18n')

i18n.setup(_M)

--       ,
--         base.toolbar_*.
local cdata = {
  file = _('FILE'),
  mis = _('MIS'),
  obj = _('OBJ'),
  map = _('MAP'),
  exit = _('EXIT'),
  tooltips = {
    exit = _('Exit the editor-tooltip', 'Exit the editor'),
    new = _('Create new mission-tooltip', 'Create new mission'),
    open = _('Open file-tooltip', 'Open file'),
    save = _('Save mission file-tooltip', 'Save mission file'),
    coalitions = _('Coalitions-tooltip', 'Coalitions'),
    briefing = _('Mission briefing-tooltip', 'Mission briefing'),
    --	failures = _('Failures-tooltip', 'Failures'),
    weather = _('Weather-tooltip', 'Weather'),
    run = _('Fly mission-tooltip', 'Fly mission'),
    airplane = _('Airplanes-tooltip', 'Airplanes'),
    helicopter = _('Helicopters-tooltip', 'Helicopters'),
    ship = _('Ships-tooltip', 'Ships'),
    vehicle = _('Ground vehicles-tooltip', 'Ground vehicles'),
    goal = _('Mission goal-tooltip', 'Mission goal'),
    zone = _('Trigger zones-tooltip', 'Trigger zones'),
    del = _('Remove group/object-tooltip', 'Remove group/object'),
    map = _('Map options-tooltip', 'Map options'),
    trig_zones_list = _('Trigger zones list-tooltip', 'Trigger zones list'),
    unit_list = _('Units list-tooltip', 'Units list'),
    trigrules = _('Trigger rules-tooltip', 'Trigger rules'),
    static = _('Static object-tooltip', 'Static object'),
    options = _('Mission options-tooltip', 'Mission options'),
    template = _('Templates-tooltip', 'Templates'),
    tape = _('Ruler-tooltip', 'Ruler'),
  },
}
local bw = 48 --  
local bh = 22 --  
local bx = 2  --    
local dy = 22 --     


local toolbar = {
    { name = 'file', title = cdata.file },
    { button = 'new',  texture = { 1, 1 } },
    { button = 'open',  texture = { 2, 1 } },
    { button = 'save',  texture = { 3, 1 } },
    { name = 'mis', title = cdata.mis },
    { button = 'briefing',  texture = { 8, 1 } },
		{ button = 'coalitions',  texture = { 1, 7 } },
    --	{ button = 'failures',  texture = { 9, 1 } },
    { button = 'weather',  texture = { 10, 1 } },
    { button = 'trigrules',  texture = { 4, 5 } },
    { button = 'goal',  texture = { 6, 5 } },
    { button = 'options',  texture = { 5, 7 } },
    { button = 'run',  texture = { 7, 5 },  height = 2, type = 'button' },
    { name = 'obj', title = cdata.obj },
    { button = 'airplane',  texture = { 1, 3 } },
    { button = 'helicopter',  texture = { 2, 3 } },
    { button = 'ship',  texture = { 3, 3 } },
    { button = 'vehicle',  texture = { 4, 3 } },
    { button = 'static',  texture = { 9, 3 } },
    { button = 'zone',  texture = { 5, 5 } },
    { button = 'template',  texture = { 3, 7 } },
    { button = 'trig_zones_list',  texture = { 2, 7 } },
    { button = 'unit_list',  texture = { 4, 7 } },
    { button = 'del',  texture = { 4, 1 }, type = 'button' },
    { name = 'map', title = cdata.map },
    { button = 'map',  texture = { 2, 5 } },
    { button = 'tape',  texture = { 3, 5 } },
    { button = 'exit',  texture = { 8, 5 },  height = 2, type = 'button' },
}


-- setup button properties
function setupButton(window, button, pos, height, info)
    local theme = Theme.newToolbarButtonTheme()
    local x = (info.texture[1] - 1) * bw
    local y = (info.texture[2] - 1) * bh
    theme.upTheme.image.rect = { x, y, bw, height }
    theme.downTheme.image.rect = { x, y + height, bw, height }
    theme.hoverUpTheme.image.rect = theme.upTheme.image.rect
    theme.hoverDownTheme.image.rect = theme.downTheme.image.rect
    theme.undefinedUpTheme.image.rect = theme.downTheme.image.rect
    theme.undefinedDownTheme.image.rect = theme.downTheme.image.rect
    button:setTheme(theme)

    button:setBounds(bx, pos, bw, height)
    window:insertWidget(button)
  
    local tooltip = cdata.tooltips[info.button]
    if tooltip then
        button:setTooltip(Tooltip.new(tooltip));
    end
end


--   
function createButton(window, pos, height, info)
    local button = Button.new()
    setupButton(window, button, pos, height, info)
    return button
end 

-- create toggle button
function createToggleButton(window, pos, height, info)
    local button = ToggleButton.new()
    setupButton(window, button, pos, height, info)
    return button
end 


-- create button group label
function createLabel(window, pos, title)
    local label = Widget.new(title)
    label:setTheme(Theme.newToolbarCaptionTheme())
    label:setBounds(bx - 2, pos, bw + 2, bh - 2)
    window:addChild(label)
	return label;
end


-- claculate button height in pixels
function getButtonHeight(info)
    local height = info.height
    if not height then
        height = 1
    end
    height = height * bh
    return height
end


-- create toolbar buttons from toolbar description
function createToolbar(window, toolbar, toolbarHeight)
    local pos = 0
    local last = toolbar[#toolbar]
    for _k, v in base.pairs(toolbar) do
        if v.title then
            _M['l_'..v.name] = createLabel(window, pos, v.title)
            pos = pos + dy
        else
            local height = getButtonHeight(v)
            if v == last then
                pos = toolbarHeight - 44
            end
            if 'button' == v.type then
                _M['b_'..v.button] = createButton(window, pos, height, v)
            else
                _M['b_'..v.button] = createToggleButton(window, pos, height, v)
            end
            pos = pos + height
        end
    end
end


function create(x, y, w, h)
    window = Window.new(x, y, w, h)
    window:setTheme(Theme.newMELeftToolbarTheme())
    
    createToolbar(window, toolbar, h)
end

