local base = _G

module('me_coalitions')

local Window = base.require('Window')
local Button = base.require('Button')
local BScolor = base.require('BScolor')
local Color = base.require('Color')
local S = base.require('Serializer')
local U = base.require('me_utilities')
local T = base.require('tools')
local ListBox = base.require('ListBox')
-- local Airplane = base.require('me_airplane')
-- local Helicopter = base.require('me_helicopter')
local Aircraft = base.require('me_aircraft')
local Ship = base.require('me_ship')
local Vehicle = base.require('me_vehicle')
local Static = base.require('me_static')
local i18n = base.require('i18n')
local MsgWindow = base.require('MsgWindow')

i18n.setup(_M)

function initModule()

end;
    --  
    cdata = 
    {
        --         MECustom.xml.
        default_vdata_file = base.mainPath..'data/scripts/default_coalitions.lua',
        title = _('COALITIONS'),
        list = _('LIST'),
        selected = _('SELECTED'),
        save = _('SAVE'),
        ok = _('OK'),
        cancel = _('CANCEL'),
        coalitions = {
            red = {
                name = _('RED'),
                color = Color.red,
            },
            blue = {
                name = _('BLUE'),
                color = Color.blue,
            },
        },
    }
    --      .       
    vdata =
    {
        coalitions =
        {
            ['red'] = {
                'Russia', 'Ukraine',
            },
            ['blue'] = {
                'USA', 'Canada',
            },
        },
        neutral =
        {
            'The Netherlands',
            'Israel',
        },
        coalitions_country_names = {'Russia', 'Ukraine', 'USA', 'Canada',},
    }
    
--end;

-- returns true if string is number
function isNumber(str)
    return base.tonumber(str) ~= nil
end

-- parse coalition and returns list of countries
-- coalition is table in new or old format
-- old format is array of identifiers, e.g.  { "Russia", "USA" }
-- new format is arrar of countries IDs and names, e.g.
-- { {id=0; name="Russia"}, {id=1; name="USA"} }
-- name field doesn't used, but present for easy debugging
function parseCoalition(coalition)
    local res = { }
    for _tmp, v in base.pairs(coalition) do
        if isNumber(v) then
            base.table.insert(res, base.me_db.country_by_id[v].Name)
        else
            base.table.insert(res, base.me_db.getCountryByOldID(v).Name)
        end
    end
    return res
end

-- add all countries from countries list to map.  map indexed by WorldID key
function buildCountriesMap(map, countries)
    for _tmp, v in base.pairs(countries) do
        map[v] = v
    end
end

-- convert map to array
function mapToArray(map)
    arr = { }
    for _tmp, v in base.pairs(map) do
        base.table.insert(arr, v)
    end
    return arr
end


-- returns list of countries in coalitions and list of neutral countires
function createCountriesList(red, blue)
    local combined = { }
    buildCountriesMap(combined, red)
    buildCountriesMap(combined, blue)

    local countries = { }
    for _tmp, v in base.pairs(base.db.Countries) do
        if not combined[v.Name] then
            base.table.insert(countries, v.Name)
        end
    end

    return mapToArray(combined), countries
end

-- parse coalitions IDs, returns coalitions names
function parseCoalitions(coalitions)
    local res = { }
    res.red = parseCoalition(coalitions.red)
    res.blue = parseCoalition(coalitions.blue)
    return res
end

-- create default coalitions
function loadDefaultCoalitions()
    local res = { }
    local coalitions = T.safeDoFile(cdata.default_vdata_file).coalitions
    res.coalitions = parseCoalitions(coalitions)
    res.coalitions_country_names, res.neutral = 
        createCountriesList(res.coalitions.red, res.coalitions.blue)
    vdata.coalitions, vdata.coalitions_country_names, vdata.neutral = 
        res.coalitions, res.coalitions_country_names, res.neutral;
    return res
end


-- build list of country IDs
function countriesNamesToIds(names)
    local res = { }
    for _tmp, v in base.pairs(names) do
        base.table.insert(res, base.me_db.country_by_name[v].WorldID)
    end
    return res
end


-- convert coalitions names to coalitions IDs for saving
function coalitionsToIds(coalitions)
    local res = { }
    res.red = countriesNamesToIds(vdata.coalitions.red)
    res.blue = countriesNamesToIds(vdata.coalitions.blue)
    return res
end

-- save current coalitions as default
function saveDefaultCoalitions()
    local coalitions = coalitionsToIds(vdata.coalitions)
    local fileName = base.mainPath..'data/scripts/default_coalitions.lua'
    local fout = base.io.output(fileName, "w")
    local sr = S.new(fout) 
    sr:serialize_simple('coalitions', coalitions)
    fout:close()
end

local list_w = 142 --   


function cloneItem(item)
  local newItem = ListBox.newItem(item:getText())
  local theme = item:getTheme()
  newItem:setTheme(theme)  
  return newItem
end

function moveItem(item, panelFrom, panelTo)
  panelTo:insertWidget(cloneItem(item))
  panelFrom:removeWidget(item)
end


-- move country from one coalition to another
function removeFromCoalition(fromPanel, fromCoalition, toPanel, toCoalition)
    
	local selectedItem = fromPanel:getSelectedItem()
    if not selectedItem then
        return
    end
    local country = selectedItem:getText()
    local items = fromPanel:getWidgets()
    local itemIndex = nil;
    for i = 1, #items do
        local item = items[i]
        if item == selectedItem then
            U.removeFromTable(fromCoalition, country)
            base.table.insert(toCoalition, country)
            moveItem(item, fromPanel, toPanel)
            itemIndex = i;
            break;
        end
    end
    local widgets = fromPanel:getWidgets();    
    local index = itemIndex or #widgets;
    --base.print('index, itemIndex, #widgets',index, itemIndex, #widgets);
    if index > #widgets then
        index = #widgets;
    end;
    if index > 0 then
        fromPanel:selectItem(widgets[index]);    
    end;

	if true == base.toolbar.b_coalitions:getState() then -- late edit	
		update_tables();
		updateCountries();
		update_panels();
	end
end

-- =====================================================================================================================
function moveMissionCountry(strCountry, strFrom, strTo)
	local M = base.module_mission
	local coalTo = nil
	local coalFrom = nil
	local country = nil

	if strFrom == 'neutral' then
		-- create new country (from neutral)
		coalTo = M.mission.coalition[strTo]
		country = {
			  id = base.tonumber(base.me_db.country_by_name[strCountry].WorldID),
			  boss = coalTo,
			  name = strCountry,
			  plane = {group = {},},
			  helicopter = {group = {},},
			  ship = {group = {},},
			  vehicle = {group = {},},
			  static = {group = {},},
		}
		base.table.insert(coalTo.country, country)
		M.missionCountry[strCountry] = country
		M.countryCoalition[strCountry] = coalTo
	else
		-- here we move from a real coalition to anywhere
		coalFrom = M.mission.coalition[strFrom]
		coalTo = M.mission.coalition[strTo]
		country = M.missionCountry[strCountry]
		
		if not coalTo then
			-- move to neutral
			-- ask if any groups exist
			if (#country.plane.group > 0) or (#country.helicopter.group > 0) or (#country.ship.group > 0) or (#country.vehicle.group > 0) or (#country.static.group > 0) then
				local bContinue = false
				local msgWindow = MsgWindow.new('Are you sure you want to move '..strCountry..' to Neutral? \nAll unit groups of this country will be lost!', 'Remove coalition country', 'question', _('Yes'), _('No'));
				function msgWindow:onChange(str)
					if str == _('Yes') then 
						bContinue = true
					end;
					MsgWindow.onChange(self)
				end;
				msgWindow:setVisible(true);                

				-- aborted?
				if false == bContinue then
					return false
				end
			end
			
			-- through all groups: M.remove_group(g)
			removeGroups(country.plane.group)
            removeGroups(country.helicopter.group)
            removeGroups(country.ship.group)
            removeGroups(country.vehicle.group)
            removeGroups(country.static.group)
			  
			-- remove country
			local idxCountry = 1
			for a=1, #coalFrom.country do
				if coalFrom.country[a] == country then
					base.table.remove(coalFrom.country, a)
					break
				end
			end

			M.missionCountry[strCountry] = nil
			M.countryCoalition[strCountry] = nil
			
		else -- end: move to neutral
			-- move to coal
			-- remove country
			local idxCountry = 1
			for a=1, #coalFrom.country do
				if coalFrom.country[a] == country then
					base.table.remove(coalFrom.country, a)
					break
				end
			end

			-- insert to target coalition
			base.table.insert(coalTo.country, country)
			country.boss = coalTo
			M.countryCoalition[strCountry] = coalTo
		end
	end -- from country to any

	
	base.MapWindow.mapView:updateUserList(true)
	return true
 
	-- erzeugt map objekte
--	M.createCoalitionObjects(coalition)
end

-- blindspot:
function updateMapVisuals(strCountry)
	local country = base.module_mission.missionCountry[strCountry]
	for _k, grouplist in base.pairs({'plane', 'helicopter', 'ship', 'vehicle', 'static'}) do
		for a=1, #country[grouplist].group do
			local g = country[grouplist].group[a]
			base.module_mission.remove_group_map_objects(g)
			g.color = country.boss.color
			base.module_mission.create_group_map_objects(g)
		end
	end
end

-- blindspot:
function removeGroups(groups)
	if groups then
		while #groups > 0 do
			local g = groups[1]
			base.module_mission.remove_group_map_objects(g)
			base.module_mission.remove_group(g)
		end
	end
end

-- =====================================================================================================================

-- sort all countries list
function sortCoaltions()
    base.table.sort(vdata.coalitions.red)
    base.table.sort(vdata.coalitions.blue)
    base.table.sort(vdata.neutral)
    base.table.sort(vdata.coalitions_country_names)
end


function create(x, y, w, h)
    --    
    --         (       )
    vdata = loadDefaultCoalitions()
    sortCoaltions()
    
    window = Window.new(x, y, w, h)
    window:setTitleHeight(0)
    --window:getTheme():setColor(BScolor.dialog_prim)
    --      
    window:setTop(true)
    
    local left_panel_h = h - (U.widget_h+U.offset_h)*3-U.offset_h-U.button_h-U.offset_h
    local right_panel_h = (left_panel_h-30)/2

    -- 
    local t_title = U.create_header(cdata.title)
    t_title:setBounds(0, 0, w-U.widget_h, U.widget_h)
    window:addChild(t_title)
    
    --  
    b_close = U.create_close_button()
    b_close:setBounds(w-U.widget_h, 0, U.widget_h, U.widget_h)
    window:addChild(b_close)
    --    callback-     , 
    --         .
    function b_close:onChange()
        b_cancel:onChange()
    end

    local left_header = U.create_widget(window, cdata.list, U.offset_w, U.widget_h+U.offset_h, list_w, U.widget_h)     
    left_header:getTheme().text.align = {'center','center'}
    left_header:setTheme(left_header:getTheme())

    local right_header = U.create_widget(window, cdata.selected, U.offset_w+list_w+70, U.widget_h+U.offset_h, list_w, U.widget_h)
    right_header:getTheme().text.align = {'center','center'}
    right_header:setTheme(right_header:getTheme())
    
    left_panel = U.create_country_list(vdata.neutral)
    left_panel:setBounds(U.offset_w, U.widget_h+U.offset_h+U.widget_h+U.offset_h, list_w, left_panel_h)
    window:addChild(left_panel)

    red_panel = U.create_country_list(vdata.coalitions.red)
    red_panel:setBounds(U.offset_w+list_w+70, U.widget_h+U.offset_h+U.widget_h+U.offset_h, list_w, right_panel_h)
    window:addChild(red_panel)

    blue_panel = U.create_country_list(vdata.coalitions.blue)
    blue_panel:setBounds(U.offset_w+list_w+70, U.widget_h+U.offset_h+U.widget_h+U.offset_h+right_panel_h+30, list_w, right_panel_h)
    window:addChild(blue_panel)
    
    local red_text = U.create_widget(window, cdata.coalitions.red.name, U.offset_w+list_w+2, U.widget_h+U.offset_h+U.widget_h+U.offset_h+right_panel_h/3, 66, U.widget_h)
    red_text:getTheme().text.align = {'center','top'}
    red_text:getTheme().text.color = cdata.coalitions.red.color
    red_text:setTheme(red_text:getTheme())
        
    local blue_text = U.create_widget(window, cdata.coalitions.blue.name, U.offset_w+list_w+2, h-U.offset_h-U.button_h-U.offset_h-right_panel_h+right_panel_h/3, 66, U.widget_h)
    blue_text:getTheme().text.align = {'center','top'}
    blue_text:getTheme().text.color = cdata.coalitions.blue.color
    blue_text:setTheme(blue_text:getTheme())
    
    -- Buttons -------------------------------------------------------------------
    local buttons_y = h-(U.button_h+U.offset_h)
    b_save = Button.new(cdata.save)
    b_save:setBounds(U.offset_w, buttons_y, U.button_w, U.button_h)
    window:addChild(b_save)
    function b_save:onChange()
        saveDefaultCoalitions()
    end
    --  ,    SAVE,      LOAD.    ,   
    --    (   ),       .
    
    b_ok = Button.new(cdata.ok)
    b_ok:setBounds(U.offset_w+U.button_w+U.dist_w, buttons_y, U.button_w, U.button_h)
    window:addChild(b_ok)
    function b_ok:onChange()
	
		--[[ Blind:
		if true == base.toolbar.b_coalitions:getState() then
			base.MapWindow.unselectAll()
			-- base.module_mission.update_group_map_objects(....)
			
			update_tables();
			updateCountries();
			update_panels();
			base.toolbar.untoggle_all_except()
		else ]]
			base.module_mission.mapObjects = {}
			if base.MapWindow.created then
				base.MapWindow.selectedGroup = nil;
				base.MapWindow.mapView:clearUserObjects()
				base.MapWindow.mapView:updateUserList(true)
			end;                
			base.toolbar.b_new:setState(false)
			update_tables();
			base.module_mission.create_new_mission(true);
			updateCountries();
			update_panels();
			base.statusbar.t_file:setText('New Mission File')
			base.module_mission.mission.path = nil
			base.toolbar.setButtonsEnabled(nil, true);
			base.menubar.form.window:setEnabled(true);
--		end -- else
		
		show(false)
    end 
    
    b_cancel = Button.new(cdata.cancel)
    b_cancel:setBounds(U.offset_w+(U.button_w+U.dist_w)*2, buttons_y, U.button_w, U.button_h)
    window:addChild(b_cancel)
    function b_cancel:onChange()
        --   ,     
        restore_vdata()
        show(false)
        base.toolbar.setButtonsEnabled(nil, true);
        base.toolbar.untoggle_all_except()
        base.menubar.form.window:setEnabled(true);
    end
   
    b_red_left = U.create_arrow_button('left')
    b_red_left:setBounds(U.offset_w+list_w+14, U.widget_h+U.offset_h+U.widget_h+U.offset_h+right_panel_h/3 + 20, 18, 18)
    window:addChild(b_red_left)
    function b_red_left:onChange()
		-- blind
		if true == base.toolbar.b_coalitions:getState() then -- late edit
			local selectedItem = red_panel:getSelectedItem()
			if selectedItem then
				local country = selectedItem:getText()
				if false == moveMissionCountry(country, 'red', 'neutral') then
					return -- user aborted
				end
			end
		end

        removeFromCoalition(red_panel, vdata.coalitions.red, left_panel, vdata.neutral)
    end 

    b_red_right = U.create_arrow_button('right')
    b_red_right:setBounds(U.offset_w+list_w+60-4-18, U.widget_h+U.offset_h+U.widget_h+U.offset_h+right_panel_h/3 + 20, 18, 18)
    window:addChild(b_red_right)
    function b_red_right:onChange()
		-- blind
		if true == base.toolbar.b_coalitions:getState() then -- late edit
			local selectedItem = left_panel:getSelectedItem()
			if selectedItem then
				local country = selectedItem:getText()
				if false == moveMissionCountry(country, 'neutral', 'red') then
					return -- user aborted (unlikely in this case, but as an example..)
				end
			end
		end
	
        removeFromCoalition(left_panel, vdata.neutral, red_panel, vdata.coalitions.red)
    end 

    b_blue_left = U.create_arrow_button('left')
    b_blue_left:setBounds(U.offset_w+list_w+14, h-U.offset_h-U.button_h-U.offset_h-right_panel_h+right_panel_h/3+20, 18, 18)
    window:addChild(b_blue_left)
    function b_blue_left:onChange()
		-- blind
		if true == base.toolbar.b_coalitions:getState() then -- late edit
			local selectedItem = blue_panel:getSelectedItem()
			if selectedItem then
				local country = selectedItem:getText()
				if false == moveMissionCountry(country, 'blue', 'neutral') then
					return -- user aborted
				end
			end
		end
        removeFromCoalition(blue_panel, vdata.coalitions.blue, left_panel, vdata.neutral)
    end 

    b_blue_right = U.create_arrow_button('right')
    b_blue_right:setBounds(U.offset_w+list_w+60-4-18, h-U.offset_h-U.button_h-U.offset_h-right_panel_h+right_panel_h/3+20, 18, 18)
    window:addChild(b_blue_right)
    function b_blue_right:onChange()
		-- blind
		if true == base.toolbar.b_coalitions:getState() then -- late edit
			local selectedItem = left_panel:getSelectedItem()
			if selectedItem then
				local country = selectedItem:getText()
				if false == moveMissionCountry(country, 'neutral', 'blue') then
					return -- user aborted (unlikely in this case, but as an example..)
				end
			end
		end
        removeFromCoalition(left_panel, vdata.neutral, blue_panel, vdata.coalitions.blue)
    end 

    b_up = U.create_arrow_button('up')
    b_up:setBounds(U.offset_w+list_w+60+list_w/3+5, U.widget_h+U.offset_h+U.widget_h+U.offset_h+right_panel_h+U.offset_h, 18, 18)
    window:addChild(b_up)
    function b_up:onChange()
		-- blind
		local country = nil
		if true == base.toolbar.b_coalitions:getState() then -- late edit
			local selectedItem = blue_panel:getSelectedItem()
			if selectedItem then
				country = selectedItem:getText()
				if false == moveMissionCountry(country, 'blue', 'red') then
					return -- user aborted (unlikely in this case, but as an example..)
				end
			end
		end
        removeFromCoalition(blue_panel, vdata.coalitions.blue, red_panel, vdata.coalitions.red)
		if country then
			updateMapVisuals(country)
		end
    end 

    b_down = U.create_arrow_button('down')
    b_down:setBounds(U.offset_w+list_w+60+list_w/3+5+18+5, U.widget_h+U.offset_h+U.widget_h+U.offset_h+right_panel_h+U.offset_h, 18, 18)
    window:addChild(b_down)
    function b_down:onChange()
		-- blind
		local country = nil
		if true == base.toolbar.b_coalitions:getState() then -- late edit
			local selectedItem = red_panel:getSelectedItem()
			if selectedItem then
				country = selectedItem:getText()
				if false == moveMissionCountry(country, 'red', 'blue') then
					return -- user aborted (unlikely in this case, but as an example..)
				end
			end
		end
        removeFromCoalition(red_panel, vdata.coalitions.red, blue_panel, vdata.coalitions.blue)
		if country then
			updateMapVisuals(country)
		end
    end
    
    save_vdata()
    bNeedUpdate = false
end

function update_tables()
    vdata.coalitions_country_names, vdata.neutral = createCountriesList(vdata.coalitions.red, vdata.coalitions.blue)
    sortCoaltions()
end

--        vdata.coalitions.red  vdata.coalitions.blue
function update_panels()
    update_tables()
    U.update_country_list(left_panel, vdata.neutral)
    U.update_country_list(red_panel, vdata.coalitions.red)
    U.update_country_list(blue_panel, vdata.coalitions.blue)
    bNeedUpdate = false 
end

--      
function load_default()
    local saved = vdata.saved_coalitions
    vdata =  loadDefaultCoalitions()
    vdata.saved_coalitions = saved
    update_panels()
end

function save_vdata()
    vdata.saved_coalitions = {red = {}, blue = {}}
    for i,v in base.pairs(vdata.coalitions.red) do
        base.table.insert(vdata.saved_coalitions.red, v)
    end
    for i,v in base.pairs(vdata.coalitions.blue) do
        base.table.insert(vdata.saved_coalitions.blue, v)
    end
    vdata.saved_neutral = {}
    for i,v in base.pairs(vdata.neutral) do
        base.table.insert(vdata.saved_neutral, v)
    end
end

function restore_vdata()
    vdata.coalitions = {red = {}, blue = {}}
    for i,v in base.pairs(vdata.saved_coalitions.red) do
        base.table.insert(vdata.coalitions.red, v)
    end
    for i,v in base.pairs(vdata.saved_coalitions.blue) do
        base.table.insert(vdata.coalitions.blue, v)
    end
    update_tables()
    update_panels()
end

function show(b)
    if b then
		
		-- blind: buttons not make sense in late edit
		if true == base.toolbar.b_coalitions:getState() then -- late edit
			b_ok:setVisible(false)
			b_cancel:setVisible(false)
			b_save:setVisible(false)

			-- unselect
			base.MapWindow.unselectAll()
			-- base.panel_units_list.btnCloseOnChange()
			-- Vehicle:close()
		
		else
			b_ok:setVisible(true)
			b_cancel:setVisible(true)
			b_save:setVisible(true)

			if bNeedUpdate then
				--    vdata.coalitions  .
				--      .
				update_panels()
				--      
				save_vdata()
			end
		end
	else
		-- hide
--[[		if true == base.toolbar.b_coalitions:getState() then -- late edit
			update_tables(); -- bereits in update_panels, aber naja... da hat man sich ver-designt
			updateCountries();
			update_panels();
		
		end
	]]		
		base.panel_units_list.updateCountriesCombo()
	end	
	
    
	window:setVisible(b)
end


-- update countries list in all dialogs
function updateCountries()
    --Airplane.updateCountries(vdata.coalitions_country_names)
    Aircraft.updateCountries(vdata.coalitions_country_names)
    Ship.updateCountries(vdata.coalitions_country_names)
    Vehicle.updateCountries(vdata.coalitions_country_names)
    Static.updateCountries(vdata.coalitions_country_names)
end

initModule()