-- Guns and ammo for Sandown Mine Hunter (Source code by Currenthill)

-- ======================================================================================

-- Shells and ammunition

declare_weapon({
	category 				= CAT_SHELLS,
	name 					= "SD_30_APDS_T", 
	user_name 				= _("30 mm APDS-T"),
	model_name    			= "tracer_bullet_yellow",
	v0    					= 1175.0,
	Dv0   					= 0.0060,
	Da0     				= 0.0006,
	Da1     				= 0.0,
	mass      				= 0.300,
	explosive     			= 0.0,
	subcalibre     			= true,	
	AP_cap_caliber 			= 25.0,	
	life_time     			= 33,
	caliber    				= 30.0,
	s         				= 0.0,
	j         				= 0.0,
	l         				= 0.0,
	charTime    			= 0,
	cx        				= {-0.2, 0.72, 0.85, 0.08, 2.40},
	k1        				= 5.7e-09,
	tracer_off    			= 6,
	scale_tracer  			= 1,
	cartridge 				= 0,	
});

declare_weapon({
	category 				= CAT_SHELLS,
	name 					= "SD_30_HEI_T", 
	user_name 				= _("30 mm HEI-T"),
	model_name    			= "tracer_bullet_yellow",
	v0    					= 1080.0,
	Dv0   					= 0.006,
	Da0     				= 0.0006,
	Da1     				= 0.0,
	mass      				= 0.357,
	explosive     			= 0.357,
	life_time     			= 33,
	caliber    				= 30.0,
	s         				= 0.0,
	j         				= 0.0,
	l         				= 0.0,
	charTime    			= 0,
	cx        				= {-0.2, 0.72, 0.85, 0.08, 2.40},
	k1        				= 5.7e-09,
	tracer_off    			= 6,
	scale_tracer  			= 1,
	cartridge 				= 0,
	
	aiming_table			=
	{
		precalculateAirDefenceAimingTable = true,
		precalculateAimingTable = true,
		[1] = { init_vel = 1808.0 }
	}	
});


-- DS-30B Mk I 30 mm autocannon

GT_t.LN_t.DS30J_MK1 = {name = "DS-30J Mk1", display_name = _("DS-30J Mk1")}
GT_t.LN_t.DS30J_MK1.type = 3;
GT_t.LN_t.DS30J_MK1.distanceMin = 10
GT_t.LN_t.DS30J_MK1.distanceMax = 4000
GT_t.LN_t.DS30J_MK1.max_trg_alt = 3000
GT_t.LN_t.DS30J_MK1.reactionTime = 1.2;
GT_t.LN_t.DS30J_MK1.reflection_limit = 0.02;
GT_t.LN_t.DS30J_MK1.sensor = {}
set_recursive_metatable(GT_t.LN_t.DS30J_MK1.sensor, GT_t.WSN_t[7])
GT_t.LN_t.DS30J_MK1.PL = {}
GT_t.LN_t.DS30J_MK1.PL[1] = {}
GT_t.LN_t.DS30J_MK1.PL[1].switch_on_delay = 60;
GT_t.LN_t.DS30J_MK1.PL[1].shell_name = {"SD_30_APDS_T","SD_30_HEI_T"};
GT_t.LN_t.DS30J_MK1.PL[1].ammo_capacity = 160;
GT_t.LN_t.DS30J_MK1.PL[1].portionAmmoCapacity = 160;
GT_t.LN_t.DS30J_MK1.PL[1].reload_time = 45; --60
GT_t.LN_t.DS30J_MK1.PL[1].shot_delay = 60/650;
for i=2,4 do
    GT_t.LN_t.DS30J_MK1.PL[i] = {};
    set_recursive_metatable(GT_t.LN_t.DS30J_MK1.PL[i], GT_t.LN_t.DS30J_MK1.PL[1]);
end;
GT_t.LN_t.DS30J_MK1.BR = { {pos = {-4.65, 1.4, -1.35} } }

