
SU27SM3_AI =  {
      
		Name 			= 'SU27SM3_AI',
		DisplayName		= _('Su-27SM3 AI'),
        Picture 		= "Su-27.png",
        Rate 			= "50",
        Shape			= "SU27SM3_AI",	
        WorldID			=  3, 
        
	shape_table_data 	= 
	{
		{
			file  	 	= 'SU27SM3_AI';--AG
			life  	 	= 20; -- lifebar
			vis   	 	= 3; -- visibility gain.
			desrt    	= 'f-4e-oblomok'; -- Name of destroyed object file name
			fire  	 	= { 300, 2}; -- Fire on the ground after destoyed: 300sec 2m
			username	= 'SU27SM3_AI';--AG
			index       =  3;
			classname   = "lLandPlane";
			positioning = "BYNORMAL";
		},
		{
			name  		= "f-4e-oblomok";
			file  		= "f-4e-oblomok";
			fire  		= { 240, 2};
		},
	},
	
	LandRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of LandRWCategories
        TakeOffRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of TakeOffRWCategories
	
	mapclasskey 		= "P0091000024",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Fighter, 3, "Fighters", "Refuelable", "Datalink", "Link16"},
	Categories= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},
	
		M_empty						=	16400,	-- kg  with pilot and nose load, F15
		M_nominal					=	25800,	-- kg (Empty Plus Full Internal Fuel)
		M_max						=	33500,	-- kg (Maximum Take Off Weight)
		M_fuel_max					=	9400,	-- kg (Internal Fuel Only)
		H_max						=	18720,	-- m  (Maximum Operational Ceiling)
		average_fuel_consumption	=	0.26,
		CAS_min						=	58,		-- Minimum CAS speed (m/s) (for AI)
		V_opt						=	200,	-- Cruise speed (m/s) (for AI)
		V_take_off					=	98,		-- Take off speed in m/s (for AI)
		V_land						=	78,		-- Land speed in m/s (for AI)
		has_afteburner				=	true,
		has_speedbrake				=	true,
		radar_can_see_ground		=	true,

		nose_gear_pos 							 = {5.221, -2.185, 0},		-- nosegear coord
		nose_gear_wheel_diameter				 =  0.754,		-- in m
		nose_gear_amortizer_direct_stroke        =  0.104,  	    -- down from nose_gear_pos !!!
		nose_gear_amortizer_reversal_stroke      = -0.193,		-- up
		nose_gear_amortizer_normal_weight_stroke =  -0.00311633945,		-- down from nose_gear_pos

		main_gear_pos 							 = {-0.537, -2.237, 2.168},	-- main gear coords
		main_gear_wheel_diameter				 =  0.972,				-- in m
		main_gear_amortizer_direct_stroke        =  0.318,		-- down from main_gear_pos !!!
		main_gear_amortizer_reversal_stroke      = -0.114, 		-- up
		main_gear_amortizer_normal_weight_stroke =  0.0986220837,				-- down from main_gear_pos

		AOA_take_off				=	0.14,	-- AoA in take off (for AI)
		stores_number				=	10,
		bank_angle_max				=	60,		-- Max bank angle (for AI)
		Ny_min						=	-3,		-- Min G (for AI)
		Ny_max						=	8,		-- Max G (for AI)
		V_max_sea_level				=	403,	-- Max speed at sea level in m/s (for AI)
		V_max_h						=	706.11,	-- Max speed at max altitude in m/s (for AI)
		wing_area					=	62.5,	-- wing area in m2
		thrust_sum_max				=	15250,	-- thrust in kgf (64.3 kN)
		thrust_sum_ab				=	26000,	-- thrust in kgf (95.1 kN)
		Vy_max						=	325,	-- Max climb speed in m/s (for AI)
		flaps_maneuver				=	1,
		Mach_max					=	2.3,	-- Max speed in Mach (for AI)
		range						=	3740,	-- Max range in km (for AI)
		RCS							=	6,		-- Radar Cross Section m2
		Ny_max_e					=	8,		-- Max G (for AI)
		detection_range_max			=	250,
		IR_emission_coeff			=	1,	-- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
		IR_emission_coeff_ab		=	4,		-- With afterburner
		tand_gear_max				=	3.73,--XX  1.732 FA18 3.73, 
		tanker_type					=	0,-- F14=2/S33=4/M29=0/S27=0/F15=1/F16=1/To=0/F18=2/A10A=1/M29K=4/M2000=2/F4=0/F5=0/
		wing_span					=	14.7,  --XX
		wing_type 					= 	0,-- 0=FIXED_WING/ 1=VARIABLE_GEOMETRY/ 2=FOLDED_WING/ 3=ARIABLE_GEOMETRY_FOLDED
		length						=	21.93,
		height						=	5.93,
		crew_size					=	1,    --XX
		engines_count				=	2,    --XX
		wing_tip_pos 				= 	{ -4.5, 0.4, 7.5},
		defFuelRatio = 0.65,
		
		--EPLRS 						= true,--?
		TACAN_AA					= true,--?
		--launch_bar_connected_arg_value	= 0.815,--0.885,--0.745
		
		mechanimations = {
		Door0 = { {
				Flags = { "Reversible" },
				Sequence = { {
						C = { { "Arg", 38, "to", 0.11, "at", 0.074, "sign", 2 } }
					}, {
						C = { { "Arg", 38, "to", 0.9, "at", 0.14 } }
					} },
				Transition = { "Close", "Open" }
			}, {
				Flags = { "Reversible", "StepsBackwards" },
				Sequence = { {
						C = { { "Arg", 38, "to", 0, "at", 0.18 } }
					}, {
						C = { { "Arg", 38, "to", 0.89, "at", 0.074, "sign", -2 } }
					} },
				Transition = { "Open", "Close" }
			}, {
				Sequence = { {
						C = { { "JettisonCanopy", 0 } }
					} },
				Transition = { "Any", "Bailout" }
			} },
		HeadLights = { {
				Sequence = { {
						C = { { "Arg", 208, "set", 0 } }
					} },
				Transition = { "Any", "Retract" }
			}, {
				Sequence = { {
						C = { { "Arg", 208, "set", 0 } }
					} },
				Transition = { "Any", "Off" }
			}, {
				Sequence = { {
						C = { { "Arg", 208, "set", 0.5 } }
					} },
				Transition = { "Any", "Taxi" }
			}, {
				Sequence = { {
						C = { { "Arg", 208, "set", 1 } }
					} },
				Transition = { "Any", "High" }
			} }
	}, -- end of mechanimations
		
		engines_nozzles = 
		{
			[1] =
			{
				pos 		=  {-6.889, -0.257, -1.193}, -- nozzle coords
				elevation   =  0, -- AFB cone elevation
				diameter	 = 1.13, -- AFB cone diameter
				exhaust_length_ab   = 9, -- lenght in m
				exhaust_length_ab_K = 0.6, -- AB animation
				smokiness_level = 0.1,
			}, -- end of [1]
			[2] =
			{
				pos 		=  {-6.889, -0.257, 1.193}, -- nozzle coords
				elevation   =  0, -- AFB cone elevation
				diameter	 = 1.13, -- AFB cone diameter
				exhaust_length_ab   = 9, -- lenght in m
				exhaust_length_ab_K = 0.6, -- AB animation
				smokiness_level = 0.1,
			}, -- end of [2]

		}, -- end of engines_nozzles
		crew_members = 
		{
			[1] = 
			{
			ejection_seat_name	= 9,
			drop_canopy_name	= 35,
			pos					= {7.916, 0.986, 0},
			canopy_pos			= {7.916, 0.986, 0},
			g_suit 			    =  5
			}, -- end of [1]
		}, -- end of crew_members
		brakeshute_name	=	4,--su-27=4/mig-29=3/su-33=0/F-15=0/tornado=0/F-117=2
		is_tanker	=	false,
		air_refuel_receptacle_pos 	= {8.916, 0.986, 0}, -- refuel coords
		fires_pos = 
		{
			[1] = 	{-3.484, -0.004, -0.149}, -- After maingear, fuselage bottom
			[2] = 	{-2.518,  0.055,  0.416}, -- Wing inner Left
			[3] = 	{-2.518,  0.055, -0.416}, -- Wing inner Right
			[4] = 	{-6.789, -0.257, -1.193}, -- Engine damage big
			[5] = 	{-6.789, -0.257,  1.193}, -- Engine damage small
			[6] = 	{-2.346, -0.248,  0.300}, -- Air intake bottom L
			[7] = 	{ 2.346, -0.248, -0.300}, -- Air intake bottom R
		}, -- end of fires_pos
		
		effects_presets = {
			{effect = "OVERWING_VAPOR", preset = "SU27"},
		},
		
		chaff_flare_dispenser = 
		{
			[1] = 
			{
				dir = 	{0,	-1,	-1},
				pos = 	{-5.776, 1.4, -0.422},
			}, -- end of [1]
			[2] = 
			{
				dir = 	{0,	-1,	-1},
     				pos = 	{-5.776, 1.4, 0.422},
			}, -- end of [2]
		}, -- end of chaff_flare_dispenser

        -- Countermeasures
passivCounterm 		= {
CMDS_Edit 			= true,
SingleChargeTotal 	= 192,
chaff 				= {default = 96, increment = 12, chargeSz = 1},
flare 				= {default = 96, increment = 12, chargeSz = 1}
 },
	
	
        CanopyGeometry 	= {
            azimuth 	= {-145.0, 145.0},-- pilot view horizontal (AI)
            elevation 	= {-50.0, 90.0}-- pilot view vertical (AI)
        },

Sensors = {
RADAR 			= "N-011M",
RWR 			= "Abstract RWR",
OPTIC			= "Su-34 FLIR"
},
Countermeasures = {
--ECM 			= "AN/ALQ-165"--F15
},
laserEquipment = {
		laserDesignator = true,
		laserRangefinder = true
	},
	Failures = {
			{ id = 'asc', 		label = _('ASC'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'autopilot', label = _('AUTOPILOT'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hydro',  	label = _('HYDRO'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'l_engine',  label = _('L-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'r_engine',  label = _('R-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'radar',  	label = _('RADAR'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		  --{ id = 'eos',  		label = _('EOS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		  --{ id = 'helmet',  	label = _('HELMET'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mlws',  	label = _('MLWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'rws',  		label = _('RWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'ecm',   	label = _('ECM'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hud',  		label = _('HUD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mfd',  		label = _('MFD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },		
	},
	HumanRadio = {
		frequency 		= 127.5,  -- Radio Freq
		editable 		= true,
		minFrequency	= 100.000,
		maxFrequency 	= 156.000,
		modulation 		= MODULATION_AM
	},

Guns =  {
        gun_mount("DEFA_554", { count = 150 },{muzzle_pos_connector = "Gun_point", muzzle_pos = {6.44, 0.34, 1}})
        },		 

pylons_enumeration = {1, 10, 2, 9, 3, 8, 4, 7, 6, 5},

	Pylons =     {

        pylon(1, 0, -1.943, 0.173, -7.28, {use_full_connector_position = true, arg = 308, arg_value = 0},
            {
				{CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}"}, -- R73
				{CLSID = "{44EE8698-89F9-48EE-AF36-5FD31896A82F}"}, -- ECM-L				
            }
        ),

       pylon(2, 0, -2.535, -0.165, -6.168, {use_full_connector_position = true, arg = 309, arg_value = 0},
            {
 				{CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}"}, -- R73
				{CLSID = "{su27sm-r771}"}, -- R771
				{CLSID = "{FAB_250_M62}"}, -- FAB250
				{CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}"}, -- B8M1
            }
        ),

        pylon(3, 0,  -1.137,  -0.321, -4.524, {use_full_connector_position = true, arg = 310, arg_value = 0},
            {
				{CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}"}, -- R73
				{CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}"}, -- R27R
				{CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}"}, -- R27T
				{CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}"}, -- R27ER
				{CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}"}, -- R27ET
				{CLSID = "{su27sm-r771}"}, -- R771
				{CLSID = "{FAB_250_M62}"}, -- FAB250
				{CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}"}, -- FAB500
				{CLSID = "{BA565F89-2373-4A84-9502-A0E017D3A44A}"}, -- KAB500L
				{CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}"}, -- KAB500Kr
				{CLSID = "{X-29L}"}, -- X29L
				{CLSID = "{X-29T}"}, -- X29T
				{CLSID = "{X-31P}"}, -- X31P
				{CLSID = "{X-31A}"}, -- X31A
				{CLSID = "{S_25_O}"}, -- S25O
				{CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}"}, -- S25OFM
				{CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}"}, -- B13L
				{CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}"}, -- B8M1
            }
        ),

        pylon(4, 0, -0.075, -1.218, -1.192, {use_full_connector_position = true, arg = 311, arg_value = 0},
            {
				--{CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}"}, -- R73
				{CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}"}, -- R27R
				--{CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}"}, -- R27T
				{CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}"}, -- R27ER
				--{CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}"}, -- R27ET
				{CLSID = "{su27sm-r771}"}, -- R771
				{CLSID = "{FAB_250_M62}"}, -- FAB250
				{CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}"}, -- FAB500
				{CLSID = "{BA565F89-2373-4A84-9502-A0E017D3A44A}"}, -- KAB500L
				{CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}"}, -- KAB500Kr
				{CLSID = "{X-29L}"}, -- X29L
				{CLSID = "{X-29T}"}, -- X29T
				{CLSID = "{X-31P}"}, -- X31P
				{CLSID = "{X-31A}"}, -- X31A
				{CLSID = "{S_25_O}"}, -- S25O
				{CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}"}, -- S25OFM
				{CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}"}, -- B13L
				{CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}"}, -- B8M1 
           }
        ),

        pylon(5, 0, 0.986, -0.384, 0, {use_full_connector_position = true, arg = 312, arg_value = 0},
            {
				--{CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}"}, -- R73
				{CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}"}, -- R27R
				--{CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}"}, -- R27T
				{CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}"}, -- R27ER
				--{CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}"}, -- R27ET
				{CLSID = "{su27sm-r771}"}, -- R771
				{CLSID = "{FAB_250_M62}"}, -- FAB250
				{CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}"}, -- FAB500
				{CLSID = "{BA565F89-2373-4A84-9502-A0E017D3A44A}"}, -- KAB500L
				{CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}"}, -- KAB500Kr
            }
        ),

        pylon(6, 0, -3.751, -0.384, 0, {use_full_connector_position = true, arg = 313, arg_value = 0},
            {
				--{CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}"}, -- R73
				{CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}"}, -- R27R
				--{CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}"}, -- R27T
				{CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}"}, -- R27ER
				--{CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}"}, -- R27ET
				{CLSID = "{su27sm-r771}"}, -- R771
				{CLSID = "{FAB_250_M62}"}, -- FAB250
				{CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}"}, -- FAB500
				{CLSID = "{BA565F89-2373-4A84-9502-A0E017D3A44A}"}, -- KAB500L
				{CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}"}, -- KAB500Kr 
           }
        ),

        pylon(7, 0,  -0.075, -1.218, 1.192,{use_full_connector_position = true, arg = 314, arg_value = 0},
            {
 				--{CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}"}, -- R73
				{CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}"}, -- R27R
				--{CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}"}, -- R27T
				{CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}"}, -- R27ER
				--{CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}"}, -- R27ET
				{CLSID = "{su27sm-r771}"}, -- R771
				{CLSID = "{FAB_250_M62}"}, -- FAB250
				{CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}"}, -- FAB500
				{CLSID = "{BA565F89-2373-4A84-9502-A0E017D3A44A}"}, -- KAB500L
				{CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}"}, -- KAB500Kr
				{CLSID = "{X-29L}"}, -- X29L
				{CLSID = "{X-29T}"}, -- X29T
				{CLSID = "{X-31P}"}, -- X31P
				{CLSID = "{X-31A}"}, -- X31A
				{CLSID = "{S_25_O}"}, -- S25O
				{CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}"}, -- S25OFM
				{CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}"}, -- B13L
				{CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}"}, -- B8M1 
            }
        ),

        pylon(8, 0, -1.137, -0.321, 4.524, {use_full_connector_position = true, arg = 315, arg_value = 0},
            {
 				{CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}"}, -- R73
				{CLSID = "{9B25D316-0434-4954-868F-D51DB1A38DF0}"}, -- R27R
				{CLSID = "{88DAC840-9F75-4531-8689-B46E64E42E53}"}, -- R27T
				{CLSID = "{E8069896-8435-4B90-95C0-01A03AE6E400}"}, -- R27ER
				{CLSID = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}"}, -- R27ET
				{CLSID = "{su27sm-r771}"}, -- R771
				{CLSID = "{FAB_250_M62}"}, -- FAB250
				{CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}"}, -- FAB500
				{CLSID = "{BA565F89-2373-4A84-9502-A0E017D3A44A}"}, -- KAB500L
				{CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}"}, -- KAB500Kr
				{CLSID = "{X-29L}"}, -- X29L
				{CLSID = "{X-29T}"}, -- X29T
				{CLSID = "{X-31P}"}, -- X31P
				{CLSID = "{X-31A}"}, -- X31A
				{CLSID = "{S_25_O}"}, -- S25O
				{CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}"}, -- S25OFM
				{CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}"}, -- B13L
				{CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}"}, -- B8M1	
            }
        ),

        pylon(9, 0,  -2.535, -0.165, 6.168, {use_full_connector_position = true, arg = 316, arg_value = 0},
            {
 				{CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}"}, -- R73
				{CLSID = "{su27sm-r771}"}, -- R771
				{CLSID = "{FAB_250_M62}"}, -- FAB250
				{CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}"}, -- B8M1	
            }
        ),

        pylon(10, 0,  -1.943, 0.173, 7.28, {use_full_connector_position = true, arg = 317, arg_value = 0},
            {
 				{CLSID = "{FBC29BFE-3D24-4C64-B81D-941239D12249}"}, -- R73
				{CLSID = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}"}, -- ECM-R	
            }
        ),

},
	
	Tasks = {
        aircraft_task(CAP),
     	aircraft_task(Escort),
      	aircraft_task(FighterSweep),
		aircraft_task(Intercept),
		aircraft_task(Reconnaissance),
		aircraft_task(GroundAttack),
     	aircraft_task(CAS),
     	aircraft_task(SEAD),
	    --aircraft_task(RunwayAttack),
     	aircraft_task(AntishipStrike),
     	aircraft_task(PinpointStrike),
    },	
	DefaultTask = aircraft_task(CAP),

	SFM_Data = {
	aerodynamics = 
		{
			Cy0	=	0,
			Mzalfa	=	4.4,
			Mzalfadt	=	0.8,
			kjx = 2.7,
			kjz = 0.00125,
			Czbe = -0.016,
			cx_gear = 0.027,
			cx_flap = 0.05,
			cy_flap = 0.4,
			cx_brk = 0.06,
			table_data = 
			{
			--      M	 Cx0		 Cya		 B		 B4	      Omxmax	Aldop	Cymax
				{0, 0.0165, 0.077, 0.1, 0.032, 0.65, 25, 1.6 }, { 0.2, 0.0165, 0.077, 0.1, 0.032, 1.95, 25, 1.6 }, { 0.4, 0.0165, 0.077, 0.1, 0.032, 3.25, 25, 1.6 }, { 0.6, 0.0165, 0.08, 0.094, 0.043, 4.55, 24, 1.5 }, { 0.7, 0.017, 0.083, 0.094, 0.045, 4.55, 23, 1.45 }, { 0.8, 0.0178, 0.087, 0.094, 0.048, 4.55, 21, 1.4 }, { 0.9, 0.0215, 0.091, 0.11, 0.05, 4.55, 20, 1.3 }, { 1, 0.031, 0.094, 0.15, 0.1, 4.55, 18, 1.2 }, { 1.1, 0.0422, 0.094, 0.15, 0.1, 4.1, 16, 1.1 }, { 1.2, 0.044, 0.091, 0.14, 0.1, 3.19, 17, 1.05 }, { 1.3, 0.0432, 0.085, 0.17, 0.096, 2.28, 15, 1 }, { 1.5, 0.0423, 0.068, 0.23, 0.09, 1.95, 13, 0.9 }, { 1.8, 0.0416, 0.051, 0.23, 0.38, 1.17, 12, 0.7 }, { 2, 0.0416, 0.043, 0.08, 2.5, 1.04, 10.5, 0.55 }, { 2.2, 0.0416, 0.037, 0.16, 3.2, 0.91, 9, 0.4 }, { 2.5, 0.041, 0.036, 0.25, 4.5, 0.91, 9, 0.4 }, { 3.9, 0.0395, 0.033, 0.35, 6, 0.8, 9, 0.4 },
			}, -- end of table_data
		}, -- end of aerodynamics
		engine = 
		{
			Nmg	=	70,
			MinRUD	=	0,
			MaxRUD	=	1,
			MaksRUD	=	0.85,
			ForsRUD	=	0.91,
			type	=	"TurboJet",
			hMaxEng	=	19.6,
			dcx_eng	=	0.0124,
			cemax	=	1.24,
			cefor	=	2.56,
			dpdh_m	=	8100,
			dpdh_f	=	17000.0,
			table_data = {
			--   M		Pmax		 Pfor
				{0, 126000, 185024 }, { 0.2, 126000, 198744 }, { 0.4, 126000, 208250 }, { 0.6, 126000, 220892 }, { 0.7, 124000, 226870 }, { 0.8, 124000, 232887 }, { 0.9, 122000, 250210 }, { 1, 117000, 256120 }, { 1.1, 113000, 265400 }, { 1.2, 110000, 280300 }, { 1.3, 102000, 298900 }, { 1.5, 85000, 326000 }, { 1.8, 30000, 350000 }, { 2, 19000, 363000 }, { 2.2, 17000, 384000 }, { 2.5, 12000, 415000 }, { 3.9, 10000, 260476 },
			}, -- end of table_data
		}, -- end of engine
	},


	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = { {
			args = { 296 },
			critical_damage = 3
		}, {
			args = { 297 },
			critical_damage = 3
		}, {
			args = { 65 },
			critical_damage = 8
		}, {
			args = { 298 },
			critical_damage = 2
		}, {
			args = { 301 },
			critical_damage = 2
		},
		[0] = {
			args = { 146 },
			critical_damage = 5
		},
		[7] = {
			args = { 249 },
			critical_damage = 2
		},
		[8] = {
			args = { 265 },
			critical_damage = 2
		},
		[9] = {
			args = { 154 },
			critical_damage = 3
		},
		[10] = {
			args = { 153 },
			critical_damage = 3
		},
		[11] = {
			args = { 167 },
			critical_damage = 1
		},
		[12] = {
			args = { 161 },
			critical_damage = 1
		},
		[13] = {
			args = { 169 },
			critical_damage = 2
		},
		[14] = {
			args = { 163 },
			critical_damage = 2
		},
		[15] = {
			args = { 267 },
			critical_damage = 2
		},
		[16] = {
			args = { 266 },
			critical_damage = 2
		},
		[17] = {
			args = { 168 },
			critical_damage = 2
		},
		[18] = {
			args = { 162 },
			critical_damage = 2
		},
		[20] = {
			args = { 183 },
			critical_damage = 1
		},
		[23] = {
			args = { 223 },
			critical_damage = 5
		},
		[24] = {
			args = { 213 },
			critical_damage = 5
		},
		[27] = {
			args = { 231 },
			critical_damage = 3
		},
		[28] = {
			args = { 221 },
			critical_damage = 3
		},
		[29] = {
			args = { 224 },
			critical_damage = 6,
			deps_cells = { 23 }
		},
		[30] = {
			args = { 214 },
			critical_damage = 6,
			deps_cells = { 24 }
		},
		[35] = {
			args = { 225 },
			critical_damage = 6,
			deps_cells = { 23, 29, 27, 37 }
		},
		[36] = {
			args = { 215 },
			critical_damage = 6,
			deps_cells = { 24, 30, 28, 38 }
		},
		[37] = {
			args = { 228 },
			critical_damage = 2
		},
		[38] = {
			args = { 218 },
			critical_damage = 2
		},
		[39] = {
			args = { 244 },
			critical_damage = 2
		},
		[40] = {
			args = { 241 },
			critical_damage = 2
		},
		[43] = {
			args = { 243 },
			critical_damage = 2,
			deps_cells = { 39, 53 }
		},
		[44] = {
			args = { 242 },
			critical_damage = 2,
			deps_cells = { 40, 54 }
		},
		[51] = {
			args = { 240 },
			critical_damage = 2
		},
		[52] = {
			args = { 238 },
			critical_damage = 2
		},
		[53] = {
			args = { 248 },
			critical_damage = 2
		},
		[54] = {
			args = { 247 },
			critical_damage = 2
		},
		[55] = {
			args = { 159 },
			critical_damage = 2
		},
		[58] = {
			args = { 156 },
			critical_damage = 2
		},
		[59] = {
			args = { 148 },
			critical_damage = 2
		},
		[82] = {
			args = { 152 },
			critical_damage = 2
		},
		[83] = {
			args = { 134 },
			critical_damage = 3
		},
		[84] = {
			args = { 136 },
			critical_damage = 3
		},
		[85] = {
			args = { 135 },
			critical_damage = 3
		}
	},
	
	DamageParts = { "SU-27-OBLOMOK-WING-R", "SU-27-OBLOMOK-WING-L" },	

	lights_data = {
		lights = {
			[3] = {
				lights = { {
						argument = 192,
						typename = "argumentlight"
					}, {
						argument = 190,
						typename = "argumentlight"
					}, {
						argument = 191,
						typename = "argumentlight"
					} },
				typename = "collection"
			}
		},
		typename = "collection"
	},-- end of lights_data
}

add_aircraft(SU27SM3_AI)
