dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."devices.lua")

std_message_timeout = 15

local t_start = 0.0
local t_stop = 0.0
local delta_t_com = 2.0

start_sequence_full 	  = {}
stop_sequence_full		  = {}
cockpit_illumination_full = {}

function push_command(sequence, run_t, command)
	sequence[#sequence + 1] =  command
	sequence[#sequence]["time"] = run_t
end

function push_start_command(delta_t, command)
	t_start = t_start + delta_t
	push_command(start_sequence_full,t_start, command)
end

function push_stop_command(delta_t, command)
	t_stop = t_stop + delta_t
	push_command(stop_sequence_full,t_stop, command)
end

--
local count = 0
local function counter()
	count = count + 1
	return count
end

-- conditions
count = -1
Mig15_COMMON				= counter();
Mig15_RPM					= counter();
Mig15_GROUND_SUPPLY_ON		= counter();
Mig15_GROUND_SUPPLY_OFF		= counter();
Mig15_GROUND_SUPPLY_IS_ON	= counter();
Mig15_WHEEL_CHOCKS_OFF		= counter();
Mig15_WHEELS_FREE			= counter();
Mig15_ERROR					= counter();

--
alert_messages = {}
alert_messages[Mig15_COMMON]				= { message = _("MiG-15bis ERROR"), message_timeout = 10}
alert_messages[Mig15_RPM]					= { message = _("ENGINE RPM FAILURE"), message_timeout = 10}
alert_messages[Mig15_GROUND_SUPPLY_ON]		= { message = _("GROUND SUPPLY ON"), message_timeout = 10}
alert_messages[Mig15_GROUND_SUPPLY_OFF]		= { message = _("GROUND SUPPLY OFF"), message_timeout = 10}
alert_messages[Mig15_GROUND_SUPPLY_IS_ON]	= { message = _("NO GROUND ELECTRIC POWER"), message_timeout = 10}
alert_messages[Mig15_WHEEL_CHOCKS_OFF]		= { message = _("CHOCK THE WHEELS"), message_timeout = 10}
alert_messages[Mig15_WHEELS_FREE]			= { message = _("WHEELS ARE NOT FREE"), message_timeout = 10}
alert_messages[Mig15_ERROR]					= { message = _("FM MODEL ERROR"), message_timeout = 10}


----------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------
-- Start sequence
push_start_command(0.5,	{message = _("TAIPAN's AUTOSTART SEQUENCE IS RUNNING"), message_timeout = 60.0})
push_start_command(0.5,	{message = _("SET THROTTLE IDLE AND LEAVE AT IDLE!"), message_timeout = 40.0})
--

push_start_command(0.5,		{message = _("GROUND POWER SUPPLY - CONNECT"),	check_condition = Mig15_GROUND_SUPPLY_ON})
--pre-request ground power
push_start_command(0.1,	{message = _("OK TO RE-ARM AFTER GROUND POWER REQUEST QUEUED"), message_timeout = 20})

--Close canopy first, required by oxygen and pressurisation
push_start_command(1.0,	{device = devices.CPT_MECH,	action = cptmech_commands.Mig15_Command_CanopyAftHandle,	value = 1.0,	message = _("Canopy - CLOSE")})

push_start_command(3.0,	{device = devices.ENGINE_INTERFACE,	action = engine_commands.Mig15_Command_EngineStop,			value = 1.0,	message = _("COCKPIT PREPARATION"),	message_timeout = std_message_timeout})
push_start_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_AirEngineStartSw,	value = 0.0})
--push_start_command(0.2,	{device = devices.ASP_3N,			action = device_commands.Button_3,							value = 0.0})

--push_start_command(0.2,	{device = devices.ARC_5,			action = ARC_5_commands.CMD_ARC_5_NearOrFar,	value = 1.0})
--push_start_command(0.2,	{device = devices.ARC_5,			action = ARC_5_commands.CMD_ARC_5_Near1,		value = 0.0})
--push_start_command(0.2,	{device = devices.ARC_5,			action = ARC_5_commands.CMD_ARC_5_Near2,		value = 0.0})
--push_start_command(0.2,	{device = devices.ARC_5,			action = ARC_5_commands.CMD_ARC_5_Near3,		value = 0.0})
--push_start_command(1.0,	{device = devices.OXYGEN_INTERFACE,	action = oxygen_commands.Mig15_Command_OxygenSupplyValve,		value = 0.0,	message = _("Oxygen System - CHECK")})
--push_start_command(0.2,	{device = devices.OXYGEN_INTERFACE,	action = oxygen_commands.Mig15_Command_AirValve,				value = 1.0})
--push_start_command(0.2,	{device = devices.OXYGEN_INTERFACE,	action = oxygen_commands.Mig15_Command_OxygenEmergencyValve,	value = 1.0})
--push_start_command(1.0,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_BatterySw,		value = 0.0,	message = _("Battery - OFF")})
--push_start_command(1.0,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_VoltmeterBtn,	value = 1.0})
--push_start_command(1.0,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_VoltmeterBtn,	value = 0.0})

push_start_command(0.1,	{device = devices.OXYGEN_INTERFACE,	action = oxygen_commands.Mig15_Command_OxygenSupplyValve,		value = -1.0,	message = _("Left Console - Oxygen System - supply")})

--push_start_command(3.0,	{device = devices.AIR_INTERFACE,	action = air_commands.Mig15_Command_VentilationValve,	value = 0.0,	message = _("Cockpit Air Valve WARM")})
push_start_command(0.2,	{device = devices.AIR_INTERFACE,	action = air_commands.Mig15_Command_CockpitAirValve,	value = 0.75,	message = _("Right Console - Cockpit Air Valve WARM")})

push_start_command(0.1,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_NR23,				value = 1.0,	message = _("Right Console - CIRCUIT-BREAKERS - ON")})
push_start_command(0.1,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_N37D,				value = 1.0})
push_start_command(0.1,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_ASP3N,			value = 1.0})
push_start_command(0.1,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_PhotoGun,		value = 1.0})
push_start_command(0.1,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_Photo,			value = 1.0})

push_start_command(0.1,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_Bomb,				value = 1.0})
push_start_command(0.1,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_EmergencyDrop,	value = 1.0})
push_start_command(0.1,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_ARC,			value = 1.0})
push_start_command(0.1,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_RV2,			value = 1.0})

push_start_command(0.1,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_Trimmer,		value = 1.0})
push_start_command(0.1,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_AGK_DGMK,			value = 1.0})
push_start_command(0.1,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_Radio,			value = 1.0})

push_start_command(0.1,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_BatterySw,		value = 1.0,	message = _("Battery - ON")})
push_start_command(0.1,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_GeneratorSw,	value = 1.0})
push_start_command(0.1,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_NoseLight,	value = 1.0})

push_start_command(0.1,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_Heating,			value = 1.0,	message = _("Pitot Heat - ON")})

--Instruments setup
--Gyro fast slave
push_start_command(0.1,	{device = devices.REMOTE_COMPASS,	action = device_commands.Button_3,			value = 1.0,	message = _("Gyro Fast Slave")})
push_start_command(4.0,	{device = devices.REMOTE_COMPASS,	action = device_commands.Button_3,			value = 0.0}) --release

--Radar Altimeter ON 1200m
push_start_command(0.1,	{device = devices.RADAR_ALTIMETER,	action = device_commands.Button_5,			value = 1.0,	message = _("Radar Altimeter ON")})
push_start_command(1.0,	{device = devices.RADAR_ALTIMETER,	action = device_commands.Button_6,			value = 1.0,	message = _("Radar Altimeter 1200m")})

--Gear Handle
push_start_command(0.1,	{device = devices.GEAR_INTERFACE,	action = gear_commands.Mig15_Command_LandingGearHandleCover,	value = 0.0,	message = _("Landing Gear Handle - UNLOCK & NEUTRAL")})
push_start_command(0.2,	{device = devices.GEAR_INTERFACE,	action = gear_commands.Mig15_Command_LandingGearHandle,			value = 0.5})

push_start_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_LightsAndInstruments,	value = 1.0,	message = _("Left Console - Switches For Engine Start - ON")})
push_start_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_Ignition,				value = 1.0})
push_start_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_BoosterPump,			value = 1.0})
push_start_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_TransferPump,			value = 1.0})

-- ENGINE START BLOCK
push_start_command(0.1,	{message = _("GROUND POWER SUPPLY - CHECK"),	check_condition = Mig15_GROUND_SUPPLY_IS_ON})
push_start_command(1.0,	{device = devices.CONTROL_INTERFACE,	action = control_commands.Mig15_Command_ThrottleOff,		value = 0.0,	message = _("THROTTLE - IDLE")})
push_start_command(1.0,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_EngineStartBtnCover,	value = 1.0,	message = _("START ENGINE"),	message_timeout = 30.0})
push_start_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_EngineStartBtn,		value = 1.0,	message = _("Start Button")})
push_start_command(2.0,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_EngineStartBtn,		value = 0.0})
push_start_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_EngineStartBtnCover,	value = 0.0})
push_start_command(5.0,	{device = devices.ENGINE_INTERFACE,	action = engine_commands.Mig15_Command_EngineStop,				value = 0.5,	message = _("Engine Stop Lever move as reqd by RPM")})
push_start_command(7.0,	{device = devices.ENGINE_INTERFACE,	action = engine_commands.Mig15_Command_EngineStop,				value = 0.5})
for i = 1,100,1 do
	push_start_command(0.05,	{device = devices.ENGINE_INTERFACE,	action = engine_commands.Mig15_Command_EngineStop,		value = 0.5 - 0.005 * i})
end
push_start_command(1.0,	{device = devices.ENGINE_INTERFACE,	action = engine_commands.Mig15_Command_EngineStop,				value = 0.0})
push_start_command(11.0,	{message = _("ENGINE RPM - CHECK"),	check_condition = Mig15_RPM,	message_timeout = std_message_timeout})

push_start_command(0.2,	{message = _("GROUND POWER SUPPLY - DISCONNECT"),	check_condition = Mig15_GROUND_SUPPLY_OFF,	message_timeout = 10.0})
push_start_command(0.2,	{message = _("WHEEL CHOCKS - REMOVE"),	check_condition = Mig15_WHEEL_CHOCKS_OFF})
--push_start_command(1.0,	{message = _("WHEEL CHOCKS - CHECK"),	check_condition = Mig15_WHEELS_FREE})

--Drop tank signal on
push_start_command(0.2,	{device = devices.FUELSYS_INTERFACE,	action = fuel_commands.Mig15_Command_DropTanksSignal,	value = 1.0})
--Arm Tactical Release Switch
push_start_command(0.2,	{device = devices.WEAPON_SYSTEM,	action = device_commands.Button_8,	value = 1.0})

push_start_command(0.2,	{device = devices.CONTROL_INTERFACE,	action = control_commands.Mig15_Command_TrimAileron,	value = 0.0,	message = _("Trimmer - CHECK")})
push_start_command(0.2,	{device = devices.CONTROL_INTERFACE,	action = control_commands.Mig15_Command_TrimElevator,	value = 0.0})
push_start_command(0.2,	{device = devices.CONTROL_INTERFACE,	action = control_commands.Mig15_Command_AirBrakeSwitch,	value = 0.0})
push_start_command(1.0,	{device = devices.CONTROL_INTERFACE,	action = control_commands.Mig15_Command_FlapsHandle,	value = 0.0,	message = _("Flaps Lever  - NEUTRAL")})  --OK to set neutral because should set down at runway or taxi.

--Good to leave these here just in case starting up after a damaged landing & repair
push_start_command(1.0,	{device = devices.HYDROSYS_INTERFACE,	action = hydraulic_commands.Mig15_Command_EmergencyFlapsValve,		value = 1.0,	message = _("Emergency Hydraulic - CLOSE")})
push_start_command(0.2,	{device = devices.HYDROSYS_INTERFACE,	action = hydraulic_commands.Mig15_Command_EmergencyGearsValve,		value = 1.0})
push_start_command(0.2,	{device = devices.HYDROSYS_INTERFACE,	action = hydraulic_commands.Mig15_Command_EmergencySystemFilling,	value = 1.0})
push_start_command(0.2,	{device = devices.HYDROSYS_INTERFACE,	action = hydraulic_commands.Mig15_Command_AirNetValve,				value = 1.0})
push_start_command(0.2,	{device = devices.HYDROSYS_INTERFACE,	action = hydraulic_commands.Mig15_Command_CockpitFillingValve,		value = 1.0})

--push_start_command(1.0,	{device = devices.RSI_6K,	action = RSI_6K_commands.Mig15_Command_RSI6K_Forced,		value = 0.0,	message = _("Radio - CHECK")})
--push_start_command(0.2,	{device = devices.RSI_6K,	action = RSI_6K_commands.Mig15_Command_RSI6K_ReceiveARC,	value = 1.0})
--push_start_command(1.0,	{device = devices.AGK47B,	action = device_commands.Button_2,	value = 1.0,	message = _("AGK - CAGE")})
--push_start_command(1.0,	{device = devices.AGK47B,	action = device_commands.Button_2,	value = 0.0})

--
push_start_command(1.0,	{message = _("TAIPAN'S AUTOSTART COMPLETE"),message_timeout = 20})
push_start_command(1.0,	{message = _("Manually Charge Guns & Open Safety Switch after arming/takeoff"),message_timeout = 20})





----------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------
-- Stop sequence
push_stop_command(2.0,	{message = _("AUTOSTOP SEQUENCE IS RUNNING"),	message_timeout = std_message_timeout})
--
push_stop_command(1.0,	{device = devices.CONTROL_INTERFACE,	action = control_commands.Mig15_Command_ThrottleOff,	value = 0.0,	message = _("THROTTLE - IDLE")})
push_stop_command(1.0,	{device = devices.ENGINE_INTERFACE,		action = engine_commands.Mig15_Command_EngineStop,		value = 1.0,	message = _("ENGINE - STOP"),	message_timeout = std_message_timeout})

push_stop_command(1.0,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_AirEngineStartSw,			value = 0.0,	message = _("CIRCUIT-BREAKERS - OFF")})
push_stop_command(0.2,	{device = devices.ARC_5,			action = ARC_5_commands.CMD_ARC_5_NearOrFar,						value = 1.0})
push_stop_command(0.2,	{device = devices.ARC_5,			action = ARC_5_commands.CMD_ARC_5_Near1,							value = 0.0})
push_stop_command(0.2,	{device = devices.ARC_5,			action = ARC_5_commands.CMD_ARC_5_Near2,							value = 0.0})
push_stop_command(0.2,	{device = devices.ARC_5,			action = ARC_5_commands.CMD_ARC_5_Near3,							value = 0.0})
push_stop_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_GeneratorSw,				value = 0.0})
push_stop_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_LightsAndInstruments,	value = 0.0})
push_stop_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_Ignition,				value = 0.0})
push_stop_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_TransferPump,			value = 0.0})
push_stop_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_Photo,					value = 0.0})
push_stop_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_Trimmer,				value = 0.0})
push_stop_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_AGK_DGMK,					value = 0.0})
push_stop_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_Radio,					value = 0.0})
push_stop_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_Bomb,						value = 0.0})
push_stop_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_EmergencyDrop,			value = 0.0})
push_stop_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_ARC,					value = 0.0})
push_stop_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_RV2,					value = 0.0})
push_stop_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_NR23,						value = 0.0})
push_stop_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_N37D,						value = 0.0})
push_stop_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_ASP3N,					value = 0.0})
push_stop_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_PhotoGun,				value = 0.0})
push_stop_command(0.2,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_Heating,					value = 0.0})
push_stop_command(0.2,	{device = devices.FUELSYS_INTERFACE,	action = fuel_commands.Mig15_Command_DropTanksSignal,			value = 0.0})
push_stop_command(0.2,	{device = devices.CONTROL_INTERFACE,	action = control_commands.Mig15_Command_TrimAileron,			value = 0.0})
push_stop_command(0.2,	{device = devices.CONTROL_INTERFACE,	action = control_commands.Mig15_Command_TrimElevator,			value = 0.0})
push_stop_command(0.2,	{device = devices.CONTROL_INTERFACE,	action = control_commands.Mig15_Command_AirBrakeSwitch,			value = 0.0})

push_stop_command(1.0,	{device = devices.CONTROL_INTERFACE,	action = control_commands.Mig15_Command_FlapsHandle,	value = 0.0,	message = _("Flaps Lever  - NEUTRAL")})

push_stop_command(1.0,	{device = devices.HYDROSYS_INTERFACE,	action = hydraulic_commands.Mig15_Command_EmergencyFlapsValve,		value = 1.0,	message = _("Emergency Hydraulic - CLOSE")})
push_stop_command(0.2,	{device = devices.HYDROSYS_INTERFACE,	action = hydraulic_commands.Mig15_Command_EmergencyGearsValve,		value = 1.0})
push_stop_command(0.2,	{device = devices.HYDROSYS_INTERFACE,	action = hydraulic_commands.Mig15_Command_EmergencySystemFilling,	value = 1.0})
push_stop_command(0.2,	{device = devices.HYDROSYS_INTERFACE,	action = hydraulic_commands.Mig15_Command_AirNetValve,				value = 1.0})
push_stop_command(0.2,	{device = devices.HYDROSYS_INTERFACE,	action = hydraulic_commands.Mig15_Command_CockpitFillingValve,		value = 1.0})

push_stop_command(1.0,	{device = devices.AIR_INTERFACE,	action = air_commands.Mig15_Command_VentilationValve,	value = 1.0,	message = _("Heat And Vent System - OFF")})
push_stop_command(0.2,	{device = devices.AIR_INTERFACE,	action = air_commands.Mig15_Command_CockpitAirValve,	value = 0.0})

push_stop_command(1.0,	{device = devices.RSI_6K,	action = RSI_6K_commands.Mig15_Command_RSI6K_Forced,		value = 0.0,	message = _("Radio - CHECK")})
push_stop_command(0.2,	{device = devices.RSI_6K,	action = RSI_6K_commands.Mig15_Command_RSI6K_ReceiveARC,	value = 1.0})

push_stop_command(1.0,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_CB_BoosterPump,	value = 0.0,	message = _("Booster Pump - OFF")})
push_stop_command(1.0,	{device = devices.ELEC_INTERFACE,	action = electric_commands.Mig15_Command_BatterySw,			value = 0.0,	message = _("Battery - OFF")})

push_stop_command(1.0,	{device = devices.CPT_MECH,	action = cptmech_commands.Mig15_Command_CanopyLeftHandle,	value = 1.0, message = _("Canopy - OPEN")})

--
push_stop_command(3.0,	{message = _("AUTOSTOP COMPLETE"),	message_timeout = std_message_timeout})
