zoneName = "targets"

lfs.mkdir(lfs.writedir().."/Scripts/scenery/logs")

logFile = io.open(lfs.writedir().."/Scripts/scenery/logs/scenery_list.csv", "w")
function Export(str)
    if logFile then
        logFile:write(str .. "\n")
        logFile:flush()
    end
end

function findSceneryObjectsInTriggerZone(zoneNames)
  
    targetUnits = {}
  
  local sphere = trigger.misc.getZone(zoneNames)
          local volS = {
          id = world.VolumeType.SPHERE,
          params = {
          point = sphere.point,
          radius = sphere.radius
          }
        }
         
        local iftarget = function(targetItem, val)
          --targetUnits[#targetUnits + 1] = targetItem:getName()
      
          local index = #targetUnits + 1
          targetUnits[index] = {}
           if targetItem:getName() ~= nil then    
            targetUnits[index]['Name'] = targetItem:getName()
          end
          if targetItem:getName() ~= nil then    
            targetUnits[index]['typeName'] = targetItem:getTypeName()
          end
          if targetItem:getPoint() ~= nil then
            targetUnits[index]['Tx'] = targetItem:getPoint().x
            targetUnits[index]['Ty'] = targetItem:getPoint().y
            targetUnits[index]['Tz'] = targetItem:getPoint().z
          end
          return true
        end
         
			--world.searchObjects(Object.Category.UNIT, volS, iftarget)
			--world.searchObjects(Object.Category.STATIC, volS, iftarget)
			--world.searchObjects(Object.Category.CARGO, volS, iftarget)
			--world.searchObjects(Object.Category.BASE, volS, iftarget)
			world.searchObjects(Object.Category.SCENERY, volS, iftarget)
        
           
    
end

findSceneryObjectsInTriggerZone(zoneName)
--trigger.action.outText('objects numbers : '..#targetUnits,60)
--Export('objects numbers : '..#targetUnits)

Export('Name,ID,Coords,objects_numbers:'..#targetUnits)
for i, targetUnit in ipairs(targetUnits) do
        if targetUnit then
             typeName = targetUnit['typeName'] 
             Name = targetUnit['Name']
             Tx = targetUnit['Tx']
             Ty = targetUnit['Ty']
             Tz = targetUnit['Tz']
             Target = {x = Tx, y = Ty, z = Tz}
        end
            function getdisplayCoords()
                --trigger.action.outText('Name  : '..typeName.. '\nID :' ..Name.. '\nX :' ..Tx.. '\nY :' ..Ty.. '\nZ :' ..Tz,60)  --DCS format x,y,z
                --Export('Name:'..typeName.. '\nID :' ..Name.. '\nX :' ..Tx.. '\nY :' ..Ty.. '\nZ :' ..Tz)
                
                lat, long, alt = coord.LOtoLL(Target)                                    -- Lat Long Alt
                --trigger.action.outText('Lat : '..lat.. '\nlong :' ..long.. '\nalt :' ..alt,60)
                --Export('Lat : '..lat.. '\nlong :' ..long.. '\nalt :' ..alt)
                grid = coord.LLtoMGRS(coord.LOtoLL(Target))                                --MGRS 
                s = grid.UTMZone .. ' ' .. grid.MGRSDigraph .. ' ' .. grid.Easting .. ' ' .. grid.Northing
                --trigger.action.outText(s, 60)
                --Export(s)
                
                return lat, long, alt
            end
            local displayCoords = getdisplayCoords(Target)
            


            function getCoordinatesSTR(decLat, decLong, alt)                                                            --Lat long 
              local lat1, latF1 = math.modf(decLat)
              local latF2, latF3 = math.modf(latF1 * 60)
              local alt1 = alt
              local long1, longF1 = math.modf(decLong)
              local longF2, longF3 = math.modf(longF1 * 60)
              return {lat = string.format("%02d", lat1) .. ". " .. string.format("%02d",latF2) .. "' " .. string.format("%02d",math.floor(latF3 * 60)) .. "''N", 
                      long = string.format("%02d", long1) .. ". " .. string.format("%02d",longF2) .. "' " .. string.format("%02d",math.floor(longF3 * 60)) .. "''E",
                      alt = string.format("%02d", alt1).. 'm'}
              
            end

            local coordSTRTarget = getCoordinatesSTR(lat, long, alt)
            --trigger.action.outText('TARGET AREA : ' .. coordSTRTarget.lat .. "     " .. coordSTRTarget.long.. "     "..coordSTRTarget.alt,60)
            --Export('TARGET AREA : ' .. coordSTRTarget.lat .. "     " .. coordSTRTarget.long.. "     "..coordSTRTarget.alt)

            function LLtool(pos) -- lat Long Dec    

                local LLposN, LLposE = coord.LOtoLL(pos)
                local LLposfixN, LLposdegN = math.modf(LLposN)
                LLposdegN = LLposdegN * 60
                local LLposdegN2, LLposdegN3 = math.modf(LLposdegN)
                LLposdegN3 = LLposdegN3 * 1000

                local LLposfixE, LLposdegE = math.modf(LLposE)
                LLposdegE = LLposdegE * 60
                local LLposdegE2, LLposdegE3 = math.modf(LLposdegE)
                LLposdegE3 = LLposdegE3 * 1000

                local LLposNstring = string.format('%+.2i %.2i.%.3d', LLposfixN, LLposdegN2, LLposdegN3)
                local LLposEstring = string.format('%+.3i %.2i.%.3d', LLposfixE, LLposdegE2, LLposdegE3)
                local alt1= alt
                Alt = string.format("%02d", alt1)
                return LLposNstring, LLposEstring, Alt 
            end
            local LLposNstring, LLposEstring = LLtool(Target)    
            --trigger.action.outText('N ' .. LLposNstring .. '   E ' .. LLposEstring.. '   Alt ' ..Alt.. 'm', 60)
            --Export('N ' .. LLposNstring .. '   E ' .. LLposEstring.. '   Alt ' ..Alt.. 'm')
Export(typeName.. ',' ..Name.. ',N ' .. LLposNstring .. ' E ' .. LLposEstring.. '   Alt ' ..Alt.. 'm')

end
trigger.action.outText('Target list exported for Zone : ' ..zoneName.. ' ,You can now exit the mission and check list here: ../Saved Games/Scripts/scenery/logs/scenery_list.csv',20)