--[[

---------------------------------------------------------------------------------------------
--
--                      SCRIPT FOR LASING SCENERY ED OBJECTS (MAP OBJECTS NOT POSITIONNABLE STATICS OBJECTS)
--                      By titi69
--                      
--                      Coded using Scripting Engine Documentation : https://wiki.hoggitworld.com/view/Simulator_Scripting_Engine_Documentation
--                      Lot of code logic from ED Forum from people who already developed great scripts, here are main list regarding similar lasing topic
--                      https://forum.dcs.world/topic/206068-afac-lasing-a-static-object-building/
--						https://forum.dcs.world/topic/309801-how-to-get-info-about-some-sceneryobject-point-of-interest-like-bridges-or-building/?do=findComment&comment=5101792
--                      https://forum.dcs.world/topic/262118-gazdesignate-laser-designator-script-for-sa342m-gazelle/
--                            this script DOES NOT require MIST or MOOSE      
--                               
---------------------------------------------------------------------------------------------
This script is still WIP to enhance the logic , for any bug report or logic to add contact me in ED forum https://forum.dcs.world/profile/122914-titi69/
This script is to allow any unit called jtac in ME (unit name not group name) to lase map object (scenery objects like e.g. bridges), this can be change inside the script , it can be different unit for each kind of laser, can also be your own aircraft


you need to create trigger zone where you want to lase map object and update the zone list according to the trigger zone name you have given (if zone names are not matching between script and ME it will be scanned)
if you need specific to lase specific objects like bridge i recommend to right click on the object and assign as , it will create the trigger zone for this object
if other object are near by it may be scanned as well , also some bridge are made from multiple section
1. create Trigger zone with name as desired
2. update zone list with zonenames given
3. update code list as desired
4. update the valid target list if needed
5. update JTAC name in the script with unit name used to lase target 
5. create Triggers in ME ( this script DOES NOT require MIST or MOOSE) Trigger at mission start DO SCRIPT FILE , select the current script

for valid target list another script can be used to list all scenery object and export the name et coordinates in csv file

F10 Menu
Menu Structure at mission start: 

+ means command 
\ means submenu

\---Jtac
    +---IR Marker Off
    +---Laser Off
    +---ScanZone ZoneName1
    +---ScanZone ZoneName2
	+---ScanZone ZoneName3
....

when zones are scanned (let say there is no valide target in Zone 2, no submenu will be created for this zone)
 zone 1 : 3 target
 zone 2 : 0 target
 zone 3 : 2 target

\---Jtac
    +---IR Marker Off
    +---Laser Off
    \---Target In Zone ZoneName1
            +---TargetName 1 - COORDS
            |   +---IR Marker On
            |   +---Laser On 1688
			|   +---Laser On 1687
			|   +---Laser On 1113
            +---TargetName 2 - COORDS
            |   +---IR Marker On
            |   +---Laser On 1688
			|   +---Laser On 1687
			|   +---Laser On 1113
            +---TargetName 2 - COORDS
            |   +---IR Marker On
            |   +---Laser On 1688
			|   +---Laser On 1687
			|   +---Laser On 1113
   \---Target In Zone ZoneName3
            +---TargetName 1 - COORDS
            |   +---IR Marker On
            |   +---Laser On 1688
			|   +---Laser On 1687
			|   +---Laser On 1113
            +---TargetName 2 - COORDS
            |   +---IR Marker On
            |   +---Laser On 1688
			|   +---Laser On 1687
			|   +---Laser On 1113
....

If you need to lase another target it is recommended to turn off the previous laser before lasing new target, even if target is destroyed it will still lase it
if you don't turn off the laser before you want to change target, it will lase both target, not big issue for IR but for laser code it can messed up your bombing
same issue if you decide to change code : turn off the previous laser( still WIP to turn off laser before changing automatically)

--]]
local triggerMessageDuration = 15
local JTAC = "jtac"
-- Define Menu Item table
menuitem = {}


-- Define list of codes table
codes = {
    "1688",
    "1687",
    "1113",
}

-- Define list of zones table
zones = {
    "ZoneName1",
    "ZoneName2",
    "ZoneName3",
}

-- Define list of valid targets table
valid_Targets = 
{
  {typeName = "MOST(ROAD)BIG", description = "Road bridge section"}, --Big road bridge section
  {typeName = "MOST(ROAD)BIG_END", description = "Road bridge end section "}, --Big road bridge end section close to ground
  {typeName = "MOST(ROAD)SMALL", description = "Road bridge (small)"}, --Small road bridge
  {typeName = "MOST(ROAD)SMALL-A", description = "Road bridge"}, --Road bridge section
  {typeName = "MOSTIK", description = "Road bridge (small)"}, --Small road bridge
  {typeName = "MOSTIK-A", description = "Road bridge (small)"}, --Small road bridge
  {typeName = "MST(ROAD)SMALL", description = "Road bridge (small)"}, --Road bridge
  {typeName = "MSTIK", description = "Road bridge (small)"}, --Small road bridge
  {typeName = "ONE_PIECE_BRIDGE", description = "Road bridge (long)"}, --Long road bridge
  {typeName = "ONE_PIECE_BRIDGE02", description = "Road bridge (very long)"}, --Very long bridge
  {typeName = "BTR-80", description = "BTR-80"}, --Ground Unit  .Ammunition depot
  {typeName = ".Ammunition depot", description = "Ammunition depot"},
}

-- Export log/function , list all valid target, just for info
lfs.mkdir(lfs.writedir().."/Scripts/scenery/logs")
local logFile = io.open(lfs.writedir().."/Scripts/scenery/logs/scenery.csv", "w")
function Export(str)
        logFile:write(str .. "\n")
        logFile:flush()
end

-- The function is called via F10 Menu : Jtac/Scan zone
--Function to discover scenery inside a zone, collect Name, ID, Coordinates, convert coordinates to different format DDM, DMS , MGRS
-- it will create submenu for each zone that contain valid target (from valid_Targets table, can be updated to extend the list with more map objects) (scan menu will be delete for scanned zone)
-- for each Target in zone it will create command for IR and laser code (code can be added in code list table )
function findSceneryObjectsInTriggerZone(zoneName)
		--local zoneName = zoneName
        local zone = trigger.misc.getZone(zoneName)
        if zone then  
			local targetUnits = {}
			local volS = {
			  id = world.VolumeType.SPHERE,
			  params = {
			  point = zone.point,
			  radius = zone.radius
			  }
			}
			 
			local iftarget = function(targetItem, val)  
			  local index = #targetUnits + 1
			  targetUnits[index] = {}
			   if targetItem:getName() ~= nil then    
				targetUnits[index]['Name'] = targetItem:getName()
			  end
			  if targetItem:getName() ~= nil then    
				targetUnits[index]['typeName'] = targetItem:getTypeName()
			  end
			  if targetItem:getPoint() ~= nil then
				targetUnits[index]['Tx'] = targetItem:getPoint().x
				targetUnits[index]['Ty'] = targetItem:getPoint().y
				targetUnits[index]['Tz'] = targetItem:getPoint().z
			  end
			  return true
			end
				 
			--world.searchObjects(Object.Category.UNIT, volS, iftarget)
			--world.searchObjects(Object.Category.STATIC, volS, iftarget)
			--world.searchObjects(Object.Category.CARGO, volS, iftarget)
			--world.searchObjects(Object.Category.BASE, volS, iftarget)
			world.searchObjects(Object.Category.SCENERY, volS, iftarget)

			TargetListMenu = missionCommands.addSubMenu('Target In Zone: ' ..zoneName, menuPrincipal)
			
			Export('Name,ID,Coords,objects_numbers:'..#targetUnits)
			if logFile then
				for i, targetUnit in ipairs(targetUnits) do
						if targetUnit and  isValidTarget(targetUnit['typeName']) == true then
							typeName = targetUnit['typeName'] 
							Name = targetUnit['Name']
							Tx = targetUnit['Tx']
							Ty = targetUnit['Ty']
							Tz = targetUnit['Tz']
							Target = {x = Tx, y = Ty, z = Tz}
							readName = descValidTarget(targetUnit['typeName'])
					

							-- Convert Coords
							lat, long, alt = coord.LOtoLL(Target)									-- Lat Long Alt
							grid = coord.LLtoMGRS(coord.LOtoLL(Target))								--MGRS 
							s = grid.UTMZone .. ' ' .. grid.MGRSDigraph .. ' ' .. grid.Easting .. ' ' .. grid.Northing
							else
								trigger.action.outText('No Valid Target in zone: ' ..zoneName,triggerMessageDuration)
								missionCommands.removeItem(TargetListMenu)							-- remove scanned submenu for zone no containing valid target
								missionCommands.removeItem(menuitem[zoneName])						-- remove submenu Scan zone once zone is scanned		
								return false
						end
	
							function getdisplayCoords()
								--trigger.action.outText('Name  : '..typeName.. '\nID :' ..Name.. '\nX :' ..Tx.. '\nY :' ..Ty.. '\nZ :' ..Tz,60)  --DCS format x,y,z
								--Export('Name:'..typeName.. '\nID :' ..Name.. '\nX :' ..Tx.. '\nY :' ..Ty.. '\nZ :' ..Tz)
								
								lat, long, alt = coord.LOtoLL(Target)									-- Lat Long Alt 
								--trigger.action.outText('Lat : '..lat.. '\nlong :' ..long.. '\nalt :' ..alt,60)
								--Export('Lat : '..lat.. '\nlong :' ..long.. '\nalt :' ..alt)
								grid = coord.LLtoMGRS(coord.LOtoLL(Target))								--MGRS 
								s = grid.UTMZone .. ' ' .. grid.MGRSDigraph .. ' ' .. grid.Easting .. ' ' .. grid.Northing
								--trigger.action.outText(s, 60)
								--Export(s)
								
								return lat, long, alt
							end
							local displayCoords = getdisplayCoords(Target)


							function getCoordinatesSTR(decLat, decLong, alt)															--Lat long ALT DMS
							  local lat1, latF1 = math.modf(decLat)
							  local latF2, latF3 = math.modf(latF1 * 60)
							  local alt1 = alt
							  local long1, longF1 = math.modf(decLong)
							  local longF2, longF3 = math.modf(longF1 * 60)
							  return {lat = string.format("%02d", lat1) .. ". " .. string.format("%02d",latF2) .. "' " .. string.format("%02d",math.floor(latF3 * 60)) .. "''N", 
									  long = string.format("%02d", long1) .. ". " .. string.format("%02d",longF2) .. "' " .. string.format("%02d",math.floor(longF3 * 60)) .. "''E",
									  alt = string.format("%02d", alt1).. 'm'}
							  
							end

							local coordSTRTarget = getCoordinatesSTR(lat, long, alt)
							-- trigger.action.outText('TARGET AREA : ' .. coordSTRTarget.lat .. "     " .. coordSTRTarget.long.. "     "..coordSTRTarget.alt,60)
							--Export('TARGET AREA : ' .. coordSTRTarget.lat .. "     " .. coordSTRTarget.long.. "     "..coordSTRTarget.alt)

							function LLtool(pos) -- lat Long Dec     DDM

								local LLposN, LLposE = coord.LOtoLL(pos)
								local LLposfixN, LLposdegN = math.modf(LLposN)
								LLposdegN = LLposdegN * 60
								local LLposdegN2, LLposdegN3 = math.modf(LLposdegN)
								LLposdegN3 = LLposdegN3 * 1000

								local LLposfixE, LLposdegE = math.modf(LLposE)
								LLposdegE = LLposdegE * 60
								local LLposdegE2, LLposdegE3 = math.modf(LLposdegE)
								LLposdegE3 = LLposdegE3 * 1000

								local LLposNstring = string.format('%+.2i %.2i.%.3d', LLposfixN, LLposdegN2, LLposdegN3)
								local LLposEstring = string.format('%+.3i %.2i.%.3d', LLposfixE, LLposdegE2, LLposdegE3)
								local alt1= alt
								Alt = string.format("%02d", alt1)
								return LLposNstring, LLposEstring, Alt 
							end
							local LLposNstring, LLposEstring = LLtool(Target)

							--export to csv file in log folder SavedGames/Scripts/scenery/logs
							trigger.action.outText(readName.. ' N ' .. LLposNstring .. ' | E ' .. LLposEstring.. ' | Alt ' ..Alt.. 'm', triggerMessageDuration)					
							Export(readName.. ',' ..Name.. ',N ' .. LLposNstring .. ' E ' .. LLposEstring.. '   Alt ' ..Alt.. 'm')
							
							-- create submenu and command for IR and laser
							TargetMenu = missionCommands.addSubMenu(readName..'\nN '..LLposNstring..' | E '..LLposEstring..' | Alt:'..Alt..'m', TargetListMenu)
							missionCommands.addCommand('IR Marker On ' , TargetMenu, IR, {infrared = true, target = Target} )
							
							for i, Code in ipairs(codes) do
								if Code then
									missionCommands.addCommand('Laser On ' ..Code , TargetMenu, Laser, {code = Code, target = Target} )
									
								end
							end
				end	
				
				logFile:close()  -- Close the file when done
				else
					print("Error opening the log file.")
			end
			
		else
            Export('Zone not found: ' .. zoneName) -- if zone in the list are not in ME it is excluded 
		end   
		item = 'Scanned Targets in Zone: ' .. zoneName
		trigger.action.outText(item,60)
		missionCommands.removeItem(menuitem[zoneName])		-- remove submenu Scan zone once zone is scanned
	
end

--findSceneryObjectsInTriggerZone()

-- Function to check if target is valid
function isValidTarget(targetName)
	for i, target in ipairs(valid_Targets) do
		if target.typeName == targetName then
			return true
		end
	end
	return false
end

-- Function to display friendly name for targets in F10 Menu
function descValidTarget(targetName)
	for i, target in ipairs(valid_Targets) do
		if target.typeName == targetName then
			readName = target.description
			return readName
		end
	end
	return false
end


-- function Laser IR
function IR(vars)			
	 jtac = Unit.getByName(JTAC)
		if vars.infrared == true then
			SpotIR = Spot.createInfraRed(jtac, {x = 0, y = 1, z = 0}, vars.target)
			trigger.action.outText('Laser IR On' , triggerMessageDuration)
			return SpotIR
			else 
				SpotIR:destroy()
				trigger.action.outText('Laser IR Off' , triggerMessageDuration)
		end

end

-- function Laser IR Off not use anymore , destroy is integrated to function Laser IR
function IROFF()			
	SpotIR:destroy()
end

-- function Laser (code)
function Laser(vars)
	jtac = Unit.getByName(JTAC)
	if vars.code and vars.code then
		SpotLaser = Spot.createLaser(jtac, {x = 0, y = 1, z = 0}, vars.target, vars.code)
		trigger.action.outText('Laser On code:' ..vars.code , triggerMessageDuration)
		return SpotLaser
		else
			getcode = SpotLaser.getCode(SpotLaser)
			SpotLaser:destroy()
			trigger.action.outText('Laser Off code: ' ..getcode, 60)		
	end
end

-- function Laser Off (code)not use anymore , destroy is integrated to function Laser (code)
function LaserOFF()			
	SpotLaser:destroy()
end



-- Define menu principal Jtac, and IR and Laser off command
menuPrincipal = missionCommands.addSubMenu(JTAC)
menuIR = missionCommands.addCommand('IR Marker Off ' , menuPrincipal, IR, {infrared = false, target = nil} )
menurLase = missionCommands.addCommand('Laser Off ' , menuPrincipal, Laser, {code = nil, target = nil} )

-- Create submenu for each zone only if they are listed in in zone list
for i, zoneName in ipairs(zones) do
	local zone = trigger.misc.getZone(zoneName)
    if zone then
		table.insert(menuitem, zoneName)
		menuitem[zoneName] = missionCommands.addCommand('ScanZone '..zoneName, menuPrincipal, findSceneryObjectsInTriggerZone, zoneName)
    end
end


trigger.action.outText("Scenery lasing is now running",10)
env.info("Scenery lasing Running")