function layout()
return {
keyCommands = {
{combos = {{key = "1"}, }, down = iCommandPlaneModeNAV, name = "(1) Navigation Modes", category = "Modes"},
{combos = {{key = "6"}, }, down = iCommandPlaneModeFI0, name = "(6) Longitudinal Missile Aiming Mode", category = "Modes"},
{combos = {{key = "7"}, }, down = iCommandPlaneModeGround, name = "(7) Air-To-Ground Mode", category = "Modes"},
{combos = {{key = "8"}, }, down = iCommandPlaneModeGrid, name = "(8) Gunsight Reticle Switch", category = "Modes"},
{combos = {{key = "B"}, }, down = iCommandPlaneAirBrake, name = "Airbrake", category = "Systems"},
{combos = {{key = "B", reformers = {"LCtrl", }}, }, down = iCommandPlaneAirBrakeOff, name = "Airbrake Off", category = "Systems"},
{combos = {{key = "B", reformers = {"LShift", }}, }, down = iCommandPlaneAirBrakeOn, name = "Airbrake On", category = "Systems"},
{combos = {{key = "Left"}, }, down = iCommandPlaneLeftStart, up = iCommandPlaneLeftStop, name = "Aircraft Bank Left", category = "Flight Control"},
{combos = {{key = "Right"}, }, down = iCommandPlaneRightStart, up = iCommandPlaneRightStop, name = "Aircraft Bank Right", category = "Flight Control"},
{combos = {{key = "Up"}, }, down = iCommandPlaneUpStart, up = iCommandPlaneUpStop, name = "Aircraft Down", category = "Flight Control"},
{combos = {{key = "F2", reformers = {"LShift", }}, }, down = iCommandMarkerStatePlane, name = "Aircraft Labels", category = "Labels"},
{combos = {{key = "Z"}, }, down = iCommandPlaneLeftRudderStart, up = iCommandPlaneLeftRudderStop, name = "Aircraft Rudder Left", category = "Flight Control"},
{combos = {{key = "X"}, }, down = iCommandPlaneRightRudderStart, up = iCommandPlaneRightRudderStop, name = "Aircraft Rudder Right", category = "Flight Control"},
{combos = {{key = "Down"}, }, down = iCommandPlaneDownStart, up = iCommandPlaneDownStop, name = "Aircraft Up", category = "Flight Control"},
{combos = {{key = "F10", reformers = {"LShift", }}, }, down = iCommandMarkerState, name = "All Labels", category = "Labels"},
{combos = {{key = "Num.", reformers = {"RShift", }}, }, down = iCommandAllMissilePadlock, name = "All missiles padlock", category = "View Padlock"},
{combos = {{key = "-", reformers = {"RShift", }}, }, pressed = iCommandAltimeterPressureDecrease, up = iCommandAltimeterPressureStop, name = "Altimeter Pressure Decrease Su-25T", category = "Systems"},
{combos = {{key = "=", reformers = {"RShift", }}, }, pressed = iCommandAltimeterPressureIncrease, up = iCommandAltimeterPressureStop, name = "Altimeter Pressure Increase Su-25T", category = "Systems"},
{combos = {{key = "Q", reformers = {"LWin", }}, }, down = iCommandPlaneAttackMyTarget, name = "Attack My Target", category = "Communications"},
{combos = {{key = "N", reformers = {"RShift", }}, }, down = iCommandPlaneResetMasterWarning, name = "Audible Warning Reset", category = "Systems"},
{combos = {{key = "F6", reformers = {"RAlt", }}, }, down = iCommandAutoLockOnCenterAircraft, name = "Auto lock on center aircraft", category = "Simplifications"},
{combos = {{key = "F10", reformers = {"RAlt", }}, }, down = iCommandAutoLockOnCenterSurfaceTarget, name = "Auto lock on center surface target", category = "Simplifications"},
{combos = {{key = "F5", reformers = {"RAlt", }}, }, down = iCommandAutoLockOnNearestAircraft, name = "Auto lock on nearest aircraft", category = "Simplifications"},
{combos = {{key = "F9", reformers = {"RAlt", }}, }, down = iCommandAutoLockOnNearestSurfaceTarget, name = "Auto lock on nearest surface target", category = "Simplifications"},
{combos = {{key = "F7", reformers = {"RAlt", }}, }, down = iCommandAutoLockOnNextAircraft, name = "Auto lock on next aircraft", category = "Simplifications"},
{combos = {{key = "F11", reformers = {"RAlt", }}, }, down = iCommandAutoLockOnNextSurfaceTarget, name = "Auto lock on next surface target", category = "Simplifications"},
{combos = {{key = "F8", reformers = {"RAlt", }}, }, down = iCommandAutoLockOnPreviousAircraft, name = "Auto lock on previous aircraft", category = "Simplifications"},
{combos = {{key = "F12", reformers = {"RAlt", }}, }, down = iCommandAutoLockOnPreviousSurfaceTarget, name = "Auto lock on previous surface target", category = "Simplifications"},
{combos = {{key = "A"}, }, down = iCommandPlaneAutopilot, name = "Autopilot", category = "Autopilot"},
{combos = {{key = "6", reformers = {"LAlt", }}, }, down = iCommandPlaneRouteAutopilot, name = "Autopilot - 'Route following'", category = "Autopilot"},
{combos = {{key = "2", reformers = {"LAlt", }}, }, down = iCommandPlaneStabHbarBank, name = "Autopilot - Altitude And Roll Hold", category = "Autopilot"},
{combos = {{key = "1", reformers = {"LAlt", }}, }, down = iCommandPlaneStabTangBank, name = "Autopilot - Attitude Hold", category = "Autopilot"},
{combos = {{key = "4", reformers = {"LAlt", }}, }, down = iCommandPlaneStabHbar, name = "Autopilot - Barometric Altitude Hold", category = "Autopilot"},
{combos = {{key = "H"}, }, down = iCommandPlaneSAUHBarometric, name = "Autopilot - Barometric Altitude Hold 'H'", category = "Autopilot"},
{combos = {{key = "5", reformers = {"LAlt", }}, }, down = iCommandPlaneStabHrad, name = "Autopilot - Radar Altitude Hold", category = "Autopilot"},
{combos = {{key = "3", reformers = {"LAlt", }}, }, down = iCommandPlaneStabHorizon, name = "Autopilot - Transition To Level Flight Control", category = "Autopilot"},
{combos = {{key = "9", reformers = {"LAlt", }}, }, down = iCommandPlaneStabCancel, name = "Autopilot Disengage", category = "Autopilot"},
{combos = {{key = "`", reformers = {"LAlt", }}, }, down = iCommandPlaneAutopilotOverrideOn, up = iCommandPlaneAutopilotOverrideOff, name = "Autopilot override (Su-25T)", category = "Autopilot"},
{combos = {{key = "J", reformers = {"LShift", }}, }, down = iCommandViewCameraJiggle, name = "Camera jiggle toggle", category = "View Extended"},
{combos = {{key = "Z", reformers = {"LAlt", "LShift", }}, }, down = iCommandViewPanToggle, name = "Camera pan mode toggle", category = "View Cockpit"},
{combos = {{key = "Num2", reformers = {"RAlt", }}, }, down = iCommandViewCameraDownSlow, name = "Camera snap view down", category = "View Cockpit"},
{combos = {{key = "Num1", reformers = {"RAlt", }}, }, down = iCommandViewCameraDownLeftSlow, name = "Camera snap view down-left", category = "View Cockpit"},
{combos = {{key = "Num3", reformers = {"RAlt", }}, }, down = iCommandViewCameraDownRightSlow, name = "Camera snap view down-right", category = "View Cockpit"},
{combos = {{key = "Num4", reformers = {"RAlt", }}, }, down = iCommandViewCameraLeftSlow, name = "Camera snap view left", category = "View Cockpit"},
{combos = {{key = "Num6", reformers = {"RAlt", }}, }, down = iCommandViewCameraRightSlow, name = "Camera snap view right", category = "View Cockpit"},
{combos = {{key = "Num8", reformers = {"RAlt", }}, }, down = iCommandViewCameraUpSlow, name = "Camera snap view up", category = "View Cockpit"},
{combos = {{key = "Num7", reformers = {"RAlt", }}, }, down = iCommandViewCameraUpLeftSlow, name = "Camera snap view up-left", category = "View Cockpit"},
{combos = {{key = "Num9", reformers = {"RAlt", }}, }, down = iCommandViewCameraUpRightSlow, name = "Camera snap view up-right", category = "View Cockpit"},
{combos = {{key = "C"}, }, down = iCommandPlaneModeCannon, name = "Cannon", category = "Weapons"},
{combos = {{key = "C", reformers = {"LCtrl", }}, }, down = iCommandPlaneFonar, name = "Canopy Open/Close", category = "Systems"},
{combos = {{key = "Num5", reformers = {"RShift", }}, }, down = iCommandViewCameraCenter, name = "Center Camera View", category = "View Cockpit"},
{combos = {{key = "Num/", reformers = {"RCtrl", "RShift", }}, }, pressed = iCommandViewPitCameraMoveBack, up = iCommandViewPitCameraMoveStop, name = "Cockpit Camera Move Back", category = "View Cockpit"},
{combos = {{key = "Num5", reformers = {"RCtrl", "RShift", }}, }, down = iCommandViewPitCameraMoveCenter, name = "Cockpit Camera Move Center", category = "View Cockpit"},
{combos = {{key = "Num2", reformers = {"RCtrl", "RShift", }}, }, pressed = iCommandViewPitCameraMoveDown, up = iCommandViewPitCameraMoveStop, name = "Cockpit Camera Move Down", category = "View Cockpit"},
{combos = {{key = "Num*", reformers = {"RCtrl", "RShift", }}, }, pressed = iCommandViewPitCameraMoveForward, up = iCommandViewPitCameraMoveStop, name = "Cockpit Camera Move Forward", category = "View Cockpit"},
{combos = {{key = "Num4", reformers = {"RCtrl", "RShift", }}, }, pressed = iCommandViewPitCameraMoveLeft, up = iCommandViewPitCameraMoveStop, name = "Cockpit Camera Move Left", category = "View Cockpit"},
{combos = {{key = "Num6", reformers = {"RCtrl", "RShift", }}, }, pressed = iCommandViewPitCameraMoveRight, up = iCommandViewPitCameraMoveStop, name = "Cockpit Camera Move Right", category = "View Cockpit"},
{combos = {{key = "Num8", reformers = {"RCtrl", "RShift", }}, }, pressed = iCommandViewPitCameraMoveUp, up = iCommandViewPitCameraMoveStop, name = "Cockpit Camera Move Up", category = "View Cockpit"},
{combos = {{key = "Num0"}, }, down = iCommandViewTempCockpitOn, up = iCommandViewTempCockpitOff, name = "Cockpit panel view in", category = "View Cockpit"},
{combos = {{key = "Num0", reformers = {"RCtrl", }}, }, down = iCommandViewTempCockpitToggle, name = "Cockpit panel view toggle", category = "View Cockpit"},
{combos = {{key = "\\"}, }, down = iCommandToggleCommandMenu, name = "Communication menu", category = "Communications"},
{combos = {{key = "Insert"}, }, down = iCommandPlaneDropChaffOnce, name = "Countermeasures Chaff Dispense", category = "Countermeasures"},
{combos = {{key = "Q", reformers = {"LShift", }}, }, down = iCommandPlaneDropSnar, name = "Countermeasures Continuously Dispense", category = "Countermeasures"},
{combos = {{key = "Delete"}, }, down = iCommandPlaneDropFlareOnce, name = "Countermeasures Flares Dispense", category = "Countermeasures"},
{combos = {{key = "Q"}, }, down = iCommandPlaneDropSnarOnce, up = iCommandPlaneDropSnarOnceOff, name = "Countermeasures Release", category = "Countermeasures"},
{combos = {{key = "W", reformers = {"LWin", }}, }, down = iCommandPlaneCoverMySix, name = "Cover Me", category = "Communications"},
{combos = {{key = "Num0", reformers = {"LWin", }}, }, down = iCommandViewSnapView0, up = iCommandViewSnapViewStop, name = "Custom Snap View  0", category = "View Cockpit"},
{combos = {{key = "Num1", reformers = {"LWin", }}, }, down = iCommandViewSnapView1, up = iCommandViewSnapViewStop, name = "Custom Snap View  1", category = "View Cockpit"},
{combos = {{key = "Num2", reformers = {"LWin", }}, }, down = iCommandViewSnapView2, up = iCommandViewSnapViewStop, name = "Custom Snap View  2", category = "View Cockpit"},
{combos = {{key = "Num3", reformers = {"LWin", }}, }, down = iCommandViewSnapView3, up = iCommandViewSnapViewStop, name = "Custom Snap View  3", category = "View Cockpit"},
{combos = {{key = "Num4", reformers = {"LWin", }}, }, down = iCommandViewSnapView4, up = iCommandViewSnapViewStop, name = "Custom Snap View  4", category = "View Cockpit"},
{combos = {{key = "Num5", reformers = {"LWin", }}, }, down = iCommandViewSnapView5, up = iCommandViewSnapViewStop, name = "Custom Snap View  5", category = "View Cockpit"},
{combos = {{key = "Num6", reformers = {"LWin", }}, }, down = iCommandViewSnapView6, up = iCommandViewSnapViewStop, name = "Custom Snap View  6", category = "View Cockpit"},
{combos = {{key = "Num7", reformers = {"LWin", }}, }, down = iCommandViewSnapView7, up = iCommandViewSnapViewStop, name = "Custom Snap View  7", category = "View Cockpit"},
{combos = {{key = "Num8", reformers = {"LWin", }}, }, down = iCommandViewSnapView8, up = iCommandViewSnapViewStop, name = "Custom Snap View  8", category = "View Cockpit"},
{combos = {{key = "Num9", reformers = {"LWin", }}, }, down = iCommandViewSnapView9, up = iCommandViewSnapViewStop, name = "Custom Snap View  9", category = "View Cockpit"},
{combos = {{key = "C", reformers = {"LShift", }}, }, down = iCommandChangeGunRateOfFire, name = "Cut Of Burst select", category = "Weapons"},
{combos = {{key = "="}, }, down = iCommandPlaneZoomIn, name = "Display Zoom In", category = "Sensors"},
{combos = {{key = "-"}, }, down = iCommandPlaneZoomOut, name = "Display Zoom Out", category = "Sensors"},
{combos = {{key = "P"}, }, down = iCommandPlaneParachute, name = "Dragging Chute", category = "Systems"},
{combos = {{key = "E"}, }, down = iCommandActiveJamming, name = "ECM", category = "Countermeasures"},
{combos = {{key = "I"}, }, down = iCommandPlaneRadarOnOff, name = "ELINT Pod On/Off", category = "Sensors"},
{combos = {{key = "E", reformers = {"LCtrl", }}, }, down = iCommandPlaneEject, name = "Eject (3 times)", category = "Systems"},
{combos = {{key = "L", reformers = {"RShift", }}, }, down = iCommandPowerOnOff, name = "Electric Power Switch", category = "Systems"},
{combos = {{key = "O"}, }, down = iCommandPlaneEOSOnOff, name = "Electro-Optical System On/Off", category = "Sensors"},
{combos = {{key = "Esc"}, }, down = iCommandQuit, name = "End mission", category = "General"},
{combos = {{key = "Home", reformers = {"RAlt", }}, }, down = iCommandLeftEngineStart, name = "Engine Left Start", category = "Systems"},
{combos = {{key = "End", reformers = {"RAlt", }}, }, down = iCommandLeftEngineStop, name = "Engine Left Stop", category = "Systems"},
{combos = {{key = "Home", reformers = {"RCtrl", }}, }, down = iCommandRightEngineStart, name = "Engine Right Start", category = "Systems"},
{combos = {{key = "End", reformers = {"RCtrl", }}, }, down = iCommandRightEngineStop, name = "Engine Right Stop", category = "Systems"},
{combos = {{key = "Home", reformers = {"RShift", }}, }, down = iCommandEnginesStart, name = "Engines Start", category = "Systems"},
{combos = {{key = "End", reformers = {"RShift", }}, }, down = iCommandEnginesStop, name = "Engines Stop", category = "Systems"},
{combos = {{key = "F1"}, }, down = iCommandViewCockpit, name = "F1 Cockpit view", category = "View"},
{combos = {{key = "F1", reformers = {"LAlt", }}, }, down = iCommandViewHUDOnlyOnOff, name = "F1 HUD only view switch", category = "View"},
{combos = {{key = "F1", reformers = {"LWin", }}, }, down = iCommandViewPitHeadOnOff, name = "F1 Head shift movement on / off", category = "View"},
{combos = {{key = "F1", reformers = {"LCtrl", }}, }, down = iCommandNaturalViewCockpitIn, name = "F1 Natural head movement view", category = "View"},
{combos = {{key = "F10", reformers = {"LCtrl", }}, }, down = iCommandViewAWACSJump, name = "F10 Jump to theater map view over current point", category = "View"},
{combos = {{key = "F10"}, }, down = iCommandViewAWACS, name = "F10 Theater map view", category = "View"},
{combos = {{key = "F11"}, }, down = iCommandViewFree, name = "F11 Airport free camera", category = "View"},
{combos = {{key = "Num/", reformers = {"LAlt", }}, }, down = iCommandViewSlowDown, name = "F11 Camera moving backward", category = "View"},
{combos = {{key = "Num*", reformers = {"LAlt", }}, }, down = iCommandViewSpeedUp, name = "F11 Camera moving forward", category = "View"},
{combos = {{key = "F11", reformers = {"LCtrl", }}, }, down = iCommandViewFreeJump, name = "F11 Jump to free camera", category = "View"},
{combos = {{key = "F12", reformers = {"LCtrl", }}, }, down = iCommandViewMirage, name = "F12 Civil traffic view", category = "View"},
{combos = {{key = "F12"}, }, down = iCommandViewStatic, name = "F12 Static object view", category = "View"},
{combos = {{key = "F12", reformers = {"LShift", }}, }, down = iCommandViewLocomotivesToggle, name = "F12 Trains/cars toggle", category = "View"},
{combos = {{key = "F2"}, }, down = iCommandViewAir, name = "F2 Aircraft view", category = "View"},
{combos = {{key = "F2", reformers = {"RAlt", }}, }, down = iCommandViewFromTo, name = "F2 Toggle camera position", category = "View"},
{combos = {{key = "F2", reformers = {"LAlt", }}, }, down = iCommandViewLocal, name = "F2 Toggle local camera control", category = "View"},
{combos = {{key = "F2", reformers = {"LCtrl", }}, }, down = iCommandViewMe, name = "F2 View own aircraft", category = "View"},
{combos = {{key = "F3", reformers = {"LCtrl", }}, }, down = iCommandViewTowerJump, name = "F3 Fly-By jump view", category = "View"},
{combos = {{key = "F3"}, }, down = iCommandViewTower, name = "F3 Fly-By view", category = "View"},
{combos = {{key = "F4", reformers = {"LCtrl", }}, }, down = iCommandViewChase, name = "F4 Chase view", category = "View"},
{combos = {{key = "F4"}, }, down = iCommandViewRear, name = "F4 Look back view", category = "View"},
{combos = {{key = "F5", reformers = {"LCtrl", }}, }, down = iCommandViewFightGround, name = "F5 Ground hostile view", category = "View"},
{combos = {{key = "F5"}, }, down = iCommandViewFight, name = "F5 nearest AC view", category = "View"},
{combos = {{key = "F6"}, }, down = iCommandViewWeapons, name = "F6 Released weapon view", category = "View"},
{combos = {{key = "F6", reformers = {"LCtrl", }}, }, down = iCommandViewWeaponAndTarget, name = "F6 Weapon to target view", category = "View"},
{combos = {{key = "F7"}, }, down = iCommandViewGround, name = "F7 Ground unit view", category = "View"},
{combos = {{key = "F8", reformers = {"RCtrl", }}, }, down = iCommandViewTargetType, name = "F8 Player targets/All targets filter", category = "View"},
{combos = {{key = "F8"}, }, down = iCommandViewTargets, name = "F8 Target view", category = "View"},
{combos = {{key = "F9", reformers = {"LAlt", }}, }, down = iCommandViewLndgOfficer, name = "F9 Landing signal officer view", category = "View"},
{combos = {{key = "F9"}, }, down = iCommandViewNavy, name = "F9 Ship view", category = "View"},
{combos = {{key = "F", reformers = {"LShift", }}, }, down = iCommandPlaneFlapsOn, name = "Flaps Landing Position", category = "Systems"},
{combos = {{key = "F", reformers = {"LCtrl", }}, }, down = iCommandPlaneFlapsOff, name = "Flaps Up", category = "Systems"},
{combos = {{key = "F"}, }, down = iCommandPlaneFlaps, name = "Flaps Up/Down", category = "Systems"},
{combos = {{key = "D", reformers = {"LWin", }}, }, down = iCommandPlane_EngageAirDefenses, name = "Flight - Attack air defenses", category = "Communications"},
{combos = {{key = "G", reformers = {"LWin", }}, }, down = iCommandPlane_EngageGroundTargets, name = "Flight - Attack ground targets", category = "Communications"},
{combos = {{key = "E", reformers = {"LWin", }}, }, down = iCommandPlaneDoAndHome, name = "Flight - Complete mission and RTB", category = "Communications"},
{combos = {{key = "R", reformers = {"LWin", }}, }, down = iCommandPlaneDoAndBack, name = "Flight - Complete mission and rejoin", category = "Communications"},
{combos = {{key = "C", reformers = {"RShift", }}, }, down = iCommandFlightClockReset, name = "Flight Clock Start/Stop/Reset", category = "Systems"},
{combos = {{key = "Pause", reformers = {"RCtrl", }}, }, down = iCommandGraphicsFrameRate, name = "Frame rate counter - Service info", category = "General"},
{combos = {{key = "R"}, }, down = iCommandPlaneFuelOn, up = iCommandPlaneFuelOff, name = "Fuel Dump", category = "Systems"},
{combos = {{key = "L", reformers = {"RAlt", }}, }, down = iCommandPlaneHeadLightOnOff, name = "Gear Light Near/Far/Off", category = "Systems"},
{combos = {{key = "Tab", reformers = {"RCtrl", "RShift", }}, }, down = iCommandRecoverHuman, name = "Get new plane - respown", category = "General"},
{combos = {{key = "Num2", reformers = {"RCtrl", }}, }, down = iCommandViewCameraDown, up = iCommandViewCameraCenter, name = "Glance down", category = "View Cockpit"},
{combos = {{key = "Num1", reformers = {"RCtrl", }}, }, down = iCommandViewCameraDownLeft, up = iCommandViewCameraCenter, name = "Glance down-left", category = "View Cockpit"},
{combos = {{key = "Num3", reformers = {"RCtrl", }}, }, down = iCommandViewCameraDownRight, up = iCommandViewCameraCenter, name = "Glance down-right", category = "View Cockpit"},
{combos = {{key = "Num4", reformers = {"RCtrl", }}, }, down = iCommandViewCameraLeft, up = iCommandViewCameraCenter, name = "Glance left", category = "View Cockpit"},
{combos = {{key = "Num6", reformers = {"RCtrl", }}, }, down = iCommandViewCameraRight, up = iCommandViewCameraCenter, name = "Glance right", category = "View Cockpit"},
{combos = {{key = "Num8", reformers = {"RCtrl", }}, }, down = iCommandViewCameraUp, up = iCommandViewCameraCenter, name = "Glance up", category = "View Cockpit"},
{combos = {{key = "Num7", reformers = {"RCtrl", }}, }, down = iCommandViewCameraUpLeft, up = iCommandViewCameraCenter, name = "Glance up-left", category = "View Cockpit"},
{combos = {{key = "Num9", reformers = {"RCtrl", }}, }, down = iCommandViewCameraUpRight, up = iCommandViewCameraCenter, name = "Glance up-right", category = "View Cockpit"},
{combos = {{key = "H", reformers = {"RCtrl", }}, }, down = iCommandBrightnessILS, name = "HUD Color", category = "Systems"},
{combos = {{key = "E", reformers = {"LShift", }}, }, down = iCommandActiveIRJamming, name = "IR Jamming", category = "Countermeasures"},
{combos = {{key = "L"}, }, down = iCommandPlaneCockpitIllumination, name = "Illumination Cockpit", category = "Systems"},
{combos = {{key = "Y", reformers = {"LAlt", }}, }, down = iCommandViewCoordinatesInLinearUnits, name = "Info bar coordinate units toogle", category = "General"},
{combos = {{key = "Y", reformers = {"LCtrl", }}, }, down = iCommandInfoOnOff, name = "Info bar view toggle", category = "General"},
{combos = {{key = "R", reformers = {"LAlt", }}, }, down = iCommandPlaneJettisonFuelTanks, name = "Jettison Fuel Tanks", category = "Systems"},
{combos = {{key = "Y", reformers = {"LWin", }}, }, down = iCommandPlaneJoinUp, name = "Join Up Formation", category = "Communications"},
{combos = {{key = "J", reformers = {"RAlt", }}, }, down = iCommandPlaneJump, name = "Jump into other aircraft", category = "General"},
{combos = {{key = "K", reformers = {"LAlt", }}, }, down = iCommandViewKeepTerrain, name = "Keep terrain camera altitude", category = "View Extended"},
{combos = {{key = "]", reformers = {"LShift", }}, }, down = iCommandViewFastKeyboard, name = "Keyboard Rate Fast", category = "View"},
{combos = {{key = "]", reformers = {"LAlt", }}, }, down = iCommandViewNormalKeyboard, name = "Keyboard Rate Normal", category = "View"},
{combos = {{key = "]", reformers = {"LCtrl", }}, }, down = iCommandViewSlowKeyboard, name = "Keyboard Rate Slow", category = "View"},
{combos = {{key = "G", reformers = {"LShift", }}, }, down = iCommandPlaneGearDown, name = "Landing Gear Down", category = "Systems"},
{combos = {{key = "G", reformers = {"LCtrl", }}, }, down = iCommandPlaneGearUp, name = "Landing Gear Up", category = "Systems"},
{combos = {{key = "G"}, }, down = iCommandPlaneGear, name = "Landing Gear Up/Down", category = "Systems"},
{combos = {{key = "O", reformers = {"RShift", }}, }, down = iCommandPlaneLaserRangerOnOff, name = "Laser Ranger On/Off", category = "Sensors"},
{combos = {{key = "W", reformers = {"LAlt", }}, }, down = iCommandPlaneLaunchPermissionOverride, name = "Launch Permission Override", category = "Weapons"},
{combos = {{key = "Num."}, }, down = iCommandViewLock, name = "Lock View (cycle padlock)", category = "View Padlock"},
{combos = {{key = "Num.", reformers = {"RCtrl", }}, }, down = iCommandViewTerrainLock, name = "Lock terrain view", category = "View Padlock"},
{combos = {{key = "N", reformers = {"RAlt", }}, }, down = iCommandViewLeftMirrorOn, up = iCommandViewLeftMirrorOff, name = "Mirror Left On", category = "View Cockpit"},
{combos = {{key = "M", reformers = {"RAlt", }}, }, down = iCommandViewRightMirrorOn, up = iCommandViewRightMirrorOff, name = "Mirror Right On", category = "View Cockpit"},
{combos = {{key = "F6", reformers = {"LShift", }}, }, down = iCommandMarkerStateRocket, name = "Missile Labels", category = "Labels"},
{combos = {{key = "[", reformers = {"LShift", }}, }, down = iCommandViewFastMouse, name = "Mouse Rate Fast", category = "View"},
{combos = {{key = "[", reformers = {"LAlt", }}, }, down = iCommandViewNormalMouse, name = "Mouse Rate Normal", category = "View"},
{combos = {{key = "[", reformers = {"LCtrl", }}, }, down = iCommandViewSlowMouse, name = "Mouse Rate Slow", category = "View"},
{combos = {{key = "C", reformers = {"LAlt", }}, }, down = iCommandCockpitClickModeOnOff, name = "Mouse cursor cockpit mode", category = "General"},
{combos = {{key = "`"}, }, down = iCommandChat, name = "Multiplayer chat - mode All", category = "General"},
{combos = {{key = "`", reformers = {"RCtrl", }}, }, down = iCommandFriendlyChat, name = "Multiplayer chat - mode Allies", category = "General"},
{combos = {{key = "L", reformers = {"RCtrl", }}, }, down = iCommandPlaneLightsOnOff, name = "Navigation lights", category = "Systems"},
{combos = {{key = "`", reformers = {"LCtrl", }}, }, down = iCommandPlaneChangeTarget, name = "Next Waypoint, Airfield Or Target", category = "Modes"},
{combos = {{key = "O", reformers = {"RCtrl", }}, }, down = iCommandPlaneNightTVOnOff, name = "Night Vision (FLIR or LLTV) On/Off", category = "Sensors"},
{combos = {{key = "Delete", reformers = {"LAlt", }}, }, down = iCommandViewObjectIgnore, name = "Object exclude ", category = "View Extended"},
{combos = {{key = "Insert", reformers = {"LAlt", }}, }, down = iCommandViewObjectsAll, name = "Objects all excluded - include", category = "View Extended"},
{combos = {{key = "PageDown", reformers = {"LCtrl", }}, }, down = iCommandViewSwitchForward, name = "Objects switching direction forward ", category = "View Extended"},
{combos = {{key = "PageUp", reformers = {"LCtrl", }}, }, down = iCommandViewSwitchReverse, name = "Objects switching direction reverse ", category = "View Extended"},
{combos = {{key = "Pause"}, }, down = iCommandBrakeGo, name = "Pause", category = "General"},
{combos = {{key = "Num-"}, }, pressed = iCommandPlaneAUTDecrease, name = "Power Down", category = "Flight Control"},
{combos = {{key = "Num-", reformers = {"RAlt", }}, }, pressed = iCommandPlaneAUTDecreaseLeft, name = "Power Down Left", category = "Flight Control"},
{combos = {{key = "Num-", reformers = {"RShift", }}, }, pressed = iCommandPlaneAUTDecreaseRight, name = "Power Down Right", category = "Flight Control"},
{combos = {{key = "Num+"}, }, pressed = iCommandPlaneAUTIncrease, name = "Power Up", category = "Flight Control"},
{combos = {{key = "Num+", reformers = {"RAlt", }}, }, pressed = iCommandPlaneAUTIncreaseLeft, name = "Power Up Left", category = "Flight Control"},
{combos = {{key = "Num+", reformers = {"RShift", }}, }, pressed = iCommandPlaneAUTIncreaseRight, name = "Power Up Right", category = "Flight Control"},
{combos = {{key = "R", reformers = {"RShift", }}, }, down = iCommandChangeRWRMode, name = "RWR/SPO Mode Select", category = "Sensors"},
{combos = {{key = ",", reformers = {"RAlt", }}, }, down = iCommandPlaneThreatWarnSoundVolumeDown, name = "RWR/SPO Sound Signals Volume Down", category = "Sensors"},
{combos = {{key = ".", reformers = {"RAlt", }}, }, down = iCommandPlaneThreatWarnSoundVolumeUp, name = "RWR/SPO Sound Signals Volume Up", category = "Sensors"},
{combos = {{key = "'", reformers = {"LAlt", }}, }, down = iCommandMissionResourcesManagement, name = "Rearming and Refueling Window", category = "General"},
{combos = {{key = "I", reformers = {"LWin", }}, }, down = iCommandAWACSTankerBearing, name = "Request AWACS Available Tanker", category = "Communications"},
{combos = {{key = "U", reformers = {"LWin", }}, }, down = iCommandAWACSHomeBearing, name = "Request AWACS Home Airbase", category = "Communications"},
{combos = {{key = "Num5", reformers = {"RCtrl", }}, }, down = iCommandViewCameraReturn, name = "Return Camera", category = "View Cockpit"},
{combos = {{key = "Num5", reformers = {"RAlt", }}, }, down = iCommandViewCameraBaseReturn, name = "Return Camera Base", category = "View Cockpit"},
{combos = {{key = "V", reformers = {"LShift", }}, }, down = iCommandChangeRippleIntervalDown, name = "Ripple Interval Decrease", category = "Weapons"},
{combos = {{key = "V"}, }, down = iCommandChangeRippleInterval, name = "Ripple Interval Increase", category = "Weapons"},
{combos = {{key = "Space", reformers = {"LCtrl", }}, }, down = iCommandChangeRippleQuantity, name = "Ripple Quantity Select/SPPU select", category = "Weapons"},
{combos = {{key = "V", reformers = {"LCtrl", }}, }, down = iCommandPlaneSalvoOnOff, name = "Salvo Mode", category = "Weapons"},
{combos = {{key = "Num0", reformers = {"RAlt", }}, }, down = iCommandViewSaveAngles, name = "Save Cockpit Angles", category = "View Cockpit"},
{combos = {{key = "'"}, }, down = iCommandScoresWindowToggle, name = "Score window", category = "General"},
{combos = {{key = "SysRQ"}, }, down = iCommandScreenShot, name = "Screenshot", category = "General"},
{combos = {{key = "U"}, }, down = iCommandPlaneShipTakeOff, name = "Ship Take Off Position", category = "General"},
{combos = {{key = "Enter", reformers = {"RCtrl", }}, }, down = iCommandPlane_ShowControls, name = "Show controls indicator", category = "General"},
{combos = {{key = "T"}, }, down = iCommandPlaneWingtipSmokeOnOff, name = "Smoke", category = "Systems"},
{combos = {{key = "S", reformers = {"LCtrl", }}, }, down = iCommandSoundOnOff, name = "Sound On/Off", category = "General"},
{combos = {{key = "\\", reformers = {"LShift", }}, }, down = ICommandSwitchDialog, name = "Switch dialog", category = "Communications"},
{combos = {{key = "\\", reformers = {"LCtrl", }}, }, down = ICommandSwitchToCommonDialog, name = "Switch to main menu", category = "Communications"},
{combos = {{key = "."}, }, pressed = iCommandPlaneRadarDown, up = iCommandPlaneRadarStop, name = "Target Designator Down", category = "Sensors"},
{combos = {{key = ","}, }, pressed = iCommandPlaneRadarLeft, up = iCommandPlaneRadarStop, name = "Target Designator Left", category = "Sensors"},
{combos = {{key = "/"}, }, pressed = iCommandPlaneRadarRight, up = iCommandPlaneRadarStop, name = "Target Designator Right", category = "Sensors"},
{combos = {{key = "I", reformers = {"RCtrl", }}, }, down = iCommandPlaneRadarCenter, name = "Target Designator To Center", category = "Sensors"},
{combos = {{key = ";"}, }, pressed = iCommandPlaneRadarUp, up = iCommandPlaneRadarStop, name = "Target Designator Up", category = "Sensors"},
{combos = {{key = "Enter"}, }, down = iCommandPlaneChangeLock, name = "Target Lock", category = "Sensors"},
{combos = {{key = "[", reformers = {"RCtrl", }}, }, pressed = iCommandPlaneDecreaseBase_Distance, up = iCommandPlaneStopBase_Distance, name = "Target Size / Gunpod Elevation Decrease", category = "Sensors"},
{combos = {{key = "]"}, }, down = iCommandDecreaseRadarScanArea, name = "Target Size / Gunpod Elevation Decrease Stepping", category = "Sensors"},
{combos = {{key = "]", reformers = {"RCtrl", }}, }, pressed = iCommandPlaneIncreaseBase_Distance, up = iCommandPlaneStopBase_Distance, name = "Target Size / Gunpod Elevation Increase", category = "Sensors"},
{combos = {{key = "["}, }, down = iCommandIncreaseRadarScanArea, name = "Target Size / Gunpod Elevation Increase Stepping", category = "Sensors"},
{combos = {{key = "Back"}, }, down = iCommandRefusalTWS, name = "Target Unlock", category = "Sensors"},
{combos = {{key = "Num.", reformers = {"RAlt", }}, }, down = iCommandThreatMissilePadlock, name = "Threat missile padlock", category = "View Padlock"},
{combos = {{key = "PageDown"}, }, down = iCommandPlaneAUTDecreaseRegime, name = "Thrust Down", category = "Flight Control"},
{combos = {{key = "PageDown", reformers = {"RAlt", }}, }, down = iCommandPlaneAUTDecreaseRegimeLeft, name = "Thrust Down Left", category = "Flight Control"},
{combos = {{key = "PageDown", reformers = {"RShift", }}, }, down = iCommandPlaneAUTDecreaseRegimeRight, name = "Thrust Down Right", category = "Flight Control"},
{combos = {{key = "PageUp"}, }, down = iCommandPlaneAUTIncreaseRegime, name = "Thrust Up", category = "Flight Control"},
{combos = {{key = "PageUp", reformers = {"RAlt", }}, }, down = iCommandPlaneAUTIncreaseRegimeLeft, name = "Thrust Up Left", category = "Flight Control"},
{combos = {{key = "PageUp", reformers = {"RShift", }}, }, down = iCommandPlaneAUTIncreaseRegimeRight, name = "Thrust Up Right", category = "Flight Control"},
{combos = {{key = "Z", reformers = {"LCtrl", }}, }, down = iCommandAccelerate, name = "Time accelerate", category = "General"},
{combos = {{key = "Z", reformers = {"LAlt", }}, }, down = iCommandDecelerate, name = "Time decelerate", category = "General"},
{combos = {{key = "Z", reformers = {"LShift", }}, }, down = iCommandNoAcceleration, name = "Time normal", category = "General"},
{combos = {{key = "T", reformers = {"LWin", }}, }, down = iCommandPlaneFormation, name = "Toggle Formation", category = "Communications"},
{combos = {{key = "Num+", reformers = {"RCtrl", }}, }, down = iCommandViewPlus, name = "Toggle tracking fire weapon", category = "View Extended"},
{combos = {{key = ";", reformers = {"RCtrl", }}, }, pressed = iCommandPlaneTrimDown, up = iCommandPlaneTrimStop, name = "Trim Down", category = "Flight Control"},
{combos = {{key = ",", reformers = {"RCtrl", }}, }, pressed = iCommandPlaneTrimLeft, up = iCommandPlaneTrimStop, name = "Trim Left", category = "Flight Control"},
{combos = {{key = "Z", reformers = {"RCtrl", }}, }, pressed = iCommandPlaneTrimLeftRudder, up = iCommandPlaneTrimStop, name = "Trim Left Rudder", category = "Flight Control"},
{combos = {{key = "T", reformers = {"LCtrl", }}, }, down = iCommandPlaneTrimCancel, name = "Trim Reset", category = "Flight Control"},
{combos = {{key = "/", reformers = {"RCtrl", }}, }, pressed = iCommandPlaneTrimRight, up = iCommandPlaneTrimStop, name = "Trim Right", category = "Flight Control"},
{combos = {{key = "X", reformers = {"RCtrl", }}, }, pressed = iCommandPlaneTrimRightRudder, up = iCommandPlaneTrimStop, name = "Trim Right Rudder", category = "Flight Control"},
{combos = {{key = ".", reformers = {"RCtrl", }}, }, pressed = iCommandPlaneTrimUp, up = iCommandPlaneTrimStop, name = "Trim Up", category = "Flight Control"},
{combos = {{key = "NumLock"}, }, down = iCommandViewUnlock, name = "Unlock view (stop padlock)", category = "View Padlock"},
{combos = {{key = "F9", reformers = {"LShift", }}, }, down = iCommandMarkerStateShip, name = "Vehicle & Ship Labels", category = "Labels"},
{combos = {{key = "Num5"}, }, pressed = iCommandViewCenter, name = "View Center", category = "View"},
{combos = {{key = "Num1"}, }, pressed = iCommandViewDownLeftSlow, up = iCommandViewStopSlow, name = "View Down Left slow", category = "View"},
{combos = {{key = "Num3"}, }, pressed = iCommandViewDownRightSlow, up = iCommandViewStopSlow, name = "View Down Right slow", category = "View"},
{combos = {{key = "Num2"}, }, pressed = iCommandViewDownSlow, up = iCommandViewStopSlow, name = "View Down slow", category = "View"},
{combos = {{key = "Num4"}, }, pressed = iCommandViewLeftSlow, up = iCommandViewStopSlow, name = "View Left slow", category = "View"},
{combos = {{key = "Num6"}, }, pressed = iCommandViewRightSlow, up = iCommandViewStopSlow, name = "View Right slow", category = "View"},
{combos = {{key = "Num7"}, }, pressed = iCommandViewUpLeftSlow, up = iCommandViewStopSlow, name = "View Up Left slow", category = "View"},
{combos = {{key = "Num9"}, }, pressed = iCommandViewUpRightSlow, up = iCommandViewStopSlow, name = "View Up Right slow", category = "View"},
{combos = {{key = "Num8"}, }, pressed = iCommandViewUpSlow, up = iCommandViewStopSlow, name = "View Up slow", category = "View"},
{combos = {{key = "Delete", reformers = {"RCtrl", }}, }, down = iCommandViewAll, name = "View all mode", category = "View Extended"},
{combos = {{key = "Num2", reformers = {"RShift", }}, }, pressed = iCommandViewDown, up = iCommandViewStop, name = "View down", category = "View Cockpit"},
{combos = {{key = "Num1", reformers = {"RShift", }}, }, pressed = iCommandViewDownLeft, up = iCommandViewStop, name = "View down left", category = "View Cockpit"},
{combos = {{key = "Num3", reformers = {"RShift", }}, }, pressed = iCommandViewDownRight, up = iCommandViewStop, name = "View down right", category = "View Cockpit"},
{combos = {{key = "End", reformers = {"RCtrl", "RShift", }}, }, down = iCommandViewEnemies, name = "View enemies mode", category = "View Extended"},
{combos = {{key = "Home", reformers = {"RCtrl", "RShift", }}, }, down = iCommandViewFriends, name = "View friends mode", category = "View Extended"},
{combos = {{key = "Num4", reformers = {"RShift", }}, }, pressed = iCommandViewLeft, up = iCommandViewStop, name = "View left", category = "View Cockpit"},
{combos = {{key = "Num6", reformers = {"RShift", }}, }, pressed = iCommandViewRight, up = iCommandViewStop, name = "View right", category = "View Cockpit"},
{combos = {{key = "Num8", reformers = {"RShift", }}, }, pressed = iCommandViewUp, up = iCommandViewStop, name = "View up", category = "View Cockpit"},
{combos = {{key = "Num7", reformers = {"RShift", }}, }, pressed = iCommandViewUpLeft, up = iCommandViewStop, name = "View up left", category = "View Cockpit"},
{combos = {{key = "Num9", reformers = {"RShift", }}, }, pressed = iCommandViewUpRight, up = iCommandViewStop, name = "View up right", category = "View Cockpit"},
{combos = {{key = "D"}, }, down = iCommandPlaneChangeWeapon, name = "Weapon Change", category = "Weapons"},
{combos = {{key = "Space"}, }, down = iCommandPlaneFire, up = iCommandPlaneFireOff, name = "Weapon Fire", category = "Weapons"},
{combos = {{key = "W", reformers = {"LCtrl", }}, }, down = iCommandPlaneJettisonWeapons, name = "Weapons Jettison", category = "Systems"},
{combos = {{key = "W"}, }, down = iCommandPlaneWheelBrakeOn, up = iCommandPlaneWheelBrakeOff, name = "Wheel Brake On", category = "Systems"},
{combos = {{key = "Num*", reformers = {"RCtrl", }}, }, pressed = iCommandViewExternalZoomIn, up = iCommandViewExternalZoomInStop, name = "Zoom external in", category = "View"},
{combos = {{key = "NumEnter", reformers = {"RCtrl", }}, }, down = iCommandViewExternalZoomDefault, name = "Zoom external normal", category = "View"},
{combos = {{key = "Num/", reformers = {"RCtrl", }}, }, pressed = iCommandViewExternalZoomOut, up = iCommandViewExternalZoomOutStop, name = "Zoom external out", category = "View"},
{combos = {{key = "Num*", reformers = {"RShift", }}, }, pressed = iCommandViewForward, up = iCommandViewForwardStop, name = "Zoom in", category = "View Cockpit"},
{combos = {{key = "Num*"}, }, pressed = iCommandViewForwardSlow, up = iCommandViewForwardSlowStop, name = "Zoom in slow", category = "View"},
{combos = {{key = "NumEnter"}, }, down = iCommandViewAngleDefault, name = "Zoom normal", category = "View"},
{combos = {{key = "Num/", reformers = {"RShift", }}, }, pressed = iCommandViewBack, up = iCommandViewBackStop, name = "Zoom out", category = "View Cockpit"},
{combos = {{key = "Num/"}, }, pressed = iCommandViewBackSlow, up = iCommandViewBackSlowStop, name = "Zoom out slow", category = "View"},
},
axisCommands = {
},
}
end