
--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
-- ShowGameTime by JGi
--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
-- Description :
-- Little script for VR users like me who wants to know their playtime.
-- Show message each 15 minutes with real hour, mission hour and mission time
-- Require 'de-sanitized' MissionScripting.lua (os libs call)
--
-- Installation : 
-- Create a trigger and load script with 'time more(1)' condition
-- No dependancies needed (Moose, Mist, etc...)



--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
-- DEPENDANCIES
--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
-- VARIABLES
--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
local sgt = {}

sgt.firstTimer = true
sgt.secondTimer = false

-- First pediod, time in seconds
sgt.firstTimerStart = 0
sgt.firstTimerEnd = 360000 --default : 2701s > 45min
sgt.firstTimerInterval = 900 --default : 900s > 15min

-- Second period
sgt.secondTimerStart = 3600 --default : 3600s > 60min
sgt.secondTimerEnd = 43200 --default : 43200s > 12h
sgt.secondTimerInterval = 1800 --default : 1800s > 30m



--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
-- FUNCTIONS
--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function showTime()
    local gameTime= os.date("!%Hh%M",timer.getTime())
    local gameHour=os.date("!%Hh%M",timer.getAbsTime())
    local realHour = os.date("%Hh%M")

    trigger.action.outText(" "..realHour.." IRL | "..gameHour.." local | Temps de jeu : "..gameTime, 15, 0, false)
end



--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
-- MAIN
--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if os ~= nil then

    trigger.action.outText("Script ShowGameTime by JGi chargé.", 2, 0, false)

    -- First timer
    if sgt.firstTimer == true then
        for i = sgt.firstTimerStart, sgt.firstTimerEnd, sgt.firstTimerInterval do
            timer.scheduleFunction(showTime, {}, timer.getTime() + i)
        end
    end

    -- Second timer
    if sgt.secondTimer == true then
        for i = sgt.secondTimerStart, sgt.secondTimerEnd, sgt.secondTimerInterval do
            timer.scheduleFunction(showTime, {}, timer.getTime() + i)
        end
    end
else
    trigger.action.outText("Script ShowGameTime by JGi indisponible, MissionScripting.lua 'sanitize'.", 15, 0, false)
end