mount_vfs_model_path(current_mod_path .. "/Shapes/")
mount_vfs_texture_path(current_mod_path .. "/Textures/")

local function add_structure(f)
    if(f) then
        f.shape_table_data =
        {
            {
                file          = f.ShapeName,
                life        = f.Life,
                username    = f.Name,
                desrt       = f.ShapeNameDestr or "self",
                classname     = f.classname   or "lLandVehicle",
                positioning = f.positioning or "ONLYHEIGTH"
            }
        }
        if f.ShapeNameDestr then
            f.shape_table_data[#f.shape_table_data + 1] =
            {
                name  = f.ShapeNameDestr,
                file  = f.ShapeNameDestr,    
            }
        end
        
        
        f.mapclasskey = MapClassKey or "P0091000076";
        f.attribute = {wsType_Static, wsType_Standing} ;
        
        add_surface_unit(f)
        GT = nil;
    else
        error("Can't add structure")
    end;
end

local function add_BarrelPlane(type)
    add_structure({
        Name          =  "BarrelPlane"..type,
        DisplayName  = _("BarrelPlane"..type),
        ShapeName     =   "BarrelPlane"..type,
        ShapeNameDestr = "BarrelPlane"..type,
        Life         =  10,
        Rate         =  10,
        category     =  'Fortification',
        SeaObject    =     false,
        isPutToWater =  false,
        numParking   =  1,
        }) 
end

-- ADD_AFTER_THIS_LINE

add_BarrelPlane('000001x')
add_BarrelPlane('000002x')
add_BarrelPlane('000003x')
add_BarrelPlane('000004x')
add_BarrelPlane('000005x')
add_BarrelPlane('000006x')
add_BarrelPlane('000007x')
add_BarrelPlane('000008x')
add_BarrelPlane('000009x')
add_BarrelPlane('000010x')
add_BarrelPlane('000020x')
add_BarrelPlane('000030x')
add_BarrelPlane('000040x')
add_BarrelPlane('000050x')
add_BarrelPlane('000060x')
add_BarrelPlane('000070x')
add_BarrelPlane('000080x')
add_BarrelPlane('000090x')
add_BarrelPlane('000100x')
add_BarrelPlane('000200x')
add_BarrelPlane('000300x')
add_BarrelPlane('000400x')
add_BarrelPlane('000500x')
add_BarrelPlane('000600x')
add_BarrelPlane('000700x')
add_BarrelPlane('000800x')
add_BarrelPlane('000900x')
add_BarrelPlane('001000x')
add_BarrelPlane('002000x')
add_BarrelPlane('003000x')
add_BarrelPlane('004000x')
add_BarrelPlane('005000x')
add_BarrelPlane('006000x')
add_BarrelPlane('007000x')
add_BarrelPlane('008000x')
add_BarrelPlane('009000x')
add_BarrelPlane('010000x')
