--[[
Network game callbacks.

]]

local function translate(str)
	if str ~= "" then
		return gettext.translate(str)
	else
		return ""
	end
end

local function dtranslate(dom, str)
	if str ~= "" then
		return gettext.dtranslate(dom, str)
	else
		return ""
	end
end

_ = translate

local players = {}
local unit2player = {}


local function unit_property(unit, prop)
	return net.get_unit_property(unit, prop) or ""
end

local function select_by_side(side, red, blue, spec)
	if side == 1 then return red
	elseif side == 2 then return blue
	else return spec end
end

local get_name = function(id)
	local p = players[id]
	if p then return p.name end
	return _("JOUEUR INCONNU")
	--return net.get_name(id)
end

local report = function(msg, ...)
	net.recv_chat(string.format(msg, ...))
end

local player_info_noside = function(id)
	return '"'..get_name(id)..'"';
end

local player_info = function(id)
	local p = players[id]
	if not p then return _("JOUEUR INCONNU") end
	return select_by_side(players[id].side, _("Joueur ROUGE"), _("Joueur BLEU"), _("SPECTATEUR")) .. ' "' .. p.name .. '"'
end

local unit_info = function(unit)
	return dtranslate("missioneditor", unit_property(unit, 4))
end

local bot_info = function(unit)
	local info = unit_property(unit, 15)
	if info == "" then info = unit_info(unit) end
	if info == "" then info = _("Building") end
	return '"'..info..'"'
end

local weapon_info = function(weapon)
	return dtranslate("missioneditor", weapon)
end


-- called when simulation starts
function on_start()
	-- TODO: move this to client.on_connect
	local myid = net.get_local_id()
	local myname = net.get_name(myid)
	players[myid] = { name = myname }
	log(string.format("a demarre la partie multi-joueur. Mon indicatif=%d, Mon Nom=%q", myid, myname))
end

-- called when simulation stops
function on_stop()
end

-- called on client only.
function on_pause()
-- net.send_chat(1, "/pause")
end

-- called on client only.
function on_resume()
-- net.send_chat(1, "/resume")
end

function on_player_add(id, name_)
	players[id] = { name = name_ }
	report(_("%s est entre dans la partie."), player_info_noside(id))
end

function on_player_name(id, name)
	report(_("%s a change de nom en %q."), player_info(id), name)
	players[id].name = name
end

-- not implemented
--function on_player_spawn(id)
--end

function on_player_slot(id, side, unit)
	local p = players[id]
	if p then
		if p.unit then unit2player[p.unit] = nil end
		p.side = side
		p.unit = unit
	end
	if unit ~= "" then
		unit2player[unit] = p
	end
	report(select_by_side(side,
		_("%s a rejoin l'equipe rouge en %s."),
		_("%s a rejoin l'equipe bleu en %s."),
		_("%s a rejoin les spectateurs."))
		, player_info_noside(id), unit_info(unit))
end

function on_player_stat(id, stat, value)
end

function on_player_del(id)
	report(_("%s a quite la partie."), player_info(id))
	local p = players[id]
	if p then
		local unit = p.unit
		if unit then unit2player[unit] = nil end
		players[id] = nil
	end
end

function on_eject(id)
	report(_("%s s'est ejecte."), player_info(id))
end

function on_crash(id)
	report(_("%s s'est ecrase."), player_info(id))
end

function on_takeoff(id, airdrome)
	if airdrome ~= "" then
		report(_("%s a decolle de  %s."), player_info(id), dtranslate("missioneditor", airdrome))
	else
		report(_("%s est entre dans la partie."), player_info(id))
	end
end

function on_landing(id, airdrome)
	report(_("%s s'est pose a %s."), player_info(id), dtranslate("missioneditor", airdrome))
end

function on_kill(id, weapon, victim)
	if weapon ~= "" then
		report(_("%s a abattu %s avec %s."), player_info(id), bot_info(victim), weapon_info(weapon))
	else
		report(_("%s a abattu %s."), player_info(id), bot_info(victim))
	end
end

function on_mission_end(winner, msg)
	if winner == "" then
		local red_score = net.check_mission_result("red")
		local blue_score = net.check_mission_result("blue")
		net.recv_chat(string.format(_("Mission termine, score equipe rouge = %f, score equipe bleu = %f"), red_score, blue_score))
	else
		local text
		if winner == "RED" then text = _("Mission termine, les rouge ont gagne.")
		elseif winner == "BLUE" then text = _("Mission termine, les Bleu ont gagne.")
		else text = _("Mission termine.") end
		net.recv_chat(text)
		if msg ~= "" then net.recv_chat(msg) end
	end
end

function on_damage(shooter_objid, weapon_objid, victim_objid)
	local shooter_id = net.get_unit_property(shooter_objid, 2)
	local weapon_id = net.get_unit_property(weapon_objid, 2)
	local offence_player = unit2player[shooter_id] or unit2player[weapon_id]

	local victim_id = net.get_unit_property(victim_objid, 2)
	local defence_player = unit2player[victim_id]

	if offence_player and defence_player then
		if offence_player.side == defence_player.side then
			net.recv_chat(string.format(_("%s perte de l'equipe %s"), offence_player.name, defence_player.name))
		end
	end
end

function on_kill_player(id, weapon, killa)
	if weapon ~= "" then
		report(_("%s a abattu %s avec %s."), bot_info(killa), player_info(id), weapon_info(weapon))
	else
		report(_("%s a abattu %s."), bot_info(killa), player_info(id))
	end
end

---
log('events.lua loaded')
