

function plane_presets(plane,loadouts)
	local t = {}
	t[1] = "Select preset..."
	for i = 1,#loadouts do
		t[i + 1] = 'F'..tostring(i)..'-'..loadouts[i]	
	end
	t[#t + 1] = "F11-Retour"
	t[#t + 1] = "F12-Sortir"
	resources["RC-Rearming-"..plane..".res"] = t
end


resources = {
["RC-DestinationHel.res"] = {
                            "Communications",
                            "F1 - Escadron...",
                            "F2 - Ailier 2...",
                            "F3 - Ailier 3...",
                            "F4 - Ailier 4...",
                            "F6 - Tour...",
                            "F10- Maintenance...",   
                            "F12- Sortir",},
["RC-WingmanHel.res"] =    {
                            "Ailier...",
                            "F1 - Engagez...",
                            "F2 - Prendre en tenaille...",
                            "F3 - Aller vers...",
                            "F4 - Couvrez moi",
                            "F5 - Larguez l'armement",
                            "F6 - Reconnaissance ...",
                            "F7 - Mentenir position",
                            "F8 - Rejoignez la formation",
                            "F11- Retour",
                            "F12- Sortir",},
["RC-EngageHel.res"] =     {                           
                            "Engagez...",
                            "F1 - Ma cible",
                            "F2 - Mon ennemi",
                            "F3 - Ennemis",
                            "F4 - Defense anti-aerienne",
                            "F5 - Cible au sol",
                            "F7 - Mission et rejoignez",
                            "F8 - Mission et RTB",
                            "F9 - Cible du Datalink...",
                            "F11- Retrour",
                            "F12- Sortir",},
["RC-EngageDlinkTargetHel.res"] = {
							"Cible duDatalink...",
							"F1 - Cible",
							"F2 - Cibles",
							"F3 - Cible par type",
							"F4 - Cibles par type",
                            "F11- Retrour",
                            "F12- Sortir"
										},
["RC-PincerHel.res"] =     {
                            "Tenaille...",
                            "F1 - Gauche",
                            "F2 - Droite",
                            "F11- Retour",
                            "F12- Sortir",},
["RC-VectorToHel.res"] =   {
                            "Allez vers...",
                            "F1 - retrournez a la base",
                            "F2 - Route",
                            "F3 - Point du Datalink",
                            "F11- Retour",
                            "F12- Sortir",},                         
["RC-FlightHel.res"]   =    {
                            "Escadron...",
                            "F1 - Engagez...",
                            "F2 - Prendre en tenaille...",
                            "F3 - Allez vers...",
                            "F4 - Couvrez moi",
                            "F5 - L'arguez l'armement",
                            "F6 - mettez-vous en formation...",
                            "F7 - Rejoignez la Formation",
                            "F11- Retour",
                            "F12- Sortir",},
["RC-GoFormationHel.res"] = {
                            "Mettez-vous en formation ...",
                            "F1 - Heavy",
                            "F2 - Combat Cruise",
                            "F3 - Combat Spread",
                            "F4 - Trail",
                            "F5 - Overwatch",
                            "F6 - Gauche",
                            "F7 - Droite",
                            "F8 - Tight",
                            "F9 - Cruise",
                            "F10- Combat",
                            "F11- Retour",
                            "F12- Sortir",},                          
["RC-OnOff.res"] =          {
                            "Groupe de puissance lectrique au sol...",
                            "F1 - Marche",
                            "F2 - Arret",
                            "F11- Retour",
                            "F12- Sortir",},
["RC-TowerHel.res"] =       {
                            "Tower...",
                            "F1 - Demande mise en route de moteurs",
                            "F2 - Demande roulage vers la piste",
                            "F3 - demande information mto pour vol en stationnaire",
                            "F4 - Demande autorisation de dcolage",
                            "F5 - En approche",
                            "F6 - Demande autorisation d'atterrissage",
                            "F7 - Demande azimut vers la base",
                            "F11- Retour",
                            "F12- Sortir",},
["RC-MaintenanceHel.res"] = {
                            "Maintenance de l'Hlicopter...",
                            "F1 - Choisir l'armement...",
                            "F2 - Refaire le plein...",
                            "F3 - Changer l'Helmet jour/nuit...",
                            "F4 - Groupe de puissance lectrique au sol...",
                            "F5 - Selectioner la source de puissance...",
                            "F11- Retour",
                            "F12- Sortir",},                           
["RC-ReconnaissanceHel.res"] = {
                            "Reconnaissance...",
                            "F1 - 1 km",
                            "F2 - 2 km",
                            "F3 - 3 km",
                            "F4 - 5 km",
                            "F5 - 8 km",
                            "F6 - 10 km",
                            "F7 - Point",
                            "F11- Retour",
                            "F12- Sortir",},               
["RC-ReloadingHel.res"] = {
                            "Changer d'armement...",
                            "F1 - Transit",
                            "F2 - frappe en profondeur",
                            "F3 - Anti-Char",
                            "F4 - CAS",
                            "F5 - Capacit de combat rduit",
                            "F6 - Armement par dfault",
                            "F11- Retour",
                            "F12- Sortir",},                           
["RC-ReloadingFerryHel.res"] = {
                            "Transit...",
                            "F1 - 2xTanks",
                            "F2 - 4xTanks",
                            "F3 - 2xTanks; 2A42",
                            "F4 - 4xTanks; 2A42",
                            "F5 - 2A42",
                            "F6 - Vide",
                            "F11- Retour",
                            "F12-Sortir",},
["RC-ReloadingRemoteHel.res"] = {
                            "Frappe en profondeur...",
                            "F1 - 2xTanks; 12xATGM; 2A42",
                            "F2 - 2xTanks; 2xB820A; 2A42",
                            "F3 - 2xTanks; 2xUB-13; 2A42",
                            "F4 - 2xTanks; 2xUPK-23; 2A42",
                            "F5 - 2xTanks; 2xKMGU (AP); 2A42",
                            "F6 - 2xTanks; 2xKMGU (AT); 2A42",
                            "F7 - 2xTanks; 2xFAB-250; 2A42",
                            "F8 - 2xTanks; 2xFAB-500; 2A42",
                            "F11- Retour",
                            "F12- Sortir",},
["RC-ReloadingAntitankHel.res"] = {
                            "Anti-Char...",
                            "F1 - 12xATGM; 2xB820A; 2A42",
                            "F2 - 12xATGM; 2xUB-13; 2A42",
                            "F3 - 12xATGM; 2xUPK-23; 2A42",
                            "F4 - 12xATGM; 2xKMGU (AT); 2A42",
                            "F11- Retour",
                            "F12- Sortir",},
["RC-ReloadingFireSupportHel.res"] = {
                            "CAS...",
                            "F1 - 4xB820A; 2A42",
                            "F2 - 4xUB-13; 2A42",
                            "F3 - 4xUPK-23; 2A42",
                            "F4 - 4xKMGU (AP); 2A42",
                            "F5 - 4xKMGU (AT); 2A42",
                            "F6 - 4xFAB-250; 2A42",
                            "F7 - 4xFAB-500; 2A42",
                            "F11- Retour",
                            "F12- Sortir",},
["RC-ReloadingLightLoadHel.res"] = {
                            "Capacit de combat rduit...",
                            "F1 - 6xATGM; 2A42",
                            "F2 - 12xATGM; 2A42",
                            "F3 - 2xB8V20A; 2A42",
                            "F4 - 2xUB-13; 2A42",
                            "F5 - 2xUPK-23; 2A42",
                            "F6 - 2xKMGU (AP); 2A42",
                            "F7 - 2xKMGU (AT); 2A42",
                            "F8 - 2xFAB-250; 2A42",
                            "F9 - 2xFAB-500; 2A42",
                            "F11- Retour",
                            "F12- Sortir",},
["RC-RefuelingHel.res"] =  {
                            "rservoir auxiliaire interieure...",
                            "F1- 25/%",
                            "F2- 50/%",
                            "F3- Au mximum de la capacit de combat (10800kg)",
                            "F4- Au maximum de la capacit de transit (11900kg)",
                            "F11- Retour",
                            "F12- Sortir",},
["RC-ReplacementHel.res"] = {
                            "Changer l'Helmet jour/nuit...",
                            "F1- Monter viseur HMS (jour)",
                            "F2- Monter vision NVG (nocturne)",
                            "F11- Retour",
                            "F12- Sortir",},
["RC-PowerSourceSelectionHel.res"] = {
                            "Select Power Source...",
                            "F1- Turbine",
                            "F2- Rotor",
                            "F11- Retour",
                            "F12- Sortir",},
							
["RC-Maintenance.res"] = {
                            "maintenance de l'avion...";
                            "F1 - Choisir l'armement...";
                            "F2 - Canon seulement";
							"F3 - Armement par dfault";
							"F4 - Refaire le plein...";
                            "F11- Retour";
                            "F12- Sortir";};
							
["RC-Refueling.res"] = {
                            "Refaire le plein...";
                            "F1 - 25%";
                            "F2 - 50%";
							"F3 - 75%";
							"F4 - 100%";
							"F5 - Fin";
                            "F12- Sortir";};
							
							
}

loadouts = 
{
	["mig-29"] = 
	{
		"4xR-73;2xR-27R;Fuel";
		"6xR-73;Fuel";
		"2xR-73;2xR-27R;2xFAB-500;Fuel";
		"2xR-73;2xBetAB-500;2xFAB-500;Fuel";
		"4xR-73;3xFuel";
		"2xR-73;2xB-20;2xKMGU;Fuel";
		"2xR-73;2xB-20;2xS-24;Fuel";
		"2xR-73;4xS-24;Fuel";
		"2xR-73;4xB-20;Fuel";
		"2xR-73;2xB-20;2xR-27R;Fuel";
	};
	["mig-29c"] = 
	{
		"2xR-73;2xR-77;2xR-27ET;Fuel";
		"4xR-77;2xR-27ER;Fuel";
		"4xR-77;2xR-27ET;Fuel";
		"2xR-77;2xFAB-500;2xBetAB-500;Fuel";
		"2xR-73;2xR-77;3xFuel";
		"2xR-73;2xB-20;2xKMGU;Fuel";
		"2xR-73;2xB-20;2xS-24;Fuel";
		"2xR-73;4xS-24;Fuel";
		"2xR-77;4xB-20;Fuel";
		"2xR-77;2xB-20;2xR-27ET;Fuel";
	};
	["su-27"] = 
	{
		"ECM;2xR-73;2xR-27ET;4xR-27ER";
		"4xR-73;2xR-27ET;4xR-27ER";
		"ECM;2xR-73;2xR-27ET;4xFAB-500";
		"ECM;2xR-73;2xR-27ET;2xR-27ER;2xBetAB-500";
		"ECM;2xR-73;2xR-27ET;2xS-13;2xR-27ER";
		"4xR-73;4xB-20;2xRBK-500";
		"ECM;2xR-73;2xR-27ET;2xKMGU;2xFAB-500";
		"4xR-73;4xB-20;2xBetAB-500";
		"ECM;2xR-73;4xS-25;2xR-27ER";
		"ECM;2xR-73;2xS-25;2xB-20;2xR-27ER";	
	};
	["su-33"] = 
	{
		"ECM;2xR-73;2xR-27ET;4xR-27EM;2xR-27ER";
		"ECM;2xR-73;2xR-27ET;6xR-27ER";
		"4xR-73;2xR-27ET;4xR-27EM;2xR-27ER";
		"ECM;2xR-73;2xR-27ET;2xR-27EM;2xFAB-500;2xBetAB-500";
		"4xR-73;2xR-27ET;4xR-27EM;2xFAB-500;2xBetAB-500";
		"ECM;2xR-73;2xR-27ET;4xB-20;2xR-27EM";
		"2xR-73;2xFAB-250;2xR-27ET;2xFAB-500;4xBetAB-500";
		"ECM;2xR-73;6xS-25;2xR-27EM";
		"ECM;2xR-73;2xR-27ET;2xR-27EM;2xKMGU;2xRBK-500";
		"ECM;2xR-73;2xR-27ET;2xR-27EM;2xB-20;2xFAB-500";
	};
	["a-10a"] =
	{
		"ECM 2xAGM-65D;4xMk-82;2xAIM-9";
		"ECM 4xAGM-65D;4xMk-20;2xAIM-9";
		"ECM AGM-65K;AGM-65D;2xMk-84;2xMk-20;2xAIM-9";
		"ECM 2xAGM-65K;2xMk-20;2xMk-82;2xAIM-9";
		"ECM 2xAGM-65D;2xMk-20;2xMk-82;2xAIM-9";
		"ECM 2xLAU-61;4xAGM-65D;4xMk-20;2xAIM-9";
		"ECM 2xLAU-61;AGM-65K;AGM-65D;2xMk-20;2xMk-82;2xAIM-9";
		"ECM 2xLAU-61;2xAGM-65K;4xMk-82;2xAIM-9";
		"ECM 2xLAU-61 Smoke;AGM-65K;AGM-65D;4xMk-82;2xAIM-9";
		"ECM 2xSUU-25;2xAGM-65D;2xMk-20;2xMk-82;2xAIM-9";
	};
	["F-15C"] =
	{
		"4xAIM-9;4xAIM-7;Fuel";
		"4xAIM-9;2xAIM-7;2xAIM-120B";
		"4xAIM-9;2xAIM-7;2xAIM-120C;Fuel";
		"4xAIM-9;4xAIM-120C;Fuel";
		"2xAIM-9;2xAIM-120B;4xAIM-120C;Fuel";
		"4xAIM-9;4xAIM-7;3xFuel";
		"4xAIM-9;2xAIM-7;2xAIM-120B;3xFuel";
		"4xAIM-9;2xAIM-7;2xAIM-120C;3xFuel";
		"4xAIM-9;4xAIM-120C;3xFuel";
		"2xAIM-9;2xAIM-120B;4xAIM-120C;3xFuel";
	};
	["su-25"] =
	{
		"2xR-60;8xB-20";
		"2xR-60;4xB-20;4xSPPU-22";
		"2xR-60;4xB-20;2xRBK-500;2xKMGU";
		"2xR-60;2xB-20;6xS-24";
		"2xR-60;2xB-20;2xFAB-500;4xKh-25ML";
		"2xR-60;2xB-20;2xKh-25ML;2xFAB-500;2xBetAB-500";
		"2xR-60;2xS-25L;6xKh-25ML";
		"2xR-60;6xFAB-500;2xBetAB-500";
		"2xR-60;2xS-25L;2xB-20;2xKMGU;2xSPPU-22";
		"2xR-60;2xB-20;2xRBK-250;2xRBK-500;2xKh-25ML";
	};
	["su-25T"] =
	{
		"ECM;2xS-25L;4xKh-25MPU;2xKh-58U;L-081";
		"ECM;2xR-73;4xKh-25MPU;2xKh-58U;L-081";
		"2xR-60;2xS-25L;2xKh-25MPU;16xVikhR;2xKh-58U;L-081";
		"2xR-60;2xB-20;2xKMGU;16xVikhR;2xSPPU-22";
		"2xR-60;2xB-20;2xKMGU;16xVikhR;2xSPPU-22;LLTV Pod";
		"2xR-60;2xR-73;2xB-20;16xVikhR;2xKh-29T";
		"2xR-60;2xS-25L;2xB-20;16xVikhR;2xFAB-500";
		"2xR-60;2xRBK-500;2xKMGU;16xVikhR;2xKh-29T";
		"2xR-60;4xB-20;4xSPPU-22";
		"2xR-60;4xB-20;16xVikhR;2xKh-29T";
	};
}
loadouts["mig-29g"] = loadouts["mig-29"]
for i,o in pairs(loadouts) do
	plane_presets(i,o)
end




local tabula  = "    " -- 4 spaces instead tab


function add_body(size,max_wide,caption)

local body_ = 
{
    [[\dialog]],
    [[\begin]],
    tabula..[[\tag{-1}]],
    tabula..[[\upright]],
    tabula..[[\coord{]]..tostring(-max_wide)..[[,5,-5,]]..tostring((size + 1)*20)..[[}]],
    tabula..[[\caption{]]..caption..[[}]],
    tabula..[[\musthavecursor{0}]],
    tabula..[[\drawitself{1}]],
    tabula..[[\color{0, 0, 0, 50}]],
    tabula..[[\layer{100}]],
    [[\end]],
    [[]],  
    [[\static]],
    [[\begin]],
    tabula..[[\tag{50}]],
    tabula..[[\font{2}]],
    tabula..[[\coord{12, 5,]]..tostring(max_wide)..[[, 25}]],
    tabula..[[\fontcolor{0, 219, 111, 255}]],
    tabula..[[\caption{]]..caption..[[}]],
    [[\end]],
    [[]],  
}
for i=1,#body_ do 
    io.write(body_[i]..'\n')
end
end


function add_menu_string(pos,max_wide,caption)
local body_ = 
{
    [[\static]],
    [[\begin]],
    tabula..[[\tag{]]..tostring(pos)..[[}]],
    tabula..[[\font{2}]],
    tabula..[[\coord{12,]]..tostring(5 + 20 *(pos -1))..[[,]]..tostring(max_wide)..[[,]].. tostring(25 + 20 *(pos -1))..[[}]],
    tabula..[[\caption{]]..caption..[[}]],
    [[\end]],
    [[]],
} 
for i=1,#body_ do 
    io.write(body_[i]..'\n')
end
end

function generate_resource(resource,strings) 
    local f = io.open(resource,'w')
    if f == nil then
        return 
    end
    io.output(f)
    local sz = #strings         
    local max_wide = 1
    for i = 1,sz do
        local s = string.len(strings[i])
        if s > max_wide then
           max_wide = s
        end
    end 
    local per_symbol = math.ceil((280-12)/33)
    print(resource.." \n"..tostring(max_wide).."\n")
    local width = per_symbol * max_wide
    if width < 180 then
       width = 180
    end
    add_body(sz,width,strings[1])
    for i = 2,sz do
        add_menu_string(i,width,strings[i])
    end       
    io.close(f)
end

for i,o in pairs(resources) do
    generate_resource(i,o)
end