
function M134(tbl)
    tbl.category = CAT_GUN_MOUNT
--    tbl.name      = "M134"
    tbl.name      = "M134_SUU11POD"
    tbl.supply      =
    {
		shells = {"M134_7_62_T"},
        count  = 1500,		-- 1500 round DRUM
    }
    if tbl.mixes then
       tbl.supply.mixes = tbl.mixes
       tbl.mixes        = nil
    end
    tbl.gun =
    {
        max_burst_length    = 1500, --  number of rounds fired per burst
        rates               = {4000}, --4k to 6k
        recoil_coeff        = 0.07*1.3,
        barrels_count       = 6,
    }
    if tbl.rates then
       tbl.gun.rates        =  tbl.rates
       tbl.rates            = nil
    end
    tbl.ejector_pos             = {-0.5,-0.13,0.02} -- position from muzzle connector pos
    tbl.ejector_dir             = {-1, -6, 0} -- left/right; back/front;?/?
    tbl.supply_position         = tbl.supply_position   or {-0.155, 0.382, 0.944}
    tbl.aft_gun_mount           = false
    tbl.effective_fire_distance = 1500
    tbl.drop_cartridge          = 205	--drop shell shape/size from  aircraft_gun_mounts.lua
    tbl.muzzle_pos              = tbl.muzzle_pos            or  {0.96,-0.169,0}     -- all position from connector
    tbl.muzzle_pos_connector    = tbl.muzzle_pos_connector  or  "PNT_GUN" -- all position from connector
    tbl.azimuth_initial         = tbl.azimuth_initial       or  0
    tbl.elevation_initial       = tbl.elevation_initial     or  0
    if  tbl.effects == nil then
        tbl.effects = {
--						{ name = "FireEffect"     , arg = tbl.effect_arg_number or 436 },
--						{ name = "HeatEffectExt"  , shot_heat = 7.823, barrel_k = 0.462 * 16.0},
						{ name = "FireEffect"  , arg = 43, attenuation = 2, duration = 0.02, light_pos = { 0.5, 0, 0 }},
						{ name = "VisualHeatEffect"  , arg = 45, shot_heat = 7.823, barrel_k = 0.462 * 16.0},
						{ name = "SmokeEffect"},
						{ name = "GatlingEffect", arg = 800, barrels_n = 6, spin_up_t = 1,
--						spin_down_t = 0.01
						spin_down_t = 0.75
						} --animation arg for barrel spin
					   }

    end
    return declare_weapon(tbl)
end

minigun = {
    category        = CAT_PODS,
    CLSID           = "{CLP_SUU11}",
	attribute	=	{4,	15,	46, WSTYPE_PLACEHOLDER},				   --weapon_type
	wsTypeOfWeapon = {4,wsType_Shell,wsType_Shell_A, WSTYPE_PLACEHOLDER}, --container_type
    Picture         = "M134.png",
    displayName     = _("SUU-11/A Minigun Pod"),
    Weight          = 39,      --39kg empty gun
    Cx_pil          = 0.00015,
    Elements        = {{ShapeName = "CLP_SUU11"}},
    kind_of_shipping = 2,   -- SOLID_MUNITION
    gun_mounts      = {
        M134({

			})
    },
    shape_table_data = {{file = 'CLP_SUU11'; username = 'SUU-11/A Minigun'; index = WSTYPE_PLACEHOLDER;}}
}
declare_loadout(minigun)

