mount_vfs_texture_path(current_mod_path.."/Textures/CLP_O2A_TEXTURES")
dofile(current_mod_path..'/O2A_Weapons.lua')

CLP_O2 =  {

-----------------------
-- Name, Shape and Type
-----------------------

    Name 				= 'CLP_O2',
    DisplayName         = _('O-2 SKYMASTER (CLP)'),
    date_of_introduction= 1967,
    country_of_origin   = "USA",
    Picture             = "CLP_O2.png",
    Rate                = 40, -- RewardPoint in Multiplayer
    Shape               = "CLP_O2",

	WorldID 		= WSTYPE_PLACEHOLDER,

	propellorShapeType  = "3ARG_PROC_BLUR",
    propellorShapeName  = "O2_PROP.FBX",

	debrisGeneration    = 1,

    shape_table_data    = {
        {
            file        = "CLP_O2";
            life        = 18; -- life bar
            vis         = 3; -- visibility gain
            desrt       = "kc-135-oblomok"; -- Name of destroyed object file name
            fire        = {3600, 6}; -- Fire on the ground after destroyed
            username    = "CLP_O2";
            index       = WSTYPE_PLACEHOLDER;
            classname   = "lLandPlane";
            positioning = "BYNORMAL";
            drawonmap = true;
        },
        {
            name = "kc-135-oblomok";
            file = "kc-135-oblomok";
            fire = {3600, 6};
        },
    },

	CanopyGeometry = makeAirplaneCanopyGeometry(LOOK_GOOD, LOOK_GOOD, LOOK_AVERAGE),

	singleInFlight = false,
		mapclasskey = "P0091000026",
	attribute = {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER,
		"Battleplanes",
		"All", "NonAndLightArmoredUnits", "NonArmoredUnits", "Air",
		"Planes"
	},
	Categories = {
	},



-----------------------
-- SENSORS RADIOS
-----------------------

	Sensors = {
		OPTIC = "Merkury LLTV" --TEST
	},

	radar_can_see_ground	=	false,


	HumanRadio = {
	frequency = 243.0,
	editable = true,
	minFrequency = 30.000,
	maxFrequency = 399.975,
	rangeFrequency = {
		{min = 30.0,  max = 87.975},
		{min = 108.0, max = 115.975},
		{min = 118.0, max = 173.975},
		{min = 225.0, max = 399.975},
	},
	modulation = MODULATION_AM,
	},

    detection_range_max     = 0, --todo zeroed to prevent picking it up on RWR

	InheriteCommonCallnames = true,
	SpecificCallnames = { --TEST
			USA = { { "Tilly", "Tilly" }, { "Rustic", "Rustic" },{ "Spat", "Spat" }, { "Copperhead", "Copperhead" },{ "Lopez", "Lopez" },{ "Bird-Dog", "Bird-Dog" }}
		},
    -- Countermeasures

    CMDS_Edit           = false,



-----------------------
-- DEFINITION
-----------------------

    -----------------------------------------------------------------------------------------------

	M_empty         = 1292.0, -- kg
    M_nominal       = 1315.0, -- kg
    M_max           = 2449.0, -- kg
    M_fuel_max      = 485.0 * 0.72, -- kg --TODO
    H_max           = 6000.0, -- m
    average_fuel_consumption = 0.009042, -- this is highly relative, but good estimates are 36-40l/min = 28-31kg/min = 0.47-0.52kg/s -- 45l/min = 35kg/min = 0.583kg/s
    CAS_min         = 180, -- CAS capability in minute (for AI)
    V_opt           = 232.0 / 3.6,-- Cruise speed (for AI)
    V_take_off      = 120.0 / 3.6, -- Take off speed in m/s (for AI)  -TODO
    V_land          = 120.0 / 3.6, -- Land speed in m/s (for AI)
    V_max_sea_level = 320.0 / 3.6, -- Max speed at sea level in m/s (for AI)
    V_max_h         = 320.0 / 3.6, -- Max speed at max altitude in m/s (for AI)
    Vy_max          = 6.0, -- Max climb speed in m/s (for AI)
    Mach_max        = 0.5, -- Max speed in Mach (for AI) --TODO
    Ny_min          = -5.0, -- Min G (for AI)
    Ny_max          = 7.0, -- Max G (for AI)
    Ny_max_e        = 7.0, -- Max G (for AI)
    AOA_take_off    = 0.14, -- AoA in take off (for AI) -- TODO evaluate
    bank_angle_max  = 60, -- Max bank angle (for AI) -- TODO evaluate

    has_afteburner  = false, -- AFB yes/no
    has_speedbrake  = false, -- Air brake yes/no
    has_differential_stabilizer = false, -- Differential stabilizers yes/no

--    flaps_transmission = "Pneumatic",
--    undercarriage_transmission = "Pneumatic",
    flaps_transmission = "Hydraulic",
    doors_transmission = "Mechanical",
    doors_movement = 1,

    tand_gear_max   = 0.577, -- tang(a) <- a = steering angle -- TODO evaluate
    ------------------------------------
 	nose_gear_pos 								=  {2.27, -1.57, 0.0}, -- nosegear coord
	nose_gear_amortizer_direct_stroke   		=  0.0,  -- down from nose_gear_pos !!!
	nose_gear_amortizer_reversal_stroke  		=  -0.12, --(1.44-1.56)
	nose_gear_amortizer_normal_weight_stroke 	=  -0.09,
	nose_gear_wheel_diameter 					=  0.4, -- in m

 	main_gear_pos 						 	 	=  {-0.07, -1.47, 1.212},
	main_gear_amortizer_direct_stroke	 	 	=   0, --  down from main_gear_pos !!!
	main_gear_amortizer_reversal_stroke  	 	=   -0.16,
	main_gear_amortizer_normal_weight_stroke 	=  -0.03, -- -0.1,-- down from main_gear_pos
	main_gear_wheel_diameter 				 	=   0.44, -- in m
	------------------------------------

    wing_area       = 18.81, -- Wing area in m2
    wing_span       = 11.58, -- Wing span in metres
    wing_type       = 0, -- 0 = Fixed wing
                         -- 1 = Variable geometry
                         -- 2 = Fold-able wing
    thrust_sum_max  = 3193.0, -- Thrust in kg -- TODO evaluate
    thrust_sum_ab   = 3193.0, -- Thrust in kg -- TODO evaluate
    length          = 9.07, -- Full length in m
    height          = 2.84, -- Height in m
    flaps_maneuver  = 0.5, -- Max flaps in take-off and manoeuvre (0.5 = 1st stage; 1.0 = 2nd stage) (for AI)
    range           = 1710, -- Max range in km (for AI)
    RCS             = 2.5, -- Radar Cross Section m2 -- TODO evaluate
    IR_emission_coeff = 0.1, -- Normal engine -- IR_emission_coeff = 1.0 @ Su-27 without afterburner. It is a reference value. -- TODO evaluate
    IR_emission_coeff_ab = 0, -- Same with afterburner
    wing_tip_pos    = {-0.56, 0.55, -5.57}, -- Wing tip coordinates for visual effects -- TODO evaluate

    brakeshute_name = 0, -- Landing - brake chute visual shape after separation


    engines_count = 2, -- Engines count
	engines_nozzles = {
		[1] =
		{
 			pos 		=  {-1.67,-0.37, 0}, -- nozzle coords
			elevation   =  0, -- AFB cone elevation
			diameter	 = 1.0, -- AFB cone diameter
			exhaust_length_ab   = 1.5, -- lenght in m
			exhaust_length_ab_K = 0.33, -- AB animation
			smokiness_level = 0.3,
			engine_number       = 1,
		}, -- end of [1]
		[2] =
		{
			pos 		=  {2.13 ,-0.97, 0}, -- nozzle coords
			elevation   =  0, -- AFB cone elevation
			diameter	 = 1.0, -- AFB cone diameter
			exhaust_length_ab   = 1.5, -- lenght in m
			exhaust_length_ab_K = 0.33, -- AB animation
			smokiness_level = 0.3,
			engine_number       = 2,
		}, -- end of [1]
	}, -- end of engines_nozzles

    -- Tasks


    Tasks = {
		aircraft_task(GroundAttack),
        aircraft_task(RunwayAttack),
        aircraft_task(PinpointStrike),
        aircraft_task(CAS),
		aircraft_task(Escort),
        aircraft_task(SEAD),
        aircraft_task(AFAC),
		aircraft_task(Transport),
		aircraft_task(Reconnaissance),
    },
    DefaultTask = aircraft_task(Reconnaissance),

-----------------------
-- ANIMATIONS
-----------------------
	AddPropAircraft = { {
			arg = 38,
			control = "checkbox",
			defValue = FALSE,
			id = "CABINDOORCONTROL",
			label = "Start with Open Cabin Door",

		} },

	crew_members = {
        [1] = {
            pilot_name          = "CLP_PILOT",
			pos					 = {2.63, -0.15, -0.39},
            ejection_seat_name  = 0,
				ejection_order = 2,
			drop_canopy_name	=	0,
            role                = "pilot",
			role_display_name = "Pilot in command",
			pilot_body_arg      = 50,
			bailout_arg = -1,
                canopy_arg = -1,
               boarding_arg = 38,

        }, -- end of [1]

    }, -- end of crew_members

--	crew_stations = "HumanOrchestra",

    mechanimations = {


	Door0 = { -- used to open CABIN door when parked
            {Transition = {"Close", "Open"},  Sequence = {{C = {{"Sleep", "for", 5.0}}}, {C = {{"PosType", 9}, {"Sleep", "for", 10.0}}}, {C = {{"Arg", 38, "to", 1.0, "at", 0.6}}}}},
            {Transition = {"Open", "Close"},  Sequence = {{C = {{"Arg", 38, "to", 0.0, "at", 0.6}}}}},

        },
        Door1 = {DuplicateOf = "Door0"},


        LeftStrut = {
            {Transition = {"Retract", "Extend"}, Sequence = {{C = {{"VelType", 5}, {"Arg", 5, "to", 1.0, "in", 16.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Extend", "Retract"}, Sequence = {{C = {{"VelType", 5}, {"Arg", 5, "to", 0.0, "in", 16.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Any", "Collapse"},   Sequence = {{C = {{"VelType", 5}, {"PosType", 6}, {"Arg", 5, "to", 0.5, "in", 2.0}}}}},
        },
        RightStrut = {
            {Transition = {"Retract", "Extend"}, Sequence = {{C = {{"VelType", 3}, {"Arg", 3, "to", 1.0, "in", 16.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Extend", "Retract"}, Sequence = {{C = {{"VelType", 3}, {"Arg", 3, "to", 0.0, "in", 18.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Any", "Collapse"},   Sequence = {{C = {{"VelType", 3}, {"PosType", 7}, {"Arg", 3, "to", 0.5, "in", 2.0}}}}},
        },
        CentralStrut = {
            {Transition = {"Retract", "Extend"}, Sequence = {{C = {{"VelType", 4}, {"Arg", 0, "to", 1.0, "in", 15.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Extend", "Retract"}, Sequence = {{C = {{"VelType", 4}, {"Arg", 0, "to", 0.0, "in", 16.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Any", "Collapse"},   Sequence = {{C = {{"VelType", 4}, {"PosType", 8}, {"Arg", 0, "to", 0.5, "in", 2.0}}}}},
        },

    },


    net_animation = { --TODO full list. is this needed for AI?
--        278, 279, 203
    },



-----------------------
-- FLIGHT MODEL
-----------------------

    -- SFM Data modified from YAK-52
    SFM_Data = {
        aerodynamics = { -- Cx = Cx_0 + Cy^2*B2 +Cy^4*B4
            Cy0         = 0.1, -- zero AoA lift coefficient
            Mzalfa      = 4.355, -- coefficients for pitch agility
            Mzalfadt    = 0.8, -- coefficients for pitch agility
            kjx         = 2.25,
            kjz         = 0.00125,
            Czbe        = -0.016, -- coefficient, along Z axis (perpendicular), affects yaw, negative value means force orientation in FC coordinate system
            cx_gear     = 0.0277, -- coefficient, drag, gear
            cx_flap     = 0.095, -- coefficient, drag, full flaps
            cy_flap     = 0.45, -- coefficient, normal force, lift, flaps
            cx_brk      = 0.06, -- coefficient, drag, breaks
            table_data  =
            {   --      M       Cx0         Cya         B       B4      Omxmax  Aldop       Cymax
                    {   0.0,    0.0242, 0.10,       0.0634,     0.0,    0.15,   20.0,       1.58,   },
                    {   0.2,    0.0242, 0.10,       0.0634,     0.0,    1.606,  20.0,       1.58,   },
                    {   0.342,  0.0245, 0.0787,     0.061,      0.017,  2.353,  18.0,       1.3,    },
                    {   0.5,    0.0263, 0.0770,     0.057,      0.025,  1.145,  16.0,       0.95,   },
                    {   0.59,   0.0268, 0.0768,     0.0514,     0.026,  0.761,  15.0,       0.75,   },
                    {   0.67,   0.0331, 0.0784,     0.047,      0.021,  0.384,  14.5,       0.62,   },
                    {   0.74,   0.0465, 0.0848,     0.08,       0.16,   0.206,  10.0,       0.46,   },
                    {   0.76,   0.0527, 0.0813,     0.1,        0.25,   0.133,  9.0,        0.42,   },
                    {   0.8,    0.0737, 0.0695,     0.2,        0.36,   0.077,  6.0,        0.38,   },
                    {   0.83,   0.1006, 0.0993,     0.34,       2.4,    0.063,  4.5,        0.3,    },
                    {   0.9,    0.1470, 0.073,      0.56,       3.0,    0.042,  3.0,        0.2,    },
                }, -- end of table_data
            -- M - Mach number
            -- Cx0 - Coefficient, drag, profile, of the airplane
            -- Cya - Normal force coefficient of the wing and body of the aircraft in the normal direction to that of flight. Inversely proportional to the available G-loading at any Mach value. (lower the Cya value, higher G available) per 1 degree AOA
            -- B - Polar quad coeff
            -- B4 - Polar 4th power coeff
            -- Omxmax - roll rate, rad/s
            -- Aldop - Alfadop Max AOA at current M - departure threshold
            -- Cymax - Coefficient, lift, maximum possible (ignores other calculations if current Cy > Cymax)
        }, -- end of aerodynamics
        engine = {
            Nominal_RPM = 2920,
            Nmg     = 24.027, -- RPM at idle
            MinRUD  = 0, -- Min state of the throttle
            MaxRUD  = 1, -- Max state of the throttle
            MaksRUD = 1, -- Military power state of the throttle
            ForsRUD = 1, -- Afterburner state of the throttle
			type    = "Piston",
			name    = "RollsRoyceMerlin",
            Startup_Prework = 15.0,
            Startup_RPMs = {
                {0.0, 0},
                {2.0, 120},
                {5.6, 120},
                {5.5, 120},
                {6.5, 1100},
                {8.5, 900},
				{13.0, 900},
				{21.0, 550},
            },
            Startup_Ignition_Time = 6.3,
            Shutdown_Duration = 6.3,

            hMaxEng = 12.5, -- Max altitude for safe engine operation in km
            dcx_eng = 0.015, -- Engine drag coefficient
            cemax   = 0.37, -- not used for fuel calculation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
            cefor   = 0.37, -- not used for fuel calculation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
            dpdh_m  = 1800, -- altitude coefficient for max thrust
            dpdh_f  = 1800, -- altitude coefficient for AB thrust
            k_adiab_1           = 0.037923,
            k_adiab_2           = 0.0562,
            MAX_Manifold_P_1    = 155774,
            MAX_Manifold_P_2    = 206570,
            MAX_Manifold_P_3    = 226648,
            k_after_cool        = 0.54,
            Displ               = 27,
            k_Eps               = 6,
            Stroke              = 0.152,
            V_pist_0            = 12,
            Nu_0                = 1.2,
            Nu_1                = 0.9,
            Nu_2                = 0.001,
            N_indic_0           = 1023040,
            N_fr_0              = 0.072,
            N_fr_1              = 0.02,
            Init_Mom            = 220,
            D_prop              = 3.28,
            MOI_prop            = 65,
            k_gearbox           = 2.096,
            P_oil               = 495438,
            k_boost             = 3,
            k_cfug              = 0.003,
            k_oil               = 0.00004,
            k_piston            = 3000,
            k_reg               = 0.003,
            k_vel               = 0.017,

			table_data =
            {
            --   M          Pmax
                {0.0,       25000.0}, -- was 16620.0
                {0.1,       23200.0}, -- 15600
                {0.2,       21350.0}, -- 14340
                {0.3,       20000.0}, -- 13320
                {0.4,       18160.0}, -- 12230
                {0.5,       16400.0}, -- 11300
                {0.6,       15750.0}, -- 10600
                {0.7,       14950.0}, -- 10050
                {0.8,       14600.0}, -- 9820
                {0.9,       8800.0}, -- 5902
                {1.9,        4800.0}  -- 3469
            },
            -- M - Mach number
			-- Pmax - total thrust in Mil Pwr in Newtons for all engines
			-- Pfor - total thrust in AB in Newtons for all engines
            --cylinder_firing_order = {1,3,4,2},

  			prop_direction      = 1, -- pos rotates cw looking fwd neg is ccw

			prop_pitch_min      = 26.0, -- prop pitch min, degrees
            prop_pitch_max      = 82.0, -- prop pitch max, degrees
            prop_pitch_feather  = 90.0, -- prop pitch feather position, degrees if feather < prop_pitch_max no feathering available
            prop_blades_count   = 2,
            prop_locations      = {
				{3.17, -0.32, 0}, {0, 0.0, 0.0}, -- roll, yaw, pitch angle in tangent value
                {-2.07, 0.16, 0}, {0, 0.0, 0.0}, --TODO test
			},

        }, -- end of engine

    }, -- end of SFM Data

-----------------------
-- WEAPONS
-----------------------

-- Guns
	Guns 	= NIL,


--   ammo_type = {}, --TODO

    Pylons =
	{
-- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)

	pylon(1, 1, 0.076, 0.224 , -2.63,
			{
				connector = 'PNT_PYLON_01',
				use_full_connector_position = false,
				arg = 308 ,arg_value = 0,
			},
			{
				{ ["CLSID"] = "{LAU68_FFAR_WP156}", arg_value = 0.01 },
				{ ["CLSID"] = "{LAU68_FFAR_MK1HE}", arg_value = 0.01 },
				{ ["CLSID"] = "{LAU68_FFAR_MK5HEAT}", arg_value = 0.01 },

				{ CLSID = "<CLEAN>", arg_value = 1},

	--			{ CLSID = "{LAU-131 - 7 AGR-20A}" }, 		-- LAU-68 F/A with M151 APKWS
	--			{ CLSID = "{LAU-131 - 7 AGR-20 M282}" },	-- LAU-68 F/A with M282 APKWS
			}
		),

	pylon(2, 1, 0.076, 0.195 , -2.10,
			{
				connector = 'PNT_PYLON_02',
				use_full_connector_position = false,
				arg = 309 ,arg_value = 0,
			},
			{
				{ ["CLSID"] = "{LAU68_FFAR_WP156}", arg_value = 0.01 },
				{ ["CLSID"] = "{LAU68_FFAR_MK1HE}", arg_value = 0.01 },
				{ ["CLSID"] = "{LAU68_FFAR_MK5HEAT}", arg_value = 0.01 },
				{ ["CLSID"] = "{CLP_SUU11}", arg_value = 0.01 },  -- GUNPOD TEST

				{ CLSID = "<CLEAN>", arg_value = 1},

			}
		),
	pylon(3, 1, 0.076, 0.195 , 2.10,
			{
				connector = 'PNT_PYLON_03',
				use_full_connector_position = false,
				arg = 311 ,arg_value = 0,
			},
			{
				{ ["CLSID"] = "{LAU68_FFAR_WP156}", arg_value = 0.01 },
				{ ["CLSID"] = "{LAU68_FFAR_MK1HE}", arg_value = 0.01 },
				{ ["CLSID"] = "{LAU68_FFAR_MK5HEAT}", arg_value = 0.01 },
				{ ["CLSID"] = "{CLP_SUU11}", arg_value = 0.01 },  -- GUNPOD TEST

				{ CLSID = "<CLEAN>", arg_value = 1},

			}
		),
	pylon(4, 1, 0.076, 0.224 , 2.63,
			{
				connector = 'PNT_PYLON_04',
				use_full_connector_position = false,
				arg = 312 ,arg_value = 0,
			},
			{
				{ ["CLSID"] = "{LAU68_FFAR_WP156}", arg_value = 0.01 },
				{ ["CLSID"] = "{LAU68_FFAR_MK1HE}", arg_value = 0.01 },
				{ ["CLSID"] = "{LAU68_FFAR_MK5HEAT}", arg_value = 0.01 },

				{ CLSID = "<CLEAN>", arg_value = 1},

			}
		),


	},


-----------------------
-- DAMAGE MODEL
-----------------------
	fires_pos =
		{
			[1] = 	{-0.138,	-0.79,	0},  --Fuselage
			[2] = 	{-0.11,	0.98,	0.5}, -- Wing R In
			[3] = 	{-0.11,	0.98,	-0.5}, -- Wing L In
			[4] = 	{-0.11,	0.98,	2.5},  -- Wing R Mid
			[5] = 	{-0.82,	0.265,	-2.5},  -- Wing L Mid
			[6] = 	{-0.11,	0.98,	6.8}, -- Wing R Out
			[7] = 	{-0.11,	0.98,	-6.8}, -- Wing L Out
			[8] = 	{1.2615,0.4074, 3.123}, -- Engine R engine exhaust pos
			[9] = 	{1.2615,0.4074, -3.123}, -- Engine L In
			[10] = 	{2.15, 0.685, 2.588},  -- Engine R Out
			[11] = 	{2.15, 0.685, -2.588},  -- Engine L Out 2.15, 0.685, -2.588
		}, -- end of fires_pos



	Failures = {
	},



	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {

	[0] = {critical_damage = 5, args = {146}}, --NOSE_CENTER
	[3] = {critical_damage = 10, args = {65}}, --CABINA / COCKPIT
	[8] = {critical_damage = 10}, --FRONT_GEAR_BOX

	[9]  = {critical_damage = 3,  args = {154}},--FUSELAGE_LEFT_SIDE OK


	[11] = {critical_damage = 3, args = {168}}, --ENGINE_L
	[12] = {critical_damage = 3, args = {162}}, --ENGINE_R

	[15] = {critical_damage = 2,  args = {267}},--LEFT_GEAR_BOX
	[16] = {critical_damage = 2,  args = {266}},--RIGHT_GEAR_BOX
--	[17] = {critical_damage = 2,  args = {168}},--ENGINE_L_OUT
--	[18] = {critical_damage = 2,  args = {162}},--ENGINE_R_OUT

	[25] = {critical_damage = 2,  args = {226}},--ELERON_L
	[26] = {critical_damage = 2,  args = {216}},--ELERON_R
--	[35] = {critical_damage = 6, args = {225, 308, 309}, deps_cells = {25, 37, 11}},--WING_L_IN
--	[36] = {critical_damage = 6, args = {215, 311, 312}, deps_cells = {26, 38, 12}},--WING_R_IN

	[35] = {critical_damage = 6, args = {225}, deps_cells = {25, 37, 11}},--WING_L_IN
	[36] = {critical_damage = 6, args = {215}, deps_cells = {26, 38, 12}},--WING_R_IN

	[37] = {critical_damage = 2,  args = {227, 228}},--FLAP_L_IN
	[38] = {critical_damage = 2,  args = {217, 218}},--FLAP_R_IN

	[43] = {critical_damage = 2,  args = {243}},--FIN_L_BOTTOM radome
	[44] = {critical_damage = 2,  args = {242}, deps_cells = {53}},--FIN_R_BOTTOM

	[51] = {critical_damage = 2,  args = {240}},--ELEVATOR_L_IN
	[52] = {critical_damage = 2,  args = {238}},--ELEVATOR_R_IN
	[53] = {critical_damage = 2, args = {247}},  -- RUDDER_L
	[54] = {critical_damage = 2, args = {248}}, --RUDDER_R
	[55] = {critical_damage = 15, args = {81}, deps_cells = {51, 52}},  --tail

	},



	DamageParts = {
		[1] = "CLP_O2_WING_R", -- wing R
		[2] = "CLP_O2_WING_L", -- wing L
--		[3] = "kc-135-oblomok-noise", -- nose
--		[4] = "kc-135-oblomok-tail-r", -- tail
--		[5] = "kc-135-oblomok-tail-l", -- tail
	},

-----------------------
-- LIGHTING
-----------------------

    lights_data = {
        typename = "collection",
        lights = {
            [WOLALIGHT_LANDING_LIGHTS] = {
                typename = "collection",
                lights = {
                    { -- 0 -- Landing Light
                        typename = "collection",
                        lights = {
							{
                                typename = "spotlight", connector = "RESERV_SPOT_PTR", argument = 209,
                                proto = lamp_prototypes.LFS_P_27_600, angle_max = math.rad(18.0), angle_min = math.rad(11.0), angle_change_rate = math.rad(32.0 * 0.25),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "spotlight", connector = "RESERV_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, range = 24.0, angle_max = math.rad(136.0), angle_min = math.rad(116.0), angle_change_rate = math.rad(-52.0),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "Omni", connector = "RESERV_SPOT_PTR", pos_correction = {0.2, 0.0, 0.0},
                                proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
                            },


                        },
                    },
                    { -- 1 -- Landing / Taxi Light
                        typename = "collection",
                        lights = {

							{
                                typename = "spotlight", connector = "MAIN_SPOT_PTR", argument = 208,
                                proto = lamp_prototypes.LFS_P_27_600, angle_max = math.rad(18.0), angle_min = math.rad(11.0), angle_change_rate = math.rad(32.0 * 0.25),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "spotlight", connector = "MAIN_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, range = 24.0, angle_max = math.rad(136.0), angle_min = math.rad(116.0), angle_change_rate = math.rad(-52.0),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "Omni", connector = "MAIN_SPOT_PTR", pos_correction = {0.2, 0.0, 0.0},
                                proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
                            },

                        },
                    },
                },
            },
            [WOLALIGHT_TAXI_LIGHTS] = {
                typename = "collection",
                lights = {
                    { -- 0 -- NW Light
                        typename = "collection",
                        lights = {
							 {
                                typename = "spotlight", connector = "MAIN_SPOT_PTR", argument = 208,
                                proto = lamp_prototypes.LFS_P_27_600, angle_max = math.rad(18.0), angle_min = math.rad(11.0), angle_change_rate = math.rad(32.0 * 0.25),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "spotlight", connector = "MAIN_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, range = 24.0, angle_max = math.rad(136.0), angle_min = math.rad(116.0), angle_change_rate = math.rad(-52.0),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "Omni", connector = "MAIN_SPOT_PTR", pos_correction = {0.2, 0.0, 0.0},
                                proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
                            },
                        },
                    },
					{ -- 1 -- Taxi Light
                        typename = "collection",
                        lights = {

							 {
                                typename = "spotlight", connector = "MAIN_SPOT_PTR", argument = 208,
                                proto = lamp_prototypes.LFS_P_27_600, angle_max = math.rad(18.0), angle_min = math.rad(11.0), angle_change_rate = math.rad(32.0 * 0.25),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "spotlight", connector = "MAIN_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, range = 24.0, angle_max = math.rad(136.0), angle_min = math.rad(116.0), angle_change_rate = math.rad(-52.0),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "Omni", connector = "MAIN_SPOT_PTR", pos_correction = {0.2, 0.0, 0.0},
                                proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
                            },

                        },
                    },
                },
            },
            [WOLALIGHT_NAVLIGHTS] = {
                typename = "Collection",
                lights = {
                    { -- 0 -- Left Position Light (RED)
                        typename = "Spot", connector = "BANO_1", argument = 190,
                        proto = lamp_prototypes.BANO_7M_red, angle_max = math.rad(160.0), angle_min = math.rad(90.0),
                    },
							{
                                typename = "Omni", connector = "BANO_1",
                                proto = lamp_prototypes.BANO_7M_red,
								range = 9.0,
                            },
                    { -- 1 -- Right Position Light (GREEN)
                        typename = "Spot", connector = "BANO_2", argument = 191,
                        proto = lamp_prototypes.BANO_7M_green, angle_max = math.rad(160.0), angle_min = math.rad(90.0),
                    },
							{
                                typename = "Omni", connector = "BANO_2",
                                proto = lamp_prototypes.BANO_7M_green,
--								range = 9.0,
                            },
                    { -- 2 -- Tail Position Light (WHITE)
                        typename = "Collection",
                        lights = {
                            {
                                typename = "Spot", connector = "BANO_0", argument = 192,
                                proto = lamp_prototypes.ANO_3_Bl,
                            },
                            {
                                typename = "Omni", connector = "BANO_0",
                                proto = lamp_prototypes.ANO_3_Bl, range = 9.0,
                            },

                        },
                    },
                },
            },
            [WOLALIGHT_AUX_LIGHTS] = {
                typename = "collection",
                lights = {

                },
            },
            [WOLALIGHT_CABIN_BOARDING] = {
                typename = "collection",
                lights = {
 --                   { -- 0 -- Dome Light -- TODO THIS ANIMATES A VISIBLE LIGHT IN MODEL
 --                       typename = "Argument", argument = 296,
 --                   },
 --                   { -- 1 -- LH Panel Floodlight -- TODO THIS ANIMATES A VISIBLE LIGHT IN MODEL
 --                      typename = "Argument", argument = 302,
 --                   },
                },
            },
			[WOLALIGHT_STROBES] = {
				typename = "collection",
				lights = {
					{
						typename = "collection",
						lights = {

							{
								typename = "natostrobelight", connector = "RED_BEACON", argument = 193,
								proto = lamp_prototypes.SMI_2KM,
							},
														{
								typename = "natostrobelight", connector = "RED_BEACON2", argument = 193,
								proto = lamp_prototypes.SMI_2KM,
							},
														{
								typename = "natostrobelight", connector = "RED_BEACON3", argument = 193,
								proto = lamp_prototypes.SMI_2KM,
							},
						},
					},
				},
			},
			[WOLALIGHT_CABIN_NIGHT] = {
				typename = "collection",
				lights = {
					{
						typename = "collection",
--							{
--								typename = "omnilight", connector = "PNT_CABIN",
--								color = {0.9, 0.12, 0.07, 0.5}, range = 3.0,
--							},

--							{
--								typename = "Spot", connector = "PNT_CABIN",
--								proto = lamp_prototypes.BANO_7M_red, angle_max = math.rad(160.0), angle_min = math.rad(90.0),
--							},
							{ -- 0 -- Dome Light -- EMBEDDED LIGHT IN MODEL
							  typename = "Argument", argument = 69,
							},

							{
								typename = "omnilight", connector = "PNT_ORIGIN",
								color = {0.9, 0.12, 0.07, 0.5}, range = 2.0,
							},
					},
				},
			},

        },
    },
--Countries = {"RUSSIA", "POLAND", "VENEZUELA", "RED", "BLUE", "USA"},
}


add_aircraft(CLP_O2)
