local function add_dfcp_structure(name, displayName)
    if (name and displayName) then
        GT = {};
        set_recursive_metatable(GT, GT_t.generic_stationary)
        set_recursive_metatable(GT.chassis, GT_t.CH_t.STATIC);

        --Life points of the object
        GT.chassis.life = 50

        --Shape EDM name
        GT.visual.shape = name
        GT.visual.shape_dstr = name

        --Use this name for your folder inside Liveries
        GT.Name = name

        --Name that will appear inside ME
        GT.DisplayName = (displayName)
        GT.Rate = 0

        -- Class/type of object; it will appear as "Structure" inside "Static Objects" in ME
        GT.DetectionRange = 0;
        GT.ThreatRange    = 0;
        GT.mapclasskey    = "P0091000076";
        GT.attribute      = { wsType_Ground, wsType_Standing, wsType_NoWeapon, wsType_GenericFort, "Fortifications", "CustomAimPoint" };
        GT.category       = "Fortification";

        add_surface_unit(GT)
    else
        error("Can't add structure")
    end
end


add_dfcp_structure("dfcp_air_gate", "DFCP Air Gate");
add_dfcp_structure("dfcp_helper_gate_arch", "DFCP Helper Gate Arch");
add_dfcp_structure("dfcp_beeeeg_cone", "DFCP Beeeeg Cone");
add_dfcp_structure("dfcp_big_cone", "DFCP Big Cone");
add_dfcp_structure("dfcp_helper_gate", "DFCP Helper Gate");
add_dfcp_structure("dfcp_helper_gate_100ft", "DFCP Helper Gate 100ft");
add_dfcp_structure("dfcp_helper_gate_200ft", "DFCP Helper Gate 200ft");
add_dfcp_structure("dfcp_helper_gate_300ft", "DFCP Helper Gate 300ft");
add_dfcp_structure("dfcp_helper_gate_400ft", "DFCP Helper Gate 400ft");
add_dfcp_structure("dfcp_helper_gate_500ft", "DFCP Helper Gate 500ft");
add_dfcp_structure("dfcp_helper_gate_600ft", "DFCP Helper Gate 600ft");
add_dfcp_structure("dfcp_helper_gate_700ft", "DFCP Helper Gate 700ft");
add_dfcp_structure("dfcp_helper_gate_800ft", "DFCP Helper Gate 800ft");
add_dfcp_structure("dfcp_helper_gate_900ft", "DFCP Helper Gate 900ft");
add_dfcp_structure("dfcp_helper_gate_1000ft", "DFCP Helper Gate 1000ft");
add_dfcp_structure("dfcp_helper_gate_horizontal_100ft", "DFCP Helper Gate Horizontal 100ft");
add_dfcp_structure("dfcp_helper_gate_horizontal_200ft", "DFCP Helper Gate Horizontal 200ft");
add_dfcp_structure("dfcp_helper_gate_horizontal_300ft", "DFCP Helper Gate Horizontal 300ft");
add_dfcp_structure("dfcp_helper_gate_horizontal_400ft", "DFCP Helper Gate Horizontal 400ft");
add_dfcp_structure("dfcp_helper_gate_horizontal_500ft", "DFCP Helper Gate Horizontal 500ft");
add_dfcp_structure("dfcp_helper_gate_horizontal_600ft", "DFCP Helper Gate Horizontal 600ft");
add_dfcp_structure("dfcp_helper_gate_horizontal_700ft", "DFCP Helper Gate Horizontal 700ft");
add_dfcp_structure("dfcp_helper_gate_horizontal_800ft", "DFCP Helper Gate Horizontal 800ft");
add_dfcp_structure("dfcp_helper_gate_horizontal_900ft", "DFCP Helper Gate Horizontal 900ft");
add_dfcp_structure("dfcp_helper_gate_horizontal_1000ft", "DFCP Helper Gate Horizontal 1000ft");
add_dfcp_structure("dfcp_helper_gate_horizontal_offset", "DFCP Helper Gate Horizontal Offset");


-- local function add_structure(f)
-- 	if(f) then
-- 		f.shape_table_data = 
-- 		{
-- 			{
-- 				file        = f.ShapeName,
-- 				life        = f.Life,
-- 				username    = f.Name,
-- 				desrt       = f.ShapeNameDestr or "self",
-- 			    classname   = f.classname   or "lLandVehicle",
-- 				positioning = f.positioning or "ADD_HEIGTH" -- {"BYNORMAL", "ONLYHEIGTH", "BY_XZ", "ADD_HEIGTH"}
-- 			}
-- 		}
-- 		if f.ShapeNameDestr then
-- 			f.shape_table_data[#f.shape_table_data + 1] = {
-- 				name  = f.ShapeNameDestr,
-- 				file  = f.ShapeNameDestr,	
-- 			}
-- 		end
				
-- 		f.mapclasskey = "P0091000076";
-- 		f.attribute = {wsType_Ground, wsType_Standing, wsType_NoWeapon, wsType_GenericFort, "Fortifications", "CustomAimPoint"};
-- 		add_surface_unit(f)
-- 		GT = nil;
-- 	else
-- 		error("Can't add structure")
-- 	end;
-- end


-- add_structure({
--     DisplayName     = "DFCP Air Gate",
--     Name            = "dfcp_air_gate",
--     ShapeName       = "dfcp_air_gate",
--     ShapeNameDestr  = "dfcp_air_gate",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate Arch",
--     Name            = "dfcp_helper_gate_arch",
--     ShapeName       = "dfcp_helper_gate_arch",
--     ShapeNameDestr  = "dfcp_helper_gate_arch",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Beeeeg Cone",
--     Name            = "dfcp_beeeeg_cone",
--     ShapeName       = "dfcp_beeeeg_cone",
--     ShapeNameDestr  = "dfcp_beeeeg_cone",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Big Cone",
--     Name            = "dfcp_big_cone",
--     ShapeName       = "dfcp_big_cone",
--     ShapeNameDestr  = "dfcp_big_cone",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate",
--     Name            = "dfcp_helper_gate",
--     ShapeName       = "dfcp_helper_gate",
--     ShapeNameDestr  = "dfcp_helper_gate",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate 100ft",
--     Name            = "dfcp_helper_gate_100ft",
--     ShapeName       = "dfcp_helper_gate_100ft",
--     ShapeNameDestr  = "dfcp_helper_gate_100ft",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate 200ft",
--     Name            = "dfcp_helper_gate_200ft",
--     ShapeName       = "dfcp_helper_gate_200ft",
--     ShapeNameDestr  = "dfcp_helper_gate_200ft",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate 300ft",
--     Name            = "dfcp_helper_gate_300ft",
--     ShapeName       = "dfcp_helper_gate_300ft",
--     ShapeNameDestr  = "dfcp_helper_gate_300ft",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate 400ft",
--     Name            = "dfcp_helper_gate_400ft",
--     ShapeName       = "dfcp_helper_gate_400ft",
--     ShapeNameDestr  = "dfcp_helper_gate_400ft",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate 500ft",
--     Name            = "dfcp_helper_gate_500ft",
--     ShapeName       = "dfcp_helper_gate_500ft",
--     ShapeNameDestr  = "dfcp_helper_gate_500ft",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate 600ft",
--     Name            = "dfcp_helper_gate_600ft",
--     ShapeName       = "dfcp_helper_gate_600ft",
--     ShapeNameDestr  = "dfcp_helper_gate_600ft",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate 700ft",
--     Name            = "dfcp_helper_gate_700ft",
--     ShapeName       = "dfcp_helper_gate_700ft",
--     ShapeNameDestr  = "dfcp_helper_gate_700ft",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate 800ft",
--     Name            = "dfcp_helper_gate_800ft",
--     ShapeName       = "dfcp_helper_gate_800ft",
--     ShapeNameDestr  = "dfcp_helper_gate_800ft",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate 900ft",
--     Name            = "dfcp_helper_gate_900ft",
--     ShapeName       = "dfcp_helper_gate_900ft",
--     ShapeNameDestr  = "dfcp_helper_gate_900ft",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate 1000ft",
--     Name            = "dfcp_helper_gate_1000ft",
--     ShapeName       = "dfcp_helper_gate_1000ft",
--     ShapeNameDestr  = "dfcp_helper_gate_1000ft",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate Horizontal 100ft",
--     Name            = "dfcp_helper_gate_horizontal_100ft",
--     ShapeName       = "dfcp_helper_gate_horizontal_100ft",
--     ShapeNameDestr  = "dfcp_helper_gate_horizontal_100ft",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate Horizontal 200ft",
--     Name            = "dfcp_helper_gate_horizontal_200ft",
--     ShapeName       = "dfcp_helper_gate_horizontal_200ft",
--     ShapeNameDestr  = "dfcp_helper_gate_horizontal_200ft",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate Horizontal 300ft",
--     Name            = "dfcp_helper_gate_horizontal_300ft",
--     ShapeName       = "dfcp_helper_gate_horizontal_300ft",
--     ShapeNameDestr  = "dfcp_helper_gate_horizontal_300ft",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate Horizontal 400ft",
--     Name            = "dfcp_helper_gate_horizontal_400ft",
--     ShapeName       = "dfcp_helper_gate_horizontal_400ft",
--     ShapeNameDestr  = "dfcp_helper_gate_horizontal_400ft",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate Horizontal 500ft",
--     Name            = "dfcp_helper_gate_horizontal_500ft",
--     ShapeName       = "dfcp_helper_gate_horizontal_500ft",
--     ShapeNameDestr  = "dfcp_helper_gate_horizontal_500ft",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate Horizontal 600ft",
--     Name            = "dfcp_helper_gate_horizontal_600ft",
--     ShapeName       = "dfcp_helper_gate_horizontal_600ft",
--     ShapeNameDestr  = "dfcp_helper_gate_horizontal_600ft",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate Horizontal 700ft",
--     Name            = "dfcp_helper_gate_horizontal_700ft",
--     ShapeName       = "dfcp_helper_gate_horizontal_700ft",
--     ShapeNameDestr  = "dfcp_helper_gate_horizontal_700ft",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate Horizontal 800ft",
--     Name            = "dfcp_helper_gate_horizontal_800ft",
--     ShapeName       = "dfcp_helper_gate_horizontal_800ft",
--     ShapeNameDestr  = "dfcp_helper_gate_horizontal_800ft",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate Horizontal 900ft",
--     Name            = "dfcp_helper_gate_horizontal_900ft",
--     ShapeName       = "dfcp_helper_gate_horizontal_900ft",
--     ShapeNameDestr  = "dfcp_helper_gate_horizontal_900ft",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate Horizontal 1000ft",
--     Name            = "dfcp_helper_gate_horizontal_1000ft",
--     ShapeName       = "dfcp_helper_gate_horizontal_1000ft",
--     ShapeNameDestr  = "dfcp_helper_gate_horizontal_1000ft",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })
-- add_structure({
--     DisplayName     = "DFCP Helper Gate Horizontal Offset",
--     Name            = "dfcp_helper_gate_horizontal_offset",
--     ShapeName       = "dfcp_helper_gate_horizontal_offset",
--     ShapeNameDestr  = "dfcp_helper_gate_horizontal_offset",
--     Life            = 2,
--     Rate            = 1,
--     category        = "AirRaceEquipment",
--     SeaObject       = false,
--     isPutToWater    = false
-- })

