function weapons_category(clsid, name, displayName, ...)
    local cat = {};
    
    cat.CLSID = clsid;
    cat.Name = name;
    cat.DisplayName = displayName;
    cat.Launchers = {};
    for i, v in ipairs(arg) do
        cat.Launchers[i] = v;
    end
    
    table.insert(db.Weapons.Categories, cat);
end

local weaponNames = {}
local weaponDisplayNames = {}

function launcher(clsid, name, displayName, table, elements)
    local res = {};
    
    res.CLSID = clsid;
    res.Name = name;
    res.displayName = displayName
    for k, v in pairs(table) do res[k] = v; end
    res.Elements = elements;
    
    if (weaponNames[clsid]) then
        error("Duplicate launcher: " .. clsid);
    end
    
    weaponNames[clsid] = name;
    weaponDisplayNames[clsid] = displayName
    
    return res;
end

function get_weapon_name_by_clsid(clsid)
    if (weaponNames[clsid] == nil) then
        error("No weapon name for: " .. clsid);
    end
    
    return weaponNames[clsid];
end

function get_weapon_display_name_by_clsid(clsid)
    if (weaponDisplayNames[clsid] == nil) then
        error("No weapon name for: " .. clsid);
    end
    
    return weaponDisplayNames[clsid];
end

function req_launcher(clsid, name)
    return { CLSID = clsid, Name = name };
end

function element(shape, x, y, z, ...)
    local res = {};
    
    res.Position = {};
    res.Position.X = x;
    res.Position.Y = y;
    res.Position.Z = z;
    res.DrawArgs = {};
    res.ShapeName = shape;
    
    for _, v in ipairs(arg) do
        table.insert(res.DrawArgs, v);
    end
    
    return res;
end

function drawarg(key, value)
    return { Key = key, Value = value };    
end

db.Weapons = {};
db.Weapons.Categories = {};

db.Weapons.DefaultCategories = 
{
    {
        CLSID = "{60EA8FAC-2EF6-4308-83EA-92AB84BD134F}",
        Name = "Weapon",
    }
}

local lau_88_shift_x = 0.29

weapons_category("{839A9F02-9F52-4a61-9E40-7A4A59975703}", "BOMBS", _("BOMBS"),
--[[    launcher("{96A7F676-F956-404A-AD04-F33FB2C74885}", "BetAB-250", _("BetAB-250"), 
        {
            Picture = "BETAB.png",
            WorldID = "1",
            Weight = "210",
            Guided = "no",
        },
        {
            element("BETAB-250", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),]]

    launcher("{35B698AC-9FEF-4EC4-AD29-484A0085F62B}", "BetAB-500", _("BetAB-500"), 
        {
            Picture = "betab500.png",
            WorldID = "1",
            Weight = "430",
            Guided = "no",
        },
        {
            element("BETAB-500", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{BD289E34-DF84-4C5E-9220-4B14C346E79D}", "BetAB-500ShP", _("BetAB-500ShP"), 
        {
            Picture = "betab500shp.png",
            WorldID = "1",
            Weight = "424",
            Guided = "no",
        },
        {
            element("BETAB-500SP", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{FB3CE165-BF07-4979-887C-92B87F13276B}", "FAB-100", _("FAB-100"), 
        {
            Picture = "FAB100.png",
            WorldID = "1",
            Weight = "100",
            Guided = "no",
        },
        {
            element("FAB-100", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{0511E528-EA28-4caf-A212-00D1408DF10A}", "SAB-100", _("SAB-100"), 
        {
            Picture = "sab100.png",
            WorldID = "1",
            Weight = "100",
            Guided = "no",
        },
        {
            element("SAB-100", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{3C612111-C7AD-476E-8A8E-2485812F4E5C}", "FAB-250", _("FAB-250"), 
        {
            Picture = "FAB250.png",
            WorldID = "1",
            Weight = "250",
            Guided = "no",
        },
        {
            element("FAB-250-N1", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{37DCC01E-9E02-432F-B61D-10C166CA2798}", "FAB-500 M62", _("FAB-500 M62"), 
        {
            Picture = "FAB500.png",
            WorldID = "1",
            Weight = "506",
            Guided = "no",
        },
        {
            element("FAB-500-N3", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

--[[    launcher("{4BEDA482-2C83-41A6-A174-83B4F24B4A6F}", "FAB-500P", _("FAB-500P"), 
        {
            Picture = "FAB500.png",
            WorldID = "1",
            Weight = "500",
            Guided = "no",
        },
        {
            element("FAB-500-N3", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),]]

    launcher("{40AA4ABE-D6EB-4CD6-AEFE-A1A0477B24AB}", "FAB-1500 M54", _("FAB-1500 M54"), 
        {
            Picture = "FAB1500.png",
            WorldID = "1",
            Weight = "1392",
            Guided = "no",
        },
        {
            element("FAB-1500", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{BA565F89-2373-4A84-9502-A0E017D3A44A}", "KAB-500L", _("KAB-500L"), 
        {
            Picture = "KAB500.png",
            WorldID = "1",
            Weight = "534",
            Guided = "no",
        },
        {
            element("KAB-500", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{E2C426E3-8B10-4E09-B733-9CDC26520F48}", "KAB-500kr", _("KAB-500kr"), 
        {
            Picture = "kab500lpr.png",
            WorldID = "1",
            Weight = "560",
            Guided = "no",
        },
        {
            element("KAB-500T", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{39821727-F6E2-45B3-B1F0-490CC8921D1E}", "KAB-1500L", _("KAB-1500L"), 
        {
            Picture = "KAB1500.png",
            WorldID = "1",
            Weight = "1560",
            Guided = "no",
        },
        {
            element("KAB-1500", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

--[[    launcher("{023479E5-5C3C-4D11-B3D6-15D6E8BD5656}", "ODAB-500PM", _("ODAB-500PM"), 
        {
            Picture = "FAB250.png",
            WorldID = "1",
            Weight = "520",
            Guided = "no",
        },
        {
            element("ODAB", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),]]

--[[    launcher("{DF7A9A1F-6045-44BE-8F87-25D48CA5FC53}", "ZAB-500", _("ZAB-500"), 
        {
            Picture = "RBK250.png",
            WorldID = "1",
            Weight = "500",
            Guided = "no",
        },
        {
            element("ZAB-500", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),]]

    launcher("{4203753F-8198-4E85-9924-6F8FF679F9FF}", "RBK-250 PTAB-2.5M", _("RBK-250 PTAB-2.5M"), 
        {
            Picture = "RBK250.png",
            WorldID = "1",
            Weight = "273",
            Guided = "no",
        },
        {
            element("RBK-250", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{D5435F26-F120-4FA3-9867-34ACE562EF1B}", "RBK-500 PTAB-10-5", _("RBK-500 PTAB-10-5"), 
        {
            Picture = "RBK500.png",
            WorldID = "1",
            Weight = "427",
            Guided = "no",
        },
        {
            element("RBK-500AO", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{90321C8E-7ED1-47D4-A160-E074D5ABD902}", "Mk-81", _("Mk-81"), 
        {
            Picture = "FAB100.png",
            WorldID = "1",
            Weight = "118",
            Guided = "no",
        },
        {
            element("MK-81", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{BCE4E030-38E9-423E-98ED-24BE3DA87C32}", "Mk-82", _("Mk-82"), 
        {
            Picture = "FAB250.png",
            WorldID = "1",
            Weight = "241",
            Guided = "no",
        },
        {
            element("MK-82", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}", "Mk-83", _("Mk-83"), 
        {
            Picture = "FAB250.png",
            WorldID = "1",
            Weight = "447",
            Guided = "no",
        },
        {
            element("MK-83", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}", "Mk-84", _("Mk-84"), 
        {
            Picture = "FAB250.png",
            WorldID = "1",
            Weight = "894",
            Guided = "no",
        },
        {
            element("MK-84", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{00F5DAC4-0466-4122-998F-B1A298E34113}", "M-117", _("M-117"), 
        {
            Picture = "KMGU2.png",
            WorldID = "1",
            Weight = "340",
            Guided = "no",
        },
        {
            element("M-117", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{08164777-5E9C-4B08-B48E-5AA7AFB246E2}", "BL755", _("BL755"), 
        {
            Picture = "BL755.png",
            WorldID = "1",
            Weight = "264",
            Guided = "no",
        },
        {
            element("T-BL-755", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{752B9781-F962-11d5-9190-00A0249B6F00}", "BLU-107", _("BLU-107"), 
        {
            Picture = "blu107.png",
            WorldID = "1",
            Weight = "185",
            Guided = "no",
        },
        {
            element("DURANDAL", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

--[[    launcher("{5335D97A-35A5-4643-9D9B-026C75961E52}", "CBU-97", _("CBU-97"), 
        {
            Picture = "RBK250.png",
            WorldID = "1",
            Weight = "420",
            Guided = "no",
        },
        {
            element("CBU-97", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),]]

    launcher("{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}", "GBU-10", _("GBU-10"), 
        {
            Picture = "GBU10.png",
            WorldID = "1",
            Weight = "1162",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
                req_launcher("{CAAC1CFD-6745-416B-AFA4-CB57414856D0}", "Lantirn F-16"),
            },
        },
        {
            element("GBU-10", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{DB769D48-67D7-42ED-A2BE-108D566C8B1E}", "GBU-12", _("GBU-12"), 
        {
            Picture = "GBU12.png",
            WorldID = "1",
            Weight = "362",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
                req_launcher("{CAAC1CFD-6745-416B-AFA4-CB57414856D0}", "Lantirn F-16"),
            },
        },
        {
            element("GBU-12", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{0D33DDAE-524F-4A4E-B5B8-621754FE3ADE}", "GBU-16", _("GBU-16"), 
        {
            Picture = "GBU16.png",
            WorldID = "1",
            Weight = "564",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
            },
        },
        {
            element("GBU-16", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{FAAFA032-8996-42BF-ADC4-8E2C86BCE536}", "GBU-15", _("GBU-15"), 
        {
            Picture = "GBU16.png",
            WorldID = "1",
            Weight = "1140",
            Guided = "no",
        },
        {
            element("GBU-15", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{34759BBC-AF1E-4AEE-A581-498FF7A6EBCE}", "GBU-24", _("GBU-24"), 
        {
            Picture = "GBU27.png",
            WorldID = "1",
            Weight = "900",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
            },
        },
        {
            element("GBU-24", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{EF0A9419-01D6-473B-99A3-BEBDB923B14D}", "GBU-27", _("GBU-27"), 
        {
            Picture = "GBU27.png",
            WorldID = "1",
            Weight = "1200",
            Guided = "no",
        },
        {
            element("GBU-27", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{F06B775B-FC70-44B5-8A9F-5B5E2EB839C7}", "GBU-28", _("GBU-28"), 
        {
            Picture = "GBU27.png",
            WorldID = "1",
            Weight = "2130",
            Guided = "no",
        },
        {
            element("GBU-28", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}", "Mk20", _("Mk20"), 
        {
            Picture = "PTB.png",
            WorldID = "1",
            Weight = "222",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
            },
        },
        {
            element("ROCKEYE", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

--[[    launcher("{897D4395-EE32-4BF4-B225-A6B45383E74A}", "PLAB-100", _("PLAB-100"), 
        {
            Picture = ".png",
            WorldID = "1",
            Weight = "0",
            Guided = "no",
        },
        {
        }
    ),

    launcher("{4603A9D4-D1C1-4453-A098-06ECEC4E1CBC}", "APR-1", _("APR-1"), 
        {
            Picture = "BETAB.png",
            WorldID = "1",
            Weight = "0",
            Guided = "no",
        },
        {
        }
    ),

    launcher("{CAE9EC23-578E-478A-A772-7E9E7A6AA4FD}", "MK-50", _("MK-50"), 
        {
            Picture = "BETAB.png",
            WorldID = "1",
            Weight = "0",
            Guided = "no",
        },
        {
        }
    ),]]

    launcher("{C40A1E3A-DD05-40D9-85A4-217729E37FAE}", "AGM-62", _("AGM-62"), 
        {
            Picture = "agm119.png",
            WorldID = "1",
            Weight = "1088",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
            },
        },
        {
            element("AGM-62", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),


    launcher("{95334A8C-6ACB-4CB7-99BC-6D07B1479EDA}", "MER*6 Mk-81", _("MER*6 Mk-81"), 
        {
            Picture = "FAB500.png",
            Count = 6,
            WorldID = "2",
            Weight = "768",
            Guided = "no",
        },
        {
            element("MBD", 0.000000, 0.000000, 0.000000),
            element("MK-81", -1.242000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("MK-81", 1.190000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("MK-81", -1.242000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("MK-81", -1.242000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("MK-81", 1.190000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("MK-81", 1.190000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}", "MER*6 FAB-100", _("MER*6 FAB-100"), 
        {
            Picture = "FAB100.png",
            Count = 6,
            WorldID = "2",
            Weight = "660",
            Guided = "no",
        },
        {
            element("MBD", 0.000000, 0.000000, 0.000000),
            element("FAB-100", -1.242000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-100", 1.190000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-100", -1.242000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("FAB-100", -1.242000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("FAB-100", 1.190000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("FAB-100", 1.190000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{53BE25A4-C86C-4571-9BC0-47D668349595}", "MER*6 FAB-250", _("MER*6 FAB-250"), 
        {
            Picture = "FAB250.png",
            Count = 6,
            WorldID = "2",
            Weight = "1560",
            Guided = "no",
        },
        {
            element("MBD", 0.000000, 0.000000, 0.000000),
            element("FAB-250-N1", -1.242000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-250-N1", 1.190000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-250-N1", -1.242000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("FAB-250-N1", -1.242000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("FAB-250-N1", 1.190000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("FAB-250-N1", 1.190000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{E659C4BE-2CD8-4472-8C08-3F28ACB61A8A}", "MER 6*2 FAB-250", _("MER 6*2 FAB-250"), 
        {
            Picture = "FAB250.png",
            Count = 2,
            WorldID = "2",
            Weight = "550",
            Guided = "no",
        },
        {
            element("MBD", 0.000000, 0.000000, 0.000000),
            element("FAB-250-N1", -1.242000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-250-N1", 1.190000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{3E35F8C1-052D-11d6-9191-00A0249B6F00}", "MER 6*4 FAB-250", _("MER 6*4 FAB-250"), 
        {
            Picture = "FAB250.png",
            Count = 4,
            WorldID = "2",
            Weight = "1060",
            Guided = "no",
        },
        {
            element("MBD", 0.000000, 0.000000, 0.000000),
            element("FAB-250-N1", -1.242000, -0.270000, 0.306000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("FAB-250-N1", 1.190000, -0.270000, 0.306000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("FAB-250-N1", -1.242000, -0.270000, -0.306000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("FAB-250-N1", 1.190000, -0.270000, -0.306000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

--[[    launcher("{79F3F0B6-3E00-4B05-9267-67B7E6AEA00E}", "MER 6*2 BetAB-250", _("MER 6*2 BetAB-250"), 
        {
            Picture = "BETAB.png",
            WorldID = "2",
            Weight = "550",
            Guided = "no",
        },
        {
            element("MBD", 0.000000, 0.000000, 0.000000),
            element("BETAB-250", -1.242000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("BETAB-250", 1.190000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),]]

    launcher("{FA673F4C-D9E4-4993-AA7A-019A92F3C005}", "MER*6 FAB-500", _("MER*6 FAB-500"), 
        {
            Picture = "FAB500.png",
            Count = 6,
            WorldID = "2",
            Weight = "3060",
            Guided = "no",
        },
        {
            element("MBD", 0.000000, 0.000000, 0.000000),
            element("FAB-500-N3", -1.242000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-500-N3", 1.190000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-500-N3", -1.242000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("FAB-500-N3", -1.242000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("FAB-500-N3", 1.190000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("FAB-500-N3", 1.190000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

--[[    launcher("{C57AA721-4000-4D83-A47D-A7756A5B02D1}", "MER*6 BetAB-250", _("MER*6 BetAB-250"), 
        {
            Picture = "BETAB.png",
            WorldID = "2",
            Weight = "1560",
            Guided = "no",
        },
        {
            element("MBD", 0.000000, 0.000000, 0.000000),
            element("BETAB-250", -1.242000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("BETAB-250", 1.190000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("BETAB-250", -1.242000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("BETAB-250", -1.242000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("BETAB-250", 1.190000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("BETAB-250", 1.190000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),]]

    launcher("{F503C276-FE15-4C54-B310-17B50B735A84}", "MER*6 RBK-500 PTAB-2.5M", _("MER*6 RBK-500 PTAB-2.5M"), 
        {
            Picture = "RBK500.png",
            Count = 6,
            WorldID = "2",
            Weight = "3060",
            Guided = "no",
        },
        {
            element("TU-22M3-MBD", 0.000000, 0.000000, 0.000000),
            element("RBK-500AO", -2.199000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("RBK-500AO", 2.199000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("RBK-500AO", -2.199000, -0.206000, 0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("RBK-500AO", -2.199000, -0.206000, -0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("RBK-500AO", 2.199000, -0.206000, 0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("RBK-500AO", 2.199000, -0.206000, -0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

--[[    launcher("{1AD2B3A9-4F97-41FD-8AF2-8C716C40B9F9}", "MER*6 ODAB-500PM", _("MER*6 ODAB-500PM"), 
        {
            Picture = "FAB250.png",
            WorldID = "2",
            Weight = "3180",
            Guided = "no",
        },
        {
            element("MBD", 0.000000, 0.000000, 0.000000),
            element("ODAB", -1.242000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("ODAB", 1.190000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("ODAB", -1.242000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("ODAB", -1.242000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("ODAB", 1.190000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("ODAB", 1.190000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),]]

--[[    launcher("{6389A1C7-BE31-4BF3-A98E-AE7D370C6AF4}", "MER*6 CBU-97", _("MER*6 CBU-97"), 
        {
            Picture = "RBK250.png",
            WorldID = "2",
            Weight = "2760",
            Guided = "no",
        },
        {
            element("MBD", 0.000000, 0.000000, 0.000000),
            element("CBU-97", -1.242000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("CBU-97", 1.190000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("CBU-97", -1.242000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("CBU-97", -1.242000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("CBU-97", 1.190000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("CBU-97", 1.190000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),]]

    launcher("{6CDB6B36-7165-47D0-889F-6625FB333561}", "MER*6 M-117AB", _("MER*6 M-117AB"), 
        {
            Picture = "RBK250.png",
            Count = 6,
            WorldID = "2",
            Weight = "2100",
            Guided = "no",
        },
        {
            element("MBD", 0.000000, 0.000000, 0.000000),
            element("M-117", -1.242000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("M-117", 1.190000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("M-117", -1.242000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("M-117", -1.242000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("M-117", 1.190000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("M-117", 1.190000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{1C97B4A0-AA3B-43A8-8EE7-D11071457185}", "MER*6 Mk-82", _("MER*6 Mk-82"), 
        {
            Picture = "FAB250.png",
            Count = 6,
            WorldID = "2",
            Weight = "1506",
            Guided = "no",
        },
        {
            element("MBD", 0.000000, 0.000000, 0.000000),
            element("MK-82", -1.242000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("MK-82", 1.190000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("MK-82", -1.242000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("MK-82", -1.242000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("MK-82", 1.190000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("MK-82", 1.190000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{3C7CD675-7D39-41C5-8735-0F4F537818A8}", "MER*6 Mk-20 Rockeye", _("MER*6 Mk-20 Rockeye"), 
        {
            Picture = "rockeye.png",
            Count = 6,
            WorldID = "2",
            Weight = "1392",
            Guided = "no",
        },
        {
            element("MBD", 0.000000, 0.000000, 0.000000),
            element("ROCKEYE", -1.242000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("ROCKEYE", 1.190000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("ROCKEYE", -1.242000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("ROCKEYE", -1.242000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("ROCKEYE", 1.190000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("ROCKEYE", 1.190000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{752B9782-F962-11d5-9190-00A0249B6F00}", "MER*6 BLU-107", _("MER*6 BLU-107"), 
        {
            Picture = "blu107.png",
            Count = 6,
            WorldID = "2",
            Weight = "1800",
            Guided = "no",
        },
        {
            element("MBD", 0.000000, 0.000000, 0.000000),
            element("DURANDAL", -1.242000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("DURANDAL", 1.190000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("DURANDAL", -1.242000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("DURANDAL", -1.242000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("DURANDAL", 1.190000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("DURANDAL", 1.190000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{A1E85991-B58E-4E92-AE91-DED6DC85B2E7}", "MER-3*3 FAB-500", _("MER-3*3 FAB-500"), 
        {
            Picture = "FAB500.png",
            Count = 3,
            WorldID = "2",
            Weight = "1560",
            Guided = "no",
        },
        {
            element("MBD-3", 0.000000, 0.000000, 0.000000),
            element("FAB-500-N3", 0.000000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-500-N3", 0.000000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("FAB-500-N3", 0.000000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

--[[    launcher("{59E49F29-26BD-4BF0-86A6-1ECECC43891D}", "MER-3*3 BetAB-250", _("MER-3*3 BetAB-250"), 
        {
            Picture = "BETAB.png",
            WorldID = "2",
            Weight = "810",
            Guided = "no",
        },
        {
            element("MBD-3", 0.000000, 0.000000, 0.000000),
            element("BETAB-250", 0.000000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("BETAB-250", 0.000000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("BETAB-250", 0.000000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),]]

    launcher("{005E70F5-C3EA-4E95-A148-C1044C42D845}", "MER-3*3 BetAB-500", _("MER-3*3 BetAB-500"), 
        {
            Picture = "betab500.png",
            Count = 3,
            WorldID = "2",
            Weight = "1566",
            Guided = "no",
        },
        {
            element("MBD-3", 0.000000, 0.000000, 0.000000),
            element("BETAB-500", 0.000000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("BETAB-500", 0.000000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("BETAB-500", 0.000000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{EAD9B2C1-F3BA-4A7B-A2A5-84E2AF8A1975}", "MER-3*3 RBK-250 PTAB-1M", _("MER-3*3 RBK-250 PTAB-1M"), 
        {
            Picture = "RBK250.png",
            Count = 3,
            WorldID = "2",
            Weight = "885",
            Guided = "no",
        },
        {
            element("MBD-3", 0.000000, 0.000000, 0.000000),
            element("RBK-250", 0.000000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("RBK-250", 0.000000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("RBK-250", 0.000000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{CEE04106-B9AA-46B4-9CD1-CD3FDCF0CE78}", "MER-3*3 FAB-100", _("MER-3*3 FAB-100"), 
        {
            Picture = "FAB100.png",
            Count = 3,
            WorldID = "2",
            Weight = "360",
            Guided = "no",
        },
        {
            element("MBD-3", 0.000000, 0.000000, 0.000000),
            element("FAB-100", 0.000000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-100", 0.000000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("FAB-100", 0.000000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{D109EE9C-A1B7-4F1C-8D87-631C293A1D26}", "MER-3*3 FAB-250", _("MER-3*3 FAB-250"), 
        {
            Picture = "FAB250.png",
            Count = 3,
            WorldID = "2",
            Weight = "810",
            Guided = "no",
        },
        {
            element("MBD-3", 0.000000, 0.000000, 0.000000),
            element("FAB-250-N1", 0.000000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-250-N1", 0.000000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("FAB-250-N1", 0.000000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{919CE839-9390-4629-BAF7-229DE19B8523}", "MER-3*3 RBK-500 PTAB-2.5M", _("MER-3*3 RBK-500 PTAB-2.5M"), 
        {
            Picture = "RBK500.png",
            Count = 3,
            WorldID = "2",
            Weight = "1560",
            Guided = "no",
        },
        {
            element("MBD-3", 0.000000, 0.000000, 0.000000),
            element("RBK-500AO", 0.000000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("RBK-500AO", 0.000000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("RBK-500AO", 0.000000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

--[[    launcher("{E6D89769-4EDD-4334-A616-C99EB2D45852}", "MER-3*3 ODAB-500PM", _("MER-3*3 ODAB-500PM"), 
        {
            Picture = "FAB250.png",
            WorldID = "2",
            Weight = "1620",
            Guided = "no",
        },
        {
            element("MBD-3", 0.000000, 0.000000, 0.000000),
            element("ODAB", 0.000000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("ODAB", 0.000000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("ODAB", 0.000000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),]]

--[[    launcher("{615BD817-6538-4CE1-84F5-10C9B3FDBC50}", "MER-3*3-ZAB-500", _("MER-3*3-ZAB-500"), 
        {
            Picture = "RBK250.png",
            WorldID = "2",
            Weight = "1185",
            Guided = "no",
        },
        {
            element("MBD-3", 0.000000, 0.000000, 0.000000),
            element("Z-BAK-N3", 0.000000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("Z-BAK-N3", 0.000000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("Z-BAK-N3", 0.000000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),]]

--[[    launcher("{F3E2C806-CD30-42A9-8410-3F4030CF45D1}", "MER-3*3 CBU-97", _("MER-3*3 CBU-97"), 
        {
            Picture = "RBK250.png",
            WorldID = "2",
            Weight = "1410",
            Guided = "no",
        },
        {
            element("MBD-3", 0.000000, 0.000000, 0.000000),
            element("CBU-97", 0.000000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("CBU-97", 0.000000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("CBU-97", 0.000000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),]]

    launcher("{82F90BEC-0E2E-4CE5-A66E-1E4ADA2B5D1E}", "MER-3*3 M-117AB", _("MER-3*3 M-117AB"), 
        {
            Picture = "RBK250.png",
            Count = 3,
            WorldID = "2",
            Weight = "1060",
            Guided = "no",
        },
        {
            element("MBD-3", 0.000000, 0.000000, 0.000000),
            element("M-117", 0.000000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("M-117", 0.000000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("M-117", 0.000000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{7B34E0BB-E427-4C2A-A61A-8407CE18B54D}", "MER-3*3 Mk-81", _("MER-3*3 Mk-81"), 
        {
            Picture = "FAB250.png",
            Count = 3,
            WorldID = "2",
            Weight = "414",
            Guided = "no",
        },
        {
            element("MBD-3", 0.000000, 0.000000, 0.000000),
            element("MK-81", 0.000000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("MK-81", 0.000000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("MK-81", 0.000000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{60CC734F-0AFA-4E2E-82B8-93B941AB11CF}", "MER-3*3 Mk-82", _("MER-3*3 Mk-82"), 
        {
            Picture = "FAB250.png",
            Count = 3,
            WorldID = "2",
            Weight = "783",
            Guided = "no",
        },
        {
            element("MBD-3", 0.000000, 0.000000, 0.000000),
            element("MK-82", 0.000000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("MK-82", 0.000000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("MK-82", 0.000000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{B83CB620-5BBE-4BEA-910C-EB605A327EF9}", "MER-3*3 Mk20 Rockeye", _("MER-3*3 Mk20 Rockeye"), 
        {
            Picture = "rockeye.png",
            Count = 3,
            WorldID = "2",
            Weight = "726",
            Guided = "no",
        },
        {
            element("MBD-3", 0.000000, 0.000000, 0.000000),
            element("ROCKEYE", 0.000000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("ROCKEYE", 0.000000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("ROCKEYE", 0.000000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{88D49E04-78DF-4F08-B47E-B81247A9E3C5}", "MER-3*3 GBU-16", _("MER-3*3 GBU-16"), 
        {
            Picture = "GBU16.png",
            Count = 3,
            WorldID = "2",
            Weight = "666",
            Guided = "no",
        },
        {
            element("MBD-3", 0.000000, 0.000000, 0.000000),
            element("GBU-16", 0.000000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("GBU-16", 0.000000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("GBU-16", 0.000000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{5A1AC2B4-CA4B-4D09-A1AF-AC52FBC4B60B}", "MER-4*4 FAB-100", _("MER-4*4 FAB-100"), 
        {
            Picture = "FAB100.png",
            Count = 4,
            WorldID = "2",
            Weight = "460",
            Guided = "no",
        },
        {
            element("MBD-4", 0.000000, 0.000000, 0.000000),
            element("FAB-100", -0.527000, -0.068000, 0.156000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-100", 0.700000, -0.068000, 0.156000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-100", -0.527000, -0.068000, -0.156000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-100", 0.700000, -0.068000, -0.156000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{5F1C54C0-0ABD-4868-A883-B52FF9FCB422}", "MER*9 FAB-100", _("MER*9 FAB-100"), 
        {
            Picture = "FAB100.png",
            Count = 9,
            WorldID = "2",
            Weight = "960",
            Guided = "no",
        },
        {
            element("TU-22M3-MBD", 0.000000, 0.000000, 0.000000),
            element("FAB-100", -2.199000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-100", 0.000000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-100", 2.199000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-100", -2.199000, -0.206000, 0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("FAB-100", -2.199000, -0.206000, -0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("FAB-100", 0.000000, -0.206000, 0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("FAB-100", 0.000000, -0.206000, -0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("FAB-100", 2.199000, -0.206000, 0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("FAB-100", 2.199000, -0.206000, -0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{E1AAE713-5FC3-4CAA-9FF5-3FDCFB899E33}", "MER*9 FAB-250", _("MER*9 FAB-250"), 
        {
            Picture = "FAB250.png",
            Count = 9,
            WorldID = "2",
            Weight = "2310",
            Guided = "no",
        },
        {
            element("TU-22M3-MBD", 0.000000, 0.000000, 0.000000),
            element("FAB-250-N1", -2.199000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-250-N1", 0.000000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-250-N1", 2.199000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-250-N1", -2.199000, -0.206000, 0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("FAB-250-N1", -2.199000, -0.206000, -0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("FAB-250-N1", 0.000000, -0.206000, 0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("FAB-250-N1", 0.000000, -0.206000, -0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("FAB-250-N1", 2.199000, -0.206000, 0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("FAB-250-N1", 2.199000, -0.206000, -0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

--[[    launcher("{055D451B-5B2A-4AE5-AFD7-26456E5FEE0D}", "MER*9 BetAB-250", _("MER*9 BetAB-250"), 
        {
            Picture = "BETAB.png",
            WorldID = "2",
            Weight = "2310",
            Guided = "no",
        },
        {
            element("TU-22M3-MBD", 0.000000, 0.000000, 0.000000),
            element("BETAB-250", -2.199000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("BETAB-250", 0.000000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("BETAB-250", 2.199000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("BETAB-250", -2.199000, -0.206000, 0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("BETAB-250", -2.199000, -0.206000, -0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("BETAB-250", 0.000000, -0.206000, 0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("BETAB-250", 0.000000, -0.206000, -0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("BETAB-250", 2.199000, -0.206000, 0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("BETAB-250", 2.199000, -0.206000, -0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),]]

    launcher("{BF83E8FD-E7A2-40D2-9608-42E13AFE2193}", "MER*9 RBK-250 PTAB-1M", _("MER*9 RBK-250 PTAB-1M"), 
        {
            Picture = "RBK250.png",
            Count = 9,
            WorldID = "2",
            Weight = "2535",
            Guided = "no",
        },
        {
            element("TU-22M3-MBD", 0.000000, 0.000000, 0.000000),
            element("FAB-250-N1", -2.199000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-250-N1", 0.000000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-250-N1", 2.199000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-250-N1", -2.199000, -0.206000, 0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("FAB-250-N1", -2.199000, -0.206000, -0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("FAB-250-N1", 0.000000, -0.206000, 0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("FAB-250-N1", 0.000000, -0.206000, -0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("FAB-250-N1", 2.199000, -0.206000, 0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("FAB-250-N1", 2.199000, -0.206000, -0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{0D945D78-542C-4E9B-9A17-9B5008CC8D39}", "MER*6 FAB-500", _("MER*6 FAB-500"), 
        {
            Picture = "FAB500.png",
            Count = 6,
            WorldID = "2",
            Weight = "3060",
            Guided = "no",
        },
        {
            element("TU-22M3-MBD", 0.000000, 0.000000, 0.000000),
            element("FAB-500-N3", -2.199000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-500-N3", 2.199000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-500-N3", -2.199000, -0.206000, 0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("FAB-500-N3", -2.199000, -0.206000, -0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("FAB-500-N3", 2.199000, -0.206000, 0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("FAB-500-N3", 2.199000, -0.206000, -0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{436C6FB9-8BF2-46B6-9DC4-F55ABF3CD1EC}", "MER*6 BetAB-500", _("MER*6 BetAB-500"), 
        {
            Picture = "betab500.png",
            Count = 6,
            WorldID = "2",
            Weight = "3060",
            Guided = "no",
        },
        {
            element("TU-22M3-MBD", 0.000000, 0.000000, 0.000000),
            element("BETAB-500", -2.199000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("BETAB-500", 2.199000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("BETAB-500", -2.199000, -0.206000, 0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("BETAB-500", -2.199000, -0.206000, -0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("BETAB-500", 2.199000, -0.206000, 0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("BETAB-500", 2.199000, -0.206000, -0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{E96E1EDD-FF3F-47CF-A959-576C3B682955}", "MER*6 BetAB-500SP", _("MER*6 BetAB-500SP"), 
        {
            Picture = "betab500shp.png",
            Count = 6,
            WorldID = "2",
            Weight = "3060",
            Guided = "no",
        },
        {
            element("TU-22M3-MBD", 0.000000, 0.000000, 0.000000),
            element("BETAB-500SP", -2.199000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("BETAB-500SP", 2.199000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("BETAB-500SP", -2.199000, -0.206000, 0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("BETAB-500SP", -2.199000, -0.206000, -0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("BETAB-500SP", 2.199000, -0.206000, 0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("BETAB-500SP", 2.199000, -0.206000, -0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{4D459A95-59C0-462F-8A57-34E80697F38B}", "MER*6 RBK-500 PTAB-2.5M", _("MER*6 RBK-500 PTAB-2.5M"), 
        {
            Picture = "RBK500.png",
            Count = 6,
            WorldID = "2",
            Weight = "3060",
            Guided = "no",
        },
        {
            element("MBD", 0.000000, 0.000000, 0.000000),
            element("RBK-500AO", -1.242000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("RBK-500AO", 1.190000, -0.415000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("RBK-500AO", -1.242000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("RBK-500AO", -1.242000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("RBK-500AO", 1.190000, -0.266000, 0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("RBK-500AO", 1.190000, -0.266000, -0.293000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

--[[    launcher("{E1FF2417-5C0C-4A48-A616-40B908D3CD6A}", "MER*6 ODAB-500PM", _("MER*6 ODAB-500PM"), 
        {
            Picture = "FAB250.png",
            WorldID = "2",
            Weight = "3180",
            Guided = "no",
        },
        {
            element("TU-22M3-MBD", 0.000000, 0.000000, 0.000000),
            element("ODAB", -2.199000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("ODAB", 2.199000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("ODAB", -2.199000, -0.206000, 0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("ODAB", -2.199000, -0.206000, -0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("ODAB", 2.199000, -0.206000, 0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("ODAB", 2.199000, -0.206000, -0.125000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),]]

    launcher("{7C5F0F5F-0A0B-46E8-937C-8922303E39A8}", "MER*2 FAB-1500", _("MER*2 FAB-1500"), 
        {
            Picture = "FAB1500.png",
            Count = 2,
            WorldID = "2",
            Weight = "3100",
            Guided = "no",
        },
        {
            element("TU-22M3-MBD", 0.000000, 0.000000, 0.000000),
            element("FAB-1500", -2.199000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-1500", 2.199000, -0.419000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{D5D51E24-348C-4702-96AF-97A714E72697}", "MER*2 MK-82", _("MER*2 MK-82"), 
        {
            Picture = "FAB250.png",
            Count = 2,
            WorldID = "2",
            Weight = "200",
            Guided = "no",
        },
        {
            element("MER2", 0.000000, 0.000000, 0.000000),
            element("MK-82", 0.132000, -0.161000, 0.298000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("MK-82", 0.132000, -0.161000, -0.298000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{18617C93-78E7-4359-A8CE-D754103EDF63}", "MER*2 MK-83", _("MER*2 MK-83"), 
        {
            Picture = "FAB250.png",
            Count = 2,
            WorldID = "2",
            Weight = "200",
            Guided = "no",
        },
        {
            element("MER2", 0.000000, 0.000000, 0.000000),
            element("MK-83", 0.132000, -0.161000, 0.298000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("MK-83", 0.132000, -0.161000, -0.298000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{C535596E-F7D2-4301-8BB4-B1658BB87ED7}", "BL-755*2", _("BL-755*2"), 
        {
            Picture = "BL755.png",
            Count = 2,
            WorldID = "2",
            Weight = "200",
            Guided = "no",
        },
        {
            element("", 0.000000, 0.000000, 0.000000),
            element("T-BL-755", 1.320000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("T-BL-755", -1.320000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{0B9ABA77-93B8-45FC-9C63-82AFB2CB50A4}", "MER*2 Mk20 Rockeye", _("MER*2 Mk20 Rockeye"), 
        {
            Picture = "rockeye.png",
            Count = 2,
            WorldID = "2",
            Weight = "200",
            Guided = "no",
        },
        {
            element("MER2", 0.000000, 0.000000, 0.000000),
            element("ROCKEYE", 0.132000, -0.161000, 0.298000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("ROCKEYE", 0.132000, -0.161000, -0.298000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{E79759F7-C622-4AA4-B1EF-37639A34D924}", "Mk-20 Rockeye *6", _("Mk-20 Rockeye *6"), 
        {
            Picture = "rockeye.png",
            WorldID = "3",
            Weight = "1332",
            Guided = "no",
        },
        {
            element("ROCKEYE", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{02B81892-7E24-4795-84F9-B8110C641AF0}", "MER*4 RBK-250 PTAB-1M", _("MER*4 RBK-250 PTAB-1M"), 
        {
            Picture = "RBK250.png",
            Count = 4,
            WorldID = "2",
            Weight = "1060",
            Guided = "no",
        },
        {
            element("MBD-4", 0.000000, 0.000000, 0.000000),
            element("RBK-250", -1.127000, -0.068000, 0.156000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("RBK-250", 0.850000, -0.068000, 0.156000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("RBK-250", -1.127000, -0.068000, -0.156000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("RBK-250", 0.850000, -0.068000, -0.156000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{6A367BB4-327F-4A04-8D9E-6D86BDC98E7E}", "MER*4 FAB-250", _("MER*4 FAB-250"), 
        {
            Picture = "FAB250.png",
            Count = 4,
            WorldID = "2",
            Weight = "1060",
            Guided = "no",
        },
        {
            element("MBD-4", 0.000000, 0.000000, 0.000000),
            element("FAB-250-N1", -0.527000, -0.068000, 0.156000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-250-N1", 1.000000, -0.068000, 0.156000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-250-N1", -0.527000, -0.068000, -0.156000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("FAB-250-N1", 1.000000, -0.068000, -0.156000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{62BE78B1-9258-48AE-B882-279534C0D278}", "GBU-10*2", _("GBU-10*2"), 
        {
            Picture = "GBU10.png",
            WorldID = "3",
            Weight = "1800",
            Guided = "no",
        },
        {
            element("GBU-10", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{89D000B0-0360-461A-AD83-FB727E2ABA98}", "GBU-12*2", _("GBU-12*2"), 
        {
            Picture = "GBU12.png",
            WorldID = "3",
            Weight = "450",
            Guided = "no",
        },
        {
            element("GBU-12", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{EB969276-1922-4ED1-A5CB-18590F45D7FE}", "GBU-27*2", _("GBU-27*2"), 
        {
            Picture = "GBU27.png",
            WorldID = "3",
            Weight = "1968",
            Guided = "no",
        },
        {
            element("GBU-27", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{D3ABF208-FA56-4D56-BB31-E0D931D57AE3}", "Mk 82*28", _("Mk 82*28"), 
        {
            Picture = "FAB250.png",
            WorldID = "3",
            Weight = "6748",
            Guided = "no",
        },
        {
            element("MK-84", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

--[[    launcher("{F3754C5F-3EFB-4E81-BF4E-DF4BEF9F3D36}", "MER*2 CBU-97", _("MER*2 CBU-97"), 
        {
            Picture = "RBK250.png",
            WorldID = "2",
            Weight = "1000",
            Guided = "no",
        },
        {
            element("MER2", 0.000000, 0.000000, 0.000000),
            element("CBU-97", 0.030000, -0.158000, -0.300000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("CBU-97", 0.030000, -0.158000, 0.300000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),]]

--[[    launcher("{6DD77472-0387-47C1-B020-CEBB0E9C7931}", "CBU-97*10", _("CBU-97*10"), 
        {
            Picture = "RBK250.png",
            WorldID = "3",
            Weight = "4500",
            Guided = "no",
        },
        {
            element("CBU-97", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),]]

    launcher("{B8C99F40-E486-4040-B547-6639172A5D57}", "GBU-27*4", _("GBU-27*4"), 
        {
            Picture = "GBU27.png",
            WorldID = "3",
            Weight = "3936",
            Guided = "no",
        },
        {
            element("GBU-27", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{72CAC282-AE18-490B-BD4D-35E7EE969E73}", "M117*51", _("M117*51"), 
        {
            Picture = "RBK250.png",
            WorldID = "3",
            Weight = "17340",
            Guided = "no",
        },
        {
            element("M-117", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{B84DFE16-6AC7-4854-8F6D-34137892E166}", "Mk 82*51", _("Mk 82*51"), 
        {
            Picture = "FAB250.png",
            WorldID = "3",
            Weight = "12291",
            Guided = "no",
        },
        {
            element("MK-82", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{027563C9-D87E-4A85-B317-597B510E3F03}", "Mk 82*6", _("Mk 82*6"), 
        {
            Picture = "FAB250.png",
            WorldID = "3",
            Weight = "1446",
            Guided = "no",
        },
        {
            element("MK-82", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{ACADB374-6D6C-45A0-BA7C-B22B2E108AE4}", "Mk 20*18", _("Mk 20*18"), 
        {
            Picture = "rockeye.png",
            WorldID = "3",
            Weight = "3996",
            Guided = "no",
        },
        {
            element("ROCKEYE", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{F092B80C-BB54-477E-9408-66DEEF740008}", "Mk 84*18", _("Mk 84*18"), 
        {
            Picture = "FAB250.png",
            WorldID = "3",
            Weight = "16092",
            Guided = "no",
        },
        {
            element("MK-84", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{BDAD04AA-4D4A-4E51-B958-180A89F963CF}", "FAB-250*33", _("FAB-250*33"), 
        {
            Picture = "FAB250.png",
            WorldID = "3",
            Weight = "8250",
            Guided = "no",
        },
        {
            element("FAB-250-N1", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{AD5E5863-08FC-4283-B92C-162E2B2BD3FF}", "FAB-500*33", _("FAB-500*33"), 
        {
            Picture = "FAB500.png",
            WorldID = "3",
            Weight = "16500",
            Guided = "no",
        },
        {
            element("FAB-500-N3", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{B0241BD2-5628-47E0-954C-A8675B7E698E}", "FAB-250*24", _("FAB-250*24"), 
        {
            Picture = "FAB250.png",
            WorldID = "3",
            Weight = "6000",
            Guided = "no",
        },
        {
            element("FAB-250-N1", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{26D2AF37-B0DF-4AB6-9D61-A150FF58A37B}", "FAB-500*6", _("FAB-500*6"), 
        {
            Picture = "FAB500.png",
            WorldID = "3",
            Weight = "3000",
            Guided = "no",
        },
        {
            element("FAB-500-N3", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{E70446B7-C7E6-4B95-B685-DEA10CAD1A0E}", "FAB-500*12", _("FAB-500*12"), 
        {
            Picture = "FAB500.png",
            WorldID = "3",
            Weight = "6000",
            Guided = "no",
        },
        {
            element("FAB-500-N3", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{639DB5DD-CB7E-4E42-AC75-2112BC397B97}", "FAB-1500*3", _("FAB-1500*3"), 
        {
            Picture = "FAB1500.png",
            WorldID = "3",
            Weight = "4500",
            Guided = "no",
        },
        {
            element("FAB-1500", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{D9179118-E42F-47DE-A483-A6C2EA7B4F38}", "FAB-1500*6", _("FAB-1500*6"), 
        {
            Picture = "FAB1500.png",
            WorldID = "3",
            Weight = "9000",
            Guided = "no",
        },
        {
            element("FAB-1500", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

--[[    launcher("{AA0574F6-71A6-45C4-897B-584DF1CBE638}", "BetAB-250*24", _("BetAB-250*24"), 
        {
            Picture = "BETAB.png",
            WorldID = "3",
            Weight = "6000",
            Guided = "no",
        },
        {
            element("BETAB-250", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),]]

    launcher("{2B7BDB38-4F45-43F9-BE02-E7B3141F3D24}", "BetAB-500*6", _("BetAB-500*6"), 
        {
            Picture = "betab500.png",
            WorldID = "3",
            Weight = "2868",
            Guided = "no",
        },
        {
            element("BETAB-500", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{D6A0441E-6794-4FEB-87F7-E68E2290DFAB}", "BetAB-500*12", _("BetAB-500*12"), 
        {
            Picture = "betab500.png",
            WorldID = "3",
            Weight = "478",
            Guided = "no",
        },
        {
            element("BETAB-500", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{585D626E-7F42-4073-AB70-41E728C333E2}", "MER*12 Mk-82", _("MER*12 Mk-82"), 
        {
            Picture = "FAB250.png",
            Count = 12,
            WorldID = "2",
            Weight = "3000",
            Guided = "no",
        },
        {
            element("B52-MBD_M117", 0.000000, 0.000000, 0.000000),
            element("MK-82", -3.084000, -0.131000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("MK-82", -0.867000, -0.131000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("MK-82", 1.349000, -0.131000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("MK-82", 3.566000, -0.131000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("MK-82", -3.084000, -0.037000, 0.141000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("MK-82", -3.084000, -0.037000, -0.141000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("MK-82", -0.867000, -0.037000, 0.141000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("MK-82", -0.867000, -0.037000, -0.141000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("MK-82", 1.349000, -0.037000, 0.141000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("MK-82", 1.349000, -0.037000, -0.141000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("MK-82", 3.566000, -0.037000, 0.141000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("MK-82", 3.566000, -0.037000, -0.141000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{574EDEDF-20DE-4942-B2A2-B2EDFD621562}", "MER*12 M-117", _("MER*12 M-117"), 
        {
            Picture = "KMGU2.png",
            Count = 12,
            WorldID = "2",
            Weight = "4250",
            Guided = "no",
        },
        {
            element("B52-MBD_M117", 0.000000, 0.000000, 0.000000),
            element("M-117", -3.084000, -0.131000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("M-117", -0.867000, -0.131000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("M-117", 1.349000, -0.131000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("M-117", 3.566000, -0.131000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("M-117", -3.084000, -0.037000, 0.141000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("M-117", -3.084000, -0.037000, -0.141000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("M-117", -0.867000, -0.037000, 0.141000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("M-117", -0.867000, -0.037000, -0.141000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("M-117", 1.349000, -0.037000, 0.141000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("M-117", 1.349000, -0.037000, -0.141000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("M-117", 3.566000, -0.037000, 0.141000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("M-117", 3.566000, -0.037000, -0.141000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

--[[    launcher("{646D6121-F908-46BF-88A0-8530337792CC}", "HSAB*9 CBU-97", _("HSAB*9 CBU-97"), 
        {
            Picture = "RBK250.png",
            WorldID = "2",
            Weight = "4050",
            Guided = "no",
        },
        {
            element("B52-MBD_MK84", 0.000000, 0.000000, 0.000000),
            element("CBU-97", -3.853000, -0.134000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("CBU-97", -0.052000, -0.134000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("CBU-97", 3.774000, -0.134000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("CBU-97", -3.853000, -0.038000, 0.147000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("CBU-97", -3.853000, -0.038000, -0.147000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("CBU-97", -0.052000, -0.038000, 0.147000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("CBU-97", -0.052000, -0.038000, -0.147000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("CBU-97", 3.774000, -0.038000, 0.147000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("CBU-97", 3.774000, -0.038000, -0.147000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),]]

    launcher("{696CFFC4-0BDE-42A8-BE4B-0BE3D9DD723C}", "HSAB*9 Mk-84", _("HSAB*9 Mk-84"), 
        {
            Picture = "FAB250.png",
            Count = 9,
            WorldID = "2",
            Weight = "8100",
            Guided = "no",
        },
        {
            element("B52-MBD_MK84", 0.000000, 0.000000, 0.000000),
            element("MK-84", -3.853000, -0.134000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("MK-84", -0.052000, -0.134000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("MK-84", 3.774000, -0.134000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("MK-84", -3.853000, -0.038000, 0.147000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("MK-84", -3.853000, -0.038000, -0.147000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("MK-84", -0.052000, -0.038000, 0.147000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("MK-84", -0.052000, -0.038000, -0.147000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("MK-84", 3.774000, -0.038000, 0.147000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("MK-84", 3.774000, -0.038000, -0.147000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{4CD2BB0F-5493-44EF-A927-9760350F7BA1}", "HSAB*9 Mk-20 Rockeye", _("HSAB*9 Mk-20 Rockeye"), 
        {
            Picture = "rockeye.png",
            Count = 9,
            WorldID = "2",
            Weight = "2050",
            Guided = "no",
        },
        {
            element("B52-MBD_MK84", 0.000000, 0.000000, 0.000000),
            element("ROCKEYE", -3.853000, -0.134000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("ROCKEYE", -0.052000, -0.134000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("ROCKEYE", 3.774000, -0.134000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("ROCKEYE", -3.853000, -0.038000, 0.147000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("ROCKEYE", -3.853000, -0.038000, -0.147000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("ROCKEYE", -0.052000, -0.038000, 0.147000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("ROCKEYE", -0.052000, -0.038000, -0.147000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("ROCKEYE", 3.774000, -0.038000, 0.147000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("ROCKEYE", 3.774000, -0.038000, -0.147000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{6C47D097-83FF-4FB2-9496-EAB36DDF0B05}", "Mk 82*27", _("Mk 82*27"), 
        {
            Picture = "FAB250.png",
            WorldID = "3",
            Weight = "6507",
            Guided = "no",
        },
        {
            element("MK-82", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

--[[    launcher("{DE251B06-3433-4F7A-B036-614179C919FD}", "CBU-97*6", _("CBU-97*6"), 
        {
            Picture = "RBK250.png",
            WorldID = "3",
            Weight = "2700",
            Guided = "no",
        },
        {
            element("CBU-97", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),]]

    launcher("{B58F99BA-5480-4572-8602-28B0449F5260}", "M-117*27", _("M-117*27"), 
        {
            Picture = "RBK250.png",
            WorldID = "3",
            Weight = "9180",
            Guided = "no",
        },
        {
            element("M-117", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{29A828E2-C6BB-11d8-9897-000476191836}", "MBD-2-67U - 4 FAB-100", _("MBD-2-67U - 4 FAB-100"), 
        {
            Picture = "FAB100.png",
            Count = 4,
            WorldID = "2",
            Weight = "465",
            Guided = "no",
        },
        {
            element("MBD-2-67U", 0.000000, 0.000000, 0.000000),
            element("FAB-100", 0.701000, -0.088000, -0.107000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 0.470000)
            ),
            element("FAB-100", -0.595000, -0.088000, -0.107000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 0.470000)
            ),
            element("FAB-100", 0.701000, -0.088000, 0.107000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -0.470000)
            ),
            element("FAB-100", -0.595000, -0.088000, 0.107000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -0.470000)
            ),
        }
    ),

    launcher("{96A7F676-F956-404A-AD04-F33FB2C74884}", "KMGU-2 - 96 AO-2.5RT", _("KMGU-2 - 96 AO-2.5RT"), 
        {
            Picture = "KMGU2.png",
            WorldID = "2",
            Weight = "520",
            Guided = "no",
        },
        {
            element("KMGU-2", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{96A7F676-F956-404A-AD04-F33FB2C74881}", "KMGU-2 - 96 PTAB-2.5KO", _("KMGU-2 - 96 PTAB-2.5KO"), 
        {
            Picture = "KMGU2.png",
            WorldID = "2",
            Weight = "520",
            Guided = "no",
        },
        {
            element("KMGU-2", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{CAE48299-A294-4bad-8EE6-89EFC5DCDF00}", "SUU-25 * 8 LUU-2", _("SUU-25 * 8 LUU-2"), 
        {
            Picture = "L005.png",
            WorldID = "2",
            Weight = "130",
            Guided = "no",
        },
        {
            element("SUU-25", 0.000000, 0.000000, 0.000000),
        }
    )
);

weapons_category("{3AB1001C-D1FD-4862-91DC-AD97A56EA01A}", "MISSILES", _("MISSILES"),
    launcher("{12429ECF-03F0-4DF6-BCBD-5D38B6343DE1}", "Kh-22N", _("Kh-22N"), 
        {
            Picture = "kh22.png",
            WorldID = "4",
            Weight = "6800",
            Guided = "no",
            NatoName = "(AS-4A)",
        },
        {
            element("X-22", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),


    launcher("{9F390892-E6F9-42C9-B84E-1136A881DCB2}", "Kh-23L", _("Kh-23L"), 
        {
            Picture = "KAB500.png",
            WorldID = "4",
            Weight = "288",
            Guided = "no",
            NatoName = "(AS-7)",
        },
        {
            element("X-23L", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}", "Kh-25ML", _("Kh-25ML"), 
        {
            Picture = "Kh25Ml.png",
            WorldID = "4",
            Weight = "300",
            Guided = "no",
            NatoName = "(AS-10)",
        },
        {
            element("X-25ML", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{E86C5AA5-6D49-4F00-AD2E-79A62D6DDE26}", "Kh-25MPU", _("Kh-25MPU"), 
        {
            Picture = "Kh25mpu.png",
            WorldID = "4",
            Weight = "310",
            Guided = "no",
            NatoName = "(AS-12)",
            Required = {
                req_launcher("{0519A264-0AB6-11d6-9193-00A0249B6F00}", "L-081 Fantasmagoria ETS pod"),
            },
        },
        {
            element("X-25MP", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{292960BB-6518-41AC-BADA-210D65D5073C}", "Kh-25MR", _("Kh-25MR"), 
        {
            Picture = "kh25mr.png",
            WorldID = "4",
            Weight = "300",
            Guided = "no",
            NatoName = "(AS-12)",
        },
        {
            element("X-25MR", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),


    launcher("{3468C652-E830-4E73-AFA9-B5F260AB7C3D}", "Kh-29L", _("Kh-29L"), 
        {
            Picture = "kh29l.png",
            WorldID = "4",
            Weight = "657",
            Guided = "no",
            NatoName = "(AS-14)",
        },
        {
            element("X-29L", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{B4FC81C9-B861-4E87-BBDC-A1158E648EBF}", "Kh-29T", _("Kh-29T"), 
        {
            Picture = "kh29t.png",
            WorldID = "4",
            Weight = "670",
            Guided = "no",
            NatoName = "(AS-14)",
        },
        {
            element("X-29T", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{4D13E282-DF46-4B23-864A-A9423DFDE504}", "Kh-31A", _("Kh-31A"), 
        {
            Picture = "kh31a.png",
            WorldID = "4",
            Weight = "600",
            Guided = "no",
            NatoName = "(AS-17)",
            Required = {
                req_launcher("{F4920E62-A99A-11d8-9897-000476191836}", "Kopyo radar pod"),
            },
        },
        {
            element("X-31", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{D8F2C90B-887B-4B9E-9FE2-996BC9E9AF03}", "Kh-31P", _("Kh-31P"), 
        {
            Picture = "kh31p.png",
            WorldID = "4",
            Weight = "600",
            Guided = "no",
            NatoName = "(AS-17)",
            Required = {
                req_launcher("{0519A264-0AB6-11d6-9193-00A0249B6F00}", "L-081 Fantasmagoria ETS pod"),
            },
        },
        {
            element("X-31", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{2234F529-1D57-4496-8BB0-0150F9BDBBD2}", "Kh-35", _("Kh-35"), 
        {
            Picture = "kh35.png",
            WorldID = "4",
            Weight = "480",
            Guided = "no",
            NatoName = "(AS-20)",
            Required = {
                req_launcher("{F4920E62-A99A-11d8-9897-000476191836}", "Kopyo radar pod"),
            },
        },
        {
            element("X-35", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{3F26D9C5-5CC3-4E42-BC79-82FAA54E9F26}", "Kh-41", _("Kh-41"), 
        {
            Picture = "kh41.png",
            WorldID = "4",
            Weight = "4500",
            Guided = "no",
            NatoName = "(SS-N-22)",
        },
        {
            element("X-41", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{FE382A68-8620-4AC0-BDF5-709BFE3977D7}", "Kh-58U", _("Kh-58U"), 
        {
            Picture = "kh58u.png",
            WorldID = "4",
            Weight = "640",
            Guided = "no",
            NatoName = "(AS-11)",
            Required = {
                req_launcher("{0519A264-0AB6-11d6-9193-00A0249B6F00}", "L-081 Fantasmagoria ETS pod"),
            },
        },
        {
            element("X-58", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{40AB87E8-BEFB-4D85-90D9-B2753ACF9514}", "Kh-59M", _("Kh-59M"), 
        {
            Picture = "kh59m.png",
            WorldID = "4",
            Weight = "850",
            Guided = "no",
            NatoName = "(AS-18)",
        },
        {
            element("X-59M", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{BADAF2DE-68B5-472A-8AAC-35BAEFF6B4A1}", "Kh-65", _("Kh-65"), 
        {
            Picture = "kh65.png",
            WorldID = "4",
            Weight = "1250",
            Guided = "no",
            NatoName = "(AS-15B)",
        },
        {
            element("X-65", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{F789E86A-EE2E-4E6B-B81E-D5E5F903B6ED}", "APU-8 - 8 9A4172 Vikhr", _("APU-8 - 8 9A4172 Vikhr"), 
        {
            Picture = "APU8.png",
            WorldID = "5",
            Weight = "404",
            Guided = "no",
            NatoName = "(AT-16)",
        },
        {
            element("9M120", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{A6FD14D3-6D30-4C85-88A7-8D17BEE120E2}", "APU-6 - 6 9A4172 Vikhr", _("APU-6 - 6 9A4172 Vikhr"), 
        {
            Picture = "APU6.png",
            WorldID = "5",
            Weight = "330",
            Guided = "no",
            NatoName = "(AT-16)",
        },
        {
            element("APU-6", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{B919B0F4-7C25-455E-9A02-CEA51DB895E3}", "9M114 Shturm-V - 2", _("9M114 Shturm-V - 2"), 
        {
            Picture = "apu2.png",
            WorldID = "5",
            Weight = "230",
            Guided = "no",
            NatoName = "AT-6",
        },
        {
            element("9M114-PILON", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{3EA17AB0-A805-4D9E-8732-4CE00CB00F17}", "BGM-71D Tow * 4", _("BGM-71D Tow * 4"), 
        {
            Picture = "apu4.png",
            WorldID = "5",
            Weight = "250",
            Guided = "no",
        },
        {
            element("TOW-PILON", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{E6747967-B1F0-4C77-977B-AB2E6EB0C102}", "ALARM", _("ALARM"), 
        {
            Picture = "ALARM.png",
            WorldID = "4",
            Weight = "268",
            Guided = "no",
        },
        {
            element("T-ALARM", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{07BE2D19-0E48-4B0B-91DA-5F6C8F9E3C75}", "ALARM*2", _("ALARM*2"), 
        {
            Picture = "ALARM.png",
            Count = 2,
            WorldID = "5",
            Weight = "200",
            Guided = "no",
        },
        {
            element("", 0.000000, 0.000000, 0.000000),
            element("T-ALARM", 1.320000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("T-ALARM", -1.320000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{3E6B632D-65EB-44D2-9501-1C2D04515404}", "AGM-45B", _("AGM-45B"), 
        {
            Picture = "agm45.png",
            WorldID = "4",
            Weight = "177",
            Guided = "no",
        },
        {
            element("AGM-45", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{69DC8AE7-8F77-427B-B8AA-B19D3F478B65}", "AGM-65K", _("AGM-65K"), 
        {
            Picture = "agm65.png",
            WorldID = "4",
            Weight = "210",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
                req_launcher("{CAAC1CFD-6745-416B-AFA4-CB57414856D0}", "Lantirn F-16"),
            },
        },
        {
            element("AGM-65B", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{69DC8AE7-8F77-427B-B8AA-B19D3F478B66}", "AGM-65K", _("AGM-65K"), 
        {
            Picture = "agm65.png",
            WorldID = "5",
            Weight = "210",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
                req_launcher("{CAAC1CFD-6745-416B-AFA4-CB57414856D0}", "Lantirn F-16"),
            },
        },
        {
            element("LAU-117", 0.000000, 0.000000, 0.000000),
            element("AGM-65B", -0.243000, -0.141000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{D7670BC7-881B-4094-906C-73879CF7EB28}", "AGM-65K*2", _("AGM-65K*2"), 
        {
            Picture = "agm65.png",
            Count = 2,
            WorldID = "5",
            Weight = "490",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
                req_launcher("{CAAC1CFD-6745-416B-AFA4-CB57414856D0}", "Lantirn F-16"),
            },
        },
        {
            element("LAU-88", 0.000000, 0.000000, 0.000000),
            element("AGM-65K", lau_88_shift_x, -0.310000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("AGM-65K", lau_88_shift_x, -0.085000, -0.275000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
        }
    ),

    launcher("{D7670BC7-881B-4094-906C-73879CF7EB27}", "AGM-65K*2", _("AGM-65K*2"), 
        {
            Picture = "agm65.png",
            Count = 2,
            WorldID = "5",
            Weight = "490",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
                req_launcher("{CAAC1CFD-6745-416B-AFA4-CB57414856D0}", "Lantirn F-16"),
            },
        },
        {
            element("LAU-88", 0.000000, 0.000000, 0.000000),
            element("AGM-65K", lau_88_shift_x, -0.310000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("AGM-65K", lau_88_shift_x, -0.085000, 0.275000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{907D835F-E650-4154-BAFD-C656882555C0}", "AGM-65K*3", _("AGM-65K*3"), 
        {
            Picture = "agm65.png",
            Count = 3,
            WorldID = "5",
            Weight = "981",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
                req_launcher("{CAAC1CFD-6745-416B-AFA4-CB57414856D0}", "Lantirn F-16"),
            },
        },
        {
            element("LAU-88", 0.000000, 0.000000, 0.000000),
            element("AGM-65K", lau_88_shift_x, -0.310000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("AGM-65K", lau_88_shift_x, -0.085000, 0.275000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("AGM-65K", lau_88_shift_x, -0.085000, -0.275000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
        }
    ),

    launcher("{444BA8AE-82A7-4345-842E-76154EFCCA47}", "AGM-65D", _("AGM-65D"), 
        {
            Picture = "agm65.png",
            WorldID = "4",
            Weight = "220",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
                req_launcher("{CAAC1CFD-6745-416B-AFA4-CB57414856D0}", "Lantirn F-16"),
            },
        },
        {
            element("AGM-65D", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{444BA8AE-82A7-4345-842E-76154EFCCA46}", "AGM-65D", _("AGM-65D"), 
        {
            Picture = "agm65.png",
            WorldID = "5",
            Weight = "220",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
                req_launcher("{CAAC1CFD-6745-416B-AFA4-CB57414856D0}", "Lantirn F-16"),
            },
        },
        {
            element("LAU-117", 0.000000, 0.000000, 0.000000),
            element("AGM-65D", -0.243000, -0.141000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{E6A6262A-CA08-4B3D-B030-E1A993B98452}", "AGM-65D*2", _("AGM-65D*2"), 
        {
            Picture = "agm65.png",
            Count = 2,
            WorldID = "5",
            Weight = "490",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
                req_launcher("{CAAC1CFD-6745-416B-AFA4-CB57414856D0}", "Lantirn F-16"),
            },
        },
        {
            element("LAU-88", 0.000000, 0.000000, 0.000000),
            element("AGM-65D", lau_88_shift_x, -0.310000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("AGM-65D", lau_88_shift_x, -0.085000, -0.275000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
        }
    ),

    launcher("{E6A6262A-CA08-4B3D-B030-E1A993B98453}", "AGM-65D*2", _("AGM-65D*2"), 
        {
            Picture = "agm65.png",
            Count = 2,
            WorldID = "5",
            Weight = "490",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
                req_launcher("{CAAC1CFD-6745-416B-AFA4-CB57414856D0}", "Lantirn F-16"),
            },
        },
        {
            element("LAU-88", 0.000000, 0.000000, 0.000000),
            element("AGM-65D", lau_88_shift_x, -0.310000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("AGM-65D", lau_88_shift_x, -0.085000, 0.275000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{DAC53A2F-79CA-42FF-A77A-F5649B601308}", "AGM-65D*3", _("AGM-65D*3"), 
        {
            Picture = "agm65.png",
            Count = 3,
            WorldID = "5",
            Weight = "981",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
                req_launcher("{CAAC1CFD-6745-416B-AFA4-CB57414856D0}", "Lantirn F-16"),
            },
        },
        {
            element("LAU-88", 0.000000, 0.000000, 0.000000),
            element("AGM-65D", lau_88_shift_x, -0.310000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("AGM-65D", lau_88_shift_x, -0.085000, 0.275000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("AGM-65D", lau_88_shift_x, -0.085000, -0.275000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
        }
    ),

    launcher("{F16A4DE0-116C-4A71-97F0-2CF85B0313EF}", "AGM-65E", _("AGM-65E"), 
        {
            Picture = "agm65.png",
            WorldID = "4",
            Weight = "220",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
                req_launcher("{CAAC1CFD-6745-416B-AFA4-CB57414856D0}", "Lantirn F-16"),
            },
        },
        {
            element("AGM-65E", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{F16A4DE0-116C-4A71-97F0-2CF85B0313EC}", "AGM-65E", _("AGM-65E"), 
        {
            Picture = "agm65.png",
            WorldID = "5",
            Weight = "220",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
                req_launcher("{CAAC1CFD-6745-416B-AFA4-CB57414856D0}", "Lantirn F-16"),
            },
        },
        {
            element("LAU-117", 0.000000, 0.000000, 0.000000),
            element("AGM-65E", -0.243000, -0.141000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{2CC29C7A-E863-411C-8A6E-BD6F0E730548}", "AGM-65E*2", _("AGM-65E*2"), 
        {
            Picture = "agm65.png",
            Count = 2,
            WorldID = "5",
            Weight = "490",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
                req_launcher("{CAAC1CFD-6745-416B-AFA4-CB57414856D0}", "Lantirn F-16"),
            },
        },
        {
            element("LAU-88", 0.000000, 0.000000, 0.000000),
            element("AGM-65E", lau_88_shift_x, -0.310000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("AGM-65E", lau_88_shift_x, -0.085000, -0.275000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
        }
    ),

    launcher("{2CC29C7A-E863-411C-8A6E-BD6F0E730547}", "AGM-65E*2", _("AGM-65E*2"), 
        {
            Picture = "agm65.png",
            Count = 2,
            WorldID = "5",
            Weight = "490",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
                req_launcher("{CAAC1CFD-6745-416B-AFA4-CB57414856D0}", "Lantirn F-16"),
            },
        },
        {
            element("LAU-88", 0.000000, 0.000000, 0.000000),
            element("AGM-65E", lau_88_shift_x, -0.310000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("AGM-65E", lau_88_shift_x, -0.085000, 0.275000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{71AAB9B8-81C1-4925-BE50-1EF8E9899271}", "AGM-65E*3", _("AGM-65E*3"), 
        {
            Picture = "agm65.png",
            Count = 3,
            WorldID = "5",
            Weight = "981",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
                req_launcher("{CAAC1CFD-6745-416B-AFA4-CB57414856D0}", "Lantirn F-16"),
            },
        },
        {
            element("LAU-88", 0.000000, 0.000000, 0.000000),
            element("AGM-65E", lau_88_shift_x, -0.310000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("AGM-65E", lau_88_shift_x, -0.085000, 0.275000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("AGM-65E", lau_88_shift_x, -0.085000, -0.275000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
        }
    ),

    launcher("{8B7CADF9-4954-46B3-8CFB-93F2F5B90B03}", "AGM-84A", _("AGM-84A"), 
        {
            Picture = "agm84a.png",
            WorldID = "4",
            Weight = "661.5",
            Guided = "no",
        },
        {
            element("AGM-84", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{AF42E6DF-9A60-46D8-A9A0-1708B241AADB}", "AGM-84E", _("AGM-84E"), 
        {
            Picture = "agm84a.png",
            WorldID = "4",
            Weight = "628",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
            },
        },
        {
            element("AGM-84E", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{769A15DF-6AFB-439F-9B24-5B7A45C59D16}", "AGM-86C", _("AGM-86C"), 
        {
            Picture = "AGM86.png",
            WorldID = "4",
            Weight = "1950",
            Guided = "no",
        },
        {
            element("AGM-86", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{B06DD79A-F21E-4EB9-BD9D-AB3844618C9C}", "AGM-88C", _("AGM-88C"), 
        {
            Picture = "agm88.png",
            WorldID = "4",
            Weight = "361",
            Guided = "no",
            Required = {
                req_launcher("{8C3F26A2-FA0F-11d5-9190-00A0249B6F00}", "ECM Pod"),
            },
        },
        {
            element("AGM-88", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),
    
    launcher("AGM114x2_OH_58", "AGM-114K * 2", _("AGM-114K * 2"), 
        {
            Picture = "agm114.png",
            Count = 2,
            WorldID = "5",
            Weight = "250",
            Guided = "no",
        },
        {
            element("M272_AGM114", 0.000000, 0.000000, 0.000000),
            element("AGM114", 0.149, -0.17400, 0.157200,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("AGM114", 0.149000, -0.17400, -0.157200,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),
    

    launcher("{88D18A5E-99C8-4B04-B40B-1C02F2018B6E}", "AGM-114K * 4", _("AGM-114K * 4"), 
        {
            Picture = "agm114.png",
            Count = 4,
            WorldID = "5",
            Weight = "250",
            Guided = "no",
        },
        {
            element("M299_AGM114", 0.000000, 0.000000, 0.000000),
            element("AGM114", 0.063000, -0.167900, 0.157200,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("AGM114", 0.063000, -0.167900, -0.157200,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("AGM114", 0.063000, -0.498000, 0.157200,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("AGM114", 0.063000, -0.498000, -0.157200,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{0180F983-C14A-11d8-9897-000476191836}", "S-25L", _("S-25L"), 
        {
            Picture = "S25L.png",
            WorldID = "5",
            Weight = "500",
            Guided = "no",
            NatoName = "(S-25)",
        },
        {
            element("C-25PU", 0.000000, 0.000000, 0.000000),
            element("S-25L", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{7B8DCEB4-820B-4015-9B48-1028A4195692}", "AGM-119B Penguin", _("AGM-119B Penguin"), 
        {
            Picture = "AGM119.png",
            WorldID = "4",
            Weight = "0",
            Guided = "no",
        },
        {
            element("penquin", 0.000000, 0.000000, 0.000000,
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{7210496B-7B81-4B52-80D6-8529ECF847CD}", "Kormoran", _("Kormoran"), 
        {
            Picture = "S25.png",
            WorldID = "4",
            Weight = "660",
            Guided = "no",
        },
        {
            element("T-KORMORAN", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{1461CD18-429A-42A9-A21F-4C621ECD4573}", "Sea Eagle", _("Sea Eagle"), 
        {
            Picture = "SeaEagle.png",
            WorldID = "4",
            Weight = "600",
            Guided = "no",
        },
        {
            element("T-SEA-EAGLE", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{CD9417DF-455F-4176-A5A2-8C58D61AA00B}", "Kh-65*8", _("Kh-65*8"), 
        {
            Picture = "kh65.png",
            WorldID = "6",
            Weight = "10000",
            Guided = "no",
        },
        {
            element("X-65", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{0290F5DE-014A-4BB1-9843-D717749B1DED}", "Kh-65*6", _("Kh-65*6"), 
        {
            Picture = "kh65.png",
            WorldID = "6",
            Weight = "7500",
            Guided = "no",
        },
        {
            element("X-65", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{C42EE4C3-355C-4B83-8B22-B39430B8F4AE}", "Kh-35*6", _("Kh-35*6"), 
        {
            Picture = "kh35.png",
            WorldID = "6",
            Weight = "2880",
            Guided = "no",
        },
        {
            element("X-35", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{9BCC2A2B-5708-4860-B1F1-053A18442067}", "AGM-154C", _("AGM-154C"), 
        {
            Picture = "AGM154.png",
            WorldID = "1",
            Weight = "484",
            Guided = "no",
            Required = {
                req_launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR"),
                req_launcher("{CAAC1CFD-6745-416B-AFA4-CB57414856D0}", "Lantirn F-16"),
            },
        },
        {
            element("AGM-154", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),
    
    launcher("{AABA1A14-78A1-4E85-94DD-463CF75BD9E4}", "AGM-154C*4", _("AGM-154C*4"), 
        {
            Picture = "AGM154.png",
            WorldID = "6",
            Weight = "2560",
            Guided = "no",
        },
        {
            element("X-58", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{22906569-A97F-404B-BA4F-D96DBF94D05E}", "AGM-86C*20", _("AGM-86C*20"), 
        {
            Picture = "AGM86.png",
            WorldID = "6",
            Weight = "39000",
            Guided = "no",
        },
        {
            element("AGM-86", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{46ACDCF8-5451-4E26-BDDB-E78D5830E93C}", "AGM-84A*8", _("AGM-84A*8"), 
        {
            Picture = "agm84a.png",
            WorldID = "6",
            Weight = "5292",
            Guided = "no",
        },
        {
            element("AGM-84", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{8DCAF3A3-7FCF-41B8-BB88-58DEDA878EDE}", "AGM-86C*8", _("AGM-86C*8"), 
        {
            Picture = "AGM86.png",
            WorldID = "6",
            Weight = "15600",
            Guided = "no",
        },
        {
            element("AGM-86", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{45447F82-01B5-4029-A572-9AAD28AF0275}", "MER*6 AGM-86C", _("MER*6 AGM-86C"), 
        {
            Picture = "AGM86.png",
            Count = 6,
            WorldID = "5",
            Weight = "11760",
            Guided = "no",
        },
        {
            element("B52-MBD_AGM86", 0.000000, 0.000000, 0.000000),
            element("AGM-86", -2.096000, 0.138000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("AGM-86", 4.277000, 0.138000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("AGM-86", -2.096000, 0.847000, 0.838000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("AGM-86", -2.096000, 0.847000, -0.838000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
            element("AGM-86", 4.277000, 0.847000, 0.838000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
            element("AGM-86", 4.277000, 0.847000, -0.838000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{B5CA9846-776E-4230-B4FD-8BCC9BFB1676}", "Kh-58U", _("Kh-58U"), 
        {
            Picture = "kh58u.png",
            WorldID = "5",
            Weight = "730",
            Guided = "no",
            Required = {
                req_launcher("{0519A264-0AB6-11d6-9193-00A0249B6F00}", "L-081 Fantasmagoria ETS pod"),
            },
        },
        {
            element("AKU-58", 0.000000, 0.000000, 0.000000),
            element("X-58", -0.428000, -0.234000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{D4A8D9B9-5C45-42e7-BBD2-0E54F8308432}", "Kh-29L", _("Kh-29L"), 
        {
            Picture = "kh29L.png",
            WorldID = "5",
            Weight = "747",
            Guided = "no",
        },
        {
            element("AKU-58", 0.000000, 0.000000, 0.000000),
            element("X-29L", -0.482000, -0.237000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}", "Kh-29T", _("Kh-29T"), 
        {
            Picture = "kh29T.png",
            WorldID = "5",
            Weight = "760",
            Guided = "no",
        },
        {
            element("AKU-58", 0.000000, 0.000000, 0.000000),
            element("X-29T", -0.482000, -0.237000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{4D13E282-DF46-4B23-864A-A9423DFDE50A}", "Kh-31A", _("Kh-31A"), 
        {
            Picture = "kh31a.png",
            WorldID = "5",
            Weight = "690",
            Guided = "no",
            NatoName = "(AS-17)",
            Required = {
                req_launcher("{F4920E62-A99A-11d8-9897-000476191836}", "Kopyo radar pod"),
            },
        },
        {
            element("AKU-58", 0.000000, 0.000000, 0.000000),
            element("X-31", 0.245000, -0.237000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{D8F2C90B-887B-4B9E-9FE2-996BC9E9AF0A}", "Kh-31P", _("Kh-31P"), 
        {
            Picture = "kh31p.png",
            WorldID = "5",
            Weight = "690",
            Guided = "no",
            NatoName = "(AS-17)",
            Required = {
                req_launcher("{0519A264-0AB6-11d6-9193-00A0249B6F00}", "L-081 Fantasmagoria ETS pod"),
            },
        },
        {
            element("AKU-58", 0.000000, 0.000000, 0.000000),
            element("X-31", 0.245000, -0.237000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{2234F529-1D57-4496-8BB0-0150F9BDBBD3}", "Kh-35", _("Kh-35"), 
        {
            Picture = "kh35.png",
            WorldID = "5",
            Weight = "570",
            Guided = "no",
            NatoName = "(AS-20)",
            Required = {
                req_launcher("{F4920E62-A99A-11d8-9897-000476191836}", "Kopyo radar pod"),
            },
        },
        {
            element("AKU-58", 0.000000, 0.000000, 0.000000),
            element("X-35", -0.430000, -0.219000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{79D73885-0801-45a9-917F-C90FE1CE3DFC}", "Kh-25ML", _("Kh-25ML"), 
        {
            Picture = "kh25ml.png",
            WorldID = "5",
            Weight = "360",
            Guided = "no",
        },
        {
            element("APU-68", 0.000000, 0.000000, 0.000000),
            element("X-25ML", 0.000000, -0.135000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{752AF1D2-EBCC-4bd7-A1E7-2357F5601C70}", "Kh-25MPU", _("Kh-25MPU"), 
        {
            Picture = "kh25mpu.png",
            WorldID = "5",
            Weight = "370",
            Guided = "no",
            Required = {
                req_launcher("{0519A264-0AB6-11d6-9193-00A0249B6F00}", "L-081 Fantasmagoria ETS pod"),
            },
        },
        {
            element("APU-68", 0.000000, 0.000000, 0.000000),
            element("X-25MP", 0.000000, -0.135000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}", "AGM-88C", _("AGM-88C"), 
        {
            Picture = "agm88.png",
            WorldID = "5",
            Weight = "361",
            Guided = "no",
            Required = {
                req_launcher("{8C3F26A2-FA0F-11d5-9190-00A0249B6F00}", "ECM Pod"),
            },
        },
        {
            element("lau-118a", 0.000000, 0.000000, 0.000000),
            element("AGM-88", 0.000000, -0.170000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{3E6B632D-65EB-44D2-9501-1C2D04515405}", "AGM-45B", _("AGM-45B"), 
        {
            Picture = "agm45.png",
            WorldID = "5",
            Weight = "177",
            Guided = "no",
        },
        {
            element("lau-118a", 0.000000, 0.000000, 0.000000),
            element("AGM-45", 0.000000, -0.170000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{ee368869-c35a-486a-afe7-284beb7c5d52}", "AGM-114K", _("AGM-114K"), 
        {
            Picture = "agm114.png",
            WorldID = "4",
            Weight = "65",
            Guided = "no",
        },
        {
            element("AGM114", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{57232979-8B0F-4db7-8D9A-55197E06B0F5}", "9M114 Shturm-V x 8", _("9M114 Shturm-V x 8"), 
        {
            Picture = "apu8.png",
            WorldID = "5",
            Weight = "300",
            Guided = "no",
            NatoName = "AT-6",
        },
        {
            element("9K114_Shturm", 0.000000, 0.000000, 0.000000),
        }
    )
);

weapons_category("{4C8373AA-83C3-44d1-8C20-35E1C5F850F1}", "ROCKETS", _("ROCKETS"),
    launcher("{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}", "UB-32A - 32 S-5KO", _("UB-32A - 32 S-5KO"), 
        {
            Picture = "UB32.png",
            WorldID = "11",
            Weight = "275",
            Guided = "no",
        },
        {
            element("UB-32M1", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}", "B-8M1 - 20 S-8KOM", _("B-8M1 - 20 S-8KOM"), 
        {
            Picture = "B8V20A.png",
            WorldID = "11",
            Weight = "395",
            Guided = "no",
        },
        {
            element("B-20", 0.000000, 0.000000, 0.000000),
        }
    ),
    

    launcher("{FC56DF80-9B09-44C5-8976-DCFAFF219062}", "B-13L - 5 S-13 OF", _("B-13L - 5 S-13 OF"), 
        {
            Picture = "B13.png",
            WorldID = "11",
            Weight = "510",
            Guided = "no",
        },
        {
            element("UB-13", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{1FA14DEA-8CDB-45AD-88A8-EC068DF1E65A}", "S-24B", _("S-24B"), 
        {
            Picture = "s24.png",
            WorldID = "10",
            Weight = "235",
            Guided = "no",
        },
        {
            element("C-24", 0.000000, -0.140000, 0.000000),
        }
    ),

    launcher("{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}", "S-24B", _("S-24B"), 
        {
            Picture = "s24.png",
            WorldID = "10",
            Weight = "295",
            Guided = "no",
        },
        {
            element("APU-68", 0.000000, 0.000000, 0.000000),
            element("C-24", 0.300000, -0.275000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{A0648264-4BC0-4EE8-A543-D119F6BA4257}", "S-25 OFM", _("S-25 OFM"), 
        {
            Picture = "S25.png",
            WorldID = "11",
            Weight = "495",
            Guided = "no",
        },
        {
            element("C-25+PU", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{F3EFE0AB-E91A-42D8-9CA2-B63C91ED570A}", "LAU-10 - 4 ZUNI MK 71", _("LAU-10 - 4 ZUNI MK 71"), 
        {
            Picture = "LAU10.png",
            WorldID = "11",
            Weight = "440",
            Guided = "no",
        },
        {
            element("LAU-10", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}", "LAU-61 - 19 2.75' rockets MK151 HE", _("LAU-61 - 19 2.75' rockets MK151 HE"), 
        {
            Picture = "LAU61.png",
            WorldID = "11",
            Weight = "234",
            Guided = "no",
        },
        {
            element("LAU-61", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{A76344EB-32D2-4532-8FA2-0C1BDC00747E}", "LAU-61*3 - 57 2.75' rockets MK151 HE", _("LAU-61*3 - 57 2.75' rockets MK151 HE"), 
        {
            Picture = "LAU61.png",
            WorldID = "11",
            Weight = "702",
            Guided = "no",
        },
        {
            element("MBD-3-LAU-61", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{3DFB7320-AB0E-11d7-9897-000476191836}", "B-8M1 - 20 S-8TsM", _("B-8M1 - 20 S-8TsM"), 
        {
            Picture = "B8V20A.png",
            WorldID = "11",
            Weight = "382",
            Guided = "no",
        },
        {
            element("B-20", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("B-8M1 - 20 S-8OFP2", "B-8M1 - 20 S-8OFP2", _("B-8M1 - 20 S-8OFP2"),
        {
            Picture = "B8V20A.png",
            WorldID = "11",
            Weight = "382",
            Guided = "no",
        },
        {
            element("B-20", 0.000000, 0.000000, 0.000000),
        }
    ),
    
    launcher("{3DFB7321-AB0E-11d7-9897-000476191836}", "LAU-61 - 19 2.75' rockets MK156 WP", _("LAU-61 - 19 2.75' rockets MK156 WP"), 
        {
            Picture = "LAU61.png",
            WorldID = "11",
            Weight = "223",
            Guided = "no",
        },
        {
            element("LAU-61", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("M260_HYDRA", "M260 - 7 2.75' rockets MK156", _("M260 - 7 2.75' rockets MK156"), 
        {
            Picture = "lau68.png",
            WorldID = "11",
            Weight = "112",
            Guided = "no",
        },
        {
            element("OH-58D_Gorgona", 0.000000, 0.000000, 0.000000),
        }
    ),
    
    launcher("M260_HYDRA_WP", "M260 - 7 2.75' rockets MK156 WP", _("M260 - 7 2.75' rockets MK156 WP"), 
        {
            Picture = "lau68.png",
            WorldID = "11",
            Weight = "112",
            Guided = "no",
        },
        {
            element("OH-58D_Gorgona", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}", "B-8V20A - 20 S-8KOM", _("B-8V20A - 20 S-8KOM"), 
        {
            Picture = "B8V20A.png",
            WorldID = "11",
            Weight = "349",
            Guided = "no",
        },
        {
            element("B-8V20A", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("B_8V20A_CM", "B-8V20A - 20 S-8TsM", _("B-8V20A - 20 S-8TsM"), 
        {
            Picture = "B8V20A.png",
            WorldID = "11",
            Weight = "349",
            Guided = "no",
        },
        {
            element("B-8V20A", 0.000000, 0.000000, 0.000000),
        }
    ),
    
    launcher("B_8V20A_OFP2", "B-8V20A - 20 S-8OFP2", _("B-8V20A - 20 S-8OFP2"), 
        {
            Picture = "B8V20A.png",
            WorldID = "11",
            Weight = "349",
            Guided = "no",
        },
        {
            element("B-8V20A", 0.000000, 0.000000, 0.000000),
        }
    ),
    
    launcher("B_8V20A_OM", "B-8V20A - 20 S-8OM", _("B-8V20A - 20 S-8OM"), 
        {
            Picture = "B8V20A.png",
            WorldID = "11",
            Weight = "349",
            Guided = "no",
        },
        {
            element("B-8V20A", 0.000000, 0.000000, 0.000000),
        }
    )
    
);

weapons_category("{3B8A5D2A-DD92-4776-BE4A-79C3EFB360EE}", "AIR-TO-AIR", _("AIR-TO-AIR"),
    launcher("{4EDBA993-2E34-444C-95FB-549300BF7CAF}", "R-40R", _("R-40R"), 
        {
            Picture = "R40R.png",
            WorldID = "4",
            Weight = "475",
            Guided = "no",
            NatoName = "(AA-6)",
        },
        {
            element("R-40R", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{6980735A-44CC-4BB9-A1B5-591532F1DC69}", "R-24T", _("R-24T"), 
        {
            Picture = "r24t.png",
            WorldID = "4",
            Weight = "235",
            Guided = "no",
            NatoName = "(AA-7)",
        },
        {
            element("R-24T", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{CCF898C9-5BC7-49A4-9D1E-C3ED3D5166A1}", "R-24R", _("R-24R"), 
        {
            Picture = "r24r.png",
            WorldID = "4",
            Weight = "215",
            Guided = "no",
            NatoName = "(AA-7)",
        },
        {
            element("R-24R", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{3331E15D-A833-4639-B9E4-A61A37DC1956}", "R-27EA", _("R-27EA"), 
        {
            Picture = "r27erem.png",
            WorldID = "4",
            Weight = "350",
            Guided = "no",
            NatoName = "(AA-10)",
        },
        {
            element("R-27ER", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{9B25D316-0434-4954-868F-D51DB1A38DF0}", "R-27R", _("R-27R"), 
        {
            Picture = "r27r.png",
            WorldID = "4",
            Weight = "253",
            Guided = "no",
            NatoName = "(AA-10)",
        },
        {
            element("R-27R", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{E8069896-8435-4B90-95C0-01A03AE6E400}", "R-27ER", _("R-27ER"), 
        {
            Picture = "r27erem.png",
            WorldID = "4",
            Weight = "350",
            Guided = "no",
            NatoName = "(AA-10)",
        },
        {
            element("R-27ER", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{88DAC840-9F75-4531-8689-B46E64E42E53}", "R-27T", _("R-27T"), 
        {
            Picture = "r27t.png",
            WorldID = "4",
            Weight = "254",
            Guided = "no",
            NatoName = "(AA-10)",
        },
        {
            element("R-27T", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}", "R-27ET", _("R-27ET"), 
        {
            Picture = "r27et.png",
            WorldID = "4",
            Weight = "343",
            Guided = "no",
            NatoName = "(AA-10)",
        },
        {
            element("R-27ET", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{D841D0F9-5ED1-4E27-AA4B-020A492E7454}", "R-27EM", _("R-27EM"), 
        {
            Picture = "r27erem.png",
            WorldID = "4",
            Weight = "350",
            Guided = "no",
            NatoName = "(AA-10)",
        },
        {
            element("R-27ER", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}", "R-33", _("R-33"), 
        {
            Picture = "r33.png",
            WorldID = "4",
            Weight = "490",
            Guided = "no",
            NatoName = "(AA-9)",
        },
        {
            element("R-33", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{5F26DBC2-FB43-4153-92DE-6BBCE26CB0FF}", "R-40T", _("R-40T"), 
        {
            Picture = "R40T.png",
            WorldID = "4",
            Weight = "475",
            Guided = "no",
            NatoName = "(AA-6)",
        },
        {
            element("R-40T", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{682A481F-0CB5-4693-A382-D00DD4A156D7}", "R-60M", _("R-60M"), 
        {
            Picture = "r60.png",
            WorldID = "4",
            Weight = "44",
            Guided = "no",
            NatoName = "(AA-8)",
        },
        {
            element("R-60", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{FBC29BFE-3D24-4C64-B81D-941239D12249}", "R-73", _("R-73"), 
        {
            Picture = "r73.png",
            WorldID = "4",
            Weight = "110",
            Guided = "no",
            NatoName = "(AA-11)",
        },
        {
            element("R-73", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{CBC29BFE-3D24-4C64-B81D-941239D12249}", "R-73", _("R-73"), 
        {
            Picture = "r73.png",
            WorldID = "5",
            Weight = "110",
            Guided = "no",
            NatoName = "(AA-11)",
        },
        {
            element("APU-73", 0.000000, 0.000000, 0.000000),
            element("R-73", 0.000000, -0.178000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}", "R-77", _("R-77"), 
        {
            Picture = "R77.png",
            WorldID = "4",
            Weight = "175",
            Guided = "no",
            NatoName = "(AA-12)",
        },
        {
            element("R-77", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{B4C01D60-A8A3-4237-BD72-CA7655BC0FEC}", "R-77", _("R-77"), 
        {
            Picture = "R77.png",
            WorldID = "5",
            Weight = "250",
            Guided = "no",
            NatoName = "(AA-12)",
            Required = {
                req_launcher("{F4920E62-A99A-11d8-9897-000476191836}", "Kopyo radar pod"),
            },
        },
        {
            element("APU-170", 0.000000, 0.000000, 0.000000),
            element("R-77", 0.000000, -0.224000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}", "R.550 Magic 2", _("R.550 Magic 2"), 
        {
            Picture = "r60.png",
            WorldID = "4",
            Weight = "89",
            Guided = "no",
        },
        {
            element("MAGIC-R550", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{0DA03783-61E4-40B2-8FAE-6AEE0A5C5AAE}", "MICA IR", _("MICA IR"), 
        {
            Picture = "micair.png",
            WorldID = "4",
            Weight = "110",
            Guided = "no",
        },
        {
            element("MICA-T", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{6D778860-7BB8-4ACB-9E95-BA772C6BBC2C}", "MICA RF", _("MICA RF"), 
        {
            Picture = "micarf.png",
            WorldID = "4",
            Weight = "110",
            Guided = "no",
        },
        {
            element("MICA-R", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{FD21B13E-57F3-4C2A-9F78-C522D0B5BCE1}", "SUPER 530F", _("SUPER 530F"), 
        {
            Picture = "super530.png",
            WorldID = "4",
            Weight = "270",
            Guided = "no",
        },
        {
            element("SUPER-530", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{8D399DDA-FF81-4F14-904D-099B34FE7918}", "AIM-7M", _("AIM-7M"), 
        {
            Picture = "aim7m.png",
            WorldID = "4",
            Weight = "230",
            Guided = "no",
        },
        {
            element("AIM-7", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}", "AIM-9M", _("AIM-9M"), 
        {
            Picture = "aim9m.png",
            WorldID = "4",
            Weight = "85.5",
            Guided = "no",
        },
        {
            element("AIM-9", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{7575BA0B-7294-4844-857B-031A144B2595}", "AIM-54C", _("AIM-54C"), 
        {
            Picture = "aim54.png",
            WorldID = "4",
            Weight = "463",
            Guided = "no",
        },
        {
            element("AIM-54", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{C8E06185-7CD6-4C90-959F-044679E90751}", "AIM-120B", _("AIM-120B"), 
        {
            Picture = "aim120.png",
            WorldID = "4",
            Weight = "157",
            Guided = "no",
        },
        {
            element("AIM-120", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 0.000000)
            ),
        }
    ),

    launcher("{33556742-C0F5-4643-BD8F-530B4DEC719B}", "AIM-120B", _("AIM-120B"), 
        {
            Picture = "aim120.png",
            WorldID = "4",
            Weight = "157",
            Guided = "no",
        },
        {
            element("AIM-120", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 0.500000)
            ),
        }
    ),

    launcher("{02CAFD34-010A-4874-8506-4A7C89210353}", "AIM-120B", _("AIM-120B"), 
        {
            Picture = "aim120.png",
            WorldID = "4",
            Weight = "157",
            Guided = "no",
        },
        {
            element("AIM-120", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -0.500000)
            ),
        }
    ),

    launcher("{34271A1E-477E-4754-8C72-DF7C1855A782}", "AIM-120B", _("AIM-120B"), 
        {
            Picture = "aim120.png",
            WorldID = "4",
            Weight = "157",
            Guided = "no",
        },
        {
            element("AIM-120", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{D078E3E5-30C1-444e-A09E-6EEDCD334582}", "AIM-120B", _("AIM-120B"), 
        {
            Picture = "aim120.png",
            WorldID = "4",
            Weight = "157",
            Guided = "no",
        },
        {
            element("AIM-120", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
        }
    ),

    launcher("{DB434044-F5D0-4F1F-9BA9-B73027E18DD3}", "LAU-105 - 2 AIM-9M", _("LAU-105 - 2 AIM-9M"), 
        {
            Picture = "aim9m.png",
            Count = 2,
            WorldID = "5",
            Weight = "200",
            Guided = "no",
        },
        {
            element("A10-PILON-DOP", 0.000000, 0.000000, 0.000000),
            element("AIM-9", 0.4, -0.125, -0.2875,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 0.8400000)
            ),
            element("AIM-9", 0.4, -0.125, 0.274,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -0.840000)
            ),
        }
    ),

    launcher("{3C0745ED-8B0B-42eb-B907-5BD5C1717447}", "LAU-105 - 2 AIM-9P", _("LAU-105 - 2 AIM-9P"), 
        {
            Picture = "aim9p.png",
            Count = 2,
            WorldID = "5",
            Weight = "200",
            Guided = "no",
        },
        {
            element("A10-PILON-DOP", 0.000000, 0.000000, 0.000000),
            element("AIM-9P", 0.400000, -0.043000, -0.351000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("AIM-9P", 0.400000, -0.043000, 0.341000,
                drawarg(1, 2.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{9DDF5297-94B9-42FC-A45E-6E316121CD85}", "LAU-7 - 2 AIM-9M", _("LAU-7 - 2 AIM-9M"), 
        {
            Picture = "aim9m.png",
            Count = 2,
            WorldID = "5",
            Weight = "200",
            Guided = "no",
        },
        {
            element("F4-PILON", 0.000000, 0.000000, 0.000000),
            element("AIM-9", 0.465000, 0.066000, 0.330000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("AIM-9", 0.465000, 0.066000, -0.330000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{773675AB-7C29-422f-AFD8-32844A7B7F17}", "LAU-7 - 2 AIM-9P", _("LAU-7 - 2 AIM-9P"), 
        {
            Picture = "aim9p.png",
            Count = 2,
            WorldID = "5",
            Weight = "200",
            Guided = "no",
        },
        {
            element("F4-PILON", 0.000000, 0.000000, 0.000000),
            element("AIM-9P", 0.465000, 0.066000, 0.330000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("AIM-9P", 0.465000, 0.066000, -0.330000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}", "R-60M*2", _("R-60M*2"), 
        {
            Picture = "r60.png",
            Count = 2,
            WorldID = "5",
            Weight = "148",
            Guided = "no",
        },
        {
            element("PILON-2-R60", 0.000000, 0.000000, 0.000000),
            element("R-60", 0.674000, -0.303000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("R-60", 0.674000, -0.002000, -0.186000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{275A2855-4A79-4B2D-B082-91EA2ADF4691}", "R-60M*2", _("R-60M*2"), 
        {
            Picture = "r60.png",
            Count = 2,
            WorldID = "5",
            Weight = "148",
            Guided = "no",
        },
        {
            element("PILON-2-R60", 0.000000, 0.000000, 0.000000),
            element("R-60", 0.674000, -0.303000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
            element("R-60", 0.674000, -0.002000, 0.186000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}", "AIM-9P", _("AIM-9P"), 
        {
            Picture = "aim9p.png",
            WorldID = "4",
            Weight = "85.5",
            Guided = "no",
        },
        {
            element("AIM-9P", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{5CE2FF2A-645A-4197-B48D-8720AC69394F}", "AIM-9X", _("AIM-9X"), 
        {
            Picture = "aim9m.png",
            WorldID = "4",
            Weight = "85.5",
            Guided = "no",
        },
        {
            element("AIM-9X", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000)
            ),
        }
    ),

    launcher("{40EF17B7-F508-45de-8566-6FFECC0C1AB8}", "AIM-120C", _("AIM-120C"), 
        {
            Picture = "aim120c.png",
            WorldID = "4",
            Weight = "157",
            Guided = "no",
        },
        {
            element("AIM-120C", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 0.000000)
            ),
        }
    ),

    launcher("{DA8F810A-EA40-4091-8127-CC2E026041E7}", "AIM-120C", _("AIM-120C"), 
        {
            Picture = "aim120c.png",
            WorldID = "4",
            Weight = "157",
            Guided = "no",
        },
        {
            element("AIM-120C", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 0.500000)
            ),
        }
    ),

    launcher("{446E122B-8E9D-457e-AE8E-7AE88E3E566B}", "AIM-120C", _("AIM-120C"), 
        {
            Picture = "aim120c.png",
            WorldID = "4",
            Weight = "157",
            Guided = "no",
        },
        {
            element("AIM-120C", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -0.500000)
            ),
        }
    ),

    launcher("{6FBCDCD7-F984-4202-84A7-15173E02CC5B}", "AIM-120C", _("AIM-120C"), 
        {
            Picture = "aim120c.png",
            WorldID = "4",
            Weight = "157",
            Guided = "no",
        },
        {
            element("AIM-120C", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, 1.000000)
            ),
        }
    ),

    launcher("{9701DB51-AECB-42c6-A4F6-D5D8793E4D81}", "AIM-120C", _("AIM-120C"), 
        {
            Picture = "aim120c.png",
            WorldID = "4",
            Weight = "157",
            Guided = "no",
        },
        {
            element("AIM-120C", 0.000000, 0.000000, 0.000000,
                drawarg(1, 1.000000),
                drawarg(2, 1.000000),
                drawarg(3, -1.000000)
            ),
        }
    )
);

weapons_category("{859F6AD7-FCA4-45b8-A470-D3938EC33BFC}", "FUEL TANKS", _("FUEL TANKS"),
    launcher("{414DA830-B61A-4F9E-B71B-C2F6832E1D7A}", "M2000 Fuel tank", _("M2000 Fuel tank"), 
        {
            Picture = "PTB.png",
            WorldID = "7",
            Weight = "1050",
			Weight_Empty = 50,
            Guided = "no",
        },
        {
            element("M2000-PTB", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{EF124821-F9BB-4314-A153-E0E2FE1162C4}", "TORNADO Fuel tank", _("TORNADO Fuel tank"), 
        {
            Picture = "PTB.png",
            WorldID = "7",
            Weight = "1275",
    		Weight_Empty = 50,
			Guided = "no",
        },
        {
            element("T-PTB", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{0395076D-2F77-4420-9D33-087A4398130B}", "F-5 Fuel tank", _("F-5 Fuel tank"), 
        {
            Picture = "PTB.png",
            WorldID = "7",
            Weight = "1003",
 			Weight_Empty = 50,
            Guided = "no",
        },
        {
            element("F5-PTB", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}", "F-4 Fuel tank-W", _("F-4 Fuel tank-W"), 
        {
            Picture = "PTB.png",
            WorldID = "7",
            Weight = "1420",
			Weight_Empty = 50,
            Guided = "no",
        },
        {
            element("F4-BAK-L", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}", "F-4 Fuel tank-C", _("F-4 Fuel tank-C"), 
        {
            Picture = "PTB.png",
            WorldID = "7",
            Weight = "2345",
			Weight_Empty = 50,
            Guided = "no",
        },
        {
            element("F4-BAK-C", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}", "Fuel tank 1500 l", _("Fuel tank 1500 l"), 
        {
            Picture = "PTB.png",
            WorldID = "7",
            Weight = "1250",
			Weight_Empty = 50,
            Guided = "no",
        },
        {
            element("PTB-1500", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{414E383A-59EB-41BC-8566-2B5E0788ED1F}", "Fuel tank 1150 l", _("Fuel tank 1150 l"), 
        {
            Picture = "PTB.png",
            WorldID = "7",
            Weight = "977",
			Weight_Empty = 50,
            Guided = "no",
        },
        {
            element("PTB-1150", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{C0FF4842-FBAC-11d5-9190-00A0249B6F00}", "Fuel tank 1150 l", _("Fuel tank 1150 l"), 
        {
            Picture = "PTB.png",
            WorldID = "7",
            Weight = "977",
			Weight_Empty = 50,
            Guided = "no",
        },
        {
            element("PTB-1150-29", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}", "Fuel tank 800 l", _("Fuel tank 800 l"), 
        {
            Picture = "PTB.png",
            WorldID = "7",
            Weight = "680",
			Weight_Empty = 140,
            Guided = "no",
        },
        {
            element("MIG-23-PTB", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}", "Fuel tank 370 gal", _("Fuel tank 370 gal"), 
        {
            Picture = "PTB.png",
            WorldID = "7",
            Weight = "1930",
			Weight_Empty = 50,
            Guided = "no",
        },
        {
            element("F-16-PTB-N1", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{9F91BA74-BC3F-42F1-8907-3E5E0266F68A}", "Fuel tank 330 gal", _("Fuel tank 330 gal"), 
        {
            Picture = "PTB.png",
            WorldID = "7",
            Weight = "1050",
			Weight_Empty = 50,
            Guided = "no",
        },
        {
            element("F-18-PTB", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{82364E69-5564-4043-A866-E13032926C3E}", "Fuel tank 367 gal", _("Fuel tank 367 gal"), 
        {
            Picture = "PTB.png",
            WorldID = "7",
            Weight = "1193",
			Weight_Empty = 50,
            Guided = "no",
        },
        {
            element("F-16-PTB-N2", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{8A0BE8AE-58D4-4572-9263-3144C0D06364}", "Fuel tank 300 gal", _("Fuel tank 300 gal"), 
        {
            Picture = "PTB.png",
            WorldID = "7",
            Weight = "993",
			Weight_Empty = 50,
            Guided = "no",
        },
        {
            element("F-16-PTB-N2", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{0855A3A1-FA50-4C89-BDBB-5D5360ABA071}", "Fuel tank-5000 l", _("Fuel tank-5000 l"), 
        {
            Picture = "PTB.png",
            WorldID = "7",
            Weight = "4420",
			Weight_Empty = 50,
            Guided = "no",
        },
        {
            element("MIG-25-PTB", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{E1F29B21-F291-4589-9FD8-3272EEC69506}", "Fuel tank 610 gal", _("Fuel tank 610 gal"), 
        {
            Picture = "PTB.png",
            WorldID = "7",
            Weight = "1650",
			Weight_Empty = 50,
            Guided = "no",
        },
        {
            element("F15-PTB", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{7D7EC917-05F6-49D4-8045-61FC587DD019}", "Fuel tank 3000 l", _("Fuel tank 3000 l"), 
        {
            Picture = "PTB.png",
            WorldID = "7",
            Weight = "2550",
			Weight_Empty = 50,
            Guided = "no",
        },
        {
            element("PTB-3000", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{16602053-4A12-40A2-B214-AB60D481B20E}", "Fuel tank 2000 l", _("Fuel tank 2000 l"), 
        {
            Picture = "PTB.png",
            WorldID = "7",
            Weight = "1700",
			Weight_Empty = 50,
            Guided = "no",
        },
        {
            element("PTB-2000", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}", "Fuel tank 800 l Wing", _("Fuel tank 800 l Wing"), 
        {
            Picture = "PTB.png",
            WorldID = "7",
            Weight = "760",
			Weight_Empty = 140,
            Guided = "no",
        },
        {
            element("PTB-800", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{A504D93B-4E80-4B4F-A533-0D9B65F2C55F}", "Fuel tank S-3", _("Fuel tank S-3"), 
        {
            Picture = "PTB.png",
            WorldID = "7",
            Weight = "964",
			Weight_Empty = 50,
            Guided = "no",
        },
        {
            element("S-3-PTB", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{EFEC8200-B922-11d7-9897-000476191836}", "Fuel tank 330 gal", _("Fuel tank 330 gal"), 
        {
            Picture = "PTB.png",
            WorldID = "7",
            Weight = "1050",
			Weight_Empty = 50,
            Guided = "no",
        },
        {
            element("F-18A-PTB", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{EFEC8201-B922-11d7-9897-000476191836}", "Fuel tank 330 gal", _("Fuel tank 330 gal"), 
        {
            Picture = "PTB.png",
            WorldID = "7",
            Weight = "1050",
			Weight_Empty = 50,
            Guided = "no",
        },
        {
            element("F-18C-PTB", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{B99EE8A8-99BC-4a8d-89AC-A26831920DCE}", "Fuel tank", _("Fuel tank"), 
        {
            Picture = "PTB.png",
            WorldID = "7",
            Weight = "550",
			Weight_Empty = 110,
            Guided = "no",
        },
        {
            element("PTB-KA-50", 0.000000, 0.000000, 0.000000),
        }
    )
);

weapons_category("{0A5EE67D-3F2B-4cd3-8A15-26211CF19737}", "PODS", _("PODS"),
    launcher("{6D21ECEA-F85B-4E8D-9D51-31DC9B8AA4EF}", "ALQ-131", _("ALQ-131"), 
        {
            Picture = "ALQ131.png",
            WorldID = "8",
            Weight = "200",
            Guided = "no",
        },
        {
            element("ALQ-131", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{F75187EF-1D9E-4DA9-84B4-1A1A14A3973A}", "SPS-141", _("SPS-141"), 
        {
            Picture = "SPS141.png",
            WorldID = "8",
            Weight = "150",
            Guided = "no",
        },
        {
            element("SPS-141", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{44EE8698-89F9-48EE-AF36-5FD31896A82F}", "L005 Sorbtsiya ECM pod", _("L005 Sorbtsiya ECM pod"), 
        {
            Picture = "L005.png",
            WorldID = "8",
            Weight = "150",
            Guided = "no",
            Required = {
                req_launcher("{44EE8698-89F9-48EE-AF36-5FD31896A82A}", "Sorbtsiya"),
            },
        },
        {
            element("SORBCIJA", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{44EE8698-89F9-48EE-AF36-5FD31896A82A}", "Sorbtsiya", _("Sorbtsiya"), 
        {
            Picture = "L005.png",
            WorldID = "8",
            Weight = "150",
            Guided = "no",
            Required = {
                req_launcher("{44EE8698-89F9-48EE-AF36-5FD31896A82F}", "Sorbtsiya"),
            },
        },
        {
            element("SORBCIJA", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{44EE8698-89F9-48EE-AF36-5FD31896A82D}", "MPS-410", _("MPS-410"), 
        {
            Picture = "MPS410.png",
            WorldID = "8",
            Weight = "150",
            Guided = "no",
            Required = {
                req_launcher("{44EE8698-89F9-48EE-AF36-5FD31896A82C}", "MPS-410"),
            },
        },
        {
            element("MPS-410", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{44EE8698-89F9-48EE-AF36-5FD31896A82C}", "MPS-410", _("MPS-410"), 
        {
            Picture = "MPS410.png",
            WorldID = "8",
            Weight = "150",
            Guided = "no",
            Required = {
                req_launcher("{44EE8698-89F9-48EE-AF36-5FD31896A82D}", "MPS-410"),
            },
        },
        {
            element("MPS-410", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{CAAC1CFD-6745-416B-AFA4-CB57414856D0}", "Lantirn F-16", _("Lantirn F-16"), 
        {
            Picture = "Lantirn.png",
            WorldID = "9",
            Weight = "445",
            Guided = "no",
        },
        {
            element("LANTIRN", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{D1744B93-2A8A-4C4D-B004-7A09CD8C8F3F}", "Lantirn Target Pod", _("Lantirn Target Pod"), 
        {
            Picture = "Lantirn.png",
            WorldID = "9",
            Weight = "200",
            Guided = "no",
        },
        {
            element("LANTIRN-F14-TARGET", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{199D6D51-1764-497E-9AE5-7D07C8D4D87E}", "Pavetack F-111", _("Pavetack F-111"), 
        {
            Picture = "L005.png",
            WorldID = "9",
            Weight = "200",
            Guided = "no",
        },
        {
            element("PAVETACK", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{8C3F26A1-FA0F-11d5-9190-00A0249B6F00}", "BOZ-107", _("BOZ-107"), 
        {
            Picture = "BOZ107.png",
            WorldID = "9",
            Weight = "200",
            Guided = "no",
        },
        {
            element("BOZ-100", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{8C3F26A2-FA0F-11d5-9190-00A0249B6F00}", "Sky-Shadow ECM Pod", _("Sky-Shadow ECM Pod"), 
        {
            Picture = "skyshadow.png",
            WorldID = "8",
            Weight = "200",
            Guided = "no",
        },
        {
            element("SKY_SHADOW", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{B1EF6B0E-3D91-4047-A7A5-A99E7D8B4A8B}", "Mercury LLTV Pod", _("Mercury LLTV Pod"), 
        {
            Picture = "Mercury.png",
            WorldID = "9",
            Weight = "230",
            Guided = "no",
        },
        {
            element("KINGAL", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{0519A261-0AB6-11d6-9193-00A0249B6F00}", "ETHER", _("ETHER"), 
        {
            Picture = "ether.png",
            WorldID = "9",
            Weight = "200",
            Guided = "no",
        },
        {
            element("ETHER", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{0519A262-0AB6-11d6-9193-00A0249B6F00}", "Tangazh ELINT pod", _("Tangazh ELINT pod"), 
        {
            Picture = "L005.png",
            WorldID = "9",
            Weight = "200",
            Guided = "no",
        },
        {
            element("TANGAZH", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{0519A263-0AB6-11d6-9193-00A0249B6F00}", "Shpil-2M Laser Intelligence Pod", _("Shpil-2M Laser Intelligence Pod"), 
        {
            Picture = "Shpil.png",
            WorldID = "9",
            Weight = "200",
            Guided = "no",
        },
        {
            element("SHPIL", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{0519A264-0AB6-11d6-9193-00A0249B6F00}", "L-081 Fantasmagoria ELINT pod", _("L-081 Fantasmagoria ELINT pod"), 
        {
            Picture = "L081.png",
            WorldID = "9",
            Weight = "300",
            Guided = "no",
        },
        {
            element("Fantasm", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}", "Smoke Generator - red", _("Smoke Generator - red"), 
        {
            Picture = "l005.png",
            WorldID = "9",
            Weight = "220",
            Guided = "no",
        },
        {
            element("R-73U", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}", "Smoke Generator - green", _("Smoke Generator - green"), 
        {
            Picture = "l005.png",
            WorldID = "9",
            Weight = "220",
            Guided = "no",
        },
        {
            element("R-73U", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}", "Smoke Generator - blue", _("Smoke Generator - blue"), 
        {
            Picture = "l005.png",
            WorldID = "9",
            Weight = "220",
            Guided = "no",
        },
        {
            element("R-73U", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}", "Smoke Generator - white", _("Smoke Generator - white"), 
        {
            Picture = "l005.png",
            WorldID = "9",
            Weight = "220",
            Guided = "no",
        },
        {
            element("R-73U", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}", "Smoke Generator - yellow", _("Smoke Generator - yellow"), 
        {
            Picture = "l005.png",
            WorldID = "9",
            Weight = "220",
            Guided = "no",
        },
        {
            element("R-73U", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}", "Smoke Generator - orange", _("Smoke Generator - orange"), 
        {
            Picture = "l005.png",
            WorldID = "9",
            Weight = "220",
            Guided = "no",
        },
        {
            element("R-73U", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{A4BCC903-06C8-47bb-9937-A30FEDB4E741}", "Smoke Generator - red", _("Smoke Generator - red"), 
        {
            Picture = "l005.png",
            WorldID = "9",
            Weight = "220",
            Guided = "no",
        },
        {
            element("AIM-9S", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{A4BCC903-06C8-47bb-9937-A30FEDB4E742}", "Smoke Generator - green", _("Smoke Generator - green"), 
        {
            Picture = "l005.png",
            WorldID = "9",
            Weight = "220",
            Guided = "no",
        },
        {
            element("AIM-9S", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{A4BCC903-06C8-47bb-9937-A30FEDB4E743}", "Smoke Generator - blue", _("Smoke Generator - blue"), 
        {
            Picture = "l005.png",
            WorldID = "9",
            Weight = "220",
            Guided = "no",
        },
        {
            element("AIM-9S", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{A4BCC903-06C8-47bb-9937-A30FEDB4E744}", "Smoke Generator - white", _("Smoke Generator - white"), 
        {
            Picture = "l005.png",
            WorldID = "9",
            Weight = "220",
            Guided = "no",
        },
        {
            element("AIM-9S", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{A4BCC903-06C8-47bb-9937-A30FEDB4E745}", "Smoke Generator - yellow", _("Smoke Generator - yellow"), 
        {
            Picture = "l005.png",
            WorldID = "9",
            Weight = "220",
            Guided = "no",
        },
        {
            element("AIM-9S", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{A4BCC903-06C8-47bb-9937-A30FEDB4E746}", "Smoke Generator - orange", _("Smoke Generator - orange"), 
        {
            Picture = "l005.png",
            WorldID = "9",
            Weight = "220",
            Guided = "no",
        },
        {
            element("AIM-9S", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}", "AN/AAS-38 FLIR", _("AN/AAS-38 FLIR"), 
        {
            Picture = "ANAAS38.png",
            WorldID = "9",
            Weight = "200",
            Guided = "no",
        },
        {
            element("F-18-FLIR-POD", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{1C2B16EB-8EB0-43de-8788-8EBB2D70B8BC}", "AN/ASQ-173 LST/SCAM", _("AN/ASQ-173 LST/SCAM"), 
        {
            Picture = "ANASQ173.png",
            WorldID = "9",
            Weight = "250",
            Guided = "no",
        },
        {
            element("F-18-LDT-POD", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{F4920E62-A99A-11d8-9897-000476191836}", "Kopyo radar pod", _("Kopyo radar pod"), 
        {
            Picture = "kopyo.png",
            WorldID = "9",
            Weight = "115",
            Guided = "no",
        },
        {
            element("Spear", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("{A111396E-D3E8-4b9c-8AC9-2432489304D5}", "AN/AAQ-28 LITENING", _("AN/AAQ-28 LITENING"), 
        {
            Picture = "Lantirn.png",
            WorldID = "9",
            Weight = "300",
            Guided = "no",
        },
        {
            element("AAQ-28_LITENING", 0.000000, 0.000000, 0.000000),
        }
    ),
    
    launcher("{05544F1A-C39C-466b-BC37-5BD1D52E57BB}", "UPK-23-250", _("UPK-23-250"), 
        {
            Picture = "upk23250.png",
            WorldID = "11",
            Weight = "218",
            Guided = "no",
        },
        {
            element("UPK-23-250", 0.000000, 0.000000, 0.000000),
        }
    ),
    
    launcher("{E92CBFE5-C153-11d8-9897-000476191836}", "SPPU-22-1 Gun pod", _("SPPU-22-1 Gun pod"), 
        {
            Picture = "SPPU22.png",
            WorldID = "11",
            Weight = "290",
            Guided = "no",
        },
        {
            element("SPPU-22", 0.000000, 0.000000, 0.000000),
        }
    ),

    launcher("oh-58-brauning", "OH-58D Brauning", _("OH-58D Brauning"),
        {
            Picture = "oh58brau.png",
            WorldID = "11",
            Weight = "290",
            Guided = "no",
        },
        {
            element("OH-58D_Browning.LOM ", 0.000000, 0.0000, 0.00000),
        }
    )
);
