-- View scripts 
-- Copyright (C) 2004, Eagle Dynamics.

-- Don't change existing values, they are requested from ++!
-- Use these indices in Snap and CockpitLocalPoint tables.
dofile("Scripts/Database/wsTypes.lua")
PlaneIndex = {
iSu_27 = 1,
iSu_33 = 2,
iSu_25 = 3,
iSu_39 = 4,		-- Su-39 or Su-25T
iMiG_29 = 5,
iMiG_29K = 6,
iA_10 = 7,
iF_15 = 8,
iKA_50 = 9,
}

PlaneIndexByType =
{
	[MiG_29]  = PlaneIndex.iMiG_29,
	[Su_27]   = PlaneIndex.iSu_27,
	[Su_33]   = PlaneIndex.iSu_33,
	[F_15]    = PlaneIndex.iF_15,
	[Su_25]   = PlaneIndex.iSu_25,
	[A_10]    = PlaneIndex.iA_10,
	[MIG_29K] = PlaneIndex.iMiG_29K,
	[Su_39]   = PlaneIndex.iSu_39,
	[MiG_29G] = PlaneIndex.iMiG_29,
	[MiG_29C] = PlaneIndex.iMiG_29,
	[Su_25T]  = PlaneIndex.iSu_39,
	[KA_50]   = PlaneIndex.iKA_50,
}

function validate(tbl,itype)
	return tbl[itype] or tbl[Su_27]
end

DisableCombatViews = false -- F5 & Ctrl-F5
ExternalObjectsLockDistance = 10000.0
ShowTargetInfo = false
CameraTerrainRestriction = true

CockpitLocalPoint = {}
CockpitLocalPoint[PlaneIndex.iSu_27] = {8.15, 1.38, 0.0}
CockpitLocalPoint[PlaneIndex.iSu_33] = {8.35, 1.35, 0.0}
CockpitLocalPoint[PlaneIndex.iSu_25] = {3.5 , 0.4 , 0.0}
CockpitLocalPoint[PlaneIndex.iSu_39] = {3.406, 0.466, 0.0}
CockpitLocalPoint[PlaneIndex.iMiG_29] = {4.92, 1.35, 0.0}
CockpitLocalPoint[PlaneIndex.iMiG_29K] = {4.9, 1.254, 0.0}
CockpitLocalPoint[PlaneIndex.iA_10] = {4.201, 1.55, 0.0}
CockpitLocalPoint[PlaneIndex.iF_15] = {6.5, 1.238, 0.0}
CockpitLocalPoint[PlaneIndex.iKA_50] = {3.188, 0.39, 0.0}

EyePoint = {}
EyePoint[PlaneIndex.iSu_27] = {0,0,0}
EyePoint[PlaneIndex.iSu_33] = {0,0,0}
EyePoint[PlaneIndex.iSu_25] = {0,0,0}
EyePoint[PlaneIndex.iSu_39] = {0,0,0}
EyePoint[PlaneIndex.iMiG_29] = {0,0,0}
EyePoint[PlaneIndex.iMiG_29K] = {0,0,0}
EyePoint[PlaneIndex.iA_10] = {0,0,0}
EyePoint[PlaneIndex.iF_15] = {0,0,0}
EyePoint[PlaneIndex.iKA_50] = {0.09, 0, 0}

--local old_aircrafts_6DOF  = {x = {-2,2},y = {-2,2},z = {-2,2},roll = 90.0} -- {x = {0,0},y = {0,0},z = {0,0},roll = 0}
--local old_aircrafts_6DOF  = {x = {-0.02,0.05},y = {-0.03,0.03},z = {-0.03,0.03},roll = 90.0} --original FC2 limited 6DOF
local old_aircrafts_6DOF  = {x = {-0.02,0.35},y = {-0.35,0.18},z = {-0.35,0.35},roll = 90.0}

limits_6DOF = {}
limits_6DOF[PlaneIndex.iSu_27]   = old_aircrafts_6DOF
limits_6DOF[PlaneIndex.iSu_33]   = old_aircrafts_6DOF
limits_6DOF[PlaneIndex.iSu_25]   = old_aircrafts_6DOF
limits_6DOF[PlaneIndex.iSu_39]   = old_aircrafts_6DOF
limits_6DOF[PlaneIndex.iMiG_29]  = old_aircrafts_6DOF
limits_6DOF[PlaneIndex.iMiG_29K] = old_aircrafts_6DOF
limits_6DOF[PlaneIndex.iA_10]    = old_aircrafts_6DOF
limits_6DOF[PlaneIndex.iF_15]    = old_aircrafts_6DOF
limits_6DOF[PlaneIndex.iKA_50]   = {x = {-0.02,0.35},y = {-0.15,0.21},z = {-0.26,0.26},roll = 90.0}

function GetCockpitLocalPoint(iType)
	local p = CockpitLocalPoint[iType]
	return p[1], p[2], p[3]
end

function GetEyePoint(iType)
	local p = EyePoint[iType]
	return p[1], p[2], p[3]
end

function Get_6DOF_limits(iType)
	local p = limits_6DOF[iType]
	return p.x[1],
		   p.x[2],
		   p.y[1],
		   p.y[2],
		   p.z[1],
		   p.z[2],
		   p.roll
end

function SetCockpitLocalPoint(iType, x, y, z)
	local p = CockpitLocalPoint[iType]
	p[1] = x
	p[2] = y
	p[3] = z
end

-- Camera angle limits {horizontal angle max, vertical angle min, vertical angle max}
CameraAngleLimits = {}
CameraAngleLimits[PlaneIndex.iSu_27] = {140.0, -75.0, 90.0}
CameraAngleLimits[PlaneIndex.iSu_33] = {140.0, -75.0, 90.0}
CameraAngleLimits[PlaneIndex.iSu_25] = {95.0, -65.0, 90.0}
CameraAngleLimits[PlaneIndex.iSu_39] = {110.0, -80.0, 90.0}
CameraAngleLimits[PlaneIndex.iMiG_29] = {140.0, -75.0, 90.0}
CameraAngleLimits[PlaneIndex.iMiG_29K] = {140.0, -65.0, 90.0}
CameraAngleLimits[PlaneIndex.iA_10] = {140.0, -65.0, 90.0}
CameraAngleLimits[PlaneIndex.iF_15] = {140.0, -80.0, 90.0}
CameraAngleLimits[PlaneIndex.iKA_50] ={140.0, -65.0, 90.0}

CameraAngleRestriction = {}
CameraAngleRestriction[PlaneIndex.iSu_27] =  {1,60,0.4}
CameraAngleRestriction[PlaneIndex.iSu_33] =  {1,60,0.4}
CameraAngleRestriction[PlaneIndex.iSu_25] =  {1,60,0.4}
CameraAngleRestriction[PlaneIndex.iSu_39] =  {1,60,0.4}
CameraAngleRestriction[PlaneIndex.iMiG_29] = {1,60,0.4}
CameraAngleRestriction[PlaneIndex.iMiG_29K] ={1,60,0.4}
CameraAngleRestriction[PlaneIndex.iA_10]  =  {1,90,0.5}
CameraAngleRestriction[PlaneIndex.iF_15]  =  {1,60,0.4}
CameraAngleRestriction[PlaneIndex.iKA_50] =  {0,60,0.4}

function GetCameraAngleLimits(iType)
	local p = CameraAngleLimits[iType]
	return p[1], p[2], p[3]
end




function GetCameraAngleRestriction(iType)
	local p = CameraAngleRestriction[iType]
	return  p[1], p[2], p[3]
end 



function SetCameraAngleLimits(iType, hAngMax, vAngMin, vAngMax)
	local p = CameraAngleLimits[iType]
	p[1] = hAngMax
	p[2] = vAngMin
	p[3] = vAngMax
end

-- Following values will not be saved in tracks in the current version!
hAngleRearDefault =  180
vAngleRearDefault = -8.0
vAngleRearMin     = -90 -- -8.0
vAngleRearMax     = 90.0



RearCameraPos = {}
RearCameraAnglesDefault = {}

for i = PlaneIndex.iSu_27,PlaneIndex.iKA_50 do
    local cockpit_point = CockpitLocalPoint[i]
    RearCameraAnglesDefault[i] =  {180,-8.0} 
    RearCameraPos[i]           =  {cockpit_point[1] - 3.7 ,cockpit_point[2] + 2.4, cockpit_point[3]}
end

ArcadeCameraPos = {}
ArcadeCameraAnglesDefault = {}

for i = PlaneIndex.iSu_27,PlaneIndex.iKA_50 do  
    local cockpit_point = CockpitLocalPoint[i]
    ArcadeCameraAnglesDefault[i] =  {0  ,-8.0}
    ArcadeCameraPos[i]           =  {cockpit_point[1] - 20  ,cockpit_point[2] + 5  , cockpit_point[3] + 0}  
end


function GetRearCameraPosition(iType)
	local  p = RearCameraPos[iType]
	return p[1], p[2], p[3]
end

function GetRearCameraAnglesDefault(iType)
    local p = RearCameraAnglesDefault[iType]
    if p == nil then    return hAngleRearDefault , vAngleRearDefault
    else                return p[1], p[2]    end
end


function GetArcadeCameraPosition(iType)
	local  p = ArcadeCameraPos[iType]
	return p[1], p[2], p[3]
end

function GetArcadeCameraAnglesDefault(iType)
    local p = ArcadeCameraAnglesDefault[iType]
    if p == nil then    return hAngleRearDefault , vAngleRearDefault
    else                return p[1], p[2]    end
end

-- LSO local position on the carrier: {x, y, z, rot_Y, rot_Z)
-- Note: tracks can't save modified LSO local positions in the current version!
LSOPosition = {}
LSOPosition["Vinson"] = {88.0, 28.0, 31.0, 0.0, 0.0} 
LSOPosition["Kouznetsov"] = {81.236, 24.0, 28.497, 10.0, 0.0} 

function GetLSOPosition(iType)
	local p = LSOPosition[iType]
	return p[1], p[2], p[3], p[4], p[5]
end




dbg_shell    = "weapons.shells.GSH23_23"
dbg_shell_v0 = -1
