#include "common/BC.hlsl"

Texture2D MFDMap1;
Texture2D MFDMap2;

float3 pc0;
float4 pc1;

float2 b;    // brightness <0,>0
float c;
float gamma;
float brightnessMax;

float3 params;

struct VertexInput {
    float3 vPosition: POSITION;
    float2 vTexCoord0: TEXCOORD0;
};

struct VertexOutput {
    float4 vPosition: SV_POSITION;
    float2 vTexCoord0: TEXCOORD0;
};

VertexOutput vsSimpleMFD(const VertexInput i) {
    VertexOutput o;
    o.vPosition = mul(float4(i.vPosition, 1.0), matWorldViewProj);
    o.vTexCoord0 = i.vTexCoord0;
    return o;
}

float4 source(const VertexOutput i) {
    float4 pixelColor = MFDMap1.SampleBias(WrapLinearSampler, i.vTexCoord0, gMipLevelBias);
    pixelColor.rgb = pow(pixelColor.rgb, gamma);
    return pixelColor;
}

float4 applyMask(const VertexOutput i, float4 value) {
    float4 maskColor = MFDMap2.SampleBias(WrapPointSampler, i.vTexCoord0, gMipLevelBias);
    float3 val = value.rgb * maskColor.rgb * brightnessMax;
    return float4(val, value.a * maskColor.a);
}

float4 BC(const VertexOutput i, float4 value) {
    value.rgb = value.rgb * (1 + b.x) + (1.0f - value.rgb) * b.y;
    value.rgb = saturate((value.rgb - 0.5f) * c + 0.5f);
    return applyMask(i, value);
}

float4 ps_COLORED_b(const VertexOutput i): SV_TARGET0 {
    float4 pixelColor = source(i);
    return saturate(BC(i, pixelColor * float4(pc0, 1) + pc1));
}

float4 ps_COLORED_b_1(const VertexOutput i) : SV_TARGET0 {
    float4 c = source(i) * float4(pc0, 1) + pc1;
    c.xyz = BCM(c.xyz, params.x, params.y, params.z);
    return applyMask(i, c);
}

float4 ps_BW_b(const VertexOutput i): SV_TARGET0 {
    float4 pixelColor = source(i);
    return saturate( BC(i, pixelColor) );
}

float4 ps_BW_b_1(const VertexOutput i) : SV_TARGET0 {
    float4 c = source(i);
    c.xyz = dot(c.rgb, pc0) + pc1;
    c.xyz = BCM(c.xyz, params.x, params.y, params.z);
    return applyMask(i, c);
}

RasterizerState MFD_RasterizerState {
    CullMode = None;
    FillMode = Solid;
    MultisampleEnable = FALSE;
    DepthBias = 0.0;
    SlopeScaledDepthBias = 1.0;
};

technique10 Colored_b {
    pass P0 {
        SetVertexShader(CompileShader(vs_4_0, vsSimpleMFD()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, ps_COLORED_b()));
        SetRasterizerState(MFD_RasterizerState);
    }
    pass P1 {
        SetVertexShader(CompileShader(vs_4_0, vsSimpleMFD()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, ps_COLORED_b_1()));
        SetRasterizerState(MFD_RasterizerState);
    }
}

technique10 BW_b {
    pass P0 {
        SetVertexShader(CompileShader(vs_4_0, vsSimpleMFD()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, ps_BW_b()));
        SetRasterizerState(MFD_RasterizerState);
    }
    pass P1 {
        SetVertexShader(CompileShader(vs_4_0, vsSimpleMFD()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, ps_BW_b_1()));
        SetRasterizerState(MFD_RasterizerState);
    }
}
