-- Fishing style boat model A based on the castle class OPV 

mount_vfs_model_path	(current_mod_path.."/Shapes")
mount_vfs_texture_path  (current_mod_path.."/Textures/UnarmedVessel01a.zip")


GT = {};
GT_t.ws = 0;

set_recursive_metatable(GT, GT_t.generic_ship)

GT.visual = {}
GT.visual.shape = "fishing_vessel_01a.EDM"
GT.visual.shape_dstr = ""

GT.animation_arguments.water_propeller = 65;

GT.life = 180;
GT.mass = 8715
GT.max_velocity = 36.4333
GT.race_velocity = 15.4333
GT.economy_velocity = 12.2889
GT.economy_distance = 11112e+007
GT.race_distance = 2778e+006
GT.shipLength = 81.4 --172.8
GT.Width = 21 --15
GT.Height = 14.4 --37.2
GT.Length = 81 --172.8
GT.DeckLevel = 4.609
GT.X_nose = 35.31
GT.X_tail = -33.162
GT.Tail_Width = 4
GT.Gamma_max = 0.35
GT.Om = 0.59
GT.speedup = 0.41779
GT.R_min = 345.6
GT.distFindObstacles = 568.4

GT.airWeaponDist = 0
GT.airFindDist = 20

GT.Landing_Point = {-24.467, 3.191, 0.0};

GT.exhaust = {
	[1] = { size = 0.10 , pos = { -5.0, 15.823, 0.2 } },
	[2] = { size = 0.10 , pos = { -5.0, 15.823, -0.2 } },
}



GT.Name = "Unarmed vessel 01a"
GT.DisplayName = _("Unarmed vessel 01a")
GT.Rate = 700

GT.Sensors = {  OPTIC = {"long-range naval optics", "long-range naval LLTV", "long-range naval FLIR",},
               
            };

GT.DetectionRange  = GT.airFindDist;
GT.ThreatRange = GT.airWeaponDist;
GT.Singleton   ="no";
GT.mapclasskey = "P0091000067";
GT.attribute = {wsType_Navy,wsType_Ship,wsType_ArmedShip,wsType_GenericLightArmoredShip,
					"low_reflection_vessel",
                    "Unarmed ships",
					"Corvettes",
				};
GT.Categories = {
					{name = "Ship"},
				};


add_surface_unit(GT)
