Effect = {
	{
		Type = "smoke", -- Huge smoke with no fire
		LODdistance = 150000.0,
		Texture = "puff01.dds",
		-- Texture = "puff02.dds",
		
		ColorGradientTexture = "fireGradient01_Taz.dds",
		AlphaGradientTexture = "fireGradient01_Taz.dds",
		
		Points = 7, -- 2 minimum
		Density = 0.2,
		Radius = {80, 380},-- start, finish
		RadiusFactor = 1.0,
		Length = 500,
		TrailSpeedMin = 15,
		HeightFactor = 0.15,
		
		AnimSpeed = 60, -- FPS

		Color = {66/255.0, 60/255.0, 56/255.0},
		Opacity = 0.3,
		Lighting = 0.6,

		FlameAttenuation = {-50, 130}, -- meters from smoke start
		FlamePower = 5.0*9,
		FlameFactor = 0.5,
		DyingTime = 30.0,
		Light =
		{
			Color = {1, 0.45, 0,09},
			Radius = 250.0,
			Lifetime = 1000.0,
			Offset = {0, 0.5, 0},
		}
	},
}

staticEffect = true

Presets =
{
	hugeSmokeWithFire =
	{
		{
			Type = "smoke",

			Light =
			{
				Color = {1, 0.45, 0,09},
				Radius = 250.0,
				LODdistance = 150000,
				--Radius = 100000.0,
				Lifetime = 1000.0,
				Offset = {0, 2.0, 0},
			}
		}
	},
	
	largeSmokeWithFire = -- Smaller huge smoke with no fire
	{
		{
			Type = "smoke",
			
			Density = 0.1,
			Radius = {20, 320},-- start, finish
			RadiusFactor = 1.0,
			Length = 400,
			TrailSpeedMin = 10,
			HeightFactor = 0.2,
			LODdistance = 150000,

			AnimSpeed = 60, -- FPS

			Color = {64/255.0, 58/255.0, 54/255.0},
			Opacity = 0.3,
			Lighting = 0.6,
			
			FlameAttenuation = {-40, 100}, -- meters from smoke start
			FlamePower = 5.0*9,
			FlameFactor = 1.5,
			PositionOffsetLocal = {0, -40, 0},

			Light =
			{
				Color = {1, 0.45, 0,09},
				Radius = 200.0,
				--Radius = 100000.0,
				Lifetime = 1000.0,
				Offset = {0, 2.0, 0},
			}
		}
	},
	
	mediumSmokeWithFire =
	{
		{
			Type = "smoke",
			
			Density = 0.1,
			Radius = {28, 160},-- start, finish
			RadiusFactor = 1.0,
			Length = 300,
			TrailSpeedMin = 8,
			HeightFactor = 0.2,
			LODdistance = 50000,

			AnimSpeed = 60, -- FPS

			Color = {68/255.0, 62/255.0, 60/255.0},
			Opacity = 0.3,
			Lighting = 0.6,
			
			FlameAttenuation = {-20, 40}, -- meters from smoke start
			FlamePower = 5.0*9,
			FlameFactor = 1.5,

			Light =
			{
				Color = {1, 0.45, 0,09},
				Radius = 200.0,
				--Radius = 100000.0,
				Lifetime = 1000.0,
				Offset = {0, 2.0, 0},
			}
		}
	},
	
	smallSmokeWithFire = -- Placeable large smoke with fire and building smoke
	{
		{
			Type = "smoke",
			
			Density = 0.1,
			Radius = {10, 140},-- start, finish
			RadiusFactor = 1.0,
			Length = 260,
			TrailSpeedMin = 6,
			HeightFactor = 0.25,
			LODdistance = 50000,

			AnimSpeed = 180, -- FPS

			Color = {70/255.0*0.8, 64/255.0*0.8, 62/255.0*0.8},
			Opacity = 0.3,
			Lighting = 0.8,
			
			FlameAttenuation = {-8, 31}, -- meters from smoke start
			FlamePower = 4.0*1,
			FlameFactor = 0.5,
			PositionOffsetLocal = {0, -10.0, 0}, -- {0, -8.0, 0}

			Light =
			{
				Color = {1, 0.45, 0,09}, -- Glow on the ground
				Radius = 800.0,
				--Radius = 100000.0,
				Lifetime = 1000.0,
				Offset = {0, 2.0, 0},
			}
		}
	},

	miniSmokeWithFire = -- vehicle smoke
	{
		{
			Type = "smoke",
			
			Density = 0.1,
			Radius = {4, 80},-- start, finish {6, 130}
			RadiusFactor = 1.0,
			Length = 140, -- 160
			TrailSpeedMin = 4,
			HeightFactor = 0.22,
			
			AnimSpeed = 140, -- FPS
			LODdistance = 50000,

			Color = {78/255.0*0.85, 72/255.0*0.85, 68/255.0*0.85},
			Opacity = 0.30, -- 0.26
			Lighting = 0.6,
			
			FlameAttenuation = {-1.0, 2.8}, -- meters from smoke start {-1.0, 1.6}
			FlamePower = 4.0*3,
			FlameFactor = 0.02, -- 0.018
			PositionOffsetLocal = {0, -10.0, 0},

			Light =
			{
				Color = {1, 0.45, 0,09},
				Radius = 200.0,
				--Radius = 100000.0,
				Lifetime = 1000.0,
				Offset = {0, 2.0, 0},
			}
		}
	},

	areaSmokeWithFire =
	{
		{
			Type = "smoke",
			
			Density = 0.2,
			Radius = {15, 80},-- start, finish
			RadiusFactor = 1.0,
			Length = 150,
			TrailSpeedMin = 5,
			HeightFactor = 0.25,
			LODdistance = 50000,
			
			AnimSpeed = 70, -- FPS

			Color = {61/255.0*0.8, 70/255.0*0.8, 73/255.0*0.8},
			Opacity = 1.0,
			Lighting = 0.6,
			
			FlameAttenuation = {-10, 30}, -- meters from smoke start
			FlamePower = 5.0*9,
			FlameFactor = 1.5,
		},
		{
			Type = "smoke",
			
			Density = 0.25,
			Radius = {5, 50},-- start, finish
			RadiusFactor = 1.0,
			Length = 65,
			TrailSpeedMin = 4,
			HeightFactor = 0.25,
			
			AnimSpeed = 90, -- FPS

			Color = {61/255.0*0.8, 70/255.0*0.8, 73/255.0*0.8},
			Opacity = 0.9,
			Lighting = 0.65,
			
			FlameAttenuation = {-10, 38}, -- meters from smoke start
			FlamePower = 5.0*9,
			FlameFactor = 1.4,
			PositionOffsetLocal = {-6.5, -0.5, -7.543},

			LODdistance = 50000.0,
			Texture = "puff01.dds",
			-- Texture = "puff02.dds",
			
			ColorGradientTexture = "fireGradient01_Taz.dds",
			AlphaGradientTexture = "fireGradient01_Taz.dds",
			
			Points = 7, -- 2 minimum
			

		}
		,{
			Type = "smoke",
			LODdistance = 50000.0,
			Texture = "puff01.dds",
			-- Texture = "puff02.dds",
			
			ColorGradientTexture = "fireGradient01_Taz.dds",
			AlphaGradientTexture = "fireGradient01_Taz.dds",
			
			Points = 7, -- 2 minimum
			

			Density = 0.15,
			Radius = {4, 40},-- start, finish
			RadiusFactor = 0.75,
			Length = 80,
			TrailSpeedMin = 3,
			HeightFactor = 0.2,
			
			AnimSpeed = 85, -- FPS

			Color = {61/255.0*0.8, 70/255.0*0.8, 73/255.0*0.8},
			Opacity = 0.95,
			Lighting = 0.5,
			
			FlameAttenuation = {-10, 35}, -- meters from smoke start
			FlamePower = 5.0*9,
			FlameFactor = 1.6,
			PositionOffsetLocal = {7.23, -0.75, 6.2},
		}
	},
}

Presets.hugeSmoke = deepcopy(Presets.hugeSmokeWithFire)
Presets.hugeSmoke[1].FlameAttenuation = {-100, -1.0}
Presets.hugeSmoke[1].Light.Radius = 0

Presets.largeSmoke = deepcopy(Presets.largeSmokeWithFire)
Presets.largeSmoke[1].FlameAttenuation = {-100, -1.0}
Presets.largeSmoke[1].Light.Radius = 0

Presets.mediumSmoke = deepcopy(Presets.mediumSmokeWithFire)
Presets.mediumSmoke[1].FlameAttenuation = {-100, -1.0}
Presets.mediumSmoke[1].Light.Radius = 0

Presets.smallSmoke = deepcopy(Presets.smallSmokeWithFire)
Presets.smallSmoke[1].FlameAttenuation = {-100, -1.0}
Presets.smallSmoke[1].Light.Radius = 0



Presets.smokeMarkerBlack = deepcopy(Presets.smallSmoke)
Presets.smokeMarkerBlack[1].Length = 15
Presets.smokeMarkerBlack[1].Radius = {1.4, 12}
Presets.smokeMarkerBlack[1].PositionOffsetLocal = {0, -1, 0}

Presets.smokeMarkerGreen = deepcopy(Presets.smokeMarkerBlack)
Presets.smokeMarkerGreen[1].Color = {0.5, 0.95, 0.15}

Presets.smokeMarkerOrange = deepcopy(Presets.smokeMarkerGreen)
Presets.smokeMarkerOrange[1].Color = {0.95, 0.6, 0.15}

Presets.smokeMarkerRed = deepcopy(Presets.smokeMarkerGreen)
Presets.smokeMarkerRed[1].Color = {0.85, 0.15, 0.15}