-- View scripts 
-- Copyright (C) 2004, Eagle Dynamics.
DisableCombatViews				= false -- F5 & Ctrl-F5
ExternalObjectsLockDistance 	= 10000.0
ShowTargetInfo 					= false
CameraTerrainRestriction 		= true
hAngleCustomDefault 			=  0.0
vAngleCustomDefault 			= -8.0
vAngleCustomMin    				= -90.0
vAngleCustomMax    				= 90.0

UseGreenieBoardLandingDataHistory = true	-- For Carrier Air Wing Briefing Room
UseKillBoardDataHistory = true

--reformatted per-unit data to be mod system friendly 
--this file is no longer should be edited for adding new flyable aircraft , DCS automatically check core database (i.e. where you define your aircraft in aircraft table just define ViewSettings and SnapViews tables)

function default_fighter_player(t)
	local res = { 
		CameraViewAngleLimits  = {20.000000,140.000000},
		CameraAngleRestriction = {false	   ,90.000000,0.500000},
		EyePoint               = {0.05     ,0.000000 ,0.000000},
		--limits_6DOF            = {x = {-0.050000,0.4500000},y ={-0.300000,0.100000},z = {-0.220000,0.220000},roll = 90.000000},
		limits_6DOF            = {x = {-100.050000,100.4500000},y ={-100.300000,100.100000},z = {-100.220000,100.220000},roll = 90.000000},
		--Allow360rotation	   = false,
		Allow360rotation	   = true,
		CameraAngleLimits      = {200,-80.000000,110.000000},
		ShoulderSize 		   = 0.2,  -- move body when azimuth value more then 90 degrees
	}
	if t then 
		for i,o in pairs(t) do
			res[i] = o
		end
	end
	return res
end

function fulcrum()
	return {
		Cockpit = {
			default_fighter_player({CockpitLocalPoint = {4.71,1.28,0.000000}})
		},
		Chase   = {
			LocalPoint      = {1.220000,3.750000,0.000000},
			AnglesDefault   = {180.000000,-8.000000},
		}, -- Chase 
		Arcade = {
			LocalPoint      = {-15.080000,6.350000,0.000000},
			AnglesDefault   = {0.000000,-8.000000},
		}, -- Arcade 
	}
end

ViewSettings = {}
ViewSettings["A-10A"] = {
	Cockpit = {
	[1] = default_fighter_player({CockpitLocalPoint      =  {4.300000,1.282000,0.000000},
								  EyePoint  			 = {0.000000,0.000000,0.000000},
								  limits_6DOF            = {x 	 = {-0.050000,0.600000},
															y 	 = {-0.300000,0.100000},
															z 	 = {-0.250000,0.250000},
															roll =  90.000000}}),
	}, -- Cockpit 
	Chase = {
		LocalPoint      = {0.600000,3.682000,0.000000},
		AnglesDefault   = {180.000000,-8.000000},
	}, -- Chase 
	Arcade = {
		LocalPoint      = {-27.000000,12.000000,0.000000},
		AnglesDefault   = {0.000000,-12.000000},
	}, -- Arcade 
}
ViewSettings["F-15C"] = {
	Cockpit = {  
	[1] = default_fighter_player({CockpitLocalPoint      = {6.210000,1.204000,0.000000}})-- player slot 1
	}, -- Cockpit 
	Chase = {
		LocalPoint      = {2.510000,3.604000,0.000000},
		AnglesDefault   = {180.000000,-8.000000},
	}, -- Chase 
	Arcade = {
		LocalPoint      = {-13.790000,6.204000,0.000000},
		AnglesDefault   = {0.000000,-8.000000},
	}, -- Arcade 
}

ViewSettings["MiG-29A"] 	= fulcrum()
ViewSettings["MiG-29G"] 	= fulcrum()
ViewSettings["MiG-29S"] 	= fulcrum()

ViewSettings["Su-25"] = {
	Cockpit = {
	[1] = default_fighter_player({CockpitLocalPoint      = {3.352000,0.506000,0.000000}}),-- player slot 1
	}, -- Cockpit 
	Chase = {
		LocalPoint      = {-0.348000,2.906000,0.000000},
		AnglesDefault   = {180.000000,-8.000000},
	}, -- Chase 
	Arcade = {
		LocalPoint      = {-16.648001,5.506000,0.000000},
		AnglesDefault   = {0.000000,-8.000000},
	}, -- Arcade 
}

ViewSettings["Su-25T"] = {
	Cockpit = {
	[1] = default_fighter_player({CockpitLocalPoint      = {3.406000,0.466000,0.000000}}),-- player slot 1
	}, -- Cockpit 
	Chase = {
		LocalPoint      = {-0.294000,2.866000,0.000000},
		AnglesDefault   = {180.000000,-8.000000},
	}, -- Chase 
	Arcade = {
		LocalPoint      = {-16.594000,5.466000,0.000000},
		AnglesDefault   = {0.000000,-8.000000},
	}, -- Arcade 
}

ViewSettings["Su-27"] = {
	Cockpit = {
	[1] = default_fighter_player({CockpitLocalPoint      = {7.959000,1.419000,0.000000}})-- player slot 1
	}, -- Cockpit 
	Chase = {
		LocalPoint      = {4.259000,3.819000,0.000000},
		AnglesDefault   = {180.000000,-8.000000},
	}, -- Chase 
	Arcade = {
		LocalPoint      = {-12.041000,6.419000,0.000000},
		AnglesDefault   = {0.000000,-8.000000},
	}, -- Arcade 
}

ViewSettings["Su-33"] = ViewSettings["Su-27"]

ViewSettings["FA-18C_hornet"] = {
	Cockpit = {
	[1] = {-- player slot 1
		CameraViewAngleLimits  = {20.000000,140.000000},
		CockpitLocalPoint      = {3.533,1.156,0.0},
		CameraAngleRestriction = {false,90.000000,0.500000},
		CameraAngleLimits      = {200,-90.000000,90.000000},
		EyePoint               = {0.05000,0.100000,0.000000},
		ShoulderSize		   = 0.25,
		Allow360rotation	   = true,
		--limits_6DOF            = {x = {-0.13,0.30},y ={-0.3,0.065},z = {-0.18,0.18},roll = 90.000000},
		limits_6DOF            = {x = {-100.13,100.30},y ={-100.3,100.065},z = {-100.18,100.18},roll = 90.000000},
	},
	}, -- Cockpit 
	Chase = {
		LocalPoint      = {-5.0,1.0,3.0},
		AnglesDefault   = {0.000000,0.000000},
	}, -- Chase 
	Arcade = {
		LocalPoint      = {-21.500000,5.618000,0.000000},
		AnglesDefault   = {0.000000,-8.000000},
	}, -- Arcade 
}

ViewSettings["AH-64D_BLK_II"] = {
	Cockpit = {
	
		CockpitAnchorPoint 			= {1.926, 0.922, 0.0},
		[1] = {-- player slot 1 (PLT)
			CameraViewAngleLimits	= {20.000000,140.000000},
			CockpitLocalPoint		= {1.784, 0.992, 0.045},
			CameraAngleRestriction	= {false,90.000000,0.500000},
			CameraAngleLimits		= {200,-90.000000,90.000000},
			EyePoint				= {0.090, 0.000, 0.000},
			ShoulderSize			= 0.25,
			--Allow360rotation		= false,
			Allow360rotation		= true,
			--limits_6DOF				= {x = {-0.2,0.3}, y = {-0.3,0.2}, z = {-0.3,0.3}, roll = 90.000000},
			limits_6DOF				= {x = {-100.2,100.3}, y = {-100.3,100.2}, z = {-100.3,100.3}, roll = 90.000000},
		},
		[2] = {-- player slot 2 (CPG)
			CameraViewAngleLimits	= {20.000000,140.000000},
			CockpitLocalPoint		= {1.784 + 1.300, 0.992 - 0.45, 0.045},
			CameraAngleRestriction	= {false,90.000000,0.500000},
			CameraAngleLimits		= {200,-90.000000,90.000000},
			EyePoint				= {0.090, 0.000, 0.000},
			ShoulderSize			= 0.25,
			--Allow360rotation		= false,
			Allow360rotation		= true,
			--limits_6DOF				= {x = {-0.2,0.3}, y = {-0.3,0.2}, z = {-0.3,0.3}, roll = 90.000000},
			limits_6DOF				= {x = {-100.2,100.3}, y = {-100.3,100.2}, z = {-100.3,100.3}, roll = 90.000000},
		},
	},
	Chase = {
		LocalPoint		= {-5.0,1.0,3.0},
		AnglesDefault	= {0.000000,0.000000},
	},
	Arcade = {
		LocalPoint		= {-21.500000,5.618000,0.000000},
		AnglesDefault	= {0.000000,-8.000000},
	},
}

ViewSettings["F-16C_50"] = {
	Cockpit = {
	[1] = {-- player slot 1
		CameraViewAngleLimits  = {20.000000,140.000000},
		CockpitLocalPoint      = {3.259,0.796,0.0},
		CameraAngleRestriction = {false,90.000000,0.500000},
		CameraAngleLimits      = {200,-90.000000,90.000000},
		EyePoint               = {0.05000,0.100000,0.000000},
		ShoulderSize		   = 0.25,
		--Allow360rotation	   = false,
		Allow360rotation	   = true,
		--limits_6DOF            = {x = {-0.13,0.30},y ={-0.06,0.16},z = {-0.18,0.18},roll = 90.000000},
		limits_6DOF            = {x = {-100.13,100.30},y ={-100.06,100.16},z = {-100.18,100.18},roll = 90.000000},
	},
	}, -- Cockpit 
	Chase = {
		LocalPoint      = {-5.0,1.0,3.0},
		AnglesDefault   = {0.000000,0.000000},
	}, -- Chase 
	Arcade = {
		LocalPoint      = {-21.500000,5.618000,0.000000},
		AnglesDefault   = {0.000000,-8.000000},
	}, -- Arcade 
}

local mi24pAnchor = {3.176, 0.586, -0.007}
		
local function mi24pPlayer(x,y)
	return {	
		CockpitLocalPoint      = {x,y,mi24pAnchor[3]},
		CameraViewAngleLimits  = {20.000000,140.000000},
		CameraAngleRestriction = {false,90.000000,0.400000},
		CameraAngleLimits      = {200,-65.000000,90.000000},
		EyePoint               = {0.05000,0.100000,0.000000},
		ShoulderSize		   = 0.25,
		--Allow360rotation	   = false,
		Allow360rotation	   = true,
		--limits_6DOF            = {x = {-0.1,0.5},y ={-0.3,0.1},z = {-0.3,0.3},roll = 90.0},
		limits_6DOF            = {x = {-100.1,100.5},y ={-100.3,100.1},z = {-100.3,100.3},roll = 90.0},
	}
end

local function gunner(x,y, ang)
	return {	
		CockpitLocalPoint      = {x,y, 0.0},
		CockpitLocalPointAzimuth  = ang,
		CameraViewAngleLimits  = {20.000000,100.000000},
		CameraAngleRestriction = {false,60.000000,0.400000},
		CameraAngleLimits      = {90,-45.000000,60.000000},
		EyePoint               = {0.090000,0.000000,0.000000},
		Allow360rotation	   = true,
		ExternalShapeUsed	   = true,
		limits_6DOF            = {x 	= {-100.1, 100.6},
								  y 	= {-100.55, 100.55}, 
								  z 	= {-100.46, 100.46},
								  roll  = 45.000000},

	}
end

ViewSettings["Mi-24P"] = {
	--}, -- Cockpit
	Cockpit = {
		CockpitAnchorPoint = mi24pAnchor,
		mi24pPlayer(3.15, 0.57),
		mi24pPlayer(4.65, -0.05),--видимо X Y(4.65, 0.04)
		gunner(0.0, 0.0, 90),
	}, --Cockpit
	Chase = {
		LocalPoint      = {-5.700000,1.400000,-3},
		AnglesDefault   = {0,-8.000000},
	}, -- Chase 
	Arcade = {
		LocalPoint      = {-20.000000,5.000000,0.000000},
		AnglesDefault   = {0.000000,-8.000000},
	}, -- Arcade 
}

ViewSettings["F-4E-45MC"] = {
	Cockpit = {
		[1] = {

			CockpitLocalPoint		= {5.10364, 0.77765, 0.0},
			CameraViewAngleLimits  = {20.000000,170.000000}, 
			CameraAngleRestriction = {false,90.000000,0.400000}, 
			CameraAngleLimits      = {200,-90.000000,90.000000}, 
			EyePoint               = {0.00000,-0.0,0.000000},
			ShoulderSize 		   = 0.15,
			--Allow360rotation       = false,
			Allow360rotation       = true,
			--limits_6DOF            = {x = {-0.15,0.28},y = {-0.35,.1},z = {-0.22,.22},roll = 90.000000},
			limits_6DOF            = {x = {-100.15,100.28},y = {-100.35,100.1},z = {-100.22,100.22},roll = 90.000000},
		},

		[2] = {

			CockpitLocalPoint      = {3.71, 1.07, 0.0},
			CameraViewAngleLimits  = { 30.0, 140.0 },
			CameraAngleLimits      = { 180, -80.0, 120.0 },
			CameraAngleRestriction = {false, 90.0, 0.50},

			EyePoint         = { 0,0,0.000000 },
			ShoulderSize     = 0.15,
			--Allow360rotation = false,
			Allow360rotation = true,
			--limits_6DOF      = { x = {-0.3, 0.25}, y = {-0.55, 0.04}, z = {-0.23, 0.23}, roll = 45.0 },
			limits_6DOF      = { x = {-100.3, 100.25}, y = {-100.55, 100.04}, z = {-100.23, 100.23}, roll = 45.0 },
			
		},

	}, -- Cockpit 

	Chase = {
		LocalPoint      = {0.200000,1.7000,-1.300000},
		AnglesDefault   = {0.000000,-5.000000},
	}, -- Chase 
	Arcade = {
		LocalPoint      = {-27.000000,12.000000,0.000000},
		AnglesDefault   = {0.000000,-12.000000},
	}, -- Arcade
}

ViewSettings["F-5E-3"] = {
	Cockpit = {
	[1] = {-- player slot 1
		CameraViewAngleLimits  = {20.000000,140.000000},
		CockpitLocalPoint      = {3.018,0.868,0.0},
		CameraAngleRestriction = {false,90.000000,0.500000},
		CameraAngleLimits      = {200,-90.000000,90.000000},
		EyePoint               = {0.05000,0.100000,0.000000},
		ShoulderSize		   = 0.25,
		Allow360rotation	   = true,
		limits_6DOF            = {x = {-100.05,100.21},y ={-100.10,100.08},z = {-100.19,100.19},roll = 90.000000},
	},
	}, -- Cockpit 
	Chase = {
		LocalPoint      = {-5.0,1.0,3.0},
		AnglesDefault   = {0.000000,0.000000},
	}, -- Chase 
	Arcade = {
		LocalPoint      = {-21.500000,5.618000,0.000000},
		AnglesDefault   = {0.000000,-8.000000},
	}, -- Arcade 
}