--mounting 3d model paths and texture paths 

mount_vfs_model_path (current_mod_path.."/Shapes")
mount_vfs_liveries_path (current_mod_path.."/Liveries")
mount_vfs_texture_path  (current_mod_path.."/Textures/Harrier")

Harrier_GR7 =  {
        
	Name 				=   'Harrier',
	DisplayName			= _('Harrier'),
	Cannon = "yes",
	HumanCockpit 		= true,
	HumanCockpitPath    = current_mod_path..'/Cockpit/',
	
	Picture 			= "Harrier.png",
	Rate 				= 40, -- RewardPoint in Multiplayer
	Shape 				= "Harrier",
	
	shape_table_data 	= 
	{
		{
			file  	 	= 'Harrier';
			life  	 	= 18; -- lifebar
			vis   	 	= 3; -- visibility gain.
			desrt    		= 'Harrier-oblomoki'; -- Name of destroyed object file name
			fire  	 	= { 300, 2}; -- Fire on the ground after destoyed: 300sec 2m
			username	= 'Harrier';
			index    	=  WSTYPE_PLACEHOLDER;
			classname 	= "lLandPlane";
			positioning = "BYNORMAL";
			drawonmap 	= true;
		},
		{
			name  = "Harrier-oblomoki";
			file  = "Harrier-oblomoki";
			fire  = { 240, 2};
		},

	},
	mapclasskey 		= "P0091000025",

attribute  			= {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER ,"Bombers",},

	Categories= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},	
	-------------------------
		M_empty	=	6340,
		M_nominal	=	9350,
		M_max	=	14100,
		M_fuel_max	=	4853,
		H_max	=	10000,
		average_fuel_consumption	=	0.25,
		CAS_min	=	64,
		V_opt	=	180,
		V_take_off	=	72,
		V_land	=	68,
		has_afteburner	=	false,
		has_speedbrake	=	true,
		main_gear_pos = 	{-0.714,	-1.309,	1.352},
		radar_can_see_ground	=	false,
		nose_gear_pos = 	{2.808,	-1.75,	0},
		AOA_take_off	=	0.192,
		stores_number	=	11,
		bank_angle_max	=	60,
		Ny_min	=	-3,
		Ny_max	=	5.9,
		tand_gear_max	=	0.150,
		V_max_sea_level	=	292,
		V_max_h	=	271,
		tanker_type	=	0,
		wing_area	=	22.61,
		wing_span	=	9.25,
		thrust_sum_max	=	15856,
		thrust_sum_ab	=	15856,
		Vy_max	=	60,
		length	=	14.12,
		height	=	3.55,
		flaps_maneuver	=	0.5,
		Mach_max	=	1.00,
		range	=	2250,
		crew_size	=	1,
		RCS	=	7,
		Ny_max_e	=	6.5,
		detection_range_max	=	75,
		IR_emission_coeff	=	0.53,
		IR_emission_coeff_ab	=	0,
		engines_count	=	2,
		wing_tip_pos = 	{-2.7,	-0.611,	7.18},
		nose_gear_wheel_diameter	=	0.754,
		main_gear_wheel_diameter	=	0.972,
		engines_nozzles = 
		{
			[1] = 
			{
				pos = 	{-1.193,	-0.191,	-0.616},
				elevation	=	0,
				diameter	=	0.6,
				exhaust_length_ab	=	8.631,
				exhaust_length_ab_K	=	0.76,
			}, -- end of [1]
			[2] = 
			{
				pos = 	{-1.193,	-0.191,	0.616},
				elevation	=	0,
				diameter	=	0.6,
				exhaust_length_ab	=	8.631,
				exhaust_length_ab_K	=	0.76,
			}, -- end of [2]
		}, -- end of engines_nozzles
		crew_members = 
		{
			[1] = 
			{
				ejection_seat_name	=	9,
				drop_canopy_name	=	38,
				pos = 	{3.029,	-0.092,	0},
			}, -- end of [1]
		}, -- end of crew_members
		brakeshute_name	=	4,
		is_tanker	=	false,
		air_refuel_receptacle_pos = 	{0,	0,	0},
		fires_pos = 
		{
			[1] = 	{-3.084,	-0.595,	-0.112},
			[2] = 	{-0.82,	0.275,	1.274},
			[3] = 	{-0.82,	0.275,	-1.274},
			[4] = 	{-0.82,	0.265,	2.774},
			[5] = 	{-0.82,	0.265,	-2.774},
			[6] = 	{-0.82,	0.255,	4.274},
			[7] = 	{-0.82,	0.255,	-4.274},
			[8] = 	{-2.87,	-0.596,	0.754},
			[9] = 	{-2.87,	-0.596,	-0.754},
			[10] = 	{-1.573,	0.145,	-2.172},
			[11] = 	{-1.924,	-0.04,	-1.934},
		}, -- end of fires_pos

		chaff_flare_dispenser = 
		{
			[1] = 
			{
				dir = 	{0,	1,	0},
				pos = 	{-3.677,	1.012,	-0.859},
			}, -- end of [1]
			[2] = 
			{
				dir = 	{0,	1,	0},
				pos = 	{-3.677,	1.012,	0.859},
			}, -- end of [2]
		}, -- end of chaff_flare_dispenser

       -- Countermeasures
SingleChargeTotal = 240,
CMDS_Incrementation = 30,
ChaffDefault = 120,
ChaffChargeSize = 1,
FlareDefault = 120,
FlareChargeSize = 1,
CMDS_Edit = true,
	
        CanopyGeometry = {
            azimuth = {-145.0, 145.0},
            elevation = {-50.0, 90.0}
        },

Sensors = {
RADAR = "AN/APG-78",
OPTIC = {"TADS DTV", "TADS DVO", "TADS FLIR"},
RWR = "Abstract RWR"
},

	HumanRadio = {
		frequency = 127.5,  -- Radio Freq
		editable = true,
		minFrequency = 100.000,
		maxFrequency = 156.000,
		modulation = MODULATION_AM
	},

ViewSettings = {
Cockpit = {
[1] = {-- player slot 1
CockpitLocalPoint = {5.100000,0.640000,0.000000},
		CameraViewAngleLimits  = {20.000000,120.000000},
		CameraAngleRestriction = {true,60.000000,0.400000},
		CameraAngleLimits      = {140.000000,-75.000000,90.000000},
		limits_6DOF            = {x = {-0.200000,0.200000},y ={-0.200000,0.200000},z = {-0.200000,0.200000},roll = 60.000000},
	},
	}, -- Cockpit 
	Chase = {
		LocalPoint      = {1.220000,3.750000,0.000000},
		AnglesDefault   = {180.000000,-8.000000},
	}, -- Chase 
	Arcade = {
		LocalPoint      = {-15.080000,6.350000,0.000000},
		AnglesDefault   = {0.000000,-8.000000},
	}, -- Arcade 
	},

Guns = {gun_mount("M_197", { count = 1200 },{muzzle_pos = {0.611000, -0.790000, 0.373000},ejector_pos = {0.21, -0.93, 0.50}, gatl_arg = 351})
},


	Pylons =     {

pylon(1, 0, -0.816000, -0.171000, 3.971000,
            {
                FiZ = 0,
            },
            {
                { CLSID = "{34271A1E-477E-4754-8C72-DF7C1855A782}" },
                { CLSID = "{6FBCDCD7-F984-4202-84A7-15173E02CC5B}" },
                { CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" },
                { CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}" },
            }
        ),
        pylon(2, 0, -0.296000, -0.134000, 3.232000,
            {
                FiZ = 0,
            },
            {
                { CLSID = "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}" },
                { CLSID = "{A76344EB-32D2-4532-8FA2-0C1BDC00747E}" },
                { CLSID = "{3DFB7321-AB0E-11d7-9897-000476191836}" },
                { CLSID = "{69DC8AE7-8F77-427B-B8AA-B19D3F478B66}" },
                { CLSID = "{D7670BC7-881B-4094-906C-73879CF7EB28}" },
                { CLSID = "{907D835F-E650-4154-BAFD-C656882555C0}" },
                { CLSID = "{E6A6262A-CA08-4B3D-B030-E1A993B98452}" },
                { CLSID = "{444BA8AE-82A7-4345-842E-76154EFCCA46}" },
                { CLSID = "{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}" },
                { CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" },
                { CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" },
                { CLSID = "{60CC734F-0AFA-4E2E-82B8-93B941AB11CF}" },
                { CLSID = "{B83CB620-5BBE-4BEA-910C-EB605A327EF9}" },
            }
        ),
        pylon(3, 0, 0.378000, 0.069000, 2.595000,
            {
                FiZ = 0,
            },
            {
                { CLSID = "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}" },
				{ CLSID = "{3DFB7321-AB0E-11d7-9897-000476191836}" },
                { CLSID = "{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}" },
                { CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" },
                { CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" },
                { CLSID = "{69DC8AE7-8F77-427B-B8AA-B19D3F478B66}" },
                
            }
        ),
        pylon(4, 0, 0.061000, -0.030000, 1.893000,
            {
                FiZ = 0,
            },
            {
                { CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" },
				{ CLSID = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}"}, -- GBU-10
                { CLSID = "{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}" },
                { CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" },
            }
        ),
 pylon(5, 0, 0.061000, -0.930000, 0.000000,
            {
				use_full_connector_position = true,
				FiX = 90,
            },
            {

            }
        ),
        pylon(6, 0, 0.061000, -0.030000, -1.893000,
            {
                FiZ = 0,
            },
            {
                { CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" },
				{ CLSID = "{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}"}, -- GBU-10
                { CLSID = "{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}" },
                { CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" },
            }
        ),
        pylon(7, 0, 0.378000, 0.069000, -2.595000,
            {
                FiZ = 0,
            },
            {
                { CLSID = "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}" },
                { CLSID = "{3DFB7321-AB0E-11d7-9897-000476191836}" },
                { CLSID = "{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}" },
                { CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" },
                { CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" },
                { CLSID = "{69DC8AE7-8F77-427B-B8AA-B19D3F478B66}" },
                
            }
        ),
        pylon(8, 0, -0.296000, -0.134000, -3.232000,
            {
                FiZ = 0,
            },
            {
                { CLSID = "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}" },
                { CLSID = "{A76344EB-32D2-4532-8FA2-0C1BDC00747E}" },
                { CLSID = "{3DFB7321-AB0E-11d7-9897-000476191836}" },
                { CLSID = "{69DC8AE7-8F77-427B-B8AA-B19D3F478B66}" },
                { CLSID = "{D7670BC7-881B-4094-906C-73879CF7EB27}" },
                { CLSID = "{907D835F-E650-4154-BAFD-C656882555C0}" },
                { CLSID = "{E6A6262A-CA08-4B3D-B030-E1A993B98453}" },
                { CLSID = "{444BA8AE-82A7-4345-842E-76154EFCCA46}" },
                { CLSID = "{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}" },
                { CLSID = "{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}" },
                { CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" },
                { CLSID = "{60CC734F-0AFA-4E2E-82B8-93B941AB11CF}" },
                { CLSID = "{B83CB620-5BBE-4BEA-910C-EB605A327EF9}" },
            }
        ),
        pylon(9, 0, -0.816000, -0.171000, -3.971000,
            {
                FiZ = 0,
            },
            {
                { CLSID = "{34271A1E-477E-4754-8C72-DF7C1855A782}" },
                { CLSID = "{6FBCDCD7-F984-4202-84A7-15173E02CC5B}" },
                { CLSID = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}" },
                { CLSID = "{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}" },
            }
        ),
},
	
	Tasks = {
        	aircraft_task(CAP),
	aircraft_task(Escort),
      	aircraft_task(FighterSweep),
	aircraft_task(GroundAttack),
      	aircraft_task(CAS),
       	aircraft_task(AFAC),
	aircraft_task(RunwayAttack),
	aircraft_task(AntishipStrike),
    },	
	DefaultTask = aircraft_task(CAS),

	SFM_Data = {
		aerodynamics = 
		{
			Cy0	=	0,
			Mzalfa	=	4.355,
			Mzalfadt	=	0.8,
			kjx	=	2.4,
			kjz	=	0.00125,
			Czbe	=	-0.016,
			cx_gear	=	0.0268,
			cx_flap	=	0.04,
			cy_flap	=	1.1, 
			cx_brk	=	0.06,
			table_data = 
			{
				[1] = 	{0,	0.0165,	0.07,	0.1,	0.032,	0.5,	30,	1.6},
				[2] = 	{0.2,	0.0165,	0.07,	0.1,	0.032,	1.5,	30,	1.5666666666667},
				[3] = 	{0.4,	0.0165,	0.07,	0.1,	0.032,	2.5,	30,	1.5333333333333},
				[4] = 	{0.6,	0.0165,	0.073,	0.094,	0.043,	3.5,	30,	1.5},
				[5] = 	{0.7,	0.017,	0.076,	0.094,	0.045,	3.5,	28.666666666667,	1.4333333333333},
				[6] = 	{0.8,	0.0178,	0.079,	0.094,	0.048,	3.5,	27.333333333333,	1.3666666666667},
				[7] = 	{0.9,	0.0215,	0.083,	0.11,	0.05,	3.5,	26,	1.3},
				[8] = 	{1,	0.031,	0.085,	0.15,	0.1,	3.5,	24.666666666667,	1.2333333333333},
				[9] = 	{1.05,	0.0366,	0.0855,	0.15,	0.1,	3.5,	24,	1.2},
				[10] = 	{1.1,	0.0422,	0.086,	0.15,	0.1,	3.15,	18,	1.1},
				[11] = 	{1.2,	0.044,	0.083,	0.14,	0.1,	2.45,	17,	1.05},
				[12] = 	{1.3,	0.0432,	0.077,	0.17,	0.096,	1.75,	16,	1},
				[13] = 	{1.5,	0.0423,	0.062,	0.23,	0.09,	1.5,	13,	0.9},
				[14] = 	{1.7,	0.041833333333333,	0.051333333333333,	0.23,	0.28333333333333,	0.9,	12,	0.7},
				[15] = 	{1.8,	0.0416,	0.046,	0.23,	0.38,	0.86,	11.4,	0.64},
				[16] = 	{2,	0.0416,	0.039,	0.08,	2.5,	0.78,	10.2,	0.52},
				[17] = 	{2.2,	0.0416,	0.034,	0.16,	3.2,	0.7,	9,	0.4},
				[18] = 	{2.5,	0.041,	0.033,	0.25,	4.5,	0.7,	9,	0.4},
				[19] = 	{3.9,	0.0395,	0.033,	0.35,	6,	0.7,	9,	0.4},
			}, -- end of table_data
		}, -- end of aerodynamics
		engine = 
		{
			Nmg	=	67.5,
			MinRUD	=	0,
			MaxRUD	=	1,
			MaksRUD	=	0.85,
			ForsRUD	=	0.91,
			typeng	=	1,
			hMaxEng	=	19,
			dcx_eng	=	0.0144,
			cemax	=	1.24,
			cefor	=	2.56,
			dpdh_m	=	7000,
			dpdh_f	=	12300,
			table_data = 
			{
				[1] = 	{0,	105840,	158564},
				[2] = 	{0.2,	97000,	163000},
				[3] = 	{0.4,	89000,	168000},
				[4] = 	{0.6,	89000,	176000},
				[5] = 	{0.7,	92000,	181000},
				[6] = 	{0.8,	95000,	186000},
				[7] = 	{0.9,	100000,	193000},
				[8] = 	{1,	105000,	203000},
				[9] = 	{1.1,	105000,	215000},
				[10] = 	{1.2,	107000,	225000},
				[11] = 	{1.3,	104000,	231000},
				[12] = 	{1.5,	102000,	251000},
				[13] = 	{1.8,	99000,	261000},
				[14] = 	{2,	87000,	270000},
				[15] = 	{2.2,	31033.3,	271000},
				[16] = 	{2.5,	29944.4,	221000},
				[17] = 	{3,	27222.2,	55000},
			}, -- end of table_data
		}, -- end of engine
	},


	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {
				[0]		= {critical_damage = 5, args = {146}},
				[3]		= {critical_damage = 20,args = {65}}  ,
				[4]		= {critical_damage = 20, args = {150}},
				[5]		= {critical_damage = 20, args = {147}},
				[7]		= {critical_damage = 4, args = {249}} ,
				[9]		= {critical_damage = 3, args = {154}},
				[10]	= {critical_damage = 3, args = {153}},
				[11]	= {critical_damage = 3, args = {167}},
				[12]	= {critical_damage = 3, args = {161}},
				[15]	= {critical_damage = 5, args = {267}},
				[16]	= {critical_damage = 5, args = {266}},
				[23]	= {critical_damage = 8, args = {223}, deps_cells = {25}},
				[24]	= {critical_damage = 8, args = {213}, deps_cells = {26, 60}},
				[25]	= {critical_damage = 3, args = {226}},
				[26]	= {critical_damage = 3, args = {216}},
				[29]	= {critical_damage = 9, args = {224}, deps_cells = {31, 25, 23}},
				[30]	= {critical_damage = 9, args = {214}, deps_cells = {32, 26, 24, 60}},
				[31]	= {critical_damage = 4, args = {229}},
				[32]	= {critical_damage = 4, args = {219}},
				[35]	= {critical_damage = 10, args = {225}, deps_cells = {29, 31, 25, 23}},
				[36]	= {critical_damage = 10, args = {215}, deps_cells = {30, 32, 26, 24, 60}} ,
				[37]	= {critical_damage = 4, args = {227}},
				[38]	= {critical_damage = 4, args = {217}},
				[39]	= {critical_damage = 7,	args = {244}, deps_cells = {53}},
				[40]	= {critical_damage = 7, args = {241}, deps_cells = {54}},
				[45]	= {critical_damage = 9, args = {235}, deps_cells = {39, 51, 53}},
				[46]	= {critical_damage = 9, args = {233}, deps_cells = {40, 52, 54}},
				[51]	= {critical_damage = 3, args = {239}},
				[52]	= {critical_damage = 3, args = {237}},
				[53]	= {critical_damage = 3, args = {248}},
				[54]	= {critical_damage = 3, args = {247}},
				[55]	= {critical_damage = 20, args = {81}, deps_cells = {39, 40, 45, 46, 51, 52, 53, 54}},
				[59]	= {critical_damage = 5, args = {148}},
				[60]	= {critical_damage = 1, args = {144}},

				[83]	= {critical_damage = 3, args = {134}} ,-- nose wheel
				[84]	= {critical_damage = 3, args = {136}}, -- left wheel
				[85]	= {critical_damage = 3, args = {135}} ,-- right wheel
	},
	
	DamageParts = 
	{  
		[1] = "Harrier-oblomok-wing-r", -- wing R
		[2] = "Harrier-oblomok-wing-l", -- wing L
		[3] = "Harrier-part-nose", -- nose
		[4] = "Harrier-oblomok_tail", -- tail
	},
	
	lights_data = {	typename = "collection", lights = {
    [1] = {typename = "collection",lights = {}},
	[2] = {typename = "collection",
			lights = {-- Landing light
					  {typename = "spotlight",
					   connector = "MAIN_SPOT_PTR_02",
					   argument = 209,
					   dir_correction = {elevation = math.rad(-1)}
					  },
					  {-- Landing/Taxi light
					   typename = "spotlight",
					   connector = "MAIN_SPOT_PTR_01",
					   argument = 208,
					   dir_correction = {elevation = math.rad(3)}
					  }
					 }
			},
    [3]	= {typename = "collection",
			lights = {-- Left Position Light (red)
					  {typename = "omnilight",
					   connector = "BANO_1",
					   color = {0.99, 0.11, 0.3},
					   pos_correction  = {0, 0, -0.2},
					   argument  = 190
					  },
					  -- Right Position Light (green)
					  {typename = "omnilight",
					   connector = "BANO_2",
					   color = {0, 0.894, 0.6},
					   pos_correction = {0, 0, 0.2},
					   argument  = 191
					  }}
			},
    [4] = {typename = "collection",lights = {}},
	[5]	= {typename = "collection",lights = {}},
	}},
       Countries = {"USA", "Germany", "France"},

	
	
}

add_aircraft(Harrier_GR7)
