local cockpit = folder.."../../../Cockpit/Scripts/"
dofile(cockpit.."devices.lua")
dofile(cockpit.."command_defs.lua")

local res = external_profile("Config/Input/Aircrafts/common_keyboard_binding.lua")

join(res.keyCommands,{
-- Controls
{combos = {{key = 'Up'}},									down = iCommandPlaneUpStart,	up = iCommandPlaneUpStop,							name = _('Cyclic - Nose Down'),				category = {_('Ins Cyclic Stick'), _('Flight Control')}},
{combos = {{key = 'Down'}},									down = iCommandPlaneDownStart,	up = iCommandPlaneDownStop,							name = _('Cyclic - Nose Up'),				category = {_('Ins Cyclic Stick'), _('Flight Control')}},
{combos = {{key = 'Left'}},									down = iCommandPlaneLeftStart,	up = iCommandPlaneLeftStop,							name = _('Cyclic - Bank Left'),				category = {_('Ins Cyclic Stick'), _('Flight Control')}},
{combos = {{key = 'Right'}},								down = iCommandPlaneRightStart,	up = iCommandPlaneRightStop,						name = _('Cyclic - Bank Right'),			category = {_('Ins Cyclic Stick'), _('Flight Control')}},
{combos = {{key = 'Space', reformers = {'RAlt'}}}, down = iCommandPlanePickleOn,    up = iCommandPlanePickleOff, name = _('Release weapons'), category = {_('Ins Cyclic Stick'), _('Weapon')}},

{combos = {{key = '\\', 	reformers = {'RAlt'}}},			 down = SPU_8_Mi24_commands.CMD_SPU8_TRIGGER_EXT,	up = SPU_8_Mi24_commands.CMD_SPU8_TRIGGER_EXT, cockpit_device_id = devices.SPU_8, value_down = 1.0, value_up = 0.0,		name = _('Radio trigger - RADIO'),			category = {_('Ins Cyclic Stick'), _('Communications')}},
{combos = {{key = 'Space',	reformers = {'RShift'}}},		 down = SPU_8_Mi24_commands.CMD_SPU8_TRIGGER_EXT,	up = SPU_8_Mi24_commands.CMD_SPU8_TRIGGER_EXT, cockpit_device_id = devices.SPU_8, value_down = 0.5, value_up = 0.0,		name = _('Radio trigger - ICS'),			category = {_('Ins Cyclic Stick'), _('Communications')}},

{combos = {{key = 'Num+'}},							down = iCommandPlaneCollectiveIncrease, pressed = iCommandPlaneCollectiveIncrease, up = iCommandPlaneCollectiveStop,				name = _('Collective - Up'),									category = {_('Ins Collective Stick'), _('Flight Control')}},
{combos = {{key = 'Num-'}},							down = iCommandPlaneCollectiveDecrease, pressed = iCommandPlaneCollectiveDecrease, up = iCommandPlaneCollectiveStop,				name = _('Collective - Down'),									category = {_('Ins Collective Stick'), _('Flight Control')}},
{combos = {{key = 'Num+', reformers = {'RAlt'}}},	down = iCommandPlane_ReadjustFreeTurbineRPM_Up,		up = iCommandPlane_ReadjustFreeTurbineRPM_Up,	value_down =  1, value_up = 0,	name = _('Readjust Free Turbine RPM Switch - Increase'),		category = {_('Ins Collective Stick'), _('Engines')}},
{combos = {{key = 'Num-', reformers = {'RAlt'}}},	down = iCommandPlane_ReadjustFreeTurbineRPM_Down,	up = iCommandPlane_ReadjustFreeTurbineRPM_Down,	value_down = -1, value_up = 0,	name = _('Readjust Free Turbine RPM Switch - Decrease'),		category = {_('Ins Collective Stick'), _('Engines')}},
{combos = {{key = 'F'}},							down = iCommandHelicopter_CollectiveStopper_Up,		up = iCommandHelicopter_CollectiveStopper_Down,									name = _('Collective brake - Assign altitude lever'),			category = {_('Ins Collective Stick'), _('Flight Control')}},
{combos = {{key = 'PageUp'}},						down = iCommandThrottleIncrease,	up = iCommandThrottleStop,																		name = _('Correction Lever - Increase'),						category = {_('Ins Collective Stick'), _('Engines')}},
{combos = {{key = 'PageDown'}},						down = iCommandThrottleDecrease,	up = iCommandThrottleStop,																		name = _('Correction Lever - Decrease'),						category = {_('Ins Collective Stick'), _('Engines')}},

{combos = {{key = 'T'}},     								down = iCommandPlaneTrimOn, up = iCommandPlaneTrimOff,																							name = _('Trimmer Button'),					category = {_('Ins Cyclic Stick'), _('Trimmer')}},
{combos = {{key = 'T', reformers = {'LCtrl'}}},				down = iCommandPlaneTrimCancel,																													name = _('Trimmer - Reset'),				category = {_('Ins Cyclic Stick'), _('Trimmer')}},

{combos = {{key = '.', reformers = {'RCtrl'}}},	pressed = iCommandPlaneTrimUp,			up = iCommandPlaneTrimStop, name = _('Trim: Nose Up'),			category = {_('Ins Cyclic Stick'), _('Trimmer')}},
{combos = {{key = ';', reformers = {'RCtrl'}}},	pressed = iCommandPlaneTrimDown,		up = iCommandPlaneTrimStop, name = _('Trim: Nose Down'),		category = {_('Ins Cyclic Stick'), _('Trimmer')}},
{combos = {{key = ',', reformers = {'RCtrl'}}},	pressed = iCommandPlaneTrimLeft,		up = iCommandPlaneTrimStop, name = _('Trim: Left Wing Down'),	category = {_('Ins Cyclic Stick'), _('Trimmer')}},
{combos = {{key = '/', reformers = {'RCtrl'}}},	pressed = iCommandPlaneTrimRight,		up = iCommandPlaneTrimStop, name = _('Trim: Right Wing Down'),	category = {_('Ins Cyclic Stick'), _('Trimmer')}},
--{combos = {{key = 'Z', reformers = {'RCtrl'}}},	pressed = iCommandPlaneTrimLeftRudder,	up = iCommandPlaneTrimStop, name = _('Trim: Rudder Left'),		category = {_('Ins Cyclic Stick'), _('Trimmer')}},
--{combos = {{key = 'X', reformers = {'RCtrl'}}},	pressed = iCommandPlaneTrimRightRudder,	up = iCommandPlaneTrimStop, name = _('Trim: Rudder Right'),		category = {_('Ins Cyclic Stick'), _('Trimmer')}},

{combos = {{key = 'W'}},									down = iCommandPlaneWheelBrakeOn,	up = iCommandPlaneWheelBrakeOff,																			name = _('Wheel Brake'),					category = {_('Ins Cyclic Stick')}},
{combos = {{key = 'W', reformers = {'LShift'}}},			down = iCommandPlaneWheelParkingBrake,																											name = _('Wheel Parking Brake'),			category = {_('Ins Cyclic Stick')}},

{combos = {{key = 'Z'}},	down = iCommandPlaneLeftRudderStart,	up = iCommandPlaneLeftRudderStop,	name = _('Rudder Left'),	category = {_('Ins Rudder'), _('Flight Control')}},
{combos = {{key = 'X'}},	down = iCommandPlaneRightRudderStart,	up = iCommandPlaneRightRudderStop,	name = _('Rudder Right'),	category = {_('Ins Rudder'), _('Flight Control')}},
-- Cockpit elements hide/show:
{							down = cockpit_mechanics_commands.Command_CPT_MECH_Elements_Hide,		cockpit_device_id = devices.CPT_MECH,	value_down =  1.0,	name = _('Cockpit elements - HIDE'),			category = {_('Cockpit elements')}},
{							down = cockpit_mechanics_commands.Command_CPT_MECH_Elements_Hide,		cockpit_device_id = devices.CPT_MECH,	value_down =  0.0,	name = _('Cockpit elements - SHOW'),			category = {_('Cockpit elements')}},
{combos = {{key = 'Back'}},	down = cockpit_mechanics_commands.Command_CPT_MECH_Elements_Hide_EXT,	cockpit_device_id = devices.CPT_MECH,	value_down =  1.0,	name = _('Cockpit elements - HIDE/SHOW'),		category = {_('Cockpit elements')}},

-- Cheat ---------------------------------------

{combos = {{key = 'Home', reformers = {'LWin'}}},	down = iCommandEnginesStart,	name = _('Auto Start'),	category = _('Cheat')},
{combos = {{key = 'End' , reformers = {'LWin'}}},	down = iCommandEnginesStop,		name = _('Auto Stop'),	category = _('Cheat')},

-- View Cockpit 

{combos = {{key = '1'}},	down = headwrapper_commands.PilotSeat,	value_down = 1, cockpit_device_id = devices.HEAD_WRAPPER, name = _('Set Pilot Seat'),	category = _('View Cockpit')},
{combos = {{key = '2'}},	down = headwrapper_commands.OpSeat,		value_down = 1, cockpit_device_id = devices.HEAD_WRAPPER, name = _('Set Operator Seat'),	category = _('View Cockpit')},

-- General
{combos = {{key = 'Tab', reformers = {'RCtrl'}}}, down = iCommandFriendlyChat, name = _('Multiplayer chat - mode Allies'), category = _('General')},
{combos = {{key = 'P', reformers = {'RShift'}}}, down = iCommandCockpitShowPilotOnOff, name = _('Show Pilot Body'), category = _('General')},
--{combos = {{key = 'Pause', reformers = {'RShift'}}}, down = iCommandActivePauseOnOff, name = 'Active Pause', category = 'General'},
{combos = {{key = 'S', reformers = {'LCtrl','LShift'}}}, down = iCommandSoundMicOn, name = _('Sound recording start'), category = _('General')},
{combos = {{key = 'X', reformers = {'LCtrl','LShift'}}}, down = iCommandSoundMicOff, name = _('Sound recording stop'), category = _('General')},
{combos = {{key = 'E', reformers = {'RCtrl','RShift'}}}, down = iCommandTrackEditReplace, name = _('Track edit replace mode'), category = _('General')},
{combos = {{key = 'W', reformers = {'RCtrl','RShift'}}}, down = iCommandTrackEditInsert, name = _('Track edit insert mode'), category = _('General')},
{combos = {{key = 'Scroll', reformers = {'RShift'}}}, down = iCommandRecordSubtitleOn, name = _('Subtitle recording begin'), category = _('General')},
{combos = {{key = 'Scroll', reformers = {'RCtrl'}}}, down = iCommandRecordSubtitleOff, name = _('Subtitle recording end'), category = _('General')},
--{combos = {{key = 'Pause', reformers = {'RAlt'}}}, down = iCommandOneFrame, name = 'One frame mode', category = 'General'},

-- Engines Levers ------------------------------
------------------------------------------------
{combos = {{key = 'Home', reformers = {'RCtrl'}}},		cockpit_device_id = devices.ENGINE_INTERFACE, down = engine_commands.END_THROTTLES_ITER, value_down = 1.0,				name = _('Throttle Up'),									category = _('Engines')},
{combos = {{key = 'End', reformers = {'RCtrl'}}},		cockpit_device_id = devices.ENGINE_INTERFACE, down = engine_commands.END_THROTTLES_ITER, value_down = -1.0,				name = _('Throttle Down'),									category = _('Engines')},
{combos = {{key = 'PageUp', reformers = {'RAlt'}}},		cockpit_device_id = devices.ENGINE_INTERFACE, down = engine_commands.CONTROL_LEFT_THROTTLE_ITER, value_down = 1.0,		name = _('Left Throttle up (Idle-Medium-Auto-Full)'),		category = _('Engines')},
{combos = {{key = 'PageDown', reformers = {'RAlt'}}},	cockpit_device_id = devices.ENGINE_INTERFACE, down = engine_commands.CONTROL_LEFT_THROTTLE_ITER, value_down = -1.0,		name = _('Left Throttle down (Idle-Medium-Auto-Full)'),		category = _('Engines')},
{combos = {{key = 'PageUp', reformers = {'RShift'}}},	cockpit_device_id = devices.ENGINE_INTERFACE, down = engine_commands.CONTROL_RIGHT_THROTTLE_ITER, value_down = 1.0,		name = _('Right Throttle up (Idle-Medium-Auto-Full)'),		category = _('Engines')},
{combos = {{key = 'PageDown', reformers = {'RShift'}}},	cockpit_device_id = devices.ENGINE_INTERFACE, down = engine_commands.CONTROL_RIGHT_THROTTLE_ITER, value_down = -1.0,	name = _('Right Throttle down (Idle-Medium-Auto-Full)'),	category = _('Engines')},
{combos = {{key = 'PageUp', reformers = {'RCtrl'}}},	down = iCommandHelicopter_Left_Engine_Lock,																				name = _('Cut-off valve left engine'),						category = _('Engines')},
{combos = {{key = 'PageDown', reformers = {'RCtrl'}}},	down = iCommandHelicopter_Right_Engine_Lock,																			name = _('Cut-off valve right engine'),						category = _('Engines')},
{combos = {{key = 'R', reformers = {'RCtrl'}}},			down = iCommandHelicopter_Rotor_Lock,																					name = _('Rotor Brake Handle - UP/DOWN'),					category = _('Engines')},
{														down = engine_commands.LEVER_Rotor_Lock, cockpit_device_id = devices.ENGINE_INTERFACE,	value_down = 1.0,				name = _('Rotor Brake Handle - UP'),						category = _('Engines')},
{														down = engine_commands.LEVER_Rotor_Lock, cockpit_device_id = devices.ENGINE_INTERFACE,	value_down = 0.0,				name = _('Rotor Brake Handle - DOWN'),						category = _('Engines')},

{combos = {{key = 'Home'}},									down = iCommandHelicopter_Selected_Engine_start,			up = iCommandHelicopter_Selected_Engine_start_up,										name = _('Start-up Engine Button'),						category = {_('Left Side Panel'), _('Engines')}},
{combos = {{key = 'Home', reformers = {'RAlt'}}},			down = iCommandHelicopter_Selected_Engine_interrupt_start,	up = iCommandHelicopter_Selected_Engine_interrupt_start_up,								name = _('Interrupt Start-up Sequence Button'),			category = {_('Left Side Panel'), _('Engines')}},
{combos = {{key = 'Home', reformers = {'RShift'}}},			down = iCommandPlane_APU_Start,								up = iCommandPlane_APU_Off,																name = _('Start APU Button'),							category = {_('Left Side Panel'), _('Engines')}},
{combos = {{key = 'End'}},									down = iCommandHelicopter_APU_stop,							up = iCommandHelicopter_APU_stop_up,													name = _('Stop APU Button'),							category = {_('Left Side Panel'), _('Engines')}},
{															down = engine_commands.STARTUP_Engine_Select,	cockpit_device_id = devices.ENGINE_INTERFACE,	value_down = -1,									name = _('Engine Selector Switch - LEFT'),				category = {_('Left Side Panel'), _('Engines')}},
{															down = engine_commands.STARTUP_Engine_Select,	cockpit_device_id = devices.ENGINE_INTERFACE,	value_down = 0,										name = _('Engine Selector Switch - OFF'),				category = {_('Left Side Panel'), _('Engines')}},
{															down = engine_commands.STARTUP_Engine_Select,	cockpit_device_id = devices.ENGINE_INTERFACE,	value_down = 1,										name = _('Engine Selector Switch - RIGHT'),				category = {_('Left Side Panel'), _('Engines')}},
{combos = {{key = 'E', reformers = {'LShift'}}},			down = iCommandEngineLaunchMethod,													value_down = 1,													name = _('Engine Start Mode Switch - Up'),				category = {_('Left Side Panel'), _('Engines')}},
{combos = {{key = 'E', reformers = {'LAlt'}}},				down = iCommandEngineLaunchMethod,													value_down = -1,												name = _('Engine Start Mode Switch - Down'),			category = {_('Left Side Panel'), _('Engines')}},
{															down = engine_commands.STARTUP_Engine_Launch_Method,	cockpit_device_id = devices.ENGINE_INTERFACE,	value_down = -1,							name = _('Engine Start Mode Switch - COLD CRANKING'),	category = {_('Left Side Panel'), _('Engines')}},
{															down = engine_commands.STARTUP_Engine_Launch_Method,	cockpit_device_id = devices.ENGINE_INTERFACE,	value_down = 0,								name = _('Engine Start Mode Switch - OFF'),				category = {_('Left Side Panel'), _('Engines')}},
{															down = engine_commands.STARTUP_Engine_Launch_Method,	cockpit_device_id = devices.ENGINE_INTERFACE,	value_down = 1,								name = _('Engine Start Mode Switch - START'),			category = {_('Left Side Panel'), _('Engines')}},
{combos = {{key = 'E', reformers = {'RCtrl'}}},				down = engine_commands.STARTUP_APU_Launch_Method_EXT,	cockpit_device_id = devices.ENGINE_INTERFACE,	value_down = 1,								name = _('APU Start Mode Switch - Up'),					category = {_('Left Side Panel'), _('Engines')}},
{combos = {{key = 'E', reformers = {'RAlt'}}},				down = engine_commands.STARTUP_APU_Launch_Method_EXT,	cockpit_device_id = devices.ENGINE_INTERFACE,	value_down = -1,							name = _('APU Start Mode Switch - Down'),				category = {_('Left Side Panel'), _('Engines')}},
{															down = engine_commands.STARTUP_APU_Launch_Method,		cockpit_device_id = devices.ENGINE_INTERFACE,	value_down = -1,							name = _('APU Start Mode Switch - FALSE START'),		category = {_('Left Side Panel'), _('Engines')}},
{															down = engine_commands.STARTUP_APU_Launch_Method,		cockpit_device_id = devices.ENGINE_INTERFACE,	value_down = 0,								name = _('APU Start Mode Switch - COLD CRANKING'),		category = {_('Left Side Panel'), _('Engines')}},
{															down = engine_commands.STARTUP_APU_Launch_Method,		cockpit_device_id = devices.ENGINE_INTERFACE,	value_down = 1,								name = _('APU Start Mode Switch - START'),				category = {_('Left Side Panel'), _('Engines')}},


--HydroInterface
{combos = {{key = 'J', reformers = {'LShift','LAlt'}}},		down = hydraulic_commands.MainHydro_EXT,																										cockpit_device_id = devices.HYDRO_SYS_INTERFACE,		value_down = 1,							name = _('Main/Auxiliary Hydraulic Switch - AUXILIARY'),			category = {_('Left Front Instrument Panel')}},
{combos = {{key = 'K', reformers = {'LShift','LAlt'}}},		down = hydraulic_commands.MainHydro_EXT,																										cockpit_device_id = devices.HYDRO_SYS_INTERFACE,		value_down = 0,							name = _('Main/Auxiliary Hydraulic Switch - MAIN'),					category = {_('Left Front Instrument Panel')}},
{combos = {{key = 'L', reformers = {'LShift','LAlt'}}},		down = hydraulic_commands.MainHydro_ITER,																										cockpit_device_id = devices.HYDRO_SYS_INTERFACE,		value_down = 1,							name = _('Main/Auxiliary Hydraulic Switch - MAIN/AUXILIARY'),		category = {_('Left Front Instrument Panel')}},
{combos = {{key = ';', reformers = {'LShift','LAlt'}}},		down = hydraulic_commands.GearHydro_EXT,																										cockpit_device_id = devices.HYDRO_SYS_INTERFACE,		value_down = 1,							name = _('Main/Reserve Gear Hydraulic Switch - RESERVE'),			category = {_('Left Front Instrument Panel')}},
{combos = {{key = '\'', reformers = {'LShift','LAlt'}}},	down = hydraulic_commands.GearHydro_EXT,																										cockpit_device_id = devices.HYDRO_SYS_INTERFACE,		value_down = 0,							name = _('Main/Reserve Gear Hydraulic Switch - MAIN'),				category = {_('Left Front Instrument Panel')}},
{combos = {{key = 'G', reformers = {'LShift','LAlt'}}},		down = hydraulic_commands.GearHydro_ITER,																										cockpit_device_id = devices.HYDRO_SYS_INTERFACE,		value_down = 1,							name = _('Main/Reserve Gear Hydraulic Switch - MAIN/RESERVE'),		category = {_('Left Front Instrument Panel')}},
{combos = {{key = '\\', reformers = {'LShift','LAlt'}}},	down = hydraulic_commands.DisableAuxiliaryHydro_EXT,					up = hydraulic_commands.DisableAuxiliaryHydro_EXT,						cockpit_device_id = devices.HYDRO_SYS_INTERFACE,	 	value_down = 1,	 	value_up = 0,		name = _('Auxiliary Disable Button'),								category = {_('Left Front Instrument Panel')}},

--CockpitMechanics
{combos = {{key = 'G', reformers = {'LAlt'}}}, 				down = iCommandEmergencyGear, 																																											value_down = 1,							name = _('Emeregency Gear Lever'), 									category = {_('Instrument Panel')}},
{combos = {{key = 'G', reformers = {'LCtrl'}}},				down = iCommandPlaneGearUp,																																												value_down = 1,							name = _('Gear Lever - UP'),										category = {_('Instrument Panel')}},
{combos = {{key = 'G', reformers = {'LShift'}}},			down = iCommandPlaneGearDown,																																											value_down = 0,							name = _('Gear Lever - DOWN'),										category = {_('Instrument Panel')}},
{combos = {{key = 'G'}},									down = iCommandPlaneGear,																																												value_down = 1,							name = _('Gear Lever - UP/DOWN'),									category = {_('Instrument Panel')}},
{combos = {{key = 'G', reformers = {'LCtrl','LAlt'}}},		down = cockpit_mechanics_commands.Command_CPT_MECH_Gear_Pilot_Lock,		up = cockpit_mechanics_commands.Command_CPT_MECH_Gear_Pilot_Lock,		cockpit_device_id = devices.CPT_MECH,	 				value_down = 1,	 	value_up = 0,		name = _('Gear Lever Lock, UP/DOWN'),								category = {_('Instrument Panel')}},
{combos = {{key = 'Z', reformers = {'LShift','LCtrl'}}},	down = cockpit_mechanics_commands.Command_CPT_MECH_WindSprayerEXT,		up = cockpit_mechanics_commands.Command_CPT_MECH_WindSprayerEXT,		cockpit_device_id = devices.CPT_MECH,	 				value_down = 1,	 	value_up = 0,		name = _('Window Sprayer Button'),									category = {_('Left panel')}},
{combos = {{key = 'M', }},									down = iCommandToggleMirrors,	name = _('Mirror ON/OFF'), category = {_('Cockpit elements')}},


--{down = device_commands.Button_34, 		cockpit_device_id = devices.WEAP_SYS, name = _(''),	category = {_('Weapon')}},
{up = iCommandPlaneFireOff, down = iCommandPlaneFire, 			name = _('Fire Weapon'),			category = {_('Weapon')}},

{down = weapon_commands.SWITCHER_SAFE_WEAP_Ext, 					cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Main Weapon Safe Switch'),			category = {_('Weapon')}},
{down = weapon_commands.Pilot_NPU_CHAIN_Ext, 						cockpit_device_id = devices.WEAP_SYS, value_down = 1, 	name = _('Pilot Burst Length SHORT/MED/LONG Up'),		category = {_('Weapon')}},
{down = weapon_commands.Pilot_NPU_CHAIN_Ext, 						cockpit_device_id = devices.WEAP_SYS, value_down = -1, 	name = _('Pilot Burst Length SHORT/MED/LONG Down'),	category = {_('Weapon')}},
{down = weapon_commands.Pilot_RELOAD_LEFT_Ext, 						cockpit_device_id = devices.WEAP_SYS, value_down = 1, 	name = _('Reload Left Gondola Up'),				category = {_('Weapon')}},
{down = weapon_commands.Pilot_RELOAD_LEFT_Ext, 						cockpit_device_id = devices.WEAP_SYS, value_down = -1, 	name = _('Reload Left Gondola Down'),			category = {_('Weapon')}},
{down = weapon_commands.Pilot_RELOAD_RIGHT_Ext, 					cockpit_device_id = devices.WEAP_SYS, value_down = 1, 	name = _('Reload Right Gondola Up'),			category = {_('Weapon')}},
{down = weapon_commands.Pilot_RELOAD_RIGHT_Ext, 					cockpit_device_id = devices.WEAP_SYS, value_down = -1, 	name = _('Reload Right Gondola Down'),			category = {_('Weapon')}},
{down = weapon_commands.Pilot_FKP_CAMERA_Ext, 						cockpit_device_id = devices.WEAP_SYS, value_down = 1, 	name = _('Camera ON/OFF'),						category = {_('Weapon')}},
{down = weapon_commands.Pilot_SWITCHER_OFF_GM_URS_NPU_Iter, 			cockpit_device_id = devices.WEAP_SYS, value_down = -1,	name = _('Select Weapon Pilot Prev'),					category = {_('Weapon')}},
{down = weapon_commands.Pilot_SWITCHER_OFF_GM_URS_NPU_Iter, 			cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Select Weapon Pilot Next'),					category = {_('Weapon')}},

{combos = {{key = '1', reformers = {'LAlt'}}}, down = weapon_commands.Pilot_SWITCHER_OFF_GM_URS_NPU_Ext, cockpit_device_id = devices.WEAP_SYS, value_down = 0,		name = _('Select Weapon Pilot 1 OFF MSL'),			category = {_('Weapon')}},
{combos = {{key = '2', reformers = {'LAlt'}}}, down = weapon_commands.Pilot_SWITCHER_OFF_GM_URS_NPU_Ext, cockpit_device_id = devices.WEAP_SYS, value_down = 0.1,	name = _('Select Weapon Pilot 2 GM-30'),			category = {_('Weapon')}},
{combos = {{key = '3', reformers = {'LAlt'}}}, down = weapon_commands.Pilot_SWITCHER_OFF_GM_URS_NPU_Ext, cockpit_device_id = devices.WEAP_SYS, value_down = 0.2,	name = _('Select Weapon Pilot 3 FXD MG7.62+12.7'),	category = {_('Weapon')}},
{combos = {{key = '4', reformers = {'LAlt'}}}, down = weapon_commands.Pilot_SWITCHER_OFF_GM_URS_NPU_Ext, cockpit_device_id = devices.WEAP_SYS, value_down = 0.3,	name = _('Select Weapon Pilot 4 FXD MG-12.7'),		category = {_('Weapon')}},
{combos = {{key = '5', reformers = {'LAlt'}}}, down = weapon_commands.Pilot_SWITCHER_OFF_GM_URS_NPU_Ext, cockpit_device_id = devices.WEAP_SYS, value_down = 0.4,	name = _('Select Weapon Pilot 5 FXD MG-7.62'),		category = {_('Weapon')}},
{combos = {{key = '6', reformers = {'LAlt'}}}, down = weapon_commands.Pilot_SWITCHER_OFF_GM_URS_NPU_Ext, cockpit_device_id = devices.WEAP_SYS, value_down = 0.5,	name = _('Select Weapon Pilot 6 FXD MG-30'),		category = {_('Weapon')}},
{combos = {{key = '7', reformers = {'LAlt'}}}, down = weapon_commands.Pilot_SWITCHER_OFF_GM_URS_NPU_Ext, cockpit_device_id = devices.WEAP_SYS, value_down = 0.6,	name = _('Select Weapon Pilot 7 ROCKET'),			category = {_('Weapon')}},
{combos = {{key = '8', reformers = {'LAlt'}}}, down = weapon_commands.Pilot_SWITCHER_OFF_GM_URS_NPU_Ext, cockpit_device_id = devices.WEAP_SYS, value_down = 0.7,	name = _('Select Weapon Pilot 8 BOMB'),				category = {_('Weapon')}},
{combos = {{key = '9', reformers = {'LAlt'}}}, down = weapon_commands.Pilot_SWITCHER_OFF_GM_URS_NPU_Ext, cockpit_device_id = devices.WEAP_SYS, value_down = 0.8,	name = _('Select Weapon Pilot 9 USLP'),				category = {_('Weapon')}},

{down = weapon_commands.Pilot_BOTH_LEFT_RIGHT_Ext, 					cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Select Rockets LEFT/BOTH/RIGHT Right'),		category = {_('Weapon')}},
{down = weapon_commands.Pilot_BOTH_LEFT_RIGHT_Ext, 					cockpit_device_id = devices.WEAP_SYS, value_down = -1,	name = _('Select Rockets LEFT/BOTH/RIGHT Left'),		category = {_('Weapon')}},
{down = weapon_commands.Pilot_SWITCHER_FIRE_CONTROL_UP_Ext, 		cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Weapon Control ON'),							category = {_('Weapon')}},
{down = weapon_commands.Pilot_SWITCHER_FIRE_CONTROL_DOWN_Ext, 		cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Weapon Control OFF'),							category = {_('Weapon')}},
{down = weapon_commands.Pilot_TEMP_NPU30_Ext, 						cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Pilot Cannon Fire Rate SLOW/FAST'),			category = {_('Weapon')}},
{down = weapon_commands.Pilot_RELOAD_NPU30_Ext, up = weapon_commands.Pilot_RELOAD_NPU30_Ext, cockpit_device_id = devices.WEAP_SYS, value_down = 1, value_up = 0,	name = _('Pilot Reload Cannon'),	category = {_('Weapon')}},
{down = weapon_commands.Pilot_STOP_KMG_Ext, 						cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Stop container'),						category = {_('Weapon')}},
{down = weapon_commands.Pilot_EMERG_EXPLODE_Ext, 					cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Pilot Explosion on Jettison ON/OFF '),		category = {_('Weapon')}},
{down = weapon_commands.Pilot_EMERG_EXPLODE_COVER_Ext, 				cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Pilot Explosion on Jettison Cover, UP/DOWN'),	category = {_('Weapon')}},
{down = weapon_commands.Pilot_EMERG_RELEASE_Ext, 					cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Pilot Jettison Pylons ON/OFF'),				category = {_('Weapon')}},
{down = weapon_commands.Pilot_EMERG_RELEASE_COVER_Ext, 				cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Pilot Jettison Pylons Cover, UP/DOWN'),		category = {_('Weapon')}},
{down = weapon_commands.Pilot_EMERG_RELEASE_PU_Ext, 				cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Pilot Jettison Launcher ON/OFF'),			category = {_('Weapon')}},
{down = weapon_commands.Pilot_EMERG_RELEASE_PU_COVER_Ext, 			cockpit_device_id = devices.WEAP_SYS, 	value_down = 1,	name = _('Pilot Jettison Launcher Cover, UP/DOWN'),	category = {_('Weapon')}},
{down = weapon_commands.Pilot_PUS_ARMING, up = weapon_commands.Pilot_PUS_ARMING_Ext, cockpit_device_id = devices.WEAP_SYS, value_down = 1, value_up = 0, name = _('Arm Rockets'),	category = {_('Weapon')}},


{down = weapon_commands.Pilot_Counter1_Inc, 				cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Ammo Counter 1 Increment'),			category = {_('Weapon')}},
{down = weapon_commands.Pilot_Counter2_Inc, 				cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Ammo Counter 2 Increment'),			category = {_('Weapon')}},
{down = weapon_commands.Pilot_Counter3_Inc, 				cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Ammo Counter 3 Increment'),			category = {_('Weapon')}},
{down = weapon_commands.Pilot_Counter4_Inc, 				cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Ammo Counter 4 Increment'),			category = {_('Weapon')}},
{down = weapon_commands.Pilot_Counter5_Inc, 				cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Ammo Counter 5 Increment'),			category = {_('Weapon')}},

--SPO-10
{down = SPO_commands.Command_SPO_POWER_Ext, 		cockpit_device_id = devices.SPO_10, value_down = 1,	name = _('RWR Power'),			category = {_('RWR')}},
{down = SPO_commands.Command_SPO_SIGNAL_Ext, 		cockpit_device_id = devices.SPO_10, value_down = 1, name = _('RWR Signal On/Off'),	category = {_('RWR')}},
{down = SPO_commands.Command_DAY_NIGHT_Ext, 		cockpit_device_id = devices.SPO_10, value_down = -1, name = _('RWR DAY/NIGHT'),		category = {_('RWR')}},

--ASO-2V
{down = avASO_2V_commands.ASO_2V_Release_Pilot_Ext, up = avASO_2V_commands.ASO_2V_Release_Pilot_Ext, 	cockpit_device_id = devices.ASO_2V, value_down = 1, value_up = 0,	name = _('Pilot Launch Countermeasures'),		category = {_('ASO-2V')}},

--ASP-17
{down = asp_commands.Reflector_Fix_EXT, 			cockpit_device_id = devices.ASP_17V, value_down = 1, name = _('Fix/Release Reflector'),		category = {_('ASP-17V')}},
{down = asp_commands.Reflector_Move_Up_EXT, 		cockpit_device_id = devices.ASP_17V, value_down = 1, name = _('Reflector Up'),				category = {_('ASP-17V')}},
{down = asp_commands.Reflector_Move_Down_EXT, 		cockpit_device_id = devices.ASP_17V, value_down = 1, name = _('Reflector Down'),			category = {_('ASP-17V')}},
{down = asp_commands.Power_EXT, 					cockpit_device_id = devices.ASP_17V, value_down = 1, name = _('ASP-17 Power On'),			category = {_('ASP-17V')}},
{down = asp_commands.Power_EXT, 					cockpit_device_id = devices.ASP_17V, value_down = 0, name = _('ASP-17 Power Off'),			category = {_('ASP-17V')}},


--InternalLightSystem
{																				down = int_lights_commands.CabinLightingWhiteRed_EXT,                                                                 								cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1,                        	name = _('Cabin Lighting Switch - WHITE'),												category = {_('Left Side Instrument Panel')}},
{																				down = int_lights_commands.CabinLightingWhiteRed_EXT,	                                                             								cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0,                        	name = _('Cabin Lighting Switch - RED'),												category = {_('Left Side Instrument Panel')}},
{																				down = int_lights_commands.CabinLightingWhiteRed_ITER,                                                                								cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1,                        	name = _('Cabin Lighting Switch - WHITE/RED'),											category = {_('Left Side Instrument Panel')}},
{																				down = int_lights_commands.CargoWhiteLightingOn_EXT,                                                                 								cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1,                        	name = _('Cargo Lighting Switch - ON'),													category = {_('Left Side Instrument Panel')}},
{																				down = int_lights_commands.CargoWhiteLightingOn_EXT,	                                                             								cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0,                        	name = _('Cargo Lighting Switch - OFF'),												category = {_('Left Side Instrument Panel')}},
{																				down = int_lights_commands.CargoWhiteLightingOn_ITER,                                                                								cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1,                        	name = _('Cargo Lighting Switch - ON/OFF'),												category = {_('Left Side Instrument Panel')}},
{																				down = int_lights_commands.CargoLightingWhiteBlue_EXT,                                                                 								cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1,                        	name = _('Cargo Lighting Switch - WHITE'),												category = {_('Left Side Instrument Panel')}},
{																				down = int_lights_commands.CargoLightingWhiteBlue_EXT,	                                                             								cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0,                        	name = _('Cargo Lighting Switch - BLUE'),												category = {_('Left Side Instrument Panel')}},
{																				down = int_lights_commands.CargoLightingWhiteBlue_ITER,                                                                								cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1,                        	name = _('Cargo Lighting Switch - WHITE/BLUE'),											category = {_('Left Side Instrument Panel')}},
{combos = {{key = 'N', reformers = {'LShift','LAlt'}}},							down = int_lights_commands.TestLights_EXT,									up = int_lights_commands.TestLights_EXT,								cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1,	 	value_up = 0,		name = _('Test Warning Lights Button'),													category = {_('Left Front Instrument Panel')}},
{																				down = int_lights_commands.DayNight_EXT,                                                                 											cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1,                        	name = _('Day-Night Switch - DAY'),														category = {_('Left Front Instrument Panel')}},
{																				down = int_lights_commands.DayNight_EXT,	                                                             											cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0,                        	name = _('Day-Night Switch - NIGHT'),													category = {_('Left Front Instrument Panel')}},
{																				down = int_lights_commands.DayNight_ITER,                                                                											cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1,                        	name = _('Day-Night Switch - DAY/NIGHT'),												category = {_('Left Front Instrument Panel')}},
{																				down = int_lights_commands.BlinkerSystem_EXT,                                                                 										cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1,                        	name = _('Blinker Switch - ON'),														category = {_('Left Front Instrument Panel')}},
{																				down = int_lights_commands.BlinkerSystem_EXT,	                                                             										cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0,                        	name = _('Blinker Switch - OFF'),														category = {_('Left Front Instrument Panel')}},
{																				down = int_lights_commands.BlinkerSystem_ITER,                                                                										cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1,                        	name = _('Blinker Switch - ON/OFF'),													category = {_('Left Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_1_EXT,                                                                 			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.0,                       name = _('Transformer 1 Group Of Red Lights Right And Pilot Panel - OFF'),				category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_1_EXT,	                                                             			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.1,                       name = _('Transformer 1 Group Of Red Lights Right And Pilot Panel - 8V'),				category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_1_EXT,                                                                 			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.2,                     	name = _('Transformer 1 Group Of Red Lights Right And Pilot Panel - 9V'),				category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_1_EXT,                                                                 			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.3,                       name = _('Transformer 1 Group Of Red Lights Right And Pilot Panel - 10V'),				category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_1_EXT,	                                                             			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.4,                       name = _('Transformer 1 Group Of Red Lights Right And Pilot Panel - 11V'),				category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_1_EXT,                                                                 			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.5,                     	name = _('Transformer 1 Group Of Red Lights Right And Pilot Panel - 12V'),				category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_1_EXT,                                                                 			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.6,                       name = _('Transformer 1 Group Of Red Lights Right And Pilot Panel - 13V'),				category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_1_EXT,	                                                             			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.7,                       name = _('Transformer 1 Group Of Red Lights Right And Pilot Panel - 14V'),				category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_1_EXT,                                                                 			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.8,                     	name = _('Transformer 1 Group Of Red Lights Right And Pilot Panel - 16V'),				category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_1_EXT,                                                                 			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.9,                       name = _('Transformer 1 Group Of Red Lights Right And Pilot Panel - 18V'),				category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_1_EXT,	                                                             			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1.0,                       name = _('Transformer 1 Group Of Red Lights Right And Pilot Panel - 20V'),				category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_1_ITER,                                                                			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1,                        	name = _('Transformer 1 Group Of Red Lights Right And Pilot Panel - CYCLE(UP)'),		category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_1_ITER,                                                                			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = -1,                       	name = _('Transformer 1 Group Of Red Lights Right And Pilot Panel - CYCLE(DOWN)'),		category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_2_EXT,                                                                 			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.0,                       name = _('Transformer 2 Group Of Red Lights Right And Pilot Panel - OFF'),				category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_2_EXT,	                                                             			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.1,                       name = _('Transformer 2 Group Of Red Lights Right And Pilot Panel - 8V'),				category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_2_EXT,                                                                 			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.2,                     	name = _('Transformer 2 Group Of Red Lights Right And Pilot Panel - 9V'),				category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_2_EXT,                                                                 			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.3,                       name = _('Transformer 2 Group Of Red Lights Right And Pilot Panel - 10V'),				category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_2_EXT,	                                                             			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.4,                       name = _('Transformer 2 Group Of Red Lights Right And Pilot Panel - 11V'),				category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_2_EXT,                                                                 			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.5,                     	name = _('Transformer 2 Group Of Red Lights Right And Pilot Panel - 12V'),				category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_2_EXT,                                                                 			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.6,                       name = _('Transformer 2 Group Of Red Lights Right And Pilot Panel - 13V'),				category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_2_EXT,	                                                             			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.7,                       name = _('Transformer 2 Group Of Red Lights Right And Pilot Panel - 14V'),				category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_2_EXT,                                                                 			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.8,                     	name = _('Transformer 2 Group Of Red Lights Right And Pilot Panel - 16V'),				category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_2_EXT,                                                                 			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.9,                       name = _('Transformer 2 Group Of Red Lights Right And Pilot Panel - 18V'),				category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_2_EXT,	                                                             			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1.0,                       name = _('Transformer 2 Group Of Red Lights Right And Pilot Panel - 20V'),				category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_2_ITER,                                                                			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1,                        	name = _('Transformer 2 Group Of Red Lights Right And Pilot Panel - CYCLE(UP)'),		category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotInstrumentPanelRightPanel_2_ITER,                                                                			cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = -1,                       	name = _('Transformer 2 Group Of Red Lights Right And Pilot Panel - CYCLE(DOWN)'),		category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.SpecialEquipmentPanelRedLights_EXT,                                                                 						cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1,                        	name = _('Armament Panel Red Lights Switch - ON'),										category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.SpecialEquipmentPanelRedLights_EXT,	                                                             						cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0,                        	name = _('Armament Panel Red Lights Switch - OFF'),										category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.SpecialEquipmentPanelRedLights_ITER,                                                                						cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1,                        	name = _('Armament Panel Red Lights Switch - ON/OFF'),									category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_1_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.0,                       name = _('Transformer 1 Group Of Red Lights Left Pilot Panel - OFF'),					category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_1_EXT,	                                                             							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.1,                       name = _('Transformer 1 Group Of Red Lights Left Pilot Panel - 8V'),					category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_1_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.2,                     	name = _('Transformer 1 Group Of Red Lights Left Pilot Panel - 9V'),					category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_1_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.3,                       name = _('Transformer 1 Group Of Red Lights Left Pilot Panel - 10V'),					category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_1_EXT,	                                                             							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.4,                       name = _('Transformer 1 Group Of Red Lights Left Pilot Panel - 11V'),					category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_1_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.5,                     	name = _('Transformer 1 Group Of Red Lights Left Pilot Panel - 12V'),					category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_1_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.6,                       name = _('Transformer 1 Group Of Red Lights Left Pilot Panel - 13V'),					category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_1_EXT,	                                                             							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.7,                       name = _('Transformer 1 Group Of Red Lights Left Pilot Panel - 14V'),					category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_1_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.8,                     	name = _('Transformer 1 Group Of Red Lights Left Pilot Panel - 16V'),					category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_1_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.9,                       name = _('Transformer 1 Group Of Red Lights Left Pilot Panel - 18V'),					category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_1_EXT,	                                                             							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1.0,                       name = _('Transformer 1 Group Of Red Lights Left Pilot Panel - 20V'),					category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_1_ITER,                                                                							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1,                        	name = _('Transformer 1 Group Of Red Lights Left Pilot Panel - CYCLE(UP)'),				category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_1_ITER,                                                                							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = -1,                       	name = _('Transformer 1 Group Of Red Lights Left Pilot Panel - CYCLE(DOWN)'),			category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_2_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.0,                       name = _('Transformer 2 Group Of Red Lights Left Pilot Panel - OFF'),					category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_2_EXT,	                                                             							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.1,                       name = _('Transformer 2 Group Of Red Lights Left Pilot Panel - 8V'),					category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_2_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.2,                     	name = _('Transformer 2 Group Of Red Lights Left Pilot Panel - 9V'),					category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_2_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.3,                       name = _('Transformer 2 Group Of Red Lights Left Pilot Panel - 10V'),					category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_2_EXT,	                                                             							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.4,                       name = _('Transformer 2 Group Of Red Lights Left Pilot Panel - 11V'),					category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_2_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.5,                     	name = _('Transformer 2 Group Of Red Lights Left Pilot Panel - 12V'),					category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_2_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.6,                       name = _('Transformer 2 Group Of Red Lights Left Pilot Panel - 13V'),					category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_2_EXT,	                                                             							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.7,                       name = _('Transformer 2 Group Of Red Lights Left Pilot Panel - 14V'),					category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_2_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.8,                     	name = _('Transformer 2 Group Of Red Lights Left Pilot Panel - 16V'),					category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_2_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.9,                       name = _('Transformer 2 Group Of Red Lights Left Pilot Panel - 18V'),					category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_2_EXT,	                                                             							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1.0,                       name = _('Transformer 2 Group Of Red Lights Left Pilot Panel - 20V'),					category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_2_ITER,                                                                							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1,                        	name = _('Transformer 2 Group Of Red Lights Left Pilot Panel - CYCLE(UP)'),				category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotLeftPanel_2_ITER,                                                                							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = -1,                       	name = _('Transformer 2 Group Of Red Lights Left Pilot Panel - CYCLE(DOWN)'),			category = {_('Right Front Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotBuiltInRedLights_EXT,                                                                 						cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.0,                       name = _('Builtin Red Lights Transformer - OFF'),										category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotBuiltInRedLights_EXT,	                                                             						cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.1,                       name = _('Builtin Red Lights Transformer - 0.6V'),										category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotBuiltInRedLights_EXT,                                                                 						cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.2,                     	name = _('Builtin Red Lights Transformer - 1.2V'),										category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotBuiltInRedLights_EXT,                                                                 						cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.3,                       name = _('Builtin Red Lights Transformer - 1.8V'),										category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotBuiltInRedLights_EXT,	                                                             						cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.4,                       name = _('Builtin Red Lights Transformer - 2.4V'),										category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotBuiltInRedLights_EXT,                                                                 						cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.5,                     	name = _('Builtin Red Lights Transformer - 3V'),										category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotBuiltInRedLights_EXT,                                                                 						cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.6,                       name = _('Builtin Red Lights Transformer - 3.6V'),										category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotBuiltInRedLights_EXT,	                                                             						cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.7,                       name = _('Builtin Red Lights Transformer - 4.2V'),										category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotBuiltInRedLights_EXT,                                                                 						cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.8,                     	name = _('Builtin Red Lights Transformer - 4.8V'),										category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotBuiltInRedLights_EXT,                                                                 						cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.9,                       name = _('Builtin Red Lights Transformer - 5.4V'),										category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotBuiltInRedLights_EXT,	                                                             						cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1.0,                       name = _('Builtin Red Lights Transformer - 6V'),										category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotBuiltInRedLights_ITER,                                                                						cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1,                        	name = _('Builtin Red Lights Transformer - CYCLE(UP)'),									category = {_('Right Instrument Panel')}},
{																				down = int_lights_commands.RedLightsPilotBuiltInRedLights_ITER,                                                                						cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = -1,                  	name = _('Builtin Red Lights Transformer - CYCLE(DOWN)'),								category = {_('Right Instrument Panel')}},

--ExternalLightSystem
{																				down = ext_lights_commands.GearLights_EXT,                  				                                           								cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,                     	name = _('Gear Lights Switch - ON'),													category = {_('Left Front Instrument Panel')}},
{																				down = ext_lights_commands.GearLights_EXT,	                				                                            							cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 0,                     	name = _('Gear Lights Switch - OFF'),													category = {_('Left Front Instrument Panel')}},
{																				down = ext_lights_commands.GearLights_ITER,                 				                                           								cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,                     	name = _('Gear Lights Switch - ON/OFF'),												category = {_('Left Front Instrument Panel')}},
{																				down = ext_lights_commands.TaxiLight_EXT,                  				                                           									cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,                     	name = _('Taxi Light Control Switch - ON'),												category = {_('Left Instrument Panel')}},
{																				down = ext_lights_commands.TaxiLight_EXT,	                				                                            							cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 0,                     	name = _('Taxi Light Control Switch - OFF'),											category = {_('Left Instrument Panel')}},
{																				down = ext_lights_commands.TaxiLight_ITER,                 				                                           									cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,                     	name = _('Taxi Light Control Switch - ON/OFF'),											category = {_('Left Instrument Panel')}},
{																				down = ext_lights_commands.NavLtSwitch_EXT,                  				                                           								cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,                     	name = _('Navigation Lights Switch - BRIGHT'),											category = {_('Left Front Instrument Panel')}},
{																				down = ext_lights_commands.NavLtSwitch_EXT,	                				                                            							cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 0,                     	name = _('Navigation Lights Switch - OFF'),												category = {_('Left Front Instrument Panel')}},
{																				down = ext_lights_commands.NavLtSwitch_EXT,	                				                                            							cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = -1,                     	name = _('Navigation Lights Switch - DIM'),												category = {_('Left Front Instrument Panel')}},
{																				down = ext_lights_commands.NavLtSwitch_ITER,                 				                                           								cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,                     	name = _('Navigation Lights Switch - CYCLE(UP)'),										category = {_('Left Front Instrument Panel')}},
{																				down = ext_lights_commands.NavLtSwitch_ITER,                 				                                           								cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = -1,                     	name = _('Navigation Lights Switch - CYCLE(DOWN)'),										category = {_('Left Front Instrument Panel')}},
{																				down = ext_lights_commands.NavCodeButton_EXT,								up = ext_lights_commands.NavCodeButton_EXT,								cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,	 	value_up = 0,		name = _('Navigation Lights Code Button'),												category = {_('Left Front Instrument Panel')}},
{																				down = ext_lights_commands.FormationLights_EXT,                  				                                           							cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,                     	name = _('Formation Lights Switch - BRIGHT'),											category = {_('Left Side Instrument Panel')}},
{																				down = ext_lights_commands.FormationLights_EXT,	                				                                            						cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 0,                     	name = _('Formation Lights Switch - OFF'),												category = {_('Left Side Instrument Panel')}},
{																				down = ext_lights_commands.FormationLights_EXT,	                				                                            						cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = -1,                     	name = _('Formation Lights Switch - DIM'),												category = {_('Left Side Instrument Panel')}},
{																				down = ext_lights_commands.FormationLights_ITER,                 				                                           							cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,                     	name = _('Formation Lights Switch - CYCLE(UP)'),										category = {_('Left Side Instrument Panel')}},
{																				down = ext_lights_commands.FormationLights_ITER,                 				                                           							cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = -1,                     	name = _('Formation Lights Switch - CYCLE(DOWN)'),										category = {_('Left Side Instrument Panel')}},
{																				down = ext_lights_commands.TipLights_EXT,                  				                                           									cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,                     	name = _('Tip Lights Switch - ON'),														category = {_('Left Side Instrument Panel')}},
{																				down = ext_lights_commands.TipLights_EXT,	                				                                            							cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 0,                     	name = _('Tip Lights Switch - OFF'),													category = {_('Left Side Instrument Panel')}},
{																				down = ext_lights_commands.TipLights_ITER,                 				                                           									cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,                     	name = _('Tip Lights Switch - ON/OFF'),													category = {_('Left Side Instrument Panel')}},
{																				down = ext_lights_commands.StrobeLight_EXT,                  				                                           								cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,                     	name = _('Strobe Light Switch - ON'),													category = {_('Left Side Instrument Panel')}},
{																				down = ext_lights_commands.StrobeLight_EXT,	                				                                            							cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 0,                     	name = _('Strobe Light Switch - OFF'),													category = {_('Left Side Instrument Panel')}},
{																				down = ext_lights_commands.StrobeLight_ITER,                 				                                           								cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,                     	name = _('Strobe Light Switch - ON/OFF'),												category = {_('Left Side Instrument Panel')}},
{																				down = ext_lights_commands.SpotSwitch_EXT,                  				                                           								cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,                     	name = _('Spot Switch - ON'),															category = {_('Left Front Instrument Panel')}},
{																				down = ext_lights_commands.SpotSwitch_EXT,	                				                                            							cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 0,                     	name = _('Spot Switch - OFF'),															category = {_('Left Front Instrument Panel')}},
{																				down = ext_lights_commands.SpotSwitch_ITER,                 				                                           								cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,                     	name = _('Spot Switch - ON/OFF'),														category = {_('Left Front Instrument Panel')}},
{																				down = ext_lights_commands.SpotButtonRight_EXT,								up = ext_lights_commands.SpotButtonRight_EXT,							cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,	 	value_up = 0,		name = _('Spot Light Control Button Right'),											category = {_('Ins Collective Stick')}},
{																				down = ext_lights_commands.SpotButtonExt_EXT,								up = ext_lights_commands.SpotButtonExt_EXT,								cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,	 	value_up = 0,		name = _('Spot Light Control Button Extension'),										category = {_('Ins Collective Stick')}},
{																				down = ext_lights_commands.SpotButtonLeft_EXT,								up = ext_lights_commands.SpotButtonLeft_EXT,							cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,	 	value_up = 0,		name = _('Spot Light Control Button Left'),												category = {_('Ins Collective Stick')}},
{																				down = ext_lights_commands.SpotButtonRet_EXT,								up = ext_lights_commands.SpotButtonRet_EXT,								cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,	 	value_up = 0,		name = _('Spot Light Control Button Retraction'),										category = {_('Ins Collective Stick')}},
{combos = {{key = '1', reformers = {'RCtrl'}}},		down = iCommandPlaneLightsOnOff,	 value_down = -1,	name = _('Nav. Lights Switch - Down'),			category = {_('Left Front Instrument Panel'), _('External Lights')}},
{combos = {{key = '2', reformers = {'RCtrl'}}},		down = iCommandPlaneLightsOnOff,     value_down = 1,	name = _('Nav. Lights Switch - Up'),			category = {_('Left Front Instrument Panel'), _('External Lights')}},
{combos = {{key = '3', reformers = {'RCtrl'}}},		down = iCommandPlaneFormationLights, value_down = -1,	name = _('Formation Lights Switch - Down'),		category = {_('Left Side Instrument Panel'), _('External Lights')}},
{combos = {{key = '4', reformers = {'RCtrl'}}},		down = iCommandPlaneFormationLights, value_down = 1,	name = _('Formation Lights Switch - Up'),		category = {_('Left Side Instrument Panel'), _('External Lights')}},
--{combos = {{key = '5', reformers = {'RCtrl'}}},		down = iCommandPlaneRotorTipLights,	name = _('Tip Lights Switch - ON/OFF'),			category = {_('Left Side Instrument Panel'), _('External Lights')}},
--{combos = {{key = '6', reformers = {'RCtrl'}}},		down = iCommandPlaneAntiCollisionLights,name = _('Strobe Light Switch - ON/OFF'),		category = {_('Left Side Instrument Panel'), _('External Lights')}},

{combos = {{key = '7', reformers = {'LShift'}}},	down = ext_lights_commands.HeadLightPilotControl_EXT, up = ext_lights_commands.HeadLightPilotControl_EXT,	cockpit_device_id = devices.EXT_LIGHTS_SYSTEM, value_down = 0.2, value_up = 0,	name = _('Pilot Headlight - Down'),		category = {_('Ins Collective Stick'), _('External Lights')}},
{combos = {{key = '8', reformers = {'LShift'}}},	down = ext_lights_commands.HeadLightPilotControl_EXT, up = ext_lights_commands.HeadLightPilotControl_EXT,	cockpit_device_id = devices.EXT_LIGHTS_SYSTEM, value_down = 0.1, value_up = 0,	name = _('Pilot Headlight - Up'),		category = {_('Ins Collective Stick'), _('External Lights')}},
{combos = {{key = '9', reformers = {'LShift'}}},	down = ext_lights_commands.HeadLightPilotControl_EXT, up = ext_lights_commands.HeadLightPilotControl_EXT,	cockpit_device_id = devices.EXT_LIGHTS_SYSTEM, value_down = 0.3, value_up = 0,	name = _('Pilot Headlight - Left'),		category = {_('Ins Collective Stick'), _('External Lights')}},
{combos = {{key = '0', reformers = {'LShift'}}},	down = ext_lights_commands.HeadLightPilotControl_EXT, up = ext_lights_commands.HeadLightPilotControl_EXT,	cockpit_device_id = devices.EXT_LIGHTS_SYSTEM, value_down = 0.4, value_up = 0,	name = _('Pilot Headlight - Right'),	category = {_('Ins Collective Stick'), _('External Lights')}},


-- Circuit breakers ----------------------------
------------------------------------------------
{combos = {{key = '1', reformers = {'RCtrl','RShift'}}},	down = elec_commands.CB_FRAME_LEFT_EXT, up = elec_commands.CB_FRAME_LEFT_EXT, cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1.0, value_up = 0.0,	name = _('All Left CBs ON'),	category = {_('Left CB Panels')}},
{combos = {{key = '2', reformers = {'RCtrl','RShift'}}},	down = elec_commands.CB_FRAME_RIGHT_EXT, up = elec_commands.CB_FRAME_RIGHT_EXT, cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1.0, value_up = 0.0,	name = _('All Right CBs ON'),	category = {_('Right CB Panels')}},

--ECSystem
{combos = {{key = 'Z', reformers = {'LCtrl','LAlt'}}},							down = ecs_commands.CabinUnseal_EXT,                                                                 												cockpit_device_id = devices.ECS_INTERFACE,				value_down = 1,                        	name = _('Cabin Unseal Switch - ON'),													category = {_('EC System Control Panel')}},
{combos = {{key = 'X', reformers = {'LCtrl','LAlt'}}},							down = ecs_commands.CabinUnseal_EXT,	                                                             												cockpit_device_id = devices.ECS_INTERFACE,				value_down = 0,                        	name = _('Cabin Unseal Switch - OFF'),													category = {_('EC System Control Panel')}},
{																				down = ecs_commands.CabinUnseal_ITER,                                                                												cockpit_device_id = devices.ECS_INTERFACE,				value_down = 1,                        	name = _('Cabin Unseal Switch - ON/OFF'),												category = {_('EC System Control Panel')}},
{combos = {{key = 'C', reformers = {'LCtrl','LAlt'}}},							down = ecs_commands.BlowdownConditioning_EXT,                                                                 										cockpit_device_id = devices.ECS_INTERFACE,				value_down = 1,                        	name = _('Blowdown Conditioning Switch - CONDITIONING'),								category = {_('EC System Control Panel')}},
{combos = {{key = 'V', reformers = {'LCtrl','LAlt'}}},							down = ecs_commands.BlowdownConditioning_EXT,	                                                             										cockpit_device_id = devices.ECS_INTERFACE,				value_down = 0,                        	name = _('Blowdown Conditioning Switch - OFF'),											category = {_('EC System Control Panel')}},
{combos = {{key = 'B', reformers = {'LCtrl','LAlt'}}},							down = ecs_commands.BlowdownConditioning_EXT,                                                                 										cockpit_device_id = devices.ECS_INTERFACE,				value_down = -1,                        name = _('Blowdown Conditioning Switch - BLOWDOWN'),									category = {_('EC System Control Panel')}},
{																				down = ecs_commands.BlowdownConditioning_ITER,                                                                										cockpit_device_id = devices.ECS_INTERFACE,				value_down = 1,                        	name = _('Blowdown Conditioning Switch - CYCLE(UP)'),									category = {_('EC System Control Panel')}},
{																				down = ecs_commands.BlowdownConditioning_ITER,                                                                										cockpit_device_id = devices.ECS_INTERFACE,				value_down = -1,                       	name = _('Blowdown Conditioning Switch - CYCLE(DOWN)'),									category = {_('EC System Control Panel')}},
{combos = {{key = 'N', reformers = {'LCtrl','LAlt'}}},							down = ecs_commands.Filter_EXT,                                                                 													cockpit_device_id = devices.ECS_INTERFACE,				value_down = 1,                        	name = _('Filter Switch - ON'),															category = {_('EC System Control Panel')}},
{combos = {{key = 'M', reformers = {'LCtrl','LAlt'}}},							down = ecs_commands.Filter_EXT,	                                                             														cockpit_device_id = devices.ECS_INTERFACE,				value_down = 0,                        	name = _('Filter Switch - OFF'),														category = {_('EC System Control Panel')}},
{																				down = ecs_commands.Filter_ITER,                                                                													cockpit_device_id = devices.ECS_INTERFACE,				value_down = 1,                        	name = _('Filter Switch - ON/OFF'),														category = {_('EC System Control Panel')}},
{combos = {{key = '/', reformers = {'LCtrl','LAlt'}}},							down = ecs_commands.Heating_EXT,                                                                 													cockpit_device_id = devices.ECS_INTERFACE,				value_down = 1,                        	name = _('Heating Switch - HOT'),														category = {_('EC System Control Panel')}},
{combos = {{key = '\\', reformers = {'LCtrl','LAlt'}}},							down = ecs_commands.Heating_EXT,	                                                             													cockpit_device_id = devices.ECS_INTERFACE,				value_down = 0,                        	name = _('Heating Switch - NORMAL'),													category = {_('EC System Control Panel')}},
{																				down = ecs_commands.Heating_ITER,                                                                													cockpit_device_id = devices.ECS_INTERFACE,				value_down = 1,                        	name = _('Heating Switch - HOT/NORMAL'),												category = {_('EC System Control Panel')}},
{combos = {{key = 'M', reformers = {'LShift','LAlt'}}},							down = ecs_commands.AutomaticHotCold_EXT,                                                                 											cockpit_device_id = devices.ECS_INTERFACE,				value_down = 0.0,                       name = _('Automatic Hot Cold Switch - OFF'),											category = {_('EC System Control Panel')}},
{combos = {{key = ',', reformers = {'LShift','LAlt'}}},							down = ecs_commands.AutomaticHotCold_EXT,	                                                             											cockpit_device_id = devices.ECS_INTERFACE,				value_down = 0.1,                       name = _('Automatic Hot Cold Switch - COLD'),											category = {_('EC System Control Panel')}},
{combos = {{key = '.', reformers = {'LShift','LAlt'}}},							down = ecs_commands.AutomaticHotCold_EXT,                                                                 											cockpit_device_id = devices.ECS_INTERFACE,				value_down = 0.2,                       name = _('Automatic Hot Cold Switch - HOT'),											category = {_('EC System Control Panel')}},
{combos = {{key = '/', reformers = {'LShift','LAlt'}}},							down = ecs_commands.AutomaticHotCold_EXT,                                                                 											cockpit_device_id = devices.ECS_INTERFACE,				value_down = 0.3,                       name = _('Automatic Hot Cold Switch - AUTO'),											category = {_('EC System Control Panel')}},
{																				down = ecs_commands.AutomaticHotCold_ITER,                                                                											cockpit_device_id = devices.ECS_INTERFACE,				value_down = 1,                        	name = _('Automatic Hot Cold Switch - CYCLE(UP)'),										category = {_('EC System Control Panel')}},
{																				down = ecs_commands.AutomaticHotCold_ITER,                                                                											cockpit_device_id = devices.ECS_INTERFACE,				value_down = -1,                       	name = _('Automatic Hot Cold Switch - CYCLE(DOWN)'),									category = {_('EC System Control Panel')}},
{																				down = ecs_commands.Temperature_EXT,                                                                 												cockpit_device_id = devices.ECS_INTERFACE,				value_down = 0.0,                       name = _('Temperature Selector - 5'),													category = {_('EC System Control Panel')}},
{																				down = ecs_commands.Temperature_EXT,	                                                             												cockpit_device_id = devices.ECS_INTERFACE,				value_down = 0.1,                       name = _('Temperature Selector - 10'),													category = {_('EC System Control Panel')}},
{																				down = ecs_commands.Temperature_EXT,                                                                 												cockpit_device_id = devices.ECS_INTERFACE,				value_down = 0.2,                       name = _('Temperature Selector - 15'),													category = {_('EC System Control Panel')}},
{																				down = ecs_commands.Temperature_EXT,                                                                 												cockpit_device_id = devices.ECS_INTERFACE,				value_down = 0.3,                       name = _('Temperature Selector - 18'),													category = {_('EC System Control Panel')}},
{																				down = ecs_commands.Temperature_EXT,                                                                 												cockpit_device_id = devices.ECS_INTERFACE,				value_down = 0.4,                       name = _('Temperature Selector - 20'),													category = {_('EC System Control Panel')}},
{																				down = ecs_commands.Temperature_EXT,	                                                             												cockpit_device_id = devices.ECS_INTERFACE,				value_down = 0.5,                       name = _('Temperature Selector - 22'),													category = {_('EC System Control Panel')}},
{																				down = ecs_commands.Temperature_EXT,                                                                 												cockpit_device_id = devices.ECS_INTERFACE,				value_down = 0.6,                       name = _('Temperature Selector - 24'),													category = {_('EC System Control Panel')}},
{																				down = ecs_commands.Temperature_EXT,                                                                 												cockpit_device_id = devices.ECS_INTERFACE,				value_down = 0.7,                       name = _('Temperature Selector - 30'),													category = {_('EC System Control Panel')}},
{																				down = ecs_commands.Temperature_EXT,                                                                 												cockpit_device_id = devices.ECS_INTERFACE,				value_down = 0.8,                       name = _('Temperature Selector - 35'),													category = {_('EC System Control Panel')}},
{																				down = ecs_commands.Temperature_EXT,	                                                             												cockpit_device_id = devices.ECS_INTERFACE,				value_down = 0.9,                       name = _('Temperature Selector - 40'),													category = {_('EC System Control Panel')}},
{																				down = ecs_commands.Temperature_EXT,                                                                 												cockpit_device_id = devices.ECS_INTERFACE,				value_down = 1.0,                       name = _('Temperature Selector - 50'),													category = {_('EC System Control Panel')}},
{combos = {{key = ',', reformers = {'LCtrl','LAlt'}}},							down = ecs_commands.Temperature_ITER,																												cockpit_device_id = devices.ECS_INTERFACE,				value_down = 1,							name = _('Temperature Selector - CYCLE(UP)'),											category = {_('EC System Control Panel')}},
{combos = {{key = '.', reformers = {'LCtrl','LAlt'}}},							down = ecs_commands.Temperature_ITER,																												cockpit_device_id = devices.ECS_INTERFACE,				value_down = -1,						name = _('Temperature Selector - CYCLE(DOWN)'),											category = {_('EC System Control Panel')}},

--PKP72M_interface
{combos = {{key = 'N', reformers = {'LCtrl'}}},									pressed = pkp72m_interface_commands.PitchTrimKnob_ITER,																								cockpit_device_id = devices.PKP72M_INTERFACE,			value_pressed = 1,						name = _('Pitch Trim Knob PKP72M - CW'),														category = {_('Front Instrument Panel')}},
{combos = {{key = 'N', reformers = {'LShift'}}},								pressed = pkp72m_interface_commands.PitchTrimKnob_ITER,																								cockpit_device_id = devices.PKP72M_INTERFACE,			value_pressed = -1,						name = _('Pitch Trim Knob PKP72M - CCW'),														category = {_('Front Instrument Panel')}},
{combos = {{key = 'N', reformers = {'LCtrl','LShift','LAlt'}}},					down = pkp72m_interface_commands.TestControl_EXT,							up = pkp72m_interface_commands.TestControl_EXT,							cockpit_device_id = devices.PKP72M_INTERFACE,	 		value_down = 1,	 	value_up = 0,		name = _('Test ADI Button'),															category = {_('Front Instrument Panel')}},
{combos = {{key = '1', reformers = {'LCtrl','LShift','LAlt'}}},					down = pkp72m_interface_commands.GyroverticalSwitch_EXT,                                                                 							cockpit_device_id = devices.PKP72M_INTERFACE,			value_down = 1,                        	name = _('Gyrovertical Switch - 1'),													category = {_('Front Instrument Panel')}},
{combos = {{key = '2', reformers = {'LCtrl','LShift','LAlt'}}},					down = pkp72m_interface_commands.GyroverticalSwitch_EXT,	                                                             							cockpit_device_id = devices.PKP72M_INTERFACE,			value_down = 0,                        	name = _('Gyrovertical Switch - 2'),													category = {_('Front Instrument Panel')}},
{																				down = pkp72m_interface_commands.GyroverticalSwitch_ITER,																							cockpit_device_id = devices.PKP72M_INTERFACE,			value_down = 1,							name = _('Gyrovertical Switch - 1/2'),													category = {_('Front Instrument Panel')}},



--UKT2
{																				pressed = ukt2_commands.PitchTrimKnob_ITER,																											cockpit_device_id = devices.UKT_2,						value_pressed = 1,						name = _('Pitch Trim Knob UKT-2 - CW'),														category = {_('Front Instrument Panel')}},
{																				pressed = ukt2_commands.PitchTrimKnob_ITER,																											cockpit_device_id = devices.UKT_2,						value_pressed = -1,						name = _('Pitch Trim Knob UKT-2 - CCW'),														category = {_('Front Instrument Panel')}},

-- Barometric Altimeter Pilot
{combos = {{key = 'B', reformers = {'LCtrl'}}},									pressed = baroaltimeter_commands.CMD_ADJUST_PRESSURE_EXT, 																							cockpit_device_id = devices.BAROALT_P, 					value_pressed = 1,						name = _('Baro Pressure Pilot Knob - CW'),													category = {_('Front Instrument Panel')}},
{combos = {{key = 'B', reformers = {'LShift'}}},								pressed = baroaltimeter_commands.CMD_ADJUST_PRESSURE_EXT, 																							cockpit_device_id = devices.BAROALT_P, 					value_pressed = -1,						name = _('Baro Pressure Pilot Knob - CCW'),													category = {_('Front Instrument Panel')}},


-- RMI2 Pilot
{																				down = rmi2_commands.MODE_LEFTSW_EXT,                  				                                           										cockpit_device_id = devices.RMI2_P,						value_down = 1,                     	name = _('Mode Switch Pilot -  '),															category = {_('Front Instrument Panel')}},
{																				down = rmi2_commands.MODE_LEFTSW_EXT,	                				                                            								cockpit_device_id = devices.RMI2_P,						value_down = 0,                     	name = _('Mode Switch Pilot - ARK1'),															category = {_('Front Instrument Panel')}},
{																				down = rmi2_commands.MODE_LEFTSW_ITER,                 				                                           										cockpit_device_id = devices.RMI2_P,						value_down = 1,                     	name = _('Mode Switch Pilot -  /ARK1'),														category = {_('Front Instrument Panel')}},
{																				down = rmi2_commands.MODE_RIGHTSW_EXT,                  				                                           									cockpit_device_id = devices.RMI2_P,						value_down = 1,                     	name = _('Mode Switch Pilot - ZK'),															category = {_('Front Instrument Panel')}},
{																				down = rmi2_commands.MODE_RIGHTSW_EXT,	                				                                            								cockpit_device_id = devices.RMI2_P,						value_down = 0,                     	name = _('Mode Switch Pilot - ARKU2'),														category = {_('Front Instrument Panel')}},
{																				down = rmi2_commands.MODE_RIGHTSW_ITER,                 				                                           									cockpit_device_id = devices.RMI2_P,						value_down = 1,                     	name = _('Mode Switch Pilot - ZK/ARKU2'),														category = {_('Front Instrument Panel')}},


-- Clock
{combos = {{key = 'C', reformers = {'RCtrl','RShift','RAlt'}}},					down = iCommandMechClock_LeftLever_Down, up = iCommandMechClock_LeftLever_Down_up,			name = _('Clock Left Knob - Push'),				category = {_('Instrument Panel')}},
{combos = {{key = 'M', reformers = {'RShift'}}},								down = iCommandMechClock_LeftLever_Up,														name = _('Clock Left Knob - Pull'),				category = {_('Instrument Panel')}},
{combos = {{key = '.', reformers = {'LAlt'}}},									pressed = iCommandMechClock_LeftLever_TurnRight,											name = _('Clock Left Knob - Rotate right'),		category = {_('Instrument Panel')}},
{combos = {{key = ',', reformers = {'LAlt'}}},									pressed = iCommandMechClock_LeftLever_TurnLeft,												name = _('Clock Left Knob - Rotate left'),		category = {_('Instrument Panel')}},
{combos = {{key = 'C', reformers = {'RShift','RAlt'}}},							down = iCommandMechClock_RightLever_Down, up = iCommandMechClock_RightLever_Down_up,		name = _('Clock Right Knob - Push'),			category = {_('Instrument Panel')}},
{combos = {{key = ',', reformers = {'RCtrl','RShift'}}},						down = iCommandMechClock_RightLever_Rotate_left,											name = _('Clock Right Knob - Rotate left'),		category = {_('Instrument Panel')}},
{combos = {{key = '.', reformers = {'RCtrl','RShift'}}},						down = iCommandMechClock_RightLever_Rotate_right,											name = _('Clock Right Knob - Rotate right'),	category = {_('Instrument Panel')}},

------------------



-- Electric system
-- commented out lines are temporary commented
-- todo: restore to normal after coding clickable elements
-- Electric system AC
--{combos = {{key = '`', reformers = {'LAlt','LShift'}}}, 	down = elec_commands.ACGroundPowerEXT,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('AC Ground Power Switch - ON/OFF'),	category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = '`', reformers = {'LAlt','LShift'}}},		down = elec_commands.ACGroundPower,					cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('AC Ground Power Switch - ON'),		category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = 'Esc', reformers = {'LAlt','LShift'}}},	down = elec_commands.ACGroundPower,					cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0,		name = _('AC Ground Power Switch - OFF'),		category = {_('Electrical Control Panel'), _('AC Panel')}},
--{combos = {{key = '1', reformers = {'LAlt','LShift'}}}, 	down = elec_commands.ACGeneratorLeftEXT,			cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('AC Left Generator - ON/OFF'),			category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = '1', reformers = {'LAlt','LShift'}}}, 	down = elec_commands.ACGeneratorLeft,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('AC Left Generator - ON'),				category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = 'F1', reformers = {'LAlt','LShift'}}},	down = elec_commands.ACGeneratorLeft,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0,		name = _('AC Left Generator - OFF'),			category = {_('Electrical Control Panel'), _('AC Panel')}},
--{combos = {{key = '2', reformers = {'LAlt','LShift'}}}, 	down = elec_commands.ACGeneratorRightEXT,			cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('AC Right Generator - ON/OFF'),		category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = '2', reformers = {'LAlt','LShift'}}},		down = elec_commands.ACGeneratorRight,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('AC Right Generator - ON'),			category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = 'F2', reformers = {'LAlt','LShift'}}},	down = elec_commands.ACGeneratorRight,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0,		name = _('AC Right Generator - OFF'),			category = {_('Electrical Control Panel'), _('AC Panel')}},
--{combos = {{key = '3', reformers = {'LAlt','LShift'}}}, 	down = elec_commands.Transformer115vMainBackupEXT,	cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('AC Transformer 115v - Main/Backup'),	category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = 'F3', reformers = {'LAlt','LShift'}}},	down = elec_commands.Transformer115vMainBackup,		cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('AC Transformer 115v - Main'),			category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = '3', reformers = {'LAlt','LShift'}}},		down = elec_commands.Transformer115vMainBackup,		cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0,		name = _('AC Transformer 115v - Neutral'),		category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = 'W', reformers = {'LAlt','LShift'}}},		down = elec_commands.Transformer115vMainBackup,		cockpit_device_id = devices.ELEC_INTERFACE, value_down = -1,	name = _('AC Transformer 115v - Backup'),		category = {_('Electrical Control Panel'), _('AC Panel')}},
--{combos = {{key = '4', reformers = {'LAlt','LShift'}}}, 	down = elec_commands.Transformer36vMainBackupEXT,	cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('AC Transformer 36v - Main/Backup'),	category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = 'F4', reformers = {'LAlt','LShift'}}},	down = elec_commands.Transformer36vMainBackup,		cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('AC Transformer 36v - Main'),			category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = '4', reformers = {'LAlt','LShift'}}},		down = elec_commands.Transformer36vMainBackup,		cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0,		name = _('AC Transformer 36v - Neutral'),		category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = 'E', reformers = {'LAlt','LShift'}}},		down = elec_commands.Transformer36vMainBackup,		cockpit_device_id = devices.ELEC_INTERFACE, value_down = -1,	name = _('AC Transformer 36v - Backup'),		category = {_('Electrical Control Panel'), _('AC Panel')}},
--{combos = {{key = '5', reformers = {'LAlt','LShift'}}}, 	down = elec_commands.GroundCheckEXT,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('AC Ground Check - ON/OFF'),			category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = '5', reformers = {'LAlt','LShift'}}},		down = elec_commands.GroundCheck,					cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('AC Ground Check - ON'),				category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = 'F5', reformers = {'LAlt','LShift'}}},	down = elec_commands.GroundCheck,					cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0,		name = _('AC Ground Check - OFF'),				category = {_('Electrical Control Panel'), _('AC Panel')}},
--{combos = {{key = '6', reformers = {'LAlt','LShift'}}}, 	down = elec_commands.Rotary115vConverterEXT,		cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('AC Rotary 115v Converter - ON/OFF'),	category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = '6', reformers = {'LAlt','LShift'}}},		down = elec_commands.Rotary115vConverter,			cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('AC Rotary 115v Converter - ON'),		category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = 'F6', reformers = {'LAlt','LShift'}}},	down = elec_commands.Rotary115vConverter,			cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0,		name = _('AC Rotary 115v Converter - OFF'),		category = {_('Electrical Control Panel'), _('AC Panel')}},
--{combos = {{key = '7', reformers = {'LAlt','LShift'}}}, 	down = elec_commands.Rotary36vConverterEXT,			cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('AC Rotary 36v Converter - ON/OFF'),	category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = '7', reformers = {'LAlt','LShift'}}},		down = elec_commands.Rotary36vConverter,			cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('AC Rotary 36v Converter - ON'),		category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = 'F7', reformers = {'LAlt','LShift'}}},	down = elec_commands.Rotary36vConverter,			cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0,		name = _('AC Rotary 36v Converter - OFF'),		category = {_('Electrical Control Panel'), _('AC Panel')}},
--{combos = {{key = '9', reformers = {'LAlt','LShift'}}}, 	down = elec_commands.ACGangSwitcher,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('AC Voltmeter switch - CW'),			category = {_('Electrical Control Panel'), _('AC Panel')}},
--{combos = {{key = '8', reformers = {'LAlt','LShift'}}},	down = elec_commands.ACGangSwitcher,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = -1,	name = _('AC Voltmeter switch - CCW'),			category = {_('Electrical Control Panel'), _('AC Panel')}},
--{combos = {{key = '0', reformers = {'LAlt','LShift'}}}, 	down = elec_commands.Transformer36vDIMMainBackupEXT,cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('DIM Transformer 36v - Main/Backup'),	category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = '0', reformers = {'LAlt','LShift'}}},		down = elec_commands.Transformer36vDIMMainBackup,	cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('DIM Transformer 36v - Main'),			category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = 'F10', reformers = {'LAlt','LShift'}}},	down = elec_commands.Transformer36vDIMMainBackup,	cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0,		name = _('DIM Transformer 36v - Backup'),		category = {_('Electrical Control Panel'), _('AC Panel')}},

-- temp
{combos = {{key = 'Num0', reformers = {'LAlt','LShift'}}}, 	down = elec_commands.ACGangSwitcherSet,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0,			name = _('AC Voltmeter switch - 0'),			category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = 'Num1', reformers = {'LAlt','LShift'}}}, 	down = elec_commands.ACGangSwitcherSet,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0.1,		name = _('AC Voltmeter switch - 1'),			category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = 'Num2', reformers = {'LAlt','LShift'}}}, 	down = elec_commands.ACGangSwitcherSet,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0.2,		name = _('AC Voltmeter switch - 2'),			category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = 'Num3', reformers = {'LAlt','LShift'}}}, 	down = elec_commands.ACGangSwitcherSet,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0.3,		name = _('AC Voltmeter switch - 3'),			category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = 'Num4', reformers = {'LAlt','LShift'}}}, 	down = elec_commands.ACGangSwitcherSet,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0.4,		name = _('AC Voltmeter switch - 4'),			category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = 'Num5', reformers = {'LAlt','LShift'}}}, 	down = elec_commands.ACGangSwitcherSet,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0.5,		name = _('AC Voltmeter switch - 5'),			category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = 'Num6', reformers = {'LAlt','LShift'}}}, 	down = elec_commands.ACGangSwitcherSet,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0.6,		name = _('AC Voltmeter switch - 6'),			category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = 'Num7', reformers = {'LAlt','LShift'}}}, 	down = elec_commands.ACGangSwitcherSet,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0.7,		name = _('AC Voltmeter switch - 7'),			category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = 'Num8', reformers = {'LAlt','LShift'}}}, 	down = elec_commands.ACGangSwitcherSet,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0.8,		name = _('AC Voltmeter switch - 8'),			category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = 'Num9', reformers = {'LAlt','LShift'}}}, 	down = elec_commands.ACGangSwitcherSet,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0.9,		name = _('AC Voltmeter switch - 9'),			category = {_('Electrical Control Panel'), _('AC Panel')}},
{combos = {{key = 'Num.', reformers = {'LAlt','LShift'}}}, 	down = elec_commands.ACGangSwitcherSet,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,			name = _('AC Voltmeter switch - 10'),			category = {_('Electrical Control Panel'), _('AC Panel')}},


-- Electric system DC
--{combos = {{key = '`', reformers = {'LCtrl','LShift'}}},	down = elec_commands.DCGroundPowerEXT,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('DC Ground Power Switch - ON/OFF'),	category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = '`', reformers = {'LCtrl','LShift'}}},	down = elec_commands.DCGroundPower,					cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('DC Ground Power Switch - ON'),		category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = 'Esc', reformers = {'LCtrl','LShift'}}},	down = elec_commands.DCGroundPower,					cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0,		name = _('DC Ground Power Switch - OFF'),		category = {_('Electrical Control Panel'), _('DC Panel')}},
--{combos = {{key = '1', reformers = {'LCtrl','LShift'}}},	down = elec_commands.BatteryLeftEXT,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('DC Left Battery - ON/OFF'),			category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = '1', reformers = {'LCtrl','LShift'}}},	down = elec_commands.BatteryLeft,					cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('DC Left Battery - ON'),				category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = 'F1', reformers = {'LCtrl','LShift'}}},	down = elec_commands.BatteryLeft,					cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0,		name = _('DC Left Battery - OFF'),				category = {_('Electrical Control Panel'), _('DC Panel')}},
--{combos = {{key = '2', reformers = {'LCtrl','LShift'}}},	down = elec_commands.BatteryRightEXT,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('DC Right Battery - ON/OFF'),			category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = '2', reformers = {'LCtrl','LShift'}}},	down = elec_commands.BatteryRight,					cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('DC Right Battery - ON'),				category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = 'F2', reformers = {'LCtrl','LShift'}}},	down = elec_commands.BatteryRight,					cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0,		name = _('DC Right Battery - OFF'),				category = {_('Electrical Control Panel'), _('DC Panel')}},
--{combos = {{key = '3', reformers = {'LCtrl','LShift'}}},	down = elec_commands.RectifierLeftEXT,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('DC Left Rectifier - ON/OFF'),			category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = '3', reformers = {'LCtrl','LShift'}}},	down = elec_commands.RectifierLeft,					cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('DC Left Rectifier - ON'),				category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = 'F3', reformers = {'LCtrl','LShift'}}},	down = elec_commands.RectifierLeft,					cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0,		name = _('DC Left Rectifier - OFF'),			category = {_('Electrical Control Panel'), _('DC Panel')}},
--{combos = {{key = '4', reformers = {'LCtrl','LShift'}}},	down = elec_commands.RectifierRightEXT,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('DC Right Rectifier - ON/OFF'),		category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = '4', reformers = {'LCtrl','LShift'}}},	down = elec_commands.RectifierRight,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('DC Right Rectifier - ON'),			category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = 'F4', reformers = {'LCtrl','LShift'}}},	down = elec_commands.RectifierRight,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0,		name = _('DC Right Rectifier - OFF'),			category = {_('Electrical Control Panel'), _('DC Panel')}},
--{combos = {{key = '5', reformers = {'LCtrl','LShift'}}},	down = elec_commands.DCGeneratorEXT,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('DC Starter-Generator - ON/OFF'),		category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = '5', reformers = {'LCtrl','LShift'}}},	down = elec_commands.DCGenerator,					cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('DC Starter-Generator - ON'),			category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = 'F5', reformers = {'LCtrl','LShift'}}},	down = elec_commands.DCGenerator,					cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0,		name = _('DC Starter-Generator - OFF'),			category = {_('Electrical Control Panel'), _('DC Panel')}},
--{combos = {{key = '6', reformers = {'LCtrl','LShift'}}},	down = elec_commands.BatteryHeatingEXT,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('DC Battery Heating - ON/OFF'),		category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = '6', reformers = {'LCtrl','LShift'}}},	down = elec_commands.BatteryHeating,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('DC Battery Heating - ON'),			category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = 'F6', reformers = {'LCtrl','LShift'}}},	down = elec_commands.BatteryHeating,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0,		name = _('DC Battery Heating - OFF'),			category = {_('Electrical Control Panel'), _('DC Panel')}},
--{combos = {{key = '7', reformers = {'LCtrl','LShift'}}},	down = elec_commands.NetworkToBatteriesEXT,			cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('DC Net to Batt switch - ON/OFF'),		category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = '7', reformers = {'LCtrl','LShift'}}},	down = elec_commands.NetworkToBatteries,			cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('DC Circuits to Batt switch - ON'),	category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = 'F7', reformers = {'LCtrl','LShift'}}},	down = elec_commands.NetworkToBatteries,			cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0,		name = _('DC Circuits to Batt switch - OFF'),	category = {_('Electrical Control Panel'), _('DC Panel')}},
--{combos = {{key = '9', reformers = {'LCtrl','LShift'}}}, 	down = elec_commands.DCGangSwitcher,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,		name = _('DC Voltmeter switch - CW'),			category = {_('Electrical Control Panel'), _('DC Panel')}},
--{combos = {{key = '8', reformers = {'LCtrl','LShift'}}},	down = elec_commands.DCGangSwitcher,				cockpit_device_id = devices.ELEC_INTERFACE, value_down = -1,	name = _('DC Voltmeter switch - CCW'),			category = {_('Electrical Control Panel'), _('DC Panel')}},

-- temp
{combos = {{key = 'Num0', reformers = {'LCtrl','LShift'}}}, 	down = elec_commands.DCGangSwitcherSet,			cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0,			name = _('DC Voltmeter switch - 0'),			category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = 'Num1', reformers = {'LCtrl','LShift'}}}, 	down = elec_commands.DCGangSwitcherSet,			cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0.1111111,	name = _('DC Voltmeter switch - 1'),			category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = 'Num2', reformers = {'LCtrl','LShift'}}}, 	down = elec_commands.DCGangSwitcherSet,			cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0.2222222,	name = _('DC Voltmeter switch - 2'),			category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = 'Num3', reformers = {'LCtrl','LShift'}}}, 	down = elec_commands.DCGangSwitcherSet,			cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0.3333333,	name = _('DC Voltmeter switch - 3'),			category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = 'Num4', reformers = {'LCtrl','LShift'}}}, 	down = elec_commands.DCGangSwitcherSet,			cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0.4444444,	name = _('DC Voltmeter switch - 4'),			category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = 'Num5', reformers = {'LCtrl','LShift'}}}, 	down = elec_commands.DCGangSwitcherSet,			cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0.5555555,	name = _('DC Voltmeter switch - 5'),			category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = 'Num6', reformers = {'LCtrl','LShift'}}}, 	down = elec_commands.DCGangSwitcherSet,			cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0.6666666,	name = _('DC Voltmeter switch - 6'),			category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = 'Num7', reformers = {'LCtrl','LShift'}}}, 	down = elec_commands.DCGangSwitcherSet,			cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0.7777777,	name = _('DC Voltmeter switch - 7'),			category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = 'Num8', reformers = {'LCtrl','LShift'}}}, 	down = elec_commands.DCGangSwitcherSet,			cockpit_device_id = devices.ELEC_INTERFACE, value_down = 0.8888888,	name = _('DC Voltmeter switch - 8'),			category = {_('Electrical Control Panel'), _('DC Panel')}},
{combos = {{key = 'Num9', reformers = {'LCtrl','LShift'}}}, 	down = elec_commands.DCGangSwitcherSet,			cockpit_device_id = devices.ELEC_INTERFACE, value_down = 1,			name = _('DC Voltmeter switch - 9'),			category = {_('Electrical Control Panel'), _('DC Panel')}},

--Fuel System
--{combos = {{key = '1', reformers = {'LCtrl','LAlt'}}},	down = fuel_commands.ValveTank1EXT,			cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 1,		name = _('Tank 1 valve Open/Close'),			category = {_('Fuel Control Panel')}},
{combos = {{key = '1', reformers = {'LCtrl','LAlt'}}},		down = fuel_commands.ValveTank1,			cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 1,		name = _('Tank 1 valve Open'),					category = {_('Fuel Control Panel')}},
{combos = {{key = 'F1', reformers = {'LCtrl','LAlt'}}},		down = fuel_commands.ValveTank1,			cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 0,		name = _('Tank 1 valve Close'),					category = {_('Fuel Control Panel')}},
--{combos = {{key = '2', reformers = {'LCtrl','LAlt'}}},	down = fuel_commands.ValveTank2EXT,			cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 1,		name = _('Tank 2 valve Open/Close'),			category = {_('Fuel Control Panel')}},
{combos = {{key = '2', reformers = {'LCtrl','LAlt'}}},		down = fuel_commands.ValveTank2,			cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 1,		name = _('Tank 2 valve Open'),					category = {_('Fuel Control Panel')}},
{combos = {{key = 'F2', reformers = {'LCtrl','LAlt'}}},		down = fuel_commands.ValveTank2,			cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 0,		name = _('Tank 2 valve Close'),					category = {_('Fuel Control Panel')}},
--{combos = {{key = '3', reformers = {'LCtrl','LAlt'}}},	down = fuel_commands.ValveLeftEngineEXT		cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 1,		name = _('Left Engine fire valve Open/Close'),	category = {_('Fuel Control Panel')}},
{combos = {{key = '3', reformers = {'LCtrl','LAlt'}}},		down = fuel_commands.ValveLeftEngine,		cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 1,		name = _('Left Engine fire valve Open'),		category = {_('Fuel Control Panel')}},
{combos = {{key = 'F3', reformers = {'LCtrl','LAlt'}}},		down = fuel_commands.ValveLeftEngine,		cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 0,		name = _('Left Engine fire valve Close'),		category = {_('Fuel Control Panel')}},
--{combos = {{key = '4', reformers = {'LCtrl','LAlt'}}},	down = fuel_commands.ValveRightEngineEXT,	cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 1,		name = _('Right Engine fire valve Open/Close'),	category = {_('Fuel Control Panel')}},
{combos = {{key = '4', reformers = {'LCtrl','LAlt'}}},		down = fuel_commands.ValveRightEngine,		cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 1,		name = _('Right Engine fire valve Open'),		category = {_('Fuel Control Panel')}},
{combos = {{key = 'F4', reformers = {'LCtrl','LAlt'}}},		down = fuel_commands.ValveRightEngine,		cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 0,		name = _('Right Engine fire valve Close'),		category = {_('Fuel Control Panel')}},
--{combos = {{key = '5', reformers = {'LCtrl','LAlt'}}},	down = fuel_commands.ValveDelimiterEXT,		cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 1,		name = _('Delimiter valve Open/Close'),			category = {_('Fuel Control Panel')}},
{combos = {{key = '5', reformers = {'LCtrl','LAlt'}}},		down = fuel_commands.ValveDelimiter,		cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 1,		name = _('Delimiter valve Open'),				category = {_('Fuel Control Panel')}},
{combos = {{key = 'F5', reformers = {'LCtrl','LAlt'}}},		down = fuel_commands.ValveDelimiter,		cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 0,		name = _('Delimiter valve Close'),				category = {_('Fuel Control Panel')}},
--{combos = {{key = '6', reformers = {'LCtrl','LAlt'}}},	down = fuel_commands.ExtTankEXT,			cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 1,		name = _('External tanks ON/OFF'),				category = {_('Fuel Control Panel')}},
{combos = {{key = '6', reformers = {'LCtrl','LAlt'}}},		down = fuel_commands.ExtTank,				cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 1,		name = _('External tanks ON'),					category = {_('Fuel Control Panel')}},
{combos = {{key = 'F6', reformers = {'LCtrl','LAlt'}}},		down = fuel_commands.ExtTank,				cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 0,		name = _('External tanks OFF'),					category = {_('Fuel Control Panel')}},
--{combos = {{key = '7', reformers = {'LCtrl','LAlt'}}},	down = fuel_commands.Tank4PumpEXT,			cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 1,		name = _('Pump 4 tank ON/OFF'),					category = {_('Fuel Control Panel')}},
{combos = {{key = '7', reformers = {'LCtrl','LAlt'}}},		down = fuel_commands.Tank4Pump,				cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 1,		name = _('Pump 4 tank ON'),						category = {_('Fuel Control Panel')}},
{combos = {{key = 'F7', reformers = {'LCtrl','LAlt'}}},		down = fuel_commands.Tank4Pump,				cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 0,		name = _('Pump 4 tank OFF'),					category = {_('Fuel Control Panel')}},
--{combos = {{key = '8', reformers = {'LCtrl','LAlt'}}},	down = fuel_commands.Tank5PumpEXT,			cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 1,		name = _('Pump 5 tank ON/OFF'),					category = {_('Fuel Control Panel')}},
{combos = {{key = '8', reformers = {'LCtrl','LAlt'}}},		down = fuel_commands.Tank5Pump,				cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 1,		name = _('Pump 5 tank ON'),						category = {_('Fuel Control Panel')}},
{combos = {{key = 'F8', reformers = {'LCtrl','LAlt'}}},		down = fuel_commands.Tank5Pump,				cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 0,		name = _('Pump 5 tank OFF'),					category = {_('Fuel Control Panel')}},
--{combos = {{key = '9', reformers = {'LCtrl','LAlt'}}},	down = fuel_commands.Tank1PumpEXT,			cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 1,		name = _('Pump 1 tank ON/OFF'),					category = {_('Fuel Control Panel')}},
{combos = {{key = '9', reformers = {'LCtrl','LAlt'}}},		down = fuel_commands.Tank1Pump,				cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 1,		name = _('Pump 1 tank ON'),						category = {_('Fuel Control Panel')}},
{combos = {{key = 'F9', reformers = {'LCtrl','LAlt'}}},		down = fuel_commands.Tank1Pump,				cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 0,		name = _('Pump 1 tank OFF'),					category = {_('Fuel Control Panel')}},
--{combos = {{key = '0', reformers = {'LCtrl','LAlt'}}},	down = fuel_commands.Tank2PumpEXT,			cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 1,		name = _('Pump 2 tank ON/OFF'),					category = {_('Fuel Control Panel')}},
{combos = {{key = '0', reformers = {'LCtrl','LAlt'}}},		down = fuel_commands.Tank2Pump,				cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 1,		name = _('Pump 2 tank ON'),						category = {_('Fuel Control Panel')}},
{combos = {{key = 'F10', reformers = {'LCtrl','LAlt'}}},	down = fuel_commands.Tank2Pump,				cockpit_device_id = devices.FUELSYS_INTERFACE, value_down = 0,		name = _('Pump 2 tank OFF'),					category = {_('Fuel Control Panel')}},

--Fire extinguisher
--1st queue
{combos = {{key = 'Q', reformers = {'LCtrl','LAlt'}}},		up = fire_commands.ExtingiushLE1,			cockpit_device_id = devices.FIRE_EXTING_INTERFACE,	value_up = 0,		
															down = fire_commands.ExtingiushLE1,																value_down = 1,		name = _('Extinguish Left Engine 1'),		category = {_('Fire Extinguisher Control Panel')}},
{combos = {{key = 'W', reformers = {'LCtrl','LAlt'}}},		up = fire_commands.ExtingiushRE1,			cockpit_device_id = devices.FIRE_EXTING_INTERFACE,	value_up = 0,		
															down = fire_commands.ExtingiushRE1,																value_down = 1,		name = _('Extinguish Right Engine 1'),		category = {_('Fire Extinguisher Control Panel')}},
{combos = {{key = 'E', reformers = {'LCtrl','LAlt'}}},		up = fire_commands.ExtingiushAPU1,			cockpit_device_id = devices.FIRE_EXTING_INTERFACE,	value_up = 0,		
															down = fire_commands.ExtingiushAPU1,															value_down = 1,		name = _('Extinguish APU 1'),				category = {_('Fire Extinguisher Control Panel')}},
{combos = {{key = 'R', reformers = {'LCtrl','LAlt'}}},		up = fire_commands.ExtingiushMRED1,			cockpit_device_id = devices.FIRE_EXTING_INTERFACE,	value_up = 0,		
															down = fire_commands.ExtingiushMRED1,															value_down = 1,		name = _('Extinguish Main Reductor 1'),		category = {_('Fire Extinguisher Control Panel')}},
--2nd queue
{combos = {{key = 'A', reformers = {'LCtrl','LAlt'}}},		up = fire_commands.ExtingiushLE2,			cockpit_device_id = devices.FIRE_EXTING_INTERFACE,	value_up = 0,		
															down = fire_commands.ExtingiushLE2,																value_down = 1,		name = _('Extinguish Left Engine 2'),		category = {_('Fire Extinguisher Control Panel')}},
{combos = {{key = 'S', reformers = {'LCtrl','LAlt'}}},		up = fire_commands.ExtingiushRE2,			cockpit_device_id = devices.FIRE_EXTING_INTERFACE,	value_up = 0,		
															down = fire_commands.ExtingiushRE2,																value_down = 1,		name = _('Extinguish Right Engine 2'),		category = {_('Fire Extinguisher Control Panel')}},
{combos = {{key = 'D', reformers = {'LCtrl','LAlt'}}},		up = fire_commands.ExtingiushAPU2,			cockpit_device_id = devices.FIRE_EXTING_INTERFACE,	value_up = 0,		
															down = fire_commands.ExtingiushAPU2,															value_down = 1,		name = _('Extinguish APU 2'),				category = {_('Fire Extinguisher Control Panel')}},
{combos = {{key = 'F', reformers = {'LCtrl','LAlt'}}},		up = fire_commands.ExtingiushMRED2,			cockpit_device_id = devices.FIRE_EXTING_INTERFACE,	value_up = 0,		
															down = fire_commands.ExtingiushMRED2,															value_down = 1,		name = _('Extinguish Main Reductor 2'),		category = {_('Fire Extinguisher Control Panel')}},


-- Autopilot
{combos = {{key = 'D', reformers = {'LCtrl','LShift'}}},	up = autopilot_commands.ButtonHonEXT,		cockpit_device_id = devices.AUTOPILOT,	value_up = 0,		
															down = autopilot_commands.ButtonHonEXT,											value_down = 1,		name = _('Autopilot H on'),		category = {_('Autopilot (SAU-V24)')}},
{combos = {{key = 'C', reformers = {'LCtrl','LShift'}}},	up = autopilot_commands.ButtonHoffEXT,		cockpit_device_id = devices.AUTOPILOT,	value_up = 0,		
															down = autopilot_commands.ButtonHoffEXT,											value_down = 1,		name = _('Autopilot H off'),	category = {_('Autopilot (SAU-V24)')}},
{combos = {{key = 'F', reformers = {'LCtrl','LShift'}}},	up = autopilot_commands.ButtonKonEXT,		cockpit_device_id = devices.AUTOPILOT,	value_up = 0,		
															down = autopilot_commands.ButtonKonEXT,											value_down = 1,		name = _('Autopilot K on'),		category = {_('Autopilot (SAU-V24)')}},
{combos = {{key = 'V', reformers = {'LCtrl','LShift'}}},	up = autopilot_commands.ButtonKoffEXT,		cockpit_device_id = devices.AUTOPILOT,	value_up = 0,		
															down = autopilot_commands.ButtonKoffEXT,											value_down = 1,		name = _('Autopilot K off'),	category = {_('Autopilot (SAU-V24)')}},
{combos = {{key = 'G', reformers = {'LCtrl','LShift'}}},	up = autopilot_commands.ButtonTonEXT,		cockpit_device_id = devices.AUTOPILOT,	value_up = 0,		
															down = autopilot_commands.ButtonTonEXT,											value_down = 1,		name = _('Autopilot T on'),		category = {_('Autopilot (SAU-V24)')}},
{combos = {{key = 'B', reformers = {'LCtrl','LShift'}}},	up = autopilot_commands.ButtonToffEXT,		cockpit_device_id = devices.AUTOPILOT,	value_up = 0,		
															down = autopilot_commands.ButtonToffEXT,											value_down = 1,		name = _('Autopilot T off'),	category = {_('Autopilot (SAU-V24)')}},
{combos = {{key = 'H', reformers = {'LCtrl','LShift'}}},	up = autopilot_commands.ButtonBonEXT,		cockpit_device_id = devices.AUTOPILOT,	value_up = 0,		
															down = autopilot_commands.ButtonBonEXT,											value_down = 1,		name = _('Autopilot B on'),		category = {_('Autopilot (SAU-V24)')}},
{combos = {{key = 'N', reformers = {'LCtrl','LShift'}}},	up = autopilot_commands.ButtonBoffEXT,		cockpit_device_id = devices.AUTOPILOT,	value_up = 0,		
															down = autopilot_commands.ButtonBoffEXT,											value_down = 1,		name = _('Autopilot B off'),	category = {_('Autopilot (SAU-V24)')}},
{combos = {{key = 'M', reformers = {'LCtrl','LShift'}}},	up = autopilot_commands.AutopilotOffEXT,	cockpit_device_id = devices.AUTOPILOT,	value_up = 0,		
															down = autopilot_commands.AutopilotOffEXT,											value_down = 1,		name = _('Autopilot OFF'),		category = {_('Ins Cyclic Stick')}},


{combos = {{key = 'U', reformers = {'LCtrl','LShift'}}},	up = autopilot_commands.HoverOnEXT,			cockpit_device_id = devices.AUTOPILOT,	value_up = 0,		
															down = autopilot_commands.HoverOnEXT,													value_down = 1,		name = _('Autopilot Hover mode'),		category = {_('Autopilot (SAU-V24)')}},
{combos = {{key = 'I', reformers = {'LCtrl','LShift'}}},	up = autopilot_commands.RouteHoverOffEXT,		cockpit_device_id = devices.AUTOPILOT,	value_up = 0,		
															down = autopilot_commands.RouteHoverOffEXT,											value_down = 1,		name = _('Autopilot Hover/Route off'),	category = {_('Autopilot (SAU-V24)')}},
{combos = {{key = 'O', reformers = {'LCtrl','LShift'}}},	up = autopilot_commands.RouteOnEXT,			cockpit_device_id = devices.AUTOPILOT,	value_up = 0,		
															down = autopilot_commands.RouteOnEXT,													value_down = 1,		name = _('Autopilot Route mode'),		category = {_('Autopilot (SAU-V24)')}},

{combos = {{key = 'K', reformers = {'LCtrl','LShift'}}},	up = autopilot_commands.HeightOffEXT,			cockpit_device_id = devices.AUTOPILOT,	value_up = 0,		
															down = autopilot_commands.HeightOffEXT,												value_down = 1,		name = _('Autopilot Landing/Height off'),	category = {_('Autopilot (SAU-V24)')}},
{combos = {{key = 'L', reformers = {'LCtrl','LShift'}}},	up = autopilot_commands.HeightOnEXT,			cockpit_device_id = devices.AUTOPILOT,	value_up = 0,		
															down = autopilot_commands.HeightOnEXT,													value_down = 1,		name = _('Autopilot Height mode'),			category = {_('Autopilot (SAU-V24)')}},
{combos = {{key = ',', reformers = {'LCtrl','LShift'}}},	down = autopilot_commands.SpeedOnEXT,			cockpit_device_id = devices.AUTOPILOT, 	value_down = 1,		name = _('Speed Stabilization On'),			category = {_('Autopilot (SAU-V24)')}},
{combos = {{key = '.', reformers = {'LCtrl','LShift'}}},	down = autopilot_commands.SpeedOffEXT,			cockpit_device_id = devices.AUTOPILOT, 	value_down = 1,		name = _('Speed Stabilization Off'),		category = {_('Autopilot')}},

															
--Helper AI
{combos = {{key = 'V', reformers = {'LCtrl'}}},	up = helperai_commands.ShowMenu, 	down = helperai_commands.ShowMenu, 	cockpit_device_id = devices.HELPER_AI, value_up = 0, value_down = 1,	name = _('Show/Hide Menu'),	category = {_('Helper AI Commands')}},
{combos = {{key = 'W', reformers = {'LCtrl'}}},up = helperai_commands.MainWeapSwitch, 	down = helperai_commands.MainWeapSwitch, 	cockpit_device_id = devices.HELPER_AI, value_up = 0, value_down = 1,	name = _('Prepare Weapons Systems'),	category = {_('Helper AI Commands')}},
{combos = {{key = 'C'}}, up = helperai_commands.HeliControlEXT, down = helperai_commands.HeliControlEXT,	cockpit_device_id = devices.HELPER_AI, 	value_up = 0, value_down = 1,	name = _('Request Aircraft Control'),	category = {_('Helper AI Commands'), _('Multicrew')}},
{up = helperai_commands.Select_or_fireEXT, down = helperai_commands.Select_or_fireEXT,	cockpit_device_id = devices.HELPER_AI, 	value_up = 0, value_down = 1,	name = _('Select target with ASP-17/Order to fire'),	category = {_('Helper AI Commands')}},


--Map display (TEMP)
{combos = {{key = 'Num+', reformers = {'RAlt','RCtrl'}}},	down = map_display_commands.Power,		cockpit_device_id = devices.MAP_DISPLAY, value_down = 1,		name = _('Map display ON'),						category = {_('Map Display Commands')}},
{combos = {{key = 'Num-', reformers = {'RAlt','RCtrl'}}},	down = map_display_commands.Power,		cockpit_device_id = devices.MAP_DISPLAY, value_down = 0,		name = _('Map display OFF'),					category = {_('Map Display Commands')}},
{combos = {{key = 'Num1', reformers = {'RAlt','RCtrl'}}},	down = map_display_commands.Scale,		cockpit_device_id = devices.MAP_DISPLAY, value_down = 1,		name = _('Map display scale 10km'),				category = {_('Map Display Commands')}},
{combos = {{key = 'Num2', reformers = {'RAlt','RCtrl'}}},	down = map_display_commands.Scale,		cockpit_device_id = devices.MAP_DISPLAY, value_down = 0,		name = _('Map display scale 2km'),				category = {_('Map Display Commands')}},
--Map Lights
{down = map_display_commands.Lights_EXT, cockpit_device_id = devices.MAP_DISPLAY,			value_down = 1,                     	name = _('Map Lights Switch - BRIGHT'),									category = {_('Right Forward Panel'), _('Map Display Commands')}},
{down = map_display_commands.Lights_EXT, cockpit_device_id = devices.MAP_DISPLAY,			value_down = 0,                     	name = _('Map Lights Switch - OFF'),									category = {_('Right Forward Panel'), _('Map Display Commands')}},
{down = map_display_commands.Lights_EXT, cockpit_device_id = devices.MAP_DISPLAY,			value_down = -1,                     	name = _('Map Lights Switch - DIM'),									category = {_('Right Forward Panel'), _('Map Display Commands')}},
-- Accelerometer
{combos = {{key = 'O', reformers = {'LCtrl','LAlt'}}},		down = G_Meter_commands.Command_AccelReset_EXT, up = G_Meter_commands.Command_AccelReset_EXT, cockpit_device_id = devices.G_Meter, value_down = 1, value_up = 0, name = _('Accelerometer Reset Button'), category = {_('Instrument Panel')}},

-- ARC-U2		
{combos = {{key = 'Q', reformers = {'RAlt','RCtrl'}}},down = ARC_U2_commands.CMD_ARC_U2_ON_OFF_EXT, 		up = ARC_U2_commands.CMD_ARC_U2_ON_OFF_EXT, 		cockpit_device_id = devices.ARC_U2, value_down = 1, value_up = 0, name = _('ARC-U2 POWER - ON/OFF'), category = {_('Left Side Panel')}},
{combos = {{key = 'W', reformers = {'RAlt','RCtrl'}}},down = ARC_U2_commands.CMD_ARC_U2_FRAME_EXT_LEFT, 	up = ARC_U2_commands.CMD_ARC_U2_FRAME_EXT_LEFT, 	cockpit_device_id = devices.ARC_U2, value_down = -1,	value_up = 0, name = _('ARC-U2 Left RAMKA Right Switch - L position'), category = {_('Left Side Panel')}},
-- TODO: to assign combo
{down = ARC_U2_commands.CMD_ARC_U2_FRAME_EXT_RIGHT, up = ARC_U2_commands.CMD_ARC_U2_FRAME_EXT_RIGHT, 	cockpit_device_id = devices.ARC_U2, value_down = 1,	value_up = 0, name = _('ARC-U2 Left RAMKA Right Switch - P position'), category = {_('Left Side Panel')}},
{combos = {{key = 'E', reformers = {'RAlt','RCtrl'}}},down = ARC_U2_commands.CMD_ARC_U2_SENS_EXT,  			up = ARC_U2_commands.CMD_ARC_U2_SENS_EXT, 			cockpit_device_id = devices.ARC_U2, value_down = 1,	value_up = 0, name = _('ARC-U2 Sensitivity Switch - MORE/LESS'), category = {_('Left Side Panel')}},
{combos = {{key = 'R', reformers = {'RAlt','RCtrl'}}},down = ARC_U2_commands.CMD_ARC_U2_COMPASS_CONNECT_EXT,up = ARC_U2_commands.CMD_ARC_U2_COMPASS_CONNECT_EXT,cockpit_device_id = devices.ARC_U2,	value_down = 1,	value_up = 0, name = _('ARC-U2 Compass Selector Switch - COMPASS R-852–RADIOLINK–COMPASS R-828'), category = {_('Left Side Panel')}},

-- Intercom Panels -----------------------------
------------------------------------------------
{combos = {{key = 'Q', reformers = {'LAlt','LShift'}}},	pressed = SPU_8_Mi24_commands.CMD_SPU8_MAIN_VOLUME_EXT,	value_pressed = -0.2,	cockpit_device_id = devices.SPU_8,	name = _('SPU-8 Main Volume Knob - CCW/Decrease'),			category = {_('SPU-8 Intercom Panels')}},
{combos = {{key = 'Q', reformers = {'LAlt','LCtrl'}}},	pressed = SPU_8_Mi24_commands.CMD_SPU8_MAIN_VOLUME_EXT,	value_pressed = 0.2,	cockpit_device_id = devices.SPU_8,	name = _('SPU-8 Main Volume Knob - CW/Increase'),			category = {_('SPU-8 Intercom Panels')}},
{combos = {{key = 'W', reformers = {'LAlt','LShift'}}},	pressed = SPU_8_Mi24_commands.CMD_SPU8_RADIO_VOLUME_EXT,value_pressed = -0.2,	cockpit_device_id = devices.SPU_8,	name = _('SPU-8 Listening Volume Knob - CCW/Decrease'),		category = {_('SPU-8 Intercom Panels')}},
{combos = {{key = 'W', reformers = {'LAlt','LCtrl'}}},	pressed = SPU_8_Mi24_commands.CMD_SPU8_RADIO_VOLUME_EXT,value_pressed = 0.2,	cockpit_device_id = devices.SPU_8,	name = _('SPU-8 Listening Volume Knob - CW/Increase'),		category = {_('SPU-8 Intercom Panels')}},
{combos = {{key = 'E', reformers = {'LAlt','LShift'}}},	down = SPU_8_Mi24_commands.CMD_SPU8_MODE_EXT,			value_down = -1,		cockpit_device_id = devices.SPU_8,	name = _('SPU-8 Radio Source Select Rotary - CCW/Left'),	category = {_('SPU-8 Intercom Panels')}},
{combos = {{key = 'E', reformers = {'LAlt','LCtrl'}}},	down = SPU_8_Mi24_commands.CMD_SPU8_MODE_EXT,			value_down = 1,			cockpit_device_id = devices.SPU_8,	name = _('SPU-8 Radio Source Select Rotary - CW/Right'),	category = {_('SPU-8 Intercom Panels')}},
{combos = {{key = 'Z', reformers = {'LAlt','LCtrl'}}},	down = SPU_8_Mi24_commands.CMD_SPU8_ICS_RADIO_EXT,		value_down = 1,			cockpit_device_id = devices.SPU_8,	name = _('SPU-8 Mode Switch - RADIO/ICS'),					category = {_('SPU-8 Intercom Panels')}},	
{combos = {{key = 'L', reformers = {'LAlt','LCtrl'}}},	down = SPU_8_Mi24_commands.CMD_SPU8_O_ICS_EXT,			value_down = 1,			cockpit_device_id = devices.SPU_8,	name = _('SPU-8 Switch - ICS/OFF'),							category = {_('SPU-8 Intercom Panels')}},								
	
-- IFF Transponder-----------------------------
{down = IFF_6201_commands.CMD_IFF_Erase_BtnCover_EXT,									cockpit_device_id = devices.IFF,	value_down = 1,						name = _('IFF Transponder Erase Button Cover - OPEN/CLOSE'),		category = {_('Left Side Panel'), _('IFF Transponder')}},
{down = IFF_6201_commands.CMD_IFF_Disaster_SwCover_EXT,									cockpit_device_id = devices.IFF,	value_down = 1,						name = _('IFF Transponder Disaster Switch Cover - OPEN/CLOSE'),		category = {_('Left Side Panel'), _('IFF Transponder')}},
{down = IFF_6201_commands.CMD_IFF_Disaster_Sw_EXT,										cockpit_device_id = devices.IFF,	value_down = 1,						name = _('IFF Transponder Disaster Switch - ON/OFF'),				category = {_('Left Side Panel'), _('IFF Transponder')}},
{down = IFF_6201_commands.CMD_IFF_1_2_EXT,												cockpit_device_id = devices.IFF,	value_down = 1,						name = _('IFF Transponder Device Mode Switch - 1/2'),				category = {_('Left Side Panel'), _('IFF Transponder')}},
{down = IFF_6201_commands.CMD_IFF_Device_Sw_EXT,										cockpit_device_id = devices.IFF,	value_down = 1,						name = _('IFF Transponder Device Selector Switch - WORK/RESERVE'),	category = {_('Left Side Panel'), _('IFF Transponder')}},
{down = IFF_6201_commands.CMD_IFF_Mode_Sw_EXT,											cockpit_device_id = devices.IFF,	value_down = 1,						name = _('IFF Transponder Mode Selector Switch - CW/Right'),		category = {_('Left Side Panel'), _('IFF Transponder')}},
{down = IFF_6201_commands.CMD_IFF_Mode_Sw_EXT,											cockpit_device_id = devices.IFF,	value_down = -1,					name = _('IFF Transponder Mode Selector Switch - CCW/Left'),		category = {_('Left Side Panel'), _('IFF Transponder')}},
{down = IFF_6201_commands.CMD_IFF_Power_Sw_EXT,											cockpit_device_id = devices.IFF,	value_down = 1,						name = _('IFF Transponder Power Switch - CCW/Left'),				category = {_('Left Side Panel'), _('IFF Transponder')}},

-- Signal Flare
{combos = {{key = '`', reformers = {'LShift'}}},	down = signal_flares_commands.CMD_Cassette1_Power_EXT,		cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 1,		name = _('EKSR-46 Signal Flare Dispenser Cassette 1 Power Switch - ON/OFF'),	category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{													down = signal_flares_commands.CMD_Cassette1_Power,			cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 1,		name = _('EKSR-46 Signal Flare Dispenser Cassette 1 Power Switch - ON'),		category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{													down = signal_flares_commands.CMD_Cassette1_Power,			cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 0,		name = _('EKSR-46 Signal Flare Dispenser Cassette 1 Power Switch - OFF'),		category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{													down = signal_flares_commands.CMD_drop_Cassette1_RED_EXT,	cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 1,		name = _('EKSR-46 Cassette 1 Red Signal Flare Launch Button - ON/OFF'),			category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{combos = {{key = '1', reformers = {'LShift'}}},	down = signal_flares_commands.CMD_drop_Cassette1_RED,		cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 1,		name = _('EKSR-46 Cassette 1 Red Signal Flare Launch Button - ON'),				category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{													down = signal_flares_commands.CMD_drop_Cassette1_RED,		cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 0,		name = _('EKSR-46 Cassette 1 Red Signal Flare Launch Button - OFF'),			category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{													down = signal_flares_commands.CMD_drop_Cassette1_GREEN_EXT,	cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 1,		name = _('EKSR-46 Cassette 1 Green Signal Flare Launch Button - ON/OFF'),		category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{combos = {{key = '2', reformers = {'LShift'}}},	down = signal_flares_commands.CMD_drop_Cassette1_GREEN,		cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 1,		name = _('EKSR-46 Cassette 1 Green Signal Flare Launch Button - ON'),			category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{													down = signal_flares_commands.CMD_drop_Cassette1_GREEN,		cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 0,		name = _('EKSR-46 Cassette 1 Green Signal Flare Launch Button - OFF'),			category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{													down = signal_flares_commands.CMD_drop_Cassette1_YELLOW_EXT,cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 1,		name = _('EKSR-46 Cassette 1 Yellow Signal Flare Launch Button - ON/OFF'),		category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{combos = {{key = '3', reformers = {'LShift'}}},	down = signal_flares_commands.CMD_drop_Cassette1_YELLOW,	cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 1,		name = _('EKSR-46 Cassette 1 Yellow Signal Flare Launch Button - ON'),			category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{													down = signal_flares_commands.CMD_drop_Cassette1_YELLOW,	cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 0,		name = _('EKSR-46 Cassette 1 Yellow Signal Flare Launch Button - OFF'),			category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{													down = signal_flares_commands.CMD_drop_Cassette1_WHITE_EXT,	cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 1,		name = _('EKSR-46 Cassette 1 White Signal Flare Launch Button - ON/OFF'),		category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{combos = {{key = '4', reformers = {'LShift'}}},	down = signal_flares_commands.CMD_drop_Cassette1_WHITE,		cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 1,		name = _('EKSR-46 Cassette 1 White Signal Flare Launch Button - ON'),			category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{													down = signal_flares_commands.CMD_drop_Cassette1_WHITE,		cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 0,		name = _('EKSR-46 Cassette 1 White Signal Flare Launch Button - OFF'),			category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{combos = {{key = '`', reformers = {'LCtrl'}}},		down = signal_flares_commands.CMD_Cassette2_Power_EXT,		cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 1,		name = _('EKSR-46 Signal Flare Dispenser Cassette 2 Power Switch - ON/OFF'),	category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{													down = signal_flares_commands.CMD_Cassette2_Power,			cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 1,		name = _('EKSR-46 Signal Flare Dispenser Cassette 2 Power Switch - ON'),		category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{													down = signal_flares_commands.CMD_Cassette2_Power,			cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 0,		name = _('EKSR-46 Signal Flare Dispenser Cassette 2 Power Switch - OFF'),		category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{													down = signal_flares_commands.CMD_drop_Cassette2_RED_EXT,	cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 1,		name = _('EKSR-46 Cassette 2 Red Signal Flare Launch Button - ON/OFF'),			category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{combos = {{key = '1', reformers = {'LCtrl'}}},		down = signal_flares_commands.CMD_drop_Cassette2_RED,		cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 1,		name = _('EKSR-46 Cassette 2 Red Signal Flare Launch Button - ON'),				category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{													down = signal_flares_commands.CMD_drop_Cassette2_RED,		cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 0,		name = _('EKSR-46 Cassette 2 Red Signal Flare Launch Button - OFF'),			category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{													down = signal_flares_commands.CMD_drop_Cassette2_GREEN_EXT,	cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 1,		name = _('EKSR-46 Cassette 2 Green Signal Flare Launch Button - ON/OFF'),		category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{combos = {{key = '2', reformers = {'LCtrl'}}},		down = signal_flares_commands.CMD_drop_Cassette2_GREEN,		cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 1,		name = _('EKSR-46 Cassette 2 Green Signal Flare Launch Button - ON'),			category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{													down = signal_flares_commands.CMD_drop_Cassette2_GREEN,		cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 0,		name = _('EKSR-46 Cassette 2 Green Signal Flare Launch Button - OFF'),			category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{													down = signal_flares_commands.CMD_drop_Cassette2_YELLOW_EXT,cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 1,		name = _('EKSR-46 Cassette 2 Yellow Signal Flare Launch Button - ON/OFF'),		category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{combos = {{key = '3', reformers = {'LCtrl'}}},		down = signal_flares_commands.CMD_drop_Cassette2_YELLOW,	cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 1,		name = _('EKSR-46 Cassette 2 Yellow Signal Flare Launch Button - ON'),			category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{													down = signal_flares_commands.CMD_drop_Cassette2_YELLOW,	cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 0,		name = _('EKSR-46 Cassette 2 Yellow Signal Flare Launch Button - OFF'),			category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{													down = signal_flares_commands.CMD_drop_Cassette2_WHITE_EXT,	cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 1,		name = _('EKSR-46 Cassette 2 White Signal Flare Launch Button - ON/OFF'),		category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{combos = {{key = '4', reformers = {'LCtrl'}}},		down = signal_flares_commands.CMD_drop_Cassette2_WHITE,		cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 1,		name = _('EKSR-46 Cassette 2 White Signal Flare Launch Button - ON'),			category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},
{													down = signal_flares_commands.CMD_drop_Cassette2_WHITE,		cockpit_device_id = devices.SIGNAL_FLARES,	value_down = 0,		name = _('EKSR-46 Cassette 2 White Signal Flare Launch Button - OFF'),			category = {_('Left Side Panel'), _('Signal Flare Dispenser')}},

-- Recorder MC 61
{down = RecorderMC61_commands.CMD_Power_EXT,		cockpit_device_id = devices.Recorder_MC61,	value_down = 1,			name = _('Recorder MC-61 Power Switch - ON/OFF'),			category = {_('Left Side Panel'), _('Recorder MC-61')}},
{pressed = RecorderMC61_commands.CMD_LightRst_EXT,	cockpit_device_id = devices.Recorder_MC61,	value_pressed = 0.2,	name = _('Recorder MC-61 Brightness Knob - CW/Increase'),	category = {_('Left Side Panel'), _('Recorder MC-61')}},
{pressed = RecorderMC61_commands.CMD_LightRst_EXT,	cockpit_device_id = devices.Recorder_MC61,	value_pressed = -0.2,	name = _('Recorder MC-61 Brightness Knob - CCW/Decrease'),	category = {_('Left Side Panel'), _('Recorder MC-61')}},

-- Ri-65
{combos = {{key = 'A', reformers = {'LShift'}}},	down = RI65_commands.Command_RI_Mi24_Off_EXT,    up = RI65_commands.Command_RI_Mi24_Off_EXT,	cockpit_device_id = devices.VMS,	value_down = 1.0, value_up = 0.0,	name = _('RI-65 OFF Button'),					category = {_('Left Side Panel'), _('RI-65 Panel')}},
{combos = {{key = 'Q', reformers = {'LShift'}}},	down = RI65_commands.Command_RI_Mi24_Repeat_EXT, up = RI65_commands.Command_RI_Mi24_Repeat_EXT,	cockpit_device_id = devices.VMS,	value_down = 1.0, value_up = 0.0,	name = _('RI-65 Repeat Button'),				category = {_('Left Side Panel'), _('RI-65 Panel')}},
{combos = {{key = 'S', reformers = {'LShift'}}},	down = RI65_commands.Command_RI_Mi24_Check_EXT,  up = RI65_commands.Command_RI_Mi24_Check_EXT,	cockpit_device_id = devices.VMS,	value_down = 1.0, value_up = 0.0,	name = _('RI-65 Check Button'),					category = {_('Left Side Panel'), _('RI-65 Panel')}},
-- pilot door:
{combos = {{key = 'C', reformers = {'LCtrl'}}},			 down = cockpit_mechanics_commands.Command_CPT_MECH_Door_EXT, value_down = 1, cockpit_device_id = devices.CPT_MECH, name = _('Open/Close Cockpit Door'),	  category = _('Systems')},
-- left, right cargo doors:
{combos = {{key = 'C', reformers = {'RCtrl','LShift'}}},	down = cockpit_mechanics_commands.Command_CPT_MECH_LeftMainDoor,  value_down = 1,	cockpit_device_id = devices.CPT_MECH,	name = _('Open/Close Left Door'),category = _('Systems')},
{combos = {{key = 'C', reformers = {'RCtrl','RShift'}}},	down = cockpit_mechanics_commands.Command_CPT_MECH_RightMainDoor, value_down = 1,	cockpit_device_id = devices.CPT_MECH,	name = _('Open/Close Right Door'),category = _('Systems')},

-- Anti Ice System
{combos = {{key = 'A', reformers = {'LShift'}}}, 		 down = AntiIceSys_commands.ANTIICE_ManAuto_EXT,   cockpit_device_id = devices.ANTI_ICE_INTERFACE, value_down = 1,	value_up = 0, name = _('AntiIce AUTO/MANUAL'),         		category = _('Right Side Panel')},
{combos = {{key = 'O', reformers = {'LAlt'}}},			 down = AntiIceSys_commands.ANTIICE_Off_EXT, 	   cockpit_device_id = devices.ANTI_ICE_INTERFACE, value_down = 1,	value_up = 0, name = _('AntiIce OFF'),                 		category = _('Right Side Panel')},
{combos = {{key = 'L', reformers = {'RCtrl','LShift'}}}, down = AntiIceSys_commands.ANTIICE_LeftEng_EXT,   cockpit_device_id = devices.ANTI_ICE_INTERFACE, value_down = 1,	value_up = 0, name = _('Left Engine AntiIce ON/OFF'),  		category = _('Right Side Panel')},
{combos = {{key = 'R', reformers = {'RCtrl','RShift'}}}, down = AntiIceSys_commands.ANTIICE_RightEng_EXT,  cockpit_device_id = devices.ANTI_ICE_INTERFACE, value_down = 1,	value_up = 0, name = _('Right Engine AntiIce ON/OFF'), 		category = _('Right Side Panel')},
{combos = {{key = 'W', reformers = {'LShift','RShift'}}},down = AntiIceSys_commands.ANTIICE_GLAZING_P_EXT, cockpit_device_id = devices.ANTI_ICE_INTERFACE, value_down = 1,  value_up = 0, name = _('Windshield Antiice OFF'),			category = _('Right Side Panel')},

{combos = {{key = 'A', reformers = {'LShift'}}}, 		 pressed = AntiIceSys_commands.ANTIICE_Ammeter_EXT,cockpit_device_id = devices.ANTI_ICE_INTERFACE, value_pressed = -0.2, name = _('AC Ammeter knob'), category = _('Right Side Panel')},

-- External Cargo
{combos = {{key = 'L', reformers = {'RCtrl','RShift'}}},		down = iCommandExtCargoHook,																				name = _('External Cargo Hook'),				category = {_('External Cargo')}},
{combos = {{key = 'L', reformers = {'RCtrl','RShift','RAlt'}}},	down = iCommandTacticalCargoUnhook,		up = iCommandTacticalCargoUnhook,	value_down = 1, value_up = 0,	name = _('External Cargo Tactical Unhook'),		category = {_('Ins Collective Stick'), _('External Cargo')}},
{combos = {{key = 'P', reformers = {'RCtrl','RShift','RAlt'}}},	down = iCommandEmergencyCargoUnhook,	up = iCommandEmergencyCargoUnhook,	value_down = 1, value_up = 0,	name = _('External Cargo Emergency Unhook'),	category = {_('Ins Collective Stick'), _('External Cargo')}},

{	down = ext_cargo_equipment_commands.CMD_TacticalReleaseBtn_EXT,			up = ext_cargo_equipment_commands.CMD_TacticalReleaseBtn_EXT,	cockpit_device_id = devices.EXT_CARGO_EQUIPMENT,	value_down = 1.0,	value_up = 0.0,	name = _('Tactical Cargo Release Button'),							category = {_('Ins Collective Stick'), _('External Cargo')}},
{	down = ext_cargo_equipment_commands.CMD_TacticalReleaseBtn_Cover_ITER,																	cockpit_device_id = devices.EXT_CARGO_EQUIPMENT,	value_down = 0,						name = _('Tactical Cargo Release Button Cover - OPEN/CLOSE'),		category = {_('Ins Collective Stick'), _('External Cargo')}},
{	down = ext_cargo_equipment_commands.CMD_TacticalReleaseBtn_Cover_EXT,																	cockpit_device_id = devices.EXT_CARGO_EQUIPMENT,	value_down = 1,						name = _('Tactical Cargo Release Button Cover - OPEN'),				category = {_('Ins Collective Stick'), _('External Cargo')}},
{	down = ext_cargo_equipment_commands.CMD_TacticalReleaseBtn_Cover_EXT,																	cockpit_device_id = devices.EXT_CARGO_EQUIPMENT,	value_down = 0,						name = _('Tactical Cargo Release Button Cover - CLOSE'),			category = {_('Ins Collective Stick'), _('External Cargo')}},
{	down = ext_cargo_equipment_commands.CMD_EmergReleaseBtn_EXT,			up = ext_cargo_equipment_commands.CMD_EmergReleaseBtn_EXT,		cockpit_device_id = devices.EXT_CARGO_EQUIPMENT,	value_down = 1.0,	value_up = 0.0,	name = _('Emergency Cargo Release Button'),							category = {_('Ins Collective Stick'), _('External Cargo')}},
{	down = ext_cargo_equipment_commands.CMD_EmergReleaseBtnCover_ITER,																		cockpit_device_id = devices.EXT_CARGO_EQUIPMENT,	value_down = 0,						name = _('Emergency Cargo Release Button Cover - OPEN/CLOSE'),		category = {_('Ins Collective Stick'), _('External Cargo')}},
{	down = ext_cargo_equipment_commands.CMD_EmergReleaseBtnCover_EXT,																		cockpit_device_id = devices.EXT_CARGO_EQUIPMENT,	value_down = 1,						name = _('Emergency Cargo Release Button Cover - OPEN'),			category = {_('Ins Collective Stick'), _('External Cargo')}},
{	down = ext_cargo_equipment_commands.CMD_EmergReleaseBtnCover_EXT,																		cockpit_device_id = devices.EXT_CARGO_EQUIPMENT,	value_down = 0,						name = _('Emergency Cargo Release Button Cover - CLOSE'),			category = {_('Ins Collective Stick'), _('External Cargo')}},
{	down = ext_cargo_equipment_commands.CMD_AutoReleaseSw_ITER,																				cockpit_device_id = devices.EXT_CARGO_EQUIPMENT,	value_down = 0,						name = _('External Cargo Auto-Release Switch - ON/OFF'),			category = {_('Right Forward Panel'), _('External Cargo')}},
{	down = ext_cargo_equipment_commands.CMD_AutoReleaseSw_EXT,																				cockpit_device_id = devices.EXT_CARGO_EQUIPMENT,	value_down = 1,						name = _('External Cargo Auto-Release Switch - ON'),				category = {_('Right Forward Panel'), _('External Cargo')}},
{	down = ext_cargo_equipment_commands.CMD_AutoReleaseSw_EXT,																				cockpit_device_id = devices.EXT_CARGO_EQUIPMENT,	value_down = 0,						name = _('External Cargo Auto-Release Switch - OFF'),				category = {_('Right Forward Panel'), _('External Cargo')}},
{	down = ext_cargo_equipment_commands.CMD_RemoveRelease_ITER,																				cockpit_device_id = devices.EXT_CARGO_EQUIPMENT,	value_down = 0,						name = _('External Cargo Remove-Release Switch - RELEASE/REMOVE'),	category = {_('Right Forward Panel'), _('External Cargo')}},
{	down = ext_cargo_equipment_commands.CMD_RemoveRelease_EXT,																				cockpit_device_id = devices.EXT_CARGO_EQUIPMENT,	value_down = 1,						name = _('External Cargo Remove-Release Switch - RELEASE'),			category = {_('Right Forward Panel'), _('External Cargo')}},
{	down = ext_cargo_equipment_commands.CMD_RemoveRelease_EXT,																				cockpit_device_id = devices.EXT_CARGO_EQUIPMENT,	value_down = 0,						name = _('External Cargo Remove-Release Switch - REMOVE'),			category = {_('Right Forward Panel'), _('External Cargo')}},

{combos = {{key = 'H', reformers = {'RShift'}}}		   , down    = iCommandViewNightVisionGogglesOn   , name = _('Toggle goggles')   , category = _('NVG')},
{combos = {{key = 'H', reformers = {'RShift','RCtrl'}}}, pressed = iCommandPlane_Helmet_Brightess_Up  , name = _('Gain goggles up')  , category = _('NVG')},
{combos = {{key = 'H', reformers = {'RShift','RAlt'}}} , pressed = iCommandPlane_Helmet_Brightess_Down, name = _('Gain goggles down'), category = _('NVG')}, 


})
return res
