local cockpit = folder.."../../../Cockpit/Scripts/"
dofile(cockpit.."devices.lua")
dofile(cockpit.."command_defs.lua")

local res = external_profile("Config/Input/Aircrafts/common_keyboard_binding.lua")

join(res.keyCommands,{
-- Controls
{combos = {{key = 'Up'}},									down = iCommandPlaneUpStart,	up = iCommandPlaneUpStop,							name = _('Cyclic - Nose Down'),				category = {_('Ins Cyclic Stick'), _('Flight Control')}},
{combos = {{key = 'Down'}},									down = iCommandPlaneDownStart,	up = iCommandPlaneDownStop,							name = _('Cyclic - Nose Up'),				category = {_('Ins Cyclic Stick'), _('Flight Control')}},
{combos = {{key = 'Left'}},									down = iCommandPlaneLeftStart,	up = iCommandPlaneLeftStop,							name = _('Cyclic - Bank Left'),				category = {_('Ins Cyclic Stick'), _('Flight Control')}},
{combos = {{key = 'Right'}},								down = iCommandPlaneRightStart,	up = iCommandPlaneRightStop,						name = _('Cyclic - Bank Right'),			category = {_('Ins Cyclic Stick'), _('Flight Control')}},
{combos = {{key = 'Space', reformers = {'RAlt'}}}, down = iCommandPlanePickleOn,    up = iCommandPlanePickleOff, name = _('Release weapons'), category = {_('Ins Cyclic Stick'), _('Weapon')}},

{combos = {{key = '\\', 	reformers = {'RAlt'}}},			 down = SPU_8_Mi24_commands.CMD_SPU8_TRIGGER_EXT,	up = SPU_8_Mi24_commands.CMD_SPU8_TRIGGER_EXT, cockpit_device_id = devices.SPU_8, value_down = 1.0, value_up = 0.0,		name = _('Radio trigger - RADIO'),			category = {_('Ins Cyclic Stick'), _('Communications')}},
{combos = {{key = 'Space',	reformers = {'RShift'}}},		 down = SPU_8_Mi24_commands.CMD_SPU8_TRIGGER_EXT,	up = SPU_8_Mi24_commands.CMD_SPU8_TRIGGER_EXT, cockpit_device_id = devices.SPU_8, value_down = 0.5, value_up = 0.0,		name = _('Radio trigger - ICS'),			category = {_('Ins Cyclic Stick'), _('Communications')}},

{combos = {{key = 'Num+'}},							down = iCommandPlaneCollectiveIncrease, pressed = iCommandPlaneCollectiveIncrease, up = iCommandPlaneCollectiveStop,				name = _('Collective - Up'),									category = {_('Ins Collective Stick'), _('Flight Control')}},
{combos = {{key = 'Num-'}},							down = iCommandPlaneCollectiveDecrease, pressed = iCommandPlaneCollectiveDecrease, up = iCommandPlaneCollectiveStop,				name = _('Collective - Down'),									category = {_('Ins Collective Stick'), _('Flight Control')}},
{combos = {{key = 'Num+', reformers = {'RAlt'}}},	down = iCommandPlane_ReadjustFreeTurbineRPM_Up,		up = iCommandPlane_ReadjustFreeTurbineRPM_Up,	value_down =  1, value_up = 0,	name = _('Readjust Free Turbine RPM Switch - Increase'),		category = {_('Ins Collective Stick'), _('Engines')}},
{combos = {{key = 'Num-', reformers = {'RAlt'}}},	down = iCommandPlane_ReadjustFreeTurbineRPM_Down,	up = iCommandPlane_ReadjustFreeTurbineRPM_Down,	value_down = -1, value_up = 0,	name = _('Readjust Free Turbine RPM Switch - Decrease'),		category = {_('Ins Collective Stick'), _('Engines')}},
{combos = {{key = 'F'}},							down = iCommandHelicopter_CollectiveStopper_Up,		up = iCommandHelicopter_CollectiveStopper_Down,									name = _('Collective brake - Assign altitude lever'),			category = {_('Ins Collective Stick'), _('Flight Control')}},
{combos = {{key = 'PageUp'}},						down = iCommandThrottleIncrease,	up = iCommandThrottleStop,																		name = _('Correction Lever - Increase'),						category = {_('Ins Collective Stick'), _('Engines')}},
{combos = {{key = 'PageDown'}},						down = iCommandThrottleDecrease,	up = iCommandThrottleStop,																		name = _('Correction Lever - Decrease'),						category = {_('Ins Collective Stick'), _('Engines')}},

{combos = {{key = 'T'}},     								down = iCommandPlaneTrimOn, up = iCommandPlaneTrimOff,																							name = _('Trimmer Button'),					category = {_('Ins Cyclic Stick'), _('Trimmer')}},
{combos = {{key = 'T', reformers = {'LCtrl'}}},				down = iCommandPlaneTrimCancel,																													name = _('Trimmer - Reset'),				category = {_('Ins Cyclic Stick'), _('Trimmer')}},

{combos = {{key = '.', reformers = {'RCtrl'}}},	pressed = iCommandPlaneTrimUp,			up = iCommandPlaneTrimStop, name = _('Trim: Nose Up'),			category = {_('Ins Cyclic Stick'), _('Trimmer')}},
{combos = {{key = ';', reformers = {'RCtrl'}}},	pressed = iCommandPlaneTrimDown,		up = iCommandPlaneTrimStop, name = _('Trim: Nose Down'),		category = {_('Ins Cyclic Stick'), _('Trimmer')}},
{combos = {{key = ',', reformers = {'RCtrl'}}},	pressed = iCommandPlaneTrimLeft,		up = iCommandPlaneTrimStop, name = _('Trim: Left Wing Down'),	category = {_('Ins Cyclic Stick'), _('Trimmer')}},
{combos = {{key = '/', reformers = {'RCtrl'}}},	pressed = iCommandPlaneTrimRight,		up = iCommandPlaneTrimStop, name = _('Trim: Right Wing Down'),	category = {_('Ins Cyclic Stick'), _('Trimmer')}},
--{combos = {{key = 'Z', reformers = {'RCtrl'}}},	pressed = iCommandPlaneTrimLeftRudder,	up = iCommandPlaneTrimStop, name = _('Trim: Rudder Left'),		category = {_('Ins Cyclic Stick'), _('Trimmer')}},
--{combos = {{key = 'X', reformers = {'RCtrl'}}},	pressed = iCommandPlaneTrimRightRudder,	up = iCommandPlaneTrimStop, name = _('Trim: Rudder Right'),		category = {_('Ins Cyclic Stick'), _('Trimmer')}},

-- View Cockpit 

{combos = {{key = '1'}},	down = headwrapper_commands.PilotSeat,	value_down = 1, cockpit_device_id = devices.HEAD_WRAPPER, name = _('Set Pilot Seat'),	category = _('View Cockpit')},
{combos = {{key = '2'}},	down = headwrapper_commands.OpSeat,		value_down = 1, cockpit_device_id = devices.HEAD_WRAPPER, name = _('Set Operator Seat'),	category = _('View Cockpit')},


-- General
{combos = {{key = 'Tab', reformers = {'RCtrl'}}}, down = iCommandFriendlyChat, name = _('Multiplayer chat - mode Allies'), category = _('General')},
{combos = {{key = 'P', reformers = {'RShift'}}}, down = iCommandCockpitShowPilotOnOff, name = _('Show Pilot Body'), category = _('General')},
--{combos = {{key = 'Pause', reformers = {'RShift'}}}, down = iCommandActivePauseOnOff, name = 'Active Pause', category = 'General'},
{combos = {{key = 'S', reformers = {'LCtrl','LShift'}}}, down = iCommandSoundMicOn, name = _('Sound recording start'), category = _('General')},
{combos = {{key = 'X', reformers = {'LCtrl','LShift'}}}, down = iCommandSoundMicOff, name = _('Sound recording stop'), category = _('General')},
{combos = {{key = 'E', reformers = {'RCtrl','RShift'}}}, down = iCommandTrackEditReplace, name = _('Track edit replace mode'), category = _('General')},
{combos = {{key = 'W', reformers = {'RCtrl','RShift'}}}, down = iCommandTrackEditInsert, name = _('Track edit insert mode'), category = _('General')},
{combos = {{key = 'Scroll', reformers = {'RShift'}}}, down = iCommandRecordSubtitleOn, name = _('Subtitle recording begin'), category = _('General')},
{combos = {{key = 'Scroll', reformers = {'RCtrl'}}}, down = iCommandRecordSubtitleOff, name = _('Subtitle recording end'), category = _('General')},
--{combos = {{key = 'Pause', reformers = {'RAlt'}}}, down = iCommandOneFrame, name = 'One frame mode', category = 'General'},

--9K113
{down = i9K113_commands.Command_POWER_PN_Ext, 		cockpit_device_id = devices.I9K113, value_down = 1,		name = _('GUID.UNIT POWER'),						category = {_('9K113')}},
{down = i9K113_commands.Command_9k113_Backlight_Ext, cockpit_device_id = devices.I9K113, value_down = 1,	name = _('LIGHTS (Backlight)'),						category = {_('9K113')}},
{down = i9K113_commands.Command_Heat_O_Ext, 		cockpit_device_id = devices.I9K113, value_down = 1,		name = _('Sight Heating'),						category = {_('9K113')}},

{combos = {{key = 'O', reformers = {'RCtrl'}}}, down = i9K113_commands.Command_NABL_Ext,		cockpit_device_id = devices.I9K113,	value_down =  0.0,	name = _('OBSERVE - OFF'),			category = {_('9K113')}},
{combos = {{key = 'O', reformers = {'RShift'}}},down = i9K113_commands.Command_NABL_Ext,		cockpit_device_id = devices.I9K113,	value_down =  1.0,	name = _('OBSERVE - ON'),			category = {_('9K113')}},
{combos = {{key = 'O'}},						down = i9K113_commands.Command_NABL_Iter,		cockpit_device_id = devices.I9K113,	value_down =  1.0,	name = _('OBSERVE - ON/OFF'),		category = {_('9K113')}},

{combos = {{key = 'A', reformers = {'LAlt'}}}, down = i9K113_commands.Command_Aiming, 		cockpit_device_id = devices.I9K113, 		value_down = 1,	name = _('9K113 aiming profile On/Off'), category = {_('9K113')}},

{down = i9K113_commands.Command_DIAFR_OTKR_Ext, 	cockpit_device_id = devices.I9K113, value_down = 1,		name = _('DIAFR Open'),							category = {_('9K113')}},
{down = i9K113_commands.Command_OTKL_BLOCK_ARU_Ext, cockpit_device_id = devices.I9K113, value_down = 1,		name = _('LOCK ARU'),							category = {_('9K113')}},
{down = i9K113_commands.Command_SSP_VKL_Ext, 		cockpit_device_id = devices.I9K113, value_down = 1,		name = _('SSP On'),								category = {_('9K113')}},
{down = i9K113_commands.Command_GENER_EMIT_Ext, 	cockpit_device_id = devices.I9K113, value_down = 1,		name = _('GENERATOR-IMIT'),						category = {_('9K113')}},
{down = i9K113_commands.Command_KONTR_T1_B9_KONTR_T2_Ext, 		cockpit_device_id = devices.I9K113, value_down = 1,		name = _('CHECK2-NEUTR-CHECK1 Up'),				category = {_('9K113')}},
{down = i9K113_commands.Command_WORK_CONTROL_Ext, 	cockpit_device_id = devices.I9K113, value_down = -1,	name = _('CHECK2-NEUTR-CHECK1 Down'),			category = {_('9K113')}},
{down = i9K113_commands.Command_VHOD_BVK_KV_Ext, 	cockpit_device_id = devices.I9K113, value_down = 1,		name = _('WORK-CHECK'),							category = {_('9K113')}},
{down = i9K113_commands.Command_START_PM_Ext, 		cockpit_device_id = devices.I9K113, value_down = 1,		name = _('Start PM'),							category = {_('9K113')}},
{down = i9K113_commands.Command_VHOD_BVK_KV_Ext, 	cockpit_device_id = devices.I9K113, value_down = 1,		name = _('BVK Set Next'),						category = {_('9K113')}},
{down = i9K113_commands.Command_VHOD_BVK_KV_Ext, 	cockpit_device_id = devices.I9K113, value_down = -1,	name = _('BVK Set Prev'),						category = {_('9K113')}},
{down = i9K113_commands.Command_STVORKI_Ext, 		cockpit_device_id = devices.I9K113, value_down = 1,		name = _('Sight Doors'),						category = {_('9K113')}},
{down = i9K113_commands.Command_HEAT_O_Ext, 		cockpit_device_id = devices.I9K113, value_down = 1,		name = _('Sight Fan'),							category = {_('9K113')}},
{down = i9K113_commands.Command_CHECK_LAMPS_Ext, 	cockpit_device_id = devices.I9K113, value_down = 1,		name = _('Lamps Check'),						category = {_('9K113')}},
{down = i9K113_commands.Command_0_04_Ext, 			cockpit_device_id = devices.I9K113, value_down = 1,		name = _('Switcher 0 - 0.4'),					category = {_('9K113')}},
{down = i9K113_commands.Command_SWITCHER_IN_OUT_Ext, cockpit_device_id = devices.I9K113, value_down = 1,		name = _('Switcher IN-OUT'),					category = {_('9K113')}},
{down = i9K113_commands.Command_COD1_COD2_Ext, 		cockpit_device_id = devices.I9K113, value_down = 1,		name = _('Switcher CODE1-CODE2'),				category = {_('9K113')}},
{down = i9K113_commands.Command_CHECKING_Ext, 		up = i9K113_commands.Button_49, cockpit_device_id = devices.I9K113, value_down = 1, value_up = 0, name = _('Checking'),	category = {_('9K113')}},
{down = i9K113_commands.Command_HIGH_K_Ext, 		up = i9K113_commands.Button_50, cockpit_device_id = devices.I9K113, value_down = 1, value_up = 0, name = _('High K'),	category = {_('9K113')}},
{down = i9K113_commands.Command_TABLO_Ext, 		cockpit_device_id = devices.I9K113, 					name = _('Board Check'),						category = {_('9K113')}},

{down = i9K113_commands.Command_StickPark_Ext, 		cockpit_device_id = devices.I9K113, value_down = 1, name = _('Park/Unpark Operators Stick'), category = {_('Ins Cyclic Stick')}},
{down = i9K113_commands.Command_RadiationReset_Ext, up = i9K113_commands.Command_RadiationReset_Ext,		cockpit_device_id = devices.I9K113, value_down = 1, value_up = 0,	name = _('Radiation Reset'),						category = {_('9K113')}},

{combos = {{key = 'X', reformers = {'LCtrl'}}}, down = i9K113_commands.Command_ZOOM_Ext, cockpit_device_id = devices.I9K113, value_down = 1, name = _('Enlargement x3/x10'),		category = {_('9K113')}},
{combos = {{key = 'O', reformers = {'RAlt'}}}, down = i9K113_commands.Command_OS_Ext, cockpit_device_id = devices.I9K113, value_down = 1,	name = _('Orange Filter On/Off'),		category = {_('9K113')}},
{combos = {{key = 'G', reformers = {'RAlt'}}}, down = i9K113_commands.Command_SES_Ext, cockpit_device_id = devices.I9K113, value_down = 1,	name = _('Laser Filter On/Off'),		category = {_('9K113')}},

{combos = {{key = 'H', reformers = {'LWin'}}}, down = i9K113_commands.Command_Hint_Ext, cockpit_device_id = devices.I9K113, value_down = 1,	name = _('9K113 Hints On/Off'),		category = {_('9K113')}},
{combos = {{key = 'S', reformers = {'LAlt'}}}, down = i9K113_commands.Command_SteeringHelper_Ext, cockpit_device_id = devices.I9K113, value_down = 1,	name = _('9K113 Steering Arrow On/Off'),		category = {_('9K113')}},


{combos = {{key = ';'}}, down = iCommandPlaneRadarUp, 		up = iCommandPlaneRadarUp, 		value_down = 1,	value_up = 0, name = _('9K113 slew up'), category = _('9K113')},
{combos = {{key = '.'}}, down = iCommandPlaneRadarDown, 	up = iCommandPlaneRadarDown, 	value_down = -1,	value_up = 0, name = _('9K113 slew down'), category = _('9K113')},
{combos = {{key = ','}}, down = iCommandPlaneRadarLeft, 	up = iCommandPlaneRadarLeft, 	value_down = -1,	value_up = 0, name = _('9K113 slew left'), category = _('9K113')},
{combos = {{key = '/'}}, down = iCommandPlaneRadarRight, 	up = iCommandPlaneRadarRight, 	value_down = 1,	value_up = 0, name = _('9K113 slew right'), category = _('9K113')},
{combos = {{key = 'I', reformers = {'RCtrl'}}}, down = iCommandPlaneRadarCenter, name = _('9K113 center'), category = _('9K113')},
{combos = {{key = '='}}, down = iCommandPlaneZoomIn, name = _('Zoom In'), category = _('9K113')},
{combos = {{key = '-'}}, down = iCommandPlaneZoomOut, name = _('Zoom Out'), category = _('9K113')},

{combos = {{key = 'Space', reformers = {'RCtrl'}}},	pressed = weapon_commands.Operator_LAUNCH_URS,	up = weapon_commands.Operator_LAUNCH_URS, cockpit_device_id = devices.WEAP_SYS,	value_pressed = 1,	value_up = 0, name = _('Fire Shturm'),	category = {_('Weapon')}},

{down = weapon_commands.SWITCHER_WEAP_TYPE_AB_Ext, 					cockpit_device_id = devices.WEAP_SYS, value_down = 1, 	name = _('Select Weapon Operator Next'),					category = {_('Weapon')}},
{down = weapon_commands.SWITCHER_WEAP_TYPE_AB_Ext, 					cockpit_device_id = devices.WEAP_SYS, value_down = -1, 	name = _('Select Weapon Operator Prev'),					category = {_('Weapon')}},
{down = weapon_commands.EMERG_RELEASE_OPERATOR_Cvr_Ext, 			cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Emergency Jettison Cover, UP/DOWN'),	category = {_('Weapon')}},
{down = weapon_commands.EMERG_RELEASE_OPERATOR_Ext, 				cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Emergency Jettison'),					category = {_('Weapon')}},
{down = weapon_commands.SWITCHER_BOMB_BLOCK_BOMB_Cvr_Ext, 			cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Bombs/Blocks Mode Cover, UP/DOWN'),	category = {_('Weapon')}},
{down = weapon_commands.SWITCHER_BOMB_BLOCK_BOMB_Ext, 				cockpit_device_id = devices.WEAP_SYS, value_down = 1,   name = _('Bombs/Blocks Mode Up'),				category = {_('Weapon')}},
{down = weapon_commands.SWITCHER_BOMB_BLOCK_BOMB_Ext, 				cockpit_device_id = devices.WEAP_SYS, value_down = -1,  name = _('Bombs/Blocks Mode Down'),				category = {_('Weapon')}},
{down = weapon_commands.Operator_EMERG_EXPLODE_OPERATOR_Cvr_Ext,	cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Explosion on Jettison Cover, UP/DOWN'),category = {_('Weapon')}},
{down = weapon_commands.EMERG_EXPLODE_OPERATOR_Ext, 				cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Explosion on Jettison'),				category = {_('Weapon')}},
{down = weapon_commands.CONTROL_On_ME_OPERATOR_Cvr_Up_Ext,			cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Operator Weapon Control Cover, UP'),		category = {_('Weapon')}},
{down = weapon_commands.CONTROL_On_ME_OPERATOR_Cvr_Down_Ext,		cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Operator Weapon Control Cover, DOWN'),		category = {_('Weapon')}},
{down = weapon_commands.SWITCHER_CONTROL_On_ME_OPERATOR_Up_Ext,		cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Operator Weapon Control, UP'),						category = {_('Weapon')}},
{down = weapon_commands.SWITCHER_CONTROL_On_ME_OPERATOR_Down_Ext,	cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Operator Weapon Control, DOWN'),						category = {_('Weapon')}},
{down = weapon_commands.EMERG_RELEASE_PU_OPERATOR_Ext, 				cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Jettison Launcher ON/OFF'),			category = {_('Weapon')}},
{down = weapon_commands.EMERG_RELEASE_PU_OPERATOR_Cvr_Ext,	cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Jettison Launcher Cover, UP/DOWN'),	category = {_('Weapon')}},
{down = weapon_commands.CHAIN_LENGTH_SHORT_MED_LONG_Ext, 			cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Burst Length SHORT/MED/LONG Up'),		category = {_('Weapon')}},
{down = weapon_commands.CHAIN_LENGTH_SHORT_MED_LONG_Ext, 			cockpit_device_id = devices.WEAP_SYS, value_down = -1,	name = _('Burst Length SHORT/MED/LONG Down'),		category = {_('Weapon')}},
{down = weapon_commands.OPERATOR_RATE_MORE_Ext, 			cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Cannon Fire Rate SLOW/FAST'),			category = {_('Weapon')}},
{down = weapon_commands.URS_POWER_Ext, 						cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Missiles Power'),						category = {_('Weapon')}},
{down = weapon_commands.CHECK_RELEASE_PU_Ext, 				cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Release Check PU'),					category = {_('Weapon')}},
{down = weapon_commands.CHECK1_WORK_CHECK2_Ext, 			cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('CHECK1-WORK-CHECK2 Next'),			category = {_('Weapon')}},
{down = weapon_commands.CHECK1_WORK_CHECK2_Ext, 			cockpit_device_id = devices.WEAP_SYS, value_down = -1,	name = _('CHECK1-WORK-CHECK2 Prev'),			category = {_('Weapon')}},
{down = weapon_commands.RELOAD_NPU30_Ext, up = weapon_commands.RELOAD_NPU30_Ext, cockpit_device_id = devices.WEAP_SYS, value_down = 1, value_up = 0, name = _('Reload Cannon'),	category = {_('Weapon')}},
{down = weapon_commands.POWER_SHO_SWITCHER_Ext, 			cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('SCHO Power'),							category = {_('Weapon')}},
{down = weapon_commands.CHECK_LAMPS_9C475_Ext, 				cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('SCHO Lamps Check'),					category = {_('Weapon')}},
{down = weapon_commands.SWITCHER_LAUNCH_STATION_Ext, 		cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Select Station Next'),				category = {_('Weapon')}},
{down = weapon_commands.SWITCHER_LAUNCH_STATION_Ext, 		cockpit_device_id = devices.WEAP_SYS, value_down = -1,	name = _('Select Station Prev'),				category = {_('Weapon')}},

{down = weapon_commands.Operator_START_KMG_Ext, 			cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Start container'),						category = {_('Weapon')}},
{down = weapon_commands.Operator_STOP_KMG_Ext, 				cockpit_device_id = devices.WEAP_SYS, value_down = 1,	name = _('Stop container Operator'),						category = {_('Weapon')}},


--ASO-2V
{down = avASO_2V_commands.ASO_2V_Release_Ext, 		up = avASO_2V_commands.ASO_2V_Release_Ext, 			cockpit_device_id = devices.ASO_2V, value_down = 1, value_up = 0,	name = _('Launch Countermeasures'),			category = {_('ASO-2V')}},
{down = avASO_2V_commands.ASO_2V_Left_Ext, 			cockpit_device_id = devices.ASO_2V, value_down = 1, name = _('Left Side'),			category = {_('ASO-2V')}},
{down = avASO_2V_commands.ASO_2V_Right_Ext, 		cockpit_device_id = devices.ASO_2V, value_down = 1, name = _('Right Side'),			category = {_('ASO-2V')}},
{down = avASO_2V_commands.ASO_2V_Set_I_II_III_Ext, 	cockpit_device_id = devices.ASO_2V, value_down = 1,	name = _('Set I/II/III'),		category = {_('ASO-2V')}},
{down = avASO_2V_commands.ASO_2V_Interval_2_4_Ext, 	cockpit_device_id = devices.ASO_2V, value_down = 1, name = _('Interval'),			category = {_('ASO-2V')}},
{down = avASO_2V_commands.ASO_2V_Series_4_16_Ext, 	cockpit_device_id = devices.ASO_2V, value_down = 1, name = _('Serie'),				category = {_('ASO-2V')}},

--Helper AI
{combos = {{key = 'V', reformers = {'LCtrl'}}},	up = helperai_commands.ShowMenu, 	down = helperai_commands.ShowMenu, 	cockpit_device_id = devices.HELPER_AI, value_up = 0, value_down = 1,	name = _('Show/Hide Menu'),	category = {_('Helper AI Commands')}},
{combos = {{key = 'C'}}, up = helperai_commands.HeliControlEXT, down = helperai_commands.HeliControlEXT,	cockpit_device_id = devices.HELPER_AI, 	value_up = 0, value_down = 1,	name = _('Request Aircraft Control'),	category = {_('Helper AI Commands'), _('Multicrew')}},

--InternalLightSystem
{																				down = int_lights_commands.RedLightsOperatorPanel_1_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.0,                       name = _('Transformer 1 Group Of Red Lights Left And Operator Panel - OFF'),			category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_1_EXT,	                                                             							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.1,                       name = _('Transformer 1 Group Of Red Lights Left And Operator Panel - 8V'),				category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_1_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.2,                     	name = _('Transformer 1 Group Of Red Lights Left And Operator Panel - 9V'),				category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_1_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.3,                       name = _('Transformer 1 Group Of Red Lights Left And Operator Panel - 10V'),			category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_1_EXT,	                                                             							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.4,                       name = _('Transformer 1 Group Of Red Lights Left And Operator Panel - 11V'),			category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_1_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.5,                     	name = _('Transformer 1 Group Of Red Lights Left And Operator Panel - 12V'),			category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_1_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.6,                       name = _('Transformer 1 Group Of Red Lights Left And Operator Panel - 13V'),			category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_1_EXT,	                                                             							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.7,                       name = _('Transformer 1 Group Of Red Lights Left And Operator Panel - 14V'),			category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_1_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.8,                     	name = _('Transformer 1 Group Of Red Lights Left And Operator Panel - 16V'),			category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_1_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.9,                       name = _('Transformer 1 Group Of Red Lights Left And Operator Panel - 18V'),			category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_1_EXT,	                                                             							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1.0,                       name = _('Transformer 1 Group Of Red Lights Left And Operator Panel - 20V'),			category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_1_ITER,                                                                							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1,                        	name = _('Transformer 1 Group Of Red Lights Left And Operator Panel - CYCLE(UP)'),		category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_1_ITER,                                                                							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = -1,                       	name = _('Transformer 1 Group Of Red Lights Left And Operator Panel - CYCLE(DOWN)'),	category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_2_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.0,                       name = _('Transformer 2 Group Of Red Lights Left And Operator Panel - OFF'),			category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_2_EXT,	                                                             							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.1,                       name = _('Transformer 2 Group Of Red Lights Left And Operator Panel - 8V'),				category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_2_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.2,                     	name = _('Transformer 2 Group Of Red Lights Left And Operator Panel - 9V'),				category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_2_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.3,                       name = _('Transformer 2 Group Of Red Lights Left And Operator Panel - 10V'),			category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_2_EXT,	                                                             							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.4,                       name = _('Transformer 2 Group Of Red Lights Left And Operator Panel - 11V'),			category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_2_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.5,                     	name = _('Transformer 2 Group Of Red Lights Left And Operator Panel - 12V'),			category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_2_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.6,                       name = _('Transformer 2 Group Of Red Lights Left And Operator Panel - 13V'),			category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_2_EXT,	                                                             							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.7,                       name = _('Transformer 2 Group Of Red Lights Left And Operator Panel - 14V'),			category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_2_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.8,                     	name = _('Transformer 2 Group Of Red Lights Left And Operator Panel - 16V'),			category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_2_EXT,                                                                 							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0.9,                       name = _('Transformer 2 Group Of Red Lights Left And Operator Panel - 18V'),			category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_2_EXT,	                                                             							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1.0,                       name = _('Transformer 2 Group Of Red Lights Left And Operator Panel - 20V'),			category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_2_ITER,                                                                							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1,                        	name = _('Transformer 2 Group Of Red Lights Left And Operator Panel - CYCLE(UP)'),		category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.RedLightsOperatorPanel_2_ITER,                                                                							cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = -1,                       	name = _('Transformer 2 Group Of Red Lights Left And Operator Panel - CYCLE(DOWN)'),	category = {_('Left Instrument Panel')}},
{																				down = int_lights_commands.OperatorPanelRedLights_EXT,                                                                 								cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1,                        	name = _('Operator Panel Lights Switch - ON'),											category = {_('Front Instrument Panel')}},
{																				down = int_lights_commands.OperatorPanelRedLights_EXT,	                                                             								cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 0,                        	name = _('Operator Panel Lights Switch - OFF'),											category = {_('Front Instrument Panel')}},
{																				down = int_lights_commands.OperatorPanelRedLights_ITER,                                                                								cockpit_device_id = devices.INT_LIGHTS_SYSTEM,			value_down = 1,                        	name = _('Operator Panel Lights Switch - ON/OFF'),										category = {_('Front Instrument Panel')}},

--ExternalLightSystem
{																				down = ext_lights_commands.TaxiLight_EXT,                  				                                           									cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,                     	name = _('Taxi Light Control Switch - ON'),												category = {_('Left Instrument Panel')}},
{																				down = ext_lights_commands.TaxiLight_EXT,	                				                                            							cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 0,                     	name = _('Taxi Light Control Switch - OFF'),											category = {_('Left Instrument Panel')}},
{																				down = ext_lights_commands.TaxiLight_ITER,                 				                                           									cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,                     	name = _('Taxi Light Control Switch - ON/OFF'),											category = {_('Left Instrument Panel')}},
{																				down = ext_lights_commands.SpotToMyself_EXT,                  				                                           								cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,                     	name = _('Spot To Myself Switch - ON'),													category = {_('Operator Instrument Panel')}},
{																				down = ext_lights_commands.SpotToMyself_EXT,	                				                                            						cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 0,                     	name = _('Spot To Myself Switch - OFF'),												category = {_('Operator Instrument Panel')}},
{																				down = ext_lights_commands.SpotToMyself_ITER,                 				                                           								cockpit_device_id = devices.EXT_LIGHTS_SYSTEM,			value_down = 1,                     	name = _('Spot To Myself Switch - ON/OFF'),												category = {_('Operator Instrument Panel')}},

{combos = {{key = '7', reformers = {'RShift'}}},	down = ext_lights_commands.HeadLightOperatorControl_EXT, up = ext_lights_commands.HeadLightOperatorControl_EXT,	cockpit_device_id = devices.EXT_LIGHTS_SYSTEM, value_down = 0.2, value_up = 0,	name = _('Operator Headlight - Down'),	category = {_('Ins Collective Stick'), _('External Lights')}},
{combos = {{key = '8', reformers = {'RShift'}}},	down = ext_lights_commands.HeadLightOperatorControl_EXT, up = ext_lights_commands.HeadLightOperatorControl_EXT,	cockpit_device_id = devices.EXT_LIGHTS_SYSTEM, value_down = 0.1, value_up = 0,	name = _('Operator Headlight - Up'),	category = {_('Ins Collective Stick'), _('External Lights')}},
{combos = {{key = '9', reformers = {'RShift'}}},	down = ext_lights_commands.HeadLightOperatorControl_EXT, up = ext_lights_commands.HeadLightOperatorControl_EXT,	cockpit_device_id = devices.EXT_LIGHTS_SYSTEM, value_down = 0.3, value_up = 0,	name = _('Operator Headlight - Left'),	category = {_('Ins Collective Stick'), _('External Lights')}},
{combos = {{key = '0', reformers = {'RShift'}}},	down = ext_lights_commands.HeadLightOperatorControl_EXT, up = ext_lights_commands.HeadLightOperatorControl_EXT,	cockpit_device_id = devices.EXT_LIGHTS_SYSTEM, value_down = 0.4, value_up = 0,	name = _('Operator Headlight - Right'),	category = {_('Ins Collective Stick'), _('External Lights')}},

-- Barometric Altimeter Operator
{combos = {{key = 'B', reformers = {'RCtrl'}}},									pressed = baroaltimeter_commands.CMD_ADJUST_PRESSURE_EXT, 																							cockpit_device_id = devices.BAROALT_O, 					value_pressed = 1,						name = _('Baro Pressure Operator Knob - CW'),													category = {_('Front Instrument Panel')}},
{combos = {{key = 'B', reformers = {'RShift'}}},								pressed = baroaltimeter_commands.CMD_ADJUST_PRESSURE_EXT, 																							cockpit_device_id = devices.BAROALT_O, 					value_pressed = -1,						name = _('Baro Pressure Operator Knob - CCW'),													category = {_('Front Instrument Panel')}},

--PKP72M_interface
{combos = {{key = 'E', reformers = {'LCtrl','LShift','LAlt'}}},					down = pkp72m_interface_commands.PKP72MoperatorSwitch_EXT,                                                                 							cockpit_device_id = devices.PKP72M_INTERFACE,			value_down = 1,                        	name = _('ADI Switch - ON'),															category = {_('Front Instrument Panel')}},
{combos = {{key = 'D', reformers = {'LCtrl','LShift','LAlt'}}},					down = pkp72m_interface_commands.PKP72MoperatorSwitch_EXT,	                                                             							cockpit_device_id = devices.PKP72M_INTERFACE,			value_down = 0,                        	name = _('ADI Switch - OFF'),															category = {_('Front Instrument Panel')}},
{																				down = pkp72m_interface_commands.PKP72MoperatorSwitch_ITER,																							cockpit_device_id = devices.PKP72M_INTERFACE,			value_down = 1,							name = _('ADI Switch - ON/OFF'),														category = {_('Front Instrument Panel')}},

-- RMI2 Operator
{																				down = rmi2_commands.MODE_LEFTSW_EXT,                  				                                           										cockpit_device_id = devices.RMI2_O,						value_down = 1,                     	name = _('Mode Switch Operator -  '),															category = {_('Front Instrument Panel')}},
{																				down = rmi2_commands.MODE_LEFTSW_EXT,	                				                                            								cockpit_device_id = devices.RMI2_O,						value_down = 0,                     	name = _('Mode Switch Operator - ARK1'),															category = {_('Front Instrument Panel')}},
{																				down = rmi2_commands.MODE_LEFTSW_ITER,                 				                                           										cockpit_device_id = devices.RMI2_O,						value_down = 1,                     	name = _('Mode Switch Operator -  /ARK1'),														category = {_('Front Instrument Panel')}},
{																				down = rmi2_commands.MODE_RIGHTSW_EXT,                  				                                           									cockpit_device_id = devices.RMI2_O,						value_down = 1,                     	name = _('Mode Switch Operator - ZK'),															category = {_('Front Instrument Panel')}},
{																				down = rmi2_commands.MODE_RIGHTSW_EXT,	                				                                            								cockpit_device_id = devices.RMI2_O,						value_down = 0,                     	name = _('Mode Switch Operator - ARKU2'),														category = {_('Front Instrument Panel')}},
{																				down = rmi2_commands.MODE_RIGHTSW_ITER,                 				                                           									cockpit_device_id = devices.RMI2_O,						value_down = 1,                     	name = _('Mode Switch Operator - ZK/ARKU2'),														category = {_('Front Instrument Panel')}},

-- Clock
{combos = {{key = 'C', reformers = {'RCtrl','RShift','RAlt'}}},					down = iCommandMechClock_LeftLever_Down, up = iCommandMechClock_LeftLever_Down_up,			name = _('Clock Left Knob - Push'),				category = {_('Instrument Panel')}},
{combos = {{key = 'M', reformers = {'RShift'}}},								down = iCommandMechClock_LeftLever_Up,														name = _('Clock Left Knob - Pull'),				category = {_('Instrument Panel')}},
{combos = {{key = '.', reformers = {'LAlt'}}},									pressed = iCommandMechClock_LeftLever_TurnRight,											name = _('Clock Left Knob - Rotate right'),		category = {_('Instrument Panel')}},
{combos = {{key = ',', reformers = {'LAlt'}}},									pressed = iCommandMechClock_LeftLever_TurnLeft,												name = _('Clock Left Knob - Rotate left'),		category = {_('Instrument Panel')}},
{combos = {{key = 'C', reformers = {'RShift','RAlt'}}},							down = iCommandMechClock_RightLever_Down, up = iCommandMechClock_RightLever_Down_up,		name = _('Clock Right Knob - Push'),			category = {_('Instrument Panel')}},
{combos = {{key = ',', reformers = {'RCtrl','RShift'}}},						down = iCommandMechClock_RightLever_Rotate_left,											name = _('Clock Right Knob - Rotate left'),		category = {_('Instrument Panel')}},
{combos = {{key = '.', reformers = {'RCtrl','RShift'}}},						down = iCommandMechClock_RightLever_Rotate_right,											name = _('Clock Right Knob - Rotate right'),	category = {_('Instrument Panel')}},

-- operator canopy:
{combos = {{key = 'C', reformers = {'LCtrl'}}},	down = cockpit_mechanics_commands.Command_CPT_MECH_Door_EXT,         value_down = 1, cockpit_device_id = devices.CPT_MECH, name = _('Open/Close Operator Canopy'), category = _('Systems')},
-- Intercom Panels -----------------------------
------------------------------------------------
{combos = {{key = 'Q', reformers = {'LAlt','LShift'}}},	pressed = SPU_8_Mi24_commands.CMD_SPU8_MAIN_VOLUME_EXT,	value_pressed = -0.2,	cockpit_device_id = devices.SPU_8,	name = _('SPU-8 Main Volume Knob - CCW/Decrease'),			category = {_('SPU-8 Intercom Panels')}},
{combos = {{key = 'Q', reformers = {'LAlt','LCtrl'}}},	pressed = SPU_8_Mi24_commands.CMD_SPU8_MAIN_VOLUME_EXT,	value_pressed = 0.2,	cockpit_device_id = devices.SPU_8,	name = _('SPU-8 Main Volume Knob - CW/Increase'),			category = {_('SPU-8 Intercom Panels')}},
{combos = {{key = 'W', reformers = {'LAlt','LShift'}}},	pressed = SPU_8_Mi24_commands.CMD_SPU8_RADIO_VOLUME_EXT,value_pressed = -0.2,	cockpit_device_id = devices.SPU_8,	name = _('SPU-8 Listening Volume Knob - CCW/Decrease'),		category = {_('SPU-8 Intercom Panels')}},
{combos = {{key = 'W', reformers = {'LAlt','LCtrl'}}},	pressed = SPU_8_Mi24_commands.CMD_SPU8_RADIO_VOLUME_EXT,value_pressed = 0.2,	cockpit_device_id = devices.SPU_8,	name = _('SPU-8 Listening Volume Knob - CW/Increase'),		category = {_('SPU-8 Intercom Panels')}},
{combos = {{key = 'E', reformers = {'LAlt','LShift'}}},	down = SPU_8_Mi24_commands.CMD_SPU8_MODE_EXT,			value_down = -1,		cockpit_device_id = devices.SPU_8,	name = _('SPU-8 Radio Source Select Rotary - CCW/Left'),	category = {_('SPU-8 Intercom Panels')}},
{combos = {{key = 'E', reformers = {'LAlt','LCtrl'}}},	down = SPU_8_Mi24_commands.CMD_SPU8_MODE_EXT,			value_down = 1,			cockpit_device_id = devices.SPU_8,	name = _('SPU-8 Radio Source Select Rotary - CW/Right'),	category = {_('SPU-8 Intercom Panels')}},
{combos = {{key = 'Z', reformers = {'LAlt','LCtrl'}}},	down = SPU_8_Mi24_commands.CMD_SPU8_ICS_RADIO_EXT,		value_down = 1,			cockpit_device_id = devices.SPU_8,	name = _('SPU-8 Mode Switch - RADIO/ICS'),					category = {_('SPU-8 Intercom Panels')}},	
{combos = {{key = 'L', reformers = {'LAlt','LCtrl'}}},	down = SPU_8_Mi24_commands.CMD_SPU8_O_ICS_EXT,			value_down = 1,			cockpit_device_id = devices.SPU_8,	name = _('SPU-8 Switch - ICS/OFF'),							category = {_('SPU-8 Intercom Panels')}},

-- Anti Ice System
{combos = {{key = 'W', reformers = {'LShift','RShift'}}},down = AntiIceSys_commands.ANTIICE_GLAZING_O_EXT, cockpit_device_id = devices.ANTI_ICE_INTERFACE, value_down = 1,  value_up = 0, name = _('Windshield Antiice OFF'),			category = _('Left Side Operator Panel')},


{combos = {{key = 'H', reformers = {'RShift'}}}		   , down    = iCommandViewNightVisionGogglesOn   , name = _('Toggle goggles')   , category = _('NVG')},
{combos = {{key = 'H', reformers = {'RShift','RCtrl'}}}, pressed = iCommandPlane_Helmet_Brightess_Up  , name = _('Gain goggles up')  , category = _('NVG')},
{combos = {{key = 'H', reformers = {'RShift','RAlt'}}} , pressed = iCommandPlane_Helmet_Brightess_Down, name = _('Gain goggles down'), category = _('NVG')}, 

})
return res
