
MIG23ML =  {
      
		Name 			= 'MIG23ML',--AG
		DisplayName		= _('MiG-23ML AI'),--AG
        Picture 		= "MIG23ML.png",
        Rate 			= "50",	
        WorldID			=  1, --WSTYPE_PLACEHOLDER
        Shape			= "MIG23ML",--AG
        
	shape_table_data 	= 
	{
		{
			file  	 	= 'MIG23ML';--AG
			life  	 	= 15; -- lifebar
			vis   	 	= 3; -- visibility gain.
			desrt    	= 'f-4e-oblomok'; -- Name of destroyed object file name
			fire  	 	= { 300, 2}; 			-- Fire on the ground after destoyed: 300sec 2m
			username	= 'MIG23ML';--AG
			index       =  1;
			classname   = "lLandPlane";
			positioning = "BYNORMAL";
		},
		{
			name  		= "f-4e-oblomok";
			file  		= "f-4e-oblomok";
			fire  		= { 240, 2};
		},
	},
	
	LandRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of LandRWCategories
        TakeOffRWCategories = 
        {
        [1] = 
        {
			Name = "AircraftCarrier",
        },
        [2] = 
        {
            Name = "AircraftCarrier With Catapult",
        }, 
        [3] = 
        {
            Name = "AircraftCarrier With Tramplin",
        }, 
    }, -- end of TakeOffRWCategories
	
	mapclasskey 		= "P0091000024",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Fighter, 1, "Fighters", "Refuelable", "Datalink", "Link16"},
	Categories= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},
	
		M_empty						=	10550,	-- kg  with pilot and nose load, F15
		M_nominal					=	14350,	-- kg (Empty Plus Full Internal Fuel)
		M_max						=	17800,	-- kg (Maximum Take Off Weight)
		M_fuel_max					=	3800,	-- kg (Internal Fuel Only)
		H_max						=	18500,	-- m  (Maximum Operational Ceiling)
		average_fuel_consumption	=	0.337,
		CAS_min						=	58,		-- Minimum CAS speed (m/s) (for AI)
		V_opt						=	220,	-- Cruise speed (m/s) (for AI)
		V_take_off					=	61,		-- Take off speed in m/s (for AI)
		V_land						=	71,		-- Land speed in m/s (for AI)
		has_afteburner				=	true,
		has_speedbrake				=	true,
		radar_can_see_ground		=	true,
		input_profile_entry = 	"MIG23ML",

		nose_gear_pos 				                = {4.647, -2.33, 0},   -- nosegear coord 
	    nose_gear_amortizer_direct_stroke   		=  0,  -- down from nose_gear_pos !!!
	    nose_gear_amortizer_reversal_stroke  		=  0,  -- up 
	    nose_gear_amortizer_normal_weight_stroke 	=  0,   -- up 
	    nose_gear_wheel_diameter 	                =  0.541, -- in m
	
	    main_gear_pos 						 	    = {-1.41, -2.139, 1.391}, -- main gear coords 
	    main_gear_amortizer_direct_stroke	 	    =   0, --  down from main_gear_pos !!!
	    main_gear_amortizer_reversal_stroke  	    =   0, --  up 
	    main_gear_amortizer_normal_weight_stroke    =   0,-- down from main_gear_pos
	    main_gear_wheel_diameter 				    =   0.86, -- in m

		AOA_take_off				=	0.16,	-- AoA in take off (for AI)
		stores_number				=	7,
		bank_angle_max				=	60,		-- Max bank angle (for AI)
		Ny_min						=	-3,		-- Min G (for AI)
		Ny_max						=	8,		-- Max G (for AI)
		V_max_sea_level				=	423,	-- Max speed at sea level in m/s (for AI)
		V_max_h						=	736.11,	-- Max speed at max altitude in m/s (for AI)
		wing_area					=	34.2,	-- wing area in m2
		thrust_sum_max				=	7036,	-- thrust in kgf (64.3 kN)
		thrust_sum_ab				=	11500,	-- thrust in kgf (95.1 kN)
		Vy_max						=	275,	-- Max climb speed in m/s (for AI)
		flaps_maneuver				=	1,
		Mach_max					=	2.5,	-- Max speed in Mach (for AI)
		range						=	2140,	-- Max range in km (for AI)
		RCS							=	4,		-- Radar Cross Section m2
		Ny_max_e					=	8,		-- Max G (for AI)
		detection_range_max			=	120,
		IR_emission_coeff			=	0.68,	-- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
		IR_emission_coeff_ab		=	3,		-- With afterburner
		tand_gear_max				=	3.73,--XX  1.732 FA18 3.73, 
		tanker_type					=	0,--F14=2/S33=4/ M29=0/S27=0/F15=1/ F16=1/To=0/F18=2/A10A=1/ M29K=4/F4=0/
		wing_span					=	14.05,--XX  wing spain in m
		wing_type 					= 	1,-- 0=FIXED_WING/ 1=VARIABLE_GEOMETRY/ 2=FOLDED_WING/ 3=ARIABLE_GEOMETRY_FOLDED
		length						=	15.73,
		height						=	5.73,
		crew_size					=	1, --XX
		engines_count				=	1, --XX
		wing_tip_pos 				= 	{-2.466, 0.115, 7.107},
		
		--EPLRS 						= true,--?
		TACAN_AA					= true,--?
		launch_bar_connected_arg_value	= 0.815,--0.885,--0.745
		
		mechanimations = {
        Door0 = {
            {Transition = {"Close", "Open"},  Sequence = {{C = {{"Arg", 38, "to", 0.9, "in", 9.0},},},}, Flags = {"Reversible"},},
            {Transition = {"Open", "Close"},  Sequence = {{C = {{"Arg", 38, "to", 0.0, "in", 6.0},},},}, Flags = {"Reversible", "StepsBackwards"},},
            {Transition = {"Any", "Bailout"}, Sequence = {{C = {{"JettisonCanopy", 0},},},},},
        },
        FoldableWings = {
            {Transition = {"Retract", "Extend"}, Sequence = {{C = {{"Arg", 8, "to", 0.0, "in", 5.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Extend", "Retract"}, Sequence = {{C = {{"Arg", 8, "to", 1.0, "in", 5.0}}}}, Flags = {"Reversible", "StepsBackwards"}},
        },
		ServiceHatches = {--Parkposition
            {Transition = {"Close", "Open"}, Sequence = {{C = {{"PosType", 3}, {"Sleep", "for", 30.0}}}, {C = {{"Arg", 24, "set", 1.0}}}}},
            {Transition = {"Open", "Close"}, Sequence = {{C = {{"PosType", 6}, {"Sleep", "for", 5.0}}}, {C = {{"Arg", 24, "set", 0.0}}}}},
        },
        LaunchBar = {
            {Transition = {"Retract", "Extend"}, Sequence = {{C = {{"ChangeDriveTo", "HydraulicGravityAssisted"}, {"VelType", 3}, {"Arg", 85, "to", 0.881, "in", 4.4}}}}},
            {Transition = {"Retract", "Stage"},  Sequence = {{C = {{"ChangeDriveTo", "HydraulicGravityAssisted"}, {"VelType", 3}, {"Arg", 85, "to", 0.815, "in", 4.4}}}}},
			{Transition = {"Any", "Retract"},  Sequence = {{C = {{"ChangeDriveTo", "Hydraulic"}, {"VelType", 2}, {"Arg", 85, "to", 0.000, "in", 4.5}}}}},
            {Transition = {"Extend", "Stage"},   Sequence = {
                    {C = {{"ChangeDriveTo", "Mechanical"}, {"Sleep", "for", 0.000}}},
                    {C = {{"Arg", 85, "from", 0.881, "to", 0.766, "in", 0.600}}},
                    {C = {{"Arg", 85, "from", 0.766, "to", 0.753, "in", 0.300}}},
                    {C = {{"Sleep", "for", 0.45}}},
                    {C = {{"Arg", 85, "from", 0.753, "to", 0.784, "in", 0.1, "sign", 2}}},
                    {C = {{"Arg", 85, "from", 0.784, "to", 0.881, "in", 1.0}}},
                },
            },
			{Transition = {"Stage", "Pull"},  Sequence = {
					{C = {{"ChangeDriveTo", "Mechanical"}, {"VelType", 2}, {"Arg", 85,"from", 0.881, "to", launch_bar_connected_arg_value_, "in", 0.15}}},
					{C = {{"ChangeDriveTo", "Mechanical"}, {"VelType", 2}, {"Arg", 85, "to", 0.78, "speed", 0.1}}},
					{C = {{"ChangeDriveTo", "Mechanical"}, {"VelType", 2}, {"Arg", 85, "to", 0.7792, "speed", 0.02}}},
					}
			},
            {Transition = {"Stage", "Extend"},   Sequence = {{C = {{"ChangeDriveTo", "HydraulicGravityAssisted"}, {"VelType", 3}, {"Arg", 85, "from", 0.815, "to", 0.881, "in", 0.2}}}}},
        },
    }, -- end of mechanimations
		
		engines_nozzles = 
		{
			[1] = 
			{
				pos = 	{-7.548, -0.248, 0},
				elevation	=	0,--3.7
				diameter	=	1.18,--0.965
				exhaust_length_ab	=	5.9,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.5, 
				afterburner_effect_texture = "afterburner_f-16c",
			}, -- end of [1]
		}, -- end of engines_nozzles
		crew_members = 
		{
			[1] = 
			{
				ejection_seat_name	=	9,
				drop_canopy_name	=	41,
				pos = 	{4.207, -0.321, 0},
			}, -- end of [1]
		}, -- end of crew_members
		brakeshute_name	=	4,
		is_tanker	=	false,
		air_refuel_receptacle_pos = 	{0,	0,	0},
		fires_pos = 
		{
			[1] = 	{-0.664,	-0.496,	0},
			[2] = 	{0.173,	-0.307,	1.511},
			[3] = 	{0.173,	-0.307,	-1.511},
			[4] = 	{-0.82,	0.265,	1.774},
			[5] = 	{-0.82,	0.265,	-1.774},
			[6] = 	{-0.82,	0.255,	2.274},
			[7] = 	{-0.82,	0.255,	-2.274},
			[8] = 	{-6.899,	-0.212,	0.611},
			[9] = 	{-6.899,	-0.212,	-0.611},
			[10] = 	{-0.896,	1.118,	0},
			[11] = 	{0.445,	-0.436,	0},
		}, -- end of fires_pos
		
		effects_presets = {
			{effect = "OVERWING_VAPOR", file = current_mod_path.."/Effects/MIG23ML_overwingVapor.lua"},
		},
		
		chaff_flare_dispenser = 
		{
			[1] = 
			{
				dir = 	{0,	1,	0.3},
				pos = 	{-8.5, 0.5, 0},
			}, -- end of [1]
			[2] = 
			{
				dir = 	{0,	1,	-0.3},
				pos = 	{-8.5, 0.5, 0},
			}, -- end of [2]
		}, -- end of chaff_flare_dispenser

        -- Countermeasures
passivCounterm 		= {
CMDS_Edit 			= true,
SingleChargeTotal 	= 96,
chaff 				= {default = 48, increment = 16, chargeSz = 1},
flare 				= {default = 48, increment = 16, chargeSz = 1}
 },
	
	
        CanopyGeometry 	= {
            azimuth 	= {-145.0, 145.0},-- pilot view horizontal (AI)
            elevation 	= {-50.0, 90.0}-- pilot view vertical (AI)
        },

Sensors = {
RADAR 	= "N-008",--Mig23
IRST 	= "TP-23M",--Mig23
RWR 	= "Abstract RWR"--F15
},
Countermeasures = {
--ECM 			= "AN/ALQ-135"--F15
},
	Failures = {
			{ id = 'asc', 		label = _('ASC'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'autopilot', label = _('AUTOPILOT'), enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hydro',  	label = _('HYDRO'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'l_engine',  label = _('L-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'r_engine',  label = _('R-ENGINE'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'radar',  	label = _('RADAR'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		  --{ id = 'eos',  		label = _('EOS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
		  --{ id = 'helmet',  	label = _('HELMET'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mlws',  	label = _('MLWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'rws',  		label = _('RWS'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'ecm',   	label = _('ECM'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'hud',  		label = _('HUD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'mfd',  		label = _('MFD'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },		
	},
	HumanRadio = {
		frequency 		= 127.5,  -- Radio Freq
		editable 		= true,
		minFrequency	= 100.000,
		maxFrequency 	= 156.000,
		modulation 		= MODULATION_AM
	},

Guns = {gun_mount("M_61", { count = 320 },{muzzle_pos = {3.11, -1.2, 0}}),--3.906000, 0.768000, -0.975000
},

pylons_enumeration = {1, 5, 2, 4, 3},

	Pylons =     {

        pylon(1, 1, 0, -0.124, -1.554,
            {
                --
            },
            {
			    --{ CLSID	= "{apu60-mig23ml-r24r}", attach_point_position = {0.8, -0.18 ,0.0} }, -- R-23R
			    --{ CLSID	= "{apu60-mig23ml-r24t}", attach_point_position = {0.8, -0.18 ,0.0} }, -- R-23T
			    { CLSID	= "{mig23ml-r24r}" }, -- R-23R
			    { CLSID	= "{mig23ml-r24r2}" }, -- R-24R
			    { CLSID	= "{mig23ml-r24t}" }, -- R-23T
			    { CLSID	= "{mig23ml-r24t2}" }, -- R-24T
			    { CLSID	= "{FAB_250_M62}" }, --FAB250M62
			    { CLSID	= "{37DCC01E-9E02-432F-B61D-10C166CA2798}" }, --FAB500
			    { CLSID	= "{RBK_250_275_AO_1SCH}" }, --RBK250
			    { CLSID	= "{UB-16_S5M}" }, --UB16
			    { CLSID	= "{UB-32_S5M}" }, --UB32
			    { CLSID	= "{S-24B}" }, --S24
            }
        ),
		pylon(2, 0, 1.055, -1.071, -0.328,
            {
                --
            },
            {
			    { CLSID	= "{APU-60-1_R_60M}" }, --R60x1
			    { CLSID	= "{R-60M 2L}" }, --R60x2
			    { CLSID	= "{FAB_250_M62}" }, --FAB250M62
			    { CLSID	= "{RBK_250_275_AO_1SCH}" }, --RBK250
			    { CLSID	= "{UB-16_S5M}" }, --UB16
			    { CLSID	= "{S-24B}" }, --S24
            }
        ),
        pylon(3, 0, -0.308, -1.151, 0,
            {
                --
            },
            {
 			    { CLSID	= "{PTB_490_MIG21}", attach_point_position = {-0.1, 0.1 ,0.0} }, --FuelTank
 			    { CLSID	= "{PTB_800_MIG21}", attach_point_position = {-0.1, 0.1 ,0.0} }, --FuelTank
            }
        ),
        pylon(4, 1, 1.055, -1.071, 0.328,
            {
                --
            },
            {
			    { CLSID	= "{APU-60-1_R_60M}" }, --R60x1
			    { CLSID	= "{R-60M 2R}" }, --R60x2
			    { CLSID	= "{FAB_250_M62}" }, --FAB250M62
			    { CLSID	= "{RBK_250_275_AO_1SCH}" }, --RBK250
			    { CLSID	= "{UB-16_S5M}" }, --UB16
			    { CLSID	= "{S-24B}" }, --S24
            }
        ),
        pylon(5, 1, 0, -0.124, 1.554,
            {
                --
            },
            {
			    --{ CLSID	= "{apu60-mig23ml-r24r}", attach_point_position = {0.8, -0.18 ,0.0} }, -- R-23R
			    --{ CLSID	= "{apu60-mig23ml-r24t}", attach_point_position = {0.8, -0.18 ,0.0} }, -- R-23T
			    { CLSID	= "{mig23ml-r24r}" }, -- R-23R
			    { CLSID	= "{mig23ml-r24r2}" }, -- R-24R
			    { CLSID	= "{mig23ml-r24t}" }, -- R-23T
			    { CLSID	= "{mig23ml-r24t2}" }, -- R-24T
			    { CLSID	= "{FAB_250_M62}" }, --FAB250M62
			    { CLSID	= "{37DCC01E-9E02-432F-B61D-10C166CA2798}" }, --FAB500
			    { CLSID	= "{RBK_250_275_AO_1SCH}" }, --RBK250
			    { CLSID	= "{UB-16_S5M}" }, --UB16
			    { CLSID	= "{UB-32_S5M}" }, --UB32
			    { CLSID	= "{S-24B}" }, --S24
            }
        ),
},
	
	Tasks = {
        aircraft_task(CAP),
     	aircraft_task(Escort),
      	aircraft_task(FighterSweep),
		aircraft_task(Intercept),
		aircraft_task(Reconnaissance),
    	aircraft_task(GroundAttack),
     	aircraft_task(CAS),
        aircraft_task(AFAC),
	    aircraft_task(RunwayAttack),
--  	aircraft_task(AntishipStrike),
    },	
	DefaultTask = aircraft_task(CAP),

	SFM_Data = {
	aerodynamics = --F15
		{
			Cy0	=	0,
			Mzalfa	=	4.355,
			Mzalfadt	=	0.8,
			kjx = 2.75,
			kjz = 0.00125,
			Czbe = -0.016,
			cx_gear = 0.0268,
			cx_flap = 0.02,
			cy_flap = 0.35,
			cx_brk = 0.06,
			table_data = 
			{
			--      M	 Cx0		 Cya		 B		 B4	      Omxmax	Aldop	Cymax
				{0, 0.0235, 0.075, 0.024, 0.18, 0.5, 30, 1 }, { 0.2, 0.0235, 0.075, 0.024, 0.18, 1.5, 30, 1 }, { 0.4, 0.0235, 0.075, 0.024, 0.18, 2.5, 30, 1 }, { 0.6, 0.0235, 0.075, 0.024, 0.18, 3.5, 30, 1 }, { 0.7, 0.022, 0.076, 0.3, 0.052, 3.5, 28.666666666667, 0.98 }, { 0.8, 0.022, 0.079, 0.3, 0.052, 3.5, 27.333333333333, 0.96 }, { 0.9, 0.0235, 0.083, 0.324, 0.0536, 3.5, 26, 0.94 }, { 1, 0.03, 0.085, 0.348, 0.0552, 3.5, 24.666666666667, 0.92 }, { 1.05, 0.031, 0.0855, 0.36, 0.056, 3.5, 24, 0.91 },
				{ 1.1, 0.032, 0.086, 0.372, 0.0568, 3.15, 18, 0.9 }, { 1.2, 0.0325, 0.083, 0.396, 0.0584, 2.45, 17, 0.85 }, { 1.3, 0.032, 0.077, 0.42, 0.06, 1.75, 16, 0.8 }, { 1.5, 0.031, 0.062, 0.488571, 0.06, 1.5, 13, 0.7 }, { 1.7, 0.03, 0.051333333333333, 0.557143, 0.06, 0.9, 12, 0.5 }, { 1.8, 0.0295, 0.046, 0.591429, 0.06, 0.86, 11.4, 0.44 }, { 2, 0.029, 0.039, 0.66, 0.06, 0.78, 10.2, 0.32 }, { 2.2, 0.028, 0.034, 0.227, 3.2, 0.7, 9, 0.2 }, { 2.5, 0.027, 0.033, 0.25, 4.5, 0.7, 9, 0.2 }, { 3.9, 0.027, 0.033, 0.35, 6, 0.7, 9, 0.2 },
			}, -- end of table_data
		}, -- end of aerodynamics
		engine = 
		{
			Nmg	=	60.2,
			MinRUD	=	0,
			MaxRUD	=	1,
			MaksRUD	=	0.85,
			ForsRUD	=	0.91,
			type	=	"TurboJet",
			hMaxEng	=	19.1,
			dcx_eng	=	0.0114,
			cemax	=	1.24,
			cefor	=	2.56,
			dpdh_m	=	4500,
			dpdh_f	=	9800.0,
			table_data = {
			--   M		Pmax		 Pfor
				{0, 65660, 97000 }, { 0.2, 66000, 99000 }, { 0.4, 67000, 107000 }, { 0.6, 68600, 118000 }, { 0.7, 70560, 129000 }, { 0.8, 73500, 137000 }, { 0.9, 75460, 140000 }, { 1, 76000, 143000 }, { 1.1, 76500, 148000 }, { 1.2, 77000, 154000 }, { 1.3, 77000, 159000 }, { 1.4, 77000, 177000 }, { 1.6, 91000, 206000 }, { 1.8, 116000, 218000 }, { 2.2, 126000, 220000 }, { 2.35, 115000, 212000 }, { 3.9, 77000, 150000},
			}, -- end of table_data
		}, -- end of engine
	},


	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {

	[0]  = {critical_damage = 5,  args = {146}},
	[1]  = {critical_damage = 3,  args = {296}},
	[2]  = {critical_damage = 3,  args = {297}},
	[3]  = {critical_damage = 5, args = {65}},
	[4]  = {critical_damage = 2,  args = {298}},
	[5]  = {critical_damage = 2,  args = {301}},
	[7]  = {critical_damage = 2,  args = {249}},
	[8]  = {critical_damage = 3,  args = {265}},
	[9]  = {critical_damage = 3,  args = {154}},
	[10] = {critical_damage = 3,  args = {153}},
	[11] = {critical_damage = 1,  args = {167}},
	[12] = {critical_damage = 1,  args = {161}},
	[13] = {critical_damage = 2,  args = {169}},
	[14] = {critical_damage = 2,  args = {163}},
	[15] = {critical_damage = 2,  args = {267}},
	[16] = {critical_damage = 2,  args = {266}},
	[17] = {critical_damage = 2,  args = {168}},
	[18] = {critical_damage = 2,  args = {162}},
	[20] = {critical_damage = 2,  args = {183}},
	[23] = {critical_damage = 5, args = {223}},
	[24] = {critical_damage = 5, args = {213}},
	[25] = {critical_damage = 2,  args = {226}},
	[26] = {critical_damage = 2,  args = {216}},
	[29] = {critical_damage = 5, args = {224}, deps_cells = {23, 25}},
	[30] = {critical_damage = 5, args = {214}, deps_cells = {24, 26}},
	[35] = {critical_damage = 5, args = {225}, deps_cells = {23, 29, 25, 37}},
	[36] = {critical_damage = 5, args = {215}, deps_cells = {24, 30, 26, 38}}, 
	[37] = {critical_damage = 2,  args = {228}},
	[38] = {critical_damage = 2,  args = {218}},
	[39] = {critical_damage = 2,  args = {244}, deps_cells = {53}}, 
	[40] = {critical_damage = 2,  args = {241}, deps_cells = {54}}, 
	[43] = {critical_damage = 2,  args = {243}, deps_cells = {39, 53}},
	[44] = {critical_damage = 2,  args = {242}, deps_cells = {40, 54}}, 
	[51] = {critical_damage = 2,  args = {240}}, 
	[52] = {critical_damage = 2,  args = {238}},
	[53] = {critical_damage = 2,  args = {248}},
	[54] = {critical_damage = 2,  args = {247}},
	[56] = {critical_damage = 2,  args = {158}},
	[57] = {critical_damage = 2,  args = {157}},
	[59] = {critical_damage = 3,  args = {148}},
	[61] = {critical_damage = 2,  args = {147}},
	[82] = {critical_damage = 2,  args = {152}},
	},
	
	DamageParts = 
	{  
		[1] = "MIG-23-OBLOMOK-WING-R", -- wing R
		[2] = "MIG-23-OBLOMOK-WING-L", -- wing L
	},
	
	lights_data = { typename = "collection", lights = {
		
	    [WOLALIGHT_NAVLIGHTS] = {
         typename = "argumentlight",
         argument = 49, },

        [WOLALIGHT_SPOTS] = {
            typename = "collection",
            lights = {
                [1] = {
                    typename = "Collection",
                    lights = {
                        {
                            typename = "Spot", connector = "MAIN_SPOT_PTR", dir_correction = {elevation = math.rad(8.0)}, argument = 51,
                            proto = lamp_prototypes.LFS_P_27_600,
                        },
                    },
                },
            }
        },
        [WOLALIGHT_TAXI_LIGHTS] = {
            typename = "collection",
            lights = {
                [1] = {
                    typename = "Collection",
                    lights = {
                        {
                            typename = "Spot", position = { 2.542, -0.826, 0.789 }, dir_correction = {elevation = math.rad(8.0)}, argument = 51,
                            proto = lamp_prototypes.LFS_R_27_180,},
                        },
                    },
                },
            }
        },
	},
}

add_aircraft(MIG23ML) --AG
