
local r24t_name = 'R-23T (Infra-Red)'
local r24t_mass = 232.0
local pylon_mass = 1.0

local r24t_warhead = enhanced_a2a_warhead(11, 178)

local MIG23_R24T_AA = {
    category        = CAT_AIR_TO_AIR,
    name            = r24t_name,
    model           = 'r-24t',
    user_name       = _(r24t_name),
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
    mass            = r24t_mass,
    display_name_short = "R-23T",

    Escort          = 0,
    Head_Type       = 1,
    sigma           = {5, 5, 5},
    M               = r24t_mass,
    H_max           = 12000.0,
    H_min           = 1.0,
    Diam            = 178.0,
    Cx_pil          = 2.5,
    D_max           = 12000.0,
    D_min           = 700.0,
    Head_Form       = 1,
    Life_Time       = 90.0,
    Nr_max          = 30,
    v_min           = 140.0,
    v_mid           = 700.0,
    Mach_max        = 3.2,
    t_b             = 0.0,
    t_acc           = 3.0,
    t_marsh         = 5.0,
    Range_max       = 28000.0,
    H_min_t         = 3.0,
    Fi_start        = 0.4,
    Fi_rak          = 3.14152,
    Fi_excort       = 1.05,
    Fi_search       = 1.05,
    OmViz_max       = 0.22,
    exhaust         = { 0.8, 0.8, 0.8, 0.05 };
	X_back          = -2.29,
    Y_back          = 0.0,
    Z_back          = 0.0,
    Reflection      = 0.06,
    KillDistance    = 12.0,
	Loft			= 0,
	Hoj 			= 0,
	ccm_k0 			= 0.6,
	loft_factor 	= 1.0,	

	SeekerSensivityDistance = 25000,
	SeekerCooled = true,

	PN_coeffs = {3, 				-- Number of Entries	
				15000.0 ,1.0,		-- Less 5 km to target Pn = 1
				25000.0, 0.5,		-- Between 10 and 5 km  to target, Pn smoothly changes from 0.5 to 1.0. 
				40000.0, 0.25};		-- Between 15 and 10 km  to target, Pn smoothly changes from 0.2 to 0.5. Longer then 15 km Pn = 0.2.

    warhead         = r24t_warhead,
    warhead_air     = r24t_warhead,

    shape_table_data = {
        {
            name     = r24t_name,
            file     = 'r-24t',
            life     = 1,
            fire     = {0, 1},
            username = "23T",		--Shortened name for cockpit displays
            index    = WSTYPE_PLACEHOLDER,
        },
    },


    ModelData = {
        58 ,  -- model params count
        0.5 ,   -- characteristic square (характеристическая площадь) -- 9

        -- параметры зависимости Сx
        0.046 , -- планка Сx0 на дозвуке ( M << 1) cx_k0
        0.093 , -- высота пика волнового кризиса cx_k1
        0.02 , -- крутизна фронта на подходе к волновому кризису cx_k2
        -0.445 , -- планка Cx0 на сверхзвуке ( M >> 1) cx_k3
        0.145  , -- крутизна спада за волновым кризисом cx_k4
        0.7  , -- коэффициент отвала поляры

        -- параметры зависимости Cy
        1.9 , -- планка Сy0 на дозвуке ( M << 1)
        0.7 , -- планка Cy0 на сверхзвуке ( M >> 1)
        0.8 , -- крутизна спада(фронта) за волновым кризисом

        0.4 , -- 7 Alfa_max  максимальный балансировачный угол, радианы
        0.00, --угловая скорость создаваймая моментом газовых рулей

        --    t_statr   t_b      t_accel  t_march   t_inertial   t_break  t_end
        -1.0,   -1.0,       3.0,     3.0,      8.0,          0.0,      1.0e9,           -- time interval
        0.0,    0.0,       14.5,     14.5,      9.0,          0.0,        0.0,           -- fuel flow rate in second kg/sec(секундный расход массы топлива кг/сек)
        0.0,    0.0,   14400.0,  11345.0,      -200.0,          0.0,        0.0,           -- thrust

        62, -- таймер самоликвидации, сек  Self-destructive time, sec
        80.0, -- время работы энергосистемы, сек  Working time of power system, sec
        0, -- абсолютная высота самоликвидации, м  Absolute height of self-destruction, M
        1.0, -- время задержки включения управления (маневр отлета, безопасности), сек  Connection delay time (shunting departure, safety), sec
        25000, -- дальность до цели в момент пуска, при превышении которой ракета выполняется маневр 'горка', м
        15000, -- дальность до цели, при которой маневр 'горка' завершается и ракета переходит на чистую пропорциональную навигацию (должен быть больше или равен предыдущему параметру), м
        0.52356,  -- синус угла возвышения траектории набора горки
        50.0, -- продольное ускорения взведения взрывателя  Longitudinal acceleration of fuze arming
        0.0, -- модуль скорости сообщаймый катапультным устройством, вышибным зарядом и тд
        1.19, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K0
        1.0, -- характристика системы САУ-РАКЕТА,  коэф фильтра второго порядка K1
        2.0, -- характристика системы САУ-РАКЕТА,  полоса пропускания контура управления

        -- DLZ. Данные для рассчета дальностей пуска (индикация на прицеле)
		21.0, 
		-23.0, 
		-3.0, 
		20500.0, 
		10000.0, 
		24500.0,
		12000.0, 
		15500.0, 
		6000.0, 
		4000.0, 
		0.4, 
		-0.015, 
		0.5,
    },
}

declare_weapon(MIG23_R24T_AA)

declare_loadout({
    category    = CAT_AIR_TO_AIR,
    CLSID       = "{mig23ml-r24t}",
    Picture     = 'r24t.png',
    wsTypeOfWeapon   = MIG23_R24T_AA.wsTypeOfWeapon,
    displayName = _(r24t_name),
	attribute	=	{4,	4,	32,	WSTYPE_PLACEHOLDER},
    Count       = 1,
    Weight      = r24t_mass + pylon_mass,
    Elements    = 
	{
		{
		
			ShapeName	=	"r-24t",
			Position	=	{0,	0,	0}
		},
	}, 	
})

declare_loadout({
    category        = CAT_AIR_TO_AIR,
    CLSID           = "{apu60-mig23ml-r24t}",
    wsTypeOfWeapon  = MIG23_R24T_AA.wsTypeOfWeapon,
    attribute       = {4, 4, 32, WSTYPE_PLACEHOLDER},
    Count           = 1,
    Picture         = "r24t.png",
    displayName     = _(r24t_name),
    Weight          = r24t_mass,
    Position	=	{0, -0.335, 0},
	Elements = {
	
		{
			ShapeName = "HB_F14_EXT_SHOULDER_PHX_R",
			IsAdapter = true,
			Rotation = {0,0,-0.6},
		},
		
		{
			Position	=	{-1.0, -0.152, 0},
			ShapeName	=	"r-24t",
			Rotation = {0,0,-0.6},
		},
		
	},
})
