dofile("Scripts/Database/wsTypes.lua")

local GALLON_TO_KG = 3.785 * 0.8
local POUNDS_TO_KG = 0.453592

--*** FUEL Tank ***  by ANDR0ID {UH60_FUEL_TANK_230} new 3d model by Tanuki44 for MH
local function fuel_tank_120(clsid)
	local data =
	{
		category	= CAT_FUEL_TANKS,
		CLSID		= clsid,
		attribute	= {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture		= "PTB.png",
		displayName	= _("120 Gal Tank"),
		Weight_Empty	= 100 * POUNDS_TO_KG,
		Weight			= ((100 * POUNDS_TO_KG) + (60 * GALLON_TO_KG)),
		Cx_pil		= 0.000956902,
		shape_table_data = 
		{
			{
				name	= "FUEL_TANK_120";
				file	= "mh_tank";
				life	= 1;
				fire	= { 0, 1};
				username	= "FUEL_TANK_120";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "mh_tank",
			}, 
		}, 
	}
	declare_loadout(data)
end
fuel_tank_120("{FUEL_TANK_120}")

local function fuel_tank_dummy(clsid)
	local data =
	{
		category	= CAT_FUEL_TANKS,
		CLSID		= clsid,
		attribute	= {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture		= "Weaponx.png",
		displayName	= _("Do Not Use"),
		Weight_Empty	= 100 * POUNDS_TO_KG,
		Weight			= ((100 * POUNDS_TO_KG) + (60 * GALLON_TO_KG)),
		Cx_pil		= 0.000956902,
		shape_table_data = 
		{
			{
				name	= "FUEL_TANK_120";
				file	= "mh_tank";
				life	= 1;
				fire	= { 0, 1};
				username	= "FUEL_TANK_120";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "mh_tank",
			}, 
		}, 
	}
	declare_loadout(data)
end
fuel_tank_dummy("{FUEL_TANK_DUMMY}")
--ANDR0ID Added
local function fuel_tank_Dual120(clsid)
	local data =
	{
		category	= CAT_FUEL_TANKS,
		CLSID		= clsid,
		attribute	= {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture		= "PTB.png",
		displayName	= _("Dual 120 Gal Tanks"),
		Weight_Empty	= 100 * POUNDS_TO_KG,
		Weight			= ((100 * POUNDS_TO_KG) + (120 * GALLON_TO_KG)),
		Cx_pil		= 0.000956902,
		shape_table_data = 
		{
			{
				name	= "FUEL_TANK_120";
				file	= "mh_tank";
				life	= 1;
				fire	= { 0, 1};
				username	= "FUEL_TANK_120";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "mh_tank",
			}, 
		}, 
	}
	declare_loadout(data)
end
fuel_tank_Dual120("{FUEL_TANK_Dual120}")

local function fuel_tank_80(clsid)
	local data =
	{
		category	= CAT_FUEL_TANKS,
		CLSID		= clsid,
		attribute	= {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture		= "PTB.png",
		displayName	= _("80 Gal Tank"),
		Weight_Empty	= 90 * POUNDS_TO_KG,
		Weight			= ((90 * POUNDS_TO_KG) + (40 * GALLON_TO_KG)),
		Cx_pil		= 0.000956902,
		shape_table_data = 
		{
			{
				name	= "FUEL_TANK_120";
				file	= "mh_tank";
				life	= 1;
				fire	= { 0, 1};
				username	= "FUEL_TANK_120";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "mh_tank",
			}, 
		}, 
	}
	declare_loadout(data)
end
fuel_tank_80("{FUEL_TANK_80}")

local function fuel_tank_dummyDual120(clsid)
	local data =
	{
		category	= CAT_FUEL_TANKS,
		CLSID		= clsid,
		attribute	= {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture		= "Weaponx.png",
		displayName	= _("Do Not Use - Dual"),
		Weight_Empty	= 100 * POUNDS_TO_KG, 
		Weight			= ((100 * POUNDS_TO_KG) + (120 * GALLON_TO_KG)), --Zero weight becuase Requires regular 120 in MH-60R.lua
		Cx_pil		= 0.000956902,
		shape_table_data = 
		{
			{
				name	= "FUEL_TANK_120";
				file	= "mh_tank";
				life	= 1;
				fire	= { 0, 1};
				username	= "FUEL_TANK_120";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "mh_tank",
			}, 
		}, 
	}
	declare_loadout(data)
end
fuel_tank_dummyDual120("{FUEL_TANK_DUMMYDual120}")

local function fuel_tank_dummy80(clsid)
	local data =
	{
		category	= CAT_FUEL_TANKS,
		CLSID		= clsid,
		attribute	= {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture		= "Weaponx.png",
		displayName	= _("Do Not Use - 80"),
		Weight_Empty	= 90 * POUNDS_TO_KG,
		Weight			= ((90 * POUNDS_TO_KG) + (40 * GALLON_TO_KG)),
		Cx_pil		= 0.000956902,
		shape_table_data = 
		{
			{
				name	= "FUEL_TANK_120";
				file	= "mh_tank";
				life	= 1;
				fire	= { 0, 1};
				username	= "FUEL_TANK_120";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "mh_tank",
			}, 
		}, 
	}
	declare_loadout(data)
end
fuel_tank_dummy80("{FUEL_TANK_DUMMY80}")

local function fuel_tank_120_empty(clsid)
	local data =
	{
		category	= CAT_FUEL_TANKS,
		CLSID		= clsid,
		attribute	= {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture		= "PTB.png",
		displayName	= _("120 Gal Tank - E"),
		Weight_Empty	= 0,
		Weight			= 0,
		Cx_pil		= 0.000956902,
		shape_table_data = 
		{
			{
				name	= "FUEL_TANK_120";
				file	= "mh_tank";
				life	= 1;
				fire	= { 0, 1};
				username	= "FUEL_TANK_120";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "mh_tank",
			}, 
		}, 
	}
	declare_loadout(data)
end
fuel_tank_120_empty("{FUEL_TANK_120_EMPTY}")

local function MH60T_Radar(clsid)
	local data =
	{
		category	= CAT_PODS,
		CLSID		= clsid,
		attribute	=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
		Picture		= "JH.png",
		displayName	= _("MH-60J JAYHAWK"),
		Weight_Empty	= 0 * POUNDS_TO_KG,--ANDR0ID, base mod pylon is zero, so staying consistant.
		Weight			= 0 * POUNDS_TO_KG,
		Cx_pil		= 0.000956902,
		shape_table_data = 
		{
			{
				name	= "MH60T Radar";
				file	= "MH60T";
				life	= 1;
				fire	= { 0, 1};
				username	= "MH60_T_RADAR";
				index	= WSTYPE_PLACEHOLDER;
			},
		},
		Elements	= 
		{
			{
				ShapeName	= "MH60T",
			}, 
		}, 
	}
	declare_loadout(data)
end
MH60T_Radar("{MH60T_Radar}")