dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."utils.lua")
dofile(LockOn_Options.script_path.."Systems/circuitBreakerHandles.lua")

dev = GetSelf()
sensor_data = get_base_data()
update_time_step = 1
make_default_activity(update_time_step)

local inbdLPresent = false
local inbdRPresent = false

local inbdLFuelQuantity = 0
local inbdRFuelQuantity = 0

local afmcpXferMode = 0
local afmcpManXfer = 0
local afmcpXferFrom = 0
local afmcpPress = 0

local paramInbdLFuelDisplay = get_param_handle("AFMS_DISPLAY_INBD_L")
local paramInbdRFuelDisplay = get_param_handle("AFMS_DISPLAY_INBD_R")

local stationInfo = nil
local tankFuelAmount1Value = 0
local tankFuelAmount2Value = 0
local flag_init = false
		
function post_initialize()
    local birth = LockOn_Options.init_conditions.birth_place	
    if birth=="GROUND_HOT" or birth=="AIR_HOT" then  
    elseif birth=="GROUND_COLD" then
    end
end

dev:listen_command(device_commands.afmcpXferMode)
dev:listen_command(device_commands.afmcpManXfer)
dev:listen_command(device_commands.afmcpXferFrom)
dev:listen_command(device_commands.afmcpPress)

dev:listen_command(Keys.afmcpXferModeCycle)
dev:listen_command(Keys.afmcpManXferCycle)
dev:listen_command(Keys.afmcpXferFromCycle)
dev:listen_command(Keys.afmcpPressCycle)
dev:listen_command(Keys.afmcpPress_AXIS)
dev:listen_command(Keys.afmcpPressInc)
dev:listen_command(Keys.afmcpPressDec)

function SetCommand(command,value)   
    if command == device_commands.afmcpXferMode then
		--print_message_to_user("XFERMODE: " .. value)
		dispatch_action(nil, EFM_commands.afmcpXferMode, value)
		afmcpXferMode = value
	elseif command == device_commands.afmcpManXfer then
		--print_message_to_user("MANXFER: " .. value)
		dispatch_action(nil, EFM_commands.afmcpManXfer, value)
		afmcpManXfer = value
	elseif command == device_commands.afmcpXferFrom then
		value = 1 - value
		--print_message_to_user("XFERFROM: " .. value)
		dispatch_action(nil, EFM_commands.afmcpXferFrom, value)
		afmcpXferFrom = value
	elseif command == device_commands.afmcpPress then
		afmcpPress = value
	elseif command == Keys.afmcpXferModeCycle then
		local tempValue = afmcpXferMode + 1
		if tempValue > 1 then tempValue = -1 end
		dev:performClickableAction(device_commands.afmcpXferMode, tempValue, true)
	elseif command == Keys.afmcpManXferCycle then
		local tempValue = afmcpManXfer + 1
		if tempValue > 1 then tempValue = -1 end
		dev:performClickableAction(device_commands.afmcpManXfer, tempValue, true)
	elseif command == Keys.afmcpXferFromCycle then
		local tempValue = 1 - afmcpXferFrom
		dev:performClickableAction(device_commands.afmcpXferFrom, tempValue, true)
	elseif command == Keys.afmcpPressCycle then
		local tempValue = afmcpPress + 1/3
		if tempValue > 1 then tempValue = -1 end
		dev:performClickableAction(device_commands.afmcpPress, tempValue, true)
	elseif command == Keys.afmcpPress_AXIS then
		local normalisedValue = (( value + 1 ) / 2 ) * 1.0 -- normalised {-1 to 1} to {0 - 1.0}
        dev:performClickableAction(device_commands.afmcpPress, normalisedValue, false)
	elseif command == Keys.afmcpPressInc and afmcpPress < 1 then
		local tempValue = clamp(afmcpPress + 1/3, 0, 1)
		dev:performClickableAction(device_commands.afmcpPress, tempValue, true)
		--print_message_to_user("INC: " .. afmcpPress .. " .. " ..tempValue )
	elseif command == Keys.afmcpPressDec and afmcpPress > 0 then
		local tempValue = clamp(afmcpPress - 1/3, 0, 1)
		dev:performClickableAction(device_commands.afmcpPress, tempValue, true)
		--print_message_to_user("DEC: " .. afmcpPress .. " .. " ..tempValue )
	end
end

function updateTanks(i)
	get_param_handle("PYLONS_USED"):set(0)
	local stationInfo = dev:get_station_info(i)
--ANDR0ID Edited
	if i == 0 and tostring(stationInfo["CLSID"]) == "{FUEL_TANK_120}" then --Port Side
		tankFuelAmountValue = get_param_handle("AUX_FUEL_P0"):get() * 2
		--print_message_to_user("AUX_FUEL_P0:" .. tankFuelAmountValue)
		inbdLFuelQuantity = round(tankFuelAmountValue / 10) * 10
		paramInbdLFuelDisplay:set(tostring(inbdLFuelQuantity.."%"))
	elseif i == 0 and tostring(stationInfo["CLSID"]) == "{FUEL_TANK_Dual120}" then
		tankFuelAmountValue = get_param_handle("AUX_FUEL_P0"):get() * 2
		--print_message_to_user("AUX_FUEL_P0:" .. tankFuelAmountValue)
		inbdLFuelQuantity = round(tankFuelAmountValue / 10) * 10
		paramInbdLFuelDisplay:set(tostring(inbdLFuelQuantity.."%"))		
	elseif i == 1 and tostring(stationInfo["CLSID"]) == "{FUEL_TANK_120}" then --STBD Side
		tankFuelAmountValue = get_param_handle("AUX_FUEL_P1"):get() * 2
		--print_message_to_user("AUX_FUEL_P1:" .. tankFuelAmountValue)
		inbdRFuelQuantity = round(tankFuelAmountValue / 10) * 10
		paramInbdRFuelDisplay:set(tostring(inbdRFuelQuantity.."%"))
	elseif i == 1 and tostring(stationInfo["CLSID"]) == "{FUEL_TANK_80}" then
		tankFuelAmountValue = get_param_handle("AUX_FUEL_P1"):get() * 2
		--print_message_to_user("AUX_FUEL_P1:" .. tankFuelAmountValue)
		inbdRFuelQuantity = round(tankFuelAmountValue / 10) * 10
		paramInbdRFuelDisplay:set(tostring(inbdRFuelQuantity.."%"))
	end
--END ANDR0ID Edited	
end



function update()
	updateNetworkArgs(GetSelf())

	for i= 0, 1 do
		updateTanks(i)
	end

end

need_to_be_closed = false 