dofile(LockOn_Options.script_path.."command_defs.lua")
dofile(LockOn_Options.script_path.."devices.lua")

local gettext = require("i_18n")
_ = gettext.translate

cursor_mode =
{
    CUMODE_CLICKABLE = 0,
    CUMODE_CLICKABLE_AND_CAMERA  = 1,
    CUMODE_CAMERA = 2,
};

clickable_mode_initial_status  = cursor_mode.CUMODE_CLICKABLE
use_pointer_name			   = true
anim_speed_default = 5.0

function default_button(hint_,device_,command_,arg_,arg_val_,arg_lim_)

	local   arg_val_ = arg_val_ or 1
	local   arg_lim_ = arg_lim_ or {0,1}

	return  {
				class 				= {class_type.BTN},
				hint  				= hint_,
				device 				= device_,
				action 				= {command_},
				stop_action 		= {command_},
				arg 				= {arg_},
				arg_value			= {arg_val_},
				arg_lim 			= {arg_lim_},
				use_release_message = {true}
			}
end

function default_1_position_tumb(hint_, device_, command_, arg_, arg_val_, arg_lim_)
	local   arg_val_ = arg_val_ or 1
	local   arg_lim_ = arg_lim_ or {0,1}
	return  {
				class 		= {class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_},
				arg 	  	= {arg_},
				arg_value 	= {arg_val_},
				arg_lim   	= {arg_lim_},
				updatable 	= true,
				use_OBB 	= true
			}
end

function default_2_position_tumb(hint_, device_, command_, arg_)
	return  {
				class 		= {class_type.TUMB,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_,command_},
				arg 	  	= {arg_,arg_},
				arg_value 	= {1,-1},
				arg_lim   	= {{0,1},{0,1}},
				updatable 	= true,
				use_OBB 	= true
			}
end

function default_2_position_tumb_animated(hint_, device_, command_, arg_, animation_speed_)
 element = default_2_position_tumb(hint_, device_, command_, arg_)
 
 local animation_ = animation_speed_ or anim_speed_default
 
 element.animated = {true}
 element.animation_speed = {animation_}
 return element
end

function default_3_position_tumb(hint_,device_,command_,arg_,cycled_,inversed_)
	local cycled = true

	local val =  1
	if inversed_ then
	      val = -1
	end
	if cycled_ ~= nil then
	   cycled = cycled_
	end
	return  {
				class 		= {class_type.TUMB,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_,command_},
				arg 	  	= {arg_,arg_},
				arg_value 	= {val,-val},
				arg_lim   	= {{-1,1},{-1,1}},
				updatable 	= true,
				use_OBB 	= true,
				cycle       = cycled
			}
end

function default_3_position_tumb_animated(hint_,device_,command_,arg_,cycled_,inversed_,animation_speed_)
    local element = default_3_position_tumb(hint_,device_,command_,arg_,cycled_,inversed_)
	local animation_speed_  = animation_speed_ or anim_speed_default
	element.animated		= {true,true}
	element.animation_speed	= {animation_speed_,animation_speed_}
	return element
end

function springloaded_3_pos_tumb(hint_, device_, command1_, command2_, arg_, val1_, val2_, val3_)
    local val1 = val1_ or 0.0
    local val2 = val2_ or 0.5
    local val3 = val3_ or 1.0
    return  {   
                class       = {class_type.BTN,class_type.BTN},
                hint        = hint_,
                device      = device_,
                action      = {command1_,command2_},
                stop_action = {command1_,command2_},
                arg         = {arg_,arg_},
                arg_value   = {val1,val3}, 
                arg_lim     = {{val1,val3},{val1,val2}},
                updatable   = true, 
                use_OBB     = true,
                use_release_message = {true,true},
            }
end

function springloaded_3_pos_tumb_inverted(hint_, device_, command1_, command2_, arg_, val1_, val2_, val3_)
    local val1 = val1_ or 0.0
    local val2 = val2_ or 0.5
    local val3 = val3_ or 1.0
    return  {   
                class       = {class_type.BTN,class_type.BTN},
                hint        = hint_,
                device      = device_,
                action      = {command1_,command2_},
                stop_action = {command1_,command2_},
                arg         = {arg_,arg_},
                arg_value   = {val3,val1}, 
                arg_lim     = {{val1,val3},{val1,val2}},
                updatable   = true, 
                use_OBB     = true,
                use_release_message = {true,true},
            }
end

function default_axis(hint_,device_,command_,arg_, default_, gain_,updatable_,relative_)

	local default = default_ or 1
	local gain = gain_ or 0.1
	local updatable = updatable_ or false
	local relative  = relative_ or false

	return  {
				class 		= {class_type.LEV},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_},
				arg 	  	= {arg_},
				arg_value 	= {default},
				arg_lim   	= {{0,1}},
				updatable 	= updatable,
				use_OBB 	= true,
				gain		= {gain},
				relative    = {relative},
			}
end

function default_axis_cycle(hint_,device_,command_,arg_, default_, gain_,updatable_,relative_)

	local default = default_ or 1
	local gain = gain_ or 0.1
	local updatable = updatable_ or false
	local relative  = relative_ or false

	return  {
				class 		= {class_type.LEV},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_},
				arg 	  	= {arg_},
				arg_value 	= {default},
				arg_lim   	= {{0,1}},
				updatable 	= updatable,
				use_OBB 	= true,
				gain		= {gain},
				relative    = {relative},
				cycle     	= true,
			}
end

function default_movable_axis(hint_,device_,command_,arg_, default_, gain_,updatable_,relative_)

	local default = default_ or 1
	local gain = gain_ or 0.1
	local updatable = updatable_ or false
	local relative  = relative_ or false

	return  {
				class 		= {class_type.MOVABLE_LEV},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_},
				arg 	  	= {arg_},
				arg_value 	= {default},
				arg_lim   	= {{0,1}},
				updatable 	= updatable,
				use_OBB 	= true,
				gain		= {gain},
				relative    = {relative},
			}
end

function default_axis_limited(hint_,device_,command_,arg_, default_, gain_,updatable_,relative_, arg_lim_)

	local relative = false
	local default = default_ or 0
	local updatable = updatable_ or false
	if relative_ ~= nil then
		relative = relative_
	end

	local gain = gain_ or 0.1
	return  {
				class 		= {class_type.LEV},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_},
				arg 	  	= {arg_},
				arg_value 	= {default},
				arg_lim   	= {arg_lim_},
				updatable 	= updatable,
				use_OBB 	= false,
				gain		= {gain},
				relative    = {relative},
                cycle       = false,
			}
end

function default_axis_limited_cycle(hint_,device_,command_,arg_, default_, gain_,updatable_,relative_, arg_lim_)

	local relative = false
	local default = default_ or 0
	local updatable = updatable_ or false
	if relative_ ~= nil then
		relative = relative_
	end

	local gain = gain_ or 0.1
	return  {
				class 		= {class_type.LEV},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_},
				arg 	  	= {arg_},
				arg_value 	= {default},
				arg_lim   	= {arg_lim_},
				updatable 	= updatable,
				use_OBB 	= false,
				gain		= {gain},
				relative    = {relative},
                cycle       = true,
			}
end

function multiposition_switch(hint_,device_,command_,arg_,count_,delta_,inversed_, min_)
    local min_   = min_ or 0
	local delta_ = delta_ or 0.5

	local inversed = 1
	if	inversed_ then
		inversed = -1
	end

	return  {
				class 		= {class_type.TUMB,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_,command_},
				arg 	  	= {arg_,arg_},
				arg_value 	= {-delta_ * inversed,delta_ * inversed},
				arg_lim   	= {{min_, min_ + delta_ * (count_ -1)},
							   {min_, min_ + delta_ * (count_ -1)}},
				updatable 	= true,
				use_OBB 	= true
			}
end

function multiposition_switch_limited(hint_,device_,command_,arg_,count_,delta_,inversed_,min_)
    local min_   = min_ or 0
	local delta_ = delta_ or 0.5

	local inversed = 1
	if	inversed_ then
		inversed = -1
	end

	return  {
				class 		= {class_type.TUMB,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_,command_},
				arg 	  	= {arg_,arg_},
				arg_value 	= {-delta_ * inversed,delta_ * inversed},
				arg_lim   	= {{min_, min_ + delta_ * (count_ -1)},
							   {min_, min_ + delta_ * (count_ -1)}},
				updatable 	= true,
				use_OBB 	= true,
				cycle     	= false,
			}
end

function multiposition_switch_limited_animated(hint_,device_,command_,arg_,count_,delta_,inversed_,min_,animation_speed_)
    local element = multiposition_switch_limited(hint_,device_,command_,arg_,count_,delta_,inversed_,min_)
	local animation_speed_  = animation_speed_ or anim_speed_default
	element.animated		= {true,true}
	element.animation_speed	= {animation_speed_/count_,animation_speed_/count_}
	return element
end

function default_button_axis(hint_, device_,command_1, command_2, arg_1, arg_2, limit_1, limit_2)
	local limit_1_   = limit_1 or 1.0
	local limit_2_   = limit_2 or 1.0
return {
			class		=	{class_type.BTN, class_type.LEV},
			hint		=	hint_,
			device		=	device_,
			action		=	{command_1, command_2},
			stop_action =   {command_1, 0},
			arg			=	{arg_1, arg_2},
			arg_value	= 	{1, 0.5},
			arg_lim		= 	{{0, limit_1_}, {0,limit_2_}},
			animated        = {false,true},
			animation_speed = {0, 0.4},
			gain = {0, 0.1},
			relative	= 	{false, false},
			updatable 	= 	true,
			use_OBB 	= 	true,
			use_release_message = {true, false}
	}
end

function default_animated_lever(hint_, device_, command_, arg_, animation_speed_,arg_lim_)
local arg_lim__ = arg_lim_ or {0.0,1.0}
return  {
	class  = {class_type.TUMB, class_type.TUMB},
	hint   	= hint_,
	device 	= device_,
	action 	= {command_, command_},
	arg 		= {arg_, arg_},
	arg_value 	= {1, 0},
	arg_lim 	= {arg_lim__, arg_lim__},
	updatable  = true,
	gain 		= {0.1, 0.1},
	animated 	= {true, true},
	animation_speed = {animation_speed_, 0},
	cycle = true
}
end

function default_multiposition_animated_lever(hint_,device_,command_,arg_,count_,delta_,inversed_,min_,animation_speed_)
    local min_   = min_ or 0
	local delta_ = delta_ or 0.5

	local inversed = 1
	if	inversed_ then
		inversed = -1
	end

	return  {
				class 		= {class_type.TUMB,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_,command_},
				arg 	  	= {arg_,arg_},
				arg_value 	= {-delta_ * inversed,delta_ * inversed},
				arg_lim   	= {{min_, min_ + delta_ * (count_ -1)},
							   {min_, min_ + delta_ * (count_ -1)}},
				updatable 	= true,
				use_OBB 	= true,
				cycle     	= false,
				gain 		= {0.1, 0.1},
				animated 	= {true, true},
				animation_speed = {animation_speed_, 0},
			}
end

function default_button_tumb(hint_, device_, command1_, command2_, arg_)
	return  {
				class 		= {class_type.BTN,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command1_,command2_},
				stop_action = {command1_,0},
				arg 	  	= {arg_,arg_},
				arg_value 	= {-1,1},
				arg_lim   	= {{-1,0},{0,1}},
				updatable 	= true,
				use_OBB 	= true,
				use_release_message = {true,false}
			}
end

function FCS_Tumb(hint_, device_, command1_, command2_, arg_)
	return  {
				class 		= {class_type.TUMB,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command1_,command2_},
				arg 	  	= {arg_, arg_},
				arg_value 	= {-0.5,0.5},
				arg_lim   	= {{0,1},{0,1}},
				cycle = false
			}
end

function default_basic_Lever(hint_, device_, command1_, arg_)
	return	{
				class 		= {class_type.LEV,class_type.LEV},
				hint  		= hint_,
				device 		= device_,
				action 		= {command1_ ,	command1_},
				arg 		= {arg_,arg_},
				arg_value	= {0.05},
				arg_lim 	= {{0.0, 1.0}}
			}
end

function default_2_way_spring_switch(hint_, device_, command1_, arg_, inversed_)

	local inversed = 1
	if	inversed_ then
		inversed = -1
	end

	return	{
				class		= {class_type.BTN, class_type.BTN},
				hint  		= hint_,
				device 		= device_,
				action 		= {command1_,command1_},
				stop_action = {command1_,command1_},
				arg 		= {arg_, arg_},
				arg_value	= {1.0*inversed, -1.0*inversed},
				arg_lim 	= {{0.0, 1.0}, {-1.0, 0.0}},
				use_release_message = {true}
			}
end

function default_multiposition_knob(hint_,device_,command_,arg_,count_,delta_,inversed_,min_)
    local min_   = min_ or 0
	local delta_ = delta_ or 0.5

	local inversed = 1
	if	inversed_ then
		inversed = -1
	end

	return  {
				class 		= {class_type.TUMB,class_type.TUMB},
				hint  		= hint_,
				device 		= device_,
				action 		= {command_,command_},
				arg 	  	= {arg_,arg_},
				arg_value 	= {-delta_ * inversed,delta_ * inversed},
				arg_lim   	= {{min_, min_ + delta_ * (count_ -1)},
							   {min_, min_ + delta_ * (count_ -1)}},
				updatable 	= true,
				use_OBB 	= true,
				cycle     	= true,
			}
end

function default_multiposition_knob_animated(hint_,device_,command_,arg_,count_,delta_,inversed_,min_,animation_speed_)
    local element = default_multiposition_knob(hint_,device_,command_,arg_,count_,delta_,inversed_,min_)
	local animation_speed_  = animation_speed_ or anim_speed_default
	element.animated		= {true,true}
	element.animation_speed	= {animation_speed_/count_,animation_speed_/count_}
	return element
end


function intercom_rotate_tumb(hint_, device_,command_1, command_2, arg_1, arg_2)
return {
			class		=	{class_type.TUMB, class_type.TUMB, class_type.LEV},
			hint		=	hint_,
			device		=	device_,
			action		=	{command_1, command_1, command_2},
			arg			=	{arg_1, arg_1, arg_2},
			arg_value	= 	{1, -1, 1},
			arg_lim		= 	{{0, 1}, {0, 1}, {0,1}},
			--animated        = {false,false,false},
			--animation_speed = {0, 0, 0.5},
			relative	= 	{false, false, false},
			updatable 	= 	false, 
			use_OBB 	= 	false,
			gain 		=   {1.0, 1.0, 0.1},
			cycle 		=   false,
	}
end

function multiposition_switch_spring(hint_, device_, command_1, command_2, arg_, inversed_, min_)
    local min_   = min_ or 0
	local inversed = 1
	
	if	inversed_ then
		inversed = -1
	end
	
	return {
			class		= {class_type.TUMB,class_type.BTN},
			hint  		= hint_,
			device 		= device_,
			action		= {command_1 ,command_2},
			arg			= {arg_, arg_},
			stop_action	= {0, command_2},
			arg_value	= {0,1},
			arg_lim		= {{0.0, 0.5},{0.5, 1.0}},
			use_release_message = {false,true},
	}
end

function multiposition_switch_spring_animated(hint_, device_, command_1, command_2, arg_, inversed_, min_, animation_speed_)
    local element = multiposition_switch_spring(hint_, device_, command_1, command_2, arg_, inversed_, min_)
	local animation_speed_  = animation_speed_ or anim_speed_default
	element.animated		= {true,true}
	element.animation_speed	= {animation_speed_,animation_speed_}
	return element
end

elements = {}

-- Landing Gear
elements["PTN_404"]	= default_animated_lever(_("Landing Gear Lever"), devices.INSTPANEL, device_commands.Button_404, 404,5.0)
elements["PTN_408"]	= default_animated_lever(_("Landing Gear Emergency Release Lever"), devices.INSTPANEL, device_commands.Button_408, 408, 5.0)

-- HUD/VTB
elements["PTN_201"] = multiposition_switch_limited_animated(_("HUD Power Switch"),					devices.VTH_VTB,	device_commands.Button_201,	201,	3,	0.5,	false, 0)
elements["PTN_202"] = default_axis_limited(_("HUD Brightness Knob"),						devices.VTH_VTB,	device_commands.Button_202,	202,	0,	0.1,	true,	false,	{0.0, 1.0})
elements["PTN_203"] = default_2_way_spring_switch(_("HUD Declutter Switch"),				devices.VTH_VTB,	device_commands.Button_203,	203,	true)
elements["PTN_204"] = multiposition_switch_limited_animated(_("HUD Altimeter Selector Switch"),		devices.VTH_VTB,	device_commands.Button_204, 204,	3, 0.5, true, 0)
elements["PTN_205"] = multiposition_switch_limited_animated(_("Radar Altimeter Power Switch"),		devices.VTH_VTB,	device_commands.Button_205, 205,	3, 0.5, false, 0)
elements["PTN_206"] = default_2_position_tumb_animated(_("Auxiliary Gunsight"),						devices.VTH_VTB,	device_commands.Button_206, 206)
elements["PTN_207"] = default_axis_cycle(_("Auxiliary Gunsight Deflection"),				devices.VTH_VTB,	device_commands.Button_207, 207,	0, 0.01, true, 0)
elements["PTN_208"] = default_2_position_tumb_animated(_("A/G Gun Reticle Switch"),					devices.VTH_VTB,	device_commands.Button_208, 208)
elements["PTN_209"] = default_axis_limited(_("Target Wingspan Knob"),						devices.VTH_VTB,	device_commands.Button_209, 209,	0, -0.03,	true,	false, {0.0, 0.99})
elements["PTN_210"] = default_button(_("HUD Clear Button"),									devices.VTH_VTB,	device_commands.Button_210, 210,	0, 1)
elements["PTN_192"] = default_axis(_("Minimum Altitude Selector"),							devices.VTH_VTB,	device_commands.Button_192, 192,	0,	0.2, true, 0)
elements["PTN_470"] = default_2_position_tumb_animated(_("Radar WOW Emitter Authorize Switch"),		devices.VTH_VTB,	device_commands.Button_470, 470)
elements["PTN_213"] = default_2_way_spring_switch(_("Target Data Manual Entry Begin/End"),	devices.VTH_VTB,	device_commands.Button_213, 213, true)
elements["PTN_214"] = default_2_way_spring_switch(_("Bullseye Waypoint Selector"),			devices.VTH_VTB,	device_commands.Button_214, 214, true)
elements["PTN_215"] = default_2_way_spring_switch(_("Target Range from Bullseye"),			devices.VTH_VTB,	device_commands.Button_215, 215, true)
elements["PTN_216"] = default_2_way_spring_switch(_("Target Bearing from Bullseye"),		devices.VTH_VTB,	device_commands.Button_216, 216, true)
elements["PTN_217"] = default_2_way_spring_switch(_("Target Heading"),						devices.VTH_VTB,	device_commands.Button_217, 217, true)
elements["PTN_218"] = default_2_way_spring_switch(_("Target Altitude"),						devices.VTH_VTB,	device_commands.Button_218, 218, true)
elements["PTN_219"] = default_2_way_spring_switch(_("Target Mach Number"),					devices.VTH_VTB,	device_commands.Button_219, 219, true)
elements["PTN_220"] = default_2_way_spring_switch(_("Target Age"),							devices.VTH_VTB,	device_commands.Button_220, 220, true)
elements["PTN_221"] = default_2_position_tumb_animated(_("VTB Power Switch"),						devices.VTH_VTB,	device_commands.Button_221, 221)
elements["PTN_222"] = default_2_way_spring_switch(_("VTB Declutter"),						devices.VTH_VTB,	device_commands.Button_222, 222, true)
elements["PTN_223"] = default_2_position_tumb_animated(_("VTB Orientation Selector (Inop)"),			devices.VTH_VTB,	device_commands.Button_223, 223)
elements["PTN_224"] = multiposition_switch_limited_animated(_("Icons and Rulers Brightness"),		devices.VTH_VTB,	device_commands.Button_224, 224, 8, 0.1, false, 0)
elements["PTN_225"] = multiposition_switch_limited_animated(_("Video Brightness"),					devices.VTH_VTB,	device_commands.Button_225, 225, 8, 0.1, false, 0)
elements["PTN_226"] = multiposition_switch_limited_animated(_("Display Contrast"),					devices.VTH_VTB,	device_commands.Button_226, 226, 8, 0.1, false, 0)
elements["PTN_227"] = multiposition_switch_limited_animated(_("Display Brightness"),					devices.VTH_VTB,	device_commands.Button_227, 227, 8, 0.1, false, 0)

-- PCA/PPA
elements["PTN_463"]	= default_2_position_tumb_animated(_("Gun Arm/Safe Switch"), devices.PCA_PPA, device_commands.Button_463, 463)
elements["PTN_234"] = default_2_position_tumb_animated(_("Master Arm Switch"), devices.PCA_PPA, device_commands.Button_234, 234)
elements["PTN_248"] = default_2_position_tumb_animated(_("Selective Jettison Switch Cover"), devices.PCA_PPA, device_commands.Button_248, 248)
elements["PTN_249"] = default_2_position_tumb_animated(_("Selective Jettison Switch"), devices.PCA_PPA, device_commands.Button_249, 249)

elements["PTN_235"] = default_button(_("PCA Button 1"), devices.PCA_PPA, device_commands.Button_235, 235, 0, 1)
elements["PTN_237"] = default_button(_("PCA Button 2"), devices.PCA_PPA, device_commands.Button_237, 237, 0, 1)
elements["PTN_239"] = default_button(_("PCA Button 3"), devices.PCA_PPA, device_commands.Button_239, 239, 0, 1)
elements["PTN_241"] = default_button(_("PCA Button 4"), devices.PCA_PPA, device_commands.Button_241, 241, 0, 1)
elements["PTN_243"] = default_button(_("PCA Button 5"), devices.PCA_PPA, device_commands.Button_243, 243, 0, 1)

elements["PTN_245"] = default_button(_("Gun Mode Button"), devices.PCA_PPA, device_commands.Button_245, 245, 0, 1)

elements["PTN_250"] = default_button(_("Weapons Selector Button 1"), devices.PCA_PPA, device_commands.Button_250, 250, 0, 1)
elements["PTN_253"] = default_button(_("Weapons Selector Button 2"), devices.PCA_PPA, device_commands.Button_253, 253, 0, 1)
elements["PTN_256"] = default_button(_("Weapons Selector Button 3"), devices.PCA_PPA, device_commands.Button_256, 256, 0, 1)
elements["PTN_259"] = default_button(_("Weapons Selector Button 4"), devices.PCA_PPA, device_commands.Button_259, 259, 0, 1)
elements["PTN_262"] = default_button(_("Weapons Selector Button 5"), devices.PCA_PPA, device_commands.Button_262, 262, 0, 1)

elements["PTN_266"] = default_button(_("S530 Standby"), devices.PCA_PPA, device_commands.Button_266, 266, 0, 1)
elements["PTN_269"] = default_button(_("AUTO/MAN Button"), devices.PCA_PPA, device_commands.Button_269, 269, 0, 1)
elements["PTN_272"] = default_button(_("MAGIC Standby"), devices.PCA_PPA, device_commands.Button_272, 272, 0, 1)
elements["PTN_279"] = default_button(_("530D/Rockets/Guns Firing Mode Selector"), devices.PCA_PPA, device_commands.Button_279, 279, 0, 1)

elements["PTN_265"] = default_3_position_tumb_animated(_("Missile Selector Switch"), devices.PCA_PPA, device_commands.Button_265, 265, false, false)
elements["PTN_275"] = default_2_way_spring_switch(_("PPA Test Switch"), devices.PCA_PPA, device_commands.Button_275, 275, false)
elements["PTN_276"] = multiposition_switch_limited_animated(_("Bomb Fuze Selector Switch"), devices.PCA_PPA, device_commands.Button_276, 276, 3, 0.5, true, 0)
elements["PTN_277"] = default_2_way_spring_switch(_("Bomb Release Quantity Selector Switch"), devices.PCA_PPA, device_commands.Button_277, 277, true)
elements["PTN_278"] = default_2_way_spring_switch(_("Bomb Release Interval Selector Switch"), devices.PCA_PPA, device_commands.Button_278, 278, true)

elements["PTN_409"] = default_button(_("Emergency Jettison"), devices.PCA_PPA, device_commands.Button_409, 409, 0, 1)

--AFCS
elements["PTN_282"] = default_button(_("Autopilot Master Button"), devices.AFCS, device_commands.Button_282, 282, 0, 1)
elements["PTN_285"] = default_button(_("Altitude Hold Button"), devices.AFCS, device_commands.Button_285, 285, 0, 1)
elements["PTN_288"] = default_button(_("Selected Altitude Hold Button"), devices.AFCS, device_commands.Button_288, 288, 0, 1)
elements["PTN_294"] = default_button(_("Approach Hold Button"), devices.AFCS, device_commands.Button_294, 294, 0, 1)
elements["PTN_302"] = default_button(_("Autopilot Lights Test Button"), devices.AFCS, device_commands.Button_302, 302, 0, 1)
elements["PTN_299"] = default_multiposition_knob_animated(_("Altitude 10,000 ft Selector"), devices.AFCS, device_commands.Button_299, 299,  6, 0.1, false, 0)
elements["PTN_300"] = default_multiposition_knob_animated(_("Altitude 1,000 ft Selector"),  devices.AFCS, device_commands.Button_300, 300, 10, 0.1, false, 0)
elements["PTN_301"] = default_multiposition_knob_animated(_("Altitude 100 ft Selector"),  devices.AFCS, device_commands.Button_301, 301, 10, 0.1, false4, 0)
elements["PTN_514"] = default_2_position_tumb_animated(_("Autopilot Test Switch Cover"),  devices.AFCS, device_commands.Button_514, 514)
elements["PTN_515"] = default_2_position_tumb_animated(_("Autopilot Test Switch"),  devices.AFCS, device_commands.Button_515, 515)
elements["PTN_516"] = default_2_position_tumb_animated(_("FBW Test Switch Cover"),  devices.AFCS, device_commands.Button_516, 516)
elements["PTN_517"] = multiposition_switch_limited_animated(_("FBW Test Switch"),  devices.AFCS, device_commands.Button_517, 517, 3, 0.5, false, 0)
elements["PTN_479"]	= default_2_position_tumb_animated(_("FBW Channel 5 Switch Cover"), devices.AFCS, device_commands.Button_479, 479)
elements["PTN_480"]	= default_2_position_tumb_animated(_("FBW Channel 5 Switch"), devices.AFCS, device_commands.Button_480, 480)
elements["PTN_508"] = default_animated_lever(_("Trim Control Mode Dial"), devices.AFCS, device_commands.Button_508, 508,5.0)
elements["PTN_509"] = default_2_way_spring_switch(_("Rudder Trim Paddle"), devices.AFCS, device_commands.Button_509, 509,true)

--FBW
elements["PTN_330"] = default_2_position_tumb_animated(_("FBW Spin Mode Switch"), devices.ENGINE, device_commands.Button_330, 330)
elements["PTN_420"] = default_2_position_tumb_animated(_("FBW Gain Mode Switch Cover"),  devices.ENGINE, device_commands.Button_420, 420)
elements["PTN_421"] = default_2_position_tumb_animated(_("FBW Gain Mode Switch"),  devices.ENGINE, device_commands.Button_421, 421)
elements["PTN_422"] = default_2_position_tumb_animated(_("FBW G-Limiter Switch"),  devices.ENGINE, device_commands.Button_422, 422)
elements["PTN_423"] = default_button(_("FBW Reset Button"),  devices.AFCS, device_commands.Button_423, 423)

-- HSI
elements["PTN_340"] = default_axis_cycle("HSI VAD Selector",devices.NAVINST, device_commands.Button_340, 340)
elements["PTN_341"] = multiposition_switch_limited_animated(_("HSI Mode Selector Switch"), devices.NAVINST, device_commands.Button_341, 341, 7, 0.1, false, 0)

-- PELLES, SOURIES AND BECS
elements["PTN_460"] = default_2_position_tumb_animated(_("Intake Slats Operation Switch"), devices.ENGINE, device_commands.Button_460, 460)
elements["PTN_461"] = default_2_position_tumb_animated(_("Intake Cones Operation Switch"), devices.ENGINE, device_commands.Button_461, 461)
elements["PTN_462"] = default_3_position_tumb_animated(_("Slats Operation Switch"), devices.SUBSYSTEMS, device_commands.Button_462, 462, false, true)
elements["PTN_396"] = default_axis_limited("Pedal Adjustment Lever",devices.SUBSYSTEMS,device_commands.Button_396,396, 0.5, -0.1, true, 0)
elements["PTN_395"] = default_2_position_tumb_animated(_("Hydraulic System Selector"), devices.SUBSYSTEMS, device_commands.Button_395, 395)

-- RADAR
elements["PTN_481"] = multiposition_switch_limited_animated(_("Radar Illumination Switch"), devices.RADAR, device_commands.Button_481, 481, 4, 0.5, false, -1)
elements["PTN_482"] = default_button(_("Radar Test Button"), devices.RADAR, device_commands.Button_482, 482, 0, 1)
elements["PTN_483"] = default_button(_("Radar Rearm Button"), devices.RADAR, device_commands.Button_483, 483, 0, 1)
elements["PTN_484"] = default_2_position_tumb_animated(_("Radar Doppler Reject Switch"), devices.RADAR, device_commands.Button_484, 484, 3, 0.5, false, 0)
elements["PTN_485"] = multiposition_switch_limited_animated(_("Radar Contrast Switch"), devices.RADAR, device_commands.Button_485, 485, 4, 0.5, false, -1)
elements["PTN_486"] = multiposition_switch_limited_animated(_("Radar Power Selector"), devices.RADAR, device_commands.Button_486, 486, 4, 0.33, false, 0)
elements["PTN_488"] = default_axis_limited(_("Radar Gain Dial"), devices.RADAR, device_commands.Button_488, 488, 10, 0.3, false, 0)
elements["PTN_491"] = default_2_position_tumb_animated(_("A/G Radar A Mode Switch"), devices.RADAR, device_commands.Button_491, 491, 0, 1)
elements["PTN_493"] = default_2_position_tumb_animated(_("A/G Radar DEC Mode Switch"), devices.RADAR, device_commands.Button_493, 493, 0, 1)
elements["PTN_495"] = default_2_position_tumb_animated(_("A/G Radar VISU Mode Switch"), devices.RADAR, device_commands.Button_495, 495, 0, 1)
elements["PTN_499"] = default_2_position_tumb_animated(_("Radar Grid Selector Switch"), devices.RADAR, device_commands.Button_499, 499, 0, 1)
elements["PTN_500"] = default_2_position_tumb_animated(_("Target Memory Time Selector Switch"), devices.RADAR, device_commands.Button_500, 500, 0, 1)
elements["PTN_502"] = multiposition_switch_limited_animated(_("Radar Scan Lines Selector"), devices.RADAR, device_commands.Button_502, 502, 3, 0.5, true, 0)
elements["PTN_503"] = default_2_way_spring_switch(_("Radar Range Selector Switch"), devices.RADAR, device_commands.Button_503, 503,true)
elements["PTN_504"] = default_button(_("A/A Radar STT Selector Button"), devices.RADAR, device_commands.Button_504, 504, 0, 1)
elements["PTN_506"] = multiposition_switch_limited_animated(_("Radar Azimuth Selector"), devices.RADAR, device_commands.Button_506, 506, 3, 0.5, false, 0)
elements["PTN_109"] = default_3_position_tumb_animated(_("Radar PRF Switch"), devices.RADAR, device_commands.Button_109, 109, false, true)
elements["PTN_710"] = default_2_position_tumb_animated(_("TDC Mode Switch"), devices.RADAR, device_commands.Button_710, 710, 0, 1)

-- RADAR IFF
elements["PTN_598"] = multiposition_switch_limited_animated(_("Radar IFF Mode Switch"),   devices.RADAR, device_commands.Button_598, 598, 6, 0.2, false, 0)
elements["PTN_599"] = default_2_position_tumb_animated(_("Radar IFF L/R Selector"),       devices.RADAR, device_commands.Button_599, 599, 0, 1)
elements["PTN_600"] = multiposition_switch_limited_animated(_("Radar IFF Power Switch"),  devices.RADAR, device_commands.Button_600, 600, 3, 0.5, false, 0)
elements["PTN_601"] = default_multiposition_knob_animated(_("Radar IFF Code-4 Selector"), devices.RADAR, device_commands.Button_601, 601, 10, 0.1, false, 0)
elements["PTN_602"] = default_multiposition_knob_animated(_("Radar IFF Code-3 Selector"), devices.RADAR, device_commands.Button_602, 602, 10, 0.1, false, 0)
elements["PTN_603"] = default_multiposition_knob_animated(_("Radar IFF Code-2 Selector"), devices.RADAR, device_commands.Button_603, 603, 10, 0.1, false, 0)
elements["PTN_604"] = default_multiposition_knob_animated(_("Radar IFF Code-1 Selector"), devices.RADAR, device_commands.Button_604, 604, 10, 0.1, false, 0)

-- ELECTRICAL PANEL
elements["PTN_520"]	= default_2_position_tumb_animated(_("Main Battery Switch"),devices.PWRPNL, device_commands.Button_520, 520)
elements["PTN_521"]	= default_2_position_tumb_animated(_("Electric Power Transfer Switch"),devices.PWRPNL, device_commands.Button_521, 521)
elements["PTN_522"]	= default_2_position_tumb_animated(_("Alternator 1 Switch"),devices.PWRPNL, device_commands.Button_522, 522)
elements["PTN_523"]	= default_2_position_tumb_animated(_("Alternator 2 Switch"),devices.PWRPNL, device_commands.Button_523, 523)
elements["PTN_524"]	= default_2_way_spring_switch(_("Lights Test Switch"),devices.PWRPNL, device_commands.Button_524, 524,true)
elements["PTN_654"]	= default_2_position_tumb_animated(_("Alert Network (QRA) Switch"),devices.PWRPNL, device_commands.Button_654, 654)

-- PCN
elements["PTN_570"] = default_button(_("INS PREP Switch"),     devices.PCN_NAV, device_commands.Button_570, 570, 0, 1)
elements["PTN_572"] = default_button(_("INS DEST Switch"),     devices.PCN_NAV, device_commands.Button_572, 572, 0, 1)
elements["PTN_576"] = default_button(_("Offset Waypoint/Target"), devices.PCN_NAV, device_commands.Button_576, 576, 0, 1)
elements["PTN_578"] = default_button(_("INS Update"),             devices.PCN_NAV, device_commands.Button_578, 578, 0, 1)
elements["PTN_580"] = default_button(_("Validate Data Entry"),    devices.PCN_NAV, device_commands.Button_580, 580, 0, 1)
elements["PTN_582"] = default_button(_("Mark Position"),          devices.PCN_NAV, device_commands.Button_582, 582, 0, 1)
elements["PTN_667"] = default_button(_("AUTO Navigation"),        devices.PCN_NAV, device_commands.Button_667, 667, 0, 1)
elements["PTN_574"] = default_multiposition_knob_animated(_("INS Parameter Selector"), devices.PCN_NAV, device_commands.Button_574,	 574, 11, 0.1, false, 0)
elements["PTN_575"]	= default_axis_limited(_("Light Brightnes Control/Test"), devices.SYSLIGHTS, device_commands.Button_575, 575, 10, 0.1, false, 0)
elements["PTN_584"] = default_button(_("INS Button 1"), devices.PCN_NAV, device_commands.Button_584, 584, 0, 1)
elements["PTN_585"] = default_button(_("INS Button 2"), devices.PCN_NAV, device_commands.Button_585, 585, 0, 1)
elements["PTN_586"] = default_button(_("INS Button 3"), devices.PCN_NAV, device_commands.Button_586, 586, 0, 1)
elements["PTN_587"] = default_button(_("INS Button 4"), devices.PCN_NAV, device_commands.Button_587, 587, 0, 1)
elements["PTN_588"] = default_button(_("INS Button 5"), devices.PCN_NAV, device_commands.Button_588, 588, 0, 1)
elements["PTN_589"] = default_button(_("INS Button 6"), devices.PCN_NAV, device_commands.Button_589, 589, 0, 1)
elements["PTN_590"] = default_button(_("INS Button 7"), devices.PCN_NAV, device_commands.Button_590, 590, 0, 1)
elements["PTN_591"] = default_button(_("INS Button 8"), devices.PCN_NAV, device_commands.Button_591, 591, 0, 1)
elements["PTN_592"] = default_button(_("INS Button 9"), devices.PCN_NAV, device_commands.Button_592, 592, 0, 1)
elements["PTN_593"] = default_button(_("INS Button 0"), devices.PCN_NAV, device_commands.Button_593, 593, 0, 1)
elements["PTN_594"] = default_button(_("INS Clear Button"), devices.PCN_NAV, device_commands.Button_594, 594, 0, 1)
elements["PTN_596"] = default_button(_("INS ENTER Button"), devices.PCN_NAV, device_commands.Button_596, 596, 0, 1)

-- PSM
elements["PTN_627"] = multiposition_switch_limited_animated(_("INS Mode Selector"), devices.PCN_NAV, device_commands.Button_627, 627, 8, 0.1, false, 0)
elements["PTN_629"] = multiposition_switch_limited_animated(_("INS Operational Mode"), devices.PCN_NAV, device_commands.Button_629, 629, 5, 0.1, true, 0)
elements["PTN_665"] = multiposition_switch_limited_animated(_("INS Auxiliary Heading/Horizon"), devices.PCN_NAV, device_commands.Button_665, 665, 3, 0.5, false, 0)

-- EW PANEL
elements["PTN_228"]	= default_axis_limited(_("RWR Light Brightnes Control"), devices.SYSLIGHTS, device_commands.Button_228, 228, 10, 0.1, false, 0)
elements["PTN_605"] = default_3_position_tumb_animated(_("EW Mode Selector Switch"), devices.RWR, device_commands.Button_605, 605, false, true)
elements["PTN_606"] = multiposition_switch_limited_animated(_("BR Power Switch"), devices.RWR, device_commands.Button_606, 606, 3, 0.5, false, 0)
elements["PTN_607"] = multiposition_switch_limited_animated(_("RWR Power Switch"), devices.RWR, device_commands.Button_607, 607, 3, 0.5, false, 0)
elements["PTN_608"] = multiposition_switch_limited_animated(_("D2M Power Switch"), devices.DDM_IND, device_commands.Button_608, 608, 3, 0.5, false, 0)
elements["PTN_609"] = multiposition_switch_limited_animated(_("Decoy Release Mode Switch"), devices.RWR, device_commands.Button_609, 609, 3, 0.5, false, 0)
elements["PTN_610"] = multiposition_switch_limited_animated(_("Decoy Release Program Knob"), devices.RWR, device_commands.Button_610, 610, 11, 0.1, false, 0)

-- ECM BOX
elements["PTN_194"] = multiposition_switch_limited_animated(_("ECM Box Mode Switch"), devices.RWR, device_commands.Button_194, 194, 3, 0.5, false, 0)
elements["PTN_195"]	= default_2_position_tumb_animated(_("ECM Box Switch"), devices.RWR, device_commands.Button_195, 195)
elements["PTN_196"]	= default_2_position_tumb_animated(_("ECM Box Lights Switch"), devices.RWR, device_commands.Button_196, 196)
elements["PTN_197"]	= default_axis_limited(_("ECM Box LCD Display Brightness"), devices.RWR, device_commands.Button_197, 197, 5, 0.5, false, 0)

-- Panel Lights
elements["PTN_449"]	= default_2_position_tumb_animated(_("Police Lights Switch"), devices.SYSLIGHTS, device_commands.Button_449, 449)
elements["PTN_450"]	= multiposition_switch_limited_animated(_("Landing Lights Switch"), devices.SYSLIGHTS, device_commands.Button_450, 450, 3, 0.5, false, 0)
elements["PTN_452"]	= multiposition_switch_limited_animated(_("SERPAM Recorder Switch"), devices.SYSLIGHTS, device_commands.Button_452, 452, 3, 0.5, false, 0)
elements["PTN_453"]	= multiposition_switch_limited_animated(_("Anti-Collision Lights Switch"), devices.SYSLIGHTS, device_commands.Button_453, 453, 3, 0.5, false, 0)
elements["PTN_454"]	= multiposition_switch_limited_animated(_("Navigation Lights Switch"), devices.SYSLIGHTS, device_commands.Button_454, 454, 3, 0.5, false, 0)
elements["PTN_455"]	= multiposition_switch_limited_animated(_("Formation Lights Switch"), devices.SYSLIGHTS, device_commands.Button_455, 455, 3, 0.5, false, 0)
elements["PTN_639"]	= default_axis_limited(_("Dashboard U.V. Lights Knob"), devices.SYSLIGHTS, device_commands.Button_639, 639, 10, 0.3, false, 0)
elements["PTN_640"]	= default_axis_limited(_("Dashboard Panel Lights Knob"), devices.SYSLIGHTS, device_commands.Button_640, 640, 10, 0.3, false, 0)
elements["PTN_641"]	= default_axis_limited(_("Red Flood Lights Knob"), devices.SYSLIGHTS, device_commands.Button_641, 641, 10, 0.3, false, 0)
elements["PTN_642"]	= default_axis_limited(_("Console Panel Lights Knob"), devices.SYSLIGHTS, device_commands.Button_642, 642, 10, 0.3, false, 0)
elements["PTN_643"]	= default_axis_limited(_("Casution/Advisory Lights Rheostat"), devices.SYSLIGHTS, device_commands.Button_643, 643, 10, 0.3, false, 0)
elements["PTN_644"]	= default_axis_limited(_("White Flood Lights Knob"), devices.SYSLIGHTS, device_commands.Button_644, 644, 10, 0.3, false, 0)
elements["PTN_920"] = default_axis_limited(_("Refuel Lights Brightness Knob"),devices.SYSLIGHTS,device_commands.Button_920, 920, 10, 0.3, false, 0)

-- Engine Start Panel
elements["PTN_468"]	= default_2_position_tumb_animated(_("Engine In-Flight Start Switch"), devices.ENGPANEL, device_commands.Button_468, 468, 0, 1)
elements["PTN_467"] = default_button(_("Engine Shutdown Button"), devices.ENGPANEL, device_commands.Button_467, 467)
elements["PTN_645"]	= default_2_position_tumb_animated(_("Engine Start Switch Cover"), devices.ENGPANEL, device_commands.Button_645, 645)
elements["PTN_646"]	= default_2_position_tumb_animated(_("Starter Fuel Pump Switch"), devices.ENGPANEL, device_commands.Button_646, 646)
elements["PTN_647"]	= default_2_position_tumb_animated(_("Engine Fuel Left Boost Pump Switch"), devices.INSTPANEL, device_commands.Button_647, 647)
elements["PTN_648"]	= default_2_position_tumb_animated(_("Engine Fuel Right Boost Pump Switch"), devices.INSTPANEL, device_commands.Button_648, 648)
elements["PTN_649"]	= default_button(_("Engine Start Switch"), devices.ENGPANEL, device_commands.Button_649, 649, 0, 1)
elements["PTN_650"] = multiposition_switch_limited_animated(_("Ventilation Selector Switch"), devices.ENGPANEL, device_commands.Button_650, 650, 3, 0.50, false, 0)
elements["PTN_651"]	= default_2_position_tumb_animated(_("Fuel Cutoff Switch Cover"), devices.ENGPANEL, device_commands.Button_651, 651)
elements["PTN_652"]	= default_2_position_tumb_animated(_("Fuel Cutoff Switch"), devices.ENGPANEL, device_commands.Button_652, 652)
elements["PTN_477"]	= default_2_position_tumb_animated(_("Fuel Dump Switch Cover"), devices.INSTPANEL, device_commands.Button_477, 477)
elements["PTN_478"]	= default_2_position_tumb_animated(_("Fuel Dump Switch"), devices.INSTPANEL, device_commands.Button_478, 478)
elements["PTN_471"]	= default_2_position_tumb_animated(_("A/B Emergency Cutoff Switch Cover"), devices.INSTPANEL, device_commands.Button_471, 471)
elements["PTN_472"]	= default_2_position_tumb_animated(_("A/B Emergency Cutoff Switch"), devices.INSTPANEL, device_commands.Button_472, 472)
elements["PTN_464"]	= default_2_position_tumb_animated(_("Emergency Throttle Cover"), devices.ENGPANEL, device_commands.Button_464, 464)
elements["PTN_465"] = default_axis_limited(_("Emergency Throttle Handle"),devices.ENGPANEL,device_commands.Button_465,465, 0.8, 0.5, true, false, {0.0, 1.0})
elements["PTN_473"]	= default_2_position_tumb_animated(_("Secondary Oil Control Cover"), devices.ENGPANEL, device_commands.Button_473, 473)
elements["PTN_474"]	= default_2_position_tumb_animated(_("Secondary Oil Control Switch"), devices.ENGPANEL, device_commands.Button_474, 474)
elements["PTN_475"]	= default_2_position_tumb_animated(_("Engine Emergency Control Cover"), devices.ENGPANEL, device_commands.Button_475, 475)
elements["PTN_476"]	= multiposition_switch_limited_animated(_("Engine Emergency Control Switch"), devices.ENGPANEL, device_commands.Button_476, 476,3, 0.5, true, 0)

-- Fuel Panel
elements["PTN_193"]	= multiposition_switch_limited_animated(_("Refuel Transfer Switch"), devices.ENGPANEL, device_commands.Button_193, 193, 3, 0.5, false, 0)
elements["PTN_360"] = default_multiposition_knob_animated(_("Bingo Fuel 1,000 kg Selector"), devices.INSTPANEL, device_commands.Button_360, 360,  10, 0.1, false, 0)
elements["PTN_361"] = default_multiposition_knob_animated(_("Bingo Fuel 100 kg Selector"), devices.INSTPANEL, device_commands.Button_361, 361,  10, 0.1, false, 0)
elements["PTN_357"]	= default_2_position_tumb_animated(_("Fuel Crossfeeed Switch"), devices.INSTPANEL, device_commands.Button_357, 357)

-- Radio Panel
elements["PTN_429"]	= default_2_position_tumb_animated(_("UHF Power 5W/25W Switch"), devices.UHF, device_commands.Button_429, 429)
elements["PTN_430"]	= default_2_position_tumb_animated(_("UHF SIL Switch"), devices.UHF, device_commands.Button_430, 430)
elements["PTN_431"]	= default_2_way_spring_switch(_("UHF E+A2 Switch"), devices.UHF, device_commands.Button_431, 431, true)
elements["PTN_432"]	= default_button(_("UHF CDE Switch"), devices.UHF, device_commands.Button_432, 432)
elements["PTN_433"] = multiposition_switch_limited_animated(_("UHF Mode Switch"), devices.UHF, device_commands.Button_433, 433, 4, 0.25, false, 0)
elements["PTN_434"]	= default_button(_("UHF TEST Switch"), devices.UHF, device_commands.Button_434, 434)
elements["PTN_435"]	= default_multiposition_knob_animated(_("UHF Knob"), devices.UHF, device_commands.Button_435, 435, 20, 0.05,false,0.05)
elements["PTN_437"]	= default_button(_("U/VHF TEST Switch"), devices.UVHF, device_commands.Button_437, 437)
elements["PTN_438"]	= default_2_way_spring_switch(_("U/VHF E+A2 Switch"), devices.UVHF, device_commands.Button_438, 438, true)
elements["PTN_439"]	= default_2_position_tumb_animated(_("U/VHF SIL Switch"), devices.UVHF, device_commands.Button_439, 439)
elements["PTN_440"] = default_multiposition_knob_animated(_("U/VHF 100 MHz Selector"), devices.UVHF, device_commands.Button_440, 440, 4, 0.1, false, 0)
elements["PTN_441"] = default_multiposition_knob_animated(_("U/VHF 10 MHz Selector"), devices.UVHF, device_commands.Button_441, 441, 10, 0.1, false, 0)
elements["PTN_442"] = default_multiposition_knob_animated(_("U/VHF 1 MHz Selector"), devices.UVHF, device_commands.Button_442, 442, 10, 0.1, false, 0)
elements["PTN_443"] = default_multiposition_knob_animated(_("U/VHF 100 KHz Selector"), devices.UVHF, device_commands.Button_443, 443, 10, 0.1, false, 0)
elements["PTN_444"] = default_multiposition_knob_animated(_("U/VHF 25 KHz Selector"), devices.UVHF, device_commands.Button_444, 444, 4, 0.25, false, 0)
elements["PTN_445"]	= default_multiposition_knob_animated(_("U/VHF Knob"), devices.UVHF, device_commands.Button_445, 445, 20, 0.05,false,0.05)
elements["PTN_446"] = multiposition_switch_limited_animated(_("U/VHF Mode Switch 1"), devices.UVHF, device_commands.Button_446, 446, 5, 0.25, false, 0)
elements["PTN_447"]	= default_2_position_tumb_animated(_("U/VHF Power 5W/25W Switch"), devices.UVHF, device_commands.Button_447, 447)
elements["PTN_448"] = multiposition_switch_limited_animated(_("U/VHF Manual/Preset Mode Selector"), devices.UVHF, device_commands.Button_448, 448, 3, 0.50, false, 0)

-- Navigational Antennas
elements["PTN_616"] = default_multiposition_knob_animated(_("VOR/ILS Frequency Change Whole"),devices.VORILS,device_commands.Button_616,616, 11, 0.1, false, 0)
elements["PTN_617"] = default_2_position_tumb_animated(_("VOR/ILS Power Dial"), devices.VORILS,device_commands.Button_617,617)
elements["PTN_618"] = default_multiposition_knob_animated(_("VOR/ILS Frequency Change Decimal"),devices.VORILS,device_commands.Button_618,618, 20, 0.05,false,0.0)
elements["PTN_619"] = default_2_position_tumb_animated(_("VOR/ILS Test Dial"), devices.VORILS,device_commands.Button_619,619)
elements["PTN_623"] = default_multiposition_knob_animated(_("TACAN Channel 10 Selector"),devices.TACAN,device_commands.Button_623,623, 13, 0.076923, false, 0.0)
elements["PTN_624"] = default_2_position_tumb_animated(_("TACAN X/Y Select"),devices.TACAN,device_commands.Button_624,624)
elements["PTN_625"] = default_multiposition_knob_animated(_("TACAN Channel 1 Selector"),devices.TACAN,device_commands.Button_625,625, 10, 0.1, false, 0)
elements["PTN_626"] = multiposition_switch_limited_animated(_("TACAN Mode Select"), devices.TACAN, device_commands.Button_626, 626, 4, 0.33, false, 0)


-- Miscelaneous Left Panel
elements["PTN_400"] = default_2_position_tumb_animated(_("Cockpit Clock"), devices.MISCPANELS, device_commands.Button_400, 400)
elements["PTN_191"] = default_button(_("Audio Warning Reset"), devices.SYSLIGHTS, Keys.PlaneResetMasterWarning, 191, 0, 1)
elements["PTN_458"]	= default_2_position_tumb_animated(_("Anti-Skid Switch Cover"), devices.MISCPANELS, device_commands.Button_458, 458)
elements["PTN_459"]	= default_2_position_tumb_animated(_("Anti-Skid Switch"), devices.MISCPANELS, device_commands.Button_459, 459)
elements["PTN_666"]	= default_animated_lever(_("Parking Brake Lever"), devices.MISCPANELS, device_commands.Button_666, 666,5.0)
elements["PTN_456"]	= default_animated_lever(_("Canopy Jettison"),devices.SUBSYSTEMS, device_commands.Button_456, 456,5.0)
elements["PTN_457"]	= default_animated_lever(_("Drag Chute Lever"), devices.MISCPANELS, device_commands.Button_457, 457,5.0)
elements["PTN_807"] = default_2_way_spring_switch(_("Nose Wheel Steering / IFF Interrogation Button"), devices.MISCPANELS, device_commands.Button_807, 807)
elements["PTN_655"]	= default_2_position_tumb(_("Canopy Lock"),devices.SUBSYSTEMS, device_commands.Button_655, 655)
elements["PTN_656"] = default_multiposition_animated_lever(_("Canopy Lock/Neutral/Lower Lever"), devices.SUBSYSTEMS, device_commands.Button_656, 656, 3, 0.5, false, 0,2.5)
elements["PTN_905"] = default_2_position_tumb_animated(_("Emergency Compass"),devices.PCN_NAV, device_commands.Button_905, 905)
elements["PTN_907"]	= default_2_position_tumb(_("Canopy Handle"),devices.SUBSYSTEMS, device_commands.Button_907, 907)
elements["PTN_908"]	= default_2_position_tumb(_("Canopy Handle"),devices.SUBSYSTEMS, device_commands.Button_908, 908)
elements["PTN_909"] = default_2_position_tumb(_("Mirror Rendering Toggle"), devices.MISCPANELS, device_commands.Button_909, 909)

-- Miscelaneous Right Panel
elements["PTN_657"]	= multiposition_switch_spring(_("Emergency Hydraulic Pump Switch"), devices.ENGINE, device_commands.Button_657, device_commands.Button_657, 657)
elements["PTN_658"]	= default_2_position_tumb_animated(_("Audio Warning Switch"), devices.SYSLIGHTS, device_commands.Button_658, 658)
elements["PTN_659"] = default_2_position_tumb_animated(_("Pitot Heat Cover"), devices.MISCPANELS, device_commands.Button_659, 659)
elements["PTN_660"] = default_2_position_tumb_animated(_("Pitot Heat Switch"), devices.MISCPANELS, device_commands.Button_660, 660)

-- Miscelaneous Seat
elements["PTN_900"] = default_2_way_spring_switch(_("Seat Adjustment Switch"), devices.MISCPANELS, device_commands.Button_900, 900,true)
elements["PTN_910"] = default_2_position_tumb_animated(_("LOX Dilution Lever"),devices.ECS, device_commands.Button_910,  910)
elements["PTN_912"] = default_2_position_tumb_animated(_("LOX Emergency Supply"), devices.ECS, device_commands.Button_912, 912)
elements["PTN_911"] = { class       = {class_type.TUMB, class_type.BTN},
                        hint        = _("LOX Test Switch") , 
                        device      = devices.ECS, 
                        arg         = {911, 911},
                        arg_value   = {0, 1.0},
                        arg_lim     = {{0, 0.5},{0.5, 1.0}},
                        action      = {device_commands.Button_911,device_commands.Button_911},
                        stop_action = {0, device_commands.Button_911}, 
                        stop_value  = {nil, 0.5},                                   
                        use_release_message = {false, true}}

-- Sound Panel
elements["PTN_700"] = default_2_position_tumb_animated(_("AMPLIS Selector Knob"), devices.SYSLIGHTS, device_commands.Button_700, 700)
elements["PTN_701"] = default_axis_limited(_("VOR/ILS Volume Knob"), devices.SYSLIGHTS, device_commands.Button_701, 701, 0.8, 0.5, true, false, {0.0, 1.0})
elements["PTN_702"] = default_axis_limited(_("TACAN Volume Knob"), devices.SYSLIGHTS, device_commands.Button_702, 702, 0.8, 0.5, true, false, {0.0, 1.0})
elements["PTN_703"] = default_axis_limited(_("MAGIC Tone Volume Knob"), devices.SYSLIGHTS, device_commands.Button_703, 703, 0.8, 0.5, true, false, {0.0, 1.0})
elements["PTN_704"] = default_axis_limited(_("TB APP Volume Knob"), devices.SYSLIGHTS, device_commands.Button_704, 704, 0.8, 0.5, true, false, {0.0, 1.0})
elements["PTN_705"] = default_axis_limited(_("Marker Signal Volume Knob"), devices.SYSLIGHTS, device_commands.Button_705, 705, 0.8, 0.5, true, false, {0.0, 1.0})
elements["PTN_706"] = default_axis_limited(_("UHF Radio Volume Knob"), devices.SYSLIGHTS, device_commands.Button_706, 706, 0.8, 0.5, true, false, {0.0, 1.0})
elements["PTN_707"] = default_axis_limited(_("V/UHF Radio Volume Knob"), devices.SYSLIGHTS, device_commands.Button_707, 707, 0.8, 0.5, true, false, {0.0, 1.0})

-- Flight Instruments
elements["PTN_309"] = default_axis(_("Barometric Pressure Calibration"),devices.FLIGHTINST,device_commands.Button_309,309)
elements["PTN_314"]	= default_2_position_tumb_animated(_("ADI Cage Lever"),devices.FLIGHTINST, device_commands.Button_314, 314)
elements["PTN_315"] = default_2_position_tumb_animated(_("ADI Backlight Switch"),devices.FLIGHTINST,device_commands.Button_315,315)
elements["PTN_325"] = { 
	class				= {class_type.BTN, class_type.LEV}, 
	hint				= _("Backup ADI Cage/Pitch Adjust Knob"), 
	device				= devices.FLIGHTINST, 
	action				= {device_commands.Button_325, device_commands.Button_328}, 
	stop_action			= {device_commands.Button_325, 0}, 
	is_repeatable		= {}, 
	arg					= {325, 328}, 
	arg_value			= {1.0, 0.0}, 
	arg_lim				= {{0, 1}, {-1, 1}}, 
	relative			= {false,false},
	gain				= {1.0, 0.5}, 
	use_release_message	= {true, false}, 
	use_OBB				= true,
	animated			= {true,true},
	animation_speed		= {anim_speed_default,anim_speed_default},
	cycle				= false,
	}
    
-- ECS Panel
elements["PTN_630"]	= default_2_position_tumb_animated(_("ECS Main Mode Switch"),devices.ECS, device_commands.Button_630, 630)
elements["PTN_631"]	= default_button(_("ECS C Button"), devices.ECS, device_commands.Button_631, 631, 1, 1)
elements["PTN_633"]	= default_button(_("ECS F Button"), devices.ECS, device_commands.Button_633, 633, 1, 1)
elements["PTN_635"]	= default_2_position_tumb_animated(_("ECS Cond Switch"),devices.ECS, device_commands.Button_635, 635)
elements["PTN_636"]	= default_2_position_tumb_animated(_("ECS Air Exchange Switch"),devices.ECS, device_commands.Button_636, 636)
elements["PTN_637"] = default_axis_limited_cycle(_("ECS Temperature Select Knob"), devices.ECS, device_commands.Button_637, 637, 0.8, 0.5, true, false, {-1.0, 1.0})
elements["PTN_638"]	= default_2_position_tumb_animated(_("ECS Defog Switch"),devices.ECS, device_commands.Button_638, 638)

-- IFF
elements["PTN_377"] = default_multiposition_knob_animated(_("Mode-1 Tens Selector"), devices.INSTPANEL, device_commands.Button_377, 377,  10, 0.1, false, 0)
elements["PTN_378"] = default_multiposition_knob_animated(_("Mode-1 Ones Selector"), devices.INSTPANEL, device_commands.Button_378, 378,  10, 0.1, false, 0)
elements["PTN_379"] = default_multiposition_knob_animated(_("Mode-3A Thousands Selector"), devices.INSTPANEL, device_commands.Button_379, 379,  10, 0.1, false, 0)
elements["PTN_380"] = default_multiposition_knob_animated(_("Mode-3A Hundreds Selector"), devices.INSTPANEL, device_commands.Button_380, 380,  10, 0.1, false, 0)
elements["PTN_381"] = default_multiposition_knob_animated(_("Mode-3A Tens Selector"), devices.INSTPANEL, device_commands.Button_381, 381,  10, 0.1, false, 0)
elements["PTN_382"] = default_multiposition_knob_animated(_("Mode-3A Ones Selector"), devices.INSTPANEL, device_commands.Button_382, 382,  10, 0.1, false, 0)
elements["PTN_383"] = default_3_position_tumb_animated(_("Ident Power Switch"), devices.INSTPANEL, device_commands.Button_383, 383, false, false)
elements["PTN_384"] = default_2_position_tumb_animated(_("Mode-1 Switch"), devices.INSTPANEL, device_commands.Button_384, 384)
elements["PTN_385"] = default_2_position_tumb_animated(_("Mode-2 Switch"), devices.INSTPANEL, device_commands.Button_385, 385)
elements["PTN_386"] = default_2_position_tumb_animated(_("Mode-3A Switch"), devices.INSTPANEL, device_commands.Button_386, 386)
elements["PTN_387"] = default_2_position_tumb_animated(_("Mode-C Switch"), devices.INSTPANEL, device_commands.Button_387, 387)


-- Add more lines in command_defs.lua if needed

for i,o in pairs(elements) do
	if  o.class[1] == class_type.TUMB or
	   (o.class[2]  and o.class[2] == class_type.TUMB) or
	   (o.class[3]  and o.class[3] == class_type.TUMB)  then
	   o.updatable = true
	   o.use_OBB   = true
	end
end
