BACKGROUND_TYPE_AIR = 0 --look-up or look-down if self and target above the fog and overcast
BACKGROUND_TYPE_LAND = 1
BACKGROUND_TYPE_FOREST = 2
BACKGROUND_TYPE_ROAD = 3
BACKGROUND_TYPE_RUNWAY = 4
BACKGROUND_TYPE_WATER = 5

DET_EVENT_MG_SHOOT = 1
DET_EVENT_SMALL_CALIBER_CANNON_SHOOT = 2
DET_EVENT_MEDIUM_CALIBER_CANNON_SHOOT = 3
DET_EVENT_BIG_CALIBER_CANNON_SHOOT = 4
DET_EVENT_ROCKET_FIRE = 5
DET_EVENT_HEAVY_ROCKET_FIRE = 6
DET_EVENT_MISSILE_FIRE = 7
DET_EVENT_HEAVY_MISSILE_FIRE = 8

NAV_LIGHTS = 1
LANDING_LIGHTS = 2
TIPS_LIGHTS = 3
SPOT_LIGHTS = 4
STROBE_LIGHT = 5

visual_detection = {
    terrain_LOS_test = true,
    Earth_curvature_LOS_test = true,
    objects_LOS_test = false,
    clouds_LOS_test = false,
    trees_LOS_test = false,
    
    sun_illumination_factor = true,
    other_light_sources_illumination_factor = true, --no effect if sun_illumination factor disabled
    darkness_limit = 0.085, --no effect if sun_illumination factor disabled
    overcast_test = true,
    fog_test = true, 
    precipitations_test = true, 
    
    max_detection_distance = 30000.0, --m --absolutely limit
    atmosphere_transparency_factor = {
        max_clear_cut_distance = 16000.0, --max distance in which target still clear-cut
        max_detection_distance = 20000.0 --max distance in which target can be detected
    },
    --Detection distances for targets
    --Cconditions: skill = excelent, LOS present, no fog, no clouds, illumination = 1.0, background = air, non-moving target, no nearly located targets, no smokes, target is not shooting, no dust and inversion tail, no lights   
    by_reflected_light = {
        fixed_size_target_detection = {
            target_size = 6.0, --m
            detection_distance = 10000.0, --m
        },
        detection_distance_by_class = {
            ["Fighters"] = 5500.0,
            ["Multirole fighters"] = 5500.0,
            ["Interceptors"] = 5500.0,
            ["Battleplanes"] = 5000.0,
            ["Bombers"] = 9500.0,
            ["Strategic bombers"] = 10500.0,
            ["UAVs"]  = 900.0,
            ["Helicopters"] = 5000.0,
            ["Ground vehicles"] = 10000.0, --original 5500.0
            ["Infantry"] = {3000.0, 0}, --original 100m
            ["Aircraft Carriers"] = 16000.0,
            ["Cruisers"]  = 12500.0,
            ["Destroyers"] = 10000.0,
            ["Fregates"] = 9000.0,
            ["Unarmed ships"]  = 10000.0,
            ["Airfields"] = 25000.0,
			["Fortifications"] = 8000
        },
        --detection_time_with_50_percent_visibility = 5.0,
    },
    by_own_light = {
        light_detection_distance = 10000.0 --for light power = 1.0f
    },
    by_shoots = {
        weapon_lights_detection_distance = {
            [DET_EVENT_MG_SHOOT] = 5000.0,
            [DET_EVENT_SMALL_CALIBER_CANNON_SHOOT] = 5500.0,
            [DET_EVENT_MEDIUM_CALIBER_CANNON_SHOOT] = 6000.0,
            [DET_EVENT_BIG_CALIBER_CANNON_SHOOT] = 7000.0,
            [DET_EVENT_ROCKET_FIRE] = 5000.0,
            [DET_EVENT_HEAVY_ROCKET_FIRE] = 7500.0,
            [DET_EVENT_MISSILE_FIRE] = 5000.0,
            [DET_EVENT_HEAVY_MISSILE_FIRE] = 7500.0
        }
    },
    motion_factor = {
        angular_speed_to_angular_size_ratio_max = 10.0,
        detection_distance_factor_max = 1.5,
    },
    background_factor = true,
    background_factors = {  --for air targets ONLY!
        [BACKGROUND_TYPE_AIR] = 1.0,
        [BACKGROUND_TYPE_LAND] = 0.6,
        [BACKGROUND_TYPE_FOREST] = 0.3,
        [BACKGROUND_TYPE_ROAD] = 0.8,
        [BACKGROUND_TYPE_RUNWAY] = 0.8,
        [BACKGROUND_TYPE_WATER] = 0.75
    },
    other_detected_target_location_factor = false,
    other_target_location_factor = false,   
    --note: motion_factor,  background_factor and skill_factor are multiplicative detection distance factors
}

detection_by_optic_sensor = {   
    magnifications_ratio_factor = 10.0,
    scan_time_for_double_scan_to_view_volume_ratio = 0.1, --for optic sensors
    --
    IR_view_trough_fog_and_overcast = true,
    shooter_detection_magnification_factor = false,
    light_detection_magnification_factor = false    
}

detection_by_IRST = {
    sun_factor = true, 
    background_factor = true  
}

detection_by_radar = {
    air_to_air = {
        radial_velocity_limit = true,
        relative_radial_velocity_limit = true,
        background_factor = true,
        aspect_factor = true,
        tail_on_aspect_terrain_objects_mask_factor = true
    },
    air_to_ground = {
        vehicles_detecion_limitation = true,
        resolution_with_terrain_objects = true,
        masking_by_terrain_objects = true
    }
}