mount_vfs_texture_path(current_mod_path.."/Textures/ERC.zip")



GT_t.CH_t.ERC = {
	life = 4.0,
	mass = 9000,
	length = 5.02,
	width = 2.49,
	max_road_velocity = 25,	
	
	max_slope = 0.6,
	engine_power = 170,
	gear_count = 6,
	canSwim = true,
	canWade = true,
	max_vert_obstacle = 1.0,
	max_acceleration = 2.3,
	min_turn_radius = 10,
	X_gear_1 = 1.925,
	Y_gear_1 = 0,
	Z_gear_1 = 0.75,
	X_gear_2 = -1.361,
	Y_gear_2 = 0,
	Z_gear_2 = 0.75,
	gear_type = GT_t.GEAR_TYPES.WHEELS,
	r_max = 0.46,
	armour_thickness = 0.010,
};


local OFL90 = {
	category = CAT_SHELLS,
	user_name = _("OFL90"),
	model_name    = "kinetic_type1",
	v0    = 1275.0,
	Dv0   = 0.0007,
	Da0     = 0.0007,
	Da1     = 0.0,
	mass      = 9.9,
	explosive     = 0.0000,
	life_time     = 7,
	caliber     = 90.0,
	 subcalibre     = true,
	AP_cap_caliber = 30.0, 
	piercing_mass = 3.33,
	s         = 0.0,
	j         = 0.0,
	l         = 0.0,
	charTime    = 0,
	cx        = {1.0,0.78,0.60,0.15,1.80},
	k1        = 9.4e-09,
	tracer_off    = 4,
	scale_tracer  = 1,
	
	name = "OFL90",

	cartridge = 0,
	};
declare_weapon(OFL90);

-- ERC-90 HE
local OE90 = {
	category = CAT_SHELLS,
	user_name = _("OE90"),
	model_name    = "pula",
	v0    = 750.0,
	Dv0   = 0.00508,
	Da0     = 0.0005,
	Da1     = 0.0,
	mass      = 5.4,
	explosive     = 3.0,
	life_time     = 7,
	caliber     = 90.0,
	s         = 0.0,
	j         = 0.0,
	l         = 0.0,
	charTime    = 0,
	cx        = {1.0,0.78,0.60,0.15,1.80},
	k1        = 9.4e-09,
	tracer_off    = 4,
	scale_tracer  = 1,
	
	name = "OE90",

	cartridge = 0,
	};
declare_weapon(OE90);


--ERC-90 CANON

GT_t.LN_t._90F4 = {} 
GT_t.LN_t._90F4.type = 2
GT_t.LN_t._90F4.xc = 0.585
GT_t.LN_t._90F4.distanceMin = 10
GT_t.LN_t._90F4.distanceMax = 4000
GT_t.LN_t._90F4.max_trg_alt = 3000
GT_t.LN_t._90F4.reactionTime = 10
GT_t.LN_t._90F4.launch_delay = 9
GT_t.LN_t._90F4.radialDisperse = 2.7;
GT_t.LN_t._90F4.dispertionReductionFactor = 0.988;
GT_t.LN_t._90F4.maxShootingSpeed = 5
GT_t.LN_t._90F4.beamWidth = math.rad(1);
GT_t.LN_t._90F4.inclination_correction_upper_limit = math.rad(20);
GT_t.LN_t._90F4.inclination_correction_bias = math.rad(0.4);
GT_t.LN_t._90F4.sensor = {}
set_recursive_metatable(GT_t.LN_t._90F4.sensor, GT_t.WSN_t[4])
GT_t.LN_t._90F4.PL = {}
GT_t.LN_t._90F4.PL[1] = {}
GT_t.LN_t._90F4.PL[1].shot_delay = 9
GT_t.LN_t._90F4.PL[1].ammo_capacity = 12
--GT_t.LN_t._90F4.PL[1].portionAmmoCapacity = 8;
GT_t.LN_t._90F4.PL[1].reload_time = 600;
GT_t.LN_t._90F4.PL[1].type_ammunition=OFL90.wsTypeOfWeapon
GT_t.LN_t._90F4.PL[1].shell_name = {"OFL90"};
GT_t.LN_t._90F4.PL[1].switch_on_delay = 0.5;
GT_t.LN_t._90F4.BR = { {pos = {1.2, 0, 0} } }
--GT_t.LN_t._90F4.PL[1].feedSlot = 1;


GT_t.LN_t._90F4H = {} 
GT_t.LN_t._90F4H.type = 2
GT_t.LN_t._90F4H.xc = 0.585
GT_t.LN_t._90F4H.distanceMin = 10
GT_t.LN_t._90F4H.distanceMax = 4000
GT_t.LN_t._90F4H.max_trg_alt = 3000
GT_t.LN_t._90F4H.reactionTime = 10
GT_t.LN_t._90F4H.launch_delay = 9
GT_t.LN_t._90F4H.radialDisperse = 2.7;
GT_t.LN_t._90F4H.dispertionReductionFactor = 0.988;
GT_t.LN_t._90F4H.maxShootingSpeed = 5
GT_t.LN_t._90F4H.beamWidth = math.rad(1);
GT_t.LN_t._90F4H.inclination_correction_upper_limit = math.rad(20);
GT_t.LN_t._90F4H.inclination_correction_bias = math.rad(0.4);
GT_t.LN_t._90F4H.sensor = {}
set_recursive_metatable(GT_t.LN_t._90F4H.sensor, GT_t.WSN_t[4])
GT_t.LN_t._90F4H.PL = {}
GT_t.LN_t._90F4H.PL[1] = {}
GT_t.LN_t._90F4H.PL[1].shot_delay = 9
GT_t.LN_t._90F4H.PL[1].ammo_capacity = 8
--GT_t.LN_t._90F4H.PL[1].portionAmmoCapacity = 12;
GT_t.LN_t._90F4H.PL[1].reload_time = 600;
GT_t.LN_t._90F4H.PL[1].type_ammunition=OFL90.wsTypeOfWeapon
GT_t.LN_t._90F4H.PL[1].shell_name = {"OE90"};
GT_t.LN_t._90F4H.PL[1].switch_on_delay = 0.5;
GT_t.LN_t._90F4H.BR = { {pos = {1.2, 0, 0} } }
--GT_t.LN_t._90F4H.PL[1].feedSlot = 1;


-- ERC-90

GT = {};
GT_t.ws = 0;
set_recursive_metatable(GT, GT_t.generic_wheel_IFV);
set_recursive_metatable(GT.chassis, GT_t.CH_t.ERC);

GT.visual.shape = "ERC"
GT.visual.shape_dstr = "ERC_destr"
GT.IR_emission_coeff = 0.12
GT.visual.IR = { coeffs = {GT_t.IR_COEFFS_ENGINE_APC, GT_t.IR_COEFFS_WHEELS_Truck, GT_t.IR_COEFFS_100mm, {0.0, 0.00}, {0.23, 0.23/1250}}}

--chassis
GT.swing_on_run = true


GT.sensor = {};
GT.sensor.max_range_finding_target = 6000;
GT.sensor.min_range_finding_target = 0;
GT.sensor.max_alt_finding_target = 1500;
GT.sensor.min_alt_finding_target = 0;
GT.sensor.height = 3.0;

--Burning after hit
GT.visual.fire_size = 0.9 --relative burning size
GT.visual.fire_pos[1] = 1 -- center of burn at long axis shift(meters)
GT.visual.fire_pos[2] = 0 -- center of burn shift at vertical shift(meters)
GT.visual.fire_pos[3] = -0.5 -- center of burn at transverse axis shift(meters)
GT.visual.fire_time = 900 --burning time (seconds)
GT.animation_arguments.crew_presence = 50;

GT.driverViewPoint = {0.0, 0.0, 0.0};
GT.driverViewConnectorName = "DRIVER_POINT"
GT.driverCockpit = "DriverCockpit/DriverCockpitWithLLTV"

-- weapon systems


GT.WS = {}
GT.WS.maxTargetDetectionRange = 6000;

local ws = GT_t.inc_ws();
GT.WS[ws] = {};
GT.WS[ws].center = 'CENTER_TOWER';
GT.WS[ws].angles = {
                    {math.rad(180), math.rad(-180), math.rad(-8), math.rad(15)},
                    };
GT.WS[ws].drawArgument1 = 0;
GT.WS[ws].drawArgument2 = 1;
GT.WS[ws].omegaY = math.rad(60);
GT.WS[ws].omegaZ = math.rad(30);
GT.WS[ws].reloadAngleY = math.rad(30);
GT.WS[ws].reloadAngleZ = math.rad(30);
GT.WS[ws].stabilizer = true;
GT.WS[ws].laser = true;
GT.WS[ws].pointer = 'GUNNER_POINT';
--GT.WS[ws].cockpit = { "Gepard/Gepard", {0.0, 0.0, 0.0}};

__LN = add_launcher(GT.WS[ws], GT_t.LN_t._90F4);
__LN.fireAnimationArgument = 125
__LN.beamWidth = math.rad(1);
__LN.BR[1].connector_name = 'GUN_POINT'
__LN.customViewPoint = { "XLHL-60/HL-60", {0.0, 0.0, 0.0} };
__LN.sightMasterMode = 1
__LN.distanceMaxForFCS = 5000;

__LN = add_launcher(GT.WS[ws], GT_t.LN_t._90F4H);
__LN.fireAnimationArgument = 125
__LN.beamWidth = math.rad(1);
__LN.BR[1].connector_name = 'GUN_POINT'
__LN.customViewPoint = { "XLHL-60/HL-60", {0.0, 0.0, 0.0} };
__LN.sightMasterMode = 1
__LN.distanceMaxForFCS = 5000;

__LN = add_launcher(GT.WS[ws], GT_t.LN_t.PKT);
__LN.fireAnimationArgument = 23
__LN.beamWidth = math.rad(1);
__LN.BR[1].connector_name = 'AANF1_POINT'
__LN.customViewPoint = { "XLHL-60/HL-60", {0.0, 0.0, 0.0}};
__LN.sightMasterMode = 1
__LN = nil;


GT.Name = "ERC"
GT.DisplayName = _("ERC-90")
GT.Rate = 15

GT.EPLRS = true;

GT.DetectionRange  = 0;
GT.ThreatRange = GT.WS[1].LN[1].distanceMax;
GT.mapclasskey = "P0091000001";
GT.attribute = {wsType_Ground,wsType_Tank,wsType_Gun,wsType_Hummer,              
				"APC",               
                "Datalink"
        };
GT.category = "Armor";

GT.Countries = { "France"}; 

add_surface_unit(GT)
