--------------------------------------------------------------------------------------------------
-- File lua for Markindel and Stonehouse HE111 
--------------------------------------------------------------------------------------------------

mount_vfs_model_path	(current_mod_path.."/Shapes")
mount_vfs_liveries_path (current_mod_path.."/Liveries")
mount_vfs_texture_path  (current_mod_path.."/Textures/HE111.zip")
mount_vfs_texture_path  (current_mod_path.."/Textures/")
mount_vfs_sound_path (current_mod_path.."/Sounds")



SC_250_4 = 
{
	CLSID        = "SC_250_4",
	category     = CAT_BOMBS,
	Picture	=	"FAB250.png",
	attribute	=	{4,	5,	9,	90},
	displayName	=	_("4 SC_250"),
	Count	=	4,
	Weight	=	1000,
	Elements	=	
	{
		[1]	=	
		{
			Position	=	{0,	0,	0},
			ShapeName	=	"FAB-250-N1",
		}, 
	}, -- end of Elements
}
declare_loadout(SC_250_4)

SC_50_16 = 
{
	CLSID        = "SC_50_16",
	category     = CAT_BOMBS,
	Picture	=	"FAB100.png",
	attribute	=	{4,	5,	9,	90},
	displayName	=	_("16 SC_50"),
	Count	=	16,
	Weight	=	800,
	Elements	=	
	{
		[1]	=	
		{
			Position	=	{0,	0,	0},
			ShapeName	=	"SC50",
		}, 
	}, -- end of Elements
}
declare_loadout(SC_50_16)



HE_111 = 
{
	Name 				=   'He-111',
	DisplayName			= _('He-111'),
--	HumanCockpit 		= false,
	Picture 				= current_mod_path..'/Textures/HE111.png',
	Rate 				= 40, -- RewardPoint in Multiplayer
	Shape 				= "HE111",
	shape_table_data 	= 
	{
		{
			file  	 = 'HE111';
			life  	 = 130; -- lifebar
			vis   	 = 3; -- visibility gain.
			desrt    = 'HE111_destr'; -- Name of destroyed object file name
			fire  	 = { 500, 4}; -- Fire on the ground after destoyed: 500sec 4m
			username = 'He-111';
			index    =  WSTYPE_PLACEHOLDER;
			classname 	= "lLandPlane";
			positioning = "BYNORMAL";
			drawonmap 	= true;
		},
		{
			name  = "HE111_destr";
			file  = "HE111-destr";
			fire  = { 500, 4};
		},

	},
	mapclasskey = "P0091000027",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Intruder, WSTYPE_PLACEHOLDER , "Strategic bombers"},
	Categories 			= {},

	-------------------------
	M_empty 					= 8680, -- kg
	M_nominal 					= 11030, -- kg
	M_max 						= 14000, -- kg
	M_fuel_max 					= 2445, -- kg
	length 						= 16.4, -- full length in m
	height 						= 4, -- height in m
	wing_area 					= 86.5, -- wing area in m2
	wing_span 					= 22.6, -- wing spain in m
	wing_type 					= 0,
	wing_tip_pos 				=  {0.908,	1.636, 21.415}, -- wingtip coords for visual effects
	

--------------------------------------------------------------------------------
---- Primo valore    : avanti/indietro
---- Secondo valore: alto/basso
---- Terzo Valore    : destra/sinistra	
--	nose_gear_pos				= 	{-10.522,	-1.145,	0}, -- nosegear coord 3.769,	-2.353,	0  ----- Ruotino posteriore
--	main_gear_pos 				= 	{0.635,	       -2.330,	2.534}, -- main gear coords 0.072,	-2.374,	2.341	--- carrello principale
--	tand_gear_max 				= 0.05,  -------- angolo di rotazione del ruotino posteriore
	nose_gear_pos				= 	{-10.522,	-1.125,	0}, -- nosegear coord 3.769,	-2.353,	0  ----- Ruotino posteriore
	main_gear_pos 				= 	{0.635,	       -2.350,	2.534}, -- main gear coords 0.072,	-2.374,	2.341	--- carrello principale
	tand_gear_max 				= 0.05,  -------- angolo di rotazione del ruotino posteriore
	
	
	nose_gear_wheel_diameter 	= 0.793, -- in m
	main_gear_wheel_diameter 	= 1.395, -- in m
	stores_number				=	0,
	V_opt 						= 102,-- Cruise speed (for AI)
	V_take_off 					= 43, -- Take off speed in m/s (for AI) 288km/h
	V_land 						= 40, -- Land speed in m/s (for AI)
	V_max_sea_level 			= 112, -- Max speed at sea level in m/s (for AI)
	V_max_h 					= 122, -- Max speed at max altitude in m/s (for AI)
	Vy_max 						= 1.5, -- Max climb speed in m/s (for AI)
	Mach_max 					= 0.33, -- Max speed in Mach (for AI)
	H_max 					 	= 8500, -- m
	Ny_min 						= 0, -- Min G (for AI)
	Ny_max 						= 1.5,  -- Max G (for AI)
	Ny_max_e 					= 1.5,  -- Max G (for AI)
	AOA_take_off 				= 0.14, -- AoA in take off (for AI)
	bank_angle_max 				= 10, -- Max bank angle (for AI)
	average_fuel_consumption 	= 0.0386, -- this is highly relative, but good estimates are 36-40l/min = 28-31kg/min = 0.47-0.52kg/s -- 45l/min = 35kg/min = 0.583kg/s
	range 						= 1200, -- Max range in km (for AI)
	crew_size	                = 5, 
	CAS_min 					= 72, -- if this is not OVERAL FLIGHT TIME, but jus LOITER TIME, than it sholud be 10-15 minutes.....CAS capability in minute (for AI)
	thrust_sum_max 				= 50000,
	thrust_sum_ab 				= 50000,
	has_afteburner 				= false, -- AFB yes/no
	has_speedbrake 				= false, -- Speedbrake yes/no
	tanker_type 				= 0, -- Tanker type if the plane is airrefuel capable
	flaps_maneuver 				= 0.5, -- Max flaps in take-off and maneuver (0.5 = 1st stage; 1.0 = 2nd stage) (for AI)
	brakeshute_name 			= 0, -- Landing - brake chute visual shape after separation
	is_tanker 					= false, -- Tanker yes/no
	air_refuel_receptacle_pos 	= {0, 0, 0}, -- refuel coords
	RCS 						= 100, -- Radar Cross Section m2
	IR_emission_coeff 			= 1.5, -- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
	IR_emission_coeff_ab 		= 0, -- With afterburner
	engines_count				= 2, -- Engines count

------------------------------------------------------------------------------	
-- Fumo scarico motori {x,y,z}
------------------------------------------------------------------------------
	engines_nozzles = 
	{
		[1] = 
		{
				pos = 	{2.5,	-0.2,	-1.7},
				elevation	=	0,
				diameter	=	0.523,
				exhaust_length_ab	=	11.794,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.2,
				engine_number  = 1, --both to first engine
		},
		[2] = 
		{
			pos = 	{2.5,	-0.2,	1.7},
				elevation	=	0,
				diameter	=	0.523,
				exhaust_length_ab	=	11.794,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.2,
				engine_number  = 2, --both to 2nd engine
		},
	}, -- end of engines_nozzles
--------------------------------------------------------------------------------
---- Primo valore    : avanti/indietro
---- Secondo valore: alto/basso
---- Terzo Valore    : destra/sinistra


---------------------------------------------------------------------------------
--  equipaggio
---------------------------------------------------------------------------------

	crew_size	 = 5,
	crew_members = 
	{
			[1] = 
			{	pilot_name          = "pilot_bf109", --pilot
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{3,	1,	-0.5},
			}, -- end of [1]
			[2] = 
			{	pilot_name          = "pilot_bf109", --copilot
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{3,	1,	0.5},
			}, -- end of [2]
			[3] = 
			{	pilot_name          = "pilot_bf109", --bombardier
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{4.25,	0.5, 0},
			}, -- end of [3]
			[4] = 
			{	pilot_name          = "pilot_bf109", --waist/ventral
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{-3, 0, 0},
			}, -- end of [4]
			[5] = 
			{	pilot_name          = "pilot_bf109", --dorsal
				ejection_seat_name	=	0,
				drop_canopy_name	=	0,
				pos = 	{-1, 1.5, 0},
			}, -- end of [5]
			
	}, -- end of crew_members




	
	fires_pos = 
	{
		[1] = 	{-4, 0.25, 0},
		[2] = 	{0, 0, 1.1},
		[3] = 	{-0.25, 0.25, -0.9},
		[4] = 	{3.75, 0.5, 2.75},
		[5] = 	{3.75, 0.5, -2.9},
		[6] = 	{-0.2, 0.75, 8.75},
		[7] = 	{0.5, 0.5, -6.25},
		[8] = 	{3.5, 0.75, 0.25},
	}, -- end of fires_pos
	
	-- Countermeasures
	SingleChargeTotal	 	= 0,
	CMDS_Incrementation 	= 0,
	ChaffDefault 			= 0, 
	ChaffChargeSize 		= 0,
	FlareDefault 			= 0, 
	FlareChargeSize 		= 0,
	CMDS_Edit 				= false,
	chaff_flare_dispenser 	= 
	{
	}, -- end of chaff_flare_dispenser

	--sensors
	
	detection_range_max		 = 60,
	radar_can_see_ground 	 = false, -- this should be examined (what is this exactly?)
	CanopyGeometry = 
	{
		azimuth   = {-160.0, 160.0}, -- pilot view horizontal (AI)
		elevation = {-50.0, 90.0} -- pilot view vertical (AI)
	},
	Sensors = 
	{
	},
	HumanRadio = 
	{
		frequency = 127.5,  -- Radio Freq
		editable = true,
		minFrequency = 100.000,
		maxFrequency = 156.000,
		modulation = MODULATION_AM
	},

	Guns = 
	{

		gun_mount("M_2", --front
			{count = 2000},
			{muzzle_pos = {5.3,0.25,0.25},
			 supply_position = {4.5,  0.5, 0},
			 aft_gun_mount = true,
			 drop_cartridge = 0,	
			}
		),
		gun_mount("M_2", --dorsal
			{count = 2000},
			{muzzle_pos = {-2.25,  1.5, 0},
			 supply_position = {-1,  1, 0},
			 aft_gun_mount = true,
			 drop_cartridge = 0,	
			}
		),
		gun_mount("M_2", --waist left 1
			{count = 2000},
			{muzzle_pos = {-3.13,  0.75, -1.3},
			 supply_position = {-3,  0.25, -0.3},
			 aft_gun_mount = true,
			drop_cartridge = 0,			 
			}
		),
		gun_mount("M_2", --waist right 1
			{count = 1000},
			{muzzle_pos = {-3.13,  0.75, 1.3},
			 supply_position = {-3,  0.25, 0.3},
			 aft_gun_mount = true,
			 drop_cartridge = 0,
			}
		),
		gun_mount("M_2", --ventral 1
			{count = 2000},
			{muzzle_pos = {-1,  -1, 0},
			 supply_position = {-1.5,  -0.75, 0},
			 aft_gun_mount = true,
			 drop_cartridge = 0,
			}
		),
		gun_mount("M_39",  --ventral 2
			{count = 1000},
			{muzzle_pos = {-4.25,  -1, 0},
			 supply_position = {-3.75,  -0.75, 0},
			 aft_gun_mount = true,
			 drop_cartridge = 0,
			}
		),	

	},

---- Primo valore    : avanti/indietro
---- Secondo valore: alto/basso
---- Terzo Valore    : destra/sinistra	
----------- NOTE  per i Pilomi  (http://forums.eagle.ru/showthread.php?t=110815)
---1 = What number Pylon it is
---2 = Internal or External pylon, so if its set to 2 it fires the Argument #26, if its set to 1, its external
---1.302000, 0.182000, -0.500000 = XYZ coords

	Pylons = 
    {
		-- Parameter 2 = Internal or External pylon, so if its set to 2 it fires the Argument #26
        pylon(1, 2, 1, -0.5, -0.5,
			{
			},
            {
				{ CLSID = "SC_250_4" },
				{ CLSID = "SC_50_16" },
            }
        ),
        pylon(2, 2, 1,  -0.5, 0.5,
			{
			},
            {
				{ CLSID = "SC_250_4" },
				{ CLSID = "SC_50_16" },
            }
        ),
    },
	
	

-----------------------------------------------------------------------------------	

-----------------------------------------------------------------------------------	

	Tasks = 
	{
		aircraft_task(GroundAttack),
		aircraft_task(RunwayAttack),
    },	
	DefaultTask = aircraft_task(RunwayAttack),

	SFM_Data = {
		aerodynamics = -- Cx = Cx_0 + Cy^2*B2 +Cy^4*B4
		{
			Cy0			=	0.2,  -- zero AoA lift coefficient
			Mzalfa		=	4.6,  -- coefficients for pitch agility
			Mzalfadt	=	0.8,    -- coefficients for pitch agility
			kjx			=	2.0,    
			kjz			=	0.00125, 
			Czbe		=	-0.012, -- coefficient, along Z axis (perpendicular), affects yaw, negative value means force orientation in FC coordinate system
			cx_gear		=	0.015,    -- coefficient, drag, gear
			cx_flap		=	0.05,   -- coefficient, drag, full flaps
			cy_flap		=	1.2,    -- coefficient, normal force, lift, flaps
			cx_brk		=	0.06,   -- coefficient, drag, breaks
			table_data  = 
			{
			--   M		Cx0		Cya		B		B4			Omxmax	Aldop	Cymax
				{0,		0.024,	0.1,	0.0426,	1e-006,	0.5,	20,	1.2},
				{0.1,	0.024,	0.1,	0.0426,	1e-006,	1,		20,	1.2},
				{0.2,	0.024,	0.1,	0.0426,	1e-006,	1.5,	20,	1.2},
				{0.3,	0.024,	0.1,	0.0426,	1e-006,	2,		20,	1.2},
				{0.4,	0.024,	0.1,	0.0426,	1e-006,	2.5,	20,	1.2},
				{0.5,	0.024,	0.1,	0.0426,	1e-006,	3,		20,	1.2},
				{0.6,	0.024,	0.1,	0.044,	1e-006,	3.5,	20,	1.2},
				{0.7,	0.025,	0.1,	0.045,	0.02,	3.5,	20,	1},
				{0.8,	0.029,	0.1,	0.049,	0.05,	3.5,	20,	0.9},
				{0.9,	0.04,	0.1,	0.071,	0.07,	3.5,	20,	0.8},
				{1,		0.06,	0.1,	0.138,	0.2,	3.5,	20,	0.76666666666667},
			}, -- end of table_data
			-- M - Mach number
			-- Cx0 - Coefficient, drag, profile, of the airplane
			-- Cya - Normal force coefficient of the wing and body of the aircraft in the normal direction to that of flight. Inversely proportional to the available G-loading at any Mach value. (lower the Cya value, higher G available) per 1 degree AOA
			-- B - Polar quad coeff
			-- B4 - Polar 4th power coeff
			-- Omxmax - roll rate, rad/s
			-- Aldop - Alfadop Max AOA at current M - departure threshold
			-- Cymax - Coefficient, lift, maximum possible (ignores other calculations if current Cy > Cymax)
		}, -- end of aerodynamics
		engine = 
		{
			Nmg	=	700, -- RPM at idle
			MinRUD	=	0, -- Min state of the throttle
			MaxRUD	=	1, -- Max state of the throttle
			MaksRUD	=	1, -- Military power state of the throttle
			ForsRUD	=	1, -- Afterburner state of the throttle
			typeng	=	2,
			--	E_TURBOJET = 0
			--	E_TURBOJET_AB = 1
			--	E_PISTON = 2
			--	E_TURBOPROP = 3
			--	E_TURBOFAN	= 4
			--	E_TURBOSHAFT = 5
			hMaxEng	=	19.5, -- Max altitude for safe engine operation in km
			dcx_eng	=	0.0085, -- Engine drag coeficient
			cemax	=	0.37, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			cefor	=	0.37, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			dpdh_m	=	19000, --  altitude coefficient for max thrust
			dpdh_f	=	19000, --  altitude coefficient for AB thrust
			table_data = 
			{
			--   M		Pmax		 Pfor	
				{0,		608000,	608000},
				{0.1,	568000,	568000},
				{0.2,	520000,	520000},
				{0.3,	484000,	484000},
				{0.4,	440000,	440000},
				{0.5,	418000,	418000},
				{0.6,	410000,	410000},
				{0.7,	436000,	436000},
				{0.798,	470000,	470000},
				{0.9,	524000,	524000},
				{1,		560000,	560000},
			}, -- end of table_data
			-- M - Mach number
			-- Pmax - Engine thrust at military power
			-- Pfor - Engine thrust at AFB
			k_adiab_1			= 0.037923,
			k_adiab_2			= 0.0562,
			MAX_Manifold_P_1	= 155774,
			MAX_Manifold_P_2	= 206570,
			MAX_Manifold_P_3	= 226648,
			k_after_cool		= 0.54,
			Displ				= 27,
			k_Eps				= 6,
			Stroke				= 0.152,
			V_pist_0			= 12,
			Nu_0				= 15.0,
			Nu_1				= 2.4,
			Nu_2				= 0.001,
			N_indic_0			= 1023040,
			N_fr_0				= 0.072,
			N_fr_1				= 0.02,
			Init_Mom			= 220,
			D_prop				= 3.45,
			MOI_prop			= 65,
			k_gearbox			= 2.088,
			P_oil				= 495438,
			k_boost				= 3,
			k_cfug				= 0.003,
			k_oil				= 0.00004,
			k_piston			= 3000,
			k_reg				= 0.003,
			k_vel				= 0.017,
		}, -- end of engine
	}, -- end of SFM_Data

----------------------------------------------------------------------------------------------------
---  Damage Section
-----------------------------------------------------------------------------------------------------	
Damage = {
	[0]  		= {critical_damage = 10}, --nose
	[1]			= {critical_damage = 15}, -- nose left
	[2]			= {critical_damage = 15}, -- nose right
	[3]			= {critical_damage = 10}, -- cockpit 
 	[4]			= {critical_damage = 20, args = {154}},-- cabin left*
	[5]			= {critical_damage = 20, args = {153}},-- cabin right*
	[11]		= {critical_damage = 3},  -- Engine 1 count from left
	[12]		= {critical_damage = 3},  -- Engine 2 count from left
	[23]		= {critical_damage = 15, deps_cells = {25}}, -- wing out left
	[24]		= {critical_damage = 15, deps_cells = {26}},-- wing out right
	[25]		= {critical_damage = 2}, -- eleron left 
	[26]		= {critical_damage = 2}, -- eleron right 
	
	[29]		= {critical_damage = 15, deps_cells = {23, 25, 37}}, -- wing center left 
 	[30]		= {critical_damage = 15, deps_cells = {24, 26, 38}},-- wing center right 
	[35]		= {critical_damage = 15, args = {225}}, -- wing in left* 
	[36]		= {critical_damage = 15, args = {215}}, -- wing in right* 	
	[37]		= {critical_damage = 2}, -- flap in left 
	[38]		= {critical_damage = 2},-- flap in right 	
	[39]		= {critical_damage = 5}, -- fin top left

	[43]		= {critical_damage = 5, args = {243}}, -- Vertical stabilizer*

	[45]		= {critical_damage = 5}, -- stabilizer out left
	[46]		= {critical_damage = 5}, -- stabilizer out right
	[47]		= {critical_damage = 5, args = {236}} ,-- stabilizer in left*
	[48]		= {critical_damage = 5, args = {234}}, -- stabilizer in right*
	[49]		= {critical_damage = 2},-- elevator out left
	[50]		= {critical_damage = 2},-- elevator out right
	[53]		= {critical_damage = 5, args = {247}, deps_cells = {54}}, -- rudder left*
	[54]		= {critical_damage = 5, args = {247}, deps_cells = {53}}, -- rudder right*
	[55]		= {critical_damage = 25, args = {81}, deps_cells = {43, 53, 54, 45, 46},droppable=false}, -- tail *
	[56]		= {critical_damage = 15, args = {158},droppable=false},-- tail left*
	[57]		= {critical_damage = 15, args = {157},droppable=false},-- tail right	*
	[59]		= {critical_damage = 8}, -- nose bottom 	

	[82]		= {critical_damage = 8},-- fuselage bottom
	[83]		= {critical_damage = 1}, -- wheel nose 
	[84]		= {critical_damage = 1}, -- wheel left 
	[85]		= {critical_damage = 1}, -- wheel right 
	[61]		= {critical_damage = 6}, -- fuel tank left
	[62] 		= {critical_damage = 6}, -- fuel tank right
	[63]		= {critical_damage = 3}, -- rotor
	[64]		= {critical_damage = 3}, -- blade 1 in  (for contact model!)
	[66]		= {critical_damage = 3}, -- blade 1 out
	[67]		= {critical_damage = 3, args = {430}}, -- blade 2 in  (for contact model!)*
	[69]		= {critical_damage = 3}, -- blade 2 out
	[70]		= {critical_damage = 3, args = {431}}, -- blade 3 in  (for contact model!)*	
	[72]		= {critical_damage = 3}, -- blade 3 out
	[73]		= {critical_damage = 3}, -- blade 4 in  (for contact model!)	
	[75]		= {critical_damage = 3}, -- blade 4 out

	
	},
	DamageParts = 
	{  
		[1] = "he111-oblomok-wing_r.edm",
		[2] = "he111-oblomok-wing_l.edm",
		[3] = "he111-oblomok-tail.edm",
		
		
	},
	
----------------------------------------------------------------------------------------------------
---  End Damage Section
-----------------------------------------------------------------------------------------------------	
	lights_data = 
	{
		typename = "collection",
		lights = 
		{
			[1] = -- EXEgEEE{EEECEg
			{
			},
			[2] = -- EEEEEfEBEEEOEEECEg
			{
			},
		    [3]	= -- EiErEQE[EVEEEEEEECEg
			{
		    	typename = "collection",
				lights =
				{
					-- Left Position Light (red)
					{typename = "omnilight",
					color = {0.32, 0.0, 0.07},
					position  = {3.74, 1.44, -21.45},
					argument  = 190
					},
					-- Right Position Light (green)
					{typename = "omnilight",
					color = {0, 0.26, 0.18},
					position = {3.74, 1.44, 21.45},
					argument  = 191
					},
					-- Tail Position Light (white)
					{typename = "omnilight",
					color = {0.8, 0.8, 0.8},
					position  = {-13.2, 0.33, 0.0},
					argument  = 203
					},
				}
			},
		    [4] = -- EtEHE[EEE[EVEEEEEEECEg
			{
			},
			[5]	=
			{
			}
		}
	},  -- end of lights_data

}

add_aircraft(HE_111)
