dofile(db_path.."wsTypes.lua")

WsTypeTree = {
  [wsType_Air] = {
    [wsType_Airplane] = {
      [wsType_Fighter] =  {
        ["MiG-23MLD"] = MiG_23, ["MiG-29A"] = MiG_29, ["MiG-29G"] = MiG_29G, ["MiG-29S"] = MiG_29C, 
        ["MiG-29K"] = MIG_29K, ["Su-27"] = Su_27, ["Su-33"] = Su_33, ["Su-30"] = Su_30,
        
        ["F-4E"] = F_4E, ["F-5E"] = F_5E, ["F-14A"] = F_14, ["F-15C"] = F_15, ["F-16C bl.50"] = F_16, ["F-16A"] = F_16A, 
        ["F/A-18A"] = FA_18, ["F/A-18C"] = FA_18C, ["Mirage 2000-5"] = Mirage, ["Tornado GR3"] = F_2, ["Tornado IDS"] = TORNADO_IDS,
        
        ["Su-34"] = Su_34, ["MiG-27K"] = MiG_27, ["Su-24M"] = Su_24, ["Su-24MR"] = Su_24MR, ["Su-17M4"] = SU_17M4, ["F-111F"] = F_111, 
        ["EA-6B"] = EA_6B, ["BAE Harrier"] = AV_8B
      },
      [wsType_F_Bomber] = {
        ["Tu-22M3"] = Tu_22M3, ["Tu-160"] = Tu_160, ["B-1B"] = B_1
      },
      [wsType_Intercepter] = {
        ["MiG-25PD"] = MiG_25P, ["MiG-31"] = MiG_31, ["MiG-25RBT"] = MiG_25
      },
      [wsType_Intruder] = {
        ["Tu-95MS"] = Tu_95, ["Tu-142"] = Tu_142, ["B-52H"] = B_52
      },
      [wsType_Cruiser] = {
        ["A-50"] = A_50, ["E-3A"] = E_3, ["IL-78M"] = IL_78, ["KC-10A"] = KC_10, ["IL-76MD"] = IL_76, ["C-130"] = C_130, 
        ["S-3R"] = S_3R, ["Tu-143"] = Tu_143, ["Tu-141"] = Tu_141, ["An-26B"] = AN_26B, ["An-30M"] = AN_30M, 
        ["E-2C"] = E_2C, ["S-3B"] = S_3A, ["C-17A"] = C_17, ["Yak-40"] = Yak_40,
      },
      [wsType_Battleplane] = {
        ["Su-25"] = Su_25, ["A-10A"] = A_10, ["F-117A"] = F_117, ["Su-25TM"] = Su_39, 
        ["Su-25T"] = Su_25T, ["RQ-1A Predator"] = RQ_1A_Predator
      }
    },
    [wsType_Helicopter] = {
      [wsType_Battleplane] = {
        ["Mi-24V"] = MI_24W, ["Ka-50"] = KA_50, ["Ka-52"] = KA_52, ["AH-64A"] = AH_64A, ["AH-64D"] = AH_64D, 
        ["SH-60B"] = SH_60B, ["AH-1W"] = AH_1W, ["Sea Lynx"] = Sea_Lynx, ["UH-1H"] = AB_212, ["Mi-28N"] = MI_28N, ["OH-58D"] = OH_58D
      },
      [wsType_NoWeapon] = {
        ["Mi-8MT"] = MI_8MT, ["Mi-26"] = MI_26, ["Ka-27"] = KA_27, ["CH-47D"] = CH_47D, ["CH-53E"] = CH_53E, 
        ["UH-60A"] = UH_60A, ["SH-3W"] = SH_3H, 
      }
    }
  },
  [wsType_Ground] = {
    [wsType_Moving] = { --unarmed vechicles
      [wsType_NoWeapon] = {
      }
    },
    [wsType_Tank] = { --armed vechicles
      [wsType_Gun] = {
        ["LAV-25"] = wsTypeLAV25, ["LVTP-7"] = wsTypeLVTP7, ["BRDM-2"] = wsTypeBRDM2,       
        ["MSTA"] = wsTypeSAUmsta, ["Akatzia"] = wsTypeSAUakacia, ["SAU_2C9"] = wsTypeSAU_2C9, ["2C1"] = wsType2C1,        
        ["MCV80"] = wsTypeMCV80, ["M109"] = wsTypeM109, ["Leopard-2"] = wsTypeLeopard2, ["M1 Abrams"] = wsTypeAbrams, 
        ["Bereg_SAU"] = wsTypeBeregSAU, ["T-80U"] = wsTypeT80,  ["TPZ"] = wsTypeTPZ,
        ["M-60"] = wsTypeM_60, ["Leo1"] = wsTypeLeo1, ["M1126 Stryker ICV"] = wsTypeM1126_Stryker_ICV, 
        ["M1128 Stryker MGS"] = wsTypeM1128_Stryker_MGS, ["Marder"] = wsTypeMarder, ["M113"] = wsTypeM113, 
            ["MTLB"] = wsTypeMTLB, ["BTR80"] = wsTypeBTR80, ["T-72"] = wsTypeT72, ["T-55"] = wsTypeT55, 
        ["M-1043"] = wsTypeM1043, ["LeClerc"] = wsTypeLeClerc, ["Infantry-AK74"] = wsTypeAutogun, ["SoldierAK"] = wsTypeSoldier_AK,
        ["BOMAN"] = wsTypeBOMAN, ["Sandbox"] = wsTypeSandbox, ["Bunker"] = wsTypeBunker
      },
      [wsType_MissGun] = {
        ["BMD-1"] = wsTypeBMD1, ["BMP-1"] = wsTypeBMP1, ["BMP-2"] = wsTypeBMP2, ["BMP-3"] = wsTypeBMP3, 
        ["M-2_Bradley"] = wsTypeM2Bradley, ["M1134 Stryker ATGM"] = wsTypeM1134_Stryker_ATGM, 
        ["BTR-D"] = wsTypeBTR_D, ["M1045"] = wsTypeM1045, ["Infantry-RPG"] = wsTypeRPG, ["SoldierRPG"] = wsTypeSoldier_RPG
      },
      [wsType_Miss] = { --MRLSs
        ["Grad"] = wsTypeGrad, ["Smerch"] = wsTypeSmerch, ["Scud"] = wsTypeUragan, ["MLRS"] = wsTypeMLRS
      },
      [wsType_Radar] = { --radars
        ["Bereg_RLS"] = wsTypeBeregRLS, ["PRV-11"] = wsTypeRLS_PRW11,  ["RSP-7"] = wsTypeRLS_RSP7, 
        ["RLS-37"] = wsTypeRLS37, ["Zapros"] = wsTypeZapros, ["RadioStation"] = wsTypeRadioSt
      },
      [wsType_NoWeapon] = {
        ["M-1025"] = wsTypeHummer,
        --
        ["Ural375PBU"] = wsTypeUral375PBU,
        ["M818"] = wsTypeM818,
        ["TMZ5"] = wsTypeTMZ5,
        ["TZ10"] = wsTypeTZ10,
        ["UralApa"] = wsTypeUralApa,        
        ["MAZelektro"] = wsTypeMAZelektro,
        ["MAZkaraul"] = wsTypeMAZkaraul,
        ["MAZobsch"] = wsTypeMAZobsch,
        ["MAZstol"] = wsTypeMAZstol,
        ["ATZ60"] = wsTypeATZ60,
        ["Reis"] = wsTypeReis,
        ["Tiagach"] = wsTypeTiagach,
        ["UAZ469"] = wsTypeUAZ469,
        ["Ural375"] = wsTypeUral375,        
        ["ZIL135"] = wsTypeZIL135,
        ["Elektrovoz"] = wsTypeElektrovoz,
        ["Bus"] = wsTypeBus,
        ["VAZ"] = wsTypeVAZ,
        ["Teplowoz"] = wsTypeTeplowoz,
        ["Trolebus"] = wsTypeTrolebus,
        ["WCisterna"] = wsTypeWCisterna,
        ["WGruz"] = wsTypeWGruz,
        ["WGruzOtkr"] = wsTypeWGruzOtkr,
        ["WagonPlatforma"] = wsTypeWagonPlatforma,
        ["WagonPass"] = wsTypeWagonPass,
        ["RadioSt"] = wsTypeRadioSt,
        ["KAMAZ_Fire"] = wsTypeKAMAZ_Fire,
        ["KAMAZ_Tent"] = wsTypeKAMAZ_Tent,
        ["LAZ_695"] = wsTypeLAZ_695,
        ["GAZ_66"] = wsTypeGAZ_66,
        ["GAZ_3307"] = wsTypeGAZ_3307,
        ["GAZ_3308"] = wsTypeGAZ_3308,
        ["MAZ_6303"] = wsTypeMAZ_6303,
        ["ZIL_4334"] = wsTypeZIL_4334,
        ["Predator_GC"] = wsTypePredator_GC,
        ["Predator_TrojanSpirit"] = wsTypePredator_TrojanSpirit,
        ["Predator_GCS"] = wsTypePredator_GCS,
        ["ZIL_SKP_11"] = wsTypeZIL_SKP_11,
        ["URAL_4320T"] = wsTypeURAL_4320T,
        ["eURAL_4320_31"] = wsTypeURAL_4320_31,
        ["URAL_ATsP_6"] = wsTypeURAL_ATsP_6,
        ["ZIL_APA_80"] = wsTypeZIL_APA_80,
        ["ZIL_131_KUNG"] = wsTypeZIL_131_KUNG,
        ["HEMTT_M978"] = wsTypeHEMTT_M978
      }
    },
    [wsType_SAM] = {  --anti-aircraft vehicles
      [wsType_Gun] = { --AAA
        ["ZU-23"] = ZU_23, 
        ["ZU-23 TRENCH"] = ZU_23_OKOP,
        ["ZU-23 URAL"] = ZU_23_URAL,        
        ["ZU-23 INSURGENT"] = ZU_23_insurgent,
        ["ZU-23 TRENCH INSURGENT"] = ZU_23_insurgent_okop,
        ["ZU-23 URAL INSURGENT"] = ZU_23_insurgent_ural
      },
      [wsType_Miss] = { --SAM launchers
        ["9A82"] = S300V_9A82, ["9A83"] = S300V_9A83,
        ["5P85C"] = PU_5P85C, ["5P85D"] = PU_5P85D, 
        ["9A84"] = S300V_9A84, ["9A85"] = S300V_9A85, 
        ["M901"] = Patriot_, 
        ["2P25"] = KUB_2P25, ["AN/MSW-11"] = Hawk_,
        ["Dzhigit"] = Dzhigit_, ["Igla"] = Igla_, ["Stinger"] = Stinger_, ["Igla-IglaRUS_1"] = IglaRUS_1,  
            ["IglaRUS_2"] = IglaRUS_2, ["IglaGRG_1"] = IglaGRG_1, ["IglaGRG_2"] = IglaGRG_2, ["StingerUSA_1"] = StingerUSA_1, 
        ["StingerUSA_2"] = StingerUSA_2, ["StingerIZR_1"] = StingerIZR_1, ["StingerIZR_2"] = StingerIZR_2, 
        ["Strela 9K31"] = Strela_9K31, ["Strela_9K35"] = Strela_9K35, ["M-48 Chaparral"] = M48_Chaparral
      },
      [wsType_MissGun] = { --AAA & SAM
        ["Avenger"] = Avenger_, ["M-6 Linebacker"] = M6Linebacker, ["Strela 9K35"] = Strela_9K35, 
      },
      [wsType_Radar] = {
        ["1L13"] = EWR_1L13, ["55ZH6"] = EWR_55G6,
        ["RPN on 40V6M"] = V_40B6M, ["45N66M on 40V6MD"] = V_40B6MD, ["5N63C"] = RLS_5H63C, ["64N6E"] = RLO_64H6E, ["AN/MPQ-53"] = Patr_AN_MPQ_53_P,
        ["KUB_1C91"] = KUB_1C91, ["9C18M1"] = BUK_9C18M1, 
        ["AN/MPQ-50"] = Hawk_Search_Radar, ["AN/MPQ-46"] = Hawk_Track_Radar,
        ["9C737M"] = Radar_Dog_Ear, ["Roland search radar"] = Roland_Search_Radar
      },
      [wsType_Radar_Gun] = {
        ["Shilka"] = Shilka_, ["Gepard"] = Gepard_, ["Vulkan"] = wsTypeVulkan
      },
      [wsType_Radar_Miss] = { --SAM launchers with track and|or illumination radar
        ["9A84"] = S300V_9A84, ["9A85"] = S300V_9A85,     
        ["9A310M1"] = BUK_PU, ["9A39"] = BUK_LL, ["9A33BM3"] = OSA_9A33BM3, ["9T217"] = OSA_9T217, 
        ["9A331"] = Tor_, ["Roland"] = Roland_
      },
      [wsType_Radar_MissGun] = {
        ["Tunguska"] = Tunguska_
      },
      [wsType_NoWeapon] = { --control stations
        ["54K6"] = KP_54K6, ["9C457"] = KP_S300V_9C457, ["9C470M1"] = BUK_9C470M1, 
        ["AN/MSQ-104"] = Patr_KP
      }
    }
  },
  [wsType_Navy] = {
    [wsType_Ship] = {
      [wsType_AirCarrier] = {
        ["CV Admiral Kuznetzov"] = Kuznecow,      
        ["CVN Carl Vinson"] = VINSON,
      },
      [wsType_HCarrier] = {
        ["CG Moscow"] = MOSCOW,
        ["CG Grozny"] = GROZNY
      },
      [wsType_ArmedShip] = {
        ["Kater"] = KATER, ["MSO Natya"] = AKVAMAREN, ["CG Kara"] = AZOV, ["LST Ropucha"] = BOBRUISK,       
        ["FSG Sivuch"] = BORA, ["FFL Grisha V"] = ALBATROS, ["FFL Grisha II"] = AMETYST, ["FFG Krivak III"] = OREL, ["FFG Krivak II"] = REZKY, 
        ["FSG Tarantul III"] = MOLNIYA, ["ACV Tsaplya"] = MURENA, ["FFG O_H_Perry"] = PERRY, ["FSG Osa II"] = OSA, 
        ["DDG Mod_Kashin"] = SKORY, ["DD Spurance"] = SPRUANCE, ["CG Ticonderoga"] = TICONDEROGA, ["Torpedo kater"] = TK, 
        ["FSG Nanuchka III"] = VETER, ["FFG Neustrashimy"] = NEUSTRASH
      },
      [wsType_CivilShip] = {
        ["Elnya"] = ELNYA,
        ["Zvezdny"] = ZWEZDNY,
        ["Yastrenov"] = YASTREBOW,
        ["Barge with sand"] = BARGE_WITH_SAND,
        ["Barge without sand"] = BARGE_WITHOUT_SAND,
        ["SS Kilo"] = KILO,
        ["SS Som"] = SOM,
      }
    }
  },
  [wsType_Weapon] = {
    [wsType_GContainer] = {
        [wsType_Control_Cont] = {
            ["PAVETACK AN/AVQ-26 FLIR/LDT"] = PAVETACK, ["LANTIRN F-14"] = LANTIRN_F14, ["LANTIRN F-16"] = LANTIRN, ["LANTIRN F-18"] = LANTIRN_F18, 
            ["AN/ASQ-173 LDT/CAM"] = AN_ASQ_173_LST_CAM, ["Litening AN/AAQ-28 FLIR/LDT"] = AN_AAQ_28_LITENING, ["AN/AAS-38 FLIR/LDT"] = AN_AAS_38_FLIR,
            ["Merkury LLTV"] = KINGAL, ["Kopyo radar"] = Kopyo, ["Fantasmagoria"] = FANTASM
        },
        [wsType_Jam_Cont] = {
            ["Sorbtsia L203 ECM"] = SORBCIJA, ["Siren SPS-141 ECM"] = SPS_141, ["AN/ALQ-131 ECM"] = ALQ_131, ["Sky Shadow ECM"] = Sky_Shadow
        },
        [wsType_Cannon_Cont] = {
        
        }
    },
    [wsType_Missile] = {
      [wsType_AA_Missile] = {
        ["R-550"] = R_550,
        ["MICA-T"] = MICA_T,
        ["MICA-R"] = MICA_R,
        ["Super530F"] = Super_530F,
        ["R-98"] = P_98,
        ["R-4R"] = P_4R,
        ["R-40R"] = P_40R,
        ["R-24R"] = P_24R,
        ["R-60"] = P_60,
        ["R-33E"] = P_33E,
        ["R-27AE"] = P_27AE,
        ["R-27R"] = P_27P,
        ["R-27RE"] = P_27PE,
        ["R-27T"] = P_27T,
        ["R-27TE"] = P_27TE,
        ["R-27EM"] = P_27EM,
        ["R-73"] = P_73,
        ["R-77"] = P_77,
        ["R-37"] = P_37,        
        ["AIM-7M"] = AIM_7,
        ["AIM-9M"] = AIM_9,
        ["AIM-54C"] = AIM_54,
        ["AIM-120"] = AIM_120,
        ["R-24T"] = P_24T,
        ["R-40T"] = P_40T,        
        ["AIM-120C"] = AIM_120C,
        ["AIM-9P"] = AIM_9P,
        ["AIM-9X"] = AIM_9X
      },
      [wsType_AS_Missile] = {
        ["AGM_114K"] = AGM_114K,
        ["AGM_119"] = AGM_119,
        ["X_22"] = X_22,
        ["X_29TE"] = X_29TE,
        ["X_23"] = X_23,
        ["X_28"] = X_28,
        ["X_25ML"] = X_25ML,
        ["X_58"] = X_58,
        ["X_25MP"] = X_25MP,
        ["AT_6"] = AT_6,
        ["AT_6X_29L"] = X_29L,
        ["X_55"] = X_55,
        ["X_65"] = X_65,
        ["X_15"] = X_15,
        ["X_31A"] = X_31A,
        ["X_59M"] = X_59M,
        ["X_41"] = X_41,
        ["Vikhr"] = Vikhr,
        ["Vikhr_M"] = Vikhr_M,
        ["AGM_114"] = AGM_114,
        ["AGM_45"] = AGM_45,
        ["AGM_65K"] = AGM_65K,
        ["AGM_84A"] = AGM_84A,
        ["AGM_84E"] = AGM_84E,
        ["AGM_86"] = AGM_86,
        ["AGM_88"] = AGM_88,
        ["Sea_Eagle"] = Sea_Eagle,
        ["AGM_122"] = AGM_122,
        ["AGM_123"] = AGM_123,
        ["AGM_65E"] = AGM_65E,
        ["AGM_130"] = AGM_130,
        ["ALARM"] = ALARM,
        ["X_23L"] = X_23L,
        ["X_25MR"] = X_25MR,
        ["X_29T"] = X_29T,
        ["X_31P"] = X_31P,
        ["AGM_65D"] = AGM_65D,
        ["Kormoran"] = Kormoran,
        ["AGM_154"] = AGM_154,
        ["S_25L"] = S_25L,
        ["AGM_65H"] = AGM_65H,
        ["AGM_65G"] = AGM_65G,
        ["TGM_65G"] = TGM_65G,
        ["TGM_65D"] = TGM_65D,
        ["CATM_65K"] = CATM_65K,
        ["CATM_9"] = CATM_9,
        ["TGM_65H"] = TGM_65H,
      },
      [wsType_SA_Missile] = {
        ["SeaSparrow"] = SeaSparrow,
        ["SAV611"] = SAV611,
        ["SM_2"] = SM_2,
        ["SA5B55"] = SA5B55,
        ["SA48H6E2"] = SA48H6E2,
        ["SA9M82"] = SA9M82,
        ["SA9M83"] = SA9M83,
        ["SA3M9M"] = SA3M9M,
        ["SA9M33"] = SA9M33,
        ["SA9M31"] = SA9M31,
        ["SA9M38M1"] = SA9M38M1,
        ["SA9M333"] = SA9M333,
        ["SA9M330"] = SA9M330,
        ["SA9M311"] = SA9M311,
        ["Igla_1E"] = Igla_1E,
        ["MIM_104"] = MIM_104,
        ["FIM_92C"] = FIM_92C,
        ["SA5B27"] = SA5B27,
        ["HAWK_RAKETA"] = HAWK_RAKETA,
        ["ROLAND_R"] = ROLAND_R,
        ["MIM_72G"] = MIM_72G
      },
      [wsType_SS_Missile] = {
        ["P_500P_35"] = P_35,
        ["P_500"] = P_500,
        ["P_700"] = P_700,
        ["P_15U"] = P_15U,
        ["P_120"] = P_120,
        ["R_85"] = R_85,
        ["R_85U"] = R_85U,
        ["BGM_109B"] = BGM_109B,
        ["AGM_84S"] = AGM_84S,
        ["GRAD_RAKETA"] = GRAD_RAKETA,
        ["SMERCH_RAKETA"] = SMERCH_RAKETA,
        ["URAGAN_RAKETA"] = URAGAN_RAKETA,
        ["M26_RAKETA"] = M26_RAKETA,
        ["MALUTKA"] = MALUTKA,
        ["KONKURS"] = KONKURS,
        ["P_9M117"] = P_9M117,
        ["TOW"] = TOW
      }
    },
    [wsType_Bomb] = {
      [wsType_Bomb_A] = {
            ["FAB_100"] = FAB_100,
            ["FAB_250"] = FAB_250,
            ["FAB_500"] = FAB_500,
            ["FAB_1000"] = FAB_1000,
            ["FAB_1500"] = FAB_1500,
            ["FAB_5000"] = FAB_5000,
            
            ["FAB_100P"] = FAB_100P,
            ["FAB_250P"] = FAB_250P,
            ["PB_250"] = PB_250,
            ["FAB_500P"] = FAB_500P,
            ["FAB_500_3"] = FAB_500_3,

            ["Puma"] = Puma,
            ["MW_1"] = MW_1,

            ["M_117"] = M_117,
            ["Mk_81"] = Mk_81,
            ["Mk_82"] = Mk_82,
            ["MK_82AIR"] = MK_82AIR,
            ["MK_82SNAKEYE"] = MK_82SNAKEYE,
            ["Mk_83"] = Mk_83,
            ["Mk_84"] = Mk_84   
      },
      [wsType_Bomb_Guided] = {
            ["KAB_500"] = KAB_500,
            ["KAB_500Kr"] = KAB_500Kr,
            ["KAB_500KrOD"] = KAB_500KrOD,
            ["KAB_1500Kr"] = KAB_1500Kr,
            
            ["AGM_62"] = AGM_62,
            ["GBU_10"] = GBU_10,
            ["GBU_11"] = GBU_11,
            ["GBU_12"] = GBU_12,
            ["GBU_16"] = GBU_16,
            ["GBU_17"] = GBU_17,
            ["GBU_24"] = GBU_24,
            ["GBU_15"] = GBU_15,
            ["GBU_27"] = GBU_27,
            ["GBU_22"] = GBU_22,
            ["GBU_28"] = GBU_28,
            ["GBU_29"] = GBU_29,
            ["GBU_30"] = GBU_30
      },
      [wsType_Bomb_BetAB] = {
            ["BetAB_150DS"] = BetAB_150DS,
            ["BetAB_250"] = BetAB_250,
            ["BetAB_500"] = BetAB_500,
            ["BetAB_500ShP"] = BetAB_500ShP,
            
            ["Durandal"] = Durandal,
      },
      [wsType_Bomb_Cluster] = {
            ["RBK_250"] = RBK_250,
            ["RBK_250S"] = RBK_250S,
            ["RBK_500AO"] = RBK_500AO,
            ["RBK_500SOAB"] = RBK_500SOAB,
            
            ["AO_2_5RT"] = AO_2_5RT,
            ["PTAB_2_5KO"]  = PTAB_2_5KO,
            
            ["BL_755"] = BL_755,
            
            ["CBU_97"] = CBU_97,
            ["CBU_87"] = CBU_87,
            ["CBU_89"] = CBU_89,
            ["ROCKEYE"] = ROCKEYE,
      },
      [wsType_Bomb_Antisubmarine] = {
        ["GluB"] = GluB, --DEPTH CHARGE
      },
      [wsType_Bomb_ODAB] = {
        ["ODAB_500PM"] = ODAB_500PM,
        ["ODAB_250"] = ODAB_250,
      },
      [wsType_Bomb_Fire] = {
        ["Z_BAK_3"] = Z_BAK_3,
        ["XZAB_250"] = XZAB_250,
        ["XZAB_500"] = XZAB_500     
      },
      [wsType_Bomb_Nuclear] = {
        ["NB_1"] = NB_1,
        ["NB_2"] = NB_2
      },
      [wsType_Bomb_Lighter] = {     
        ["SAB_100"] = SAB_100,
        
        ["LUU_2B"] = LUU_2B,
        ["LUU_2AB"] = LUU_2AB,
        ["LUU_2BB"] = LUU_2BB,
        ["LUU_1"] = LUU_1,
        ["LUU_5"] = LUU_5,
        ["LUU_6"] = LUU_6,
        ["LUU_19"] = LUU_19
      },
    },
    [wsType_Shell] = {
      [wsType_Shell_A] = {
      
      }
    },
    [wsType_NURS] = {
      [wsType_Container] = {
      },
      [wsType_Rocket] = {
      }
    }
  },
  [wsType_Static] = {
    [wsType_Airdrome] = {
      [wsType_RW1] = {
        ["Khersones"] = Khersones,
        ["Razdolnoe"] = Razdolnoe,
        ["Dzhankoy"] = Dzhankoy,
        ["Kirovskoe"] = Kirovskoe,
        ["Kerch"] = Kerch,
        ["Belbek"] = Belbek,
        ["Krasnogvardeyskoye"] = Krasnogvardeyskoye,
        ["Octyabrskoe"] = Octyabrskoe,
        ["Gvardeyskoe"] = Gvardeyskoe,
        ["Krasnodar"] = Krasnodar,
        ["Anapa"] = Anapa,
        ["Novorossiysk"] = Novorossiysk,
        ["Krymsk"] = Krymsk,
        ["Maykop"] = Maykop,
        ["Gelendzhik"] = Gelendzhik,
        ["Sochi"] = Sochi,
        ["Sukhumi"] = Sukhumi,
        ["Gudauta"] = Gudauta,
        ["Batumi"] = Batumi,
        ["Tskhakaya"] = Tskhakaya,
        ["Kobuleti"] = Kobuleti,
        ["Kutaisi"] = Kutaisi
      },
      [wsType_RW2] = {
        ["Saki"] = Saki,
        ["Simpheropol"] = Simpheropol,
        ["Krasnodar_P"] = Krasnodar_P
      },
      [wsType_Heliport] = {
        ["Helipad"] = Heliport_standart
      }
    },
    [wsType_AirdromePart] = {
      [wsType_RW1] = {
        ["1st runway"] = wsType_RunWay
      },
      [wsType_RW2] = {
        ["2nd runway"] = wsType_RunWay
      }
    },
    [wsType_Standing] = {
      [wsType_NoWeapon] = {
        ["Static flying vehicles"] = wsType_Air,
        ["Static ground vehicles"] = wsType_Tank,
        ["Static SAM"] = wsType_SAM,
        ["Static ship"] = wsType_Ship,
        ["Buildings"] = wsType_Test1,
        ["Point"] = wsType_Point,
      }
    }
  }
}

dofile("Scripts/Input/log.lua")

obj_arrays_log = LOG:new(LOG, "Temp/obj_arrays.log", true)
obj_arrays_log:add("wsTypes loading...\n")

wsType = {}
for lev1_it, lev1_tbl in pairs(WsTypeTree or {}) do
  for lev2_it, lev2_tbl in pairs(lev1_tbl or {}) do
    for lev3_it, lev3_tbl in pairs(lev2_tbl or {}) do
      for unit_name, lev4_const in pairs(lev3_tbl or {}) do
        if wsType[unit_name] == nil then
          obj_arrays_log:add("\""..unit_name.."\"\n")
          --4-level classificatior for each unit      
          wsType[unit_name] = {
            [lev1_it] = {
              [lev2_it] = {
                [lev3_it] = {lev4_const}
              }
            }
          }
        end
        obj_arrays_log:add(wsType[unit_name])
      end
    end
  end
end
