local my_db_path = db_path or "./scripts/database/"; dofile(my_db_path..'/scripts/GT.lua')
dofile(my_db_path..'/chassis/MAZ543M.lua')

-- 9К72 Эльбрус 8K14 Scud-B
GT = {}

GT.chassis = chassis; chassis = nil
GT.chassis.life = 2 

set_recursive_metatable(GT, GT_generic_wheel_vehicle)

GT.visual.shape = "URAGAN"
GT.visual.shape_dstr = "URAGAN_P_1"

GT.id = 34675469

--chassis
GT.max_rotate = 40.0
GT.r_max = 0.46
GT.swing_on_run = false
GT.fire_on_run = false

GT.sensor = {}
set_recursive_metatable(GT.sensor, SN_visual)
GT.sensor.height = 4.95

--Burning after hit
GT.visual.fire_size = 1 --relative burning size
GT.visual.fire_pos[1] = 1 -- center of burn at long axis shift(meters)
GT.visual.fire_pos[2] = 0 -- center of burn shift at vertical shift(meters)
GT.visual.fire_pos[3] = 0 -- center of burn at transverse axis shift(meters)
GT.visual.fire_time = 1200 --burning time (seconds)


GT.WS = {}
GT.WS.indirect_fire = true
GT.WS[inc_ws()] = {}
GT.WS[ws].newZ = true
GT.WS[ws].center = 'CENTER_TOWER'
GT.WS[ws].maxLeft = math.rad(25)
GT.WS[ws].maxRight = math.rad(-25)
GT.WS[ws].maxBottom = 0
GT.WS[ws].maxTop = math.rad(90)
GT.WS[ws].drawArgument1 = 0
GT.WS[ws].drawArgument2 = 1
GT.WS[ws].omegaY = math.rad(0.1)
GT.WS[ws].omegaZ = math.rad(0.1)
GT.WS[ws].reference_angle_Z = 0


GT.WS[ws].LN = {}
GT.WS[ws].LN[1] = {}
GT.WS[ws].LN[1].type = 34
GT.WS[ws].LN[1].xc = -1.466
GT.WS[ws].LN[1].out_velocity = 830
GT.WS[ws].LN[1].distanceMin = 20000
GT.WS[ws].LN[1].distanceMax = 300000
GT.WS[ws].LN[1].reactionTime = 1
GT.WS[ws].LN[1].rocket_name = "weapons.nurs.URAGAN_RAKETA";
GT.WS[ws].LN[1].major_weapon = true
GT.WS[ws].LN[1].ammunition_reserve = 1
GT.WS[ws].LN[1].launch_delay = 1.0
GT.WS[ws].LN[1].sound = { single_shot = "MissileLaunch2", }


GT.WS[ws].LN[1].sensor = {}
set_recursive_metatable(GT.WS[ws].LN[1].sensor, WSN_0)

GT.WS[ws].LN[1].PL = {}
GT.WS[ws].LN[1].PL[1] = {}
GT.WS[ws].LN[1].PL[1].reload_time = 3600
GT.WS[ws].LN[1].PL[1].ammo_capacity = 1
GT.WS[ws].LN[1].PL[1].shot_delay = 1.0

GT.WS[ws].LN[1].BR = { }
--GT.WS[ws].LN[1].BR[1] = { connector_name = "POINT_ROCKET_01", drawArgument = 4 }
GT.WS[ws].LN[1].BR[1] = {pos = {-3.00, 10.00, 0.00}, drawArgument = 4}


GT.CLSID = "{36E7F139-A83E-4097-90FE-587F9B6A3D3F}"
GT.name = "Scud"
GT.displayname = _("Scud")
GT.score = 100

register_car(
  {
        CLSID = GT.CLSID,
        Name = GT.name,
        DisplayName = GT.displayname,
        DetectionRange  = 0,
        ThreatRange = 0,
        Rate = GT.score,
        mapclasskey = "P0091000209",
  }, 
  {
  }
);

