-- Weapons' names.
-- Copyright (C) 2004, Eagle Dynamics.

-- the file is not intended for an end-user editing

-- pylons and containers names definitions

Pylons = {}
Pylons["mbd-3"]                 = 3    -- MBD_3
Pylons["lau-88"]            = 4    -- LAU_88
Pylons["b-20"]              = 6    -- B_20
Pylons["c-25+pu"]           = 7    -- S_25_C
Pylons["mbd"]               = 21   -- MBD
Pylons["mbd-4"]                 = 22   -- MBD_4
Pylons["tu-22m3-mbd"]       = 23   -- TU_22_MBD
Pylons["c-25pu"]            = 24   -- S_25_PU
Pylons["9m120"]             = 34   -- AT_9M120
Pylons["9m120m"]            = 35   -- AT_9M120M
Pylons["a10-pilon-dop"]     = 40   -- MBD_A10_2
Pylons["M299_AGM114"]       = 43   -- AGM_114_Pilon
Pylons["9m114-pilon"]       = 44   -- AT_6_9M114
Pylons["f4-pilon"]          = 45   -- F4_PILON
Pylons["pilon-2-r60"]       = 46   -- MER_L_P_60
Pylons["tow-pilon"]         = 48   -- MER_TOW
Pylons["b52-mbd_mk84"]      = 50   -- MER_9_B52
Pylons["b52-mbd_m117"]      = 51   -- MER_12_B52
Pylons["b52-mbd_agm86"]     = 52   -- MBD_6_B52
Pylons["boz-100"]           = 58   -- BOZ_100
Pylons["suu-25"]            = 70   -- SUU_25 -- not pylon
Pylons["mer2"]              = 73   -- mer-2
Pylons["apu-6"]                 = 75   -- apu-6
Pylons["MBD-2-67U"]             = 76   -- MBD-2-67U
Pylons["lau-118a"]              = 79   -- LAU_118A
Pylons["AKU-58"]            = 80   -- AKU_58
Pylons["KMGU-2"]            = 81   -- KMGU_2
Pylons["APU-68"]            = 92   -- APU_68
Pylons["APU-73"]            = 93   -- APU_73
Pylons["APU-170"]               = 96   -- APU_170
Pylons["LAU-117"]               = 97   -- LAU_117
Pylons["9K114_Shturm"]    = 100
Pylons["M272_AGM114"]     = M279_AGM114

-- 1
bombwsTypes = {}
bombwsTypes["{96A7F676-F956-404A-AD04-F33FB2C74885}"] = 2   -- BetAB_250
bombwsTypes["{35B698AC-9FEF-4EC4-AD29-484A0085F62B}"] = 3   -- BetAB_500
bombwsTypes["{BD289E34-DF84-4C5E-9220-4B14C346E79D}"] = 4   -- BetAB_500ShP
bombwsTypes["{FB3CE165-BF07-4979-887C-92B87F13276B}"] = 5   -- FAB_100
bombwsTypes["{3C612111-C7AD-476E-8A8E-2485812F4E5C}"] = 6   -- FAB_250
bombwsTypes["{37DCC01E-9E02-432F-B61D-10C166CA2798}"] = 7   -- FAB_500
bombwsTypes["{40AA4ABE-D6EB-4CD6-AEFE-A1A0477B24AB}"] = 9   -- FAB_1500
bombwsTypes["{BA565F89-2373-4A84-9502-A0E017D3A44A}"] = 11  -- KAB_500
bombwsTypes["{E2C426E3-8B10-4E09-B733-9CDC26520F48}"] = 12  -- KAB_500Kr
bombwsTypes["{F0ED00FC-24D6-4CD7-9EA5-DE4BEE69A5EA}"] = 13  -- KAB_500KrOD
bombwsTypes["{39821727-F6E2-45B3-B1F0-490CC8921D1E}"] = 14  -- KAB_1500Kr
bombwsTypes["{2A2C3F0A-723B-45C6-8D54-DD1B7B048A72}"] = 15  -- KMGU_2f
bombwsTypes["{023479E5-5C3C-4D11-B3D6-15D6E8BD5656}"] = 16  -- ODAB_500PM
bombwsTypes["{9B7C1444-7DA9-4338-99E1-16ECA2404B6C}"] = 17  -- ODAB_250
bombwsTypes["{4203753F-8198-4E85-9924-6F8FF679F9FF}"] = 18  -- RBK_250
bombwsTypes["{25298BA0-FC16-404F-9527-824DE0028D83}"] = 19  -- RBK_250S
bombwsTypes["{D5435F26-F120-4FA3-9867-34ACE562EF1B}"] = 20  -- RBK_500AO
bombwsTypes["{7AF1B3EA-1AD3-43B7-9212-4AEB2D482F63}"] = 21  -- RBK_500SOAB
bombwsTypes["{08164777-5E9C-4B08-B48E-5AA7AFB246E2}"] = 23  -- BL_755
-- bombwsTypes["{897D4395-EE32-4BF4-B225-A6B45383E74A}"] = 24  -- GluB
-- bombwsTypes["{4603A9D4-D1C1-4453-A098-06ECEC4E1CBC}"] = 27  -- Torpedo
bombwsTypes["{DF7A9A1F-6045-44BE-8F87-25D48CA5FC53}"] = 29  -- XZAB_500
bombwsTypes["{90321C8E-7ED1-47D4-A160-E074D5ABD902}"] = 30  -- Mk_81
bombwsTypes["{BCE4E030-38E9-423E-98ED-24BE3DA87C32}"] = 31  -- Mk_82
bombwsTypes["{7A44FF09-527C-4B7E-B42B-3F111CFE50FB}"] = 32  -- Mk_83
bombwsTypes["{AB8B8299-F1CC-4359-89B5-2172E0CF4A5A}"] = 33  -- Mk_84
bombwsTypes["{00F5DAC4-0466-4122-998F-B1A298E34113}"] = 34  -- M_117
bombwsTypes["{5335D97A-35A5-4643-9D9B-026C75961E52}"] = 35  -- CBU_97
bombwsTypes["{51F9AAE5-964F-4D21-83FB-502E3BFE5F8A}"] = 36  -- GBU_10
bombwsTypes["{DB769D48-67D7-42ED-A2BE-108D566C8B1E}"] = 38  -- GBU_12
bombwsTypes["{0D33DDAE-524F-4A4E-B5B8-621754FE3ADE}"] = 39  -- GBU_16
bombwsTypes["{34759BBC-AF1E-4AEE-A581-498FF7A6EBCE}"] = 41  -- GBU_24
bombwsTypes["{FAAFA032-8996-42BF-ADC4-8E2C86BCE536}"] = 42  -- GBU_15
bombwsTypes["{EF0A9419-01D6-473B-99A3-BEBDB923B14D}"] = 43  -- GBU_27
bombwsTypes["{ADD3FAE1-EBF6-4EF9-8EFC-B36B5DDF1E6B}"] = 45  -- ROCKEYE
bombwsTypes["{C40A1E3A-DD05-40D9-85A4-217729E37FAE}"] = 47  -- AGM_62
bombwsTypes["{F06B775B-FC70-44B5-8A9F-5B5E2EB839C7}"] = 48  -- GBU_28
bombwsTypes["{3227777E-1741-4DF2-9B52-E18CDF738FAE}"] = 53  -- FAB_100P
bombwsTypes["{4C551229-E03B-4D27-AE1A-C0B3E5CAAE72}"] = 54  -- FAB_250P
bombwsTypes["{4BEDA482-2C83-41A6-A174-83B4F24B4A6F}"] = 55  -- FAB_500P
bombwsTypes["{40A24F07-CD7D-4F83-89A2-39B2258B62C6}"] = 58  -- PB_250
bombwsTypes["{39998B84-11AC-474D-9413-33FCD2BF54BD}"] = 59  -- Z_BAK_3
bombwsTypes["{9CEE5354-E7E9-487C-AC9D-286DAB94046E}"] = 60  -- KMGU_2b
bombwsTypes["{752B9781-F962-11d5-9190-00A0249B6F00}"] = 62  -- Durandal
bombwsTypes["{0511E528-EA28-4caf-A212-00D1408DF10A}"] = 63  -- SAB_100


-- 2
bombLaunchTypes = {}
bombLaunchTypes["{F99BEC1A-869D-4AC7-9730-FBA0E3B1F5FC}"] = 1   -- MBD_FAB_100
bombLaunchTypes["{53BE25A4-C86C-4571-9BC0-47D668349595}"] = 2   -- MBD_FAB_250
bombLaunchTypes["{FA673F4C-D9E4-4993-AA7A-019A92F3C005}"] = 3   -- MBD_FAB_500
bombLaunchTypes["{C57AA721-4000-4D83-A47D-A7756A5B02D1}"] = 4   -- MBD_BETAB_250
bombLaunchTypes["{1AD2B3A9-4F97-41FD-8AF2-8C716C40B9F9}"] = 5   -- MBD_ODAB
bombLaunchTypes["{4ED18045-9F6B-4617-9D5D-2C95027DC862}"] = 6   -- MBD_PB_250
bombLaunchTypes["{67F0B926-E832-477B-A389-15C89BCF3DF5}"] = 7   -- MBD_RBK_250
bombLaunchTypes["{4D459A95-59C0-462F-8A57-34E80697F38B}"] = 8   -- MBD_RBK_500AO
bombLaunchTypes["{1F5F64A7-FC2D-4466-BC02-978C5866FFF3}"] = 9   -- MBD_RBK_500SOAB
bombLaunchTypes["{6389A1C7-BE31-4BF3-A98E-AE7D370C6AF4}"] = 11  -- MBD_CBU_97
bombLaunchTypes["{6CDB6B36-7165-47D0-889F-6625FB333561}"] = 12  -- MBD_M_117
bombLaunchTypes["{95334A8C-6ACB-4CB7-99BC-6D07B1479EDA}"] = 13  -- MBD_MK_81
bombLaunchTypes["{1C97B4A0-AA3B-43A8-8EE7-D11071457185}"] = 14  -- MBD_MK_82
bombLaunchTypes["{3C7CD675-7D39-41C5-8735-0F4F537818A8}"] = 15  -- MBD_Rockeye
bombLaunchTypes["{CEE04106-B9AA-46B4-9CD1-CD3FDCF0CE78}"] = 16  -- MBD_3_FAB_100
bombLaunchTypes["{D109EE9C-A1B7-4F1C-8D87-631C293A1D26}"] = 17  -- MBD_3_FAB_250
bombLaunchTypes["{A1E85991-B58E-4E92-AE91-DED6DC85B2E7}"] = 18  -- MBD_3_FAB_500
bombLaunchTypes["{59E49F29-26BD-4BF0-86A6-1ECECC43891D}"] = 19  -- MBD_3_BETAB_250
bombLaunchTypes["{E6D89769-4EDD-4334-A616-C99EB2D45852}"] = 20  -- MBD_3_ODAB
bombLaunchTypes["{2C3C1C53-1C24-4A95-BA8A-A50C5A3CDB29}"] = 21  -- MBD_3_PB_250
bombLaunchTypes["{EAD9B2C1-F3BA-4A7B-A2A5-84E2AF8A1975}"] = 22  -- MBD_3_RBK_250
bombLaunchTypes["{919CE839-9390-4629-BAF7-229DE19B8523}"] = 23  -- MBD_3_RBK_500AO
bombLaunchTypes["{50CD3A9E-452B-4FFE-B273-97F78A8F3797}"] = 24  -- MBD_3_RBK_500SOAB
bombLaunchTypes["{615BD817-6538-4CE1-84F5-10C9B3FDBC50}"] = 25  -- MBD_3_ZAB
bombLaunchTypes["{F3E2C806-CD30-42A9-8410-3F4030CF45D1}"] = 26  -- MBD_3_CBU_97
bombLaunchTypes["{82F90BEC-0E2E-4CE5-A66E-1E4ADA2B5D1E}"] = 27  -- MBD_3_M_117
bombLaunchTypes["{7B34E0BB-E427-4C2A-A61A-8407CE18B54D}"] = 28  -- MBD_3_MK_81
bombLaunchTypes["{60CC734F-0AFA-4E2E-82B8-93B941AB11CF}"] = 29  -- MBD_3_MK_82
bombLaunchTypes["{B83CB620-5BBE-4BEA-910C-EB605A327EF9}"] = 30  -- MBD_3_Rockeye
bombLaunchTypes["{88D49E04-78DF-4F08-B47E-B81247A9E3C5}"] = 31  -- MBD_3_GBU_16
bombLaunchTypes["{5A1AC2B4-CA4B-4D09-A1AF-AC52FBC4B60B}"] = 32  -- MBD_4_FAB_100
bombLaunchTypes["{5F1C54C0-0ABD-4868-A883-B52FF9FCB422}"] = 34  -- TU_22_FAB_100
bombLaunchTypes["{E1AAE713-5FC3-4CAA-9FF5-3FDCFB899E33}"] = 35  -- TU_22_FAB_250
bombLaunchTypes["{055D451B-5B2A-4AE5-AFD7-26456E5FEE0D}"] = 36  -- TU_22_BETAB_250
bombLaunchTypes["{C513553E-4C40-4A28-A70F-E546DD40563B}"] = 37  -- TU_22_PB_250
bombLaunchTypes["{BF83E8FD-E7A2-40D2-9608-42E13AFE2193}"] = 38  -- TU_22_RBK_250
bombLaunchTypes["{0D945D78-542C-4E9B-9A17-9B5008CC8D39}"] = 39  -- TU_22_FAB_500
bombLaunchTypes["{436C6FB9-8BF2-46B6-9DC4-F55ABF3CD1EC}"] = 40  -- TU_22_BETAB_500
bombLaunchTypes["{E96E1EDD-FF3F-47CF-A959-576C3B682955}"] = 41  -- TU_22_BETAB_500SP
bombLaunchTypes["{E1FF2417-5C0C-4A48-A616-40B908D3CD6A}"] = 42  -- TU_22_ODAB
bombLaunchTypes["{F503C276-FE15-4C54-B310-17B50B735A84}"] = 43  -- TU_22_RBK_500AO
bombLaunchTypes["{651545B8-C7C1-4179-BC54-798C56BD8726}"] = 44  -- TU_22_RBK_500SOAB
bombLaunchTypes["{D5D51E24-348C-4702-96AF-97A714E72697}"] = 51  -- MBD_F2_2_Mk_82
bombLaunchTypes["{18617C93-78E7-4359-A8CE-D754103EDF63}"] = 52  -- MBD_F2_2_Mk_83
bombLaunchTypes["{C535596E-F7D2-4301-8BB4-B1658BB87ED7}"] = 54  -- MBD_F2_2_BL_755
bombLaunchTypes["{0B9ABA77-93B8-45FC-9C63-82AFB2CB50A4}"] = 55  -- MBD_F2_2_ROCKEYE
bombLaunchTypes["{E659C4BE-2CD8-4472-8C08-3F28ACB61A8A}"] = 68  -- MBD_FAB_250_2
bombLaunchTypes["{5764B5C7-1AE1-4322-98F8-22EDCC8130FB}"] = 69  -- MBD_RBK_250_2
bombLaunchTypes["{79F3F0B6-3E00-4B05-9267-67B7E6AEA00E}"] = 70  -- MBD_BetAB_250_2
bombLaunchTypes["{7C5F0F5F-0A0B-46E8-937C-8922303E39A8}"] = 71  -- TU_22_FAB_1500_2
bombLaunchTypes["{005E70F5-C3EA-4E95-A148-C1044C42D845}"] = 72  -- MBD_3_BetAB_500
bombLaunchTypes["{F3754C5F-3EFB-4E81-BF4E-DF4BEF9F3D36}"] = 73  -- MER_2_F_18_CBU_97
bombLaunchTypes["{585D626E-7F42-4073-AB70-41E728C333E2}"] = 74  -- MER_12_B52_Mk_82
bombLaunchTypes["{752B9782-F962-11d5-9190-00A0249B6F00}"] = 75  -- MER_6_BLU_107
bombLaunchTypes["{574EDEDF-20DE-4942-B2A2-B2EDFD621562}"] = 76  -- MER_12_B52_M_117
bombLaunchTypes["{646D6121-F908-46BF-88A0-8530337792CC}"] = 77  -- MER_9_B52_CBU_97
bombLaunchTypes["{696CFFC4-0BDE-42A8-BE4B-0BE3D9DD723C}"] = 78  -- MER_9_B52_Mk_84
bombLaunchTypes["{4CD2BB0F-5493-44EF-A927-9760350F7BA1}"] = 79  -- MER_9_B52_Rockeye
bombLaunchTypes["{02B81892-7E24-4795-84F9-B8110C641AF0}"] = 80  -- MBD_4_RBK_250
bombLaunchTypes["{6A367BB4-327F-4A04-8D9E-6D86BDC98E7E}"] = 81  -- MBD_4_FAB_250
bombLaunchTypes["{3E35F8C3-052D-11d6-9191-00A0249B6F00}"] = 82  -- MER_6_2_PB_250
bombLaunchTypes["{3E35F8C2-052D-11d6-9191-00A0249B6F00}"] = 83  -- MER_6_4_PB_250
bombLaunchTypes["{3E35F8C1-052D-11d6-9191-00A0249B6F00}"] = 84  -- MER_6_4_FAB_250
bombLaunchTypes["{CAE48299-A294-4bad-8EE6-89EFC5DCDF00}"] = 85  -- SUU_25_8_LUU_2
bombLaunchTypes["{29A828E2-C6BB-11d8-9897-000476191836}"] = 88  -- MBD_2_67U_FAB_100
bombLaunchTypes["{96A7F676-F956-404A-AD04-F33FB2C74884}"] = 94  -- KMGU_2_AO_2_5RT
bombLaunchTypes["{96A7F676-F956-404A-AD04-F33FB2C74881}"] = 95  -- KMGU_2_PTAB_2_5KO

-- 3
bombLukeTypes = {}
-- bombLukeTypes["{D3ABF208-FA56-4D56-BB31-E0D931D57AE3}"] = 1   -- Mk_84_28
bombLukeTypes["{D3ABF208-FA56-4D56-BB31-E0D931D57AE3}"] = 20  -- Mk_82_27
bombLukeTypes["{E79759F7-C622-4AA4-B1EF-37639A34D924}"] = 2   -- Rockeye_Mk_20_6
bombLukeTypes["{6DD77472-0387-47C1-B020-CEBB0E9C7931}"] = 3   -- CBU_97_10
bombLukeTypes["{B8C99F40-E486-4040-B547-6639172A5D57}"] = 4   -- GBU_27_4
bombLukeTypes["{72CAC282-AE18-490B-BD4D-35E7EE969E73}"] = 5   -- M_117_51
bombLukeTypes["{B84DFE16-6AC7-4854-8F6D-34137892E166}"] = 6   -- Mk_82_51
bombLukeTypes["{027563C9-D87E-4A85-B317-597B510E3F03}"] = 7   -- Mk_82_6
bombLukeTypes["{ACADB374-6D6C-45A0-BA7C-B22B2E108AE4}"] = 8   -- Mk_20_18
bombLukeTypes["{F092B80C-BB54-477E-9408-66DEEF740008}"] = 9   -- Mk_84_18
bombLukeTypes["{BDAD04AA-4D4A-4E51-B958-180A89F963CF}"] = 10  -- FAB_250_33
bombLukeTypes["{AD5E5863-08FC-4283-B92C-162E2B2BD3FF}"] = 11  -- FAB_500_33
bombLukeTypes["{B0241BD2-5628-47E0-954C-A8675B7E698E}"] = 12  -- FAB_250_24
bombLukeTypes["{26D2AF37-B0DF-4AB6-9D61-A150FF58A37B}"] = 13  -- FAB_500_6
bombLukeTypes["{E70446B7-C7E6-4B95-B685-DEA10CAD1A0E}"] = 14  -- FAB_500_12
bombLukeTypes["{639DB5DD-CB7E-4E42-AC75-2112BC397B97}"] = 15  -- FAB_1500kr_3
bombLukeTypes["{D9179118-E42F-47DE-A483-A6C2EA7B4F38}"] = 16  -- FAB_1500kr_6
bombLukeTypes["{AA0574F6-71A6-45C4-897B-584DF1CBE638}"] = 17  -- BetAB_250_24
bombLukeTypes["{2B7BDB38-4F45-43F9-BE02-E7B3141F3D24}"] = 18  -- BetAB_500_6
bombLukeTypes["{D6A0441E-6794-4FEB-87F7-E68E2290DFAB}"] = 19  -- BetAB_500_1
bombLukeTypes["{6C47D097-83FF-4FB2-9496-EAB36DDF0B05}"] = 20  -- Mk_82_27
bombLukeTypes["{DE251B06-3433-4F7A-B036-614179C919FD}"] = 21  -- CBU_97_6
bombLukeTypes["{B58F99BA-5480-4572-8602-28B0449F5260}"] = 22  -- M_117_27
bombLukeTypes["{62BE78B1-9258-48AE-B882-279534C0D278}"] = 23  -- GBU_10_2
bombLukeTypes["{89D000B0-0360-461A-AD83-FB727E2ABA98}"] = 24  -- GBU_12_2
bombLukeTypes["{EB969276-1922-4ED1-A5CB-18590F45D7FE}"] = 25  -- GBU_27_2


-- 4

missileTypes = {}
missileTypes["{FC23864E-3B80-48E3-9C03-4DA8B1D7497B}"] = 1   -- R_550
missileTypes["{0DA03783-61E4-40B2-8FAE-6AEE0A5C5AAE}"] = 2   -- MICA_T
missileTypes["{6D778860-7BB8-4ACB-9E95-BA772C6BBC2C}"] = 3   -- MICA_R
missileTypes["{FD21B13E-57F3-4C2A-9F78-C522D0B5BCE1}"] = 4   -- Super_530F
missileTypes["{4EDBA993-2E34-444C-95FB-549300BF7CAF}"] = 7   -- P_40R
missileTypes["{CCF898C9-5BC7-49A4-9D1E-C3ED3D5166A1}"] = 9   -- P_24R
missileTypes["{682A481F-0CB5-4693-A382-D00DD4A156D7}"] = 10  -- P_60
missileTypes["{F1243568-8EF0-49D4-9CB5-4DA90D92BC1D}"] = 11  -- P_33E
missileTypes["{3331E15D-A833-4639-B9E4-A61A37DC1956}"] = 12  -- P_27AE
missileTypes["{9B25D316-0434-4954-868F-D51DB1A38DF0}"] = 13  -- P_27P
missileTypes["{E8069896-8435-4B90-95C0-01A03AE6E400}"] = 14  -- P_27PE
missileTypes["{88DAC840-9F75-4531-8689-B46E64E42E53}"] = 15  -- P_27T
missileTypes["{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}"] = 16  -- P_27TE
missileTypes["{D841D0F9-5ED1-4E27-AA4B-020A492E7454}"] = 17  -- P_27EM
missileTypes["{FBC29BFE-3D24-4C64-B81D-941239D12249}"] = 18  -- P_73
missileTypes["{B4C01D60-A8A3-4237-BD72-CA7655BC0FE9}"] = 19  -- P_77
missileTypes["{2061854C-60C4-41B1-8F1E-3FCC624280B5}"] = 20  -- P_37
missileTypes["{8D399DDA-FF81-4F14-904D-099B34FE7918}"] = 21  -- AIM_7
missileTypes["{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}"] = 22  -- AIM_9
missileTypes["{7575BA0B-7294-4844-857B-031A144B2595}"] = 23  -- AIM_54
missileTypes["{C8E06185-7CD6-4C90-959F-044679E90751}"] = 24  -- AIM_120B Non rotated missile
missileTypes["{33556742-C0F5-4643-BD8F-530B4DEC719B}"] = 24  -- AIM_120B Rotated at 45 degree counter-clockwise
missileTypes["{02CAFD34-010A-4874-8506-4A7C89210353}"] = 24  -- AIM_120B Rotated at 45 degree clockwise
missileTypes["{34271A1E-477E-4754-8C72-DF7C1855A782}"] = 24  -- AIM_120B Rotated at 90 degree counter-clockwise
missileTypes["{D078E3E5-30C1-444e-A09E-6EEDCD334582}"] = 24  -- AIM_120B Rotated at 90 degree clockwise
missileTypes["{6980735A-44CC-4BB9-A1B5-591532F1DC69}"] = 26  -- P_24T
missileTypes["{5F26DBC2-FB43-4153-92DE-6BBCE26CB0FF}"] = 27  -- P_40T
missileTypes["{7B8DCEB4-820B-4015-9B48-1028A4195692}"] = 40  -- AGM_119
missileTypes["{12429ECF-03F0-4DF6-BCBD-5D38B6343DE1}"] = 41  -- X_22
missileTypes["{AF95DDDF-34A5-4D2A-9B3F-FDA0036D4994}"] = 42  -- X_29TE
missileTypes["{AEB7B577-CF6F-4045-973D-0D64F8C52D9C}"] = 43  -- X_23
missileTypes["{D2A5BEA8-8DE3-4CD9-9453-082BCF30498E}"] = 44  -- X_28
missileTypes["{6DADF342-D4BA-4D8A-B081-BA928C4AF86D}"] = 45  -- X_25ML
missileTypes["{FE382A68-8620-4AC0-BDF5-709BFE3977D7}"] = 46  -- X_58
missileTypes["{E86C5AA5-6D49-4F00-AD2E-79A62D6DDE26}"] = 47  -- X_25MP
missileTypes["{3468C652-E830-4E73-AFA9-B5F260AB7C3D}"] = 49  -- X_29L
missileTypes["{A575E38F-BE2A-43E0-BA41-44779885CE99}"] = 50  -- X_55
missileTypes["{BADAF2DE-68B5-472A-8AAC-35BAEFF6B4A1}"] = 51  -- X_65
missileTypes["{E543875D-6475-4355-88ED-B4FDBF7EF221}"] = 52  -- X_15
missileTypes["{4D13E282-DF46-4B23-864A-A9423DFDE504}"] = 53  -- X_31A
missileTypes["{40AB87E8-BEFB-4D85-90D9-B2753ACF9514}"] = 54  -- X_59M
missileTypes["{2234F529-1D57-4496-8BB0-0150F9BDBBD2}"] = 55  -- X_35
missileTypes["{3F26D9C5-5CC3-4E42-BC79-82FAA54E9F26}"] = 56  -- X_41
missileTypes["{3E6B632D-65EB-44D2-9501-1C2D04515404}"] = 60  -- AGM_45
missileTypes["{69DC8AE7-8F77-427B-B8AA-B19D3F478B65}"] = 61  -- AGM_65K
missileTypes["{8B7CADF9-4954-46B3-8CFB-93F2F5B90B03}"] = 62  -- AGM_84A
missileTypes["{AF42E6DF-9A60-46D8-A9A0-1708B241AADB}"] = 63  -- AGM_84E
missileTypes["{769A15DF-6AFB-439F-9B24-5B7A45C59D16}"] = 64  -- AGM_86
missileTypes["{B06DD79A-F21E-4EB9-BD9D-AB3844618C9C}"] = 65  -- AGM_88
missileTypes["{1461CD18-429A-42A9-A21F-4C621ECD4573}"] = 66  -- Sea_Eagle
missileTypes["{E1958215-98BF-4D15-8D39-609AFB08B96D}"] = 69  -- AGM_123
missileTypes["{E6747967-B1F0-4C77-977B-AB2E6EB0C102}"] = 72  -- ALARM
missileTypes["{9F390892-E6F9-42C9-B84E-1136A881DCB2}"] = 73  -- X_23L
missileTypes["{292960BB-6518-41AC-BADA-210D65D5073C}"] = 74  -- X_25MR
missileTypes["{B4FC81C9-B861-4E87-BBDC-A1158E648EBF}"] = 75  -- X_29T
missileTypes["{D8F2C90B-887B-4B9E-9FE2-996BC9E9AF03}"] = 76  -- X_31P
missileTypes["{444BA8AE-82A7-4345-842E-76154EFCCA47}"] = 77  -- AGM_65D
missileTypes["{7210496B-7B81-4B52-80D6-8529ECF847CD}"] = 78  -- Kormoran
missileTypes["{9BCC2A2B-5708-4860-B1F1-053A18442067}"] = 132 -- AGM_154
missileTypes["{F16A4DE0-116C-4A71-97F0-2CF85B0313EF}"] = 70  -- AGM_65E
missileTypes["{ee368869-c35a-486a-afe7-284beb7c5d52}"] = 59  -- AGM_114
missileTypes["{9BFD8C90-F7AE-4e90-833B-BFD0CED0E536}"] = 135  -- AIM_9P
missileTypes["{5CE2FF2A-645A-4197-B48D-8720AC69394F}"] = 136  -- AIM_9X
missileTypes["{40EF17B7-F508-45de-8566-6FFECC0C1AB8}"] = 106  -- AIM_120C Non rotated missile
missileTypes["{DA8F810A-EA40-4091-8127-CC2E026041E7}"] = 106  -- AIM_120C Rotated at 45 degree counter-clockwise
missileTypes["{446E122B-8E9D-457e-AE8E-7AE88E3E566B}"] = 106  -- AIM_120C Rotated at 45 degree clockwise
missileTypes["{6FBCDCD7-F984-4202-84A7-15173E02CC5B}"] = 106  -- AIM_120C Rotated at 90 degree counter-clockwise
missileTypes["{9701DB51-AECB-42c6-A4F6-D5D8793E4D81}"] = 106  -- AIM_120C Rotated at 90 degree clockwise



-- 5
missileLaunchTypes = {} 
missileLaunchTypes["{907D835F-E650-4154-BAFD-C656882555C0}"] = 33  -- LAU_88_AGM_65K
missileLaunchTypes["{F789E86A-EE2E-4E6B-B81E-D5E5F903B6ED}"] = 47  -- VICHR_M
missileLaunchTypes["{DB434044-F5D0-4F1F-9BA9-B73027E18DD3}"] = 50  -- MBD_A10_2_AIM_9
missileLaunchTypes["{07BE2D19-0E48-4B0B-91DA-5F6C8F9E3C75}"] = 56  -- MBD_F2_2_ALARM
missileLaunchTypes["{DAC53A2F-79CA-42FF-A77A-F5649B601308}"] = 48  -- LAU_88_AGM_65D
missileLaunchTypes["{71AAB9B8-81C1-4925-BE50-1EF8E9899271}"] = 49  -- LAU_88_AGM_65E
missileLaunchTypes["{03572151-181E-41FF-9F02-485FBEB2F6CC}"] = 58  -- AGM_114_Pilon_4
missileLaunchTypes["{88D18A5E-99C8-4B04-B40B-1C02F2018B6E}"] = 59  -- AGM_114K_Pilon_4
missileLaunchTypes["{B919B0F4-7C25-455E-9A02-CEA51DB895E3}"] = 60  -- SHTURM
missileLaunchTypes["{9DDF5297-94B9-42FC-A45E-6E316121CD85}"] = 61  -- MER_AIM_9_2
missileLaunchTypes["{B0DBC591-0F52-4F7D-AD7B-51E67725FB81}"] = 62  -- MER_L_P_60_2
missileLaunchTypes["{275A2855-4A79-4B2D-B082-91EA2ADF4691}"] = 63  -- MER_R_P_60_2
missileLaunchTypes["{3EA17AB0-A805-4D9E-8732-4CE00CB00F17}"] = 64  -- MER_TOW_4
missileLaunchTypes["{D7670BC7-881B-4094-906C-73879CF7EB28}"] = 65  -- LAU_88_AGM_65K_2_LEFT
missileLaunchTypes["{E6A6262A-CA08-4B3D-B030-E1A993B98452}"] = 66  -- LAU_88_AGM_65D_2_LEFT
missileLaunchTypes["{45447F82-01B5-4029-A572-9AAD28AF0275}"] = 67  -- MER_6_AGM_86C
missileLaunchTypes["{A6FD14D3-6D30-4C85-88A7-8D17BEE120E2}"] = 86  -- APU_6_VICHR_M
missileLaunchTypes["{0180F983-C14A-11d8-9897-000476191836}"] = 87  -- S_25L_PU
missileLaunchTypes["{B06DD79A-F21E-4EB9-BD9D-AB3844618C93}"] = 89  -- LAU_118A_AGM_88
missileLaunchTypes["{3E6B632D-65EB-44D2-9501-1C2D04515405}"] = 90  -- LAU_118A_AGM_45
missileLaunchTypes["{B5CA9846-776E-4230-B4FD-8BCC9BFB1676}"] = 91  -- AKU_58_X_58
missileLaunchTypes["{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}"] = 92  -- AKU_58_X_29T
missileLaunchTypes["{D4A8D9B9-5C45-42e7-BBD2-0E54F8308432}"] = 93  -- AKU_58_X_29L
missileLaunchTypes["{4D13E282-DF46-4B23-864A-A9423DFDE50A}"] = 96  -- AKU_58_X_31A
missileLaunchTypes["{D8F2C90B-887B-4B9E-9FE2-996BC9E9AF0A}"] = 97  -- AKU_58_X_31P
missileLaunchTypes["{2234F529-1D57-4496-8BB0-0150F9BDBBD3}"] = 98  -- AKU_58_X_35
missileLaunchTypes["{79D73885-0801-45a9-917F-C90FE1CE3DFC}"] = 99  -- APU_68_X_25ML
missileLaunchTypes["{752AF1D2-EBCC-4bd7-A1E7-2357F5601C70}"] = 100  -- APU_68_X_25MP
--missileLaunchTypes["{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}"] = 101  -- APU_68_C_24
missileLaunchTypes["{CBC29BFE-3D24-4C64-B81D-941239D12249}"] = 102  -- APU_73_P_73
missileLaunchTypes["{B4C01D60-A8A3-4237-BD72-CA7655BC0FEC}"] = 103  -- APU_170_P_77
missileLaunchTypes["{2cc29c7a-e863-411c-8a6e-bd6f0e730548}"] = 104  -- LAU_88_AGM_65E_2_LEFT
missileLaunchTypes["{D7670BC7-881B-4094-906C-73879CF7EB27}"] = 105  -- LAU_88_AGM_65K_2_RIGHT
missileLaunchTypes["{E6A6262A-CA08-4B3D-B030-E1A993B98453}"] = 106  -- LAU_88_AGM_65D_2_RIGHT
missileLaunchTypes["{2cc29c7a-e863-411c-8a6e-bd6f0e730547}"] = 107  -- LAU_88_AGM_65E_2_RIGHT
missileLaunchTypes["{69DC8AE7-8F77-427B-B8AA-B19D3F478B66}"] = 108  -- LAU_117_AGM_65K
missileLaunchTypes["{444BA8AE-82A7-4345-842E-76154EFCCA46}"] = 109  -- LAU_117_AGM_65D
missileLaunchTypes["{F16A4DE0-116C-4A71-97F0-2CF85B0313EC}"] = 110  -- LAU_117_AGM_65E
missileLaunchTypes["{3C0745ED-8B0B-42eb-B907-5BD5C1717447}"] = 111  -- LAU-105_AIM-9P_2 A-10A
missileLaunchTypes["{773675AB-7C29-422f-AFD8-32844A7B7F17}"] = 112  -- LAU-7_AIM_9P_2 F-4
missileLaunchTypes["{57232979-8B0F-4db7-8D9A-55197E06B0F5}"] = 113  -- 9M114 Shturm-V x 8

-- LAU_117_AGM_65H
missileLaunchTypes["{051CBF0C-C764-4115-B965-A3586225548E}"] = 114
-- LAU_117_AGM_65G
missileLaunchTypes["{673D20F3-75AE-4404-BDA9-C11B936B3E22}"] = 115
-- LAU_117_TGM_65D
missileLaunchTypes["{E87BE223-AB23-4955-996C-56ACFB6F3ECD}"] = 116
-- LAU_117_TGM_65G
missileLaunchTypes["{F1A92695-5C3C-4ab4-A9E9-861F78785B21}"]  = 117
-- LAU_117_CATM_65K
missileLaunchTypes["{29E50F31-C10C-4fe0-876F-E15969956095}"] = 118

missileLaunchTypes["AGM114x2_OH_58"] = 119


-- 6
missileLukeTypes = {}
missileLukeTypes["{4F34B11C-C9F2-4FE9-9D89-ED8873C40F10}"] = 1   -- Kh_15_6
missileLukeTypes["{09FC601C-043B-4B66-8D3F-EDD725C8E84E}"] = 2   -- Kh_55_6
missileLukeTypes["{67DBD674-E298-431F-8E95-1F4B4BCE5138}"] = 3   -- Kh_55_8
missileLukeTypes["{CD9417DF-455F-4176-A5A2-8C58D61AA00B}"] = 4   -- Kh_65_8
missileLukeTypes["{0290F5DE-014A-4BB1-9843-D717749B1DED}"] = 5   -- Kh_65_6
missileLukeTypes["{C42EE4C3-355C-4B83-8B22-B39430B8F4AE}"] = 6   -- Kh_35_6
missileLukeTypes["{AABA1A14-78A1-4E85-94DD-463CF75BD9E4}"] = 7   -- AGM_154_4
missileLukeTypes["{22906569-A97F-404B-BA4F-D96DBF94D05E}"] = 8   -- AGM_86C_20
missileLukeTypes["{46ACDCF8-5451-4E26-BDDB-E78D5830E93C}"] = 9   -- AGM_84A_8
missileLukeTypes["{8DCAF3A3-7FCF-41B8-BB88-58DEDA878EDE}"] = 10  -- AGM_86C_8

-- 7
tbTypes = {}
tbTypes["{7D7EC917-05F6-49D4-8045-61FC587DD019}"] = 5   -- PTB_3000
tbTypes["{E1F29B21-F291-4589-9FD8-3272EEC69506}"] = 10  -- F_15_PTB
tbTypes["{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}"] = 11  -- F_16_PTB_N1
tbTypes["{8A0BE8AE-58D4-4572-9263-3144C0D06364}"] = 12  -- F_16_PTB_N2
tbTypes["{9F91BA74-BC3F-42F1-8907-3E5E0266F68A}"] = 13  -- F_18_PTB
tbTypes["{A5BAEAB7-6FAF-4236-AF72-0FD900F493F9}"] = 14  -- MIG_23_PTB
tbTypes["{0855A3A1-FA50-4C89-BDBB-5D5360ABA071}"] = 15  -- MIG_25_PTB
tbTypes["{414E383A-59EB-41BC-8566-2B5E0788ED1F}"] = 16  -- PTB_1150
tbTypes["{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}"] = 17  -- PTB_1500
tbTypes["{0395076D-2F77-4420-9D33-087A4398130B}"] = 36  -- F_5_PTB
tbTypes["{EF124821-F9BB-4314-A153-E0E2FE1162C4}"] = 38  -- PTB_F2_1500
tbTypes["{414DA830-B61A-4F9E-B71B-C2F6832E1D7A}"] = 39  -- M2000_PTB
tbTypes["{7B4B122D-C12C-4DB4-834E-4D8BB4D863A8}"] = 41  -- F4_PTB_WING
tbTypes["{8B9E3FD0-F034-4A07-B6CE-C269884CC71B}"] = 42  -- F4_PTB_FUZ
tbTypes["{16602053-4A12-40A2-B214-AB60D481B20E}"] = 53  -- PTB_2000
tbTypes["{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}"] = 54  -- PTB_800L_Wing
tbTypes["{A504D93B-4E80-4B4F-A533-0D9B65F2C55F}"] = 55  -- PTB_S_3
tbTypes["{82364E69-5564-4043-A866-E13032926C3E}"] = 56  -- PTB_367GAL
tbTypes["{C0FF4842-FBAC-11d5-9190-00A0249B6F00}"] = 61  -- PTB_1150_29
tbTypes["{EFEC8200-B922-11d7-9897-000476191836}"] = 71  -- F_18A_PTB
tbTypes["{EFEC8201-B922-11d7-9897-000476191836}"] = 72  -- F_18C_PTB
tbTypes["{B99EE8A8-99BC-4a8d-89AC-A26831920DCE}"] = 99  -- PTB-KA-50

    
-- 8
pomehContTypes = {}
pomehContTypes["{6D21ECEA-F85B-4E8D-9D51-31DC9B8AA4EF}"] = 25  -- ALQ_131
pomehContTypes["{F75187EF-1D9E-4DA9-84B4-1A1A14A3973A}"] = 30  -- SPS_141
pomehContTypes["{44EE8698-89F9-48EE-AF36-5FD31896A82F}"] = 29  -- SORBCIJA
pomehContTypes["{44EE8698-89F9-48EE-AF36-5FD31896A82A}"] = 29  -- SORBCIJA
pomehContTypes["{8C3F26A2-FA0F-11d5-9190-00A0249B6F00}"] = 37  -- Sky_Shadow
pomehContTypes["{44EE8698-89F9-48EE-AF36-5FD31896A82D}"] = 94  -- MPS_410
pomehContTypes["{44EE8698-89F9-48EE-AF36-5FD31896A82C}"] = 94  -- MPS_410


-- 9
uprContTypes = {}
uprContTypes["{CAAC1CFD-6745-416B-AFA4-CB57414856D0}"] = 26  -- LANTIRN
uprContTypes["{C2E594C1-025D-41EE-9AE3-A4C5096EC013}"] = 27  -- LANTIRN_F18
uprContTypes["{199D6D51-1764-497E-9AE5-7D07C8D4D87E}"] = 28  -- PAVETACK
uprContTypes["{B1EF6B0E-3D91-4047-A7A5-A99E7D8B4A8B}"] = 19  -- KINGAL
uprContTypes["{8C3F26A1-FA0F-11d5-9190-00A0249B6F00}"] = 58  -- BOZ_100
uprContTypes["{D1744B93-2A8A-4C4D-B004-7A09CD8C8F3F}"] = 59  -- LANTIRN_F14
uprContTypes["{C5D02390-D28B-49C4-8E24-07B4438CB628}"] = 60  -- FLIR_POD
uprContTypes["{0519A262-0AB6-11d6-9193-00A0249B6F00}"] = 62  -- TANGAZH
uprContTypes["{0519A261-0AB6-11d6-9193-00A0249B6F00}"] = 63  -- EPHIR
uprContTypes["{0519A263-0AB6-11d6-9193-00A0249B6F00}"] = 64  -- SHPIL
uprContTypes["{0519A264-0AB6-11d6-9193-00A0249B6F00}"] = 65  -- FANTASM
uprContTypes["{D3F65166-1AB8-490f-AF2F-2FB6E22568B1}"] = 66  -- SmokeGenerator_red
uprContTypes["{A4BCC903-06C8-47bb-9937-A30FEDB4E741}"] = 67  -- SmokeGeneratorAIM_red
uprContTypes["{6C0D552F-570B-42ff-9F6D-F10D9C1D4E1C}"] = 74  -- AN_AAS_38_FLIR
uprContTypes["{1C2B16EB-8EB0-43de-8788-8EBB2D70B8BC}"] = 78  -- AN_ASQ_173_LST_CAM
uprContTypes["{D3F65166-1AB8-490f-AF2F-2FB6E22568B2}"] = 82  -- SmokeGenerator_green
uprContTypes["{D3F65166-1AB8-490f-AF2F-2FB6E22568B3}"] = 83  -- SmokeGenerator_blue
uprContTypes["{D3F65166-1AB8-490f-AF2F-2FB6E22568B4}"] = 84  -- SmokeGenerator_white
uprContTypes["{D3F65166-1AB8-490f-AF2F-2FB6E22568B5}"] = 85  -- SmokeGenerator_yellow
uprContTypes["{D3F65166-1AB8-490f-AF2F-2FB6E22568B6}"] = 86  -- SmokeGenerator_orange
uprContTypes["{A4BCC903-06C8-47bb-9937-A30FEDB4E742}"] = 87  -- SmokeGeneratorAIM_green
uprContTypes["{A4BCC903-06C8-47bb-9937-A30FEDB4E743}"] = 88  -- SmokeGeneratorAIM_blue
uprContTypes["{A4BCC903-06C8-47bb-9937-A30FEDB4E744}"] = 89  -- SmokeGeneratorAIM_white
uprContTypes["{A4BCC903-06C8-47bb-9937-A30FEDB4E745}"] = 90  -- SmokeGeneratorAIM_yellow
uprContTypes["{A4BCC903-06C8-47bb-9937-A30FEDB4E746}"] = 91  -- SmokeGeneratorAIM_orange
uprContTypes["{F4920E62-A99A-11d8-9897-000476191836}"] = 95  -- Kopyo
uprContTypes["{A111396E-D3E8-4b9c-8AC9-2432489304D5}"] = 101 -- AN/AAQ-28 LITENING
-- 10
nursTypes = {}
nursTypes["{1FA14DEA-8CDB-45AD-88A8-EC068DF1E65A}"] = 34  -- C_24
nursTypes["{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}"] = 101 -- APU_68_C_24

-- 11
nursContTypes = {}
nursContTypes["{FC56DF80-9B09-44C5-8976-DCFAFF219062}"] = 1   -- UB_13
nursContTypes["{637334E4-AB5A-47C0-83A6-51B7F1DF3CD5}"] = 2   -- UB_32_1
nursContTypes["{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}"] = 6   -- B_20
nursContTypes["{A0648264-4BC0-4EE8-A543-D119F6BA4257}"] = 7   -- S_25_C
nursContTypes["{F3EFE0AB-E91A-42D8-9CA2-B63C91ED570A}"] = 8   -- LAU_10
nursContTypes["{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}"] = 9   -- LAU_61
nursContTypes["{A76344EB-32D2-4532-8FA2-0C1BDC00747E}"] = 33  -- MBD_3_LAU_61
nursContTypes["{3DFB7320-AB0E-11d7-9897-000476191836}"] = 68  -- B_20CM
nursContTypes["{3DFB7321-AB0E-11d7-9897-000476191836}"] = 69  -- Whiskey_Pete
nursContTypes["{E92CBFE5-C153-11d8-9897-000476191836}"] = 18  -- SPPU_22 -- actually gun pod
nursContTypes["{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}"] = 98  -- B_8V20A
nursContTypes["{05544F1A-C39C-466b-BC37-5BD1D52E57BB}"] = 20  -- UPK-23-250
nursContTypes["oh-58-brauning"]             = OH_58_BRAUNING -- OH-58-brauning
nursContTypes["M260_HYDRA"]                 = LAU_131 -- M260
nursContTypes["M260_HYDRA_WP"]              = LAU_131WP -- M260
nursContTypes["B_8V20A_CM"]                 = B_8V20A_WP
nursContTypes["B_8V20A_OFP2"]               = B_8V20A_OFP2
nursContTypes["B_8V20A_OM"]                 = B_8V20A_OM
nursContTypes["B-8M1 - 20 S-8OFP2"]         = B_8M1_OFP2


-----------------------------Object  CLSID map----------------------------------------------------------------------------------------------------------------------------------------------------
laTypes = {}
laTypes["{A00E562B-1DC8-4671-9EBF-C1CDC2506AE7}"] =  MiG_23;--  =  1; -- MiG-23 Flogger 
laTypes["{6BCCD081-F937-11d5-9190-00A0249B6F00}"] =  MiG_29;--  =  2; -- MiG-29 Fulcrum 
laTypes["{6FFE10D7-723E-46B0-AB8F-71B8B3D7572B}"] =  Su_27;--   =  3; -- Su-27 Flanker  
laTypes["{35ED40B9-C66A-4A80-AC29-04B041552520}"] =  Su_33;--   =  4;   -- Su-33            
laTypes["{919CA6E6-B44C-4144-96B2-38C959F377B1}"] =  F_14;--    =  5;   -- F-14 Tomcat              
laTypes["{CD247E45-4702-4E3A-A659-4F5E0E645D2B}"] =  F_15;--    =  6;   -- F-15 Eagle   
laTypes["{B5B20CFE-3D22-4EC0-A5C4-DDCDD68B5318}"] =  F_16;--    =  7;   -- F-16 Fighting Falcon
laTypes["{082D2561-FB8B-11d5-9190-00A0249B6F00}"] =  F_16;--    =  7;   -- F-16 Fighting Falcon
laTypes["{FB7FDABF-24F4-4311-AD7A-331CB382E9FA}"] =  MiG_25;--  =  8;   -- MiG-25 Foxbat  
laTypes["{43CC7267-6C0A-41B2-BCF7-CE8FA05E9E35}"] =  MiG_31;--  =  9;   -- MiG-31 Foxhound  
laTypes["{C9F55068-5F03-4DC9-8D00-AEDC19710D01}"] =  F_2;--     =  10;  -- Tornado F.2 IDS GR.1A  
laTypes["{4AED1A01-FA09-11d5-9190-00A0249B6F00}"] =  TORNADO_IDS;--     =  10;  -- Tornado F.2 IDS GR.1A  
laTypes["{AD3E0C2E-2992-4E03-B884-E45B6F0000A7}"] =  MiG_27;--  =  11;  -- MiG-27 Flogger-D 
laTypes["{C3A1469C-E835-4ADF-924C-A5F3D8AEC550}"] =  Su_24;--   =  12;  -- Su-24 Fencer   
laTypes["{983788D2-EB64-4D8E-A921-9FA30122B4B0}"] =  Su_30;--   =  13;  -- Su-30            
laTypes["{2C4C5E81-F950-11d5-9190-00A0249B6F00}"] =  FA_18;--   =  14;  -- F/A-18 Hornet            
laTypes["{C075771D-EDE1-42C7-8E81-130B60500584}"] =  FA_18C;--  =  53;  -- F/A-18 Hornet            
laTypes["{2325337F-8CF8-4918-A149-9A1A2F62F157}"] =  F_111;--   =  15;  -- F-111  
laTypes["{CC4276EE-EDB4-4EC0-BE13-4313ABDC7619}"] =  Su_25;--   =  16;  -- Su-25 Frogfoot 
laTypes["{8FDB2742-2283-450D-B417-CFC47774E8B6}"] =  A_10;--    =  17;  -- A-10 Thunderbolt II
laTypes["{12F005C2-F9F1-4BD7-ADA0-AF169A7D8D78}"] =  Tu_160;--  =  18;  -- Tu-160 Blackjack         
laTypes["{AB49B09D-B5DC-4833-B649-88AFB10B4CA3}"] =  B_1;--     =  19;  -- B-1 Lancer           
laTypes["{87E4C74D-1081-4B6E-A558-27EDB7A81546}"] =  Su_34;--   =  20;  -- C-34 -a
laTypes["{96710CAD-AA85-40EB-9BAC-CE307CE6C158}"] =  Tu_95;--   =  21;  -- Tu-95 Bear 
laTypes["{DCAA178F-3BB0-4F80-8DBA-BF4B256AC4BF}"] =  Tu_142;--  =  22;  -- Tu-142 Bear  
laTypes["{58517ADF-DB08-4519-B2A0-727A3DFC0217}"] =  B_52;--    =  23;  -- B-52 Stratofortress          
laTypes["{1E65CF49-44A6-4C91-8F43-209869A5B3A7}"] =  MiG_25P;-- =  24;  -- MiG_25P -- 
laTypes["{C17483D6-2911-408C-B57B-1839E4CD0528}"] =  Tu_22M3;-- =  25;  -- Tu-22M3 Backfire 
laTypes["{CA17F0F8-6AEB-43FA-BC90-76732137F61D}"] =  A_50;--    =  26;  -- -50 Mainstay
laTypes["{80AD28A5-C892-4E68-9364-F7C3C7E71E6E}"] =  E_3;--     =  27;  -- E-3 Sentry           
laTypes["{E8506C78-7BCD-4FA7-9163-354FE3297DCA}"] =  IL_78;--   =  28;  -- IL-78 Midas            
laTypes["{513825C4-174E-4926-BE80-CC87D89900E4}"] =  KC_10;--   =  29;  -- KC-10 Extender           
laTypes["{439A1A0C-1A35-4B45-A0ED-2F2A0B0E8F31}"] =  IL_76;--   =  30;  -- IL-76 Candid 
laTypes["{0213FA86-978D-4586-BAC3-BD642AD52B96}"] =  C_130;--   =  31;  -- C-130 Hercules
laTypes["{EEC9AC95-3B6F-4F7B-A3A4-6367673DCF50}"] =  MIG_29K;-- =  32;  -- MiG-29K -             
laTypes["{8B709A69-CE5E-46bc-B0D4-159238B52E2A}"] =  S_3A; --S_3R  33;  -- S-3A VICING, ,            
laTypes["{AAD0C656-A7E0-4099-8F6C-25DDCB3EEEA2}"] =  Mirage;--  =  34;  -- Mirage 2000 -             
--  laTypes[""] =  Tu_143;--  =  35;  -- Tu-143 (-3) ""           
--  laTypes[""] =  Tu_141;--  =  36;  -- Tu-141 (-2) ""
laTypes["{B31D98CC-35E9-4431-81A0-369DFDB6D6A3}"] =  F_117;--   =  37;  -- F-117               
laTypes["{734008AD-266A-4932-B6F6-CB243AD4EE38}"] =  Su_39;--   =  38;  -- SU-39               
laTypes["{A5B4B173-F4C1-4331-9AB2-1ACDE185008F}"] =  AN_26B;--  =  39;  -- AN-26B               
laTypes["{DFBDA1AB-0456-4AE8-A24C-EE2A0362D06E}"] =  AN_30M;--  =  40;  -- AN-30M                   
laTypes["{C7888130-8CDA-422F-8BB9-FC507DCDF19D}"] =  E_2C;--    =  41;  -- E-2C Hawkeye  AWACS  AN_26B             
laTypes["{C4D0D89A-F111-4610-ADB5-84CD0F29E703}"] =  S_3A;--    =  42;  -- S-3A Viking                 
laTypes["{e9dd44e3-9aa5-4055-84c4-6bf1d128148b}"] =  AV_8B;--   =  43;  -- AV-8B Harrier               
--  laTypes[""] =  EA_6B;--   =  44;  -- EA-6B Prowler               
laTypes["{4B75FEBA-9997-4D34-A0D6-0DB061350951}"] =  F_4E;--    =  45;  -- F-4E Phantom II               
laTypes["{569949FE-CE95-4D94-BF76-7B809B8DACD0}"] =  F_5E;--    =  46;  -- F-5E Tiger                
laTypes["{3782913C-BA3A-4CD9-B9DC-2DCBE6B8F656}"] =  C_17;--    =  47;  -- C-17  USA              
laTypes["{2BAFF3D1-6A2C-4654-92A9-99D3BC501A4E}"] =  SU_17M4;-- =  48;  -- Cy-17M4               
laTypes["{5B1614EC-FF32-4EDA-86BD-E580C5F0FF84}"] =  MiG_29G;--  = 49;  -- MiG-29 Fulcrum   
laTypes["{3B301281-F94A-11d5-9190-00A0249B6F00}"] =  MiG_29C;--  = 50;  -- MiG-29 Fulcrum 
laTypes["{0282A9C1-0B38-11d6-9193-00A0249B6F00}"] =  Su_24MR;--    51
laTypes["{51024F71-B4F4-4226-A8D5-976CE662517A}"] =  F_16A;  --    52
laTypes["{2B1638C8-9321-4d90-A7C8-8E9EB342C0F5}"] =  F_16A;  --    52
laTypes["{31E68806-0891-4e12-9573-D1CFEA8C96F8}"] =  Su_25T;--   = 54;  -- Su-25T Frogfoot  
laTypes["{3170e5d2-f866-4ade-a66a-81703d65a7ca}"] =  RQ_1A_Predator;--55 Predator UAV
laTypes["{{7061418E-5D0E-4b49-915D-ACEF1F2E6855}}"] =  Yak_40;--57 Yak-40

--   
laTypes["{C08CF845-F905-40F0-AF1B-554908BBE89E}"] =  MI_8MT;-- 1 M-8. / 
laTypes["{0903DF50-B9FA-441E-B94D-8F03DFF3E40D}"] =  MI_24W;-- 2 M-24B. / 
laTypes["{FDE4A6C5-A26E-402D-87EF-FF6892D8FDB3}"] =  MI_26; -- 3 M-26.  / 
laTypes["{809119BE-03A0-4B85-9134-900DF0591FC3}"] =  KA_27; -- 4 Ka-27.  /           
laTypes["{3457BB1E-523F-4C24-BBEA-58D028623F05}"] =  KA_50; -- 5 Ka-50.             
laTypes["{E3B22F6F-0A9A-46F8-BEC4-03C9ADD68FC5}"] =  KA_52; -- 6 Ka-52.             
laTypes["{F324202D-A045-418B-86D0-7594454FDA81}"] =  AH_64A;-- 7 AH-64A Apache.         NATO              
laTypes["{F939FD3E-229F-4A9F-AE99-5CD4D60DE5F9}"] =  AH_64D;-- 8 AH-64D Apache Longbow. NATO              
laTypes["{AF7808AC-A07C-470D-886B-505E8D23D317}"] =  CH_47D;-- 9 H-47D Chinook.        NATO             
laTypes["{022A971C-137D-48EB-A153-43D08A985F2E}"] =  CH_53E;-- 10 CH-53E Super Stallion. NATO             
laTypes["{975CB910-D5AC-4C70-A3E0-8EE8564BA112}"] =  SH_60B;-- 11 SH-60B Sea Hawk.       NATO             
laTypes["{8CC2AAFA-F5F6-498D-83E0-681561D691B8}"] =  UH_60A;-- 12 UH-60A Night Hawk.     NATO             
laTypes["{D49A54A7-1607-4779-88EE-7D4EF529CF5C}"] =  AH_1W; -- 13 AH-1W  Super Cobra.    NATO             
laTypes["{11607A2D-D1F2-4802-AE75-D7CA3291337A}"] =  SH_3H; -- 14 SH-3W  Sea King.      NATO              
--  laTypes[""] =  Sea_Lynx; -- 15 Sea Lynx Mk88.     NATO              
laTypes["{111132D6-F3AA-4C00-A53A-A6C5FB298572}"] =  AB_212;-- 16 UH-1H.        NATO  
laTypes["{450335F5-0F8A-4d71-A880-1B76B3C89B1A}"] =  MI_28N;
laTypes["{4A3860BF-A4DE-4f0c-9265-5E20D230FA07}"] =  OH_58D;

--  initialize civilTypes
civilTypes = {}
civilTypes["ATMZ-5"] = wsTypeTMZ5;      
civilTypes["ATZ-10"] = wsTypeTZ10;      
civilTypes["APA"] = wsTypeUralApa;    
civilTypes["RLS Bereg"] = wsTypeBeregRLS;   
civilTypes["MAZ power station"] = wsTypeMAZelektro; 
civilTypes["MAZ guardhouse"] = wsTypeMAZkaraul;   
civilTypes["MAZ home"] = wsTypeMAZobsch;    
civilTypes["MAZ mess"] = wsTypeMAZstol;   
civilTypes["ATZ-60"] = wsTypeATZ60;     
civilTypes["RLS PRW-11"] = wsTypeRLS_PRW11;   
civilTypes["RLS RSP-7"] = wsTypeRLS_RSP7;     
civilTypes["Reis launcher"] = wsTypeReis;         
civilTypes["RLS 37"] = wsTypeRLS37;       
civilTypes["Tractor"] = wsTypeTiagach;      
civilTypes["BTR TPZ"] = wsTypeTPZ;        
civilTypes["UAZ-469"] = wsTypeUAZ469;   
--civilTypes["Scud"] = wsTypeUragan;    
civilTypes["Ural-375"] = wsTypeUral375;     
civilTypes["Ural-375 PBU"] = wsTypeUral375PBU;    
civilTypes["RLS Zapros"] = wsTypeZapros;        
civilTypes["ZIL-135"] = wsTypeZIL135;         
civilTypes["Electric locomotive"] = wsTypeElektrovoz; 
civilTypes["IKARUS Bus"] = wsTypeBus;     
civilTypes["VAZ Car"] = wsTypeVAZ;      
civilTypes["Locomotive"] = wsTypeTeplowoz;    
civilTypes[" Trolley bus"] = wsTypeTrolebus;    
civilTypes["Coach a tank"] = wsTypeWCisterna;   
civilTypes["Coach cargo"] = wsTypeWGruz;      
civilTypes["Coach cargo open"] = wsTypeWGruzOtkr;   
civilTypes["Coach a platform"] = wsTypeWagonPlatforma;
civilTypes["Coach a passenger"] = wsTypeWagonPass;    
civilTypes["KRM"] = wsTypeRadioSt;    
civilTypes["KAMAZ Fire Truck"] = wsTypeKAMAZ_Fire;  
civilTypes["KAMAZ Truck"] = wsTypeKAMAZ_Tent; 
civilTypes["LAZ Bus"] = wsTypeLAZ_695;    
civilTypes["GAZ-66"]  = wsTypeGAZ_66;
civilTypes["GAZ-3307"]  = wsTypeGAZ_3307;
civilTypes["GAZ-3308"]  = wsTypeGAZ_3308;
civilTypes["MAZ-6303"]  = wsTypeMAZ_6303;
civilTypes["ZIL-4334"]  = wsTypeZIL_4334;
civilTypes["ZIL SKP-11"] = wsTypeZIL_SKP_11;
civilTypes["URAL-4320T"] = wsTypeURAL_4320T;
civilTypes["URAL-4320-31"] = wsTypeURAL_4320_31;
civilTypes["URAL ATsP-6"] = wsTypeURAL_ATsP_6;
civilTypes["ZIL APA-80"] = wsTypeZIL_APA_80;
civilTypes["ZIL-131 KUNG"] = wsTypeZIL_131_KUNG;
civilTypes["M978 HEMTT Tanker"] = wsTypeHEMTT_M978;
