require "scripts/database/Scripts/utils"

weapons_table.weapons.nurs = namespace()

function do_declare_nurs(name, user_name, model, scheme, data, amm_data, fm, engine)
    res = dbtype("wAmmunitionNURS", 
    {
        ws_type = { wsType_NURS, wsType_Rocket, _G[name] },
        
        model = model,
    })

    weapons_table.weapons.nurs[name] = res


    res.server = 
    {
        scheme  = "schemes/rockets/" .. scheme .. ".sch";   
    }

    res.client = 
    {
        scheme = "schemes/rockets/" .. scheme .. ".sch";
    }
    
    copy_recursive_with_metatables(res.server, data);
    copy_recursive_with_metatables(res.client, data);
    
    if data.warhead ~= nil then 
        res.server.warhead.fantom = 0;
        res.client.warhead.fantom = 1;
    end
    
    if data.launcher ~= nil then
        res.server.launcher.server = 1;
        res.client.launcher.server = 0;
    end
    
    res.sight_data =
    {
        engine = 
        {
            fuel_mass   = engine.fuel_mass,
            work_time   = engine.work_time;
            impulse     = engine.impulse,
        },
        fm = fm,
    }
    
    
    res.mass   = fm.mass + engine.fuel_mass;
    res.cx_pil = fm.cx_coeff[4]*fm.caliber*fm.caliber*0.78539816339744830961566084581988;

    res.name        = user_name;
    res.type_name   = _("rocket");
    
    copy_recursive(res, amm_data);
    
    return res;
end

function declare_nurs(name, user_name, model, scheme, data, amm_data)
    return do_declare_nurs(name, user_name, model, scheme, data, amm_data, data.fm, data.engine);
end

function declare_cluster_nurs(name, user_name, model, scheme, data, amm_data)
    return do_declare_nurs(name, user_name, model, scheme, data, amm_data, data.fm, data.engine);
end

require "warheads";
require "cluster_data"

-----------------------------------------------------------------
-- C_5
-----------------------------------------------------------------
declare_nurs("C_5", _("C-5"), "c-5", "nurs-standard",
{
        -- FM
        fm = 
        {
            mass        = 3.135,    -- empty weight with warhead, wo fuel, kg
            caliber     = 0.057,   -- Caliber, meters 
            cx_coeff    = {1,1.2668931,0.67,0.4521834,2.08}, -- Cx
            L           = 1.081, -- Length, meters
            I           = 0.4313938, -- moment of inertia
            Ix          = 0.0017991, -- not used
            Ma          = 0.131698, -- dependence moment coefficient of  by  AoA
            Mw          = 1.4351299, --  dependence moment coefficient by angular speed
            shapeName   = "",
            
            wind_time   = 0.675, -- dispersion coefficient
            wind_sigma  = 5, -- dispersion coefficient
            
            wing_unfold_time = 0.02, -- Unfold time, sec
        },

        engine =
        {
            fuel_mass   = 1.2953515, -- Fuel mass, kg
            impulse     = 180, -- Specific impuls, sec
            boost_time  = 0, -- Time of booster action
            work_time   = 0.675, -- Time of mid-flight engine action
            boost_factor= 1, -- Booster to cruise trust ratio
            nozzle_position =  {{-0.471, 0, 0}}, -- meters
            tail_width  = 0.052, -- contrail thickness
            boost_tail  = 1, 
            work_tail   = 1,
            
            smoke_color = {0.6, 0.6, 0.6};
            smoke_transparency = 0.3;
        },
    
    warhead = warheads["C_5"],
}, 
{
    dist_min = 600, -- min range, meters
    dist_max = 2500,    -- max range, meters
})

-----------------------------------------------------------------
-- C_8
-----------------------------------------------------------------
declare_nurs("C_8", _("C-8"), "S-8_KOM", "nurs-standard",
{
        fm = 
        {
            mass        = 7.8863,   
            caliber     = 0.08, 
            cx_coeff    = {1, 0.9309214, 0.67, 0.3322673, 2.08},
            L           = 1.7,
            I           = 2.79366,
            Ix          = 6,
            Ma          = 0.1316980,
            Mw          = 1.4351299,
            shapeName   = "",
            
            wind_time   = 1.55,
            wind_sigma  = 4,
        },

        engine =
        {
            fuel_mass   = 3.7137188,
            impulse     = 180,
            boost_time  = 0,
            work_time   = 1.55,
            boost_factor= 1,
            nozzle_position =  {{-0.758, 0, 0}},
            tail_width  = 0.052,
            boost_tail  = 1,
            work_tail   = 1,

            smoke_color = {0.6, 0.6, 0.6};
            smoke_transparency = 0.3;
        },

    warhead = warheads["C_8"],
        
},{
    dist_min = 600,
    dist_max = 3000,    
})

-----------------------------------------------------------------
-- C_8OFP2
-----------------------------------------------------------------
declare_nurs("C_8OFP2", _("C-8OFP2"), "S-8_OFP2", "nurs-standard",
{
        fm = 
        {
            mass        = 13.0,   
            caliber     = 0.08, 
            cx_coeff    = {1, 0.9309214, 0.67, 0.3322673, 2.08},
            L           = 1.428,
            I           = 2.79366,
            Ix          = 6,
            Ma          = 0.1316980,
            Mw          = 1.4351299,
            shapeName   = "",
            
            wind_time   = 1.55,
            wind_sigma  = 4,
        },

        engine =
        {
            fuel_mass   = 3.7, 
            impulse     = 180,
            boost_time  = 0,
            work_time   = 1.55,
            boost_factor= 1,
            nozzle_position =  {{-0.758, 0, 0}},
            tail_width  = 0.052,
            boost_tail  = 1,
            work_tail   = 1,

            smoke_color = {0.6, 0.6, 0.6};
            smoke_transparency = 0.3;
        },

    warhead = warheads["C_8OFP2"],
        
},{
    dist_min = 600,
    dist_max = 3000,    
})

-----------------------------------------------------------------
-- C_8OM
-----------------------------------------------------------------
declare_nurs("C_8OM", _("C-8OM"), "S-8_OM", "nurs-light",
{
        fm = 
        {
            mass        = 7.8863,   
            caliber     = 0.08, 
            cx_coeff    = {1, 0.9309214, 0.67, 0.3322673, 2.08},
            L           = 1.7,
            I           = 2.79366,
            Ix          = 6,
            Ma          = 0.1316980,
            Mw          = 1.4351299,
            shapeName   = "",
            
            wind_time   = 1.55,
            wind_sigma  = 4,
        },

        engine =
        {
            fuel_mass   = 3.7137188,
            impulse     = 180,
            boost_time  = 0,
            work_time   = 1.55,
            boost_factor= 1,
            nozzle_position =  {{-0.758, 0, 0}},
            tail_width  = 0.052,
            boost_tail  = 1,
            work_tail   = 1,

            smoke_color = {0.6, 0.6, 0.6};
            smoke_transparency = 0.3;
        },

        launcher = 
        {
			ammunition = weapons_table.weapons.bombs["S-8OM_LE"],
        },
        
        control = 
        {
            delay = 17.0,
        },
},{
    dist_min = 600,
    dist_max = 3000,    
})


-----------------------------------------------------------------
-- C_8CM
-----------------------------------------------------------------
declare_nurs("C_8CM", _("C-8CM"), "S-8_SM", "nurs-marker",
{
        fm = 
        {
            mass        = 7.8863,   
            caliber     = 0.08, 
            cx_coeff    = {1, 0.9309214, 0.67, 0.3322673, 2.08},
            L           = 1.7,
            I           = 2.79366,
            Ix          = 0.00928,
            Ma          = 0.1316980,
            Mw          = 1.4351299,
            shapeName   = "",
            
            wind_time   = 1.55,
            wind_sigma  = 4,
        },

        engine =
        {
            fuel_mass   = 3.7137188,
            impulse     = 180,
            boost_time  = 0,
            work_time   = 1.55,
            boost_factor= 1,
            nozzle_position =  {{-0.758, 0, 0}},
            tail_width  = 0.052,
            boost_tail  = 1,
            work_tail   = 1,

            smoke_color = {0.6, 0.6, 0.6};
            smoke_transparency = 0.3;
        },

    warhead = warheads["C_8CM"],
},{
    dist_min = 600,
    dist_max = 3000,    
})


-----------------------------------------------------------------
-- C_13
-----------------------------------------------------------------
declare_nurs("C_13", _("C-13"), "c-13", "nurs-standard",
{
        fm = 
        {
            mass        = 47.5103,  
            caliber     = 0.112,    
            cx_coeff    = {1,0.889005,0.67,0.3173064,2.08},
            L           = 2.643,
            I           = 39.00209,
            Ma          = 0.50851,
            Mw          = 3.28844,
            shapeName   = "",
            
            wind_time   = 2.1,
            wind_sigma  = 3,
        },

        engine =
        {
            fuel_mass   = 19.4897,
            impulse     = 180,
            boost_time  = 0,
            work_time   = 2.1,
            boost_factor= 1,
            nozzle_position =  {{-1.296, 0, 0}},
            tail_width  = 0.052,
            boost_tail  = 1,
            work_tail   = 1,

            smoke_color = {0.6, 0.6, 0.6};
            smoke_transparency = 0.3;
        },

    warhead = warheads["C_13"],
},{
    dist_min = 1100,
    dist_max = 4000,    
})

-----------------------------------------------------------------
-- C_24
-----------------------------------------------------------------
declare_nurs("C_24", _("C-24"), "c-24", "nurs-standard",
{
    
        fm = 
        {
            mass        = 183.2,    
            caliber     = 0.24, 
            cx_coeff    = {1,0.8889618,0.67,0.3172910,2.08},
            L           = 2.22,
            I           = 96.5145,
            Ma          = 0.1720553,
            Mw          = 6.106276,
            shapeName   = "",
            
            wind_time   = 1.3,
            wind_sigma  = 10,
        },

        engine =
        {
            fuel_mass   = 51.8,
            impulse     = 170,
            boost_time  = 0,
            work_time   = 1.3,
            boost_factor= 1,
            nozzle_position =  {{-1.139, 0, 0}},
            tail_width  = 0.052,
            boost_tail  = 1,
            work_tail   = 1,

            smoke_color = {0.6, 0.6, 0.6};
            smoke_transparency = 0.3;
        },

    warhead = warheads["C_24"],
},{
    dist_min = 2000,
    dist_max = 3000,    
})

-----------------------------------------------------------------
-- C_25
-----------------------------------------------------------------
declare_nurs("C_25", _("C-25"), "c-25", "nurs-standard",
{
        fm = 
        {
            mass        = 300.9,    
            caliber     = 0.34, 
            cx_coeff    = {1,0.8459661,0.67,0.3019448,2.08},
            L           = 3.56,
            I           = 433.01467,
            Ma          = 0.192352,
            Mw          = 2.521688,
            shapeName   = "",
            
            wind_time   = 2.2,
            wind_sigma  = 3,
        },

        engine =
        {
            fuel_mass   = 109.09637,
            impulse     = 180,
            boost_time  = 0,
            work_time   = 2.2,
            boost_factor= 1,
            nozzle_position =  { {-1.460, 0.06, 0}, 
                                 {-1.460, -0.06, 0},
                                 {-1.460, 0, 0.06},
                                 {-1.460, 0, -0.06} },
            tail_width  = 0.052,
            boost_tail  = 1,
            work_tail   = 1,

            smoke_color = {0.6, 0.6, 0.6};
            smoke_transparency = 0.3;
        },

    warhead = warheads["C_25"],
},{
    dist_min = 2000,
    dist_max = 3000,    
})

-----------------------------------------------------------------
-- 9M22U (grad)
-----------------------------------------------------------------
declare_nurs("GRAD_RAKETA", _("GRAD"), "9M22U", "nurs-standard",
{
        fm = 
        {
            mass        = 46.5, 
            caliber     = 0.122,    
            cx_coeff    = {1,0.66,0.49,0.2,1.53},
            L           = 2.643,
            I           = 39.00209,
            Ma          = 0.50851,
            Mw          = 3.28844,
            shapeName   = "",
            
            wind_time   = 1.0,
            wind_sigma  = 7,
        },

        engine =
        {
            fuel_mass   = 20.5,
            impulse     = 200,
            boost_time  = 0,
            work_time   = 1.0,
            boost_factor= 1,
            nozzle_position =  { {-1.598, 0, 0} },
            tail_width  = 0.52,
            boost_tail  = 1,
            work_tail   = 1,

            smoke_color = {1, 1, 1};
            smoke_transparency = 0.9;
        },

    warhead = warheads["GRAD_RAKETA"],
},{
    dist_min = 0,       --  
    dist_max = 0,   
})

-----------------------------------------------------------------
-- 8K14 SCUD-B 
-----------------------------------------------------------------
declare_nurs("URAGAN_RAKETA", _("Scud"), "URAGAN-RAKETA", "nurs-standard",
{

    fm = 
    {
        mass        = 480.9,    
        caliber     = 0.800,    
        cx_coeff    = {1,0.66,0.49,0.02,1.53},
        L           = 3.56,
        I           = 433.01467,
        Ma          = 0.192352,
        Mw          = 2.521688,
        shapeName   = "",
        
        wind_time   = 0.01,
        wind_sigma  = 0.01,
    },

    engine =
    {
     fuel_mass   = 1959,
     impulse     = 240,
     boost_time  = 0,
     work_time   = 35,
     boost_factor= 0.5,
     nozzle_position =  { {-5.3, 0, 0} },
     tail_width  = 0.84,
     boost_tail  = 1,
     work_tail   = 1,

        smoke_color = {1, 1, 1};
        smoke_transparency = 0.9;
    },
       
    warhead = warheads["URAGAN_RAKETA"],
   },{ 

    dist_min = 0,       --  
    dist_max = 0,   
})

---------------------------------------------------------------------

declare_cluster_nurs("SMERCH_RAKETA", _("SMERCH"), "9M55", "nurs-ground-cluster",
{
    fm = 
    {
        mass        = 480.9,    
        caliber     = 0.300,    
        cx_coeff    = {1,0.66,0.49,0.02,1.53},
        L           = 3.56,
        I           = 433.01467,
        Ma          = 0.192352,
        Mw          = 2.521688,
        shapeName   = "",
        
        wind_time   = 3,
        wind_sigma  = 2,
    },

    engine =
    {
        fuel_mass   = 320.0,
        impulse     = 220.0,
        boost_time  = 0,
        work_time   = 3,
        boost_factor= 1,
        nozzle_position =  { {-4.00, 0, 0} },
        tail_width  = 0.52,
        boost_tail  = 1,
        work_tail   = 1,

        smoke_color = {1, 1, 1};
        smoke_transparency = 0.9;
    },
    
    launcher = 
    {
        cluster = cluster_desc("Bomb_Other", wsType_Bomb_Cluster, combine_cluster(PTAB_10_5_DATA,
        {
            cluster = {
                count        = 300,
                effect_count = 30, 
            
                wind_sigma  = 5,
                impulse_sigma = 30000,
                moment_sigma = 0.0001,
            }
        }))
    },
    
    fuze = 
    {
        fire_height = 1200,
    },
},{
    dist_min = 0,       --  
    dist_max = 0,   
})


-----------------------------------------------------------------
-- HYDRA-70 M151
-----------------------------------------------------------------
declare_nurs("HYDRA_70", _("HYDRA-70"), "Hydra_MK151HE", "nurs-standard",
{
        fm = 
        {
            mass        = 6.3863,   
            caliber     = 0.06985,  
            cx_coeff    = {1,0.91,0.67,0.3248,2.08},
            L           = 1.3815,
            I           = 1.7240,
            Ma          = 0.23322,
            Mw          = 2.177036,
            shapeName   = "",
            
            wind_time   = 1.1,
            wind_sigma  = 5,
        },

        engine =
        {
            fuel_mass   = 4.453741,
            impulse     = 150,
            boost_time  = 0,
            work_time   = 1.1,
            boost_factor= 1,
            nozzle_position =  {{-0.65, 0, 0}},
            tail_width  = 0.052,
            boost_tail  = 1,
            work_tail   = 1,

            smoke_color = {0.6, 0.6, 0.6};
            smoke_transparency = 0.3;
        },

    warhead = warheads["HYDRA_70"],
},{
    dist_min = 1000,
    dist_max = 2000,    
})

-----------------------------------------------------------------
-- HYDRA-70 M156 (WP)
-----------------------------------------------------------------
declare_nurs("HYDRA_70WP", _("HYDRA-70WP"), "Hydra_MK151HE",  "nurs-marker",
{
        fm = 
        {
            mass        = 6.3863,   
            caliber     = 0.06985,  
            cx_coeff    = {1,0.91,0.67,0.3248,2.08},
            L           = 1.3815,
            I           = 1.7240,
            Ma          = 0.23322,
            Mw          = 2.177036,
            shapeName   = "",
            
            wind_time   = 1.1,
            wind_sigma  = 5,
        },

        engine =
        {
            fuel_mass   = 4.453741,
            impulse     = 150,
            boost_time  = 0,
            work_time   = 1.1,
            boost_factor= 1,
            nozzle_position =  {{-0.65, 0, 0}},
            tail_width  = 0.052,
            boost_tail  = 1,
            work_tail   = 1,

            smoke_color = {0.6, 0.6, 0.6};
            smoke_transparency = 0.3;
        },

    warhead = warheads["HYDRA_70WP"],
},{
    dist_min = 1000,
    dist_max = 2000,    
})

-----------------------------------------------------------------
-- ZUNI-127
-----------------------------------------------------------------
--   C-8!!!!
-----------------------------------------------------------------
declare_nurs("Zuni_127", _("Zuni-127"), "zuni",  "nurs-standard",
{
        fm = 
        {
            mass        = 47.5103,  
            caliber     = 0.112,    
            cx_coeff    = {1,0.889005,0.67,0.3173064,2.08},
            L           = 2.643,
            I           = 39.00209,
            Ma          = 0.50851,
            Mw          = 3.28844,
            shapeName   = "",
            
            wind_time   = 2.1,
            wind_sigma  = 3,
        },

        engine =
        {
            fuel_mass   = 19.4897,
            impulse     = 180,
            boost_time  = 0,
            work_time   = 2.1,
            boost_factor= 1,
            nozzle_position =  {{-1.0, 0, 0}},
            tail_width  = 0.052,
            boost_tail  = 1,
            work_tail   = 1,

            smoke_color = {0.6, 0.6, 0.6};
            smoke_transparency = 0.3;
        },

    warhead = warheads["Zuni_127"],
},{
    dist_min = 1200,
    dist_max = 4000,    
})

declare_nurs("M26_RAKETA", _("M26"), "M26", "nurs-ground-cluster",
{
    fm = 
    {
        mass        = 221.0,    
        caliber     = 0.230,    
        cx_coeff    = {1, 0.66, 0.49, 0.2, 1.53},
        L           = 3.56,
        I           = 433.01467,
        Ma          = 0.192352,
        Mw          = 2.521688,
        shapeName   = "",
        
        wind_time   = 2.0,
        wind_sigma  = 3,
    },

    engine =
    {
        fuel_mass   = 85.0,
        impulse     = 270,
        boost_time  = 0,
        work_time   = 2.0,
        boost_factor= 1,
        nozzle_position =  { {-2.05, 0, 0} },
        tail_width  = 0.52,
        boost_tail  = 1,
        work_tail   = 1,

        smoke_color = {1, 1, 1};
        smoke_transparency = 0.9;
    },
    
    launcher = 
    {
        cluster = cluster_desc("Bomb_Other", wsType_Bomb_Cluster, combine_cluster(PTAB_10_5_DATA,
        {
            cluster = {
                count        = 300,
                effect_count = 30, 
            
                wind_sigma  = 5,
                impulse_sigma = 30000,
                moment_sigma = 0.0001,
            }
        }))
    },
    
    fuze = 
    {
        fire_height = 1200,
    },
},{
    dist_min = 0,       --  
    dist_max = 0,   
})
