--mounting 3d model paths and texture paths 

mount_vfs_model_path	(current_mod_path.."/Shapes")
mount_vfs_liveries_path (current_mod_path.."/Liveries")
mount_vfs_texture_path  (current_mod_path.."/Textures/c-130.zip")
mount_vfs_texture_path  (current_mod_path.."/Textures")

C_130FR =  {
        
	Name 				=   'C-130FR',
	DisplayName			= _('C-130FR'),
	
	HumanCockpit 		= true,
	HumanCockpitPath    = current_mod_path..'/Cockpit/',
	
	Picture 			= "C-130.png",
	Rate 				= 40, -- RewardPoint in Multiplayer
	Shape 				= "C-130",
	
	shape_table_data 	= 
	{
		{
			file  	 = 'C-130';
			life  	 = 20; -- lifebar
			vis   	 = 3; -- visibility gain.
			desrt    = 'Wunderluft_destr'; -- Name of destroyed object file name
			fire  	 = { 300, 2}; -- Fire on the ground after destoyed: 300sec 2m
			username = 'C-130FR';
			index    =  WSTYPE_PLACEHOLDER;
		},
		{
			name  = "C-130-oblomok";
			file  = "C-130-oblomok";
			fire  = { 240, 2};
		},

	},
	mapclasskey 		= "P0091000025",
	attribute  			= {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER ,"Battleplanes",},
	Categories 			= {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},	
	-------------------------
	M_empty 				= 36400, -- kg
	M_nominal 				= 70000, -- kg
	M_max 					= 79380, -- kg
	M_fuel_max 				= 20830, -- kg --2225
	H_max 					= 9315, -- m
	average_fuel_consumption 		= 0.06, -- this is highly relative, but good estimates are 36-40l/min = 28-31kg/min = 0.47-0.52kg/s -- 45l/min = 35kg/min = 0.583kg/s
	CAS_min 				= 54, -- if this is not OVERAL FLIGHT TIME, but jus LOITER TIME, than it sholud be 10-15 minutes.....CAS capability in minute (for AI)
	V_opt 					= 174,-- Cruise speed (for AI)
	V_take_off 				= 58, -- Take off speed in m/s (for AI)
	V_land 					= 61, -- Land speed in m/s (for AI)
	V_max_sea_level 			= 167.5, -- Max speed at sea level in m/s (for AI)
	V_max_h 				= 172, -- Max speed at max altitude in m/s (for AI)
	Vy_max 					= 9.1, -- Max climb speed in m/s (for AI)
	Mach_max 				= 0.63, -- Max speed in Mach (for AI)
	Ny_min 					= 0.5, -- Min G (for AI)
	Ny_max 					= 2.5,  -- Max G (for AI)
	Ny_max_e 				= 2,  -- Max G (for AI)
	AOA_take_off 				= 0.17, -- AoA in take off (for AI)
	bank_angle_max 				= 45, -- Max bank angle (for AI)
	has_afteburner 				= false, -- AFB yes/no
	has_speedbrake 				= false, -- Speedbrake yes/no
	nose_gear_pos 				= {8.133, -2.5,	0},  
	main_gear_pos 				= {-2.654, -2.5, 2.746},
	tand_gear_max 				= 0.577,
	tanker_type 				= 0, -- Tanker type if the plane is airrefuel capable
	wing_area 				= 152.1, -- wing area in m2
	wing_span 				= 40.4, -- wing spain in m
	wing_type 				= 0,
	thrust_sum_max 				= 44400, -- thrust in kg (44kN)
	thrust_sum_ab 				= 44400, -- thrust inkg (71kN)
	length 					= 29.79, -- full lenght in m
	height 					= 11.66, -- height in m
	flaps_maneuver 				= 0.5, -- Max flaps in take-off and maneuver (0.5 = 1st stage; 1.0 = 2nd stage) (for AI)
	range 					= 8260, -- Max range in km (for AI)
	RCS 					= 80, -- Radar Cross Section m2
	IR_emission_coeff 			= 1, -- Normal engine -- IR_emission_coeff .
	IR_emission_coeff_ab 			= 0, -- With afterburner
	wing_tip_pos 				=  {-6.627,	-0.265,	20.2}, -- wingtip coords for visual effects
	nose_gear_wheel_diameter 		= 0.754, -- in m
	main_gear_wheel_diameter 		= 0.972, -- in m
	--main_gear_amortizer_direct_stroke	=   0, --  down from main_gear_pos !!!
	--main_gear_amortizer_reversal_stroke  	= 	-0.00, --  up 
	--main_gear_amortizer_normal_weight_stroke =  0.0,-- down from main_gear_pos
	--nose_gear_amortizer_direct_stroke   		=  0,  -- down from nose_gear_pos !!!
	--nose_gear_amortizer_reversal_stroke  		= -0.0,  -- up 
	--nose_gear_amortizer_normal_weight_stroke 	= 0.0,   -- up 
	brakeshute_name 			= 0, -- Landing - brake chute visual shape after separation
	is_tanker 					= false, -- Tanker yes/no
	air_refuel_receptacle_pos 	= {0, 0, 0}, -- refuel coords
	engines_count				= 2, -- Engines count
	engines_nozzles = {
		[1] = 
		{
			pos = 	{-0.73,	1.105,	-10.335},
				elevation	=	0,
				diameter	=	1.523,
				exhaust_length_ab	=	11.794,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.1, 
		}, -- end of [1]
		[2] = 
		{
			pos = 	{-0.73,	1.105,	10.335},
				elevation	=	0,
				diameter	=	1.523,
				exhaust_length_ab	=	11.794,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.1, 
		}, -- end of [2]
	}, -- end of engines_nozzles
	crew_size	 = 1,
	crew_members = 
	{
		[1] = 
		{
			ejection_seat_name = "1",
			drop_canopy_name = "1",
			pos =  {4,	1,	0},
			canopy_pos = {4,	1,	0},
		}, -- end of [1]
	}, -- end of crew_members

	fires_pos = 
		{
			[1] = 	{-2.33,	1.807,	0},
			[2] = 	{-2.333,	1.807,	5.463},
			[3] = 	{-2.333,	1.807,	-5.463},
			[4] = 	{-0.82,	0.265,	2.774},
			[5] = 	{-0.82,	0.265,	-2.774},
			[6] = 	{-0.82,	0.255,	4.274},
			[7] = 	{-0.82,	0.255,	-4.274},
			[8] = 	{0.586,	1.66,	4.841},
			[9] = 	{0.586,	1.66,	-4.841},
			[10] = 	{0.586,	1.546,	10.05},
			[11] = 	{0.586,	1.546,	-10.05},
		}, -- end of fires_pos
	
	
	-- Countermeasures
	SingleChargeTotal	 	= 140,
	CMDS_Incrementation 	= 4,
	ChaffDefault 			= 20, 
	ChaffChargeSize 		= 1,
	FlareDefault 			= 140, 
	FlareChargeSize 		= 1,
	CMDS_Edit 				= true,
	chaff_flare_dispenser 	= {
		[1] = 
		{
			dir =  {0, -1, 1},
			pos =  {-3, -1, 2},
		}, -- end of [1]
		[2] = 
		{
			dir =  {0, -1, -1},
			pos =  {-3, -1, -2},
		}, -- end of [2]
	}, -- end of chaff_flare_dispenser

	--sensors
	
	detection_range_max		 = 60,
	radar_can_see_ground 	 = false, -- this should be examined (what is this exactly?)
	CanopyGeometry = {
		azimuth   = {-160.0, 160.0}, -- pilot view horizontal (AI)
		elevation = {-50.0, 90.0} -- pilot view vertical (AI)
	},
	Sensors = {
		RWR = "Abstract RWR", -- RWR type
		RADAR = "N-019", -- Radar type
	},
	HumanRadio = {
		frequency = 127.5,  -- Radio Freq
		editable = true,
		minFrequency = 100.000,
		maxFrequency = 156.000,
		modulation = MODULATION_AM
	},
	
	
	Guns = {gun_mount("ADEN", {
			count = 0,
			muzzle_pos_connector = "GUN_POINT",
			muzzle_pos 		  = {0, -0.5, -1},
			elevation_initial = 0.000,
			supply_position   = {1, 0, 0},
			effect_arg_number = 350,
			 }
			)
			},
	
	Pylons =     {
        pylon(1, 0, 2.000000, -1.8000, -8.075000,
            {
				use_full_connector_position=true,
            },
            {
                { CLSID	= "{A4BCC903-06C8-47bb-9937-A30FEDB4E744}" },

            }
        ),
		
    },
	
	Tasks = {
	aircraft_task(Refueling),
        aircraft_task(GroundAttack),
        aircraft_task(RunwayAttack),
        aircraft_task(PinpointStrike),
        aircraft_task(CAS),
        aircraft_task(AFAC),
		aircraft_task(CAP),
        aircraft_task(Escort),
        aircraft_task(FighterSweep),
        aircraft_task(Intercept),
    },	
	DefaultTask = aircraft_task(CAP),
	
	SFM_Data = {
		aerodynamics = -- Cx = Cx_0 + Cy^2*B2 +Cy^4*B4
		{
			Cy0		=	0.0,      -- zero AoA lift coefficient
			Mzalfa		=	6.6,  -- coefficients for pitch agility
			Mzalfadt	=	1,    -- coefficients for pitch agility
			kjx		=	2.85,    
			kjz		=	0.00125, 
			Czbe		=	-0.012, -- coefficient, along Z axis (perpendicular), affects yaw, negative value means force orientation in FC coordinate system
			cx_gear		=	0.015,    -- coefficient, drag, gear
			cx_flap		=	0.08,   -- coefficient, drag, full flaps
			cy_flap		=	1,    -- coefficient, normal force, lift, flaps
			cx_brk		=	0.06,   -- coefficient, drag, breaks
			table_data  = 
			{
				[1] = 	{0,	0.024,	0.1,	0.0384,	0.000001,	0.5,	11,	1.2},
				[2] = 	{0.2,	0.024,	0.1,	0.0384,	0.000001,	0.8,	12,	1.2},
				[3] = 	{0.4,	0.024,	0.1,	0.0384,	0.000001,	1.0,	13,	1.2},
				[4] = 	{0.5,	0.024,	0.1,	0.0384,	0.000001,	1.1,	14,	1.2},
				[5] = 	{0.6,	0.027,	0.1,	0.0,	0.3,		1.2,	15,	1.2},
				[6] = 	{0.7,	0.031,	0.1,	0.045,	0.9,		1.3,	16,	1},
				[7] = 	{0.8,	0.036,	0.1,	0.107,	1,		1.3,	15,	0.8},
				[8] = 	{0.9,	0.045,	0.1,	0.148,	0.058,		1.35,	10,	0.6},
				[9] = 	{1,	0.054,	0.1,	0.199,	0.1,		1.4,	7,	0.53333333333333},
				[10] = 	{1.5,	0.054,	0.1,	0.199,	0.1,		1.5,	3,	0.2},
			}, -- end of table_data
			-- M - Mach number
			-- Cx0 - Coefficient, drag, profile, of the airplane
			-- Cya - Normal force coefficient of the wing and body of the aircraft in the normal direction to that of flight. Inversely proportional to the available G-loading at any Mach value. (lower the Cya value, higher G available) per 1 degree AOA
			-- B - Polar quad coeff
			-- B4 - Polar 4th power coeff
			-- Omxmax - roll rate, rad/s
			-- Aldop - Alfadop Max AOA at current M - departure threshold
			-- Cymax - Coefficient, lift, maximum possible (ignores other calculations if current Cy > Cymax)
		}, -- end of aerodynamics
		engine = 
		{
			Nmg	=	67.5, -- RPM at idle
			MinRUD	=	0, -- Min state of the throttle
			MaxRUD	=	1, -- Max state of the throttle
			MaksRUD	=	1, -- Military power state of the throttle
			ForsRUD	=	1, -- Afterburner state of the throttle
			typeng	=	3,
			--[[
				E_TURBOJET = 0
				E_TURBOJET_AB = 1
				E_PISTON = 2
				E_TURBOPROP = 3
				E_TURBOFAN = 4
				E_TURBOSHAFT = 5
			--]]
			
			hMaxEng	=	19.5, -- Max altitude for safe engine operation in km
			dcx_eng	=	0.0085, -- Engine drag coeficient
			cemax	=	1.24, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			cefor	=	0.37, -- not used for fuel calulation , only for AI routines to check flight time ( fuel calculation algorithm is built in )
			dpdh_m	=	4820, --  altitude coefficient for max thrust
			dpdh_f	=	4820,  --  altitude coefficient for AB thrust
			table_data = 
			{		--   M		Pmax		 Pfor	
				[1] = 	{0.0,	150792},
				[2] = 	{0.1,	148288},
				[3] = 	{0.2,	123532},
				[4] = 	{0.3,	103802},
				[5] = 	{0.4,	87547},
				[6] = 	{0.5,	71709},
				[7] = 	{0.6,	58459},
				[8] = 	{0.7,	48624},
				[9] = 	{0.8,	41439},
				[10] = 	{0.9,	33000},
			}, -- end of table_data
			-- M - Mach number
			-- Pmax - Engine thrust at military power
			-- Pfor - Engine thrust at AFB
		}, -- end of engine
	},
	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {
				[0]		= {critical_damage = 5, args = {146}},
				[3]		= {critical_damage = 20,args = {65}}  ,
				[4]		= {critical_damage = 20, args = {150}},
				[5]		= {critical_damage = 20, args = {147}},
				[7]		= {critical_damage = 4, args = {249}} ,
				[9]		= {critical_damage = 3, args = {154}},
				[10]	= {critical_damage = 3, args = {153}},
				[11]	= {critical_damage = 3, args = {167}},
				[12]	= {critical_damage = 3, args = {161}},
				[15]	= {critical_damage = 5, args = {267}},
				[16]	= {critical_damage = 5, args = {266}},
				[23]	= {critical_damage = 8, args = {223}, deps_cells = {25}},
				[24]	= {critical_damage = 8, args = {213}, deps_cells = {26, 60}},
				[25]	= {critical_damage = 3, args = {226}},
				[26]	= {critical_damage = 3, args = {216}},
				[29]	= {critical_damage = 9, args = {224}, deps_cells = {31, 25, 23}},
				[30]	= {critical_damage = 9, args = {214}, deps_cells = {32, 26, 24, 60}},
				[31]	= {critical_damage = 4, args = {229}},
				[32]	= {critical_damage = 4, args = {219}},
				[35]	= {critical_damage = 10, args = {225}, deps_cells = {29, 31, 25, 23}},
				[36]	= {critical_damage = 10, args = {215}, deps_cells = {30, 32, 26, 24, 60}} ,
				[37]	= {critical_damage = 4, args = {227}},
				[38]	= {critical_damage = 4, args = {217}},
				[39]	= {critical_damage = 7,	args = {244}, deps_cells = {53}},
				[40]	= {critical_damage = 7, args = {241}, deps_cells = {54}},
				[45]	= {critical_damage = 9, args = {235}, deps_cells = {39, 51, 53}},
				[46]	= {critical_damage = 9, args = {233}, deps_cells = {40, 52, 54}},
				[51]	= {critical_damage = 3, args = {239}},
				[52]	= {critical_damage = 3, args = {237}},
				[53]	= {critical_damage = 3, args = {248}},
				[54]	= {critical_damage = 3, args = {247}},
				[55]	= {critical_damage = 20, args = {81}, deps_cells = {39, 40, 45, 46, 51, 52, 53, 54}},
				[59]	= {critical_damage = 5, args = {148}},
				[60]	= {critical_damage = 1, args = {144}},

				[83]	= {critical_damage = 3, args = {134}} ,-- nose wheel
				[84]	= {critical_damage = 3, args = {136}}, -- left wheel
				[85]	= {critical_damage = 3, args = {135}} ,-- right wheel
	},
	
	DamageParts = 
	{  
		[1] = "C-130-OBLOMOK-WING-R", -- wing R
		[2] = "C-130-OBLOMOK-WING-L", -- wing L
		[3] = "Wunderluft-part-nose", -- nose
		[4] = "Wunderluft-part-tail", -- tail
	},
	
	lights_data = {
	typename = "collection",
	lights = {
    [1] = { typename = "collection",
						lights = {-- Left Anticollision Light
								  {typename = "natostrobelight",
								   connector = "WHITE_BEACON L",
								   argument_1 = 195,
								   period = 1.2,
								   phase_shift = 0
								  },
								  -- Right Anticollision Light
								  {typename = "natostrobelight",
								   connector = "WHITE_BEACON R",
								   argument_1 = 196,
								   period = 1.2,
								   phase_shift = 0
								  },
								  -- Tail Anticollision Light
								  {typename = "natostrobelight",
								   connector = "BANO_0_BACK",
								   argument_1 = 192,
								   period = 1.2,
								   phase_shift = 0
								  }
								 }
									  },
	[2] = { typename = "collection",
							lights = {-- Landing light
									  {typename = "spotlight",
									   connector = "MAIN_SPOT_PTR_02",
									   argument = 209,
									   dir_correction = {elevation = math.rad(-1)}
									  },
									  {-- Landing/Taxi light
									   typename = "spotlight",
									   connector = "MAIN_SPOT_PTR_01",
									   argument = 208,
									   dir_correction = {elevation = math.rad(3)}
									  }
									 }
						},
    [3]	= {	typename = "collection",
						lights = {-- Left Position Light (red)
								  {typename = "omnilight",
								   connector = "BANO_1",
								   color = {0.99, 0.11, 0.3},
								   pos_correction  = {0, 0, -0.2},
								   argument  = 190
								  },
								  -- Right Position Light (green)
								  {typename = "omnilight",
								   connector = "BANO_2",
								   color = {0, 0.894, 0.6},
								   pos_correction = {0, 0, 0.2},
								   argument  = 191
								  },
								  -- Tail Position Light (white)
								  {typename = "omnilight",
								   connector = "BANO_0_BACK",
								   color = {1, 1, 1},
								   pos_correction  = {0, 0, 0},
								   argument  = 203
								  }}
									},
    [4] = {	typename = "collection",
				lights = {{typename = "collection",
						   lights = {
									 -- Top Formation Light (white)
									 {typename = "omnilight",
									  connector = "BANO_0_TOP",
									  color = {1, 1, 1},
									 },
									 {typename  = "argumentlight", argument = 202},
									 -- Bottom Formation Light (white)
									 {typename = "omnilight",
									  connector = "BANO_0_BOTTOM",
									  color = {1, 1, 1},
									 },
									 {typename  = "argumentlight", argument = 201},
									}
							},
							-- Tail formation lights
							{typename = "collection",
								lights = {{
										-- Right Tail Formation Light
										typename = "spotlight",
										connector = "BANO_W_HR",
										color = {1.0, 1.0, 1.0},
										intensity_max = 6,
										angle_max = 0.65,
										argument = 205,
										dont_change_color = false,
										angle_change_rate = 0,
										pos_correction = {0.0, 0.0, 0.1},
										dir_correction = {azimuth = math.rad(-3), elevation = math.rad(9)},
									   },
									   {
										-- Left Tail Formation Light
										typename = "spotlight",
										connector = "BANO_W_HL",
										color = {1.0, 1.0, 1.0},
										intensity_max = 6,
										angle_max = 0.65,
										argument = 204,
										dont_change_color = false,
										angle_change_rate = 0,
										pos_correction = {0.0, 0.0, -0.1},
										dir_correction = {azimuth = math.rad(-3), elevation = math.rad(-9)},
									   }
									},
							},
							-- Electroluminescent formation lights
							{typename  = "argumentlight", argument = 200},
						 }
									},
	[5]	= {typename = "collection",
			lights = {
						{typename = "collection",
						lights = {{
								-- Right Nacelle Floodlight
								typename = "spotlight",
								position  = {0.5, 1.2, 0},
								color = {1.0, 1.0, 1.0},
								intensity_max = 6.0,
								angle_max = 0.45,
								direction = {azimuth = math.rad(150), elevation = math.rad(5)},
								dont_change_color = false,
								angle_change_rate = 0
							   },
							   {
								-- Left Nacelle Floodlight
								typename = "spotlight",
								position  = {0.5, 1.2, 0},
								color = {1.0, 1.0, 1.0},
								intensity_max = 6.0,
								angle_max = 0.45,
								direction = {azimuth = math.rad(-150), elevation = math.rad(5)},
								dont_change_color = false,
								angle_change_rate = 0
							   },
							   {typename  = "argumentlight", argument = 212},
						},
					},
					{typename = "collection",
						lights = {{
								-- Left Nose Floodlight
								typename  = "spotlight",
								position  = {0, -0.3, -5.80},
								color = {1.0, 1.0, 1.0},
								intensity_max = 6.0, angle_max = 0.45,
								direction = {azimuth = math.rad(45)},
								argument = 211,
								dont_change_color = false,
								angle_change_rate = 0
							   },
							   {
								-- Right Nose Floodlight
								typename = "spotlight",
								position  = {0, -0.3, 5.80},
								color = {1.0, 1.0, 1.0},
								intensity_max = 6.0,
								angle_max = 0.45,
								direction = {azimuth = math.rad(-45)},
								argument = 210,
								dont_change_color = false,
								angle_change_rate = 0
							   }
						}
					},
					-- UARRSI light
					{
						typename = "omnilight", position  = {6.5, 0.4, 0}, color = {1, 1, 1}
					}
				  },
			}
		}
	},
	Countries = {"France", "USA"},
}

add_aircraft(C_130FR)
