dofile(LockOn_Options.common_script_path.."elements_defs.lua")
dofile(LockOn_Options.script_path.."ASP17V/Indicator/ASP_17V_definitions.lua")

HUD_DEFAULT_LEVEL = 2
HUD_NOCLIP_LEVEL = HUD_DEFAULT_LEVEL - 1

ULX,ULY,SZX,SZY,GUI_scale = get_UIMainView()
local v = find_viewport("GU_MAIN_VIEWPORT", "CENTER")
if v ~= nil then
	ULX = v.x
	ULY = v.y
	SZX = v.width
	SZY = v.height
else
	ULX = ULX
	ULY = ULY
	SZX = SZX
	SZY = SZY
end
aspect = SZX/SZY

SetScale(FOV)

HUD_OnlyX	   = SZX / 100.0 -- 6.0
HUD_OnlyY 	   = SZY / 100.0 --6.0
-- HUD_OnlyX	   = LockOn_Options.screen.width / 100.0 -- 6.0
-- HUD_OnlyY 	   = LockOn_Options.screen.height / 100.0 --6.0

HUD_OnlyVerts  = {{-HUD_OnlyX, HUD_OnlyY}, {HUD_OnlyX, HUD_OnlyY}, {HUD_OnlyX, -HUD_OnlyY}, {-HUD_OnlyX, -HUD_OnlyY}}
frame1                                       = CreateElement "ceMeshPoly"
frame1.name                                  = "fr1"
frame1.primitivetype                         = "triangles"
frame1.material                              = "BLACK2"
frame1.vertices                  			 = HUD_OnlyVerts
frame1.indices			                     = default_box_indices
frame1.controllers                           = {{"render_purpose", render_purpose.SCREENSPACE_INSIDE_COCKPIT},{"tv_control"}, {"black_frame"}}
frame1.h_clip_relation 						 = h_clip_relations.REWRITE_LEVEL
frame1.level			 					 = HUD_NOCLIP_LEVEL
frame1.isdraw			 					 = true	
frame1.isvisible			 				 = true
frame1.init_pos                              = {HUD_OnlyX - 1.0, -HUD_OnlyY + 1.0}
frame1.use_mipfilter 						 = true
Add(frame1)


frame                                       = CreateElement "ceMeshPoly"
frame.name                                  = "fr"
frame.primitivetype                         = "triangles"
frame.material                              = "BLACK2"
frame.vertices                  			= HUD_OnlyVerts
frame.indices			                    = default_box_indices
frame.controllers                           = {{"render_purpose", render_purpose.SCREENSPACE_INSIDE_COCKPIT},{"tv_control"}, {"camera_on"}}
frame.h_clip_relation 						= h_clip_relations.REWRITE_LEVEL
frame.level			 						= HUD_NOCLIP_LEVEL
frame.isdraw			 					= true	
frame.isvisible			 					= false	
frame.init_pos                              = {HUD_OnlyX - 1.0, -HUD_OnlyY + 1.0}
frame.use_mipfilter 						= true
Add(frame)

Y_interval = 0.3

local tips_pos = {HUD_OnlyX - 1.2, Y_interval*1}

txt_Tips                 = CreateElement "ceStringPoly"
txt_Tips.name            = "txt_Tips"
txt_Tips.material        = "font_general"
txt_Tips.init_pos		 =  tips_pos
txt_Tips.alignment       = "RightCenter"
txt_Tips.isdraw			= true
txt_Tips.isvisible		= true
txt_Tips.stringdefs      = {0.025, 0.025,0,0}
txt_Tips.level			 = HUD_NOCLIP_LEVEL
txt_Tips.h_clip_relation	= h_clip_relations.COMPARE
txt_Tips.value           = "HIDE/SHOW TIPS  [LWIN+H] "
txt_Tips.parent_element  = frame1.name
Add(txt_Tips)

txt_NABLTips                 = CreateElement "ceStringPoly"
txt_NABLTips.name            = "txt_NABLTips"
txt_NABLTips.material        = "font_general"
txt_NABLTips.init_pos		 =  {0.0, 0.0}
txt_NABLTips.alignment       = "CenterCenter"
txt_NABLTips.isdraw			= true
txt_NABLTips.isvisible		= true
txt_NABLTips.stringdefs      = {0.05, 0.05,0,0}
txt_NABLTips.level			 = HUD_NOCLIP_LEVEL
txt_NABLTips.h_clip_relation	= h_clip_relations.COMPARE
txt_NABLTips.value           = "OPEN SIGHT DOORS"
txt_NABLTips.parent_element  = frame1.name
Add(txt_NABLTips)


function AddHints(hintsBase, hintsScale)

	HintsSize = 0.025 * hintsScale
	LinesInterval = 0.3 * hintsScale

	txt_Zoom                 = CreateElement "ceStringPoly"
	txt_Zoom.name            = "txt_Zoom" .. hintsScale
	txt_Zoom.material        = "font_general"
	txt_Zoom.init_pos		 =  {HUD_OnlyX - 1.2, LinesInterval * 21}
	txt_Zoom.alignment       = "RightCenter"
	txt_Zoom.isdraw			= true
	txt_Zoom.isvisible		= true
	txt_Zoom.stringdefs      = {HintsSize, HintsSize,0,0}
	txt_Zoom.level			 = HUD_NOCLIP_LEVEL
	txt_Zoom.h_clip_relation	= h_clip_relations.COMPARE
	txt_Zoom.value           = "ENLARGMENT FACTOR  [LCTRL+X]"
	txt_Zoom.parent_element  = hintsBase.name
	Add(txt_Zoom)


	txt_Zoom_Val             = CreateElement "ceStringPoly"
	txt_Zoom_Val.name            = "txt_Zoom_Val" .. hintsScale
	txt_Zoom_Val.material        = "font_general"
	txt_Zoom_Val.init_pos		 =  {HUD_OnlyX - 0.9, LinesInterval * 21}
	txt_Zoom_Val.alignment       = "LeftCenter"
	txt_Zoom_Val.isdraw			= true
	txt_Zoom_Val.isvisible		= true
	txt_Zoom_Val.stringdefs      = {HintsSize, HintsSize,0,0}
	txt_Zoom_Val.level			 = HUD_NOCLIP_LEVEL
	txt_Zoom_Val.h_clip_relation	= h_clip_relations.COMPARE
	txt_Zoom_Val.formats           = {"X3", "X10"}
	txt_Zoom_Val.controllers     = {{"Zoom_Val"}}
	txt_Zoom_Val.parent_element  = hintsBase.name
	Add(txt_Zoom_Val)

	txt_Filter              = CreateElement "ceStringPoly"
	txt_Filter.name         = "txt_Filter" .. hintsScale
	txt_Filter.material     = "font_general"
	txt_Filter.init_pos		=  {HUD_OnlyX - 1.2, LinesInterval * 6}
	txt_Filter.alignment    = "RightCenter"
	txt_Filter.isdraw		= true
	txt_Filter.isvisible	= true
	txt_Filter.stringdefs   = {HintsSize, HintsSize,0,0}
	txt_Filter.level		= HUD_NOCLIP_LEVEL
	txt_Filter.h_clip_relation	= h_clip_relations.COMPARE
	txt_Filter.value        = "LASER PROTECT  [RALT+G] "
	txt_Filter.parent_element  = hintsBase.name
	Add(txt_Filter)

	txt_Filter_Val             = CreateElement "ceStringPoly"
	txt_Filter_Val.name            = "txt_Filter_Val" .. hintsScale
	txt_Filter_Val.material        = "font_general"
	txt_Filter_Val.init_pos		 =  {HUD_OnlyX - 0.9, LinesInterval * 6}
	txt_Filter_Val.alignment       = "LeftCenter"
	txt_Filter_Val.isdraw			= true
	txt_Filter_Val.isvisible		= true
	txt_Filter_Val.stringdefs      = {HintsSize, HintsSize,0,0}
	txt_Filter_Val.level			 = HUD_NOCLIP_LEVEL
	txt_Filter_Val.h_clip_relation	= h_clip_relations.COMPARE
	txt_Filter_Val.formats           = {"OFF", "ON"}
	txt_Filter_Val.controllers     = {{"Laser_Filter"}}
	txt_Filter_Val.parent_element  = hintsBase.name
	Add(txt_Filter_Val)

	txt_Filter1              = CreateElement "ceStringPoly"
	txt_Filter1.name         = "txt_Filter1" .. hintsScale
	txt_Filter1.material     = "font_general"
	txt_Filter1.init_pos	 =  {HUD_OnlyX - 1.2, LinesInterval * 5}
	txt_Filter1.alignment    = "RightCenter"
	txt_Filter1.isdraw		= true
	txt_Filter1.isvisible	= true
	txt_Filter1.stringdefs   = {HintsSize, HintsSize,0,0}
	txt_Filter1.level		= HUD_NOCLIP_LEVEL
	txt_Filter1.h_clip_relation	= h_clip_relations.COMPARE
	txt_Filter1.value        = "FILTER ON/OFF           "
	txt_Filter1.parent_element  = hintsBase.name
	Add(txt_Filter1)


	txt_OrangeFilter            = CreateElement "ceStringPoly"
	txt_OrangeFilter.name       = "txt_OrangeFilter" .. hintsScale
	txt_OrangeFilter.material   = "font_general"
	txt_OrangeFilter.init_pos	=  {HUD_OnlyX - 1.2, LinesInterval * 8}
	txt_OrangeFilter.alignment  = "RightCenter"
	txt_OrangeFilter.isdraw		= true
	txt_OrangeFilter.isvisible	= true
	txt_OrangeFilter.stringdefs   = {HintsSize, HintsSize,0,0}
	txt_OrangeFilter.level		= HUD_NOCLIP_LEVEL
	txt_OrangeFilter.h_clip_relation	= h_clip_relations.COMPARE
	txt_OrangeFilter.value      = "ORANGE FILTER ON/OFF  [RALT+O] "
	txt_OrangeFilter.parent_element  = hintsBase.name
	Add(txt_OrangeFilter)

	txt_Filter1_Val             = CreateElement "ceStringPoly"
	txt_Filter1_Val.name            = "txt_Filter1_Val" .. hintsScale
	txt_Filter1_Val.material        = "font_general"
	txt_Filter1_Val.init_pos		 =  {HUD_OnlyX - 0.9, LinesInterval * 8}
	txt_Filter1_Val.alignment       = "LeftCenter"
	txt_Filter1_Val.isdraw			= true
	txt_Filter1_Val.isvisible		= true
	txt_Filter1_Val.stringdefs      = {HintsSize, HintsSize,0,0}
	txt_Filter1_Val.level			 = HUD_NOCLIP_LEVEL
	txt_Filter1_Val.h_clip_relation	= h_clip_relations.COMPARE
	txt_Filter1_Val.formats           = {"OFF", "ON"}
	txt_Filter1_Val.controllers     = {{"Orange_Filter"}}
	txt_Filter1_Val.parent_element  = hintsBase.name
	Add(txt_Filter1_Val)


	txt_Mouse1            = CreateElement "ceStringPoly"
	txt_Mouse1.name       = "txt_Mouse1" .. hintsScale
	txt_Mouse1.material   = "font_general"
	txt_Mouse1.init_pos	=  {HUD_OnlyX - 1.2, LinesInterval * 15}
	txt_Mouse1.alignment  = "RightCenter"
	txt_Mouse1.isdraw		= true
	txt_Mouse1.isvisible	= true
	txt_Mouse1.stringdefs   = {HintsSize, HintsSize,0,0}
	txt_Mouse1.level		= HUD_NOCLIP_LEVEL
	txt_Mouse1.h_clip_relation	= h_clip_relations.COMPARE
	txt_Mouse1.value      = "KEY CONTROL OF           "
	txt_Mouse1.parent_element  = hintsBase.name
	Add(txt_Mouse1)

	txt_Mouse2            = CreateElement "ceStringPoly"
	txt_Mouse2.name       = "txt_Mouse2" .. hintsScale
	txt_Mouse2.material   = "font_general"
	txt_Mouse2.init_pos	=  {HUD_OnlyX - 1.2, LinesInterval * 14}
	txt_Mouse2.alignment  = "RightCenter"
	txt_Mouse2.isdraw		= true
	txt_Mouse2.isvisible	= true
	txt_Mouse2.stringdefs   = {HintsSize, HintsSize,0,0}
	txt_Mouse2.level		= HUD_NOCLIP_LEVEL
	txt_Mouse2.h_clip_relation	= h_clip_relations.COMPARE
	txt_Mouse2.value      = "VIEWING AXIS:           "
	txt_Mouse2.parent_element  = hintsBase.name
	Add(txt_Mouse2)

	txt_Mouse3            = CreateElement "ceStringPoly"
	txt_Mouse3.name       = "txt_Mouse3" .. hintsScale
	txt_Mouse3.material   = "font_general"
	txt_Mouse3.init_pos	=  {HUD_OnlyX - 1.2, LinesInterval * 13}
	txt_Mouse3.alignment  = "RightCenter"
	txt_Mouse3.isdraw		= true
	txt_Mouse3.isvisible	= true
	txt_Mouse3.stringdefs   = {HintsSize, HintsSize,0,0}
	txt_Mouse3.level		= HUD_NOCLIP_LEVEL
	txt_Mouse3.h_clip_relation	= h_clip_relations.COMPARE
	txt_Mouse3.value      = "LEFT  [,]      "
	txt_Mouse3.parent_element  = hintsBase.name
	Add(txt_Mouse3)

	txt_Mouse4            = CreateElement "ceStringPoly"
	txt_Mouse4.name       = "txt_Mouse4" .. hintsScale
	txt_Mouse4.material   = "font_general"
	txt_Mouse4.init_pos	=  {HUD_OnlyX - 1.2, LinesInterval * 12}
	txt_Mouse4.alignment  = "RightCenter"
	txt_Mouse4.isdraw		= true
	txt_Mouse4.isvisible	= true
	txt_Mouse4.stringdefs   = {HintsSize, HintsSize,0,0}
	txt_Mouse4.level		= HUD_NOCLIP_LEVEL
	txt_Mouse4.h_clip_relation	= h_clip_relations.COMPARE
	txt_Mouse4.value      = "RIGHT  [/]      "
	txt_Mouse4.parent_element  = hintsBase.name
	Add(txt_Mouse4)

	txt_Mouse5            = CreateElement "ceStringPoly"
	txt_Mouse5.name       = "txt_Mouse5" .. hintsScale
	txt_Mouse5.material   = "font_general"
	txt_Mouse5.init_pos	=  {HUD_OnlyX - 1.2, LinesInterval * 11}
	txt_Mouse5.alignment  = "RightCenter"
	txt_Mouse5.isdraw		= true
	txt_Mouse5.isvisible	= true
	txt_Mouse5.stringdefs   = {HintsSize, HintsSize,0,0}
	txt_Mouse5.level		= HUD_NOCLIP_LEVEL
	txt_Mouse5.h_clip_relation	= h_clip_relations.COMPARE
	txt_Mouse5.value      = "UP  [;]      "
	txt_Mouse5.parent_element  = hintsBase.name
	Add(txt_Mouse5)

	txt_Mouse6            = CreateElement "ceStringPoly"
	txt_Mouse6.name       = "txt_Mouse6" .. hintsScale
	txt_Mouse6.material   = "font_general"
	txt_Mouse6.init_pos	=  {HUD_OnlyX - 1.2, LinesInterval * 10}
	txt_Mouse6.alignment  = "RightCenter"
	txt_Mouse6.isdraw		= true
	txt_Mouse6.isvisible	= true
	txt_Mouse6.stringdefs   = {HintsSize, HintsSize,0,0}
	txt_Mouse6.level		= HUD_NOCLIP_LEVEL
	txt_Mouse6.h_clip_relation	= h_clip_relations.COMPARE
	txt_Mouse6.value      = "DOWN  [.]      "
	txt_Mouse6.parent_element  = hintsBase.name
	Add(txt_Mouse6)


	txt_ArrowHelper                 = CreateElement "ceStringPoly"
	txt_ArrowHelper.name            = "txt_ArrowHelper" .. hintsScale
	txt_ArrowHelper.material        = "font_general"
	txt_ArrowHelper.init_pos		 =  {HUD_OnlyX - 1.2, LinesInterval * 4}
	txt_ArrowHelper.alignment       = "RightCenter"
	txt_ArrowHelper.isdraw			= true
	txt_ArrowHelper.isvisible		= true
	txt_ArrowHelper.stringdefs      = {HintsSize, HintsSize,0,0}
	txt_ArrowHelper.level			 = HUD_NOCLIP_LEVEL
	txt_ArrowHelper.h_clip_relation	= h_clip_relations.COMPARE
	txt_ArrowHelper.value           = "STEERING HELPER  [LALT+S] "
	txt_ArrowHelper.parent_element  = hintsBase.name
	Add(txt_ArrowHelper)

	txt_ArrowHelper_Val             = CreateElement "ceStringPoly"
	txt_ArrowHelper_Val.name            = "txt_ArrowHelper_Val" .. hintsScale
	txt_ArrowHelper_Val.material        = "font_general"
	txt_ArrowHelper_Val.init_pos		 =  {HUD_OnlyX - 0.9, LinesInterval * 4}
	txt_ArrowHelper_Val.alignment       = "LeftCenter"
	txt_ArrowHelper_Val.isdraw			= true
	txt_ArrowHelper_Val.isvisible		= true
	txt_ArrowHelper_Val.stringdefs      = {HintsSize, HintsSize,0,0}
	txt_ArrowHelper_Val.level			 = HUD_NOCLIP_LEVEL
	txt_ArrowHelper_Val.h_clip_relation	= h_clip_relations.COMPARE
	txt_ArrowHelper_Val.formats           = {"OFF", "ON"}
	txt_ArrowHelper_Val.controllers     = {{"ArrowHelper_Val"}}
	txt_ArrowHelper_Val.parent_element  = hintsBase.name
	Add(txt_ArrowHelper_Val)
	
	txt_LaunchKey     = CreateElement "ceStringPoly"
	txt_LaunchKey.name       = "txt_LaunchKey" .. hintsScale
	txt_LaunchKey.material   = "font_general"
	txt_LaunchKey.init_pos	=  {HUD_OnlyX - 0.55, LinesInterval * 3}
	txt_LaunchKey.alignment  = "RightCenter"
	txt_LaunchKey.isdraw		= true
	txt_LaunchKey.isvisible	= true
	txt_LaunchKey.stringdefs   = {HintsSize, HintsSize,0,0}
	txt_LaunchKey.level		= HUD_NOCLIP_LEVEL
	txt_LaunchKey.h_clip_relation	= h_clip_relations.COMPARE
	txt_LaunchKey.value      = "LAUNCH MISSILE  [RCTRL+SPACE]"
	txt_LaunchKey.parent_element  = hintsBase.name
	Add(txt_LaunchKey)
	
end

Hints					= CreateElement "ceSimple"
Hints.name				= "Hints9K113"
Hints.parent_element  = frame1.name
Hints.controllers     = {{"HintsOn", 1}}
Add(Hints)

AddHints(Hints, 1)

Hints_1					= CreateElement "ceSimple"
Hints_1.name			= "Hints9K113_1"
Hints_1.parent_element  = frame1.name
Hints_1.controllers     = {{"HintsOn", 2}}
Add(Hints_1)

AddHints(Hints_1, 1.5)


HUD_Y_size = 0.9 * HUD_OnlyY
HUD_OnlyVerts  = {{-HUD_Y_size, HUD_Y_size}, {HUD_Y_size, HUD_Y_size}, {HUD_Y_size, -HUD_Y_size}, {-HUD_Y_size, -HUD_Y_size}}

FOV = HUD_Y_size
num_points = 64
step = math.rad(360.0/num_points)

verts = {}
for i = 1, num_points do
	verts[i] = {FOV * math.cos(i * step), FOV * math.sin(i * step)}
end

		
total_field_of_view9K113 = CreateElement "ceMeshPoly"
total_field_of_view9K113.name = "total_field_of_view9K113"
total_field_of_view9K113.primitivetype = "triangles"
total_field_of_view9K113.vertices = verts

inds = {}
j = 0
for i = 0, 61 do
	j = j + 1
	inds[j] = 0
	j = j + 1
	inds[j] = i + 1
	j = j + 1
	inds[j] = i + 2
end

total_field_of_view9K113.indices		     = inds
total_field_of_view9K113.init_pos		 = {0.0, 0.0, 0.0}
total_field_of_view9K113.init_rot		 = {0.0, 0.0, 0.0}
total_field_of_view9K113.material		 = "RED_TRANSPARENT"
total_field_of_view9K113.h_clip_relation  = h_clip_relations.INCREASE_IF_LEVEL
total_field_of_view9K113.level			 = HUD_NOCLIP_LEVEL
total_field_of_view9K113.isdraw			= true
total_field_of_view9K113.isvisible		= false
total_field_of_view9K113.z_enabled 		= false
total_field_of_view9K113.parent_element   =  frame.name
Add(total_field_of_view9K113)

render_tv_in_HUD_only_view					= CreateElement "ceTexPoly"
render_tv_in_HUD_only_view.name				= "render_tv_in_HUD_only_view"
render_tv_in_HUD_only_view.vertices			= verts
render_tv_in_HUD_only_view.indices			= inds
render_tv_in_HUD_only_view.tex_params		= {0.5, 0.5, 1 / (2 * HUD_Y_size), 1 / (2 * HUD_Y_size)}
render_tv_in_HUD_only_view.material			= "render_target_"..string.format("%d",GetRenderTarget() + 1)
render_tv_in_HUD_only_view.parent_element   =  frame.name
Add(render_tv_in_HUD_only_view)



BG_9k113_Orange 				= CreateElement "ceMeshPoly"
BG_9k113_Orange.name 			= "BG_9k113_Orange"
BG_9k113_Orange.primitivetype 	= "triangles"
BG_9k113_Orange.vertices 		= verts
BG_9k113_Orange.indices		    = inds
BG_9k113_Orange.init_pos		= {0.0, 0.0, 0.0}
BG_9k113_Orange.init_rot		= {0.0, 0.0, 0.0}
BG_9k113_Orange.material		= "ORANGE_2"
BG_9k113_Orange.h_clip_relation = h_clip_relations.COMPARE
BG_9k113_Orange.level			= HUD_DEFAULT_LEVEL
BG_9k113_Orange.isdraw			= true
BG_9k113_Orange.isvisible		= true
BG_9k113_Orange.z_enabled 		= false
BG_9k113_Orange.parent_element  =  frame.name
BG_9k113_Orange.controllers     = {{"Orange_filter_9K113"}}
Add(BG_9k113_Orange)

BG_9k113_Green            	= CreateElement "ceMeshPoly"
BG_9k113_Green.name        	= "BG_9k113_Green"
BG_9k113_Green.material    	= "GREEN_2"
BG_9k113_Green.vertices    	= verts
BG_9k113_Green.indices		= inds
BG_9k113_Green.init_pos		= {0.0, 0.0, 0.0}
BG_9k113_Green.init_rot		= {0.0, 0.0, 0.0}
BG_9k113_Green.isdraw		= true
BG_9k113_Green.isvisible	= true
BG_9k113_Green.z_enabled 	= false
BG_9k113_Green.h_clip_relation	= h_clip_relations.COMPARE
BG_9k113_Green.level		= HUD_DEFAULT_LEVEL
BG_9k113_Green.parent_element   	=  frame.name
BG_9k113_Green.controllers      = {{"Green_filter_9K113"}}
Add(BG_9k113_Green)


tex_scale = 1.0 / 1024.0
local scale = 70

BG_9k113                  	= CreateElement "ceTexPoly"
BG_9k113.name             	= "BG_9k113"
BG_9k113.material         	= "INDICATION_9K113_BG"
BG_9k113.vertices         	= HUD_OnlyVerts
BG_9k113.indices		  	= default_box_indices
BG_9k113.init_pos		  	= {0.0, 0.0, 0.0}
BG_9k113.init_rot		  	= {0.0, 0.0, 0.0}
BG_9k113.isdraw			  	= true
BG_9k113.isvisible			= true
BG_9k113.z_enabled 			= false
BG_9k113.h_clip_relation	= h_clip_relations.COMPARE
BG_9k113.level				= HUD_DEFAULT_LEVEL
BG_9k113.tex_params 		= {0.5, 0.5, 1 / (2.07 * HUD_Y_size), 1 / (2.07 * HUD_Y_size)}
BG_9k113.parent_element   	=  frame.name
BG_9k113.additive_alpha		= true
BG_9k113.use_mipfilter		= true
Add(BG_9k113)

local upY = 2 / scale
local leftX = 1.0 / scale
local rightX = 281.0 / scale

local bl_delta = 1.0 / scale

local	ZeroLine_backlight			= CreateElement("ceHWLine")
ZeroLine_backlight.name				= "FlexCrossZeroLine_backlight1"
ZeroLine_backlight.vertices			= {{-leftX - bl_delta, -upY - bl_delta}, {-leftX - bl_delta, upY + bl_delta}, {rightX + bl_delta, upY + bl_delta}, {rightX + bl_delta, -upY - bl_delta}}
ZeroLine_backlight.maskvertices		= {{0, -upY - bl_delta}, {0,upY + bl_delta}, {rightX + bl_delta, upY + bl_delta}, {rightX + bl_delta, -upY - bl_delta}}
ZeroLine_backlight.indices			= default_box_indices
ZeroLine_backlight.maxlength		= HUD_Y_size * 0.66
ZeroLine_backlight.length			= HUD_Y_size * 0.61
ZeroLine_backlight.material			= "ORANGE_2"
ZeroLine_backlight.tex_params		= {tex_scale * 16, tex_scale * 496.5, tex_scale * scale, tex_scale * scale}
ZeroLine_backlight.init_pos			= {0.0, -HUD_Y_size, 0.0}
ZeroLine_backlight.init_rot			= {90.0, 0.0, 0.0}
ZeroLine_backlight.controllers    	= {{"ZeroLine", HUD_Y_size}}
ZeroLine_backlight.parent_element	= frame.name
ZeroLine_backlight.isdraw			= true
ZeroLine_backlight.h_clip_relation	= h_clip_relations.COMPARE
ZeroLine_backlight.level			= HUD_DEFAULT_LEVEL
ZeroLine_backlight.additive_alpha	= true
ZeroLine_backlight.use_mipfilter	= true
ZeroLine_backlight.z_enabled 		= false
ZeroLine_backlight.controllers    = {{"backlight_9K113_on"}}
Add(ZeroLine_backlight)

local	ZeroLine			= CreateElement("ceHWLine")
ZeroLine.name				= "FlexCrossZeroLine1"
ZeroLine.vertices			= {{-leftX, -upY}, {-leftX, upY}, {rightX, upY}, {rightX, -upY}}
ZeroLine.maskvertices		= {{0, -upY}, {0,upY}, {rightX, upY}, {rightX, -upY}}
ZeroLine.indices			= default_box_indices
ZeroLine.maxlength			= HUD_Y_size * 0.66
ZeroLine.length				= HUD_Y_size * 0.61
ZeroLine.material			= "BLACK_IND"
ZeroLine.tex_params			= {tex_scale * 16, tex_scale * 496.5, tex_scale * scale, tex_scale * scale}
ZeroLine.init_pos			= {0.0, -HUD_Y_size, 0.0}
ZeroLine.init_rot			= {90.0, 0.0, 0.0}
ZeroLine.controllers    	= {{"ZeroLine", HUD_Y_size}}
ZeroLine.parent_element		= frame.name
ZeroLine.isdraw				= true
ZeroLine.h_clip_relation	= h_clip_relations.COMPARE
ZeroLine.level				= HUD_DEFAULT_LEVEL
ZeroLine.additive_alpha		= true
ZeroLine.use_mipfilter		= true
ZeroLine.z_enabled 			= false
Add(ZeroLine)

Grid_9k113_backlight                = CreateElement "ceTexPoly"
Grid_9k113_backlight.name           = "Grid_9k113_backlight"
Grid_9k113_backlight.material       = "INDICATION_9K113_GRID_FIXED_backlight"
Grid_9k113_backlight.vertices       = HUD_OnlyVerts
Grid_9k113_backlight.indices		= default_box_indices
Grid_9k113_backlight.init_pos		= {0.0, 0.0, 0.0}
Grid_9k113_backlight.init_rot		= {0.0, 0.0, 0.0}
Grid_9k113_backlight.isdraw			= true
Grid_9k113_backlight.isvisible		= true
Grid_9k113_backlight.z_enabled 		= false
Grid_9k113_backlight.h_clip_relation	= h_clip_relations.COMPARE
Grid_9k113_backlight.level			= HUD_DEFAULT_LEVEL
Grid_9k113_backlight.tex_params 		= {0.5, 0.5, 1 / (2 * HUD_Y_size), 1 / (2 * HUD_Y_size)}
Grid_9k113_backlight.controllers    = {{"backlight_9K113_on"}}
Grid_9k113_backlight.parent_element   =  frame.name
Grid_9k113_backlight.additive_alpha	= true
Grid_9k113_backlight.use_mipfilter	= true
Add(Grid_9k113_backlight)

Grid_9k113                  = CreateElement "ceTexPoly"
Grid_9k113.name             = "Grid_9k113"
Grid_9k113.material         = "INDICATION_9K113_GRID_FIXED"
Grid_9k113.vertices         = HUD_OnlyVerts
Grid_9k113.indices		    = default_box_indices
Grid_9k113.init_pos		 	= {0.0, 0.0, 0.0}
Grid_9k113.init_rot			= {0.0, 0.0, 0.0}
Grid_9k113.isdraw			= true
Grid_9k113.isvisible		= true
Grid_9k113.z_enabled 		= false
Grid_9k113.h_clip_relation	= h_clip_relations.COMPARE
Grid_9k113.level			= HUD_DEFAULT_LEVEL
Grid_9k113.tex_params 		= {0.5, 0.5, 1 / (2 * HUD_Y_size), 1 / (2 * HUD_Y_size)}
Grid_9k113.parent_element   =  frame.name
Grid_9k113.additive_alpha	= true
Grid_9k113.use_mipfilter	= true
Add(Grid_9k113)

Grid_10x_9k113_backlight                = CreateElement "ceTexPoly"
Grid_10x_9k113_backlight.name           = "Grid_10x_9k113_backlight"
Grid_10x_9k113_backlight.material       = "INDICATION_9K113_GRID_10x_backlight"
Grid_10x_9k113_backlight.vertices       = HUD_OnlyVerts
Grid_10x_9k113_backlight.indices		= default_box_indices
Grid_10x_9k113_backlight.init_pos		= {0.0, 0.0, 0.0}
Grid_10x_9k113_backlight.init_rot		= {0.0, 0.0, 0.0}
Grid_10x_9k113_backlight.isdraw			= true
Grid_10x_9k113_backlight.isvisible		= true
Grid_10x_9k113_backlight.z_enabled 		= false
Grid_10x_9k113_backlight.controllers    = {{"Grid_9K113_rotation", 1}, {"backlight_9K113_on"}}
Grid_10x_9k113_backlight.h_clip_relation	= h_clip_relations.COMPARE
Grid_10x_9k113_backlight.level			= HUD_DEFAULT_LEVEL
Grid_10x_9k113_backlight.tex_params 	= {0.5, 0.5, 1 / (2 * HUD_Y_size), 1 / (2 * HUD_Y_size)}
Grid_10x_9k113_backlight.parent_element =  frame.name
Grid_10x_9k113_backlight.additive_alpha	= true
Grid_10x_9k113_backlight.use_mipfilter	= true
Add(Grid_10x_9k113_backlight)

Grid_10x_9k113                  = CreateElement "ceTexPoly"
Grid_10x_9k113.name             = "Grid_10x_9k113"
Grid_10x_9k113.material         = "INDICATION_9K113_GRID_10x"
Grid_10x_9k113.vertices         = HUD_OnlyVerts
Grid_10x_9k113.indices		    = default_box_indices
Grid_10x_9k113.init_pos		 	= {0.0, 0.0, 0.0}
Grid_10x_9k113.init_rot			= {0.0, 0.0, 0.0}
Grid_10x_9k113.isdraw			= true
Grid_10x_9k113.isvisible		= true
Grid_10x_9k113.z_enabled 		= false
Grid_10x_9k113.controllers      = {{"Grid_9K113_rotation", 1}}
Grid_10x_9k113.h_clip_relation	= h_clip_relations.COMPARE
Grid_10x_9k113.level			= HUD_DEFAULT_LEVEL
Grid_10x_9k113.tex_params 		= {0.5, 0.5, 1 / (2 * HUD_Y_size), 1 / (2 * HUD_Y_size)}
Grid_10x_9k113.parent_element   =  frame.name
Grid_10x_9k113.additive_alpha	= true
Grid_10x_9k113.use_mipfilter	= true
Add(Grid_10x_9k113)

Grid_3x_9k113_backlight                 = CreateElement "ceTexPoly"
Grid_3x_9k113_backlight.name            = "Grid_3x_9k113_backlight"
Grid_3x_9k113_backlight.material        = "INDICATION_9K113_GRID_3x_backlight"
Grid_3x_9k113_backlight.vertices        = HUD_OnlyVerts
Grid_3x_9k113_backlight.indices		    = default_box_indices
Grid_3x_9k113_backlight.init_pos		= {0.0, 0.0, 0.0}
Grid_3x_9k113_backlight.init_rot		= {0.0, 0.0, 0.0}
Grid_3x_9k113_backlight.isdraw			= true
Grid_3x_9k113_backlight.isvisible		= true
Grid_3x_9k113_backlight.z_enabled 		= false
Grid_3x_9k113_backlight.controllers     = {{"Grid_9K113_rotation", 0}, {"backlight_9K113_on"}}
Grid_3x_9k113_backlight.h_clip_relation	= h_clip_relations.COMPARE
Grid_3x_9k113_backlight.level			= HUD_DEFAULT_LEVEL
Grid_3x_9k113_backlight.tex_params 		= {0.5, 0.5, 1 / (2 * HUD_Y_size), 1 / (2 * HUD_Y_size)}
Grid_3x_9k113_backlight.parent_element  =  frame.name
Grid_3x_9k113_backlight.additive_alpha	= true
Grid_3x_9k113_backlight.use_mipfilter	= true
Add(Grid_3x_9k113_backlight)

Grid_3x_9k113                  = CreateElement "ceTexPoly"
Grid_3x_9k113.name             = "Grid_3x_9k113"
Grid_3x_9k113.material         = "INDICATION_9K113_GRID_3x"
Grid_3x_9k113.vertices         = HUD_OnlyVerts
Grid_3x_9k113.indices		    = default_box_indices
Grid_3x_9k113.init_pos		 	= {0.0, 0.0, 0.0}
Grid_3x_9k113.init_rot			= {0.0, 0.0, 0.0}
Grid_3x_9k113.isdraw			= true
Grid_3x_9k113.isvisible			= true
Grid_3x_9k113.z_enabled 		= false
Grid_3x_9k113.controllers      	= {{"Grid_9K113_rotation", 0}}
Grid_3x_9k113.h_clip_relation	= h_clip_relations.COMPARE
Grid_3x_9k113.level				= HUD_DEFAULT_LEVEL
Grid_3x_9k113.tex_params 		= {0.5, 0.5, 1 / (2 * HUD_Y_size), 1 / (2 * HUD_Y_size)}
Grid_3x_9k113.parent_element   	=  frame.name
Grid_3x_9k113.additive_alpha	= true
Grid_3x_9k113.use_mipfilter	= true
Add(Grid_3x_9k113)


Ready_9k113                  = CreateElement "ceTexPoly"
Ready_9k113.name             = "Ready_9k113"
Ready_9k113.material         = "INDICATION_9K113_READY"
Ready_9k113.vertices         = HUD_OnlyVerts
Ready_9k113.indices		     = default_box_indices
Ready_9k113.init_pos		 = {0.0, 0.0, 0.0}
Ready_9k113.init_rot		 = {0.0, 0.0, 0.0}
Ready_9k113.isdraw			 = true
Ready_9k113.isvisible		 = true
Ready_9k113.z_enabled 		 = false
Ready_9k113.controllers      = {{"Ready_9K113"}}
Ready_9k113.h_clip_relation	= h_clip_relations.COMPARE
Ready_9k113.level				= HUD_DEFAULT_LEVEL
Ready_9k113.tex_params 		= {0.5, 0.5, 1 / (2 * HUD_Y_size), 1 / (2 * HUD_Y_size)}
Ready_9k113.parent_element   	=  frame.name
Ready_9k113.additive_alpha	= true
Ready_9k113.use_mipfilter	= true
Add(Ready_9k113)


if LockOn_Options.screen.oculus_rift then
	screen_aspect = aspect
	kX = 2/SZX*screen_aspect;
	kY = 2/SZY;
else
	screen_aspect = SZX/SZY
	kX = 2/SZX*screen_aspect;
	kY = 2/SZY;
end

CX_norm = -screen_aspect+(ULX+SZX/2)*kX
CY_norm = 1-(ULY+SZY/2)*kY

local ssize = 0.25
steering                    = CreateElement "ceStateTexPoly"
steering.vertices           = {{-ssize, -ssize}, { -ssize, ssize}, { ssize,ssize}, {ssize,-ssize}}
steering.indices            = default_box_indices
steering.material           = MakeMaterial("Bazar/Textures/AvionicsCommon/Cursors.tga",{255, 255, 0, 255})
steering.state_tex_coords   = 
{
	{{0/128.0, 49.0/128.0},{0.0/128.0, 0.0/128.0},{49.0/128.0, 0.0/128.0},{49.0/128.0, 49.0/128.0}},
	{{64.0/128.0, 56.0/128.0},{64.0/128.0, 0.0/128.0},{120.0/128.0, 0.0/128.0},{120.0/128.0, 56.0/128.0}},
	{{0.0/128.0, 120.0/128.0},{0.0/128.0, 64.0/128.0},{56.0/128.0, 64.0/128.0},{56.0/128.0, 120.0/128.0}},
	{{64.0/128.0, 120.0/128.0},{64.0/128.0, 64.0/128.0},{120.0/128.0, 64.0/128.0},{120.0/128.0, 120.0/128.0}},
}
steering.init_pos			= {CX_norm, CY_norm}
steering.additive_alpha     = false
steering.parent_element   	=  frame.name
steering.level				= HUD_DEFAULT_LEVEL
steering.h_clip_relation	= h_clip_relations.COMPARE
steering.isdraw			 	= true
steering.isvisible		 	= true
steering.z_enabled 		 	= false
steering.controllers        = {{"draw_steering_helper", 0.66, aspect}}
steering.use_mipfilter      = true
Add(steering)
