local my_db_path = db_path or "./scripts/database/"
require(my_db_path..'/scripts/utils')
require(my_db_path..'/scripts/sensors')

WS_TOW_launcher = {} -- for M2 Bradley and M1134 Stryker ATGM
WS_TOW_launcher.LN = {}
WS_TOW_launcher.LN[1] = {}
WS_TOW_launcher.LN[1].type = 33
WS_TOW_launcher.LN[1].distanceMin = 50
WS_TOW_launcher.LN[1].distanceMax = 3000
WS_TOW_launcher.LN[1].max_trg_alt = 3000
WS_TOW_launcher.LN[1].reactionTime = 2
WS_TOW_launcher.LN[1].type_ammunition={4,4,8,130}
WS_TOW_launcher.LN[1].ammunition_reserve = 14
WS_TOW_launcher.LN[1].sound = { single_shot = "TowLaunch", }
WS_TOW_launcher.LN[1].sensor = {}
set_recursive_metatable(WS_TOW_launcher.LN[1].sensor, WSN_0)
WS_TOW_launcher.LN[1].PL = {}
WS_TOW_launcher.LN[1].PL[1] = {}
WS_TOW_launcher.LN[1].PL[1].reload_time = 30
WS_TOW_launcher.LN[1].PL[1].ammo_capacity = 2
WS_TOW_launcher.LN[1].PL[1].shot_delay = 1
WS_TOW_launcher.LN[1].BR = { {pos = {0.7, 0.4, -1.3} }, {pos = {0.7, 0.5, -1.3} } }

WS_Malutka_launcher = {} -- 9M14 Malutka (AT-3 "Sagger") for BMP-1, BMD-1
WS_Malutka_launcher.type = 33
WS_Malutka_launcher.pos = {-0.099, 1.753,0}
WS_Malutka_launcher.xc = 0.512
WS_Malutka_launcher.distanceMin = 100
WS_Malutka_launcher.distanceMax = 3000
WS_Malutka_launcher.max_trg_alt = 3000
WS_Malutka_launcher.reactionTime = 2
WS_Malutka_launcher.type_ammunition={4,4,11,127}
WS_Malutka_launcher.show_external_missile = false
WS_Malutka_launcher.ammunition_reserve = 3
WS_Malutka_launcher.sound = { single_shot = "MissileLaunch", }
WS_Malutka_launcher.sensor = {}
set_recursive_metatable(WS_Malutka_launcher.sensor, WSN_0)
WS_Malutka_launcher.PL = {}
WS_Malutka_launcher.PL[1] = {}
WS_Malutka_launcher.PL[1].shot_delay = 1
WS_Malutka_launcher.PL[1].ammo_capacity = 1
WS_Malutka_launcher.PL[1].reload_time = 30
WS_Malutka_launcher.BR = { {pos = {1.366, 0.237,0}, drawArgument = 4 } }

WS_Kornet_launcher = {} -- 9M133 'KORNET' ATGM for BTR-RD vehicle
WS_Kornet_launcher.LN = {}
WS_Kornet_launcher.LN[1] = {}
WS_Kornet_launcher.LN[1].type = 33
WS_Kornet_launcher.LN[1].distanceMin = 100
WS_Kornet_launcher.LN[1].distanceMax = 3000
WS_Kornet_launcher.LN[1].max_trg_alt = 3000
WS_Kornet_launcher.LN[1].reactionTime = 2
WS_Kornet_launcher.LN[1].type_ammunition={4,4,11,153}
WS_Kornet_launcher.LN[1].show_external_missile = false
WS_Kornet_launcher.LN[1].ammunition_reserve = 4
WS_Kornet_launcher.LN[1].sound = { single_shot = "MissileLaunch", }
WS_Kornet_launcher.LN[1].sensor = {}
set_recursive_metatable(WS_Kornet_launcher.LN[1].sensor, WSN_0)
WS_Kornet_launcher.LN[1].PL = {}
WS_Kornet_launcher.LN[1].PL[1] = {}
WS_Kornet_launcher.LN[1].PL[1].shot_delay = 1
WS_Kornet_launcher.LN[1].PL[1].reload_time = 30
WS_Kornet_launcher.LN[1].PL[1].ammo_capacity = 1
WS_Kornet_launcher.LN[1].BR = { {pos = {1.366, 0, 0}, drawArgument = 4 } }

WS_Fagot_launcher = {} -- 9M111 'Fagot' ATGM for BMP-2
WS_Fagot_launcher.LN = {}
WS_Fagot_launcher.LN[1] = {}
WS_Fagot_launcher.LN[1].type = 33
WS_Fagot_launcher.LN[1].xc = 0.512
WS_Fagot_launcher.LN[1].distanceMin = 100
WS_Fagot_launcher.LN[1].distanceMax = 3000
WS_Fagot_launcher.LN[1].max_trg_alt = 3000
WS_Fagot_launcher.LN[1].reactionTime = 2
WS_Fagot_launcher.LN[1].type_ammunition={4,4,11,128}
WS_Fagot_launcher.LN[1].show_external_missile = false
WS_Fagot_launcher.LN[1].ammunition_reserve = 5
WS_Fagot_launcher.LN[1].sound = { single_shot = "MissileLaunch", }
WS_Fagot_launcher.LN[1].sensor = {}
set_recursive_metatable(WS_Fagot_launcher.LN[1].sensor, WSN_0)
WS_Fagot_launcher.LN[1].PL = {}
WS_Fagot_launcher.LN[1].PL[1] = {}
WS_Fagot_launcher.LN[1].PL[1].shot_delay = 1
WS_Fagot_launcher.LN[1].PL[1].ammo_capacity = 1
WS_Fagot_launcher.LN[1].PL[1].reload_time = 30
WS_Fagot_launcher.LN[1].BR = { {pos = {1.366, 0.237,0}, drawArgument = 4 } }

WS_9M117_launcher = {} -- for BMP-3
WS_9M117_launcher.LN = {}
WS_9M117_launcher.LN[2] = {}
WS_9M117_launcher.LN[2].type = 33
WS_9M117_launcher.LN[2].xc = 0.585
WS_9M117_launcher.LN[2].distanceMin = 100
WS_9M117_launcher.LN[2].distanceMax = 4000
WS_9M117_launcher.LN[2].max_trg_alt = 3000
WS_9M117_launcher.LN[2].reactionTime = 2
WS_9M117_launcher.LN[2].type_ammunition={4,4,11,129}
WS_9M117_launcher.LN[2].ammunition_reserve = 8
WS_9M117_launcher.LN[2].sound = { single_shot = "MissileLaunch", }
WS_9M117_launcher.LN[2].sensor = {}
set_recursive_metatable(WS_9M117_launcher.LN[2].sensor, WSN_0)
WS_9M117_launcher.LN[2].PL = {}
WS_9M117_launcher.LN[2].PL[1] = {}
WS_9M117_launcher.LN[2].PL[1].shot_delay = 30
WS_9M117_launcher.LN[2].PL[1].ammo_capacity = 8
WS_9M117_launcher.LN[2].PL[1].reload_time = 3000
WS_9M117_launcher.LN[2].BR = { {pos = {3.7, 0, -0.11}, drawArgument = 5 } }

WS_9M311_launcher_k = {} -- Kortik
WS_9M311_launcher_k.LN = {}
WS_9M311_launcher_k.type = 4
WS_9M311_launcher_k.xc = -1.072
WS_9M311_launcher_k.distanceMin = 100
WS_9M311_launcher_k.distanceMax = 8000
WS_9M311_launcher_k.reactionTime = 2
WS_9M311_launcher_k.type_ammunition={4,4,34,90}
WS_9M311_launcher_k.ammunition_reserve = 8
WS_9M311_launcher_k.reflection_limit = 0.18
WS_9M311_launcher_k.sound = { single_shot = "MissileLaunch", }
WS_9M311_launcher_k.sensor = {}
set_recursive_metatable(WS_9M311_launcher_k.sensor, WSN_0)
WS_9M311_launcher_k.PL = {}
WS_9M311_launcher_k.PL[1] = {}
WS_9M311_launcher_k.PL[1].reload_time = 3600
WS_9M311_launcher_k.PL[1].ammo_capacity = 8
WS_9M311_launcher_k.PL[1].shot_delay = 1
WS_9M311_launcher_k.BR = { 
                       {connector_name = 'POINT_ROCKET_01',drawArgument = 4},
                       {connector_name = 'POINT_ROCKET_02',drawArgument = 5},
                       {connector_name = 'POINT_ROCKET_03',drawArgument = 6},
                       {connector_name = 'POINT_ROCKET_04',drawArgument = 7},
                       {connector_name = 'POINT_ROCKET_05',drawArgument = 18},
                       {connector_name = 'POINT_ROCKET_06',drawArgument = 19},
                     }

WS_9M311_launcher = {} -- Tunguska, Kashtan
WS_9M311_launcher.LN = {}
WS_9M311_launcher.LN[1] = {}
WS_9M311_launcher.LN[1].type = 4
WS_9M311_launcher.LN[1].xc = -1.072
WS_9M311_launcher.LN[1].distanceMin = 3000
WS_9M311_launcher.LN[1].distanceMax = 8000
WS_9M311_launcher.LN[1].reactionTime = 2
WS_9M311_launcher.LN[1].type_ammunition={4,4,34,90}
WS_9M311_launcher.LN[1].ammunition_reserve = 8
WS_9M311_launcher.LN[1].reflection_limit = 0.18
WS_9M311_launcher.LN[1].sound = { single_shot = "MissileLaunch", }
WS_9M311_launcher.LN[1].sensor = {}
set_recursive_metatable(WS_9M311_launcher.LN[1].sensor, WSN_0)
WS_9M311_launcher.LN[1].PL = {}
WS_9M311_launcher.LN[1].PL[1] = {}
WS_9M311_launcher.LN[1].PL[1].reload_time = 3600
WS_9M311_launcher.LN[1].PL[1].ammo_capacity = 8
WS_9M311_launcher.LN[1].PL[1].shot_delay = 1
WS_9M311_launcher.LN[1].BR = { 
                       {connector_name = 'POINT_ROCKET_01',drawArgument = 4},
                       {connector_name = 'POINT_ROCKET_02',drawArgument = 5},
                       {connector_name = 'POINT_ROCKET_03',drawArgument = 6},
                       {connector_name = 'POINT_ROCKET_04',drawArgument = 7},
                       {connector_name = 'POINT_ROCKET_05',drawArgument = 18},
                       {connector_name = 'POINT_ROCKET_06',drawArgument = 19},
                     }
                     
WS_9A310M1_launcher = {} -- BUK
WS_9A310M1_launcher.LN = {}
WS_9A310M1_launcher.LN[1] = {}
WS_9A310M1_launcher.LN[1].type = 4
WS_9A310M1_launcher.LN[1].xc = -3.26
WS_9A310M1_launcher.LN[1].distanceMin = 3000
WS_9A310M1_launcher.LN[1].distanceMax = 60000
WS_9A310M1_launcher.LN[1].reactionTime = 22
WS_9A310M1_launcher.LN[1].type_ammunition={4,4,34,87}
WS_9A310M1_launcher.LN[1].show_external_missile = true
WS_9A310M1_launcher.LN[1].ammunition_reserve = 4
WS_9A310M1_launcher.LN[1].sound = { single_shot = "MissileLaunch", }
WS_9A310M1_launcher.LN[1].sensor = {}
set_recursive_metatable(WS_9A310M1_launcher.LN[1].sensor, WSN_0)
WS_9A310M1_launcher.LN[1].PL = {}
WS_9A310M1_launcher.LN[1].PL[1] = {}
WS_9A310M1_launcher.LN[1].PL[1].ammo_capacity = 4
WS_9A310M1_launcher.LN[1].PL[1].reload_time = 1800
WS_9A310M1_launcher.LN[1].PL[1].shot_delay = 10
WS_9A310M1_launcher.LN[1].BR = {}
WS_9A310M1_launcher.LN[1].BR[1] = {pos = {-1.477, 0.459,-1.08}, drawArgument = 4}
WS_9A310M1_launcher.LN[1].BR[2] = {pos = {-1.477, 0.459,-0.38}, drawArgument = 5}
WS_9A310M1_launcher.LN[1].BR[3] = {pos = {-1.477, 0.459, 0.43}, drawArgument = 6}
WS_9A310M1_launcher.LN[1].BR[4] = {pos = {-1.477, 0.459, 1.15}, drawArgument = 7}

WS_9A35_launcher = {} -- Strela-10
WS_9A35_launcher.LN = {}
WS_9A35_launcher.LN[1] = {}
WS_9A35_launcher.LN[1].type = 4
WS_9A35_launcher.LN[1].distanceMin = 800
WS_9A35_launcher.LN[1].distanceMax = 5000
WS_9A35_launcher.LN[1].reactionTime = 8
WS_9A35_launcher.LN[1].type_ammunition={4,4,34,88}
WS_9A35_launcher.LN[1].ammunition_reserve = 4
WS_9A35_launcher.LN[1].reflection_limit = 0.18
WS_9A35_launcher.LN[1].sound = { single_shot = "MissileLaunch", }
WS_9A35_launcher.LN[1].sensor = {}
set_recursive_metatable(WS_9A35_launcher.LN[1].sensor, WSN_0)
WS_9A35_launcher.LN[1].PL = {}
WS_9A35_launcher.LN[1].PL[1] = {}
WS_9A35_launcher.LN[1].PL[1].ammo_capacity = 4
WS_9A35_launcher.LN[1].PL[1].reload_time = 3600
WS_9A35_launcher.LN[1].PL[1].shot_delay = 1

WS_9A330_launcher = {} -- Tor
WS_9A330_launcher.LN = {}
WS_9A330_launcher.LN[1] = {}
WS_9A330_launcher.LN[1].max_number_of_missiles_channels = 2
WS_9A330_launcher.LN[1].type = 4
WS_9A330_launcher.LN[1].distanceMin = 1500
WS_9A330_launcher.LN[1].distanceMax = 12000
WS_9A330_launcher.LN[1].reactionTime = 6
WS_9A330_launcher.LN[1].type_ammunition={4,4,34,89}
WS_9A330_launcher.LN[1].ammunition_reserve = 8
WS_9A330_launcher.LN[1].sound = { single_shot = "MissileLaunch", }
WS_9A330_launcher.LN[1].sensor = {}
set_recursive_metatable(WS_9A330_launcher.LN[1].sensor, WSN_0)
WS_9A330_launcher.LN[1].launch_delay = 1.5
WS_9A330_launcher.LN[1].PL = {}
WS_9A330_launcher.LN[1].PL[1] = {}
WS_9A330_launcher.LN[1].PL[1].ammo_capacity = 8
WS_9A330_launcher.LN[1].PL[1].reload_time = 3600
WS_9A330_launcher.LN[1].PL[1].shot_delay = 1

WS_9P31_launcher = {} -- Strela-1
WS_9P31_launcher.LN = {}
WS_9P31_launcher.LN[1] = {}
WS_9P31_launcher.LN[1].type = 4
WS_9P31_launcher.LN[1].distanceMin = 500
WS_9P31_launcher.LN[1].distanceMax = 4200
WS_9P31_launcher.LN[1].reactionTime = 8
WS_9P31_launcher.LN[1].type_ammunition={4,4,34,86}
WS_9P31_launcher.LN[1].ammunition_reserve = 4
WS_9P31_launcher.LN[1].reflection_limit = 0.18
WS_9P31_launcher.LN[1].sound = { single_shot = "MissileLaunch", }
WS_9P31_launcher.LN[1].sensor = {}
set_recursive_metatable(WS_9P31_launcher.LN[1].sensor, WSN_0)
WS_9P31_launcher.LN[1].PL = {}
WS_9P31_launcher.LN[1].PL[1] = {}
WS_9P31_launcher.LN[1].PL[1].ammo_capacity = 4
WS_9P31_launcher.LN[1].PL[1].reload_time = 3600
WS_9P31_launcher.LN[1].PL[1].shot_delay = 1
WS_9P31_launcher.LN[1].BR = {}
WS_9P31_launcher.LN[1].BR[1] = {connector_name = "POINT_ROCKET_01",drawArgument = 4}
WS_9P31_launcher.LN[1].BR[2] = {connector_name = "POINT_ROCKET_02",drawArgument = 5}
WS_9P31_launcher.LN[1].BR[3] = {connector_name = "POINT_ROCKET_03",drawArgument = 6}
WS_9P31_launcher.LN[1].BR[4] = {connector_name = "POINT_ROCKET_04",drawArgument = 7}

WS_9A33_launcher = {} -- Osa
WS_9A33_launcher.LN = {}
WS_9A33_launcher.LN[1] = {}
WS_9A33_launcher.LN[1].type = 4
WS_9A33_launcher.LN[1].distanceMin = 1500
WS_9A33_launcher.LN[1].distanceMax = 10000
WS_9A33_launcher.LN[1].reactionTime = 26
WS_9A33_launcher.LN[1].type_ammunition={4,4,34,85}
WS_9A33_launcher.LN[1].ammunition_reserve = 6
WS_9A33_launcher.LN[1].sound = { single_shot = "MissileLaunch", }
WS_9A33_launcher.LN[1].sensor = {}
set_recursive_metatable(WS_9A33_launcher.LN[1].sensor, WSN_0)
WS_9A33_launcher.LN[1].PL = {}
WS_9A33_launcher.LN[1].PL[1] = {}
WS_9A33_launcher.LN[1].PL[1].ammo_capacity = 6
WS_9A33_launcher.LN[1].PL[1].reload_time = 2400
WS_9A33_launcher.LN[1].PL[1].shot_delay = 6
WS_9A33_launcher.LN[1].BR = { 
                       {connector_name = 'POINT_ROCKET_01',drawArgument = 4},
                       {connector_name = 'POINT_ROCKET_02',drawArgument = 5},
                       {connector_name = 'POINT_ROCKET_03',drawArgument = 6},
                       {connector_name = 'POINT_ROCKET_04',drawArgument = 7},
                       {connector_name = 'POINT_ROCKET_05',drawArgument = 18},
                       {connector_name = 'POINT_ROCKET_06',drawArgument = 19},
                     }

WS_2P25_launcher = {} -- Kub
WS_2P25_launcher.LN = {}
WS_2P25_launcher.LN[1] = {}
WS_2P25_launcher.LN[1].type = 4
WS_2P25_launcher.LN[1].distanceMin = 4000
WS_2P25_launcher.LN[1].distanceMax = 43000
WS_2P25_launcher.LN[1].reactionTime = 10
WS_2P25_launcher.LN[1].type_ammunition={4,4,34,84}
WS_2P25_launcher.LN[1].show_external_missile = true
WS_2P25_launcher.LN[1].ammunition_reserve = 3
WS_2P25_launcher.LN[1].sound = { single_shot = "MissileLaunch", }
WS_2P25_launcher.LN[1].sensor = {}
set_recursive_metatable(WS_2P25_launcher.LN[1].sensor, WSN_0)
WS_2P25_launcher.LN[1].PL = {}
WS_2P25_launcher.LN[1].PL[1] = {}
WS_2P25_launcher.LN[1].PL[1].reload_time = 1200
WS_2P25_launcher.LN[1].PL[1].ammo_capacity = 3
WS_2P25_launcher.LN[1].PL[1].shot_delay = 6
WS_2P25_launcher.LN[1].BR = {{connector_name = 'POINT_KUB_1_1',drawArgument = 4},{connector_name = 'POINT_KUB_1_2',drawArgument = 5},{connector_name = 'POINT_KUB_1_3',drawArgument = 6},}

WS_M48_launcher = {} -- Chaparral
WS_M48_launcher.LN = {}
WS_M48_launcher.LN[1] = {}
WS_M48_launcher.LN[1].type = 4
WS_M48_launcher.LN[1].distanceMin = 10
WS_M48_launcher.LN[1].distanceMax = 5200
WS_M48_launcher.LN[1].reactionTime = 8
WS_M48_launcher.LN[1].type_ammunition={4,4,34,137}
WS_M48_launcher.LN[1].show_external_missile = true
WS_M48_launcher.LN[1].ammunition_reserve = 4
WS_M48_launcher.LN[1].sound = { single_shot = "MissileLaunch", }
WS_M48_launcher.LN[1].sensor = {}
set_recursive_metatable(WS_M48_launcher.LN[1].sensor, WSN_0)
WS_M48_launcher.LN[1].PL = {}
WS_M48_launcher.LN[1].PL[1] = {}
WS_M48_launcher.LN[1].PL[1].ammo_capacity = 4
WS_M48_launcher.LN[1].PL[1].shot_delay = 3
WS_M48_launcher.LN[1].PL[1].reload_time = 2000
WS_M48_launcher.LN[1].BR = { {connector_name = 'POINT_M48_1_1'}, {connector_name = 'POINT_M48_1_2'}, {connector_name = 'POINT_M48_1_3'}, {connector_name = 'POINT_M48_1_4'}, }

WS_M192_launcher = {} -- Hawk
WS_M192_launcher.LN = {}
WS_M192_launcher.LN[1] = {}
WS_M192_launcher.LN[1].type = 4
WS_M192_launcher.LN[1].xc = -0.529
WS_M192_launcher.LN[1].distanceMin = 1500
WS_M192_launcher.LN[1].distanceMax = 65000
WS_M192_launcher.LN[1].reactionTime = 22
WS_M192_launcher.LN[1].type_ammunition={4,4,34,98}
WS_M192_launcher.LN[1].show_external_missile = true
WS_M192_launcher.LN[1].ammunition_reserve = 3
WS_M192_launcher.LN[1].sound = { single_shot = "MissileLaunch", }
WS_M192_launcher.LN[1].sensor = {}
set_recursive_metatable(WS_M192_launcher.LN[1].sensor, WSN_0)
WS_M192_launcher.LN[1].PL = {}
WS_M192_launcher.LN[1].PL[1] = {}
WS_M192_launcher.LN[1].PL[1].reload_time = 1200
WS_M192_launcher.LN[1].PL[1].ammo_capacity = 3
WS_M192_launcher.LN[1].PL[1].shot_delay = 1
WS_M192_launcher.LN[1].BR = {{connector_name = 'POINT_HAWK_1_1',drawArgument = 4},{connector_name = 'POINT_HAWK_1_2',drawArgument = 5},{connector_name = 'POINT_HAWK_1_3',drawArgument = 6},}

WS_5P73_launcher = {} -- 5P73 beczl
WS_5P73_launcher.LN = {}
WS_5P73_launcher.LN[1] = {}
WS_5P73_launcher.LN[1].type = 4
WS_5P73_launcher.LN[1].xc = -0.529
WS_5P73_launcher.LN[1].distanceMin = 1500
WS_5P73_launcher.LN[1].distanceMax = 18000
WS_5P73_launcher.LN[1].reactionTime = 2
WS_5P73_launcher.LN[1].type_ammunition={4,4,34,97}
WS_5P73_launcher.LN[1].show_external_missile = true
WS_5P73_launcher.LN[1].ammunition_reserve = 4
WS_5P73_launcher.LN[1].sound = { single_shot = "MissileLaunch", }
WS_5P73_launcher.LN[1].sensor = {}
set_recursive_metatable(WS_5P73_launcher.LN[1].sensor, WSN_0)
WS_5P73_launcher.LN[1].PL = {}
WS_5P73_launcher.LN[1].PL[1] = {}
WS_5P73_launcher.LN[1].PL[1].reload_time = 1
WS_5P73_launcher.LN[1].PL[1].ammo_capacity = 4	
WS_5P73_launcher.LN[1].PL[1].shot_delay = 2400
WS_5P73_launcher.LN[1].BR = {{connector_name = 'POINT_ROCKET_01',drawArgument = 4},{connector_name = 'POINT_ROCKET_02',drawArgument = 5},{connector_name = 'POINT_ROCKET_03',drawArgument = 6},{connector_name = 'POINT_ROCKET_04',drawArgument = 7},}

WS_M901_launcher = {} -- Patriot
WS_M901_launcher.LN = {}
WS_M901_launcher.LN[1] = {}
WS_M901_launcher.LN[1].type = 4
WS_M901_launcher.LN[1].xc = -1.109
WS_M901_launcher.LN[1].distanceMin = 3000
WS_M901_launcher.LN[1].distanceMax = 125000
WS_M901_launcher.LN[1].reactionTime = 5
WS_M901_launcher.LN[1].type_ammunition={4,4,34,92}
WS_M901_launcher.LN[1].ammunition_reserve = 4
WS_M901_launcher.LN[1].launch_delay = 10
WS_M901_launcher.LN[1].sound = { single_shot = "MissileLaunch", }
WS_M901_launcher.LN[1].sensor = {}
set_recursive_metatable(WS_M901_launcher.LN[1].sensor, WSN_0)
WS_M901_launcher.LN[1].PL = {}
WS_M901_launcher.LN[1].PL[1] = {}
WS_M901_launcher.LN[1].PL[1].reload_time = 1800
WS_M901_launcher.LN[1].PL[1].ammo_capacity = 4
WS_M901_launcher.LN[1].PL[1].shot_delay = 10
WS_M901_launcher.LN[1].BR = {}
WS_M901_launcher.LN[1].BR[1] = {connector_name = 'POINT_PATRIOT_1_1', drawArgument = 4}
WS_M901_launcher.LN[1].BR[2] = {connector_name = 'POINT_PATRIOT_1_2', drawArgument = 5}
WS_M901_launcher.LN[1].BR[3] = {connector_name = 'POINT_PATRIOT_1_3', drawArgument = 6}
WS_M901_launcher.LN[1].BR[4] = {connector_name = 'POINT_PATRIOT_1_4', drawArgument = 7}

WS_roland_launcher = {} -- Roland ADS
WS_roland_launcher.LN = {}
WS_roland_launcher.LN[1] = {}
WS_roland_launcher.LN[1].type = 4
WS_roland_launcher.LN[1].xc = -3.255
WS_roland_launcher.LN[1].distanceMin = 1500
WS_roland_launcher.LN[1].distanceMax = 8000
WS_roland_launcher.LN[1].reactionTime = 8
WS_roland_launcher.LN[1].type_ammunition={4,4,34,99}
WS_roland_launcher.LN[1].ammunition_reserve = 8
WS_roland_launcher.LN[1].sound = { single_shot = "MissileLaunch", }
WS_roland_launcher.LN[1].sensor = {}
set_recursive_metatable(WS_roland_launcher.LN[1].sensor, WSN_0)
WS_roland_launcher.LN[1].PL = {}
WS_roland_launcher.LN[1].PL[1] = {}
WS_roland_launcher.LN[1].PL[1].reload_time = 10
WS_roland_launcher.LN[1].PL[1].ammo_capacity = 2
WS_roland_launcher.LN[1].PL[1].shot_delay = 3
WS_roland_launcher.LN[1].BR = { {connector_name = 'POINT_ROLAND_1_1', drawArgument = 4 }, { connector_name = 'POINT_ROLAND_1_2', drawArgument = 5}, }

WS_ship_klinok = {} -- SA-N-9 Guntlet (internal name "Kinshal", export name "Klinok"), navy analog of SAM TOR
WS_ship_klinok.reference_angle_Z = math.rad(90)
WS_ship_klinok.moveable = false
WS_ship_klinok.LN = {}
WS_ship_klinok.LN[1] = {}
WS_ship_klinok.LN[1].type = 4
WS_ship_klinok.LN[1].distanceMin = 1500
WS_ship_klinok.LN[1].distanceMax = 12000
WS_ship_klinok.LN[1].reactionTime = 6
WS_ship_klinok.LN[1].type_ammunition = {4,4,34,89}
WS_ship_klinok.LN[1].sensor = {}
WS_ship_klinok.LN[1].ammunition_reserve = 40
WS_ship_klinok.LN[1].sound = { single_shot = "MissileLaunch", }
WS_ship_klinok.LN[1].launch_delay = 3
set_recursive_metatable(WS_ship_klinok.LN[1].sensor, WSN_0)
WS_ship_klinok.LN[1].PL = {}
WS_ship_klinok.LN[1].PL[1] = {}
WS_ship_klinok.LN[1].PL[1].ammo_capacity = 8
WS_ship_klinok.LN[1].PL[1].reload_time = 120
WS_ship_klinok.LN[1].PL[1].shot_delay = 3
WS_ship_klinok.LN[1].major_weapon = true
WS_ship_klinok.LN[1].BR = { {pos = {0, 0, 0} } }
WS_ship_klinok.LN[1].max_number_of_missiles_channels = 2

WS_kortik = {} -- SA-N-11 Grisson (internal name "Kortik", export name "Kashtan"), Navy analog of SAM Tunguska
WS_kortik.type = 5
WS_kortik.maxRight = math.rad(-90)
WS_kortik.maxLeft = math.rad(90)
WS_kortik.maxBottom = -0.2
WS_kortik.maxTop = 1.5183
WS_kortik.omegaY = 1.0472
WS_kortik.omegaZ = 1.0472
WS_kortik.reference_angle_Z = 0
WS_kortik.reference_angle_Y = 0
WS_kortik.sound = { single_shot = "MissileLaunch", }
WS_kortik.LN = {}
WS_kortik.LN[1] = {}
set_recursive_metatable(WS_kortik.LN[1], WS_9M311_launcher_k)
WS_kortik.LN[1].BR = {{pos = {1.4, -0.2, 1.2}},{pos = {1.4, -0.2, -1.2}},}
WS_kortik.LN[2] = {}
set_recursive_metatable(WS_kortik.LN[2], WS_automatic_gun_6K30)

WS_seasparrow = {} -- RIM-7, Navy analog of AIM-7
WS_seasparrow.maxRight = -2.5708
WS_seasparrow.maxLeft = 2.5708
WS_seasparrow.maxBottom = -0.261799
WS_seasparrow.maxTop = 1.48353
WS_seasparrow.omegaY = 1
WS_seasparrow.omegaZ = 1
WS_seasparrow.distanceMin = 2000
WS_seasparrow.distanceMax = 15000
WS_seasparrow.reference_angle_Z = 0
WS_seasparrow.LN = {}
WS_seasparrow.LN[1] = {}
WS_seasparrow.LN[1].type = 4
WS_seasparrow.LN[1].reactionTime = 1
WS_seasparrow.LN[1].type_ammunition = {4,4,34,21}
WS_seasparrow.LN[1].sound = { single_shot = "MissileLaunch", }
WS_seasparrow.LN[1].sensor = {}
set_recursive_metatable(WS_seasparrow.LN[1].sensor, WSN_0)
WS_seasparrow.LN[1].PL = {}
WS_seasparrow.LN[1].PL[1] = {}
WS_seasparrow.LN[1].PL[1].ammo_capacity = 8
WS_seasparrow.LN[1].PL[1].shot_delay = 1
WS_seasparrow.LN[1].PL[1].reload_time = 1800
WS_seasparrow.LN[1].major_weapon = true
WS_seasparrow.LN[1].BR = { {pos = {0, 0, 0.9} }, {pos = {0, 0, -0.9} } }

WS_ship_rif = {} -- S-300 5V55 missile, SA-N-6 Grumble (internal name "Fort", export name "Rif")
WS_ship_rif.moveable = false
WS_ship_rif.reference_angle_Z = math.rad(90)
WS_ship_rif.LN = {}
WS_ship_rif.LN[1] = {}
WS_ship_rif.LN[1].type = 4
WS_ship_rif.LN[1].distanceMin = 5000
WS_ship_rif.LN[1].distanceMax = 75000
WS_ship_rif.LN[1].reactionTime = 10
WS_ship_rif.LN[1].type_ammunition = {4,4,34,80}
WS_ship_rif.LN[1].sound = { single_shot = "MissileLaunch", }
WS_ship_rif.LN[1].sensor = {}
set_recursive_metatable(WS_ship_rif.LN[1].sensor, WSN_0)
WS_ship_rif.LN[1].major_weapon = true
WS_ship_rif.LN[1].PL = {}
WS_ship_rif.LN[1].PL[1] = {}
WS_ship_rif.LN[1].PL[1].ammo_capacity = 5
WS_ship_rif.LN[1].PL[1].reload_time = 4
WS_ship_rif.LN[1].PL[1].shot_delay = 4
WS_ship_rif.LN[1].BR = { {pos = {0, 0, 0} } }

WS_ship_rifM = {} -- S-300PM 48N6E2 missile, SA-N-6 Grumble (internal name "Fort-M", export name "Rif-M")
WS_ship_rifM.moveable = false
WS_ship_rifM.reference_angle_Z = math.rad(90)
WS_ship_rifM.LN = {}
WS_ship_rifM.LN[1] = {}
WS_ship_rifM.LN[1].type = 4
WS_ship_rifM.LN[1].moveable = false
WS_ship_rifM.LN[1].distanceMin = 5000
WS_ship_rifM.LN[1].distanceMax = 90000
WS_ship_rifM.LN[1].reactionTime = 10
WS_ship_rifM.LN[1].type_ammunition = {4,4,34,81}
WS_ship_rifM.LN[1].sound = { single_shot = "MissileLaunch", }
WS_ship_rifM.LN[1].sensor = {}
set_recursive_metatable(WS_ship_rifM.LN[1].sensor, WSN_0)
WS_ship_rifM.LN[1].major_weapon = true
WS_ship_rifM.LN[1].PL = {}
WS_ship_rifM.LN[1].PL[1] = {}
WS_ship_rifM.LN[1].PL[1].ammo_capacity = 5
WS_ship_rifM.LN[1].PL[1].reload_time = 4000
WS_ship_rifM.LN[1].PL[1].shot_delay = 4
WS_ship_rifM.LN[1].BR = { {pos = {0, 0, 0} } }

WS_ship_granit = {} -- Granit 3M45 P-700, SS-N-19 Shipwreck 
WS_ship_granit.reference_angle_Z = 0.75
WS_ship_granit.moveable = false
WS_ship_granit.LN = {}
WS_ship_granit.LN[1] = {}
WS_ship_granit.LN[1].type = 1
WS_ship_granit.LN[1].distanceMin = 13000
WS_ship_granit.LN[1].distanceMax = 550000
WS_ship_granit.LN[1].reactionTime = 8
WS_ship_granit.LN[1].type_ammunition = {4,4,11,120}
WS_ship_granit.LN[1].sound = { single_shot = "MissileLaunch", }
WS_ship_granit.LN[1].sensor = {}
set_recursive_metatable(WS_ship_granit.LN[1].sensor, WSN_0)
WS_ship_granit.LN[1].PL = {}
WS_ship_granit.LN[1].PL[1] = {}
WS_ship_granit.LN[1].PL[1].ammo_capacity = 2
WS_ship_granit.LN[1].PL[1].reload_time = 3600
WS_ship_granit.LN[1].PL[1].shot_delay = 2
WS_ship_granit.LN[1].major_weapon = true
WS_ship_granit.LN[1].BR = { {pos = {0, 0, 0} } }

WS_ship_bazalt = {} -- Bazalt 4K80 P-500, ASM SS-N-12 Sandbox
WS_ship_bazalt.reference_angle_Z = math.rad(30)
WS_ship_bazalt.moveable = false
WS_ship_bazalt.LN = {}
WS_ship_bazalt.LN[1] = {}
WS_ship_bazalt.LN[1].type = 1
WS_ship_bazalt.LN[1].distanceMin = 13000
WS_ship_bazalt.LN[1].distanceMax = 555000
WS_ship_bazalt.LN[1].reactionTime = 8
WS_ship_bazalt.LN[1].type_ammunition = {4,4,11,119}
WS_ship_bazalt.LN[1].sound = { single_shot = "MissileLaunch", }
WS_ship_bazalt.LN[1].sensor = {}
set_recursive_metatable(WS_ship_bazalt.LN[1].sensor, WSN_0)
WS_ship_bazalt.LN[1].major_weapon = true
WS_ship_bazalt.LN[1].PL = {}
WS_ship_bazalt.LN[1].PL[1] = {}
WS_ship_bazalt.LN[1].PL[1].ammo_capacity = 2
WS_ship_bazalt.LN[1].PL[1].reload_time = 3600
WS_ship_bazalt.LN[1].PL[1].shot_delay = 2
WS_ship_bazalt.LN[1].BR = { {pos = {0, 0, 0} } }

WS_ship_OSA_M = {} -- 9M33, SA-N-4
WS_ship_OSA_M.maxBottom = -0.01
WS_ship_OSA_M.maxTop = 1.5708
WS_ship_OSA_M.omegaY = 1
WS_ship_OSA_M.omegaZ = 1
WS_ship_OSA_M.reference_angle_Z = 0
WS_ship_OSA_M.reference_angle_Y = 0
WS_ship_OSA_M.LN = {}
WS_ship_OSA_M.LN[1] = {}
WS_ship_OSA_M.LN[1].type = 4
WS_ship_OSA_M.LN[1].distanceMin = 1500
WS_ship_OSA_M.LN[1].distanceMax = 12000
WS_ship_OSA_M.LN[1].reactionTime = 8
WS_ship_OSA_M.LN[1].type_ammunition = {4,4,34,85}
WS_ship_OSA_M.LN[1].sound = { single_shot = "MissileLaunch", }
WS_ship_OSA_M.LN[1].sensor = {}
set_recursive_metatable(WS_ship_OSA_M.LN[1].sensor, WSN_0)
WS_ship_OSA_M.LN[1].show_external_missile = true
WS_ship_OSA_M.LN[1].PL = {}
WS_ship_OSA_M.LN[1].PL[1] = {}
WS_ship_OSA_M.LN[1].PL[1].ammo_capacity = 2
WS_ship_OSA_M.LN[1].PL[1].reload_time = 45
WS_ship_OSA_M.LN[1].PL[1].shot_delay = 12
WS_ship_OSA_M.LN[1].BR = { {pos = {0,0,0.3} }, {pos = {0,0,-0.3} }}

WS_ship_MK41_SM2 = {}
WS_ship_MK41_SM2.moveable = false
WS_ship_MK41_SM2.LN = {}
WS_ship_MK41_SM2.LN[1] = {}
WS_ship_MK41_SM2.LN[1].type = 4
WS_ship_MK41_SM2.LN[1].distanceMin = 4000
WS_ship_MK41_SM2.LN[1].distanceMax = 100000
WS_ship_MK41_SM2.LN[1].reactionTime = 8
WS_ship_MK41_SM2.LN[1].type_ammunition = {4,4,34,79}
WS_ship_MK41_SM2.LN[1].sound = { single_shot = "MissileLaunch", }
WS_ship_MK41_SM2.LN[1].sensor = {}
set_recursive_metatable(WS_ship_MK41_SM2.LN[1].sensor, WSN_0)
WS_ship_MK41_SM2.LN[1].PL = {}
WS_ship_MK41_SM2.LN[1].PL[1] = {}
WS_ship_MK41_SM2.LN[1].PL[1].ammo_capacity = 15
WS_ship_MK41_SM2.LN[1].PL[1].reload_time = 3600
WS_ship_MK41_SM2.LN[1].PL[1].shot_delay = 0.1
WS_ship_MK41_SM2.LN[1].BR = { {pos = {0, 0, 0} } }

WS_ship_HARPOON = {}
WS_ship_HARPOON.reference_angle_Z = 0.785398
WS_ship_HARPOON.moveable = false
WS_ship_HARPOON.LN = {}
WS_ship_HARPOON.LN[1] = {}
WS_ship_HARPOON.LN[1].type = 1
WS_ship_HARPOON.LN[1].distanceMin = 8000
WS_ship_HARPOON.LN[1].distanceMax = 95000
WS_ship_HARPOON.LN[1].reactionTime = 8
WS_ship_HARPOON.LN[1].type_ammunition = {4,4,11,126}
WS_ship_HARPOON.LN[1].sound = { single_shot = "MissileLaunch", }
WS_ship_HARPOON.LN[1].sensor = {}
set_recursive_metatable(WS_ship_HARPOON.LN[1].sensor, WSN_0)
WS_ship_HARPOON.LN[1].PL = {}
WS_ship_HARPOON.LN[1].PL[1] = {}
WS_ship_HARPOON.LN[1].PL[1].ammo_capacity = 1
WS_ship_HARPOON.LN[1].PL[1].reload_time = 3600
WS_ship_HARPOON.LN[1].PL[1].shot_delay = 2
WS_ship_HARPOON.LN[1].BR = { {pos = {0, 0, 0} } }

WS_ship_TOMAHAWK = {}
WS_ship_TOMAHAWK.reference_angle_Z = math.rad(90)
WS_ship_TOMAHAWK.moveable = false
WS_ship_TOMAHAWK.LN = {}
WS_ship_TOMAHAWK.LN[1] = {}
WS_ship_TOMAHAWK.LN[1].type = 8
WS_ship_TOMAHAWK.LN[1].distanceMin = 18000
WS_ship_TOMAHAWK.LN[1].distanceMax = 460000
WS_ship_TOMAHAWK.LN[1].reactionTime = 8
WS_ship_TOMAHAWK.LN[1].type_ammunition = {4,4,11,125}
WS_ship_TOMAHAWK.LN[1].major_weapon = true
WS_ship_TOMAHAWK.LN[1].sound = { single_shot = "MissileLaunch", }
WS_ship_TOMAHAWK.LN[1].sensor = {}
set_recursive_metatable(WS_ship_TOMAHAWK.LN[1].sensor, WSN_0)
WS_ship_TOMAHAWK.LN[1].PL = {}
WS_ship_TOMAHAWK.LN[1].PL[1] = {}
WS_ship_TOMAHAWK.LN[1].PL[1].ammo_capacity = 12
WS_ship_TOMAHAWK.LN[1].PL[1].reload_time = 200000
WS_ship_TOMAHAWK.LN[1].PL[1].shot_delay = 2
WS_ship_TOMAHAWK.LN[1].BR = { {pos = {2, 0, 0} } }

WS_ship_MOSKIT = {} -- 3M80 MOSKIT (SS-N-22 Sunburn ASM-MSS)
WS_ship_MOSKIT.reference_angle_Y = 0
WS_ship_MOSKIT.reference_angle_Z = 0.20944
WS_ship_MOSKIT.moveable = false
WS_ship_MOSKIT.LN = {}
WS_ship_MOSKIT.LN[1] = {}
WS_ship_MOSKIT.LN[1].type = 1
WS_ship_MOSKIT.LN[1].distanceMin = 5000
WS_ship_MOSKIT.LN[1].distanceMax = 120000
WS_ship_MOSKIT.LN[1].reactionTime = 8
WS_ship_MOSKIT.LN[1].type_ammunition = {4,4,11,56}
WS_ship_MOSKIT.LN[1].sound = { single_shot = "MissileLaunch", }
WS_ship_MOSKIT.LN[1].sensor = {}
set_recursive_metatable(WS_ship_MOSKIT.LN[1].sensor, WSN_0)
WS_ship_MOSKIT.LN[1].PL = {}
WS_ship_MOSKIT.LN[1].PL[1] = {}
WS_ship_MOSKIT.LN[1].PL[1].ammo_capacity = 2
WS_ship_MOSKIT.LN[1].PL[1].reload_time = 3600
WS_ship_MOSKIT.LN[1].PL[1].shot_delay = 2
WS_ship_MOSKIT.LN[1].BR = { {pos = {5, 0, 0} } }

WS_stinger = {}
WS_stinger.type = 4
WS_stinger.distanceMin = 200
WS_stinger.distanceMax = 4500
WS_stinger.reactionTime = 3
WS_stinger.type_ammunition={4,4,34,93}
WS_stinger.ammunition_reserve = 3
WS_stinger.reflection_limit = 0.18
WS_stinger.sound = { single_shot = "MissileLaunch", }
WS_stinger.sensor = {}
set_recursive_metatable(WS_stinger.sensor, WSN_0)
WS_stinger.PL = {}
WS_stinger.PL[1] = {}
WS_stinger.PL[1].reload_time = 6000
WS_stinger.PL[1].shoot_delay = 60
WS_stinger.PL[1].ammo_capacity = 3
WS_stinger.BR = { { pos = {1, 0, 0}, drawArgument = 4}, }

WS_stinger_manpad = {}
WS_stinger_manpad.sound = { single_shot = "MissileLaunch", }
WS_stinger_manpad.newZ = true
WS_stinger_manpad.pos = {-0.071, 1.623,0}
WS_stinger_manpad.maxBottom = -math.rad(45)
WS_stinger_manpad.maxTop = math.rad(45)
WS_stinger_manpad.drawArgument1 = 0
WS_stinger_manpad.drawArgument2 = 1
WS_stinger_manpad.omegaY = 0.5
WS_stinger_manpad.omegaZ = 0.5
WS_stinger_manpad.reference_angle_Z = 0
WS_stinger_manpad.reference_angle_Y = 0
WS_stinger_manpad.LN = {}
WS_stinger_manpad.LN[1] = {}
set_recursive_metatable(WS_stinger_manpad.LN[1], WS_stinger)

WS_igla = {}
WS_igla.sound = { single_shot = "MissileLaunch", }
WS_igla.type = 4
WS_igla.distanceMin = 500
WS_igla.distanceMax = 5200
WS_igla.reactionTime = 5
WS_igla.type_ammunition={4,4,34,91}
WS_igla.ammunition_reserve = 3
WS_igla.reflection_limit = 0.18
WS_igla.sensor = {}
set_recursive_metatable(WS_igla.sensor, WSN_0)
WS_igla.PL = {}
WS_igla.PL[1] = {}
WS_igla.PL[1].reload_time = 6000
WS_igla.PL[1].shoot_delay = 60
WS_igla.PL[1].ammo_capacity = 3
WS_igla.major_weapon = true
WS_igla.BR = { { pos = {1, 0, 0}, drawArgument = 4}, }

WS_igla_manpad = {}
WS_igla_manpad.sound = { single_shot = "MissileLaunch", }
WS_igla_manpad.newZ = true
WS_igla_manpad.pos = {-0.071, 1.623,0}
WS_igla_manpad.maxBottom = -math.rad(45)
WS_igla_manpad.maxTop = math.rad(45)
WS_igla_manpad.drawArgument1 = 0
WS_igla_manpad.drawArgument2 = 1
WS_igla_manpad.omegaY = 0.5
WS_igla_manpad.omegaZ = 0.5
WS_igla_manpad.reference_angle_Z = 0
WS_igla_manpad.reference_angle_Y = 0
WS_igla_manpad.LN = {}
WS_igla_manpad.LN[1] = {}
set_recursive_metatable(WS_igla_manpad.LN[1], WS_igla)

WS_igla_comm_manpad = {}
WS_igla_comm_manpad.sound = { single_shot = "MissileLaunch", }
WS_igla_comm_manpad.newZ = true
WS_igla_comm_manpad.pos = {-0.071, 1.623,0}
WS_igla_comm_manpad.maxBottom = -math.rad(45)
WS_igla_comm_manpad.maxTop = math.rad(45)
WS_igla_comm_manpad.drawArgument1 = 0
WS_igla_comm_manpad.drawArgument2 = 1
WS_igla_comm_manpad.omegaY = 2
WS_igla_comm_manpad.omegaZ = 2
WS_igla_comm_manpad.reference_angle_Z = 0
WS_igla_comm_manpad.reference_angle_Y = 0
WS_igla_comm_manpad.LN = {}
WS_igla_comm_manpad.LN[1] = {}
WS_igla_comm_manpad.LN[1].type = 101
WS_igla_comm_manpad.LN[1].xc = 0
WS_igla_comm_manpad.LN[1].distanceMin = 500
WS_igla_comm_manpad.LN[1].distanceMax = 5200
WS_igla_comm_manpad.LN[1].min_trg_alt = 10
WS_igla_comm_manpad.LN[1].max_trg_alt = 2500
WS_igla_comm_manpad.LN[1].reactionTime = 5
WS_igla_comm_manpad.LN[1].type_ammunition={4,4,34,91}
WS_igla_comm_manpad.LN[1].ammunition_reserve = 0
WS_igla_comm_manpad.LN[1].reflection_limit = 0.18

WS_stinger_comm_manpad = {}
WS_stinger_comm_manpad.sound = { single_shot = "MissileLaunch", }
WS_stinger_comm_manpad.newZ = true
WS_stinger_comm_manpad.pos = {-0.071, 1.623,0}
WS_stinger_comm_manpad.maxBottom = -math.rad(45)
WS_stinger_comm_manpad.maxTop = math.rad(45)
WS_stinger_comm_manpad.drawArgument1 = 0
WS_stinger_comm_manpad.drawArgument2 = 1
WS_stinger_comm_manpad.omegaY = 2
WS_stinger_comm_manpad.omegaZ = 2
WS_stinger_comm_manpad.reference_angle_Z = -math.rad(90) -- hand down
WS_stinger_comm_manpad.reference_angle_Y = 0
WS_stinger_comm_manpad.LN = {}
WS_stinger_comm_manpad.LN[1] = {}
WS_stinger_comm_manpad.LN[1].type = 101
WS_stinger_comm_manpad.LN[1].xc = 0
WS_stinger_comm_manpad.LN[1].distanceMin = 200
WS_stinger_comm_manpad.LN[1].distanceMax = 4500
WS_stinger_comm_manpad.LN[1].min_trg_alt = 10
WS_stinger_comm_manpad.LN[1].max_trg_alt = 3500
WS_stinger_comm_manpad.LN[1].reactionTime = 1
WS_stinger_comm_manpad.LN[1].type_ammunition={4,4,34,93}
WS_stinger_comm_manpad.LN[1].ammunition_reserve = 0
WS_stinger_comm_manpad.LN[1].reflection_limit = 0.18