local function task(name, id)
    return { WorldID =  id, Name = name };
end

local function gnd_cat(clsid, name)
    return { CLSID = clsid, Name = name };
end

local function fortification(clsid, name, displayName, shape, rate, seaObject)
    local res = {};
    
    res.CLSID = clsid;
    res.Name = name;
    res.DisplayName = displayName;
    res.ShapeName = shape;
    res.Rate = rate;
    res.SeaObject = seaObject; -- allows object to be placed only on water
    
    table.insert(db.Units.Fortifications.Fortification, res); 
end

local function ground_object(clsid, name, displayName, id)
    local res = {};
    res.CLSID = clsid;
    res.Name = name;
    res.DisplayName = displayName;
    res.WorldID = id;
    
    table.insert(db.Units.GroundObjects.GroundObject, res);
end


db.Units.Fortifications = {};
db.Units.Fortifications.Fortification = {};
db.Units.Fortifications.DefaultCategories = { gnd_cat("{7F1597F0-88EB-41cb-A04E-E9A4D5EF7466}", "Buildings") }
db.Units.Fortifications.DefaultTasks    = { task(_("Nothing"), "15") }
db.Units.Fortifications.Tasks           = { task(_("Nothing"), "15") }

db.Units.GroundObjects = {};
db.Units.GroundObjects.DefaultCategories = { gnd_cat("{AB46BAAE-F87E-40f9-A4F6-9F045251E14D}", "Ground Object") }
db.Units.GroundObjects.GroundObject = {};

ground_object("{CD1842EE-C112-4231-938B-D6B0920FBE8A}", "Building", _("Building"),  1);
ground_object("{B83CED40-F02C-47b5-A801-972AFA404BD1}", "Bridge", _("Bridge"),  2);
ground_object("{4D62E3AD-BCB6-490f-9716-1BA5AD0668AF}", "Transport", _("Transport"),  3);
ground_object("{79BA723F-319D-4dc8-94D6-17CA55F84001}", "Train", _("Train"),  4);

fortification("{71AC463C-310A-41ce-B7E7-923AC3CA5EDC}", ".Block", _(".Block"), "block", 100);
fortification("{B54053A8-B054-4a0b-871C-6DDA65ED90EF}", ".Block on road", _(".Block on road"), "block-onroad", 100);
fortification("{20A1B146-07C6-4ee6-851C-DBBC92135446}", ".Bunker", _(".Bunker"), "dot", 100);
fortification("{2848C193-6789-472c-8430-AF3D739BB6C8}", ".Pill-box", _(".Pill-box"), "dot2", 100);
fortification("{64DE4673-7D3E-424f-AB29-F4336AC38F98}", ".Command Center", _(".Command Center"), "ComCenter", 100);
fortification("{85D3DBF2-05DF-48e1-9C49-FD104E65A76E}", ".Ammunition depot", _(".Ammunition depot"), "SkladC", 100);
fortification("{7c822c60-9885-4a44-8add-b87511ff0fc5}", "Hangar A", _("Hangar A"), "angar_a", 100);
fortification("{f0f48213-396f-4cc2-9fec-2f308cb11154}", "Tank", _("Tank"), "bak", 100);
fortification("{b0e8ef18-c50c-4695-ac6e-1033b3691ce2}", "Tech hangar A", _("Tech hangar A"), "ceh_ang_a", 100);
fortification("{db4d86a5-f9d6-4db1-b6ff-72153d082fc8}", "Farm A", _("Farm A"), "ferma_a", 100);
fortification("{d406d212-8425-41be-83a1-502864f221dd}", "Farm B", _("Farm B"), "ferma_b", 100);
fortification("{e8f80c05-dd74-4ce4-a232-f29afa025c3b}", "Garage A", _("Garage A"), "garage_a", 100);
fortification("{c5f17833-f456-45be-8c7c-ab28996f0e85}", "Boiler-house A", _("Boiler-house A"), "kotelnaya_a", 100);
fortification("{65c10c17-e726-46d4-a380-db42706b923f}", "Restaurant 1", _("Restaurant 1"), "restoran1", 100);
fortification("{80af40db-22ac-4e42-ab24-a015d1a21311}", "Warehouse", _("Warehouse"), "sklad", 100);
fortification("{fe75a842-e794-4650-9197-22797513dc72}", "Comms tower M", _("Comms tower M"), "tele_bash_m", 100);
fortification("{70bf5fc8-441f-47cb-b587-d8f36ab81600}", "Cafe", _("Cafe"), "stolovaya", 100);
fortification("{bddc2805-fd70-47dd-90b0-0041ebd1eee3}", "Workshop A", _("Workshop A"), "tec_a", 100);
fortification("{7d0fa1db-38a1-4bf8-9169-943e11d49001}", "Electric power box", _("Electric power box"), "tr_budka", 100);
fortification("{d161a6b7-3946-49b2-af4c-aef104809480}", "Supermarket A", _("Supermarket A"), "uniwersam_a", 100);
fortification("{1a4b08df-98c6-45da-bfea-161d7ad0135f}", "Water tower A", _("Water tower A"), "wodokachka_a", 100);
fortification("{cc06c05a-da19-494c-8066-04bb6b2f375b}", "TV tower", _("TV tower"), "tele_bash", 100);
fortification("{2fe5cb79-1395-4b34-a112-913e964534e9}", "Shelter", _("Shelter"), "ukrytie", 100);
fortification("{56c3c279-31f6-4cb9-ba63-6025f14adb08}", "Repair workshop", _("Repair workshop"), "tech", 100);
fortification("{4d01350e-eac5-406a-8daf-a1e1cc74c03b}", "Railway station", _("Railway station"), "r_vok_sd", 100);
fortification("{557eab86-9e3d-459f-880b-3bfbd3b397fe}", "Railway crossing A", _("Railway crossing A"), "pereezd_big", 100);
fortification("{8ff4a140-121e-4b25-a7e1-72bf64a3645c}", "Railway crossing B", _("Railway crossing B"), "pereezd_small", 100);
fortification("{044858e2-4d40-4702-a185-70ee80f07151}", "WC", _("WC"), "WC", 100);
fortification("{72c629a7-112d-4a3e-9032-ba62dab2e36d}", "Small house 1A area", _("Small house 1A area"), "domik1a-all", 100);
fortification("{40cf54da-bdb2-4993-a619-f5504200c3f5}", "Small house 1A", _("Small house 1A"), "domik1a", 100);
fortification("{95dbcac0-35e6-4621-bb02-a500666e337e}", "Small house 1B area", _("Small house 1B area"), "domik1b-all", 100);
fortification("{8b22a3fd-8d96-4320-81b5-04f2c9edb247}", "Small house 1B", _("Small house 1B"), "domik1b", 100);
fortification("{7ae8526a-0edc-46ca-bf03-a1dc10445fcd}", "Small house 1C area", _("Small house 1C area"), "dom2c-all", 100);
fortification("{9f6a6842-f5a5-4953-871b-58e0a2278849}", "Small house 2C", _("Small house 2C"), "dom2c", 100);
fortification("{aa0f2150-ed5c-4b66-8c7a-39ab3bccf5e3}", "Shop", _("Shop"), "magazin", 100);
fortification("{0a4804d2-db83-4a18-bf2a-a253a9b17e33}", "Tech combine", _("Tech combine"), "kombinat", 100);
fortification("{264c3fb6-7871-471a-8915-a68afe98fbb5}", "Chemical tank A", _("Chemical tank A"), "him_bak_a", 100);
fortification("{2cca8015-d0a0-43f7-bc89-0bf1cf290246}", "Small werehouse 1", _("Small werehouse 1"), "s1", 100);
fortification("{14b9c61c-bf3a-4dff-939c-5f3d55351d4e}", "Small werehouse 2", _("Small werehouse 2"), "s2", 100);
fortification("{ffe9021e-7d44-4ab3-8df9-0696d2506148}", "Small werehouse 3", _("Small werehouse 3"), "s3", 100);
fortification("{4b6bcf8c-6e4c-485b-a8f3-ac4de3338b5f}", "Small werehouse 4", _("Small werehouse 4"), "s4", 100);
fortification("{e0b21ae2-029b-4c20-986c-9c469d69b2c8}", "Garage B", _("Garage B"), "garage_b", 100);
fortification("{70a0edf9-c9bd-42c8-b260-e97927ebaaaa}", "Garage small A", _("Garage small A"), "garagh-small-a", 100);
fortification("{e4322f04-ba0d-43db-afe9-16025738ebeb}", "Garage small B", _("Garage small B"), "garagh-small-b", 100);
fortification("{36ac22c8-9737-4bdc-b59e-fd0fb823daaa}", "Pump station", _("Pump station"), "nasos", 100);
fortification("{7d517890-d7ea-4ede-9c73-5be252b96d3f}", "Oil derrick", _("Oil derrick"), "neftevyshka", 100);
fortification("{d4fd6053-a036-4adf-8395-beca84e9efbb}", "Container red 1", _("Container red 1"), "konteiner_red1", 100);
fortification("{edd392fd-f262-4609-84d3-c09f126478ee}", "Container red 2", _("Container red 2"), "konteiner_red2", 100);
fortification("{dc005e97-7820-4cce-bc0e-edd875baaf92}", "Container red 3", _("Container red 3"), "konteiner_red3", 100);
fortification("{662e6cea-5a59-473f-87e9-e34d01f1ddb7}", "Container white", _("Container white"), "konteiner_white", 100);
fortification("{d55f444b-745a-4954-bd4c-0ea1781f67a7}", "Container brown", _("Container brown"), "konteiner_brown", 100);
fortification("{7f3722ae-10bc-49c5-a3cc-68ab89878c5b}", "Barracks 1", _("Barracks 1"), "kazarma1", 100);
fortification("{eb3bac2d-4c24-4ff8-8c8a-dcd3d0c98750}", "Barracks 2", _("Barracks 2"), "kazarma2", 100);
fortification("{a056cc08-9b50-45b1-b798-e0eb4277ea86}", "Military staff", _("Military staff"), "aviashtab", 100);
fortification("{2b1802df-c4f9-404f-afe1-5f291ef68d30}", "Watchtower", _("Watchtower"), "ohr-vyshka", 100);
fortification("{e9e4e232-b0c8-4306-b013-2f9defbb04d1}", "Hangar B", _("Hangar B"), "angar_b", 100);
fortification("{07a6695a-2373-489f-a0a0-e1e35dd03b85}", "Fuel tank", _("Fuel tank"), "toplivo-bak", 100);
fortification("{25f698c7-ee7b-40be-bafb-d97e64c487f3}", "Shelter B", _("Shelter B"), "ukrytie_b", 100);
fortification("{e0f6d8f9-0692-4695-933b-6e87636c7acb}", "Oil platform", _("Oil platform"), "plavbaza", 100, true);
fortification("{6d518ff5-cfca-4a7c-921b-ee3621a4207d}", "Subsidiary structure 1", _("Subsidiary structure 1"), "hozdomik1", 100);
fortification("{47a39247-7989-4f6d-bbb8-2cdd40e012dd}", "Subsidiary structure 2", _("Subsidiary structure 2"), "hozdomik2", 100);
fortification("{e58952f4-d2e9-43bc-a5ea-854d4678ef96}", "Subsidiary structure 3", _("Subsidiary structure 3"), "hozdomik3", 100);
fortification("{394ff644-013b-4f88-bfe1-1277cbcba8cc}", "Subsidiary structure A", _("Subsidiary structure A"), "saray-a", 100);
fortification("{c724c713-61ad-4fb0-807d-dc6eb4a89884}", "Subsidiary structure B", _("Subsidiary structure B"), "saray-b", 100);
fortification("{162b2803-ddf1-4b0e-9b95-b45b2f35ee30}", "Subsidiary structure C", _("Subsidiary structure C"), "saray-c", 100);
fortification("{9cbba4f7-7014-4f67-b69a-4a458e5f2420}", "Subsidiary structure D", _("Subsidiary structure D"), "saray-d", 100);
fortification("{dbb8c3f5-f1ea-42e1-b486-482ef41a4e53}", "Subsidiary structure E", _("Subsidiary structure E"), "saray-e", 100);
fortification("{74e14790-da2b-4269-bd94-0bfa2dee0031}", "Subsidiary structure F", _("Subsidiary structure F"), "saray-f", 100);
fortification("{96fc5825-e329-468d-83d8-fc9326d8aa52}", "Subsidiary structure G", _("Subsidiary structure G"), "saray-g", 100);
fortification("{30D37BB2-F438-45ae-B09D-F00B1EFCB790}", "Landmine", _("Landmine"), "landmine", 1);
fortification("{7c9d05ea-0b54-4d5c-9d6f-fa2cde39e349}", "FARP Ammo Dump Coating", _("FARP Ammo Dump Coating"), "SetkaKP", 50);
fortification("{80c39fb0-854f-461b-bc4b-b2b51d0c4139}", "FARP Tent", _("FARP Tent"), "PalatkaB", 50);
fortification("{a947d0fd-9268-4851-a885-cb59aebe9bbc}", "FARP CP Blindage", _("FARP CP Blindage"), "kp_ug", 100);
fortification("{3441baf3-7ff7-4d76-ab9e-77f768b7813f}", "FARP Fuel Depot", _("FARP Fuel Depot"), "GSM Rus", 20);
fortification("{7e58d67d-191e-4e2c-ad22-a9c50cd48f53}", "GeneratorF", _("GeneratorF"), "GeneratorF", 100);
fortification("{1BB4FECD-0BF0-4070-BB58-1EB6C7D1766B}", "S-125 Site", _("S-125 Site"), "S-125_base", 100); --beczl
fortification("{A65C983E-3615-4350-93B2-128CBA8B3569}", "Coach a tank", _("Coach a tank"), "wagon-cisterna",100);
fortification("{066A8FCF-6591-457C-888A-AF443AF95084}", "Coach cargo", _("Coach cargo"), "wagon-gruz",100);
fortification("{AA5E677A-BE23-4752-8C1A-24E25EC148CC}", "Coach cargo open", _("Coach cargo open"), "wagon-gruz-otkr",100);
fortification("{77348759-616D-4500-9AB8-701D9F8028CD}", "Coach a platform", _("Coach a platform"), "wagon-platforma",100);
fortification("{8B096AEA-9E18-4541-8120-0DAB3BC57170}", "Coach a passenger", _("Coach a passenger"), "wagon-pass",100);
fortification("{5D159ABA-28C6-4E6A-BD41-B295AFA4E108}", "Electric locomotive",_("Electric locomotive"),"elektrowoz",100);
fortification("{79BEF6B1-03EE-40A5-9D67-FE369D67D8F3}", "Locomotive", _("Locomotive"), "teplowoz",100);
