db = db or {}

troopsPath = db_path.. 'troops/BS/'
if __LOP__ == true then 
    troopsPath = db_path.. 'troops/LOP/'
end;

function troop(name, nativeName, picture)
    local res = {};
    res.name = name;
    res.nativeName = nativeName;
    res.picture = picture;
    return res;
end;


-- TODO: remove oldId after all data in old format will be converted
-- to new format
local function country(clsid, name, oldId, shortname, flag, id, units, callsigns, ranks, awards, troops, rect)
  local res = {};
  
  res.CLSID = clsid;
  res.Name = name;
  res.OldID = oldId;
  res.ShortName = shortname;
  res.flag = flag;
  res.WorldID = id;
  res.Units = units;
  res.CallNames = callsigns;
  res.Ranks = ranks or {};
  res.Awards = awards or {};
  res.rect = rect;
  
  res.rank_by_name = {}; 
  res.award_by_name = {};
  res.troop_by_name = {};
  
    for i = 1, #res.Awards do
        res.Awards[i].picture = oldId .. '/awards/' .. res.Awards[i].picture;
        res.Awards[i].countryID = id;
        res.award_by_name[res.Awards[i].name] = res.Awards[i];
    end;

    for i = 1, #res.Ranks do
        res.Ranks[i].stripes = oldId .. '/stripes.png';
        res.rank_by_name[res.Ranks[i].nativeName] = res.Ranks[i];
    end;


    --res.Troops = troops or {};
    local path = troopsPath .. troops
    local f, err = loadfile(path)
    if f then
        local env = {troop = troop, _ = _}
        setfenv(f, env);
        f();
        --print('troops for', name, 'loaded from', path )
        res.Troops = env.troops;
    else
		res.Troops = {}
        print('error loading troops', err)
    end;
    for i = 1, #res.Troops do
        res.Troops[i].picture = oldId .. '/troops/' .. res.Troops[i].picture;
        res.troop_by_name[res.Troops[i].name] = res.Troops[i];
    end;
  
  table.insert(db.Countries, res);
end

local function cnt_unit(clsid, name, color_schemes)
  local res = { CLSID = clsid, Name = name, ColorSchemes = color_schemes };
  
  return res;
end

local function color_scheme(clsid, name)
  local res = {};
  res.CLSID = clsid;
  res.Name = name;
  
  return res;
end

local function callsign(index, clsid, name)
  local res = {};
  res.CLSID = clsid;
  res.Index = name;
  res.ID =  index;
  
  return res;
end

local function rank(name, nativeName, threshold, pictureRect) 
    local res = {};
    res.name = name;
    res.nativeName = nativeName;
    res.threshold = threshold;
    res.pictureRect = pictureRect;
    return res;
end;

local function award(name, nativeName, threshold, picture)
    local res = {};
    res.name = name;
    res.nativeName = nativeName;
    res.threshold = threshold;
    res.picture = picture;
    return res;
end;

db.Countries = {};

country("{B2A43A73-E650-49B0-98B9-F67A53DA95FD}", _("Russia"), "Russia", "RUS", "Russia.png", 0,
  {
    Planes =
    {
      CATID = "{C168A850-3C0B-436a-95B5-C4A015552560}",
      Plane =
      {
        cnt_unit("{35ED40B9-C66A-4A80-AC29-04B041552520}", "Su-33", {
          color_scheme("{46d8da77-fda0-4b3e-903a-af4369c02df9}", "279th KIAP 1st squad NAVY"),
          color_scheme("{d71c7b23-5c93-449d-9b06-ca14870aa09d}", "279th KIAP 2nd squad NAVY"),
          color_scheme("{192e27c7-94a4-4fea-b659-ff9ae5f63bf4}", "Standart-1 NAVY"),
          color_scheme("{6c04e62d-36e6-42e9-ae76-b0e600c1ef65}", "Standart-2 NAVY"),
          color_scheme("{aa9b5600-d317-4cae-b8b1-f9eee779f77b}", "T-10K-1 test paint scheme"),
          color_scheme("{5de1a3de-4380-45cf-893c-d568350211d6}", "T-10K-2 test paint scheme"),
        }),
        cnt_unit("{CC4276EE-EDB4-4EC0-BE13-4313ABDC7619}", "Su-25", {
          color_scheme("{a414cf0a-8aa3-4727-bb07-5f48b63accc2}", "Field Camo Scheme #1 (native)"),
          color_scheme("{fd4ac256-9a56-4340-b163-5d93b76be457}", "Forest Camo Scheme #1 (native)"),
          color_scheme("{f317e120-00d5-4795-b7dc-a9ec8b74469a}", "Field Camo Scheme #2 (native). 960th ShAP."),
          color_scheme("{57332dae-ec8b-41ae-a2c6-a3800746744b}", "Field Camo Scheme #3 (worn-out). 960th ShAP."),
        }),
        cnt_unit("{3B301281-F94A-11d5-9190-00A0249B6F00}", "MiG-29S", {
          color_scheme("{7e303d17-2a72-440a-a3bb-7a152c5968dc}", "73th Guards Regiment, Merzeburg AB (GDR)"),
          color_scheme("{3015445a-32bc-4b73-ac1d-827cc0f380bd}", "1038th Guards C&amp;CTC, Mary AB"),
          color_scheme("{ab13058d-c24b-4922-9c86-9ab5e4b63727}", "115th Guards Regiment, Termez AB"),
          color_scheme("{67db1c28-9247-409c-92e9-90d64aa38684}", "120th Guards Regiment, Domna AB"),
          color_scheme("{51bb45a2-3039-47d9-b8a0-2b1431097650}", "733th Guards Regiment, Damgarten AB (GDR)"),
          color_scheme("{75b6f15c-7c72-4a46-9560-31951e25cd1b}", "4th C&amp;CTC Lypetsk AB"),
          color_scheme("{7433b9fa-acb0-4e6c-9c3a-d14b21fb09d7}", "2nd FS, \"Swifts\" Team, Kubinka AB"),
        }),
        cnt_unit("{6BCCD081-F937-11d5-9190-00A0249B6F00}", "MiG-29A", {
          color_scheme("{2196f6e8-9800-4274-bcde-38611b0e9263}", "AF Standart-1"),
          color_scheme("{29353c69-93f3-4352-9607-088d84652095}", "AF Standart-2"),
          color_scheme("{fd246c9f-287e-4b02-a0cf-7736c2884bcb}", "968th IAP Altenburg AB (Germany)"),
          color_scheme("{392966ae-dc75-4188-b256-8abb74f27a7a}", "33th IAP Wittstock AB (Germany):"),
          color_scheme("{dc402ddf-2685-4ba0-8d0b-c0edbf142c24}", "120 GvIAP #45 Domna AB"),
          color_scheme("{188954f8-83c4-432b-9f26-cc86ed0d5f4f}", "\"Swifts\" Team #44 Kubinka AB"),
          color_scheme("{535cc955-3c4f-4ae2-9ab3-27f3e80b4987}", "Demo paint scheme #999 MAPO"),
        }),
        cnt_unit("{6FFE10D7-723E-46B0-AB8F-71B8B3D7572B}", "Su-27", {
          color_scheme("{36525adb-82b7-4496-bfb2-4d7d6de8eaee}", "AF Standart early"),
          color_scheme("{9e859598-2757-47ee-9e9e-04456515bfed}", "AF Standart early (worn-out)"),
          color_scheme("{0d17a49c-eb74-465a-839c-b339e6a9531f}", "AF Standart last (worn-out)"),
          color_scheme("{59e13a03-a383-4029-b165-d1cc721e4a44}", "AF 4th C&amp;CTC Lypetsk AB-1"),
          color_scheme("{79b72f73-025e-4b9c-8e56-c9f6fccd23a3}", "AF 4th C&amp;CTC Lypetsk AB-2"),
          color_scheme("{02e0644d-482d-4781-8dc5-73670b6425b3}", "ADF 148th C&amp;CTC Savasleyka AB-1"),
          color_scheme("{54289d36-e123-4130-81f4-b7fb36eb72c6}", "\"Russian Knights\" Team #05"),
          color_scheme("{98bad3e0-15fd-4979-a939-b011f89b5890}", "\"Test-Pilots\" Team #595"),
          color_scheme("{ff706014-624d-48e2-9420-d5c7fb4d5999}", "\"Test-Pilots\" Team #598"),
        }),
        cnt_unit("{734008AD-266A-4932-B6F6-CB243AD4EE38}", "Su-25TM", {
          color_scheme("{cab4d49f-f345-430a-bff5-c05ff4a10031}", "Su-25TM test scheme"),
        }),
        cnt_unit("{31E68806-0891-4e12-9573-D1CFEA8C96F8}", "Su-25T", {
          color_scheme("{9F46E21D-88F0-41b3-B7CF-0D825D9A4A6B}", "AF Standard 1"),
          color_scheme("{3ADBD83A-1CAB-4d06-B455-C80945EE1BBC}", "AF Standard 2"),
          color_scheme("{D3ABB834-B47A-4327-BD24-DF44A128B10D}", "Su-25T test scheme"),
		  color_scheme("{23167d50-d6d8-11de-8a39-0800200c9a66}", "Fictional Black"),
		  color_scheme("{89a73a30-196a-11df-8a39-0800200c9a66}", "Fictional NAVY"),
		  color_scheme("{906462d0-196a-11df-8a39-0800200c9a66}", "Fictional 4CCTC"),
		  color_scheme("{9813b3a0-196a-11df-8a39-0800200c9a66}", "Fictional T8M"),
		  color_scheme("{9d2e9df0-196a-11df-8a39-0800200c9a66}", "Fictional winter digital camo"),
		  color_scheme("{a42414a0-196a-11df-8a39-0800200c9a66}", "Fictional summer digital camo"),
		  color_scheme("{aaaf57d0-196a-11df-8a39-0800200c9a66}", "Fictional 4CCTC 2"),
		  color_scheme("{df34f8b0-196b-11df-8a39-0800200c9a66}", "Fictional 4CCTC 3"),
		  color_scheme("{e3dc39a0-196b-11df-8a39-0800200c9a66}", "Fictional Lida AFB"),
        }),
        cnt_unit("{43CC7267-6C0A-41B2-BCF7-CE8FA05E9E35}", "MiG-31", {
          color_scheme("{67470817-0609-4DEC-A8DD-DF1773F883A3}", "AF Standart"),
        }),
        cnt_unit("{AD3E0C2E-2992-4E03-B884-E45B6F0000A7}", "MiG-27K", {
          color_scheme("{9156ABCD-9314-426D-B004-7FB7D3E290BB}", "AF Standart"),
        }),
        cnt_unit("{983788D2-EB64-4D8E-A921-9FA30122B4B0}", "Su-30", {
          color_scheme("{f6039928-792d-4eae-8dce-a1d976c6c505}", "AF Standard early"),
          color_scheme("{85e3ac0b-e49d-4136-9888-c0dbc28a5c26}", "AF Standard last"),
          color_scheme("{6510946e-cd7a-4a48-abfc-724d46003743}", "AF Standard early (worn-out)"),
          color_scheme("{54940291-e464-4aa8-bc32-7d6e34a0a49d}", "AF Standard last (worn-out)"),
          color_scheme("{3a1a0b64-977e-4a19-a420-bf4f479a2cd2}", "ADF 148th C&amp;CTC Savasleyka AB"),
          color_scheme("{7519785a-21ae-4b1f-9e0b-384609e00a2c}", "AF Standard"),
          color_scheme("{a1324049-fc92-4304-8442-242ae6b3a4e3}", "\"Desert\" test paint scheme"),
          color_scheme("{7b231b34-e5d7-48d3-bc34-f6190eaad7d6}", "\"Snow\" test paint scheme"),
          color_scheme("{c2b5c655-73d8-467a-88f0-abae729a0b3f}", "\"Russian Knights\" Team #25"),
          color_scheme("{b992f54b-9366-4410-8a5c-2c448f9ab670}", "\"Test-Pilots\" Team #597"),
        }),
        cnt_unit("{12F005C2-F9F1-4BD7-ADA0-AF169A7D8D78}", "Tu-160", {
          color_scheme("{FC853FD4-F2FE-4328-9498-7CE054338D1D}", "AF Standart"),
        }),
        cnt_unit("{87E4C74D-1081-4B6E-A558-27EDB7A81546}", "Su-34", {
          color_scheme("{2C42F824-0C17-4CC1-9875-D438A560F622}", "AF Standart"),
          color_scheme("{916e8437-4fed-414c-ba47-1891623ba84d}", "AF Standart 2"),
        }),
        cnt_unit("{96710CAD-AA85-40EB-9BAC-CE307CE6C158}", "Tu-95MS", {
          color_scheme("{C294E610-F64C-4EE0-8C5A-DE8FA235CF22}", "AF Standart"),
        }),
        cnt_unit("{DCAA178F-3BB0-4F80-8DBA-BF4B256AC4BF}", "Tu-142", {
          color_scheme("{498149B0-6A87-473A-A7C5-E7E66BEB0E0A}", "AF Standart"),
        }),
        cnt_unit("{1E65CF49-44A6-4C91-8F43-209869A5B3A7}", "MiG-25PD", {
          color_scheme("{BE2E9D8C-A708-485B-8231-E172D46014FE}", "AF Standart"),
        }),
        cnt_unit("{C17483D6-2911-408C-B57B-1839E4CD0528}", "Tu-22M3", {
          color_scheme("{413F9CBF-C3A7-4E9B-A111-A3AFAE15306B}", "AF Standart"),
        }),
        cnt_unit("{CA17F0F8-6AEB-43FA-BC90-76732137F61D}", "A-50", {
          color_scheme("{FF7486C5-D360-445E-8234-5E1C76CF31E8}", "AF Standard"),
        }),
        cnt_unit("{{7061418E-5D0E-4b49-915D-ACEF1F2E6855}}", "Yak-40", {
          color_scheme("{{D4664874-8CD5-4dee-877A-543D305123F5}}", "AF Standart"),  
        }),
        cnt_unit("{A5B4B173-F4C1-4331-9AB2-1ACDE185008F}", "An-26B", {
          color_scheme("{3FCBFB57-DD04-4F58-8CBC-3AF4E8C3E1AC}", "AF Standart"),
        }),
        cnt_unit("{DFBDA1AB-0456-4AE8-A24C-EE2A0362D06E}", "An-30M", {
          color_scheme("{F0A26F8F-0DD8-42B5-A8A0-BD78F0B32C1E}", "AF Standart"),
        }),
        cnt_unit("{2BAFF3D1-6A2C-4654-92A9-99D3BC501A4E}", "Su-17M4", {
          color_scheme("{a84c6cc0-1871-43f5-ab04-9a4307d8c98d}", "AF Standart"),
          color_scheme("{1eff7cb6-2e55-48bc-821d-14d1eb635480}", "AF Standart (worn-out)"),
        }),
        cnt_unit("{A00E562B-1DC8-4671-9EBF-C1CDC2506AE7}", "MiG-23MLD", {
          color_scheme("{564E8CDA-5C46-455A-8A27-4BF0EAC591CA}", "AF Standart"),
          color_scheme("{4d7e9231-30bd-42d3-a06f-a34130f2a6bf}", "AF Standart-1"),
          color_scheme("{cca1969c-c53c-47c3-a71f-54ac0d19eb19}", "AF Standart-2"),
          color_scheme("{fd569ddb-135a-4469-9cbc-f8ba945295b4}", "AF Standart-3 (worn-out)"),
        }),
        cnt_unit("{FB7FDABF-24F4-4311-AD7A-331CB382E9FA}", "MiG-25RBT", {
          color_scheme("{9DB9237E-0D8C-457C-89E9-D353700B96D4}", "AF Standart"),
        }),
        cnt_unit("{C3A1469C-E835-4ADF-924C-A5F3D8AEC550}", "Su-24M", {
          color_scheme("{14A6595A-6605-48DC-98BD-6F91423C60EE}", "AF Standart"),
        }),
        cnt_unit("{0282A9C1-0B38-11d6-9193-00A0249B6F00}", "Su-24MR", {
          color_scheme("{BBC88536-2767-4071-A7FA-B4B890CA72D8}", "AF Standart"),
        }),
        cnt_unit("{E8506C78-7BCD-4FA7-9163-354FE3297DCA}", "IL-78M", {
          color_scheme("{8B1CD99D-A246-40A0-98B3-AF360F896E19}", "AF Standart-1"),
          color_scheme("{93240945-FE43-4b47-AE79-54607F0E66C0}", "AF Standart-2"),
        }),
        cnt_unit("{439A1A0C-1A35-4B45-A0ED-2F2A0B0E8F31}", "IL-76MD", {
          color_scheme("{2CDD2752-627F-4B01-A306-C77147C3A2B0}", "AF Standart-1"),
          color_scheme("{93240945-FE43-4b47-AE79-54607F0E66C0}", "AF Standart-2"),
        }),
      },
    },
    Heliports =
    {
      CATID = "{E6490BAB-7129-4d23-9023-1CFE810886EF}",
      Heliport =
      {
        cnt_unit("{24FC9197-F225-4f2a-8A31-BD51DC7BDAB6}", "FARP"),
      },
    },
    Ships =
    {
      CATID = "{AAFD44F1-C080-4572-9465-3A52C46F2A45}",
      Ship =
      {
        cnt_unit("{25554ABC-3877-46D5-A1D2-E82878FBBBFB}", "KUZNECOW"),
        cnt_unit("{5723F0F5-08EB-41DE-9CBB-7DCA54521D79}", "MOSCOW"),
        cnt_unit("{396EBD9D-3230-45B5-B7E4-C360E26CAEF9}", "PIOTR"),
        cnt_unit("{63CAFD18-C960-476B-BE9D-865C53A88146}", "ELNYA"),
        cnt_unit("{5CB43DA6-B4C1-498F-BB60-0EF0BA6D6BE7}", "ALBATROS"),
        cnt_unit("{7705E299-53DF-405F-95E5-C39B33DA5AAE}", "REZKY"),
        cnt_unit("{C8459CF8-BD2E-4595-9C92-6625C0B8794E}", "MOLNIYA"),
        cnt_unit("{CC2B663E-1F4A-4726-AB60-98E660C154E1}", "KILO"),
        cnt_unit("{9C52FE18-DC5D-4674-A446-25F067E126F7}", "SOM"),
        cnt_unit("{843E23DF-8A61-40DD-8E33-41B1AEA7CF18}", "ZWEZDNY"),
        cnt_unit("{06B97F7F-8CBA-429C-9CCF-376B80A8DD31}", "NEUSTRASH"),
        cnt_unit("{AD0D2B7F-EBB4-4415-AC14-B4D117D514D5}", "Dry-cargo ship-1"),
        cnt_unit("{21B074E6-780D-4ba5-963E-94D5C8436A4E}", "Dry-cargo ship-2"),
        cnt_unit("{6449989a-2f92-48ed-89bf-d0ae87176cb3}", "speedboat"),
      },
    },
    Cars =
    {
      CATID = "{6CAE2420-8E36-40f3-8586-E853AADB9199}",
      Car =
      {
        cnt_unit("{10C3BD0E-4494-4bc4-BC37-2C544E33ADC7}", "BTR-80"),
        cnt_unit("{F16F5FBF-D121-47EC-9BFA-8140F30C8664}", "1L13 EWR"),
        cnt_unit("{EDEA0ECC-33A4-488B-8A3C-1D6929B5A871}", "55G6 EWR"),
        cnt_unit("{0626F96A-FDFB-42D3-ADE5-A0415690BF5E}", "S-300PS 40B6M tr"),
        cnt_unit("{414E9DC1-B881-44C3-8141-049DD59B2A69}", "S-300PS 40B6MD sr"),
        cnt_unit("{3F127663-E479-4B8D-855B-7C4F6E9310EA}", "S-300PS 64H6E sr"),
        cnt_unit("{ABB2373A-4A0C-479B-A810-A075C4346644}", "S-300PS 5P85C ln"),
        cnt_unit("{4351D9C0-EDE5-4574-9789-75227A3C9873}", "S-300PS 5P85D ln"),
        cnt_unit("{AC6EAFDF-396C-4E27-8FED-BBB9B2868F2B}", "SA-11 Buk SR 9S18M1"),
        cnt_unit("{3EE3346E-9E4D-49FA-89CD-61D0151B3DB7}", "SA-11 Buk LN 9A310M1"),
		cnt_unit("{AE03B512-4198-4ae0-90D6-8921597BFEB8}", "SA-3 S-125 LN"), -- beczl
        cnt_unit("{8CA1B264-74D2-4353-94FA-995F888D6C70}", "SA-3 SNR-125 TR"), -- beczl
		cnt_unit("{0A988814-8015-4d7a-906A-0BC419EF0DBC}", "SA-3 P-19 SR"), -- beczl
		cnt_unit("{3EB2AF54-2728-4aa3-AE22-9218EC787104}", "ZiL-131 PR-14AM"), --beczl
        cnt_unit("{6FBA140B-C916-460D-97AF-0921E25D71D3}", "Kub 1S91 str"),
        cnt_unit("{E553DB76-0817-4CE1-A97B-ABF2F7A38772}", "Kub 2P25 ln"),
        cnt_unit("{8E5B2FB3-8845-4026-BC7F-16898FF9442B}", "Osa 9A33 ln"),
        cnt_unit("{5C486AED-5DCE-4A0A-AF88-7343D3B2B43E}", "Strela-1 9P31"),
        cnt_unit("{DD80908D-C289-4AFA-A25E-A6697EC65FDE}", "Strela-10M3"),
        cnt_unit("{C422DA78-1BC6-4FD7-BA48-CAE7674AA3A8}", "Dog Ear radar"),
        cnt_unit("{C206BC9A-F3B1-496C-AB9B-3E3A9B95DBED}", "Tor 9A331"),
        cnt_unit("{08353DA0-2367-42CB-8F46-20A9E4787441}", "2S6 Tunguska"),
        cnt_unit("{28704245-E952-427A-9C57-B2A6E0AB1E66}", "ZSU-23-4 Shilka"),
        cnt_unit("{80530579-B527-4A29-B1B6-1B0BDD4C8D86}", "SAU Msta"),
        cnt_unit("{83485D57-2B11-4A83-9A7E-5FD47E9ADCEC}", "SAU Akatsia"),
        cnt_unit("{099A1146-4309-459F-A913-AAA515D70049}", "SAU 2-C9"),
        cnt_unit("{A97C0647-83EB-4B15-8B5B-BD2F8842DF91}", "ATMZ-5"),
        cnt_unit("{C0A5AA21-5A93-4707-9A9F-2AE24C4A22B0}", "ATZ-10"),
        cnt_unit("{A326AD1A-4820-4A5A-989D-5F3CCC174FCA}", "BMD-1"),
        cnt_unit("{A90A4A5B-5AF8-49CF-B363-BB81EF4A9256}", "BMP-1"),
        cnt_unit("{EBF0085E-E84E-401B-9F66-9C2B2BC7D214}", "BMP-2"),
        cnt_unit("{B33FB5B1-ABF0-48E6-A06B-6886A0132786}", "BRDM-2"),
        cnt_unit("{37DBF2AA-30C8-4FFA-A63A-D760623FF4E0}", "Grad-URAL"),
        cnt_unit("{BF8A33C7-95E1-4B1E-B3DF-5DA8C455ACE4}", "Smerch"),
        cnt_unit("{E2D06D03-13F6-4E5F-8A28-549D4CF30D9F}", "T-80UD"),
        cnt_unit("{1D6C2705-575C-4F35-A670-328ECBA007A3}", "UAZ-469"),
        cnt_unit("{85DF753A-0ECA-4143-88F8-5A46DEAB53C2}", "Ural-375"),
        cnt_unit("{20B6EAF4-E6D3-4FC2-A306-41951CAF1361}", "Ural-375 PBU"),
        cnt_unit("{4FC31476-127F-4608-876E-5D9B482F7E17}", "IKARUS Bus"),
        cnt_unit("{647DDAAC-CFB5-40AD-8394-042840EC4A6D}", "VAZ Car"),
        cnt_unit("{988392FB-77C0-461A-A738-DBEA8AB83030}", "Trolley bus"),
        cnt_unit("{254D09EB-5591-4D42-B513-3A15B9965B63}", "KAMAZ Truck"),
        cnt_unit("{D75AF34A-25E9-4BDE-A57A-E179AF185F2D}", "LAZ Bus"),
        cnt_unit("{7126EBF1-BC0E-450D-9C61-92B8B5310385}", "SAU Gvozdika"),
        cnt_unit("{616C3D4B-37BA-47EA-BC78-EBDDF62C086E}", "BMP-3"),
        cnt_unit("{5231B5F9-15E5-4B6C-8B22-374CEEC378BE}", "BTR_D"),
        cnt_unit("{1C4F9C25-EDBD-429e-B95A-083ABFE82B95}", "S-300PS 54K6 cp"),
        cnt_unit("{672D3629-C30C-4ba5-A54D-68728E8C35E5}", "GAZ-3307"),
        cnt_unit("{4CC190E5-CC9B-4c66-8071-C5A807B8DBB9}", "GAZ-66"),
        cnt_unit("{DFABA701-5202-4d78-91FF-EAE6525099EC}", "GAZ-3308"),
        cnt_unit("{9A2584F4-2FEE-4f3c-A47F-35D97995FCE1}", "MAZ-6303"),
        cnt_unit("{4C763AC0-89AC-43a8-88D1-8FB710F42603}", "ZIL-4331"),
        cnt_unit("{693BB858-F64A-4af0-B4EF-0BE24B8406A6}", "SKP-11"),
        cnt_unit("{B1BD673F-11B7-4a0c-8719-A81D06DD2E34}", "Ural-4320T"),
        cnt_unit("{D61DB6DA-E56D-4439-88A0-37F8615A44C2}", "Ural-4320-31"),
        cnt_unit("{E8DC1D50-7463-4dfa-86D7-2F81C1214D06}", "Ural ATsP-6"),
        cnt_unit("{A207B91F-77F0-4647-8D74-88A9D3851EAD}", "ZiL-131 APA-80"),
        cnt_unit("{4D98849E-2A76-4017-9356-B9852B39EBA6}", "ZIL-131 KUNG"),
        cnt_unit("{82DAF699-2456-43F7-811D-76B922288915}", "Ural-375 APA-50"),
        cnt_unit("{B76231A9-4B8A-41e0-8EAD-65785077FC0C}", "ZU-23 Emplacement"),
        cnt_unit("{773F294C-4057-4789-892C-643BE8619778}", "ZU-23 Emplacement Closed"),
        cnt_unit("{96E2A468-E0D6-4e7f-A618-7C29E4DAD176}", "Ural-375 ZU-23"),
        cnt_unit("{B00A39DC-A02C-41ec-A041-51163608CB9C}", "MTLB"),
        cnt_unit("{40B742B7-3683-4fe5-A72A-A4E7E428159F}", "T-72B"),
        cnt_unit("{277D9D98-C741-4e14-8B07-F7966C490284}", "SA-18 Igla-S manpad"),
        cnt_unit("{44232141-5D7E-4c29-9425-5970278183B9}", "SA-18 Igla-S comm"),
        cnt_unit("{64066D8C-3785-4baf-A347-C585FE29746E}", "T-55"),
        cnt_unit("{3FED785C-D336-45bb-82AF-BB02F8F5F394}", "Paratrooper RPG-16"),
        cnt_unit("{4EF38747-79E3-4b61-8D80-FA4BE43382E2}", "Paratrooper AKS-74"),

        cnt_unit("{0ECCCF2B-61D9-462a-A38A-5BBFA917F37F}", "Boman"),
        cnt_unit("{1e92e0f5-c183-4bc5-a4dd-2a437eff526b}", "Sandbox"),
        cnt_unit("{2dde8bcd-759c-4347-a4e3-eeec6c2c40a4}", "Bunker"),
      },
    },
    Helicopters =
    {
      CATID = "{828CEADE-3F1D-40aa-93CE-8CDB73FE2710}",
      Helicopter =
      {
        cnt_unit("{3457BB1E-523F-4C24-BBEA-58D028623F05}", "Ka-50", {
          color_scheme("{060AFECF-BFBD-44c5-9C47-D9B5EF35D104}", "Standard"),
          color_scheme("{CC7B095B-038D-432e-B8D2-AE1F9A9F0E3A}", "Standard (faded)"),
          color_scheme("{3E5CA0B0-C1CA-4b55-87BC-B230371124DA}", "Demo paint scheme #024"),
          color_scheme("{B72394A9-596C-433B-9F1F-742F67B1BCC1}", "Demo paint scheme # 22  \"Black Shark\""),
          color_scheme("{AC7E6F33-30A3-4560-B80A-5509BDF89BBE}", "Demo paint scheme \"Werewolf\""),
          color_scheme("{84E30899-5D49-4bdd-96F1-B0FA6AC9B2B6}", "Fictional Snow Splatter scheme"),
          color_scheme("{19822419-B967-43fd-AD73-FC6E1E82E32C}", "Fictional Swedish scheme"),
          color_scheme("{E293EDA2-B401-4045-88B6-22F400879492}", "Fictional Olive Grey scheme"),
          color_scheme("{BFE322AC-E7C7-11DC-934E-78D056D89593}", "Fictional Desert2 scheme"),
          color_scheme("{DC56EAAA-7BD0-4269-8754-CF1BBE42CC99}", "Fictional Tropic Green scheme"),
          color_scheme("{bc52bd10-d046-11dd-ad8b-0800200c9a66}", "New Year 2009"),
          color_scheme("{c73a5580-d046-11dd-ad8b-0800200c9a66}", "New Year"),
          color_scheme("{1210e020-dcda-11dd-ad8b-0800200c9a66}", "DOSAAF"),
          color_scheme("{99e9c790-2132-11de-8c30-0800200c9a66}", "Worn Black"),
          
        }),
        cnt_unit("{0903DF50-B9FA-441E-B94D-8F03DFF3E40D}", "Mi-24V", {
          color_scheme("{75E7691D-19E1-40B4-8123-FB8FBD1CC621}", "Standard 1"),
          color_scheme("{50E6FD2D-2B85-48f1-8B66-064CD20D2E77}", "Standard 2 (faded and sun-bleached)"),
        }),
        cnt_unit("{C08CF845-F905-40F0-AF1B-554908BBE89E}", "Mi-8MT", {
          color_scheme("{E5D21F6F-54F5-43A7-90F8-F5A03315A934}", "Standart"),
          color_scheme("{CB825521-4034-4b46-A6A2-47B532BB5884}", "Standart1"),
          color_scheme("{5B02BC84-3BEC-4f7f-843F-162C7CADF027}", "Standart2"),
        }),
        cnt_unit("{FDE4A6C5-A26E-402D-87EF-FF6892D8FDB3}", "Mi-26", {
          color_scheme("{D714F983-DAD5-4A36-AE0C-B6B052DC4203}", "Standart"),
          color_scheme("{D90FF99C-F293-4935-8665-8334E14B6066}", ""),
          color_scheme("{2B92F1DE-36C1-4686-9EF6-D3C6C5DEA8C2}", ""),
        }),
        cnt_unit("{809119BE-03A0-4B85-9134-900DF0591FC3}", "Ka-27", {
          color_scheme("{D2AE1B1B-6619-4196-AE8C-988C6F71BE8E}", "Standard"),
        }),
        cnt_unit("{450335F5-0F8A-4d71-A880-1B76B3C89B1A}", "Ka-27", {
          color_scheme("{CC6CE0F3-4A2D-4d19-8F54-DC36EA2F8356}", "Standard"),
          color_scheme("{ACD3C57F-6E2B-4b5f-A4AF-656EC1F7FB87}", "Night"),
        }),
      },
    },
    Fortifications =
    {
      CATID = "{7F1597F0-88EB-41cb-A04E-E9A4D5EF7466}",
      Fortification =
      {
        cnt_unit("{79BEF6B1-03EE-40A5-9D67-FE369D67D8F3}", "Locomotive"),
        cnt_unit("{5D159ABA-28C6-4E6A-BD41-B295AFA4E108}", "Electric locomotive"),
        cnt_unit("{A65C983E-3615-4350-93B2-128CBA8B3569}", "Coach a tank"),
        cnt_unit("{066A8FCF-6591-457C-888A-AF443AF95084}", "Coach cargo"),
        cnt_unit("{AA5E677A-BE23-4752-8C1A-24E25EC148CC}", "Coach cargo open"),
        cnt_unit("{77348759-616D-4500-9AB8-701D9F8028CD}", "Coach a platform"),
        cnt_unit("{8B096AEA-9E18-4541-8120-0DAB3BC57170}", "Coach a passenger"),
        cnt_unit("{71AC463C-310A-41ce-B7E7-923AC3CA5EDC}", ".Block"),
        cnt_unit("{B54053A8-B054-4a0b-871C-6DDA65ED90EF}", ".Block on road"),
        cnt_unit("{20A1B146-07C6-4ee6-851C-DBBC92135446}", ".Bunker"),
        cnt_unit("{2848C193-6789-472c-8430-AF3D739BB6C8}", ".Pill-box"),
        cnt_unit("{64DE4673-7D3E-424f-AB29-F4336AC38F98}", ".Command Center"),
        cnt_unit("{85D3DBF2-05DF-48e1-9C49-FD104E65A76E}", ".Ammunition depot"),
        cnt_unit("{7c822c60-9885-4a44-8add-b87511ff0fc5}", "Hangar A"),
        cnt_unit("{f0f48213-396f-4cc2-9fec-2f308cb11154}", "Tank"),
        cnt_unit("{b0e8ef18-c50c-4695-ac6e-1033b3691ce2}", "Tech hangar A"),
        cnt_unit("{db4d86a5-f9d6-4db1-b6ff-72153d082fc8}", "Farm A"),
        cnt_unit("{d406d212-8425-41be-83a1-502864f221dd}", "Farm B"),
        cnt_unit("{e8f80c05-dd74-4ce4-a232-f29afa025c3b}", "Garage A"),
        cnt_unit("{c5f17833-f456-45be-8c7c-ab28996f0e85}", "Boiler-house A"),
        cnt_unit("{65c10c17-e726-46d4-a380-db42706b923f}", "Restaurant 1"),
        cnt_unit("{80af40db-22ac-4e42-ab24-a015d1a21311}", "Warehouse"),
        cnt_unit("{fe75a842-e794-4650-9197-22797513dc72}", "Comms tower M"),
        cnt_unit("{70bf5fc8-441f-47cb-b587-d8f36ab81600}", "Cafe"),
        cnt_unit("{bddc2805-fd70-47dd-90b0-0041ebd1eee3}", "Workshop A"),
        cnt_unit("{7d0fa1db-38a1-4bf8-9169-943e11d49001}", "Electric power box"),
        cnt_unit("{d161a6b7-3946-49b2-af4c-aef104809480}", "Supermarket A"),
        cnt_unit("{1a4b08df-98c6-45da-bfea-161d7ad0135f}", "Water tower A"),
        cnt_unit("{cc06c05a-da19-494c-8066-04bb6b2f375b}", "TV tower"),
        cnt_unit("{2fe5cb79-1395-4b34-a112-913e964534e9}", "Shelter"),
        cnt_unit("{56c3c279-31f6-4cb9-ba63-6025f14adb08}", "Repair workshop"),
        cnt_unit("{4d01350e-eac5-406a-8daf-a1e1cc74c03b}", "Railway station"),
        cnt_unit("{557eab86-9e3d-459f-880b-3bfbd3b397fe}", "Railway crossing A"),
        cnt_unit("{8ff4a140-121e-4b25-a7e1-72bf64a3645c}", "Railway crossing B"),
        cnt_unit("{044858e2-4d40-4702-a185-70ee80f07151}", "WC"),
        cnt_unit("{72c629a7-112d-4a3e-9032-ba62dab2e36d}", "Small house 1A area"),
        cnt_unit("{40cf54da-bdb2-4993-a619-f5504200c3f5}", "Small house 1A"),
        cnt_unit("{95dbcac0-35e6-4621-bb02-a500666e337e}", "Small house 1B area"),
        cnt_unit("{8b22a3fd-8d96-4320-81b5-04f2c9edb247}", "Small house 1B"),
        cnt_unit("{7ae8526a-0edc-46ca-bf03-a1dc10445fcd}", "Small house 1C area"),
        cnt_unit("{9f6a6842-f5a5-4953-871b-58e0a2278849}", "Small house 2C"),
        cnt_unit("{aa0f2150-ed5c-4b66-8c7a-39ab3bccf5e3}", "Shop"),
        cnt_unit("{0a4804d2-db83-4a18-bf2a-a253a9b17e33}", "Tech combine"),
        cnt_unit("{264c3fb6-7871-471a-8915-a68afe98fbb5}", "Chemical tank A"),
        cnt_unit("{2cca8015-d0a0-43f7-bc89-0bf1cf290246}", "Small werehouse 1"),
        cnt_unit("{14b9c61c-bf3a-4dff-939c-5f3d55351d4e}", "Small werehouse 2"),
        cnt_unit("{ffe9021e-7d44-4ab3-8df9-0696d2506148}", "Small werehouse 3"),
        cnt_unit("{4b6bcf8c-6e4c-485b-a8f3-ac4de3338b5f}", "Small werehouse 4"),
        cnt_unit("{e0b21ae2-029b-4c20-986c-9c469d69b2c8}", "Garage B"),
        cnt_unit("{70a0edf9-c9bd-42c8-b260-e97927ebaaaa}", "Garage small A"),
        cnt_unit("{e4322f04-ba0d-43db-afe9-16025738ebeb}", "Garage small B"),
        cnt_unit("{36ac22c8-9737-4bdc-b59e-fd0fb823daaa}", "Pump station"),
        cnt_unit("{7d517890-d7ea-4ede-9c73-5be252b96d3f}", "Oil derrick"),
        cnt_unit("{d4fd6053-a036-4adf-8395-beca84e9efbb}", "Container red 1"),
        cnt_unit("{edd392fd-f262-4609-84d3-c09f126478ee}", "Container red 2"),
        cnt_unit("{dc005e97-7820-4cce-bc0e-edd875baaf92}", "Container red 3"),
        cnt_unit("{662e6cea-5a59-473f-87e9-e34d01f1ddb7}", "Container white"),
        cnt_unit("{d55f444b-745a-4954-bd4c-0ea1781f67a7}", "Container brown"),
        cnt_unit("{7f3722ae-10bc-49c5-a3cc-68ab89878c5b}", "Barracks 1"),
        cnt_unit("{eb3bac2d-4c24-4ff8-8c8a-dcd3d0c98750}", "Barracks 2"),
        cnt_unit("{a056cc08-9b50-45b1-b798-e0eb4277ea86}", "Military staff"),
        cnt_unit("{2b1802df-c4f9-404f-afe1-5f291ef68d30}", "Watchtower"),
        cnt_unit("{e9e4e232-b0c8-4306-b013-2f9defbb04d1}", "Hangar B"),
        cnt_unit("{07a6695a-2373-489f-a0a0-e1e35dd03b85}", "Fuel tank"),
        cnt_unit("{25f698c7-ee7b-40be-bafb-d97e64c487f3}", "Shelter B"),
        cnt_unit("{e0f6d8f9-0692-4695-933b-6e87636c7acb}", "Oil platform"),
        cnt_unit("{6d518ff5-cfca-4a7c-921b-ee3621a4207d}", "Subsidiary structure 1"),
        cnt_unit("{47a39247-7989-4f6d-bbb8-2cdd40e012dd}", "Subsidiary structure 2"),
        cnt_unit("{e58952f4-d2e9-43bc-a5ea-854d4678ef96}", "Subsidiary structure 3"),
        cnt_unit("{394ff644-013b-4f88-bfe1-1277cbcba8cc}", "Subsidiary structure A"),
        cnt_unit("{c724c713-61ad-4fb0-807d-dc6eb4a89884}", "Subsidiary structure B"),
        cnt_unit("{162b2803-ddf1-4b0e-9b95-b45b2f35ee30}", "Subsidiary structure C"),
        cnt_unit("{9cbba4f7-7014-4f67-b69a-4a458e5f2420}", "Subsidiary structure D"),
        cnt_unit("{dbb8c3f5-f1ea-42e1-b486-482ef41a4e53}", "Subsidiary structure E"),
        cnt_unit("{74e14790-da2b-4269-bd94-0bfa2dee0031}", "Subsidiary structure F"),
        cnt_unit("{96fc5825-e329-468d-83d8-fc9326d8aa52}", "Subsidiary structure G"),
        cnt_unit("{30D37BB2-F438-45ae-B09D-F00B1EFCB790}", "Landmine"),
        cnt_unit("{7c9d05ea-0b54-4d5c-9d6f-fa2cde39e349}", "FARP Ammo Dump Coating"),
        cnt_unit("{80c39fb0-854f-461b-bc4b-b2b51d0c4139}", "FARP Tent"),
        cnt_unit("{a947d0fd-9268-4851-a885-cb59aebe9bbc}", "FARP CP Blindage"),
        cnt_unit("{3441baf3-7ff7-4d76-ab9e-77f768b7813f}", "FARP Fuel Depot"),
        cnt_unit("{7e58d67d-191e-4e2c-ad22-a9c50cd48f53}", "GeneratorF"),
		cnt_unit("{1BB4FECD-0BF0-4070-BB58-1EB6C7D1766B}", "S-125 Site"), --beczl
      },
    },
  },
  {
    callsign(1, "{63F96C45-0053-4b82-91A3-484E101297C7}", "0"),
    callsign(2, "{99614DB6-5B25-465e-87BC-528CFB253784}", "1"),
    callsign(3, "{AC5C879B-E065-40fe-B160-0CDAE7FC011D}", "2"),
    callsign(4, "{99420485-7146-4286-9CB4-B6E362A13F8B}", "3"),
    callsign(5, "{A72AF054-195F-431c-978D-B519ACAFD997}", "4"),
    callsign(6, "{B2B919BB-55E4-4731-8AC1-CFDB14341407}", "5"),
    callsign(7, "{7FCB6479-44DB-42c2-9EC4-9F7197A06F79}", "6"),
    callsign(8, "{1C2F8D53-DDD8-41d8-A871-A7BAF1E957F5}", "7"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Courage Order', _('Courage Order'), 200, 'RUS-01-CourageOrder.png'),
    award('Medal of Courage',_('Medal of Courage'), 600, 'RUS-02-MeritMedal.png'),
    award('Nesterov Medal',_('Nesterov Medal'), 1000, 'RUS-03-NesterovMedal.png'),
    award('Military Serve Order',_('Military Serve Order'), 1400, 'RUS-04-MilitaryServe.png'),
    award('Georgy Cross-IV',_('Georgy Cross-IV'), 1800, 'RUS-05-GeorgyCross-4.png'),
    award('Medal For Merit To Fatherland-II with swords',_('Medal For Merit To Fatherland-II with swords'), 2200, 'RUS-06-ForMeritToFatherland-2.png'),
    award('Georgy Cross-I',_('Georgy Cross-I'), 2600, 'RUS-07-GeorgyCross-1.png'),
    award('Hero Gold Star',_('Hero Gold Star'), 3000, 'RUS-08-HeroStar.png'),
  },
  'Russia.lua',
  {0,0,64,30}
);

country("{30E7A2EB-360F-4FEF-8075-7ACB771234DC}", _("Ukraine"), "Ukraine", "UKR", "Ukraine.png", 1,
  {
    Planes =
    {
      CATID = "{C168A850-3C0B-436a-95B5-C4A015552560}",
      Plane =
      {
        cnt_unit("{6FFE10D7-723E-46B0-AB8F-71B8B3D7572B}", "Su-27", {
          color_scheme("{a6e07cee-1fe8-49ab-90d9-e21d5cb78667}", "AF Standart last"),
          color_scheme("{69897050-cc3e-4587-9cbc-53e01fe4578e}", "831th GvIAP Mirgorod AB"),
          color_scheme("{7858c43b-366c-4425-bac0-152d71705939}", "AF Standart last (worn-out)"),
          color_scheme("{3d6e09c8-b32f-4956-8e2b-5f46bfceecc1}", "AF Standart early (worn-out)"),
          color_scheme("{fcf26dfb-dffc-49a7-9aa4-db3f0b0685a9}", "Mirgorod AB Aerobatics #57"),
        }),
        cnt_unit("{6BCCD081-F937-11d5-9190-00A0249B6F00}", "MiG-29A", {
          color_scheme("{c0647fdc-34d6-468b-89ae-a15ed291008c}", "AF Standart-1"),
          color_scheme("{639dae0b-a29e-454c-a1a3-a3bd57e5ae15}", "AF Standart-2"),
          color_scheme("{d8a00e29-7163-42de-8686-8c38247a182a}", "40th FW \"Maestro\" Vasilkov AB"),
        }),
        cnt_unit("{3B301281-F94A-11d5-9190-00A0249B6F00}", "MiG-29S", {
          color_scheme("{37c77cde-8901-430e-8ff3-5fca693320b1}", "14th army, Vinnitsa AB"),
          color_scheme("{88ab1171-ba31-45b8-b4c1-89102ab090d7}", "\"Ukrainian Falcons\" paint scheme"),
          color_scheme("{5aa3b4e9-5a58-45a4-9b32-7af955dcbbd2}", "9th FW Belbek AB"),
        }),
        cnt_unit("{2BAFF3D1-6A2C-4654-92A9-99D3BC501A4E}", "Su-17M4", {
          color_scheme("{99a4fff2-ac69-4901-8950-41eedf294895}", "AF Standart"),
          color_scheme("{16f4ed76-21a7-4482-befc-f248773cc062}", "AF Standart (worn-out)"),
          color_scheme("{86093b14-9c4b-4f35-96e5-9bc15d515cbf}", "ShAP Limanskoye AB"),
        }),
        cnt_unit("{96710CAD-AA85-40EB-9BAC-CE307CE6C158}", "Tu-95MS", {
          color_scheme("{C294E610-F64C-4EE0-8C5A-DE8FA235CF22}", "AF Standart"),
        }),
        cnt_unit("{C3A1469C-E835-4ADF-924C-A5F3D8AEC550}", "Su-24M", {
          color_scheme("{14A6595A-6605-48DC-98BD-6F91423C60EE}", "AF Standart"),
        }),
        cnt_unit("{0282A9C1-0B38-11d6-9193-00A0249B6F00}", "Su-24MR", {
          color_scheme("{BBC88536-2767-4071-A7FA-B4B890CA72D8}", "AF Standart"),
        }),
        cnt_unit("{CC4276EE-EDB4-4EC0-BE13-4313ABDC7619}", "Su-25", {
          color_scheme("{7a82a124-3e31-472a-893d-5753d04621cf}", "Petal Camo Scheme #1 (native). 299th Brigade."),
          color_scheme("{9ea8271b-f0c6-440c-b6d3-c1bdc946128c}", "Petal Camo Scheme #1 (worn-out). 299th Brigade."),
          color_scheme("{bd456602-5fcf-4bd6-ab0e-e4d4b71700a1}", "Petal Camo Scheme #2 (native). 299th Brigade."),
          color_scheme("{26313b3c-b922-4fb0-a871-5071c183baf6}", "Broken Camo Scheme #1 (native). 299th OShAP."),
          color_scheme("{4DFB357F-103D-40ef-8D21-F3E85534D779}", "Broken Camo Scheme #2 (native). 452th ShAP."),
        }),
        cnt_unit("{1E65CF49-44A6-4C91-8F43-209869A5B3A7}", "MiG-25PD", {
          color_scheme("{BE2E9D8C-A708-485B-8231-E172D46014FE}", "AF Standart"),
        }),
        cnt_unit("{A5B4B173-F4C1-4331-9AB2-1ACDE185008F}", "An-26B", {
          color_scheme("{3FCBFB57-DD04-4F58-8CBC-3AF4E8C3E1AC}", "AF Standart"),
        }),
        cnt_unit("{DFBDA1AB-0456-4AE8-A24C-EE2A0362D06E}", "An-30M", {
          color_scheme("{F0A26F8F-0DD8-42B5-A8A0-BD78F0B32C1E}", "AF Standart"),
        }),
        cnt_unit("{A00E562B-1DC8-4671-9EBF-C1CDC2506AE7}", "MiG-23MLD", {
          color_scheme("{564E8CDA-5C46-455A-8A27-4BF0EAC591CA}", "AF Standart"),
        }),
        cnt_unit("{E8506C78-7BCD-4FA7-9163-354FE3297DCA}", "IL-78M", {
          color_scheme("{8B1CD99D-A246-40A0-98B3-AF360F896E19}", "AF Standart-1"),
          color_scheme("{93240945-FE43-4b47-AE79-54607F0E66C0}", "AF Standart-2"),
        }),
        cnt_unit("{439A1A0C-1A35-4B45-A0ED-2F2A0B0E8F31}", "IL-76MD", {
          color_scheme("{2CDD2752-627F-4B01-A306-C77147C3A2B0}", "AF Standart-1"),
          color_scheme("{93240945-FE43-4b47-AE79-54607F0E66C0}", "AF Standart-2"),
        }),
        cnt_unit("{AD3E0C2E-2992-4E03-B884-E45B6F0000A7}", "MiG-27K", {
          color_scheme("{9156ABCD-9314-426D-B004-7FB7D3E290BB}", "AF Standart"),
        }),
        cnt_unit("{C17483D6-2911-408C-B57B-1839E4CD0528}", "Tu-22M3", {
          color_scheme("{413F9CBF-C3A7-4E9B-A111-A3AFAE15306B}", "AF Standart"),
        }),
        cnt_unit("{FB7FDABF-24F4-4311-AD7A-331CB382E9FA}", "MiG-25RBT", {
          color_scheme("{9DB9237E-0D8C-457C-89E9-D353700B96D4}", "AF Standart"),
        }),
		cnt_unit("{{7061418E-5D0E-4b49-915D-ACEF1F2E6855}}", "Yak-40", {
          color_scheme("{{UKRAINE-STANDARD}}", "UA Standard"),  
        }),
      },
    },
    Heliports =
    {
      CATID = "{E6490BAB-7129-4d23-9023-1CFE810886EF}",
      Heliport =
      {
        cnt_unit("{24FC9197-F225-4f2a-8A31-BD51DC7BDAB6}", "FARP"),
      },
    },
    Ships =
    {
      CATID = "{AAFD44F1-C080-4572-9465-3A52C46F2A45}",
      Ship =
      {
        cnt_unit("{63CAFD18-C960-476B-BE9D-865C53A88146}", "ELNYA"),
        cnt_unit("{5CB43DA6-B4C1-498F-BB60-0EF0BA6D6BE7}", "ALBATROS"),
        cnt_unit("{C8459CF8-BD2E-4595-9C92-6625C0B8794E}", "MOLNIYA"),
        cnt_unit("{CC2B663E-1F4A-4726-AB60-98E660C154E1}", "KILO"),
        cnt_unit("{843E23DF-8A61-40DD-8E33-41B1AEA7CF18}", "ZWEZDNY"),
        cnt_unit("{AD0D2B7F-EBB4-4415-AC14-B4D117D514D5}", "Dry-cargo ship-1"),
        cnt_unit("{21B074E6-780D-4ba5-963E-94D5C8436A4E}", "Dry-cargo ship-2"),
        cnt_unit("{7705E299-53DF-405F-95E5-C39B33DA5AAE}", "REZKY"),
        cnt_unit("{6449989a-2f92-48ed-89bf-d0ae87176cb3}", "speedboat"),
      },
    },
    Cars =
    {
      CATID = "{6CAE2420-8E36-40f3-8586-E853AADB9199}",
      Car =
      {
        cnt_unit("{10C3BD0E-4494-4bc4-BC37-2C544E33ADC7}", "BTR-80"),
        cnt_unit("{F16F5FBF-D121-47EC-9BFA-8140F30C8664}", "1L13 EWR"),
        cnt_unit("{EDEA0ECC-33A4-488B-8A3C-1D6929B5A871}", "55G6 EWR"),
        cnt_unit("{0626F96A-FDFB-42D3-ADE5-A0415690BF5E}", "S-300PS 40B6M tr"),
        cnt_unit("{414E9DC1-B881-44C3-8141-049DD59B2A69}", "S-300PS 40B6MD sr"),
        cnt_unit("{3F127663-E479-4B8D-855B-7C4F6E9310EA}", "S-300PS 64H6E sr"),
        cnt_unit("{ABB2373A-4A0C-479B-A810-A075C4346644}", "S-300PS 5P85C ln"),
        cnt_unit("{4351D9C0-EDE5-4574-9789-75227A3C9873}", "S-300PS 5P85D ln"),
        cnt_unit("{AC6EAFDF-396C-4E27-8FED-BBB9B2868F2B}", "SA-11 Buk SR 9S18M1"),
        cnt_unit("{3EE3346E-9E4D-49FA-89CD-61D0151B3DB7}", "SA-11 Buk LN 9A310M1"),
        cnt_unit("{6FBA140B-C916-460D-97AF-0921E25D71D3}", "Kub 1S91 str"),
        cnt_unit("{E553DB76-0817-4CE1-A97B-ABF2F7A38772}", "Kub 2P25 ln"),
        cnt_unit("{8E5B2FB3-8845-4026-BC7F-16898FF9442B}", "Osa 9A33 ln"),
        cnt_unit("{DD80908D-C289-4AFA-A25E-A6697EC65FDE}", "Strela-10M3"),
        cnt_unit("{C422DA78-1BC6-4FD7-BA48-CAE7674AA3A8}", "Dog Ear radar"),
        cnt_unit("{C206BC9A-F3B1-496C-AB9B-3E3A9B95DBED}", "Tor 9A331"),
        cnt_unit("{28704245-E952-427A-9C57-B2A6E0AB1E66}", "ZSU-23-4 Shilka"),
        cnt_unit("{80530579-B527-4A29-B1B6-1B0BDD4C8D86}", "SAU Msta"),
        cnt_unit("{83485D57-2B11-4A83-9A7E-5FD47E9ADCEC}", "SAU Akatsia"),
        cnt_unit("{099A1146-4309-459F-A913-AAA515D70049}", "SAU 2-C9"),
        cnt_unit("{A97C0647-83EB-4B15-8B5B-BD2F8842DF91}", "ATMZ-5"),
        cnt_unit("{C0A5AA21-5A93-4707-9A9F-2AE24C4A22B0}", "ATZ-10"),
        cnt_unit("{A326AD1A-4820-4A5A-989D-5F3CCC174FCA}", "BMD-1"),
        cnt_unit("{A90A4A5B-5AF8-49CF-B363-BB81EF4A9256}", "BMP-1"),
        cnt_unit("{EBF0085E-E84E-401B-9F66-9C2B2BC7D214}", "BMP-2"),
        cnt_unit("{B33FB5B1-ABF0-48E6-A06B-6886A0132786}", "BRDM-2"),
        cnt_unit("{37DBF2AA-30C8-4FFA-A63A-D760623FF4E0}", "Grad-URAL"),
        cnt_unit("{E2D06D03-13F6-4E5F-8A28-549D4CF30D9F}", "T-80UD"),
        cnt_unit("{1D6C2705-575C-4F35-A670-328ECBA007A3}", "UAZ-469"),
        cnt_unit("{85DF753A-0ECA-4143-88F8-5A46DEAB53C2}", "Ural-375"),
        cnt_unit("{20B6EAF4-E6D3-4FC2-A306-41951CAF1361}", "Ural-375 PBU"),
        cnt_unit("{4FC31476-127F-4608-876E-5D9B482F7E17}", "IKARUS Bus"),
        cnt_unit("{647DDAAC-CFB5-40AD-8394-042840EC4A6D}", "VAZ Car"),
        cnt_unit("{988392FB-77C0-461A-A738-DBEA8AB83030}", "Trolley bus"),
        cnt_unit("{254D09EB-5591-4D42-B513-3A15B9965B63}", "KAMAZ Truck"),
        cnt_unit("{D75AF34A-25E9-4BDE-A57A-E179AF185F2D}", "LAZ Bus"),
        cnt_unit("{7126EBF1-BC0E-450D-9C61-92B8B5310385}", "SAU Gvozdika"),
        cnt_unit("{5231B5F9-15E5-4B6C-8B22-374CEEC378BE}", "BTR_D"),
        cnt_unit("{1C4F9C25-EDBD-429e-B95A-083ABFE82B95}", "S-300PS 54K6 cp"),
        cnt_unit("{672D3629-C30C-4ba5-A54D-68728E8C35E5}", "GAZ-3307"),
        cnt_unit("{DFABA701-5202-4d78-91FF-EAE6525099EC}", "GAZ-3308"),
        cnt_unit("{4CC190E5-CC9B-4c66-8071-C5A807B8DBB9}", "GAZ-66"),
        cnt_unit("{4C763AC0-89AC-43a8-88D1-8FB710F42603}", "ZIL-4331"),
        cnt_unit("{9A2584F4-2FEE-4f3c-A47F-35D97995FCE1}", "MAZ-6303"),
        cnt_unit("{693BB858-F64A-4af0-B4EF-0BE24B8406A6}", "SKP-11"),
        cnt_unit("{B1BD673F-11B7-4a0c-8719-A81D06DD2E34}", "Ural-4320T"),
        cnt_unit("{E8DC1D50-7463-4dfa-86D7-2F81C1214D06}", "Ural ATsP-6"),
        cnt_unit("{A207B91F-77F0-4647-8D74-88A9D3851EAD}", "ZiL-131 APA-80"),
        cnt_unit("{4D98849E-2A76-4017-9356-B9852B39EBA6}", "ZIL-131 KUNG"),
        cnt_unit("{82DAF699-2456-43F7-811D-76B922288915}", "Ural-375 APA-50"),
        cnt_unit("{B76231A9-4B8A-41e0-8EAD-65785077FC0C}", "ZU-23 Emplacement"),
        cnt_unit("{773F294C-4057-4789-892C-643BE8619778}", "ZU-23 Emplacement Closed"),
        cnt_unit("{96E2A468-E0D6-4e7f-A618-7C29E4DAD176}", "Ural-375 ZU-23"),
        cnt_unit("{08353DA0-2367-42CB-8F46-20A9E4787441}", "2S6 Tunguska"),
        cnt_unit("{BF8A33C7-95E1-4B1E-B3DF-5DA8C455ACE4}", "Smerch"),
        cnt_unit("{5C486AED-5DCE-4A0A-AF88-7343D3B2B43E}", "Strela-1 9P31"),
        cnt_unit("{B00A39DC-A02C-41ec-A041-51163608CB9C}", "MTLB"),
        cnt_unit("{40B742B7-3683-4fe5-A72A-A4E7E428159F}", "T-72B"),
        cnt_unit("{277D9D98-C741-4e14-8B07-F7966C490284}", "SA-18 Igla-S manpad"),
        cnt_unit("{44232141-5D7E-4c29-9425-5970278183B9}", "SA-18 Igla-S comm"),
        cnt_unit("{64066D8C-3785-4baf-A347-C585FE29746E}", "T-55"),
        cnt_unit("{1e92e0f5-c183-4bc5-a4dd-2a437eff526b}", "Sandbox"),
        cnt_unit("{2dde8bcd-759c-4347-a4e3-eeec6c2c40a4}", "Bunker"),
      },
    },
    Helicopters =
    {
      CATID = "{828CEADE-3F1D-40aa-93CE-8CDB73FE2710}",
      Helicopter =
      {
        cnt_unit("{0903DF50-B9FA-441E-B94D-8F03DFF3E40D}", "Mi-24V", {
        color_scheme("{F6F6471A-B632-4450-822A-BDE49102EF23}", "Ukraine"),
        }),
        cnt_unit("{C08CF845-F905-40F0-AF1B-554908BBE89E}", "Mi-8MT", {
          color_scheme("{E5D21F6F-54F5-43A7-90F8-F5A03315A934}", "Standard"),
        }),
        cnt_unit("{FDE4A6C5-A26E-402D-87EF-FF6892D8FDB3}", "Mi-26", {
          color_scheme("{D714F983-DAD5-4A36-AE0C-B6B052DC4203}", "Standard"),
        }),
        cnt_unit("{809119BE-03A0-4B85-9134-900DF0591FC3}", "Ka-27", {
          color_scheme("{D2AE1B1B-6619-4196-AE8C-988C6F71BE8E}", "Standard"),
        }),
        cnt_unit("{3457BB1E-523F-4C24-BBEA-58D028623F05}", "Ka-50", {
          color_scheme("{79a33620-f067-11dd-ba2f-0800200c9a66}", "Ukraine Camo 1"),
          color_scheme("{ca7fd330-f069-11dd-ba2f-0800200c9a66}", "Ukraine Camo 1 dirt"),
        }),
      },
    },
    Fortifications =
    {
      CATID = "{7F1597F0-88EB-41cb-A04E-E9A4D5EF7466}",
      Fortification =
      {
        cnt_unit("{79BEF6B1-03EE-40A5-9D67-FE369D67D8F3}", "Locomotive"),
        cnt_unit("{5D159ABA-28C6-4E6A-BD41-B295AFA4E108}", "Electric locomotive"),
        cnt_unit("{A65C983E-3615-4350-93B2-128CBA8B3569}", "Coach a tank"),
        cnt_unit("{066A8FCF-6591-457C-888A-AF443AF95084}", "Coach cargo"),
        cnt_unit("{AA5E677A-BE23-4752-8C1A-24E25EC148CC}", "Coach cargo open"),
        cnt_unit("{77348759-616D-4500-9AB8-701D9F8028CD}", "Coach a platform"),
        cnt_unit("{8B096AEA-9E18-4541-8120-0DAB3BC57170}", "Coach a passenger"),
        cnt_unit("{71AC463C-310A-41ce-B7E7-923AC3CA5EDC}", ".Block"),
        cnt_unit("{B54053A8-B054-4a0b-871C-6DDA65ED90EF}", ".Block on road"),
        cnt_unit("{20A1B146-07C6-4ee6-851C-DBBC92135446}", ".Bunker"),
        cnt_unit("{2848C193-6789-472c-8430-AF3D739BB6C8}", ".Pill-box"),
        cnt_unit("{64DE4673-7D3E-424f-AB29-F4336AC38F98}", ".Command Center"),
        cnt_unit("{85D3DBF2-05DF-48e1-9C49-FD104E65A76E}", ".Ammunition depot"),
        cnt_unit("{7c822c60-9885-4a44-8add-b87511ff0fc5}", "Hangar A"),
        cnt_unit("{f0f48213-396f-4cc2-9fec-2f308cb11154}", "Tank"),
        cnt_unit("{b0e8ef18-c50c-4695-ac6e-1033b3691ce2}", "Tech hangar A"),
        cnt_unit("{db4d86a5-f9d6-4db1-b6ff-72153d082fc8}", "Farm A"),
        cnt_unit("{d406d212-8425-41be-83a1-502864f221dd}", "Farm B"),
        cnt_unit("{e8f80c05-dd74-4ce4-a232-f29afa025c3b}", "Garage A"),
        cnt_unit("{c5f17833-f456-45be-8c7c-ab28996f0e85}", "Boiler-house A"),
        cnt_unit("{65c10c17-e726-46d4-a380-db42706b923f}", "Restaurant 1"),
        cnt_unit("{80af40db-22ac-4e42-ab24-a015d1a21311}", "Warehouse"),
        cnt_unit("{fe75a842-e794-4650-9197-22797513dc72}", "Comms tower M"),
        cnt_unit("{70bf5fc8-441f-47cb-b587-d8f36ab81600}", "Cafe"),
        cnt_unit("{bddc2805-fd70-47dd-90b0-0041ebd1eee3}", "Workshop A"),
        cnt_unit("{7d0fa1db-38a1-4bf8-9169-943e11d49001}", "Electric power box"),
        cnt_unit("{d161a6b7-3946-49b2-af4c-aef104809480}", "Supermarket A"),
        cnt_unit("{1a4b08df-98c6-45da-bfea-161d7ad0135f}", "Water tower A"),
        cnt_unit("{cc06c05a-da19-494c-8066-04bb6b2f375b}", "TV tower"),
        cnt_unit("{2fe5cb79-1395-4b34-a112-913e964534e9}", "Shelter"),
        cnt_unit("{56c3c279-31f6-4cb9-ba63-6025f14adb08}", "Repair workshop"),
        cnt_unit("{4d01350e-eac5-406a-8daf-a1e1cc74c03b}", "Railway station"),
        cnt_unit("{557eab86-9e3d-459f-880b-3bfbd3b397fe}", "Railway crossing A"),
        cnt_unit("{8ff4a140-121e-4b25-a7e1-72bf64a3645c}", "Railway crossing B"),
        cnt_unit("{044858e2-4d40-4702-a185-70ee80f07151}", "WC"),
        cnt_unit("{72c629a7-112d-4a3e-9032-ba62dab2e36d}", "Small house 1A area"),
        cnt_unit("{40cf54da-bdb2-4993-a619-f5504200c3f5}", "Small house 1A"),
        cnt_unit("{95dbcac0-35e6-4621-bb02-a500666e337e}", "Small house 1B area"),
        cnt_unit("{8b22a3fd-8d96-4320-81b5-04f2c9edb247}", "Small house 1B"),
        cnt_unit("{7ae8526a-0edc-46ca-bf03-a1dc10445fcd}", "Small house 1C area"),
        cnt_unit("{9f6a6842-f5a5-4953-871b-58e0a2278849}", "Small house 2C"),
        cnt_unit("{aa0f2150-ed5c-4b66-8c7a-39ab3bccf5e3}", "Shop"),
        cnt_unit("{0a4804d2-db83-4a18-bf2a-a253a9b17e33}", "Tech combine"),
        cnt_unit("{264c3fb6-7871-471a-8915-a68afe98fbb5}", "Chemical tank A"),
        cnt_unit("{2cca8015-d0a0-43f7-bc89-0bf1cf290246}", "Small werehouse 1"),
        cnt_unit("{14b9c61c-bf3a-4dff-939c-5f3d55351d4e}", "Small werehouse 2"),
        cnt_unit("{ffe9021e-7d44-4ab3-8df9-0696d2506148}", "Small werehouse 3"),
        cnt_unit("{4b6bcf8c-6e4c-485b-a8f3-ac4de3338b5f}", "Small werehouse 4"),
        cnt_unit("{e0b21ae2-029b-4c20-986c-9c469d69b2c8}", "Garage B"),
        cnt_unit("{70a0edf9-c9bd-42c8-b260-e97927ebaaaa}", "Garage small A"),
        cnt_unit("{e4322f04-ba0d-43db-afe9-16025738ebeb}", "Garage small B"),
        cnt_unit("{36ac22c8-9737-4bdc-b59e-fd0fb823daaa}", "Pump station"),
        cnt_unit("{7d517890-d7ea-4ede-9c73-5be252b96d3f}", "Oil derrick"),
        cnt_unit("{d4fd6053-a036-4adf-8395-beca84e9efbb}", "Container red 1"),
        cnt_unit("{edd392fd-f262-4609-84d3-c09f126478ee}", "Container red 2"),
        cnt_unit("{dc005e97-7820-4cce-bc0e-edd875baaf92}", "Container red 3"),
        cnt_unit("{662e6cea-5a59-473f-87e9-e34d01f1ddb7}", "Container white"),
        cnt_unit("{d55f444b-745a-4954-bd4c-0ea1781f67a7}", "Container brown"),
        cnt_unit("{7f3722ae-10bc-49c5-a3cc-68ab89878c5b}", "Barracks 1"),
        cnt_unit("{eb3bac2d-4c24-4ff8-8c8a-dcd3d0c98750}", "Barracks 2"),
        cnt_unit("{a056cc08-9b50-45b1-b798-e0eb4277ea86}", "Military staff"),
        cnt_unit("{2b1802df-c4f9-404f-afe1-5f291ef68d30}", "Watchtower"),
        cnt_unit("{e9e4e232-b0c8-4306-b013-2f9defbb04d1}", "Hangar B"),
        cnt_unit("{07a6695a-2373-489f-a0a0-e1e35dd03b85}", "Fuel tank"),
        cnt_unit("{25f698c7-ee7b-40be-bafb-d97e64c487f3}", "Shelter B"),
        cnt_unit("{e0f6d8f9-0692-4695-933b-6e87636c7acb}", "Oil platform"),
        cnt_unit("{6d518ff5-cfca-4a7c-921b-ee3621a4207d}", "Subsidiary structure 1"),
        cnt_unit("{47a39247-7989-4f6d-bbb8-2cdd40e012dd}", "Subsidiary structure 2"),
        cnt_unit("{e58952f4-d2e9-43bc-a5ea-854d4678ef96}", "Subsidiary structure 3"),
        cnt_unit("{394ff644-013b-4f88-bfe1-1277cbcba8cc}", "Subsidiary structure A"),
        cnt_unit("{c724c713-61ad-4fb0-807d-dc6eb4a89884}", "Subsidiary structure B"),
        cnt_unit("{162b2803-ddf1-4b0e-9b95-b45b2f35ee30}", "Subsidiary structure C"),
        cnt_unit("{9cbba4f7-7014-4f67-b69a-4a458e5f2420}", "Subsidiary structure D"),
        cnt_unit("{dbb8c3f5-f1ea-42e1-b486-482ef41a4e53}", "Subsidiary structure E"),
        cnt_unit("{74e14790-da2b-4269-bd94-0bfa2dee0031}", "Subsidiary structure F"),
        cnt_unit("{96fc5825-e329-468d-83d8-fc9326d8aa52}", "Subsidiary structure G"),
        cnt_unit("{30D37BB2-F438-45ae-B09D-F00B1EFCB790}", "Landmine"),
        cnt_unit("{7c9d05ea-0b54-4d5c-9d6f-fa2cde39e349}", "FARP Ammo Dump Coating"),
        cnt_unit("{80c39fb0-854f-461b-bc4b-b2b51d0c4139}", "FARP Tent"),
        cnt_unit("{a947d0fd-9268-4851-a885-cb59aebe9bbc}", "FARP CP Blindage"),
        cnt_unit("{3441baf3-7ff7-4d76-ab9e-77f768b7813f}", "FARP Fuel Depot"),
        cnt_unit("{7e58d67d-191e-4e2c-ad22-a9c50cd48f53}", "GeneratorF"),
      },
    },
  },
  {
    callsign(1, "{63F96C45-0053-4b82-91A3-484E101297C7}", "0"),
    callsign(2, "{99614DB6-5B25-465e-87BC-528CFB253784}", "1"),
    callsign(3, "{AC5C879B-E065-40fe-B160-0CDAE7FC011D}", "2"),
    callsign(4, "{99420485-7146-4286-9CB4-B6E362A13F8B}", "3"),
    callsign(5, "{A72AF054-195F-431c-978D-B519ACAFD997}", "4"),
    callsign(6, "{B2B919BB-55E4-4731-8AC1-CFDB14341407}", "5"),
    callsign(7, "{7FCB6479-44DB-42c2-9EC4-9F7197A06F79}", "6"),
    callsign(8, "{1C2F8D53-DDD8-41d8-A871-A7BAF1E957F5}", "7"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Medal "Zakhystnyku Vitchyzny"', _('Medal "Zakhystnyku Vitchyzny"'), 200,  'UKR-01-ForDefenderOfFatherland.png'),
    award('Orden "Za Zaslugy III"', _('Orden "Za Zaslugy III"'), 600,  'UKR-02-ForMerit-III.png'),
    award('Orden "Za Zaslugy II"', _('Orden "Za Zaslugy II"'), 1000, 'UKR-03-ForMerit-II.png'),
    award('Orden "Za Zaslugy I"', _('Orden "Za Zaslugy I"'), 1400, 'UKR-04-ForMerit-I.png'),
    award('Zirka "Za Zaslugy"', _('Zirka "Za Zaslugy"'), 1800, 'UKR-05-ForMerit-Star.png'),
    award('Medal "Za Viyskovu Sluzhbu"', _('Medal "Za Viyskovu Sluzhbu"'), 2200, 'UKR-06-ForMilitaryService.png'),                                                    
    award('Orden "Za Muzhnist"', _('Orden "Za Muzhnist"'), 2600, 'UKR-07-OrderForCourage.png'),
    award('Zolota Zirka', _('Zolota Zirka'), 3000, 'UKR-08-GoldStar.png'),                                                       
  },                                         
  'Ukraine.lua',
  {0,390,64,30}
);

country("{EFADDFE6-9360-4523-8CAB-2D74182617FD}", _("USA"), "USA", "USA", "USA.png", 2,
  {
    Planes =
    {
      CATID = "{C168A850-3C0B-436a-95B5-C4A015552560}",
      Plane =
      {
        cnt_unit("{8FDB2742-2283-450D-B417-CFC47774E8B6}", "A-10A", {
          color_scheme("{06802A89-EC9B-486D-90C3-89C3A91F1309}", "Flipper"),
          color_scheme("{6D79BC93-FB8D-4EE4-AE1A-AECADB2798E5}", "23rd FG New"),
          color_scheme("{6C2CCF81-751B-42F5-93B2-4160B55DD085}", "52th Fighter Wing"),
          color_scheme("{58430E22-BD3D-4CC3-B2B9-CB7ED57CB7FF}", "European1"),
          color_scheme("{A32B6C33-9C38-4BD0-BBBD-09380BA6A23E}", "23rd FG Old"),
          color_scheme("{9DF1AFBE-56FD-4E7D-AB73-0731DD4CD720}", "JAWS"),
          color_scheme("{DB597F88-04FF-40C4-9ADF-83EF6FF46246}", "Desert1"),
          color_scheme("{8FC7F7C0-FD76-4607-85F0-9B19F542DA12}", "Desert2"),
          color_scheme("{2C99F172-EAF3-4E49-8020-475E89467C9C}", "Snow1"),
          color_scheme("{D7FBDFAC-7CDA-4857-9999-CDC0F2AFD1CA}", "104th Fighter Wing"),
        }),
        cnt_unit("{B31D98CC-35E9-4431-81A0-369DFDB6D6A3}", "F-117A", {
          color_scheme("{58206553-0986-4B0A-B0BA-BAD1950CEC01}", "USAF Standart"),
        }),
        cnt_unit("{3782913C-BA3A-4CD9-B9DC-2DCBE6B8F656}", "C-17A", {
          color_scheme("{CF56A53B-5B7A-47DD-BACD-8D5DED11192B}", "USAF Standart"),
        }),
        cnt_unit("{CD247E45-4702-4E3A-A659-4F5E0E645D2B}", "F-15C", {
          color_scheme("{2e57406b-0ad2-4531-8dc4-e9ba59be6167}", "32nd TFS (CR) AB Soesterberg (early)"),
          color_scheme("{3506c4fe-4c3a-4d79-b232-fd000ec65b9c}", "58th FS \"Gorillas\" (EG) AFB Eglin"),
          color_scheme("{abd15535-a4ba-451a-8583-6d796c35747b}", "59th FS \"Proud Lions\" (EG) AFB Eglin"),
          color_scheme("{8238d333-c109-43dc-8cae-74e92799270a}", "27th FS \"Fighting Eagles\" (FF) AFB Langley"),
          color_scheme("{a4492e44-06bd-4ed8-b744-f5fd4be4b2c8}", "71th FS \"The Ironmen\" (FF) AFB Langley"),
          color_scheme("{c0ee4ef9-9328-4a38-871e-1dfbd1efd41f}", "67th FS \"Fighting Cocks\"  (ZZ) AB Kadena"),
          color_scheme("{1a27ede8-236a-42c6-b7c5-2f2f2620fd26}", "48th FW 493rd FS (LN) RAF Lakenheath (GB)"),
          color_scheme("{2a31c5f8-df20-4af3-bd7d-ccbb8a64b5cf}", "52th FW \"The Tigers\" (SP) AB Spangdahlem"),
          color_scheme("{8e75a77d-c944-4f43-9441-787e03d6b68f}", "54th FS (AK) AFB Elmendorf (early)"),
        }),
        cnt_unit("{082D2561-FB8B-11d5-9190-00A0249B6F00}", "F-16C bl.52d", {
          color_scheme("{eeaab67f-6f15-4a5d-9b74-1c08ee971e9b}", "USAFE 555th FS (AV) Aviano AFB"),
          color_scheme("{189e0024-e439-494c-8b7e-817a2884ab85}", "PACAF 14th FS (MJ) Misawa AFB"),
          color_scheme("{65a85d13-351d-450d-84f9-c5cc528228cf}", "PACAF 35th FW (WW) Misawa AFB"),
          color_scheme("{89c5ff57-d84c-4950-8109-dafd18e40143}", "USAF 77th FS (SW) Shaw AFB"),
          color_scheme("{356613e0-28af-4ca1-ac5d-1c590bb213c6}", "USAFE 22nd FS (SP) Spangdahlem AFB"),
          color_scheme("{382e7a6a-b29f-4881-9c28-d9ea192bc4c6}", "USAF 414th CTS (WA) Nellis AFB"),
          color_scheme("{924ed5b8-c371-4315-b29f-c0be4ecb188d}", "USAF 412th TW (ED) Edwards AFB"),
          color_scheme("{d00a836b-6c9c-40f9-a8c5-39501ae3a178}", "USAF 147th FIG (EF) Ellington AFB"),
        }),
        cnt_unit("{AB49B09D-B5DC-4833-B649-88AFB10B4CA3}", "B-1B", {
          color_scheme("{E3DEBF9D-D1BB-4480-8373-9DAE9CF032C2}", "USAF Standart"),
        }),
        cnt_unit("{58517ADF-DB08-4519-B2A0-727A3DFC0217}", "B-52H", {
          color_scheme("{00DF53CD-FF59-4682-84B4-F7C1E6DF6B95}", "USAF Standart"),
        }),
        cnt_unit("{80AD28A5-C892-4E68-9364-F7C3C7E71E6E}", "E-3A", {
          color_scheme("{8e732627-d6b5-4724-a764-359db8556f3d}", "USAF Standart"),
        }),
        cnt_unit("{513825C4-174E-4926-BE80-CC87D89900E4}", "KC-10A", {
          color_scheme("{09B15A14-3A6F-4D14-ACD0-85478F181C9C}", "USAF Standart"),
        }),
        cnt_unit("{0213FA86-978D-4586-BAC3-BD642AD52B96}", "C-130", {
          color_scheme("{dd2aefff-6bea-44a4-86ac-7222e4cb6720}", "USAF Standard"),
          color_scheme("{E42887C8-D99B-45e6-B6FC-47430F88C8AB}", "USAF, 43rd Air Wing, Pope AFB"),
        }),
        cnt_unit("{919CA6E6-B44C-4144-96B2-38C959F377B1}", "F-14A", {
          color_scheme("{0DB7CA7A-7EB1-4C90-B1C4-223508F43D93}", "VF-111 \"Sundowners\"- 1"),
          color_scheme("{F309BA62-22DE-4A89-A6E4-D150E67797AF}", "VF-142 \"Ghost Riders\""),
          color_scheme("{C8CE193B-8953-4CF9-B01B-34C706A7D05F}", "VF-84 \"Jolly Rogers\""),
          color_scheme("{EC48B28F-FE17-4208-BDA5-607C4922EF4D}", "VF-41 \"Black Aces\""),
          color_scheme("{961A1E29-E58C-4FBD-A169-7DBCB33E96EF}", "VF-111 \"Sundowners\"- 2"),
          color_scheme("{572F098D-5B0B-4B4C-AC36-AE43CA508360}", "VF-XXX \"Aardvarks\""),
          color_scheme("{F60391CC-581B-432D-B452-E9A674BC079B}", "VF-143 \"Pukin's Dogs\""),
          color_scheme("{3FC581F1-3AFC-4372-8194-CD1C33948FD2}", "VF-1 \"Wolfpack\""),
          color_scheme("{EA8A4393-4E88-411E-8F52-2299DA280729}", "VF-33 \"Starfighters\""),
          color_scheme("{E4BD78CB-EC5E-40F3-A28A-8EBA66808295}", "Black demo scheme"),
        }),
        cnt_unit("{C4D0D89A-F111-4610-ADB5-84CD0F29E703}", "S-3B", {
          color_scheme("{66ED3430-0D09-41B1-9729-5C1EBB950789}", "USAF Standart"),
        }),
        cnt_unit("{8B709A69-CE5E-46bc-B0D4-159238B52E2A}", "S-3B Tanker", {
          color_scheme("{66ED3430-0D09-41B1-9729-5C1EBB950789}", "USAF Standart"),
        }),
        cnt_unit("{C075771D-EDE1-42C7-8E81-130B60500584}", "F/A-18C", {
          color_scheme("{0f1f7682-8316-4473-9591-3eb1d580553f}", "VFA-15 \"Valions\" NAVY (Cecil Field)"),
          color_scheme("{0798f34e-16e6-412e-b3fe-8602cf60cb16}", "VFA-37 \"Bulls\" NAVY (Cecil Field)"),
          color_scheme("{52e6bd59-a22a-4ced-81a0-c04a38652850}", "VFA-94 \"Mighty Shrikes\" NAVY (Lemoore)"),
          color_scheme("{8eefe72f-33bb-4436-9d26-e601ed4c5ca6}", "VFA-113 \"Stingers\" CAG NAVY (Lemoore)"),
          color_scheme("{6028a658-6560-4a06-aca6-4735fc478581}", "VFA-113 \"Stingers\" NAVY (Lemoore)"),
          color_scheme("{2a9629d5-4d0b-45d3-897d-c70d4ae85759}", "VFA-125 \"Rough Riders\" MC (Lemoore)"),
          color_scheme("{487663da-63bc-4fc5-ba76-13f90a6210e0}", "VFA-136 \"Knighthawks\" NAVY (Cecil Field)"),
        }),
        cnt_unit("{C7888130-8CDA-422F-8BB9-FC507DCDF19D}", "E-2C", {
          color_scheme("{cd006906-963e-4b0d-88a0-c5c0d56f393c}", "USAF Standart"),
        }),
        cnt_unit("{51024F71-B4F4-4226-A8D5-976CE662517A}", "F-16A", {
          color_scheme("{7F2A6341-D16D-48e2-A2ED-8CE58CFFFE1C}", "USAF F16 Standart-1"),
        }),
        cnt_unit("{569949FE-CE95-4D94-BF76-7B809B8DACD0}", "F-5E", {
          color_scheme("{3cfb676e-4d20-4b6c-ae4a-3dd44aa8381a}", "Aggressor \"Sand\" Scheme"),
          color_scheme("{763862f8-3a41-4871-9080-a9f6db15ef32}", "Aggressor \"Frog\" Scheme"),
          color_scheme("{252a6f11-a3a5-4072-b89a-616c86cc4058}", "Aggressor \"New Ghost \" Scheme-1"),
          color_scheme("{a3655d6d-eade-4922-bf69-7fe9a9cdf736}", "Aggressor \"New Ghost \" Scheme-2"),
          color_scheme("{26a7e90c-523b-4de1-94f6-b4feae159c34}", "Aggressor \"Old Blue \" Scheme"),
          color_scheme("{0cccc9ed-da23-4a2d-b1d0-45e825f85b12}", "Aggressor \"New Blue \" Scheme"),
          color_scheme("{4de4e05b-6a04-4815-9c08-40a32cd9a86c}", "Aggressor \"SNAKE\" Scheme"),
          color_scheme("{5e01f86b-03d2-4973-96dd-e039d465571e}", "Aggressor \"Desert\" scheme"),
          color_scheme("{2d779717-88f9-4b54-9375-5f4f5beeadfe}", "\"Green\" paint scheme"),
        }),
        cnt_unit("{2C4C5E81-F950-11d5-9190-00A0249B6F00}", "F/A-18C", {
          color_scheme("{b58d5ff2-4df7-48cd-b234-af3c757b2f3c}", "VFA-15 \"Valions\" NAVY (Cecil Field)"),
          color_scheme("{f1199df4-4110-47f0-b533-530ca81ce3d6}", "VFA-125 \"Rough Riders\" MC (Lemoore)"),
          color_scheme("{da74428c-d7ed-4070-93f8-ca90b8a7b8f4}", "VFA-131 \"Wildcats\" NAVY (Cecil Field)"),
          color_scheme("{7fb48dfb-8125-4999-835c-720f4f22448d}", "VFA-132 \"Privateers\" NAVY (Lemoore)"),
          color_scheme("{5e724135-12ab-421e-aca4-156dad3a0c60}", "VFA-151 \"Vigilantes\" NAVY (Lemoore)"),
          color_scheme("{4fccd038-63bc-47f8-b1ef-13f5bae96f1a}", "VMFA-251 \"Thunderbolts\" MC (Beaufort)"),
          color_scheme("{29483bf3-0d2f-4111-b77c-ced11be2e027}", "VMFA-314 \"Black Knights\" MC (El Toro)"),
          color_scheme("{bf417232-ebf6-4a95-9be2-8aa9466f79cb}", "VMFA-323 \"Death Rattlers\" MC (El Toro)"),
        }),
        cnt_unit("{3170e5d2-f866-4ade-a66a-81703d65a7ca}", "F/A-18C", {
          color_scheme("{6b4e276b-4d8e-42b5-ab9e-e765bec3649b}", "Predator Skin"),
        }),
      },
    },
    Heliports =
    {
      CATID = "{E6490BAB-7129-4d23-9023-1CFE810886EF}",
      Heliport =
      {
        cnt_unit("{24FC9197-F225-4f2a-8A31-BD51DC7BDAB6}", "FARP"),
      },
    },
    Ships =
    {
      CATID = "{AAFD44F1-C080-4572-9465-3A52C46F2A45}",
      Ship =
      {
        cnt_unit("{4F4EEC97-D6CA-41D5-9C0C-ECE6991BA4E9}", "VINSON"),
        cnt_unit("{AA4986BF-CBC4-48B6-AEEA-07E564FADB8B}", "PERRY"),
        cnt_unit("{E4C99B3C-BFA9-42B5-842B-563729B5DEFA}", "TICONDEROG"),
        cnt_unit("{6449989a-2f92-48ed-89bf-d0ae87176cb3}", "speedboat"),
      },
    },
    Cars =
    {
      CATID = "{6CAE2420-8E36-40f3-8586-E853AADB9199}",
      Car =
      {
        cnt_unit("{07220042-0448-486F-9842-63E68A961ECB}", "M-2 Bradley"),
        cnt_unit("{B350FDB3-E7DA-4DF3-9F59-0DADD5933EEB}", "M1097 Avenger"),
        cnt_unit("{BDFF2359-B329-479A-A4D2-A14F3FB37DE4}", "Patriot str"),
        cnt_unit("{572AF10E-0FAC-4E2D-BA3F-96D6C08194FB}", "Patriot ln"),
        cnt_unit("{6E93EACB-F7DB-4208-88C4-8D6465869A05}", "Hawk sr"),
        cnt_unit("{6FD50C44-10A0-458F-AF4E-0472EEFCD07E}", "Hawk tr"),
        cnt_unit("{DEAC9323-0320-482A-A4DC-DC7ABCB4B987}", "Hawk ln"),
        cnt_unit("{AC83CA0F-E7D9-4A25-9B1F-0CC163FA1684}", "Vulcan"),
        cnt_unit("{5A76E1FB-E73B-4D93-B61B-967AB6F87508}", "Hummer"),
        cnt_unit("{E982CA60-4C43-4C6A-A524-BF250D54E742}", "LAV-25"),
        cnt_unit("{E0B4364A-3E12-4DE3-84F2-F29EFAE17BED}", "AAV7"),
        cnt_unit("{3BDD3518-974C-49EB-8746-54A8DD91C14F}", "M-113"),
        cnt_unit("{A543AD97-7C33-4655-9A9A-FDB9F1D42248}", "M-109"),
        cnt_unit("{9B446921-7D69-4815-93B8-3AEC663E748E}", "M-1 Abrams"),
        cnt_unit("{3C8BFE7F-E0B6-4FF7-8DCD-CC165BE5D5BC}", "MLRS"),
        cnt_unit("{0EDE3912-F55C-402a-95AF-36BB3106BEA2}", "M 818"),
        cnt_unit("{033A717B-2687-4d74-9A89-69C2535DAC48}", "Patriot cp"),
        cnt_unit("{6416E353-E50F-497f-9F7A-51A99788E18E}", "M48 Chaparral"),
        cnt_unit("{FB82E110-BCD3-48ef-8D3D-BB338595F4B3}", "M1126 Stryker ICV"),
        cnt_unit("{7E3E85CE-A234-4b07-9481-EDDD965C74EA}", "M1128 Stryker MGS"),
        cnt_unit("{B2FDA9C8-E5CC-41ff-873E-CF0E0A2CE22C}", "M1134 Stryker ATGM"),
        cnt_unit("{C4DEC9B1-D738-4cdf-940C-218D6AC4F99D}", "M6 Linebacker"),
        cnt_unit("{B84C5FC5-9893-45e4-A712-E3D4D201A003}", "Stinger manpad"),
        cnt_unit("{DFC5C4AA-EFE7-4929-A305-B8785BCD6704}", "Stinger comm"),
        cnt_unit("{e0b477c0-1a54-41f6-a8e7-b049d8e0656c}", "Predator GCS"),
        cnt_unit("{57194102-8a17-4aac-8412-f26da6c82914}", "Predator TrojanSpirit"),
        cnt_unit("{FA0867CA-3D72-4545-8FD3-8E373855A0F2}", "M1043 HMMWV Armament"),
        cnt_unit("{FE382883-18E8-4ee0-88C4-2404B966E87B}", "M1045 HMMWV TOW"),
        cnt_unit("{2CAB63C2-2773-47EC-BAE0-F36D895486B9}", "M978 HEMTT Tanker"),
        cnt_unit("{39121363-3906-4157-9C96-6EF8B4755E2F}", "Soldier M4"),
        cnt_unit("{d615a96d-5591-4c8a-a681-a28bdcfd0805}", "Soldier M249"),
      },
    },
    Helicopters =
    {
      CATID = "{828CEADE-3F1D-40aa-93CE-8CDB73FE2710}",
      Helicopter =
      {
        cnt_unit("{F324202D-A045-418B-86D0-7594454FDA81}", "AH-64A", {
          color_scheme("{01EC6D3C-3B39-456A-99CE-9A26FE2208DC}", "Standard"),
          color_scheme("{0CE364E9-FA11-4400-A649-BD8DBDEC4D66}", "Standard Dirt"),
        }),
        cnt_unit("{F939FD3E-229F-4A9F-AE99-5CD4D60DE5F9}", "AH-64D", {
          color_scheme("{C25DCDD3-0DAE-4141-BB5D-8F6373BB4BC7}", "Standard"),
        }),
        cnt_unit("{D49A54A7-1607-4779-88EE-7D4EF529CF5C}", "AH-1W", {
          color_scheme("{DD91959B-D828-4DBA-8437-BCE7930376A1}", "Standard"),
          color_scheme("{22E0EF0D-67FB-4699-902A-8577680ED8DB}", "AH-1W_Marines"),
          color_scheme("{B91AB3DE-4475-4b7c-BDCA-72EB9F1AF0DD}", "AH-1W_Black"),
        }),
        cnt_unit("{8CC2AAFA-F5F6-498D-83E0-681561D691B8}", "UH-60A", {
          color_scheme("{FEA21BC0-A211-47E3-9FEF-A4043A04B6D3}", "Standard"),
        }),
        cnt_unit("{AF7808AC-A07C-470D-886B-505E8D23D317}", "CH-47D", {
          color_scheme("{EAA12DB5-638C-491A-8133-926B1232C140}", "Standard"),
        }),
        cnt_unit("{975CB910-D5AC-4C70-A3E0-8EE8564BA112}", "SH-60B", {
          color_scheme("{8D40CF69-2A36-4BAE-B8EF-952A88FAF24B}", "Standard"),
        }),
        cnt_unit("{022A971C-137D-48EB-A153-43D08A985F2E}", "CH-53E", {
          color_scheme("{482F43DE-FAC2-4FEC-931F-25C790A3A977}", "Standard"),
        }),
        cnt_unit("{4A3860BF-A4DE-4f0c-9265-5E20D230FA07}", "OH-58D", {
          color_scheme("{9C753C8A-EEF9-4d70-8013-64C6B7796B34}", "Standard"), 
        }),
        cnt_unit("{3457BB1E-523F-4C24-BBEA-58D028623F05}", "Ka-50", {
          color_scheme("{9e860c80-ecaf-11dd-ba2f-0800200c9a66}", "US ARMY"),
          color_scheme("{a7938dc0-ecaf-11dd-ba2f-0800200c9a66}", "US MARINES 1"),
          color_scheme("{b00b1090-ecaf-11dd-ba2f-0800200c9a66}", "US MARINES 2"),
        }),
        cnt_unit("{111132D6-F3AA-4C00-A53A-A6C5FB298572}", "UH-1H", {
          color_scheme("{ab0cff10-0503-11de-8c30-0800200c9a66}", "Standard"),
        }),
      },
    },
    Fortifications =
    {
      CATID = "{7F1597F0-88EB-41cb-A04E-E9A4D5EF7466}",
      Fortification =
      {
        cnt_unit("{79BEF6B1-03EE-40A5-9D67-FE369D67D8F3}", "Locomotive"),
        cnt_unit("{5D159ABA-28C6-4E6A-BD41-B295AFA4E108}", "Electric locomotive"),
        cnt_unit("{A65C983E-3615-4350-93B2-128CBA8B3569}", "Coach a tank"),
        cnt_unit("{066A8FCF-6591-457C-888A-AF443AF95084}", "Coach cargo"),
        cnt_unit("{AA5E677A-BE23-4752-8C1A-24E25EC148CC}", "Coach cargo open"),
        cnt_unit("{77348759-616D-4500-9AB8-701D9F8028CD}", "Coach a platform"),
        cnt_unit("{8B096AEA-9E18-4541-8120-0DAB3BC57170}", "Coach a passenger"),
        cnt_unit("{71AC463C-310A-41ce-B7E7-923AC3CA5EDC}", ".Block"),
        cnt_unit("{B54053A8-B054-4a0b-871C-6DDA65ED90EF}", ".Block on road"),
        cnt_unit("{20A1B146-07C6-4ee6-851C-DBBC92135446}", ".Bunker"),
        cnt_unit("{2848C193-6789-472c-8430-AF3D739BB6C8}", ".Pill-box"),
        cnt_unit("{64DE4673-7D3E-424f-AB29-F4336AC38F98}", ".Command Center"),
        cnt_unit("{85D3DBF2-05DF-48e1-9C49-FD104E65A76E}", ".Ammunition depot"),
        cnt_unit("{7c822c60-9885-4a44-8add-b87511ff0fc5}", "Hangar A"),
        cnt_unit("{f0f48213-396f-4cc2-9fec-2f308cb11154}", "Tank"),
        cnt_unit("{b0e8ef18-c50c-4695-ac6e-1033b3691ce2}", "Tech hangar A"),
        cnt_unit("{db4d86a5-f9d6-4db1-b6ff-72153d082fc8}", "Farm A"),
        cnt_unit("{d406d212-8425-41be-83a1-502864f221dd}", "Farm B"),
        cnt_unit("{e8f80c05-dd74-4ce4-a232-f29afa025c3b}", "Garage A"),
        cnt_unit("{c5f17833-f456-45be-8c7c-ab28996f0e85}", "Boiler-house A"),
        cnt_unit("{65c10c17-e726-46d4-a380-db42706b923f}", "Restaurant 1"),
        cnt_unit("{80af40db-22ac-4e42-ab24-a015d1a21311}", "Warehouse"),
        cnt_unit("{fe75a842-e794-4650-9197-22797513dc72}", "Comms tower M"),
        cnt_unit("{70bf5fc8-441f-47cb-b587-d8f36ab81600}", "Cafe"),
        cnt_unit("{bddc2805-fd70-47dd-90b0-0041ebd1eee3}", "Workshop A"),
        cnt_unit("{7d0fa1db-38a1-4bf8-9169-943e11d49001}", "Electric power box"),
        cnt_unit("{d161a6b7-3946-49b2-af4c-aef104809480}", "Supermarket A"),
        cnt_unit("{1a4b08df-98c6-45da-bfea-161d7ad0135f}", "Water tower A"),
        cnt_unit("{cc06c05a-da19-494c-8066-04bb6b2f375b}", "TV tower"),
        cnt_unit("{2fe5cb79-1395-4b34-a112-913e964534e9}", "Shelter"),
        cnt_unit("{56c3c279-31f6-4cb9-ba63-6025f14adb08}", "Repair workshop"),
        cnt_unit("{4d01350e-eac5-406a-8daf-a1e1cc74c03b}", "Railway station"),
        cnt_unit("{557eab86-9e3d-459f-880b-3bfbd3b397fe}", "Railway crossing A"),
        cnt_unit("{8ff4a140-121e-4b25-a7e1-72bf64a3645c}", "Railway crossing B"),
        cnt_unit("{044858e2-4d40-4702-a185-70ee80f07151}", "WC"),
        cnt_unit("{72c629a7-112d-4a3e-9032-ba62dab2e36d}", "Small house 1A area"),
        cnt_unit("{40cf54da-bdb2-4993-a619-f5504200c3f5}", "Small house 1A"),
        cnt_unit("{95dbcac0-35e6-4621-bb02-a500666e337e}", "Small house 1B area"),
        cnt_unit("{8b22a3fd-8d96-4320-81b5-04f2c9edb247}", "Small house 1B"),
        cnt_unit("{7ae8526a-0edc-46ca-bf03-a1dc10445fcd}", "Small house 1C area"),
        cnt_unit("{9f6a6842-f5a5-4953-871b-58e0a2278849}", "Small house 2C"),
        cnt_unit("{aa0f2150-ed5c-4b66-8c7a-39ab3bccf5e3}", "Shop"),
        cnt_unit("{0a4804d2-db83-4a18-bf2a-a253a9b17e33}", "Tech combine"),
        cnt_unit("{264c3fb6-7871-471a-8915-a68afe98fbb5}", "Chemical tank A"),
        cnt_unit("{2cca8015-d0a0-43f7-bc89-0bf1cf290246}", "Small werehouse 1"),
        cnt_unit("{14b9c61c-bf3a-4dff-939c-5f3d55351d4e}", "Small werehouse 2"),
        cnt_unit("{ffe9021e-7d44-4ab3-8df9-0696d2506148}", "Small werehouse 3"),
        cnt_unit("{4b6bcf8c-6e4c-485b-a8f3-ac4de3338b5f}", "Small werehouse 4"),
        cnt_unit("{e0b21ae2-029b-4c20-986c-9c469d69b2c8}", "Garage B"),
        cnt_unit("{70a0edf9-c9bd-42c8-b260-e97927ebaaaa}", "Garage small A"),
        cnt_unit("{e4322f04-ba0d-43db-afe9-16025738ebeb}", "Garage small B"),
        cnt_unit("{36ac22c8-9737-4bdc-b59e-fd0fb823daaa}", "Pump station"),
        cnt_unit("{7d517890-d7ea-4ede-9c73-5be252b96d3f}", "Oil derrick"),
        cnt_unit("{d4fd6053-a036-4adf-8395-beca84e9efbb}", "Container red 1"),
        cnt_unit("{edd392fd-f262-4609-84d3-c09f126478ee}", "Container red 2"),
        cnt_unit("{dc005e97-7820-4cce-bc0e-edd875baaf92}", "Container red 3"),
        cnt_unit("{662e6cea-5a59-473f-87e9-e34d01f1ddb7}", "Container white"),
        cnt_unit("{d55f444b-745a-4954-bd4c-0ea1781f67a7}", "Container brown"),
        cnt_unit("{7f3722ae-10bc-49c5-a3cc-68ab89878c5b}", "Barracks 1"),
        cnt_unit("{eb3bac2d-4c24-4ff8-8c8a-dcd3d0c98750}", "Barracks 2"),
        cnt_unit("{a056cc08-9b50-45b1-b798-e0eb4277ea86}", "Military staff"),
        cnt_unit("{2b1802df-c4f9-404f-afe1-5f291ef68d30}", "Watchtower"),
        cnt_unit("{e9e4e232-b0c8-4306-b013-2f9defbb04d1}", "Hangar B"),
        cnt_unit("{07a6695a-2373-489f-a0a0-e1e35dd03b85}", "Fuel tank"),
        cnt_unit("{25f698c7-ee7b-40be-bafb-d97e64c487f3}", "Shelter B"),
        cnt_unit("{e0f6d8f9-0692-4695-933b-6e87636c7acb}", "Oil platform"),
        cnt_unit("{6d518ff5-cfca-4a7c-921b-ee3621a4207d}", "Subsidiary structure 1"),
        cnt_unit("{47a39247-7989-4f6d-bbb8-2cdd40e012dd}", "Subsidiary structure 2"),
        cnt_unit("{e58952f4-d2e9-43bc-a5ea-854d4678ef96}", "Subsidiary structure 3"),
        cnt_unit("{394ff644-013b-4f88-bfe1-1277cbcba8cc}", "Subsidiary structure A"),
        cnt_unit("{c724c713-61ad-4fb0-807d-dc6eb4a89884}", "Subsidiary structure B"),
        cnt_unit("{162b2803-ddf1-4b0e-9b95-b45b2f35ee30}", "Subsidiary structure C"),
        cnt_unit("{9cbba4f7-7014-4f67-b69a-4a458e5f2420}", "Subsidiary structure D"),
        cnt_unit("{dbb8c3f5-f1ea-42e1-b486-482ef41a4e53}", "Subsidiary structure E"),
        cnt_unit("{74e14790-da2b-4269-bd94-0bfa2dee0031}", "Subsidiary structure F"),
        cnt_unit("{96fc5825-e329-468d-83d8-fc9326d8aa52}", "Subsidiary structure G"),
        cnt_unit("{30D37BB2-F438-45ae-B09D-F00B1EFCB790}", "Landmine"),
        cnt_unit("{7c9d05ea-0b54-4d5c-9d6f-fa2cde39e349}", "FARP Ammo Dump Coating"),
        cnt_unit("{80c39fb0-854f-461b-bc4b-b2b51d0c4139}", "FARP Tent"),
        cnt_unit("{a947d0fd-9268-4851-a885-cb59aebe9bbc}", "FARP CP Blindage"),
        cnt_unit("{3441baf3-7ff7-4d76-ab9e-77f768b7813f}", "FARP Fuel Depot"),
        cnt_unit("{7e58d67d-191e-4e2c-ad22-a9c50cd48f53}", "GeneratorF"),
      },
    },
  },
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Air Medal', _('Air Medal'), 200, 'US-01-AirMedal.png'),
    award('Purple Heart', _('Purple Heart'), 600, 'US-02-PurpleHeart.png'),
    award('Bronze Star', _('Bronze Star'), 1000, 'US-03-BronzeStar.png'),
    award('Airmans Medal', _('Airmans Medal'), 1400, 'US-04-AirmansMedal.png'),
    award('Distinguished Flying Cross', _('Distinguished Flying Cross'), 1800, 'US-05-DistinguishedFlyingCross.png'),
    award('Silver Star', _('Silver Star'), 2200, 'US-06-SilverStar.png'),
    award('Air Force Cross', _('Air Force Cross'), 2600, 'US-07-AirForceCross.png'),
    award('Air Force Medal of Honour', _('Air Force Medal of Honour'), 3000, 'US-08-AirForceMedalOfHonour.png'),
  },
  'USA.lua',
    {0,30,64,30}
);

country("{B58A534C-7F5F-489A-952A-B315A9DC2039}", _("Turkey"), "Turkey", "TUR", "Turkey.png", 3,
  {
    Planes =
    {
      CATID = "{C168A850-3C0B-436a-95B5-C4A015552560}",
      Plane =
      {
        cnt_unit("{B5B20CFE-3D22-4EC0-A5C4-DDCDD68B5318}", "F-16C bl.50", {
          color_scheme("{D8380D76-409C-4ca2-B8B9-E8C4DFEADD43}", "AF F16 Standart"),
        }),
        cnt_unit("{4B75FEBA-9997-4D34-A0D6-0DB061350951}", "F-4E", {
          color_scheme("{D3697861-0EC9-47f2-A661-2E927D88AF66}", "AF Standart"),
        }),
        cnt_unit("{569949FE-CE95-4D94-BF76-7B809B8DACD0}", "F-5E", {
          color_scheme("{169AF192-1F88-4BD4-9100-0A831AF890BD}", "AF Standart"),
        }),
        cnt_unit("{0213FA86-978D-4586-BAC3-BD642AD52B96}", "C-130", {
          color_scheme("{E78C7F44-E50A-47e5-94D5-6BA36167CE8C}", "12 nci HUAUK, 222 FILO \"ALEV\""),
        }),
      },
    },
    Heliports =
    {
      CATID = "{E6490BAB-7129-4d23-9023-1CFE810886EF}",
      Heliport =
      {
        cnt_unit("{24FC9197-F225-4f2a-8A31-BD51DC7BDAB6}", "FARP"),
      },
    },
    Ships =
    {
      CATID = "{AAFD44F1-C080-4572-9465-3A52C46F2A45}",
      Ship =
      {
        cnt_unit("{AA4986BF-CBC4-48B6-AEEA-07E564FADB8B}", "PERRY"),
        cnt_unit("{6449989a-2f92-48ed-89bf-d0ae87176cb3}", "speedboat"),
      },
    },
    Cars =
    {
      CATID = "{6CAE2420-8E36-40f3-8586-E853AADB9199}",
      Car =
      {
        cnt_unit("{3BDD3518-974C-49EB-8746-54A8DD91C14F}", "M-113"),
        cnt_unit("{6E93EACB-F7DB-4208-88C4-8D6465869A05}", "Hawk sr"),
        cnt_unit("{6FD50C44-10A0-458F-AF4E-0472EEFCD07E}", "Hawk tr"),
        cnt_unit("{DEAC9323-0320-482A-A4DC-DC7ABCB4B987}", "Hawk ln"),
        cnt_unit("{5A76E1FB-E73B-4D93-B61B-967AB6F87508}", "Hummer"),
        cnt_unit("{0EDE3912-F55C-402a-95AF-36BB3106BEA2}", "M 818"),
        cnt_unit("{A3CA58E6-EBE9-4D9F-A6A2-0D295F85D306}", "M-60"),
        cnt_unit("{3C8BFE7F-E0B6-4FF7-8DCD-CC165BE5D5BC}", "MLRS"),
        cnt_unit("{B350FDB3-E7DA-4DF3-9F59-0DADD5933EEB}", "M1097 Avenger"),
        cnt_unit("{AC83CA0F-E7D9-4A25-9B1F-0CC163FA1684}", "Vulcan"),
        cnt_unit("{A543AD97-7C33-4655-9A9A-FDB9F1D42248}", "M-109"),
        cnt_unit("{E0B4364A-3E12-4DE3-84F2-F29EFAE17BED}", "AAV7"),
        cnt_unit("{6416E353-E50F-497f-9F7A-51A99788E18E}", "M48 Chaparral"),
        cnt_unit("{10C3BD0E-4494-4bc4-BC37-2C544E33ADC7}", "BTR-80"),
        cnt_unit("{B84C5FC5-9893-45e4-A712-E3D4D201A003}", "Stinger manpad"),
        cnt_unit("{DFC5C4AA-EFE7-4929-A305-B8785BCD6704}", "Stinger comm"),
        cnt_unit("{2CAB63C2-2773-47EC-BAE0-F36D895486B9}", "M978 HEMTT Tanker"),
        cnt_unit("{16263664-B3F8-4DA7-B61D-BF2445D3C469}", "Leopard1A3"),
      },
    },
    Helicopters =
    {
      CATID = "{828CEADE-3F1D-40aa-93CE-8CDB73FE2710}",
      Helicopter =
      {
        cnt_unit("{8CC2AAFA-F5F6-498D-83E0-681561D691B8}", "UH-60A", {
          color_scheme("{FEA21BC0-A211-47E3-9FEF-A4043A04B6D3}", "Standard"),
        }),
        cnt_unit("{C08CF845-F905-40F0-AF1B-554908BBE89E}", "Mi-8MT", {
          color_scheme("{5B02BC84-3BEC-4f7f-843F-162C7CADF027}", "Standard2"),
        }),
        cnt_unit("{D49A54A7-1607-4779-88EE-7D4EF529CF5C}", "AH-1W", {
          color_scheme("{0ACC12BA-C80F-4b61-B917-8831A95F64DF}", ""),
          color_scheme("{4B46E538-9C90-4c7d-BA25-E54C70A799B1}", ""),
        }),
        cnt_unit("{3457BB1E-523F-4C24-BBEA-58D028623F05}", "Ka-50", {
          color_scheme("{F7C01B4D-5F60-4de9-8C37-F9383EE0B844}", "Fictional Turkey scheme"),
          color_scheme("{F4FE8642-0E60-4def-BA9A-30371C4E7B3E}", "Fictional USMC Gray scheme"),
          color_scheme("{945E24E7-1725-41e8-96CF-76DBEADD1C9E}", "Fictional Desert1 scheme"),
          color_scheme("{7763F118-610B-44f6-81A0-7CACCBB80BBD}", "Fictional Turkey1 skin"),

        }),
      },
    },
    Fortifications =
    {
      CATID = "{7F1597F0-88EB-41cb-A04E-E9A4D5EF7466}",
      Fortification =
      {
        cnt_unit("{79BEF6B1-03EE-40A5-9D67-FE369D67D8F3}", "Locomotive"),
        cnt_unit("{5D159ABA-28C6-4E6A-BD41-B295AFA4E108}", "Electric locomotive"),
        cnt_unit("{A65C983E-3615-4350-93B2-128CBA8B3569}", "Coach a tank"),
        cnt_unit("{066A8FCF-6591-457C-888A-AF443AF95084}", "Coach cargo"),
        cnt_unit("{AA5E677A-BE23-4752-8C1A-24E25EC148CC}", "Coach cargo open"),
        cnt_unit("{77348759-616D-4500-9AB8-701D9F8028CD}", "Coach a platform"),
        cnt_unit("{8B096AEA-9E18-4541-8120-0DAB3BC57170}", "Coach a passenger"),
        cnt_unit("{71AC463C-310A-41ce-B7E7-923AC3CA5EDC}", ".Block"),
        cnt_unit("{B54053A8-B054-4a0b-871C-6DDA65ED90EF}", ".Block on road"),
        cnt_unit("{20A1B146-07C6-4ee6-851C-DBBC92135446}", ".Bunker"),
        cnt_unit("{2848C193-6789-472c-8430-AF3D739BB6C8}", ".Pill-box"),
        cnt_unit("{64DE4673-7D3E-424f-AB29-F4336AC38F98}", ".Command Center"),
        cnt_unit("{85D3DBF2-05DF-48e1-9C49-FD104E65A76E}", ".Ammunition depot"),
        cnt_unit("{7c822c60-9885-4a44-8add-b87511ff0fc5}", "Hangar A"),
        cnt_unit("{f0f48213-396f-4cc2-9fec-2f308cb11154}", "Tank"),
        cnt_unit("{b0e8ef18-c50c-4695-ac6e-1033b3691ce2}", "Tech hangar A"),
        cnt_unit("{db4d86a5-f9d6-4db1-b6ff-72153d082fc8}", "Farm A"),
        cnt_unit("{d406d212-8425-41be-83a1-502864f221dd}", "Farm B"),
        cnt_unit("{e8f80c05-dd74-4ce4-a232-f29afa025c3b}", "Garage A"),
        cnt_unit("{c5f17833-f456-45be-8c7c-ab28996f0e85}", "Boiler-house A"),
        cnt_unit("{65c10c17-e726-46d4-a380-db42706b923f}", "Restaurant 1"),
        cnt_unit("{80af40db-22ac-4e42-ab24-a015d1a21311}", "Warehouse"),
        cnt_unit("{fe75a842-e794-4650-9197-22797513dc72}", "Comms tower M"),
        cnt_unit("{70bf5fc8-441f-47cb-b587-d8f36ab81600}", "Cafe"),
        cnt_unit("{bddc2805-fd70-47dd-90b0-0041ebd1eee3}", "Workshop A"),
        cnt_unit("{7d0fa1db-38a1-4bf8-9169-943e11d49001}", "Electric power box"),
        cnt_unit("{d161a6b7-3946-49b2-af4c-aef104809480}", "Supermarket A"),
        cnt_unit("{1a4b08df-98c6-45da-bfea-161d7ad0135f}", "Water tower A"),
        cnt_unit("{cc06c05a-da19-494c-8066-04bb6b2f375b}", "TV tower"),
        cnt_unit("{2fe5cb79-1395-4b34-a112-913e964534e9}", "Shelter"),
        cnt_unit("{56c3c279-31f6-4cb9-ba63-6025f14adb08}", "Repair workshop"),
        cnt_unit("{4d01350e-eac5-406a-8daf-a1e1cc74c03b}", "Railway station"),
        cnt_unit("{557eab86-9e3d-459f-880b-3bfbd3b397fe}", "Railway crossing A"),
        cnt_unit("{8ff4a140-121e-4b25-a7e1-72bf64a3645c}", "Railway crossing B"),
        cnt_unit("{044858e2-4d40-4702-a185-70ee80f07151}", "WC"),
        cnt_unit("{72c629a7-112d-4a3e-9032-ba62dab2e36d}", "Small house 1A area"),
        cnt_unit("{40cf54da-bdb2-4993-a619-f5504200c3f5}", "Small house 1A"),
        cnt_unit("{95dbcac0-35e6-4621-bb02-a500666e337e}", "Small house 1B area"),
        cnt_unit("{8b22a3fd-8d96-4320-81b5-04f2c9edb247}", "Small house 1B"),
        cnt_unit("{7ae8526a-0edc-46ca-bf03-a1dc10445fcd}", "Small house 1C area"),
        cnt_unit("{9f6a6842-f5a5-4953-871b-58e0a2278849}", "Small house 2C"),
        cnt_unit("{aa0f2150-ed5c-4b66-8c7a-39ab3bccf5e3}", "Shop"),
        cnt_unit("{0a4804d2-db83-4a18-bf2a-a253a9b17e33}", "Tech combine"),
        cnt_unit("{264c3fb6-7871-471a-8915-a68afe98fbb5}", "Chemical tank A"),
        cnt_unit("{2cca8015-d0a0-43f7-bc89-0bf1cf290246}", "Small werehouse 1"),
        cnt_unit("{14b9c61c-bf3a-4dff-939c-5f3d55351d4e}", "Small werehouse 2"),
        cnt_unit("{ffe9021e-7d44-4ab3-8df9-0696d2506148}", "Small werehouse 3"),
        cnt_unit("{4b6bcf8c-6e4c-485b-a8f3-ac4de3338b5f}", "Small werehouse 4"),
        cnt_unit("{e0b21ae2-029b-4c20-986c-9c469d69b2c8}", "Garage B"),
        cnt_unit("{70a0edf9-c9bd-42c8-b260-e97927ebaaaa}", "Garage small A"),
        cnt_unit("{e4322f04-ba0d-43db-afe9-16025738ebeb}", "Garage small B"),
        cnt_unit("{36ac22c8-9737-4bdc-b59e-fd0fb823daaa}", "Pump station"),
        cnt_unit("{7d517890-d7ea-4ede-9c73-5be252b96d3f}", "Oil derrick"),
        cnt_unit("{d4fd6053-a036-4adf-8395-beca84e9efbb}", "Container red 1"),
        cnt_unit("{edd392fd-f262-4609-84d3-c09f126478ee}", "Container red 2"),
        cnt_unit("{dc005e97-7820-4cce-bc0e-edd875baaf92}", "Container red 3"),
        cnt_unit("{662e6cea-5a59-473f-87e9-e34d01f1ddb7}", "Container white"),
        cnt_unit("{d55f444b-745a-4954-bd4c-0ea1781f67a7}", "Container brown"),
        cnt_unit("{7f3722ae-10bc-49c5-a3cc-68ab89878c5b}", "Barracks 1"),
        cnt_unit("{eb3bac2d-4c24-4ff8-8c8a-dcd3d0c98750}", "Barracks 2"),
        cnt_unit("{a056cc08-9b50-45b1-b798-e0eb4277ea86}", "Military staff"),
        cnt_unit("{2b1802df-c4f9-404f-afe1-5f291ef68d30}", "Watchtower"),
        cnt_unit("{e9e4e232-b0c8-4306-b013-2f9defbb04d1}", "Hangar B"),
        cnt_unit("{07a6695a-2373-489f-a0a0-e1e35dd03b85}", "Fuel tank"),
        cnt_unit("{25f698c7-ee7b-40be-bafb-d97e64c487f3}", "Shelter B"),
        cnt_unit("{e0f6d8f9-0692-4695-933b-6e87636c7acb}", "Oil platform"),
        cnt_unit("{6d518ff5-cfca-4a7c-921b-ee3621a4207d}", "Subsidiary structure 1"),
        cnt_unit("{47a39247-7989-4f6d-bbb8-2cdd40e012dd}", "Subsidiary structure 2"),
        cnt_unit("{e58952f4-d2e9-43bc-a5ea-854d4678ef96}", "Subsidiary structure 3"),
        cnt_unit("{394ff644-013b-4f88-bfe1-1277cbcba8cc}", "Subsidiary structure A"),
        cnt_unit("{c724c713-61ad-4fb0-807d-dc6eb4a89884}", "Subsidiary structure B"),
        cnt_unit("{162b2803-ddf1-4b0e-9b95-b45b2f35ee30}", "Subsidiary structure C"),
        cnt_unit("{9cbba4f7-7014-4f67-b69a-4a458e5f2420}", "Subsidiary structure D"),
        cnt_unit("{dbb8c3f5-f1ea-42e1-b486-482ef41a4e53}", "Subsidiary structure E"),
        cnt_unit("{74e14790-da2b-4269-bd94-0bfa2dee0031}", "Subsidiary structure F"),
        cnt_unit("{96fc5825-e329-468d-83d8-fc9326d8aa52}", "Subsidiary structure G"),
        cnt_unit("{30D37BB2-F438-45ae-B09D-F00B1EFCB790}", "Landmine"),
        cnt_unit("{7c9d05ea-0b54-4d5c-9d6f-fa2cde39e349}", "FARP Ammo Dump Coating"),
        cnt_unit("{80c39fb0-854f-461b-bc4b-b2b51d0c4139}", "FARP Tent"),
        cnt_unit("{a947d0fd-9268-4851-a885-cb59aebe9bbc}", "FARP CP Blindage"),
        cnt_unit("{3441baf3-7ff7-4d76-ab9e-77f768b7813f}", "FARP Fuel Depot"),
        cnt_unit("{7e58d67d-191e-4e2c-ad22-a9c50cd48f53}", "GeneratorF"),
      },
    },
  },
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Liakat Medal', _('Liakat Medal'), 200,  'TUR-01-Liakat_Medal.png'),
    award('Success Medal', _('Success Medal'), 600,  'TUR-02-Succes_Medal.png'),
    award('Superior Service Medal', _('Superior Service Medal'), 1200, 'TUR-03-Superior_Service.png'),
    award('Superior Braveness Medal', _('Superior Braveness Medal'), 1800, 'TUR-04-Superior_Braveness_Medal.png'),
    award('Service and Praise Medal', _('Service and Praise Medal'), 2400, 'TUR-05-Service_and_Praise_Medal.png'),
    award('Medal of Honour', _('Medal of Honour'), 3000, 'TUR-06-Honour_Medal.png'),                                                                           
  },                                         
  'Turkey.lua',
  {0,330,64,30}
);

country("{C3F02860-1938-4233-843B-2CCF273FA12A}", _("Germany"), "Germany", "GER", "Germany.png", 6,
  {
    Planes =
    {
      CATID = "{C168A850-3C0B-436a-95B5-C4A015552560}",
      Plane =
      {
        cnt_unit("{5B1614EC-FF32-4EDA-86BD-E580C5F0FF84}", "MiG-29G", {
          color_scheme("{ca4be5c1-fd59-41cc-b4ff-ddc7591e691b}", "Luftwaffe Gray early"),
          color_scheme("{f48fa8eb-754b-426e-8d66-48c9693615b2}", "Luftwaffe Gray-1"),
          color_scheme("{bce3518f-93a3-4356-94b3-3a2fa55209d5}", "Luftwaffe Gray-2(worn-out)"),
          color_scheme("{dd9f98d2-4b08-4934-8b93-4024bb7778f8}", "Luftwaffe Gray-3"),
          color_scheme("{91bed26c-d706-4c77-aada-fc02f05fa15c}", "Luftwaffe Gray-4"),
          color_scheme("{57426db8-0904-439d-bb2d-63c8fda1c636}", "Luftwaffe 29+20 Demo"),
        }),
        cnt_unit("{4B75FEBA-9997-4D34-A0D6-0DB061350951}", "F-4E", {
          color_scheme("{8B0C0047-C1A3-4643-A4E4-18C93B16E6AA}", "AF Standart"),
        }),
        cnt_unit("{4AED1A01-FA09-11d5-9190-00A0249B6F00}", "Tornado IDS", {
          color_scheme("{de8491a1-1db8-4d2a-857d-0060d3dd744f}", "Aufklarungsgeschwader 51 \"Immelmann\" Jagel AB Luftwaffe"),
          color_scheme("{1ee530c6-932c-4a0d-867d-39d29b1766c6}", "Marinefliegergeschwader 2 Eggebek AB Marineflieger"),
          color_scheme("{f9539980-830f-4187-b518-d62fa443a089}", "Jagdbombergeschwader 31 \"Boelcke\" Norvenich AB Luftwaffe"),
          color_scheme("{42fb9075-3910-402e-a3c7-abae21772e87}", "Jagdbombergeschwader 32 Lechfeld AB Luftwaffe"),
          color_scheme("{f8f12b12-3516-487f-b97a-b3e8a1b1b6e6}", "Jagdbombergeschwader 33 Buchel AB No. 43+19 experimental scheme"),
        }),
      },
    },
    Heliports =
    {
      CATID = "{E6490BAB-7129-4d23-9023-1CFE810886EF}",
      Heliport =
      {
        cnt_unit("{24FC9197-F225-4f2a-8A31-BD51DC7BDAB6}", "FARP"),
      },
    },
    Ships =
    {
      CATID = "{AAFD44F1-C080-4572-9465-3A52C46F2A45}",
      Ship =
      {
        cnt_unit("{6449989a-2f92-48ed-89bf-d0ae87176cb3}", "speedboat"),
      },
    },
    Cars =
    {
      CATID = "{6CAE2420-8E36-40f3-8586-E853AADB9199}",
      Car =
      {
        cnt_unit("{3BDD3518-974C-49EB-8746-54A8DD91C14F}", "M-113"),
        cnt_unit("{BDFF2359-B329-479A-A4D2-A14F3FB37DE4}", "Patriot str"),
        cnt_unit("{572AF10E-0FAC-4E2D-BA3F-96D6C08194FB}", "Patriot ln"),
        cnt_unit("{6E93EACB-F7DB-4208-88C4-8D6465869A05}", "Hawk sr"),
        cnt_unit("{6FD50C44-10A0-458F-AF4E-0472EEFCD07E}", "Hawk tr"),
        cnt_unit("{DEAC9323-0320-482A-A4DC-DC7ABCB4B987}", "Hawk ln"),
        cnt_unit("{355F9BBF-7686-481E-A277-8BE23C862003}", "Roland ADS"),
        cnt_unit("{E7CF8850-522C-4EBA-AB32-0C4DF31B02FD}", "Roland Radar"),
        cnt_unit("{C657BA0E-3AB2-4983-8D1E-442FF877BCAF}", "Gepard"),
        cnt_unit("{5A76E1FB-E73B-4D93-B61B-967AB6F87508}", "Hummer"),
        cnt_unit("{DA962EC4-E7F3-4F85-8638-9535C56D6947}", "Leopard-2"),
        cnt_unit("{A543AD97-7C33-4655-9A9A-FDB9F1D42248}", "M-109"),
        cnt_unit("{EBCB3733-510B-4D4D-AD85-12078E50E61C}", "Marder"),
        cnt_unit("{A40029C2-84DB-4A8D-8E99-0B7AF4C95D04}", "TPZ"),
        cnt_unit("{3C8BFE7F-E0B6-4FF7-8DCD-CC165BE5D5BC}", "MLRS"),
        cnt_unit("{B84C5FC5-9893-45e4-A712-E3D4D201A003}", "Stinger manpad"),
        cnt_unit("{DFC5C4AA-EFE7-4929-A305-B8785BCD6704}", "Stinger comm"),
        cnt_unit("{033A717B-2687-4d74-9A89-69C2535DAC48}", "Patriot cp"),
        cnt_unit("{0EDE3912-F55C-402a-95AF-36BB3106BEA2}", "M 818"),
        cnt_unit("{2CAB63C2-2773-47EC-BAE0-F36D895486B9}", "M978 HEMTT Tanker"),
      },
    },
    Helicopters =
    {
      CATID = "{828CEADE-3F1D-40aa-93CE-8CDB73FE2710}",
      Helicopter =
      {
      cnt_unit("{3457BB1E-523F-4C24-BBEA-58D028623F05}", "Ka-50", {
          color_scheme("{a435ac70-e01c-11dd-ad8b-0800200c9a66}", "German 8320"),
		  color_scheme("{2ac0a580-4a24-11de-8a39-0800200c9a66}", "German 8332"),
      }),
      },
    },
    Fortifications =
    {
      CATID = "{7F1597F0-88EB-41cb-A04E-E9A4D5EF7466}",
      Fortification =
      {
        cnt_unit("{79BEF6B1-03EE-40A5-9D67-FE369D67D8F3}", "Locomotive"),
        cnt_unit("{5D159ABA-28C6-4E6A-BD41-B295AFA4E108}", "Electric locomotive"),
        cnt_unit("{A65C983E-3615-4350-93B2-128CBA8B3569}", "Coach a tank"),
        cnt_unit("{066A8FCF-6591-457C-888A-AF443AF95084}", "Coach cargo"),
        cnt_unit("{AA5E677A-BE23-4752-8C1A-24E25EC148CC}", "Coach cargo open"),
        cnt_unit("{77348759-616D-4500-9AB8-701D9F8028CD}", "Coach a platform"),
        cnt_unit("{8B096AEA-9E18-4541-8120-0DAB3BC57170}", "Coach a passenger"),
        cnt_unit("{71AC463C-310A-41ce-B7E7-923AC3CA5EDC}", ".Block"),
        cnt_unit("{B54053A8-B054-4a0b-871C-6DDA65ED90EF}", ".Block on road"),
        cnt_unit("{20A1B146-07C6-4ee6-851C-DBBC92135446}", ".Bunker"),
        cnt_unit("{2848C193-6789-472c-8430-AF3D739BB6C8}", ".Pill-box"),
        cnt_unit("{64DE4673-7D3E-424f-AB29-F4336AC38F98}", ".Command Center"),
        cnt_unit("{85D3DBF2-05DF-48e1-9C49-FD104E65A76E}", ".Ammunition depot"),
        cnt_unit("{7c822c60-9885-4a44-8add-b87511ff0fc5}", "Hangar A"),
        cnt_unit("{f0f48213-396f-4cc2-9fec-2f308cb11154}", "Tank"),
        cnt_unit("{b0e8ef18-c50c-4695-ac6e-1033b3691ce2}", "Tech hangar A"),
        cnt_unit("{db4d86a5-f9d6-4db1-b6ff-72153d082fc8}", "Farm A"),
        cnt_unit("{d406d212-8425-41be-83a1-502864f221dd}", "Farm B"),
        cnt_unit("{e8f80c05-dd74-4ce4-a232-f29afa025c3b}", "Garage A"),
        cnt_unit("{c5f17833-f456-45be-8c7c-ab28996f0e85}", "Boiler-house A"),
        cnt_unit("{65c10c17-e726-46d4-a380-db42706b923f}", "Restaurant 1"),
        cnt_unit("{80af40db-22ac-4e42-ab24-a015d1a21311}", "Warehouse"),
        cnt_unit("{fe75a842-e794-4650-9197-22797513dc72}", "Comms tower M"),
        cnt_unit("{70bf5fc8-441f-47cb-b587-d8f36ab81600}", "Cafe"),
        cnt_unit("{bddc2805-fd70-47dd-90b0-0041ebd1eee3}", "Workshop A"),
        cnt_unit("{7d0fa1db-38a1-4bf8-9169-943e11d49001}", "Electric power box"),
        cnt_unit("{d161a6b7-3946-49b2-af4c-aef104809480}", "Supermarket A"),
        cnt_unit("{1a4b08df-98c6-45da-bfea-161d7ad0135f}", "Water tower A"),
        cnt_unit("{cc06c05a-da19-494c-8066-04bb6b2f375b}", "TV tower"),
        cnt_unit("{2fe5cb79-1395-4b34-a112-913e964534e9}", "Shelter"),
        cnt_unit("{56c3c279-31f6-4cb9-ba63-6025f14adb08}", "Repair workshop"),
        cnt_unit("{4d01350e-eac5-406a-8daf-a1e1cc74c03b}", "Railway station"),
        cnt_unit("{557eab86-9e3d-459f-880b-3bfbd3b397fe}", "Railway crossing A"),
        cnt_unit("{8ff4a140-121e-4b25-a7e1-72bf64a3645c}", "Railway crossing B"),
        cnt_unit("{044858e2-4d40-4702-a185-70ee80f07151}", "WC"),
        cnt_unit("{72c629a7-112d-4a3e-9032-ba62dab2e36d}", "Small house 1A area"),
        cnt_unit("{40cf54da-bdb2-4993-a619-f5504200c3f5}", "Small house 1A"),
        cnt_unit("{95dbcac0-35e6-4621-bb02-a500666e337e}", "Small house 1B area"),
        cnt_unit("{8b22a3fd-8d96-4320-81b5-04f2c9edb247}", "Small house 1B"),
        cnt_unit("{7ae8526a-0edc-46ca-bf03-a1dc10445fcd}", "Small house 1C area"),
        cnt_unit("{9f6a6842-f5a5-4953-871b-58e0a2278849}", "Small house 2C"),
        cnt_unit("{aa0f2150-ed5c-4b66-8c7a-39ab3bccf5e3}", "Shop"),
        cnt_unit("{0a4804d2-db83-4a18-bf2a-a253a9b17e33}", "Tech combine"),
        cnt_unit("{264c3fb6-7871-471a-8915-a68afe98fbb5}", "Chemical tank A"),
        cnt_unit("{2cca8015-d0a0-43f7-bc89-0bf1cf290246}", "Small werehouse 1"),
        cnt_unit("{14b9c61c-bf3a-4dff-939c-5f3d55351d4e}", "Small werehouse 2"),
        cnt_unit("{ffe9021e-7d44-4ab3-8df9-0696d2506148}", "Small werehouse 3"),
        cnt_unit("{4b6bcf8c-6e4c-485b-a8f3-ac4de3338b5f}", "Small werehouse 4"),
        cnt_unit("{e0b21ae2-029b-4c20-986c-9c469d69b2c8}", "Garage B"),
        cnt_unit("{70a0edf9-c9bd-42c8-b260-e97927ebaaaa}", "Garage small A"),
        cnt_unit("{e4322f04-ba0d-43db-afe9-16025738ebeb}", "Garage small B"),
        cnt_unit("{36ac22c8-9737-4bdc-b59e-fd0fb823daaa}", "Pump station"),
        cnt_unit("{7d517890-d7ea-4ede-9c73-5be252b96d3f}", "Oil derrick"),
        cnt_unit("{d4fd6053-a036-4adf-8395-beca84e9efbb}", "Container red 1"),
        cnt_unit("{edd392fd-f262-4609-84d3-c09f126478ee}", "Container red 2"),
        cnt_unit("{dc005e97-7820-4cce-bc0e-edd875baaf92}", "Container red 3"),
        cnt_unit("{662e6cea-5a59-473f-87e9-e34d01f1ddb7}", "Container white"),
        cnt_unit("{d55f444b-745a-4954-bd4c-0ea1781f67a7}", "Container brown"),
        cnt_unit("{7f3722ae-10bc-49c5-a3cc-68ab89878c5b}", "Barracks 1"),
        cnt_unit("{eb3bac2d-4c24-4ff8-8c8a-dcd3d0c98750}", "Barracks 2"),
        cnt_unit("{a056cc08-9b50-45b1-b798-e0eb4277ea86}", "Military staff"),
        cnt_unit("{2b1802df-c4f9-404f-afe1-5f291ef68d30}", "Watchtower"),
        cnt_unit("{e9e4e232-b0c8-4306-b013-2f9defbb04d1}", "Hangar B"),
        cnt_unit("{07a6695a-2373-489f-a0a0-e1e35dd03b85}", "Fuel tank"),
        cnt_unit("{25f698c7-ee7b-40be-bafb-d97e64c487f3}", "Shelter B"),
        cnt_unit("{e0f6d8f9-0692-4695-933b-6e87636c7acb}", "Oil platform"),
        cnt_unit("{6d518ff5-cfca-4a7c-921b-ee3621a4207d}", "Subsidiary structure 1"),
        cnt_unit("{47a39247-7989-4f6d-bbb8-2cdd40e012dd}", "Subsidiary structure 2"),
        cnt_unit("{e58952f4-d2e9-43bc-a5ea-854d4678ef96}", "Subsidiary structure 3"),
        cnt_unit("{394ff644-013b-4f88-bfe1-1277cbcba8cc}", "Subsidiary structure A"),
        cnt_unit("{c724c713-61ad-4fb0-807d-dc6eb4a89884}", "Subsidiary structure B"),
        cnt_unit("{162b2803-ddf1-4b0e-9b95-b45b2f35ee30}", "Subsidiary structure C"),
        cnt_unit("{9cbba4f7-7014-4f67-b69a-4a458e5f2420}", "Subsidiary structure D"),
        cnt_unit("{dbb8c3f5-f1ea-42e1-b486-482ef41a4e53}", "Subsidiary structure E"),
        cnt_unit("{74e14790-da2b-4269-bd94-0bfa2dee0031}", "Subsidiary structure F"),
        cnt_unit("{96fc5825-e329-468d-83d8-fc9326d8aa52}", "Subsidiary structure G"),
        cnt_unit("{30D37BB2-F438-45ae-B09D-F00B1EFCB790}", "Landmine"),
        cnt_unit("{7c9d05ea-0b54-4d5c-9d6f-fa2cde39e349}", "FARP Ammo Dump Coating"),
        cnt_unit("{80c39fb0-854f-461b-bc4b-b2b51d0c4139}", "FARP Tent"),
        cnt_unit("{a947d0fd-9268-4851-a885-cb59aebe9bbc}", "FARP CP Blindage"),
        cnt_unit("{3441baf3-7ff7-4d76-ab9e-77f768b7813f}", "FARP Fuel Depot"),
        cnt_unit("{7e58d67d-191e-4e2c-ad22-a9c50cd48f53}", "GeneratorF"),
      },
    },
  },
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Ehrenmedaille', _('Ehrenmedaille'), 200,  'DE-01-Ehrenmedaille-Honor.png'),
    award('Ehrenkreuz', _('Ehrenkreuz'), 700,  'DE-02-Ehrenkreuze.png'),
    award('Ehrenkreuz in Silber', _('Ehrenkreuz in Silber'), 1200, 'DE-03-Silbernekreuze.png'),
    award('Ehrenkreuz in Gold', _('Ehrenkreuz in Gold'), 1800, 'DE-04-Goldenekreuze.png'),
    award('Bundesverdienstmedaille', _('Bundesverdienstmedaille'), 2400, 'DE-05-Bundesverdienstmedaille.png'),
    award('Bundesverdienstkreuz', _('Bundesverdienstkreuz'), 3000, 'DE-06-Bundesverdienstkreuz.png'),   
  },                                         
  'Germany.lua',
  {0,210,64,30}
);

country("{32A0DDDF-E2C1-4F0B-A3AD-17719BB371F2}", _("Canada"), "Canada", "CAN", "Canada.png", 8,
  {
    Planes =
    {
      CATID = "{C168A850-3C0B-436a-95B5-C4A015552560}",
      Plane =
      {
        cnt_unit("{2C4C5E81-F950-11d5-9190-00A0249B6F00}", "F/A-18C", {
          color_scheme("{3b1d19d0-2967-4ff7-8b04-d4c5933010a4}", "4th Wing 410th TFS RCAF (Cold Lake AB)"),
          color_scheme("{e1324da4-ad2c-438f-a5f4-bde36e9d987a}", "4th Wing 416th TFS RCAF (Cold Lake AB)"),
          color_scheme("{83342ad3-f476-4802-b01a-e2aff2e500ad}", "4th Wing 441th TFS RCAF (Cold Lake AB)"),
          color_scheme("{fcb5be6e-9d76-4f6d-8bfe-ec04b03e308c}", "3d Wing 425th TFS RCAF (Bagotville AB)"),
          color_scheme("{72a82f1f-7d51-44fe-81ef-f87fabe0eaf1}", "3d Wing 433th TFS RCAF (Bagotville AB)"),
        }),
        cnt_unit("{0213FA86-978D-4586-BAC3-BD642AD52B96}", "C-130", {
          color_scheme("{e168a397-dbd6-4ffd-a15c-438229d31797}", "Standart"),
        }),
      },
    },
    Heliports =
    {
      CATID = "{E6490BAB-7129-4d23-9023-1CFE810886EF}",
      Heliport =
      {
        cnt_unit("{24FC9197-F225-4f2a-8A31-BD51DC7BDAB6}", "FARP"),
      },
    },
    Ships =
    {
      CATID = "{AAFD44F1-C080-4572-9465-3A52C46F2A45}",
      Ship =
      {
        cnt_unit("{6449989a-2f92-48ed-89bf-d0ae87176cb3}", "speedboat"),
      },
    },
    Cars =
    {
      CATID = "{6CAE2420-8E36-40f3-8586-E853AADB9199}",
      Car =
      {
        cnt_unit("{3BDD3518-974C-49EB-8746-54A8DD91C14F}", "M-113"),
        cnt_unit("{5A76E1FB-E73B-4D93-B61B-967AB6F87508}", "Hummer"),
        cnt_unit("{E982CA60-4C43-4C6A-A524-BF250D54E742}", "LAV-25"),
        cnt_unit("{A543AD97-7C33-4655-9A9A-FDB9F1D42248}", "M-109"),
        cnt_unit("{B84C5FC5-9893-45e4-A712-E3D4D201A003}", "Stinger manpad"),
        cnt_unit("{DFC5C4AA-EFE7-4929-A305-B8785BCD6704}", "Stinger comm"),
        cnt_unit("{0EDE3912-F55C-402a-95AF-36BB3106BEA2}", "M 818"),
        cnt_unit("{2CAB63C2-2773-47EC-BAE0-F36D895486B9}", "M978 HEMTT Tanker"),
        cnt_unit("{16263664-B3F8-4DA7-B61D-BF2445D3C469}", "Leopard1A3"),
      },
    },
    Helicopters =
    {
      CATID = "{828CEADE-3F1D-40aa-93CE-8CDB73FE2710}",
      Helicopter =
      {cnt_unit("{3457BB1E-523F-4C24-BBEA-58D028623F05}", "Ka-50", {
          color_scheme("{F932C0BF-A200-4f43-A3A5-73E860AB0A26}", "Canadian Forces"),
        }),
      },
    },
    Fortifications =
    {
      CATID = "{7F1597F0-88EB-41cb-A04E-E9A4D5EF7466}",
      Fortification =
      {
        cnt_unit("{79BEF6B1-03EE-40A5-9D67-FE369D67D8F3}", "Locomotive"),
        cnt_unit("{5D159ABA-28C6-4E6A-BD41-B295AFA4E108}", "Electric locomotive"),
        cnt_unit("{A65C983E-3615-4350-93B2-128CBA8B3569}", "Coach a tank"),
        cnt_unit("{066A8FCF-6591-457C-888A-AF443AF95084}", "Coach cargo"),
        cnt_unit("{AA5E677A-BE23-4752-8C1A-24E25EC148CC}", "Coach cargo open"),
        cnt_unit("{77348759-616D-4500-9AB8-701D9F8028CD}", "Coach a platform"),
        cnt_unit("{8B096AEA-9E18-4541-8120-0DAB3BC57170}", "Coach a passenger"),
        cnt_unit("{71AC463C-310A-41ce-B7E7-923AC3CA5EDC}", ".Block"),
        cnt_unit("{B54053A8-B054-4a0b-871C-6DDA65ED90EF}", ".Block on road"),
        cnt_unit("{20A1B146-07C6-4ee6-851C-DBBC92135446}", ".Bunker"),
        cnt_unit("{2848C193-6789-472c-8430-AF3D739BB6C8}", ".Pill-box"),
        cnt_unit("{64DE4673-7D3E-424f-AB29-F4336AC38F98}", ".Command Center"),
        cnt_unit("{85D3DBF2-05DF-48e1-9C49-FD104E65A76E}", ".Ammunition depot"),
        cnt_unit("{7c822c60-9885-4a44-8add-b87511ff0fc5}", "Hangar A"),
        cnt_unit("{f0f48213-396f-4cc2-9fec-2f308cb11154}", "Tank"),
        cnt_unit("{b0e8ef18-c50c-4695-ac6e-1033b3691ce2}", "Tech hangar A"),
        cnt_unit("{db4d86a5-f9d6-4db1-b6ff-72153d082fc8}", "Farm A"),
        cnt_unit("{d406d212-8425-41be-83a1-502864f221dd}", "Farm B"),
        cnt_unit("{e8f80c05-dd74-4ce4-a232-f29afa025c3b}", "Garage A"),
        cnt_unit("{c5f17833-f456-45be-8c7c-ab28996f0e85}", "Boiler-house A"),
        cnt_unit("{65c10c17-e726-46d4-a380-db42706b923f}", "Restaurant 1"),
        cnt_unit("{80af40db-22ac-4e42-ab24-a015d1a21311}", "Warehouse"),
        cnt_unit("{fe75a842-e794-4650-9197-22797513dc72}", "Comms tower M"),
        cnt_unit("{70bf5fc8-441f-47cb-b587-d8f36ab81600}", "Cafe"),
        cnt_unit("{bddc2805-fd70-47dd-90b0-0041ebd1eee3}", "Workshop A"),
        cnt_unit("{7d0fa1db-38a1-4bf8-9169-943e11d49001}", "Electric power box"),
        cnt_unit("{d161a6b7-3946-49b2-af4c-aef104809480}", "Supermarket A"),
        cnt_unit("{1a4b08df-98c6-45da-bfea-161d7ad0135f}", "Water tower A"),
        cnt_unit("{cc06c05a-da19-494c-8066-04bb6b2f375b}", "TV tower"),
        cnt_unit("{2fe5cb79-1395-4b34-a112-913e964534e9}", "Shelter"),
        cnt_unit("{56c3c279-31f6-4cb9-ba63-6025f14adb08}", "Repair workshop"),
        cnt_unit("{4d01350e-eac5-406a-8daf-a1e1cc74c03b}", "Railway station"),
        cnt_unit("{557eab86-9e3d-459f-880b-3bfbd3b397fe}", "Railway crossing A"),
        cnt_unit("{8ff4a140-121e-4b25-a7e1-72bf64a3645c}", "Railway crossing B"),
        cnt_unit("{044858e2-4d40-4702-a185-70ee80f07151}", "WC"),
        cnt_unit("{72c629a7-112d-4a3e-9032-ba62dab2e36d}", "Small house 1A area"),
        cnt_unit("{40cf54da-bdb2-4993-a619-f5504200c3f5}", "Small house 1A"),
        cnt_unit("{95dbcac0-35e6-4621-bb02-a500666e337e}", "Small house 1B area"),
        cnt_unit("{8b22a3fd-8d96-4320-81b5-04f2c9edb247}", "Small house 1B"),
        cnt_unit("{7ae8526a-0edc-46ca-bf03-a1dc10445fcd}", "Small house 1C area"),
        cnt_unit("{9f6a6842-f5a5-4953-871b-58e0a2278849}", "Small house 2C"),
        cnt_unit("{aa0f2150-ed5c-4b66-8c7a-39ab3bccf5e3}", "Shop"),
        cnt_unit("{0a4804d2-db83-4a18-bf2a-a253a9b17e33}", "Tech combine"),
        cnt_unit("{264c3fb6-7871-471a-8915-a68afe98fbb5}", "Chemical tank A"),
        cnt_unit("{2cca8015-d0a0-43f7-bc89-0bf1cf290246}", "Small werehouse 1"),
        cnt_unit("{14b9c61c-bf3a-4dff-939c-5f3d55351d4e}", "Small werehouse 2"),
        cnt_unit("{ffe9021e-7d44-4ab3-8df9-0696d2506148}", "Small werehouse 3"),
        cnt_unit("{4b6bcf8c-6e4c-485b-a8f3-ac4de3338b5f}", "Small werehouse 4"),
        cnt_unit("{e0b21ae2-029b-4c20-986c-9c469d69b2c8}", "Garage B"),
        cnt_unit("{70a0edf9-c9bd-42c8-b260-e97927ebaaaa}", "Garage small A"),
        cnt_unit("{e4322f04-ba0d-43db-afe9-16025738ebeb}", "Garage small B"),
        cnt_unit("{36ac22c8-9737-4bdc-b59e-fd0fb823daaa}", "Pump station"),
        cnt_unit("{7d517890-d7ea-4ede-9c73-5be252b96d3f}", "Oil derrick"),
        cnt_unit("{d4fd6053-a036-4adf-8395-beca84e9efbb}", "Container red 1"),
        cnt_unit("{edd392fd-f262-4609-84d3-c09f126478ee}", "Container red 2"),
        cnt_unit("{dc005e97-7820-4cce-bc0e-edd875baaf92}", "Container red 3"),
        cnt_unit("{662e6cea-5a59-473f-87e9-e34d01f1ddb7}", "Container white"),
        cnt_unit("{d55f444b-745a-4954-bd4c-0ea1781f67a7}", "Container brown"),
        cnt_unit("{7f3722ae-10bc-49c5-a3cc-68ab89878c5b}", "Barracks 1"),
        cnt_unit("{eb3bac2d-4c24-4ff8-8c8a-dcd3d0c98750}", "Barracks 2"),
        cnt_unit("{a056cc08-9b50-45b1-b798-e0eb4277ea86}", "Military staff"),
        cnt_unit("{2b1802df-c4f9-404f-afe1-5f291ef68d30}", "Watchtower"),
        cnt_unit("{e9e4e232-b0c8-4306-b013-2f9defbb04d1}", "Hangar B"),
        cnt_unit("{07a6695a-2373-489f-a0a0-e1e35dd03b85}", "Fuel tank"),
        cnt_unit("{25f698c7-ee7b-40be-bafb-d97e64c487f3}", "Shelter B"),
        cnt_unit("{e0f6d8f9-0692-4695-933b-6e87636c7acb}", "Oil platform"),
        cnt_unit("{6d518ff5-cfca-4a7c-921b-ee3621a4207d}", "Subsidiary structure 1"),
        cnt_unit("{47a39247-7989-4f6d-bbb8-2cdd40e012dd}", "Subsidiary structure 2"),
        cnt_unit("{e58952f4-d2e9-43bc-a5ea-854d4678ef96}", "Subsidiary structure 3"),
        cnt_unit("{394ff644-013b-4f88-bfe1-1277cbcba8cc}", "Subsidiary structure A"),
        cnt_unit("{c724c713-61ad-4fb0-807d-dc6eb4a89884}", "Subsidiary structure B"),
        cnt_unit("{162b2803-ddf1-4b0e-9b95-b45b2f35ee30}", "Subsidiary structure C"),
        cnt_unit("{9cbba4f7-7014-4f67-b69a-4a458e5f2420}", "Subsidiary structure D"),
        cnt_unit("{dbb8c3f5-f1ea-42e1-b486-482ef41a4e53}", "Subsidiary structure E"),
        cnt_unit("{74e14790-da2b-4269-bd94-0bfa2dee0031}", "Subsidiary structure F"),
        cnt_unit("{96fc5825-e329-468d-83d8-fc9326d8aa52}", "Subsidiary structure G"),
        cnt_unit("{30D37BB2-F438-45ae-B09D-F00B1EFCB790}", "Landmine"),
        cnt_unit("{7c9d05ea-0b54-4d5c-9d6f-fa2cde39e349}", "FARP Ammo Dump Coating"),
        cnt_unit("{80c39fb0-854f-461b-bc4b-b2b51d0c4139}", "FARP Tent"),
        cnt_unit("{a947d0fd-9268-4851-a885-cb59aebe9bbc}", "FARP CP Blindage"),
        cnt_unit("{3441baf3-7ff7-4d76-ab9e-77f768b7813f}", "FARP Fuel Depot"),
        cnt_unit("{7e58d67d-191e-4e2c-ad22-a9c50cd48f53}", "GeneratorF"),
      },
    },
  },
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Medal of Bravery', _('Medal of Bravery'), 200,  'CA_01_Medal_of_Bravery.png'),
    award('Medal of Military Valour', _('Medal of Military Valour'), 600,  'CA_02_Medal_of_Military_Valour.png'),
    award('Meritorious Service Cross', _('Meritorious Service Cross'), 1000, 'CA_03_Meritorious_Service_Cross.png'),
    award('Star of Courage', _('Star of Courage'), 1400, 'CA_04_Star_of_Courage.png'),
    award('Star of Military Valour', _('Star of Military Valour'), 1800, 'CA_05_Star_of_Military_Valour.png'),
    award('The Order of Military Merit', _('The Order of Military Merit'), 2200, 'CA_06_The_Order_of_Military_Merit.png'),
    award('The Order of Canada', _('The Order of Canada'), 2600, 'CA_07_The_Order_of_Canada.png'),
    award('Cross of Valour', _('Cross of Valour'), 3000, 'CA_08_Cross_of_Valour.png'),            
  },                                      
  'Canada.lua',
    {0,90,64,30}
);

country("{67A95888-8FE1-46CC-BC30-95F2BC772551}", _("UK"), "UK", "UK", "UK.png", 4,
  {
    Planes =
    {
      CATID = "{C168A850-3C0B-436a-95B5-C4A015552560}",
      Plane =
      {
        cnt_unit("{C9F55068-5F03-4DC9-8D00-AEDC19710D01}", "Tornado GR3", {
          color_scheme("{5d94cabb-906e-4f1d-b28a-e18ea6be5727}", "BB of 14 Squadron RAF Lossiemouth"),
          color_scheme("{dc7d1f8e-b7ef-4bca-8c4b-fd965beefea6}", "O of II (AC) Squadron RAF Marham"),
          color_scheme("{1b96a699-b340-4f44-9377-a399726503ed}", "No. 9 Squadron RAF Marham AB (Norfolk)"),
          color_scheme("{5470a02b-1f4f-4575-a29c-d2b494cde3ad}", "No. 12 Squadron RAF Lossiemouth AB (Morayshire)"),
          color_scheme("{7a3ddd8b-18cb-4fe3-8e91-5cbd0bde0079}", "No. 14 Squadron RAF Lossiemouth AB (Morayshire)"),
          color_scheme("{9f102600-cbe6-4c68-9190-f9de9d187b5c}", "No. 617 Squadron RAF Lossiemouth AB (Morayshire)"),
        }),
        cnt_unit("{0213FA86-978D-4586-BAC3-BD642AD52B96}", "C-130", {
          color_scheme("{b4bb1272-8589-4ed4-aa9f-2abffad6177a}", "RAF Standart"),
        }),
--        cnt_unit("{e9dd44e3-9aa5-4055-84c4-6bf1d128148b}", "C-130", {
--          color_scheme("{897c8a9d-ce80-49eb-8c98-c5d2e6930347}", "RAF Standart"),
--        }),
      },
    },
    Heliports =
    {
      CATID = "{E6490BAB-7129-4d23-9023-1CFE810886EF}",
      Heliport =
      {
        cnt_unit("{24FC9197-F225-4f2a-8A31-BD51DC7BDAB6}", "FARP"),
      },
    },
    Ships =
    {
      CATID = "{AAFD44F1-C080-4572-9465-3A52C46F2A45}",
      Ship =
      {
        cnt_unit("{6449989a-2f92-48ed-89bf-d0ae87176cb3}", "speedboat"),
      },
    },
    Cars =
    {
      CATID = "{6CAE2420-8E36-40f3-8586-E853AADB9199}",
      Car =
      {
        cnt_unit("{4D1FFA57-1ADE-4A66-A034-DA87E7CC0CE0}", "MCV-80"),
        cnt_unit("{b735f6bf-7aad-4fff-baf0-c799d2dc34d3}", "Challenger2"),
        cnt_unit("{5A76E1FB-E73B-4D93-B61B-967AB6F87508}", "Hummer"),
        cnt_unit("{3C8BFE7F-E0B6-4FF7-8DCD-CC165BE5D5BC}", "MLRS"),
        cnt_unit("{0EDE3912-F55C-402a-95AF-36BB3106BEA2}", "M 818"),
      },
    },
    Helicopters =
    {
      CATID = "{828CEADE-3F1D-40aa-93CE-8CDB73FE2710}",
      Helicopter =
      {
        cnt_unit("{F324202D-A045-418B-86D0-7594454FDA81}", "AH-64A", {
          color_scheme("{12DFEF4D-3A51-4b99-96E0-F4E27B15DAF1}", "Standard"),
        }),
        cnt_unit("{F939FD3E-229F-4A9F-AE99-5CD4D60DE5F9}", "AH-64D", {
          color_scheme("{23B5E2BE-C93D-4803-AC5B-623ED239870E}", "Standard"),
        }),
        cnt_unit("{AF7808AC-A07C-470D-886B-505E8D23D317}", "CH-47D", {
          color_scheme("{F389D32E-E01A-4c3f-B464-EFF385DDB630}", "Standard"),
        }),
        cnt_unit("{3457BB1E-523F-4C24-BBEA-58D028623F05}", "Ka-50", {
          color_scheme("{13656800-ec4e-11dd-ba2f-0800200c9a66}", "UK Camo"),
        }),
      },
    },
    Fortifications =
    {
      CATID = "{7F1597F0-88EB-41cb-A04E-E9A4D5EF7466}",
      Fortification =
      {
        cnt_unit("{79BEF6B1-03EE-40A5-9D67-FE369D67D8F3}", "Locomotive"),
        cnt_unit("{5D159ABA-28C6-4E6A-BD41-B295AFA4E108}", "Electric locomotive"),
        cnt_unit("{A65C983E-3615-4350-93B2-128CBA8B3569}", "Coach a tank"),
        cnt_unit("{066A8FCF-6591-457C-888A-AF443AF95084}", "Coach cargo"),
        cnt_unit("{AA5E677A-BE23-4752-8C1A-24E25EC148CC}", "Coach cargo open"),
        cnt_unit("{77348759-616D-4500-9AB8-701D9F8028CD}", "Coach a platform"),
        cnt_unit("{8B096AEA-9E18-4541-8120-0DAB3BC57170}", "Coach a passenger"),
        cnt_unit("{71AC463C-310A-41ce-B7E7-923AC3CA5EDC}", ".Block"),
        cnt_unit("{B54053A8-B054-4a0b-871C-6DDA65ED90EF}", ".Block on road"),
        cnt_unit("{20A1B146-07C6-4ee6-851C-DBBC92135446}", ".Bunker"),
        cnt_unit("{2848C193-6789-472c-8430-AF3D739BB6C8}", ".Pill-box"),
        cnt_unit("{64DE4673-7D3E-424f-AB29-F4336AC38F98}", ".Command Center"),
        cnt_unit("{85D3DBF2-05DF-48e1-9C49-FD104E65A76E}", ".Ammunition depot"),
        cnt_unit("{7c822c60-9885-4a44-8add-b87511ff0fc5}", "Hangar A"),
        cnt_unit("{f0f48213-396f-4cc2-9fec-2f308cb11154}", "Tank"),
        cnt_unit("{b0e8ef18-c50c-4695-ac6e-1033b3691ce2}", "Tech hangar A"),
        cnt_unit("{db4d86a5-f9d6-4db1-b6ff-72153d082fc8}", "Farm A"),
        cnt_unit("{d406d212-8425-41be-83a1-502864f221dd}", "Farm B"),
        cnt_unit("{e8f80c05-dd74-4ce4-a232-f29afa025c3b}", "Garage A"),
        cnt_unit("{c5f17833-f456-45be-8c7c-ab28996f0e85}", "Boiler-house A"),
        cnt_unit("{65c10c17-e726-46d4-a380-db42706b923f}", "Restaurant 1"),
        cnt_unit("{80af40db-22ac-4e42-ab24-a015d1a21311}", "Warehouse"),
        cnt_unit("{fe75a842-e794-4650-9197-22797513dc72}", "Comms tower M"),
        cnt_unit("{70bf5fc8-441f-47cb-b587-d8f36ab81600}", "Cafe"),
        cnt_unit("{bddc2805-fd70-47dd-90b0-0041ebd1eee3}", "Workshop A"),
        cnt_unit("{7d0fa1db-38a1-4bf8-9169-943e11d49001}", "Electric power box"),
        cnt_unit("{d161a6b7-3946-49b2-af4c-aef104809480}", "Supermarket A"),
        cnt_unit("{1a4b08df-98c6-45da-bfea-161d7ad0135f}", "Water tower A"),
        cnt_unit("{cc06c05a-da19-494c-8066-04bb6b2f375b}", "TV tower"),
        cnt_unit("{2fe5cb79-1395-4b34-a112-913e964534e9}", "Shelter"),
        cnt_unit("{56c3c279-31f6-4cb9-ba63-6025f14adb08}", "Repair workshop"),
        cnt_unit("{4d01350e-eac5-406a-8daf-a1e1cc74c03b}", "Railway station"),
        cnt_unit("{557eab86-9e3d-459f-880b-3bfbd3b397fe}", "Railway crossing A"),
        cnt_unit("{8ff4a140-121e-4b25-a7e1-72bf64a3645c}", "Railway crossing B"),
        cnt_unit("{044858e2-4d40-4702-a185-70ee80f07151}", "WC"),
        cnt_unit("{72c629a7-112d-4a3e-9032-ba62dab2e36d}", "Small house 1A area"),
        cnt_unit("{40cf54da-bdb2-4993-a619-f5504200c3f5}", "Small house 1A"),
        cnt_unit("{95dbcac0-35e6-4621-bb02-a500666e337e}", "Small house 1B area"),
        cnt_unit("{8b22a3fd-8d96-4320-81b5-04f2c9edb247}", "Small house 1B"),
        cnt_unit("{7ae8526a-0edc-46ca-bf03-a1dc10445fcd}", "Small house 1C area"),
        cnt_unit("{9f6a6842-f5a5-4953-871b-58e0a2278849}", "Small house 2C"),
        cnt_unit("{aa0f2150-ed5c-4b66-8c7a-39ab3bccf5e3}", "Shop"),
        cnt_unit("{0a4804d2-db83-4a18-bf2a-a253a9b17e33}", "Tech combine"),
        cnt_unit("{264c3fb6-7871-471a-8915-a68afe98fbb5}", "Chemical tank A"),
        cnt_unit("{2cca8015-d0a0-43f7-bc89-0bf1cf290246}", "Small werehouse 1"),
        cnt_unit("{14b9c61c-bf3a-4dff-939c-5f3d55351d4e}", "Small werehouse 2"),
        cnt_unit("{ffe9021e-7d44-4ab3-8df9-0696d2506148}", "Small werehouse 3"),
        cnt_unit("{4b6bcf8c-6e4c-485b-a8f3-ac4de3338b5f}", "Small werehouse 4"),
        cnt_unit("{e0b21ae2-029b-4c20-986c-9c469d69b2c8}", "Garage B"),
        cnt_unit("{70a0edf9-c9bd-42c8-b260-e97927ebaaaa}", "Garage small A"),
        cnt_unit("{e4322f04-ba0d-43db-afe9-16025738ebeb}", "Garage small B"),
        cnt_unit("{36ac22c8-9737-4bdc-b59e-fd0fb823daaa}", "Pump station"),
        cnt_unit("{7d517890-d7ea-4ede-9c73-5be252b96d3f}", "Oil derrick"),
        cnt_unit("{d4fd6053-a036-4adf-8395-beca84e9efbb}", "Container red 1"),
        cnt_unit("{edd392fd-f262-4609-84d3-c09f126478ee}", "Container red 2"),
        cnt_unit("{dc005e97-7820-4cce-bc0e-edd875baaf92}", "Container red 3"),
        cnt_unit("{662e6cea-5a59-473f-87e9-e34d01f1ddb7}", "Container white"),
        cnt_unit("{d55f444b-745a-4954-bd4c-0ea1781f67a7}", "Container brown"),
        cnt_unit("{7f3722ae-10bc-49c5-a3cc-68ab89878c5b}", "Barracks 1"),
        cnt_unit("{eb3bac2d-4c24-4ff8-8c8a-dcd3d0c98750}", "Barracks 2"),
        cnt_unit("{a056cc08-9b50-45b1-b798-e0eb4277ea86}", "Military staff"),
        cnt_unit("{2b1802df-c4f9-404f-afe1-5f291ef68d30}", "Watchtower"),
        cnt_unit("{e9e4e232-b0c8-4306-b013-2f9defbb04d1}", "Hangar B"),
        cnt_unit("{07a6695a-2373-489f-a0a0-e1e35dd03b85}", "Fuel tank"),
        cnt_unit("{25f698c7-ee7b-40be-bafb-d97e64c487f3}", "Shelter B"),
        cnt_unit("{e0f6d8f9-0692-4695-933b-6e87636c7acb}", "Oil platform"),
        cnt_unit("{6d518ff5-cfca-4a7c-921b-ee3621a4207d}", "Subsidiary structure 1"),
        cnt_unit("{47a39247-7989-4f6d-bbb8-2cdd40e012dd}", "Subsidiary structure 2"),
        cnt_unit("{e58952f4-d2e9-43bc-a5ea-854d4678ef96}", "Subsidiary structure 3"),
        cnt_unit("{394ff644-013b-4f88-bfe1-1277cbcba8cc}", "Subsidiary structure A"),
        cnt_unit("{c724c713-61ad-4fb0-807d-dc6eb4a89884}", "Subsidiary structure B"),
        cnt_unit("{162b2803-ddf1-4b0e-9b95-b45b2f35ee30}", "Subsidiary structure C"),
        cnt_unit("{9cbba4f7-7014-4f67-b69a-4a458e5f2420}", "Subsidiary structure D"),
        cnt_unit("{dbb8c3f5-f1ea-42e1-b486-482ef41a4e53}", "Subsidiary structure E"),
        cnt_unit("{74e14790-da2b-4269-bd94-0bfa2dee0031}", "Subsidiary structure F"),
        cnt_unit("{96fc5825-e329-468d-83d8-fc9326d8aa52}", "Subsidiary structure G"),
        cnt_unit("{30D37BB2-F438-45ae-B09D-F00B1EFCB790}", "Landmine"),
        cnt_unit("{7c9d05ea-0b54-4d5c-9d6f-fa2cde39e349}", "FARP Ammo Dump Coating"),
        cnt_unit("{80c39fb0-854f-461b-bc4b-b2b51d0c4139}", "FARP Tent"),
        cnt_unit("{a947d0fd-9268-4851-a885-cb59aebe9bbc}", "FARP CP Blindage"),
        cnt_unit("{3441baf3-7ff7-4d76-ab9e-77f768b7813f}", "FARP Fuel Depot"),
        cnt_unit("{7e58d67d-191e-4e2c-ad22-a9c50cd48f53}", "GeneratorF"),
      },
    },
  },
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('British Empire Medal', _('British Empire Medal'), 200,  'UK-01-British_Empire_Medal.png'),
    award('Air Force Medal', _('Air Force Medal'), 600,  'UK-02-Air_Force_Medal.png'),
    award('Distinguished Flying Medal', _('Distinguished Flying Medal'), 1000, 'UK-03-Distinguished_Flying_Medal.png'),
    award('Military Medal', _('Military Medal'), 1400, 'UK-04-Military_Medal.png'),
    award('Distinguished Conduct Medal', _('Distinguished Conduct Medal'), 1800, 'UK-05-Distiguished_Conduct_Medal.png'),
    award('Air Force Cross', _('Air Force Cross'), 2200, 'UK-06-Air_Force_Cross.png'),                                                               
    award('Distinguished Flying Cross', _('Distinguished Flying Cross'), 2600, 'UK-07-Distinguished_Flying_Cross.png'),
    award('Military Cross', _('Military Cross'), 3000, 'UK-08-Military_Cross.png'),                                                    
  },                                         
  'UK.lua',
  {0,360,64,30}
);

country("{24623DF1-59F6-4231-B669-4B0160F2C9BF}", _("France"), "France", "FRA", "France.png", 5,
  {
    Planes =
    {
      CATID = "{C168A850-3C0B-436a-95B5-C4A015552560}",
      Plane =
      {
        cnt_unit("{AAD0C656-A7E0-4099-8F6C-25DDCB3EEEA2}", "Mirage 2000-5", {
          color_scheme("{55033da3-6ad7-4a9c-807f-79696ce713a2}", "EC1/2 SPA3 \"Cigogne de Guynemer\""),
          color_scheme("{7c41a49f-74a3-42e6-b8d0-8297722aa1bb}", "EC1/2  SPA103 \"Cigogne de Fonck\""),
          color_scheme("{703e7ba9-e80c-4049-a440-25a45a8a0a29}", "EC1/2  SPA12 \"Cigogne a ailes ouvertes\""),
          color_scheme("{2cd75265-f577-41fb-bdc7-6bdee4555385}", "EC2/2 \"Cote d'or\" SPA65 \"Chimere\""),
          color_scheme("{e2ab0c76-4248-4268-8372-b7b35993de47}", "EC2/2 \"Cote d'or\" SPA57 \"Mouette\""),
          color_scheme("{f6b81feb-e6d9-4f4d-9a75-40a33e5b3750}", "EC2/2 SPA94 \"LaMort qui fauche\""),
        }),
        cnt_unit("{0213FA86-978D-4586-BAC3-BD642AD52B96}", "C-130", {
          color_scheme("{2024A60C-DC7B-4af0-B0E7-6A911774383B}", "ET 2/61 \"Franche-Comte\""),
        }),
      },
    },
    Heliports =
    {
      CATID = "{E6490BAB-7129-4d23-9023-1CFE810886EF}",
      Heliport =
      {
        cnt_unit("{24FC9197-F225-4f2a-8A31-BD51DC7BDAB6}", "FARP"),
      },
    },
    Ships =
    {
      CATID = "{AAFD44F1-C080-4572-9465-3A52C46F2A45}",
      Ship =
      {
        cnt_unit("{6449989a-2f92-48ed-89bf-d0ae87176cb3}", "speedboat"),
      },
    },
    Cars =
    {
      CATID = "{6CAE2420-8E36-40f3-8586-E853AADB9199}",
      Car =
      {
        cnt_unit("{20821198-A965-4f25-86C5-FD54999CC3E3}", "Leclerc"),
        cnt_unit("{3C8BFE7F-E0B6-4FF7-8DCD-CC165BE5D5BC}", "MLRS"),
        cnt_unit("{6E93EACB-F7DB-4208-88C4-8D6465869A05}", "Hawk sr"),
        cnt_unit("{6FD50C44-10A0-458F-AF4E-0472EEFCD07E}", "Hawk tr"),
        cnt_unit("{DEAC9323-0320-482A-A4DC-DC7ABCB4B987}", "Hawk ln"),
        cnt_unit("{0EDE3912-F55C-402a-95AF-36BB3106BEA2}", "M 818"),
      },
    },
    Helicopters =
    {
      CATID = "{828CEADE-3F1D-40aa-93CE-8CDB73FE2710}",
      Helicopter =
      {
      cnt_unit("{3457BB1E-523F-4C24-BBEA-58D028623F05}", "Ka-50", {
          color_scheme("{72a9d570-ef83-11dd-ba2f-0800200c9a66}", "Armee de TERRE 1"),
          color_scheme("{31aa8310-ef85-11dd-ba2f-0800200c9a66}", "Armee de TERRE 2"),
          color_scheme("{34715950-ef87-11dd-ba2f-0800200c9a66}", "Armee de TERRE Desert"),
        }),
      },
    },
    Fortifications =
    {
      CATID = "{7F1597F0-88EB-41cb-A04E-E9A4D5EF7466}",
      Fortification =
      {
        cnt_unit("{79BEF6B1-03EE-40A5-9D67-FE369D67D8F3}", "Locomotive"),
        cnt_unit("{5D159ABA-28C6-4E6A-BD41-B295AFA4E108}", "Electric locomotive"),
        cnt_unit("{A65C983E-3615-4350-93B2-128CBA8B3569}", "Coach a tank"),
        cnt_unit("{066A8FCF-6591-457C-888A-AF443AF95084}", "Coach cargo"),
        cnt_unit("{AA5E677A-BE23-4752-8C1A-24E25EC148CC}", "Coach cargo open"),
        cnt_unit("{77348759-616D-4500-9AB8-701D9F8028CD}", "Coach a platform"),
        cnt_unit("{8B096AEA-9E18-4541-8120-0DAB3BC57170}", "Coach a passenger"),
        cnt_unit("{71AC463C-310A-41ce-B7E7-923AC3CA5EDC}", ".Block"),
        cnt_unit("{B54053A8-B054-4a0b-871C-6DDA65ED90EF}", ".Block on road"),
        cnt_unit("{20A1B146-07C6-4ee6-851C-DBBC92135446}", ".Bunker"),
        cnt_unit("{2848C193-6789-472c-8430-AF3D739BB6C8}", ".Pill-box"),
        cnt_unit("{64DE4673-7D3E-424f-AB29-F4336AC38F98}", ".Command Center"),
        cnt_unit("{85D3DBF2-05DF-48e1-9C49-FD104E65A76E}", ".Ammunition depot"),
        cnt_unit("{7c822c60-9885-4a44-8add-b87511ff0fc5}", "Hangar A"),
        cnt_unit("{f0f48213-396f-4cc2-9fec-2f308cb11154}", "Tank"),
        cnt_unit("{b0e8ef18-c50c-4695-ac6e-1033b3691ce2}", "Tech hangar A"),
        cnt_unit("{db4d86a5-f9d6-4db1-b6ff-72153d082fc8}", "Farm A"),
        cnt_unit("{d406d212-8425-41be-83a1-502864f221dd}", "Farm B"),
        cnt_unit("{e8f80c05-dd74-4ce4-a232-f29afa025c3b}", "Garage A"),
        cnt_unit("{c5f17833-f456-45be-8c7c-ab28996f0e85}", "Boiler-house A"),
        cnt_unit("{65c10c17-e726-46d4-a380-db42706b923f}", "Restaurant 1"),
        cnt_unit("{80af40db-22ac-4e42-ab24-a015d1a21311}", "Warehouse"),
        cnt_unit("{fe75a842-e794-4650-9197-22797513dc72}", "Comms tower M"),
        cnt_unit("{70bf5fc8-441f-47cb-b587-d8f36ab81600}", "Cafe"),
        cnt_unit("{bddc2805-fd70-47dd-90b0-0041ebd1eee3}", "Workshop A"),
        cnt_unit("{7d0fa1db-38a1-4bf8-9169-943e11d49001}", "Electric power box"),
        cnt_unit("{d161a6b7-3946-49b2-af4c-aef104809480}", "Supermarket A"),
        cnt_unit("{1a4b08df-98c6-45da-bfea-161d7ad0135f}", "Water tower A"),
        cnt_unit("{cc06c05a-da19-494c-8066-04bb6b2f375b}", "TV tower"),
        cnt_unit("{2fe5cb79-1395-4b34-a112-913e964534e9}", "Shelter"),
        cnt_unit("{56c3c279-31f6-4cb9-ba63-6025f14adb08}", "Repair workshop"),
        cnt_unit("{4d01350e-eac5-406a-8daf-a1e1cc74c03b}", "Railway station"),
        cnt_unit("{557eab86-9e3d-459f-880b-3bfbd3b397fe}", "Railway crossing A"),
        cnt_unit("{8ff4a140-121e-4b25-a7e1-72bf64a3645c}", "Railway crossing B"),
        cnt_unit("{044858e2-4d40-4702-a185-70ee80f07151}", "WC"),
        cnt_unit("{72c629a7-112d-4a3e-9032-ba62dab2e36d}", "Small house 1A area"),
        cnt_unit("{40cf54da-bdb2-4993-a619-f5504200c3f5}", "Small house 1A"),
        cnt_unit("{95dbcac0-35e6-4621-bb02-a500666e337e}", "Small house 1B area"),
        cnt_unit("{8b22a3fd-8d96-4320-81b5-04f2c9edb247}", "Small house 1B"),
        cnt_unit("{7ae8526a-0edc-46ca-bf03-a1dc10445fcd}", "Small house 1C area"),
        cnt_unit("{9f6a6842-f5a5-4953-871b-58e0a2278849}", "Small house 2C"),
        cnt_unit("{aa0f2150-ed5c-4b66-8c7a-39ab3bccf5e3}", "Shop"),
        cnt_unit("{0a4804d2-db83-4a18-bf2a-a253a9b17e33}", "Tech combine"),
        cnt_unit("{264c3fb6-7871-471a-8915-a68afe98fbb5}", "Chemical tank A"),
        cnt_unit("{2cca8015-d0a0-43f7-bc89-0bf1cf290246}", "Small werehouse 1"),
        cnt_unit("{14b9c61c-bf3a-4dff-939c-5f3d55351d4e}", "Small werehouse 2"),
        cnt_unit("{ffe9021e-7d44-4ab3-8df9-0696d2506148}", "Small werehouse 3"),
        cnt_unit("{4b6bcf8c-6e4c-485b-a8f3-ac4de3338b5f}", "Small werehouse 4"),
        cnt_unit("{e0b21ae2-029b-4c20-986c-9c469d69b2c8}", "Garage B"),
        cnt_unit("{70a0edf9-c9bd-42c8-b260-e97927ebaaaa}", "Garage small A"),
        cnt_unit("{e4322f04-ba0d-43db-afe9-16025738ebeb}", "Garage small B"),
        cnt_unit("{36ac22c8-9737-4bdc-b59e-fd0fb823daaa}", "Pump station"),
        cnt_unit("{7d517890-d7ea-4ede-9c73-5be252b96d3f}", "Oil derrick"),
        cnt_unit("{d4fd6053-a036-4adf-8395-beca84e9efbb}", "Container red 1"),
        cnt_unit("{edd392fd-f262-4609-84d3-c09f126478ee}", "Container red 2"),
        cnt_unit("{dc005e97-7820-4cce-bc0e-edd875baaf92}", "Container red 3"),
        cnt_unit("{662e6cea-5a59-473f-87e9-e34d01f1ddb7}", "Container white"),
        cnt_unit("{d55f444b-745a-4954-bd4c-0ea1781f67a7}", "Container brown"),
        cnt_unit("{7f3722ae-10bc-49c5-a3cc-68ab89878c5b}", "Barracks 1"),
        cnt_unit("{eb3bac2d-4c24-4ff8-8c8a-dcd3d0c98750}", "Barracks 2"),
        cnt_unit("{a056cc08-9b50-45b1-b798-e0eb4277ea86}", "Military staff"),
        cnt_unit("{2b1802df-c4f9-404f-afe1-5f291ef68d30}", "Watchtower"),
        cnt_unit("{e9e4e232-b0c8-4306-b013-2f9defbb04d1}", "Hangar B"),
        cnt_unit("{07a6695a-2373-489f-a0a0-e1e35dd03b85}", "Fuel tank"),
        cnt_unit("{25f698c7-ee7b-40be-bafb-d97e64c487f3}", "Shelter B"),
        cnt_unit("{e0f6d8f9-0692-4695-933b-6e87636c7acb}", "Oil platform"),
        cnt_unit("{6d518ff5-cfca-4a7c-921b-ee3621a4207d}", "Subsidiary structure 1"),
        cnt_unit("{47a39247-7989-4f6d-bbb8-2cdd40e012dd}", "Subsidiary structure 2"),
        cnt_unit("{e58952f4-d2e9-43bc-a5ea-854d4678ef96}", "Subsidiary structure 3"),
        cnt_unit("{394ff644-013b-4f88-bfe1-1277cbcba8cc}", "Subsidiary structure A"),
        cnt_unit("{c724c713-61ad-4fb0-807d-dc6eb4a89884}", "Subsidiary structure B"),
        cnt_unit("{162b2803-ddf1-4b0e-9b95-b45b2f35ee30}", "Subsidiary structure C"),
        cnt_unit("{9cbba4f7-7014-4f67-b69a-4a458e5f2420}", "Subsidiary structure D"),
        cnt_unit("{dbb8c3f5-f1ea-42e1-b486-482ef41a4e53}", "Subsidiary structure E"),
        cnt_unit("{74e14790-da2b-4269-bd94-0bfa2dee0031}", "Subsidiary structure F"),
        cnt_unit("{96fc5825-e329-468d-83d8-fc9326d8aa52}", "Subsidiary structure G"),
        cnt_unit("{30D37BB2-F438-45ae-B09D-F00B1EFCB790}", "Landmine"),
        cnt_unit("{7c9d05ea-0b54-4d5c-9d6f-fa2cde39e349}", "FARP Ammo Dump Coating"),
        cnt_unit("{80c39fb0-854f-461b-bc4b-b2b51d0c4139}", "FARP Tent"),
        cnt_unit("{a947d0fd-9268-4851-a885-cb59aebe9bbc}", "FARP CP Blindage"),
        cnt_unit("{3441baf3-7ff7-4d76-ab9e-77f768b7813f}", "FARP Fuel Depot"),
        cnt_unit("{7e58d67d-191e-4e2c-ad22-a9c50cd48f53}", "GeneratorF"),
      },
    },
  },
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Croix de la bravoure', _('Croix de la bravoure'), 200,  'FR-01-Cross_of_Valour.png'),
    award('Medaille militaire', _('Medaille militaire'), 600,  'FR-02-Medal_Militaire.png'),
    award('Medaille du merite', _('Medaille du merite'), 1000, 'FR-03-Merit_Medal.png'),
    award('Croix du combattant', _('Croix du combattant'), 1400, 'FR-04-Combatant_Cross.png'),
    award([[Medaille de la defense de l'armee nationale]], _([[Medaille de la defense de l'armee nationale]]), 1800, 'FR-05-Army_National_Defence_Medal.png'),
    award('Ordre du merite', _('Ordre du merite'), 2200, 'FR-06-Merit_Order.png'),
    award('Croix de la liberte', _('Croix de la liberte'), 2600, 'FR-07-Liberty_Cross.png'),
    award([[Legion d'honneur]], _([[Legion d'honneur]]), 3000, 'FR-08-Legion_of_Honor.png'),            
  },                                         
  'France.lua',
    {0,150,64,30}
);

country("{4F77C010-F751-45C9-B201-DE5AB4A08CC9}", _("Spain"), "Spain", "SPN", "Spain.png", 9,
  {
    Planes =
    {
      CATID = "{C168A850-3C0B-436a-95B5-C4A015552560}",
      Plane =
      {
        cnt_unit("{2C4C5E81-F950-11d5-9190-00A0249B6F00}", "F/A-18C", {
          color_scheme("{7033b65e-0657-4cd8-b1d5-0fbf9f8b3ee0}", "Grupo 12 EAF Torrejon AB"),
          color_scheme("{37557cfe-e42f-41da-803b-e37c0884210f}", "Grupo 15 EAF Zaragoza AB"),
        }),
        cnt_unit("{0213FA86-978D-4586-BAC3-BD642AD52B96}", "C-130", {
          color_scheme("{DC479C40-26A0-4ccc-B3D7-CF643F4F340A}", "Escuadron 311, Grupo 31"),
        }),
      },
    },
    Heliports =
    {
      CATID = "{E6490BAB-7129-4d23-9023-1CFE810886EF}",
      Heliport =
      {
        cnt_unit("{24FC9197-F225-4f2a-8A31-BD51DC7BDAB6}", "FARP"),
      },
    },
    Ships =
    {
      CATID = "{AAFD44F1-C080-4572-9465-3A52C46F2A45}",
      Ship =
      {
        cnt_unit("{6449989a-2f92-48ed-89bf-d0ae87176cb3}", "speedboat"),
      },
    },
    Cars =
    {
      CATID = "{6CAE2420-8E36-40f3-8586-E853AADB9199}",
      Car =
      {
        cnt_unit("{3BDD3518-974C-49EB-8746-54A8DD91C14F}", "M-113"),
        cnt_unit("{6E93EACB-F7DB-4208-88C4-8D6465869A05}", "Hawk sr"),
        cnt_unit("{6FD50C44-10A0-458F-AF4E-0472EEFCD07E}", "Hawk tr"),
        cnt_unit("{DEAC9323-0320-482A-A4DC-DC7ABCB4B987}", "Hawk ln"),
        cnt_unit("{5A76E1FB-E73B-4D93-B61B-967AB6F87508}", "Hummer"),
        cnt_unit("{DA962EC4-E7F3-4F85-8638-9535C56D6947}", "Leopard-2"),
        cnt_unit("{A543AD97-7C33-4655-9A9A-FDB9F1D42248}", "M-109"),
        cnt_unit("{B84C5FC5-9893-45e4-A712-E3D4D201A003}", "Stinger manpad"),
        cnt_unit("{DFC5C4AA-EFE7-4929-A305-B8785BCD6704}", "Stinger comm"),
        cnt_unit("{0EDE3912-F55C-402a-95AF-36BB3106BEA2}", "M 818"),
      },
    },
    Helicopters =
    {
      CATID = "{828CEADE-3F1D-40aa-93CE-8CDB73FE2710}",
      Helicopter =
      {
      cnt_unit("{AF7808AC-A07C-470D-886B-505E8D23D317}", "CH-47D", {
        color_scheme("{4E16A8E0-3FCA-44de-93E7-91A14DADB398}", "Standard"),
        }),
      cnt_unit("{3457BB1E-523F-4C24-BBEA-58D028623F05}", "Ka-50", {
        color_scheme("{d05e2aa0-e8c0-11dd-ba2f-0800200c9a66}", "SAA Standard"),
        color_scheme("{c6991930-e8c0-11dd-ba2f-0800200c9a66}", "SAA Arido"),
        color_scheme("{2de756c0-e8c5-11dd-ba2f-0800200c9a66}", "SAA Boscoso"),
        }),
      },
    },
    Fortifications =
    {
      CATID = "{7F1597F0-88EB-41cb-A04E-E9A4D5EF7466}",
      Fortification =
      {
        cnt_unit("{79BEF6B1-03EE-40A5-9D67-FE369D67D8F3}", "Locomotive"),
        cnt_unit("{5D159ABA-28C6-4E6A-BD41-B295AFA4E108}", "Electric locomotive"),
        cnt_unit("{A65C983E-3615-4350-93B2-128CBA8B3569}", "Coach a tank"),
        cnt_unit("{066A8FCF-6591-457C-888A-AF443AF95084}", "Coach cargo"),
        cnt_unit("{AA5E677A-BE23-4752-8C1A-24E25EC148CC}", "Coach cargo open"),
        cnt_unit("{77348759-616D-4500-9AB8-701D9F8028CD}", "Coach a platform"),
        cnt_unit("{8B096AEA-9E18-4541-8120-0DAB3BC57170}", "Coach a passenger"),
        cnt_unit("{71AC463C-310A-41ce-B7E7-923AC3CA5EDC}", ".Block"),
        cnt_unit("{B54053A8-B054-4a0b-871C-6DDA65ED90EF}", ".Block on road"),
        cnt_unit("{20A1B146-07C6-4ee6-851C-DBBC92135446}", ".Bunker"),
        cnt_unit("{2848C193-6789-472c-8430-AF3D739BB6C8}", ".Pill-box"),
        cnt_unit("{64DE4673-7D3E-424f-AB29-F4336AC38F98}", ".Command Center"),
        cnt_unit("{85D3DBF2-05DF-48e1-9C49-FD104E65A76E}", ".Ammunition depot"),
        cnt_unit("{7c822c60-9885-4a44-8add-b87511ff0fc5}", "Hangar A"),
        cnt_unit("{f0f48213-396f-4cc2-9fec-2f308cb11154}", "Tank"),
        cnt_unit("{b0e8ef18-c50c-4695-ac6e-1033b3691ce2}", "Tech hangar A"),
        cnt_unit("{db4d86a5-f9d6-4db1-b6ff-72153d082fc8}", "Farm A"),
        cnt_unit("{d406d212-8425-41be-83a1-502864f221dd}", "Farm B"),
        cnt_unit("{e8f80c05-dd74-4ce4-a232-f29afa025c3b}", "Garage A"),
        cnt_unit("{c5f17833-f456-45be-8c7c-ab28996f0e85}", "Boiler-house A"),
        cnt_unit("{65c10c17-e726-46d4-a380-db42706b923f}", "Restaurant 1"),
        cnt_unit("{80af40db-22ac-4e42-ab24-a015d1a21311}", "Warehouse"),
        cnt_unit("{fe75a842-e794-4650-9197-22797513dc72}", "Comms tower M"),
        cnt_unit("{70bf5fc8-441f-47cb-b587-d8f36ab81600}", "Cafe"),
        cnt_unit("{bddc2805-fd70-47dd-90b0-0041ebd1eee3}", "Workshop A"),
        cnt_unit("{7d0fa1db-38a1-4bf8-9169-943e11d49001}", "Electric power box"),
        cnt_unit("{d161a6b7-3946-49b2-af4c-aef104809480}", "Supermarket A"),
        cnt_unit("{1a4b08df-98c6-45da-bfea-161d7ad0135f}", "Water tower A"),
        cnt_unit("{cc06c05a-da19-494c-8066-04bb6b2f375b}", "TV tower"),
        cnt_unit("{2fe5cb79-1395-4b34-a112-913e964534e9}", "Shelter"),
        cnt_unit("{56c3c279-31f6-4cb9-ba63-6025f14adb08}", "Repair workshop"),
        cnt_unit("{4d01350e-eac5-406a-8daf-a1e1cc74c03b}", "Railway station"),
        cnt_unit("{557eab86-9e3d-459f-880b-3bfbd3b397fe}", "Railway crossing A"),
        cnt_unit("{8ff4a140-121e-4b25-a7e1-72bf64a3645c}", "Railway crossing B"),
        cnt_unit("{044858e2-4d40-4702-a185-70ee80f07151}", "WC"),
        cnt_unit("{72c629a7-112d-4a3e-9032-ba62dab2e36d}", "Small house 1A area"),
        cnt_unit("{40cf54da-bdb2-4993-a619-f5504200c3f5}", "Small house 1A"),
        cnt_unit("{95dbcac0-35e6-4621-bb02-a500666e337e}", "Small house 1B area"),
        cnt_unit("{8b22a3fd-8d96-4320-81b5-04f2c9edb247}", "Small house 1B"),
        cnt_unit("{7ae8526a-0edc-46ca-bf03-a1dc10445fcd}", "Small house 1C area"),
        cnt_unit("{9f6a6842-f5a5-4953-871b-58e0a2278849}", "Small house 2C"),
        cnt_unit("{aa0f2150-ed5c-4b66-8c7a-39ab3bccf5e3}", "Shop"),
        cnt_unit("{0a4804d2-db83-4a18-bf2a-a253a9b17e33}", "Tech combine"),
        cnt_unit("{264c3fb6-7871-471a-8915-a68afe98fbb5}", "Chemical tank A"),
        cnt_unit("{2cca8015-d0a0-43f7-bc89-0bf1cf290246}", "Small werehouse 1"),
        cnt_unit("{14b9c61c-bf3a-4dff-939c-5f3d55351d4e}", "Small werehouse 2"),
        cnt_unit("{ffe9021e-7d44-4ab3-8df9-0696d2506148}", "Small werehouse 3"),
        cnt_unit("{4b6bcf8c-6e4c-485b-a8f3-ac4de3338b5f}", "Small werehouse 4"),
        cnt_unit("{e0b21ae2-029b-4c20-986c-9c469d69b2c8}", "Garage B"),
        cnt_unit("{70a0edf9-c9bd-42c8-b260-e97927ebaaaa}", "Garage small A"),
        cnt_unit("{e4322f04-ba0d-43db-afe9-16025738ebeb}", "Garage small B"),
        cnt_unit("{36ac22c8-9737-4bdc-b59e-fd0fb823daaa}", "Pump station"),
        cnt_unit("{7d517890-d7ea-4ede-9c73-5be252b96d3f}", "Oil derrick"),
        cnt_unit("{d4fd6053-a036-4adf-8395-beca84e9efbb}", "Container red 1"),
        cnt_unit("{edd392fd-f262-4609-84d3-c09f126478ee}", "Container red 2"),
        cnt_unit("{dc005e97-7820-4cce-bc0e-edd875baaf92}", "Container red 3"),
        cnt_unit("{662e6cea-5a59-473f-87e9-e34d01f1ddb7}", "Container white"),
        cnt_unit("{d55f444b-745a-4954-bd4c-0ea1781f67a7}", "Container brown"),
        cnt_unit("{7f3722ae-10bc-49c5-a3cc-68ab89878c5b}", "Barracks 1"),
        cnt_unit("{eb3bac2d-4c24-4ff8-8c8a-dcd3d0c98750}", "Barracks 2"),
        cnt_unit("{a056cc08-9b50-45b1-b798-e0eb4277ea86}", "Military staff"),
        cnt_unit("{2b1802df-c4f9-404f-afe1-5f291ef68d30}", "Watchtower"),
        cnt_unit("{e9e4e232-b0c8-4306-b013-2f9defbb04d1}", "Hangar B"),
        cnt_unit("{07a6695a-2373-489f-a0a0-e1e35dd03b85}", "Fuel tank"),
        cnt_unit("{25f698c7-ee7b-40be-bafb-d97e64c487f3}", "Shelter B"),
        cnt_unit("{e0f6d8f9-0692-4695-933b-6e87636c7acb}", "Oil platform"),
        cnt_unit("{6d518ff5-cfca-4a7c-921b-ee3621a4207d}", "Subsidiary structure 1"),
        cnt_unit("{47a39247-7989-4f6d-bbb8-2cdd40e012dd}", "Subsidiary structure 2"),
        cnt_unit("{e58952f4-d2e9-43bc-a5ea-854d4678ef96}", "Subsidiary structure 3"),
        cnt_unit("{394ff644-013b-4f88-bfe1-1277cbcba8cc}", "Subsidiary structure A"),
        cnt_unit("{c724c713-61ad-4fb0-807d-dc6eb4a89884}", "Subsidiary structure B"),
        cnt_unit("{162b2803-ddf1-4b0e-9b95-b45b2f35ee30}", "Subsidiary structure C"),
        cnt_unit("{9cbba4f7-7014-4f67-b69a-4a458e5f2420}", "Subsidiary structure D"),
        cnt_unit("{dbb8c3f5-f1ea-42e1-b486-482ef41a4e53}", "Subsidiary structure E"),
        cnt_unit("{74e14790-da2b-4269-bd94-0bfa2dee0031}", "Subsidiary structure F"),
        cnt_unit("{96fc5825-e329-468d-83d8-fc9326d8aa52}", "Subsidiary structure G"),
        cnt_unit("{30D37BB2-F438-45ae-B09D-F00B1EFCB790}", "Landmine"),
        cnt_unit("{7c9d05ea-0b54-4d5c-9d6f-fa2cde39e349}", "FARP Ammo Dump Coating"),
        cnt_unit("{80c39fb0-854f-461b-bc4b-b2b51d0c4139}", "FARP Tent"),
        cnt_unit("{a947d0fd-9268-4851-a885-cb59aebe9bbc}", "FARP CP Blindage"),
        cnt_unit("{3441baf3-7ff7-4d76-ab9e-77f768b7813f}", "FARP Fuel Depot"),
        cnt_unit("{7e58d67d-191e-4e2c-ad22-a9c50cd48f53}", "GeneratorF"),
      },
    },
  },
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Cruz del Merito Aeronautico con distintivo azul', _('Cruz del Merito Aeronautico con distintivo azul'), 200,  'SP-01-Aeronautical_Merit_Cross_with_Blue_Ribbon.png'),
    award('Cruz del Merito Aeronautico con distintivo rojo', _('Cruz del Merito Aeronautico con distintivo rojo'), 800,  'SP-02-Aeronautical_Merit_Cross_with_Red_Ribbon.png'),
    award('Cruz de Guerra', _('Cruz de Guerra'), 1500, 'SP-03-War_Cross.png'),
    award('Medalla Militar Individual', _('Medalla Militar Individual'), 2200, 'SP-04-Individual_Military_Medal.png'),
    award('Cruz Laureada de San Fernando', _('Cruz Laureada de San Fernando'), 3000, 'SP-05-Laureate_Cross_of_Saint_Ferdinand.png'),        
  },                                         
  'Spain.lua',
    {0,420,64,30}
);

country("{20BEDF03-7904-4EF8-9AD5-E7EC3A015956}", _("The Netherlands"), "The Netherlands", "NETH", "The Netherlands.png", 10,
  {
    Planes =
    {
      CATID = "{C168A850-3C0B-436a-95B5-C4A015552560}",
      Plane =
      {
        cnt_unit("{0213FA86-978D-4586-BAC3-BD642AD52B96}", "C-130", {
          color_scheme("{71BAD5DF-47C1-4f69-B3EC-502BF462F2B8}", "334 Squadron"),
        }),
        cnt_unit("{2B1638C8-9321-4d90-A7C8-8E9EB342C0F5}", "F-16A MLU", {
          color_scheme("{ed02690d-9b86-4b55-855a-84c29362fe81}", "AF F16 Standart-1"),
        }),
      },
    },
    Heliports =
    {
      CATID = "{E6490BAB-7129-4d23-9023-1CFE810886EF}",
      Heliport =
      {
        cnt_unit("{24FC9197-F225-4f2a-8A31-BD51DC7BDAB6}", "FARP"),
      },
    },
    Ships =
    {
      CATID = "{AAFD44F1-C080-4572-9465-3A52C46F2A45}",
      Ship =
      {
        cnt_unit("{6449989a-2f92-48ed-89bf-d0ae87176cb3}", "speedboat"),
      },
    },
    Cars =
    {
      CATID = "{6CAE2420-8E36-40f3-8586-E853AADB9199}",
      Car =
      {
        cnt_unit("{5A76E1FB-E73B-4D93-B61B-967AB6F87508}", "Hummer"),
        cnt_unit("{BDFF2359-B329-479A-A4D2-A14F3FB37DE4}", "Patriot str"),
        cnt_unit("{572AF10E-0FAC-4E2D-BA3F-96D6C08194FB}", "Patriot ln"),
        cnt_unit("{033A717B-2687-4d74-9A89-69C2535DAC48}", "Patriot cp"),
        cnt_unit("{6E93EACB-F7DB-4208-88C4-8D6465869A05}", "Hawk sr"),
        cnt_unit("{6FD50C44-10A0-458F-AF4E-0472EEFCD07E}", "Hawk tr"),
        cnt_unit("{DEAC9323-0320-482A-A4DC-DC7ABCB4B987}", "Hawk ln"),
        cnt_unit("{DA962EC4-E7F3-4F85-8638-9535C56D6947}", "Leopard-2"),
        cnt_unit("{A543AD97-7C33-4655-9A9A-FDB9F1D42248}", "M-109"),
        cnt_unit("{3C8BFE7F-E0B6-4FF7-8DCD-CC165BE5D5BC}", "MLRS"),
        cnt_unit("{B84C5FC5-9893-45e4-A712-E3D4D201A003}", "Stinger manpad"),
        cnt_unit("{DFC5C4AA-EFE7-4929-A305-B8785BCD6704}", "Stinger comm"),
        cnt_unit("{0EDE3912-F55C-402a-95AF-36BB3106BEA2}", "M 818"),
        cnt_unit("{16263664-B3F8-4DA7-B61D-BF2445D3C469}", "Leopard1A3"),
      },
    },
    Helicopters =
    {
      CATID = "{828CEADE-3F1D-40aa-93CE-8CDB73FE2710}",
      Helicopter =
      {
        cnt_unit("{F324202D-A045-418B-86D0-7594454FDA81}", "AH-64A", {
          color_scheme("{A648CB24-F026-4c33-BBC2-5A89163B8F9E}", "Standard"),
        }),     
                cnt_unit("{F939FD3E-229F-4A9F-AE99-5CD4D60DE5F9}", "AH-64D", {
          color_scheme("{97CF2B04-5E64-4e50-A7B7-6570A36D456C}", "Standard"),
        }),
        cnt_unit("{AF7808AC-A07C-470D-886B-505E8D23D317}", "CH-47D", {
          color_scheme("{3FD0E4C4-EABD-4d45-B35A-DE079017A463}", "Standard"),
        }),
        cnt_unit("{3457BB1E-523F-4C24-BBEA-58D028623F05}", "Ka-50", {
          color_scheme("{13b3d070-e8bc-11dd-ba2f-0800200c9a66}", "RNAF"),
          color_scheme("{c48c8880-ed6f-11dd-ba2f-0800200c9a66}", "RNAF Wooded"),
        }),
      },
    },
    Fortifications =
    {
      CATID = "{7F1597F0-88EB-41cb-A04E-E9A4D5EF7466}",
      Fortification =
      {
        cnt_unit("{79BEF6B1-03EE-40A5-9D67-FE369D67D8F3}", "Locomotive"),
        cnt_unit("{5D159ABA-28C6-4E6A-BD41-B295AFA4E108}", "Electric locomotive"),
        cnt_unit("{A65C983E-3615-4350-93B2-128CBA8B3569}", "Coach a tank"),
        cnt_unit("{066A8FCF-6591-457C-888A-AF443AF95084}", "Coach cargo"),
        cnt_unit("{AA5E677A-BE23-4752-8C1A-24E25EC148CC}", "Coach cargo open"),
        cnt_unit("{77348759-616D-4500-9AB8-701D9F8028CD}", "Coach a platform"),
        cnt_unit("{8B096AEA-9E18-4541-8120-0DAB3BC57170}", "Coach a passenger"),
        cnt_unit("{71AC463C-310A-41ce-B7E7-923AC3CA5EDC}", ".Block"),
        cnt_unit("{B54053A8-B054-4a0b-871C-6DDA65ED90EF}", ".Block on road"),
        cnt_unit("{20A1B146-07C6-4ee6-851C-DBBC92135446}", ".Bunker"),
        cnt_unit("{2848C193-6789-472c-8430-AF3D739BB6C8}", ".Pill-box"),
        cnt_unit("{64DE4673-7D3E-424f-AB29-F4336AC38F98}", ".Command Center"),
        cnt_unit("{85D3DBF2-05DF-48e1-9C49-FD104E65A76E}", ".Ammunition depot"),
        cnt_unit("{7c822c60-9885-4a44-8add-b87511ff0fc5}", "Hangar A"),
        cnt_unit("{f0f48213-396f-4cc2-9fec-2f308cb11154}", "Tank"),
        cnt_unit("{b0e8ef18-c50c-4695-ac6e-1033b3691ce2}", "Tech hangar A"),
        cnt_unit("{db4d86a5-f9d6-4db1-b6ff-72153d082fc8}", "Farm A"),
        cnt_unit("{d406d212-8425-41be-83a1-502864f221dd}", "Farm B"),
        cnt_unit("{e8f80c05-dd74-4ce4-a232-f29afa025c3b}", "Garage A"),
        cnt_unit("{c5f17833-f456-45be-8c7c-ab28996f0e85}", "Boiler-house A"),
        cnt_unit("{65c10c17-e726-46d4-a380-db42706b923f}", "Restaurant 1"),
        cnt_unit("{80af40db-22ac-4e42-ab24-a015d1a21311}", "Warehouse"),
        cnt_unit("{fe75a842-e794-4650-9197-22797513dc72}", "Comms tower M"),
        cnt_unit("{70bf5fc8-441f-47cb-b587-d8f36ab81600}", "Cafe"),
        cnt_unit("{bddc2805-fd70-47dd-90b0-0041ebd1eee3}", "Workshop A"),
        cnt_unit("{7d0fa1db-38a1-4bf8-9169-943e11d49001}", "Electric power box"),
        cnt_unit("{d161a6b7-3946-49b2-af4c-aef104809480}", "Supermarket A"),
        cnt_unit("{1a4b08df-98c6-45da-bfea-161d7ad0135f}", "Water tower A"),
        cnt_unit("{cc06c05a-da19-494c-8066-04bb6b2f375b}", "TV tower"),
        cnt_unit("{2fe5cb79-1395-4b34-a112-913e964534e9}", "Shelter"),
        cnt_unit("{56c3c279-31f6-4cb9-ba63-6025f14adb08}", "Repair workshop"),
        cnt_unit("{4d01350e-eac5-406a-8daf-a1e1cc74c03b}", "Railway station"),
        cnt_unit("{557eab86-9e3d-459f-880b-3bfbd3b397fe}", "Railway crossing A"),
        cnt_unit("{8ff4a140-121e-4b25-a7e1-72bf64a3645c}", "Railway crossing B"),
        cnt_unit("{044858e2-4d40-4702-a185-70ee80f07151}", "WC"),
        cnt_unit("{72c629a7-112d-4a3e-9032-ba62dab2e36d}", "Small house 1A area"),
        cnt_unit("{40cf54da-bdb2-4993-a619-f5504200c3f5}", "Small house 1A"),
        cnt_unit("{95dbcac0-35e6-4621-bb02-a500666e337e}", "Small house 1B area"),
        cnt_unit("{8b22a3fd-8d96-4320-81b5-04f2c9edb247}", "Small house 1B"),
        cnt_unit("{7ae8526a-0edc-46ca-bf03-a1dc10445fcd}", "Small house 1C area"),
        cnt_unit("{9f6a6842-f5a5-4953-871b-58e0a2278849}", "Small house 2C"),
        cnt_unit("{aa0f2150-ed5c-4b66-8c7a-39ab3bccf5e3}", "Shop"),
        cnt_unit("{0a4804d2-db83-4a18-bf2a-a253a9b17e33}", "Tech combine"),
        cnt_unit("{264c3fb6-7871-471a-8915-a68afe98fbb5}", "Chemical tank A"),
        cnt_unit("{2cca8015-d0a0-43f7-bc89-0bf1cf290246}", "Small werehouse 1"),
        cnt_unit("{14b9c61c-bf3a-4dff-939c-5f3d55351d4e}", "Small werehouse 2"),
        cnt_unit("{ffe9021e-7d44-4ab3-8df9-0696d2506148}", "Small werehouse 3"),
        cnt_unit("{4b6bcf8c-6e4c-485b-a8f3-ac4de3338b5f}", "Small werehouse 4"),
        cnt_unit("{e0b21ae2-029b-4c20-986c-9c469d69b2c8}", "Garage B"),
        cnt_unit("{70a0edf9-c9bd-42c8-b260-e97927ebaaaa}", "Garage small A"),
        cnt_unit("{e4322f04-ba0d-43db-afe9-16025738ebeb}", "Garage small B"),
        cnt_unit("{36ac22c8-9737-4bdc-b59e-fd0fb823daaa}", "Pump station"),
        cnt_unit("{7d517890-d7ea-4ede-9c73-5be252b96d3f}", "Oil derrick"),
        cnt_unit("{d4fd6053-a036-4adf-8395-beca84e9efbb}", "Container red 1"),
        cnt_unit("{edd392fd-f262-4609-84d3-c09f126478ee}", "Container red 2"),
        cnt_unit("{dc005e97-7820-4cce-bc0e-edd875baaf92}", "Container red 3"),
        cnt_unit("{662e6cea-5a59-473f-87e9-e34d01f1ddb7}", "Container white"),
        cnt_unit("{d55f444b-745a-4954-bd4c-0ea1781f67a7}", "Container brown"),
        cnt_unit("{7f3722ae-10bc-49c5-a3cc-68ab89878c5b}", "Barracks 1"),
        cnt_unit("{eb3bac2d-4c24-4ff8-8c8a-dcd3d0c98750}", "Barracks 2"),
        cnt_unit("{a056cc08-9b50-45b1-b798-e0eb4277ea86}", "Military staff"),
        cnt_unit("{2b1802df-c4f9-404f-afe1-5f291ef68d30}", "Watchtower"),
        cnt_unit("{e9e4e232-b0c8-4306-b013-2f9defbb04d1}", "Hangar B"),
        cnt_unit("{07a6695a-2373-489f-a0a0-e1e35dd03b85}", "Fuel tank"),
        cnt_unit("{25f698c7-ee7b-40be-bafb-d97e64c487f3}", "Shelter B"),
        cnt_unit("{e0f6d8f9-0692-4695-933b-6e87636c7acb}", "Oil platform"),
        cnt_unit("{6d518ff5-cfca-4a7c-921b-ee3621a4207d}", "Subsidiary structure 1"),
        cnt_unit("{47a39247-7989-4f6d-bbb8-2cdd40e012dd}", "Subsidiary structure 2"),
        cnt_unit("{e58952f4-d2e9-43bc-a5ea-854d4678ef96}", "Subsidiary structure 3"),
        cnt_unit("{394ff644-013b-4f88-bfe1-1277cbcba8cc}", "Subsidiary structure A"),
        cnt_unit("{c724c713-61ad-4fb0-807d-dc6eb4a89884}", "Subsidiary structure B"),
        cnt_unit("{162b2803-ddf1-4b0e-9b95-b45b2f35ee30}", "Subsidiary structure C"),
        cnt_unit("{9cbba4f7-7014-4f67-b69a-4a458e5f2420}", "Subsidiary structure D"),
        cnt_unit("{dbb8c3f5-f1ea-42e1-b486-482ef41a4e53}", "Subsidiary structure E"),
        cnt_unit("{74e14790-da2b-4269-bd94-0bfa2dee0031}", "Subsidiary structure F"),
        cnt_unit("{96fc5825-e329-468d-83d8-fc9326d8aa52}", "Subsidiary structure G"),
        cnt_unit("{30D37BB2-F438-45ae-B09D-F00B1EFCB790}", "Landmine"),
        cnt_unit("{7c9d05ea-0b54-4d5c-9d6f-fa2cde39e349}", "FARP Ammo Dump Coating"),
        cnt_unit("{80c39fb0-854f-461b-bc4b-b2b51d0c4139}", "FARP Tent"),
        cnt_unit("{a947d0fd-9268-4851-a885-cb59aebe9bbc}", "FARP CP Blindage"),
        cnt_unit("{3441baf3-7ff7-4d76-ab9e-77f768b7813f}", "FARP Fuel Depot"),
        cnt_unit("{7e58d67d-191e-4e2c-ad22-a9c50cd48f53}", "GeneratorF"),
      },
    },
  },
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Aviators Cross', _('Aviators Cross'), 200,  'NED-01-Aviators_Cross.png'),
    award('Hasselt Cross', _('Hasselt Cross'), 600,  'NED-02-Hasselt_Cross.png'),
    award('Lion III Class', _('Lion III Class'), 1000, 'NED-03-Lion_III_Class.png'),
    award('Long Service Decoration Bronze', _('Long Service Decoration Bronze'), 1400, 'NED-04-Long_Service_Decoration_Bronze.png'),                    
    award('Long Service Decoration Silver', _('Long Service Decoration Silver'), 1800, 'NED-05-Long_Service_Decoration_Silver.png'),                                    
    award('Military Order of William Knight', _('Military Order of William Knight'), 2200, 'NED-06-Military_Order_of_William_Knight.png'),
    award('Order of the House of Nassau', _('Order of the House of Nassau'), 2600, 'NED-07-Order_of_the_House_of_Nassau.png'),                                    
    award('Order of the House of Nassau-2', _('Order of the House of Nassau-2'), 3000, 'NED-08-Order_of_the_House_of_Nassau-2.png'),                                            
  },                                         
  'The Netherlands.lua',
    {0,300,64,30}  
);

country("{6AE50372-804A-4137-BAD3-A549CA056D3C}", _("Belgium"), "Belgium", "BEL", "Belgium.png", 11,
  {
    Planes =
    {
      CATID = "{C168A850-3C0B-436a-95B5-C4A015552560}",
      Plane =
      {
        cnt_unit("{0213FA86-978D-4586-BAC3-BD642AD52B96}", "C-130", {
          color_scheme("{57A4650C-6A5E-428F-BF7D-00A4FB37DD08}", "AF Standart"),
        }),
        cnt_unit("{2B1638C8-9321-4d90-A7C8-8E9EB342C0F5}", "F-16A MLU", {
          color_scheme("{a17971fe-088b-4be1-9dbf-50ea2f53dfba}", "AF F16 Standart"),
        }),
      },
    },
    Heliports =
    {
      CATID = "{E6490BAB-7129-4d23-9023-1CFE810886EF}",
      Heliport =
      {
        cnt_unit("{24FC9197-F225-4f2a-8A31-BD51DC7BDAB6}", "FARP"),
      },
    },
    Ships =
    {
      CATID = "{AAFD44F1-C080-4572-9465-3A52C46F2A45}",
      Ship =
      {
        cnt_unit("{6449989a-2f92-48ed-89bf-d0ae87176cb3}", "speedboat"),
      },
    },
    Cars =
    {
      CATID = "{6CAE2420-8E36-40f3-8586-E853AADB9199}",
      Car =
      {
        cnt_unit("{3BDD3518-974C-49EB-8746-54A8DD91C14F}", "M-113"),
        cnt_unit("{6E93EACB-F7DB-4208-88C4-8D6465869A05}", "Hawk sr"),
        cnt_unit("{6FD50C44-10A0-458F-AF4E-0472EEFCD07E}", "Hawk tr"),
        cnt_unit("{DEAC9323-0320-482A-A4DC-DC7ABCB4B987}", "Hawk ln"),
        cnt_unit("{5A76E1FB-E73B-4D93-B61B-967AB6F87508}", "Hummer"),
        cnt_unit("{A543AD97-7C33-4655-9A9A-FDB9F1D42248}", "M-109"),
        cnt_unit("{B84C5FC5-9893-45e4-A712-E3D4D201A003}", "Stinger manpad"),
        cnt_unit("{DFC5C4AA-EFE7-4929-A305-B8785BCD6704}", "Stinger comm"),
        cnt_unit("{0EDE3912-F55C-402a-95AF-36BB3106BEA2}", "M 818"),
      },
    },
    Helicopters =
    {
      CATID = "{828CEADE-3F1D-40aa-93CE-8CDB73FE2710}",
      Helicopter =
      {
      cnt_unit("{3457BB1E-523F-4C24-BBEA-58D028623F05}", "Ka-50", {
          color_scheme("{0af4efc0-eafe-11dd-ba2f-0800200c9a66}", "Belgium Camo"),
          color_scheme("{1bd52b80-eb02-11dd-ba2f-0800200c9a66}", "Belgium SAR"),
          color_scheme("{67482200-eb04-11dd-ba2f-0800200c9a66}", "Belgium Olive"),
        }),
      },
    },
    Fortifications =
    {
      CATID = "{7F1597F0-88EB-41cb-A04E-E9A4D5EF7466}",
      Fortification =
      {
        cnt_unit("{79BEF6B1-03EE-40A5-9D67-FE369D67D8F3}", "Locomotive"),
        cnt_unit("{5D159ABA-28C6-4E6A-BD41-B295AFA4E108}", "Electric locomotive"),
        cnt_unit("{A65C983E-3615-4350-93B2-128CBA8B3569}", "Coach a tank"),
        cnt_unit("{066A8FCF-6591-457C-888A-AF443AF95084}", "Coach cargo"),
        cnt_unit("{AA5E677A-BE23-4752-8C1A-24E25EC148CC}", "Coach cargo open"),
        cnt_unit("{77348759-616D-4500-9AB8-701D9F8028CD}", "Coach a platform"),
        cnt_unit("{8B096AEA-9E18-4541-8120-0DAB3BC57170}", "Coach a passenger"),
        cnt_unit("{71AC463C-310A-41ce-B7E7-923AC3CA5EDC}", ".Block"),
        cnt_unit("{B54053A8-B054-4a0b-871C-6DDA65ED90EF}", ".Block on road"),
        cnt_unit("{20A1B146-07C6-4ee6-851C-DBBC92135446}", ".Bunker"),
        cnt_unit("{2848C193-6789-472c-8430-AF3D739BB6C8}", ".Pill-box"),
        cnt_unit("{64DE4673-7D3E-424f-AB29-F4336AC38F98}", ".Command Center"),
        cnt_unit("{85D3DBF2-05DF-48e1-9C49-FD104E65A76E}", ".Ammunition depot"),
        cnt_unit("{7c822c60-9885-4a44-8add-b87511ff0fc5}", "Hangar A"),
        cnt_unit("{f0f48213-396f-4cc2-9fec-2f308cb11154}", "Tank"),
        cnt_unit("{b0e8ef18-c50c-4695-ac6e-1033b3691ce2}", "Tech hangar A"),
        cnt_unit("{db4d86a5-f9d6-4db1-b6ff-72153d082fc8}", "Farm A"),
        cnt_unit("{d406d212-8425-41be-83a1-502864f221dd}", "Farm B"),
        cnt_unit("{e8f80c05-dd74-4ce4-a232-f29afa025c3b}", "Garage A"),
        cnt_unit("{c5f17833-f456-45be-8c7c-ab28996f0e85}", "Boiler-house A"),
        cnt_unit("{65c10c17-e726-46d4-a380-db42706b923f}", "Restaurant 1"),
        cnt_unit("{80af40db-22ac-4e42-ab24-a015d1a21311}", "Warehouse"),
        cnt_unit("{fe75a842-e794-4650-9197-22797513dc72}", "Comms tower M"),
        cnt_unit("{70bf5fc8-441f-47cb-b587-d8f36ab81600}", "Cafe"),
        cnt_unit("{bddc2805-fd70-47dd-90b0-0041ebd1eee3}", "Workshop A"),
        cnt_unit("{7d0fa1db-38a1-4bf8-9169-943e11d49001}", "Electric power box"),
        cnt_unit("{d161a6b7-3946-49b2-af4c-aef104809480}", "Supermarket A"),
        cnt_unit("{1a4b08df-98c6-45da-bfea-161d7ad0135f}", "Water tower A"),
        cnt_unit("{cc06c05a-da19-494c-8066-04bb6b2f375b}", "TV tower"),
        cnt_unit("{2fe5cb79-1395-4b34-a112-913e964534e9}", "Shelter"),
        cnt_unit("{56c3c279-31f6-4cb9-ba63-6025f14adb08}", "Repair workshop"),
        cnt_unit("{4d01350e-eac5-406a-8daf-a1e1cc74c03b}", "Railway station"),
        cnt_unit("{557eab86-9e3d-459f-880b-3bfbd3b397fe}", "Railway crossing A"),
        cnt_unit("{8ff4a140-121e-4b25-a7e1-72bf64a3645c}", "Railway crossing B"),
        cnt_unit("{044858e2-4d40-4702-a185-70ee80f07151}", "WC"),
        cnt_unit("{72c629a7-112d-4a3e-9032-ba62dab2e36d}", "Small house 1A area"),
        cnt_unit("{40cf54da-bdb2-4993-a619-f5504200c3f5}", "Small house 1A"),
        cnt_unit("{95dbcac0-35e6-4621-bb02-a500666e337e}", "Small house 1B area"),
        cnt_unit("{8b22a3fd-8d96-4320-81b5-04f2c9edb247}", "Small house 1B"),
        cnt_unit("{7ae8526a-0edc-46ca-bf03-a1dc10445fcd}", "Small house 1C area"),
        cnt_unit("{9f6a6842-f5a5-4953-871b-58e0a2278849}", "Small house 2C"),
        cnt_unit("{aa0f2150-ed5c-4b66-8c7a-39ab3bccf5e3}", "Shop"),
        cnt_unit("{0a4804d2-db83-4a18-bf2a-a253a9b17e33}", "Tech combine"),
        cnt_unit("{264c3fb6-7871-471a-8915-a68afe98fbb5}", "Chemical tank A"),
        cnt_unit("{2cca8015-d0a0-43f7-bc89-0bf1cf290246}", "Small werehouse 1"),
        cnt_unit("{14b9c61c-bf3a-4dff-939c-5f3d55351d4e}", "Small werehouse 2"),
        cnt_unit("{ffe9021e-7d44-4ab3-8df9-0696d2506148}", "Small werehouse 3"),
        cnt_unit("{4b6bcf8c-6e4c-485b-a8f3-ac4de3338b5f}", "Small werehouse 4"),
        cnt_unit("{e0b21ae2-029b-4c20-986c-9c469d69b2c8}", "Garage B"),
        cnt_unit("{70a0edf9-c9bd-42c8-b260-e97927ebaaaa}", "Garage small A"),
        cnt_unit("{e4322f04-ba0d-43db-afe9-16025738ebeb}", "Garage small B"),
        cnt_unit("{36ac22c8-9737-4bdc-b59e-fd0fb823daaa}", "Pump station"),
        cnt_unit("{7d517890-d7ea-4ede-9c73-5be252b96d3f}", "Oil derrick"),
        cnt_unit("{d4fd6053-a036-4adf-8395-beca84e9efbb}", "Container red 1"),
        cnt_unit("{edd392fd-f262-4609-84d3-c09f126478ee}", "Container red 2"),
        cnt_unit("{dc005e97-7820-4cce-bc0e-edd875baaf92}", "Container red 3"),
        cnt_unit("{662e6cea-5a59-473f-87e9-e34d01f1ddb7}", "Container white"),
        cnt_unit("{d55f444b-745a-4954-bd4c-0ea1781f67a7}", "Container brown"),
        cnt_unit("{7f3722ae-10bc-49c5-a3cc-68ab89878c5b}", "Barracks 1"),
        cnt_unit("{eb3bac2d-4c24-4ff8-8c8a-dcd3d0c98750}", "Barracks 2"),
        cnt_unit("{a056cc08-9b50-45b1-b798-e0eb4277ea86}", "Military staff"),
        cnt_unit("{2b1802df-c4f9-404f-afe1-5f291ef68d30}", "Watchtower"),
        cnt_unit("{e9e4e232-b0c8-4306-b013-2f9defbb04d1}", "Hangar B"),
        cnt_unit("{07a6695a-2373-489f-a0a0-e1e35dd03b85}", "Fuel tank"),
        cnt_unit("{25f698c7-ee7b-40be-bafb-d97e64c487f3}", "Shelter B"),
        cnt_unit("{e0f6d8f9-0692-4695-933b-6e87636c7acb}", "Oil platform"),
        cnt_unit("{6d518ff5-cfca-4a7c-921b-ee3621a4207d}", "Subsidiary structure 1"),
        cnt_unit("{47a39247-7989-4f6d-bbb8-2cdd40e012dd}", "Subsidiary structure 2"),
        cnt_unit("{e58952f4-d2e9-43bc-a5ea-854d4678ef96}", "Subsidiary structure 3"),
        cnt_unit("{394ff644-013b-4f88-bfe1-1277cbcba8cc}", "Subsidiary structure A"),
        cnt_unit("{c724c713-61ad-4fb0-807d-dc6eb4a89884}", "Subsidiary structure B"),
        cnt_unit("{162b2803-ddf1-4b0e-9b95-b45b2f35ee30}", "Subsidiary structure C"),
        cnt_unit("{9cbba4f7-7014-4f67-b69a-4a458e5f2420}", "Subsidiary structure D"),
        cnt_unit("{dbb8c3f5-f1ea-42e1-b486-482ef41a4e53}", "Subsidiary structure E"),
        cnt_unit("{74e14790-da2b-4269-bd94-0bfa2dee0031}", "Subsidiary structure F"),
        cnt_unit("{96fc5825-e329-468d-83d8-fc9326d8aa52}", "Subsidiary structure G"),
        cnt_unit("{30D37BB2-F438-45ae-B09D-F00B1EFCB790}", "Landmine"),
        cnt_unit("{7c9d05ea-0b54-4d5c-9d6f-fa2cde39e349}", "FARP Ammo Dump Coating"),
        cnt_unit("{80c39fb0-854f-461b-bc4b-b2b51d0c4139}", "FARP Tent"),
        cnt_unit("{a947d0fd-9268-4851-a885-cb59aebe9bbc}", "FARP CP Blindage"),
        cnt_unit("{3441baf3-7ff7-4d76-ab9e-77f768b7813f}", "FARP Fuel Depot"),
        cnt_unit("{7e58d67d-191e-4e2c-ad22-a9c50cd48f53}", "GeneratorF"),
      },
    },
  },
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Medaille van militaire verdienste ', _('Medaille van militaire verdienste '), 200,  'BEL-01-Officer_of_the_Order_of_Leopold-1.png'),
    award('Erekruis voor militaire dienst in het buitenland ', _('Erekruis voor militaire dienst in het buitenland '), 600,  'BEL-02-Officer_of_the_Order_of_the_Crown.png'),
    award('Militair Kruis 2de Klas', _('Militair Kruis 2de Klas'), 1000, 'BEL-03-Officer_of_the_Order_of_Leopold-2.png'),
    award('Militair Kruis 1ste Klas', _('Militair Kruis 1ste Klas'), 1400, 'BEL-04-Knight_of_the_Order_of_Leopold.png'),
    award('Ridder in de Leopoldsorde', _('Ridder in de Leopoldsorde'), 1800, 'BEL-05-Military_Cross_1st_Class.png'),
    award('Officier in de Orde van Leopold II', _('Officier in de Orde van Leopold II'), 2200, 'BEL-06-Military_Cross_2nd_Class.png'),
    award('Officier in de Kroonorde', _('Officier in de Kroonorde'), 2600, 'BEL-07-Military_Cross_for_Foreign_Service.png'),
    award('Officier in de Leopoldsorde', _('Officier in de Leopoldsorde'), 3000, 'BEL-08-Medal_for_Military_Merit.png'),          
  },
  'Belgium.lua',
    {0,60,64,30}
);

country("{1F55BB4A-F52D-48F0-9886-698951048345}", _("Norway"), "Norway", "NOR", "Norway.png", 12,
  {
    Planes =
    {
      CATID = "{C168A850-3C0B-436a-95B5-C4A015552560}",
      Plane =
      {
        cnt_unit("{0213FA86-978D-4586-BAC3-BD642AD52B96}", "C-130", {
          color_scheme("{FA5CF748-D86A-4491-9F3D-5388B1C506CD}", "Skvadron 335"),
        }),
        cnt_unit("{2B1638C8-9321-4d90-A7C8-8E9EB342C0F5}", "F-16A MLU", {
          color_scheme("{1374cf6a-dd82-40ed-b35b-9e322eb12064}", "AF F16 Standart"),
        }),
      },
    },
    Heliports =
    {
      CATID = "{E6490BAB-7129-4d23-9023-1CFE810886EF}",
      Heliport =
      {
        cnt_unit("{24FC9197-F225-4f2a-8A31-BD51DC7BDAB6}", "FARP"),
      },
    },
    Ships =
    {
      CATID = "{AAFD44F1-C080-4572-9465-3A52C46F2A45}",
      Ship =
      {
        cnt_unit("{6449989a-2f92-48ed-89bf-d0ae87176cb3}", "speedboat"),
      },
    },
    Cars =
    {
      CATID = "{6CAE2420-8E36-40f3-8586-E853AADB9199}",
      Car =
      {
        cnt_unit("{3BDD3518-974C-49EB-8746-54A8DD91C14F}", "M-113"),
        cnt_unit("{6E93EACB-F7DB-4208-88C4-8D6465869A05}", "Hawk sr"),
        cnt_unit("{6FD50C44-10A0-458F-AF4E-0472EEFCD07E}", "Hawk tr"),
        cnt_unit("{DEAC9323-0320-482A-A4DC-DC7ABCB4B987}", "Hawk ln"),
        cnt_unit("{5A76E1FB-E73B-4D93-B61B-967AB6F87508}", "Hummer"),
        cnt_unit("{A543AD97-7C33-4655-9A9A-FDB9F1D42248}", "M-109"),
        cnt_unit("{3C8BFE7F-E0B6-4FF7-8DCD-CC165BE5D5BC}", "MLRS"),
        cnt_unit("{B84C5FC5-9893-45e4-A712-E3D4D201A003}", "Stinger manpad"),
        cnt_unit("{DFC5C4AA-EFE7-4929-A305-B8785BCD6704}", "Stinger comm"),
        cnt_unit("{0EDE3912-F55C-402a-95AF-36BB3106BEA2}", "M 818"),
        cnt_unit("{16263664-B3F8-4DA7-B61D-BF2445D3C469}", "Leopard1A3"),
      },
    },
    Helicopters =
    {
      CATID = "{828CEADE-3F1D-40aa-93CE-8CDB73FE2710}",
      Helicopter =
      {
      cnt_unit("{3457BB1E-523F-4C24-BBEA-58D028623F05}", "Ka-50", {
          color_scheme("{119c5110-ecac-11dd-ba2f-0800200c9a66}", "Norway Camo"),
        }),
      },
    },
    Fortifications =
    {
      CATID = "{7F1597F0-88EB-41cb-A04E-E9A4D5EF7466}",
      Fortification =
      {
        cnt_unit("{79BEF6B1-03EE-40A5-9D67-FE369D67D8F3}", "Locomotive"),
        cnt_unit("{5D159ABA-28C6-4E6A-BD41-B295AFA4E108}", "Electric locomotive"),
        cnt_unit("{A65C983E-3615-4350-93B2-128CBA8B3569}", "Coach a tank"),
        cnt_unit("{066A8FCF-6591-457C-888A-AF443AF95084}", "Coach cargo"),
        cnt_unit("{AA5E677A-BE23-4752-8C1A-24E25EC148CC}", "Coach cargo open"),
        cnt_unit("{77348759-616D-4500-9AB8-701D9F8028CD}", "Coach a platform"),
        cnt_unit("{8B096AEA-9E18-4541-8120-0DAB3BC57170}", "Coach a passenger"),
        cnt_unit("{71AC463C-310A-41ce-B7E7-923AC3CA5EDC}", ".Block"),
        cnt_unit("{B54053A8-B054-4a0b-871C-6DDA65ED90EF}", ".Block on road"),
        cnt_unit("{20A1B146-07C6-4ee6-851C-DBBC92135446}", ".Bunker"),
        cnt_unit("{2848C193-6789-472c-8430-AF3D739BB6C8}", ".Pill-box"),
        cnt_unit("{64DE4673-7D3E-424f-AB29-F4336AC38F98}", ".Command Center"),
        cnt_unit("{85D3DBF2-05DF-48e1-9C49-FD104E65A76E}", ".Ammunition depot"),
        cnt_unit("{7c822c60-9885-4a44-8add-b87511ff0fc5}", "Hangar A"),
        cnt_unit("{f0f48213-396f-4cc2-9fec-2f308cb11154}", "Tank"),
        cnt_unit("{b0e8ef18-c50c-4695-ac6e-1033b3691ce2}", "Tech hangar A"),
        cnt_unit("{db4d86a5-f9d6-4db1-b6ff-72153d082fc8}", "Farm A"),
        cnt_unit("{d406d212-8425-41be-83a1-502864f221dd}", "Farm B"),
        cnt_unit("{e8f80c05-dd74-4ce4-a232-f29afa025c3b}", "Garage A"),
        cnt_unit("{c5f17833-f456-45be-8c7c-ab28996f0e85}", "Boiler-house A"),
        cnt_unit("{65c10c17-e726-46d4-a380-db42706b923f}", "Restaurant 1"),
        cnt_unit("{80af40db-22ac-4e42-ab24-a015d1a21311}", "Warehouse"),
        cnt_unit("{fe75a842-e794-4650-9197-22797513dc72}", "Comms tower M"),
        cnt_unit("{70bf5fc8-441f-47cb-b587-d8f36ab81600}", "Cafe"),
        cnt_unit("{bddc2805-fd70-47dd-90b0-0041ebd1eee3}", "Workshop A"),
        cnt_unit("{7d0fa1db-38a1-4bf8-9169-943e11d49001}", "Electric power box"),
        cnt_unit("{d161a6b7-3946-49b2-af4c-aef104809480}", "Supermarket A"),
        cnt_unit("{1a4b08df-98c6-45da-bfea-161d7ad0135f}", "Water tower A"),
        cnt_unit("{cc06c05a-da19-494c-8066-04bb6b2f375b}", "TV tower"),
        cnt_unit("{2fe5cb79-1395-4b34-a112-913e964534e9}", "Shelter"),
        cnt_unit("{56c3c279-31f6-4cb9-ba63-6025f14adb08}", "Repair workshop"),
        cnt_unit("{4d01350e-eac5-406a-8daf-a1e1cc74c03b}", "Railway station"),
        cnt_unit("{557eab86-9e3d-459f-880b-3bfbd3b397fe}", "Railway crossing A"),
        cnt_unit("{8ff4a140-121e-4b25-a7e1-72bf64a3645c}", "Railway crossing B"),
        cnt_unit("{044858e2-4d40-4702-a185-70ee80f07151}", "WC"),
        cnt_unit("{72c629a7-112d-4a3e-9032-ba62dab2e36d}", "Small house 1A area"),
        cnt_unit("{40cf54da-bdb2-4993-a619-f5504200c3f5}", "Small house 1A"),
        cnt_unit("{95dbcac0-35e6-4621-bb02-a500666e337e}", "Small house 1B area"),
        cnt_unit("{8b22a3fd-8d96-4320-81b5-04f2c9edb247}", "Small house 1B"),
        cnt_unit("{7ae8526a-0edc-46ca-bf03-a1dc10445fcd}", "Small house 1C area"),
        cnt_unit("{9f6a6842-f5a5-4953-871b-58e0a2278849}", "Small house 2C"),
        cnt_unit("{aa0f2150-ed5c-4b66-8c7a-39ab3bccf5e3}", "Shop"),
        cnt_unit("{0a4804d2-db83-4a18-bf2a-a253a9b17e33}", "Tech combine"),
        cnt_unit("{264c3fb6-7871-471a-8915-a68afe98fbb5}", "Chemical tank A"),
        cnt_unit("{2cca8015-d0a0-43f7-bc89-0bf1cf290246}", "Small werehouse 1"),
        cnt_unit("{14b9c61c-bf3a-4dff-939c-5f3d55351d4e}", "Small werehouse 2"),
        cnt_unit("{ffe9021e-7d44-4ab3-8df9-0696d2506148}", "Small werehouse 3"),
        cnt_unit("{4b6bcf8c-6e4c-485b-a8f3-ac4de3338b5f}", "Small werehouse 4"),
        cnt_unit("{e0b21ae2-029b-4c20-986c-9c469d69b2c8}", "Garage B"),
        cnt_unit("{70a0edf9-c9bd-42c8-b260-e97927ebaaaa}", "Garage small A"),
        cnt_unit("{e4322f04-ba0d-43db-afe9-16025738ebeb}", "Garage small B"),
        cnt_unit("{36ac22c8-9737-4bdc-b59e-fd0fb823daaa}", "Pump station"),
        cnt_unit("{7d517890-d7ea-4ede-9c73-5be252b96d3f}", "Oil derrick"),
        cnt_unit("{d4fd6053-a036-4adf-8395-beca84e9efbb}", "Container red 1"),
        cnt_unit("{edd392fd-f262-4609-84d3-c09f126478ee}", "Container red 2"),
        cnt_unit("{dc005e97-7820-4cce-bc0e-edd875baaf92}", "Container red 3"),
        cnt_unit("{662e6cea-5a59-473f-87e9-e34d01f1ddb7}", "Container white"),
        cnt_unit("{d55f444b-745a-4954-bd4c-0ea1781f67a7}", "Container brown"),
        cnt_unit("{7f3722ae-10bc-49c5-a3cc-68ab89878c5b}", "Barracks 1"),
        cnt_unit("{eb3bac2d-4c24-4ff8-8c8a-dcd3d0c98750}", "Barracks 2"),
        cnt_unit("{a056cc08-9b50-45b1-b798-e0eb4277ea86}", "Military staff"),
        cnt_unit("{2b1802df-c4f9-404f-afe1-5f291ef68d30}", "Watchtower"),
        cnt_unit("{e9e4e232-b0c8-4306-b013-2f9defbb04d1}", "Hangar B"),
        cnt_unit("{07a6695a-2373-489f-a0a0-e1e35dd03b85}", "Fuel tank"),
        cnt_unit("{25f698c7-ee7b-40be-bafb-d97e64c487f3}", "Shelter B"),
        cnt_unit("{e0f6d8f9-0692-4695-933b-6e87636c7acb}", "Oil platform"),
        cnt_unit("{6d518ff5-cfca-4a7c-921b-ee3621a4207d}", "Subsidiary structure 1"),
        cnt_unit("{47a39247-7989-4f6d-bbb8-2cdd40e012dd}", "Subsidiary structure 2"),
        cnt_unit("{e58952f4-d2e9-43bc-a5ea-854d4678ef96}", "Subsidiary structure 3"),
        cnt_unit("{394ff644-013b-4f88-bfe1-1277cbcba8cc}", "Subsidiary structure A"),
        cnt_unit("{c724c713-61ad-4fb0-807d-dc6eb4a89884}", "Subsidiary structure B"),
        cnt_unit("{162b2803-ddf1-4b0e-9b95-b45b2f35ee30}", "Subsidiary structure C"),
        cnt_unit("{9cbba4f7-7014-4f67-b69a-4a458e5f2420}", "Subsidiary structure D"),
        cnt_unit("{dbb8c3f5-f1ea-42e1-b486-482ef41a4e53}", "Subsidiary structure E"),
        cnt_unit("{74e14790-da2b-4269-bd94-0bfa2dee0031}", "Subsidiary structure F"),
        cnt_unit("{96fc5825-e329-468d-83d8-fc9326d8aa52}", "Subsidiary structure G"),
        cnt_unit("{30D37BB2-F438-45ae-B09D-F00B1EFCB790}", "Landmine"),
        cnt_unit("{7c9d05ea-0b54-4d5c-9d6f-fa2cde39e349}", "FARP Ammo Dump Coating"),
        cnt_unit("{80c39fb0-854f-461b-bc4b-b2b51d0c4139}", "FARP Tent"),
        cnt_unit("{a947d0fd-9268-4851-a885-cb59aebe9bbc}", "FARP CP Blindage"),
        cnt_unit("{3441baf3-7ff7-4d76-ab9e-77f768b7813f}", "FARP Fuel Depot"),
        cnt_unit("{7e58d67d-191e-4e2c-ad22-a9c50cd48f53}", "GeneratorF"),
      },
    },
  },
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Vernedyktighetsmedaljen', _('Vernedyktighetsmedaljen'), 200,  'NOR-01-AirForceServiceMedal.png'),
    award('Forsvarets Medalje for Internasjonale Operasjoner', _('Forsvarets Medalje for Internasjonale Operasjoner'), 600,  'NOR-02-Armed_Forces_medal_for_international_operations.png'),
    award('Forsvarsmedaljen', _('Forsvarsmedaljen'), 1000, 'NOR-03-Armed_Forces_medal.png'),
    award('Forsvarsmedaljen m Laurbargren', _('Forsvarsmedaljen m Laurbargren'), 1400, 'NOR-04-Armed_Forces_medal_with_Laureat.png'),                  
    award('Krigskorset', _('Krigskorset'), 1800, 'NOR-05-War_Cross.png'),                                  
    award('St Olavsmedaljen', _('St Olavsmedaljen'), 2200, 'NOR-06-StOlaf_Medal.png'),
    award('Krigsmedaljen', _('Krigsmedaljen'), 2600, 'NOR-07-War_Medal.png'),                                
    award('Den kongelige Norske St Olavs orden', _('Den kongelige Norske St Olavs orden'), 3000, 'NOR-08-StOlaf_Knight.png'),                                                                            
  },                                         
  'Norway.lua',
  {0,270,64,30}
);

country("{400A1CBC-E08E-41A0-A4E8-77F0BA21D7C4}", _("Denmark"), "Denmark", "DEN", "Denmark.png", 13,
  {
    Planes =
    {
      CATID = "{C168A850-3C0B-436a-95B5-C4A015552560}",
      Plane =
      {
        cnt_unit("{0213FA86-978D-4586-BAC3-BD642AD52B96}", "C-130", {
          color_scheme("{0BB3C626-0713-493a-AC76-77EB5E139ADB}", "Eskadrille 721"),
        }),
        cnt_unit("{2B1638C8-9321-4d90-A7C8-8E9EB342C0F5}", "F-16A MLU", {
          color_scheme("{dd087621-15ba-4cab-8567-22126dee482e}", "RDAF F16 Standart-1"),
        }),
      },
    },
    Heliports =
    {
      CATID = "{E6490BAB-7129-4d23-9023-1CFE810886EF}",
      Heliport =
      {
        cnt_unit("{24FC9197-F225-4f2a-8A31-BD51DC7BDAB6}", "FARP"),
      },
    },
    Ships =
    {
      CATID = "{AAFD44F1-C080-4572-9465-3A52C46F2A45}",
      Ship =
      {
        cnt_unit("{6449989a-2f92-48ed-89bf-d0ae87176cb3}", "speedboat"),
      },
    },
    Cars =
    {
      CATID = "{6CAE2420-8E36-40f3-8586-E853AADB9199}",
      Car =
      {
        cnt_unit("{3BDD3518-974C-49EB-8746-54A8DD91C14F}", "M-113"),
        cnt_unit("{6E93EACB-F7DB-4208-88C4-8D6465869A05}", "Hawk sr"),
        cnt_unit("{6FD50C44-10A0-458F-AF4E-0472EEFCD07E}", "Hawk tr"),
        cnt_unit("{DEAC9323-0320-482A-A4DC-DC7ABCB4B987}", "Hawk ln"),
        cnt_unit("{5A76E1FB-E73B-4D93-B61B-967AB6F87508}", "Hummer"),
        cnt_unit("{A543AD97-7C33-4655-9A9A-FDB9F1D42248}", "M-109"),
        cnt_unit("{3C8BFE7F-E0B6-4FF7-8DCD-CC165BE5D5BC}", "MLRS"),
        cnt_unit("{B84C5FC5-9893-45e4-A712-E3D4D201A003}", "Stinger manpad"),
        cnt_unit("{DFC5C4AA-EFE7-4929-A305-B8785BCD6704}", "Stinger comm"),
        cnt_unit("{0EDE3912-F55C-402a-95AF-36BB3106BEA2}", "M 818"),
        cnt_unit("{16263664-B3F8-4DA7-B61D-BF2445D3C469}", "Leopard1A3"),
      },
    },
    Helicopters =
    {
      CATID = "{828CEADE-3F1D-40aa-93CE-8CDB73FE2710}",
      Helicopter =
      {
      cnt_unit("{3457BB1E-523F-4C24-BBEA-58D028623F05}", "Ka-50", {
          color_scheme("{c9ffd260-eb06-11dd-ba2f-0800200c9a66}", "Denmark Camo"),
          color_scheme("{0d0d3730-220e-11de-8c30-0800200c9a66}", "Navy Trainer"),
        }),
      },
    },
    Fortifications =
    {
      CATID = "{7F1597F0-88EB-41cb-A04E-E9A4D5EF7466}",
      Fortification =
      {
        cnt_unit("{79BEF6B1-03EE-40A5-9D67-FE369D67D8F3}", "Locomotive"),
        cnt_unit("{5D159ABA-28C6-4E6A-BD41-B295AFA4E108}", "Electric locomotive"),
        cnt_unit("{A65C983E-3615-4350-93B2-128CBA8B3569}", "Coach a tank"),
        cnt_unit("{066A8FCF-6591-457C-888A-AF443AF95084}", "Coach cargo"),
        cnt_unit("{AA5E677A-BE23-4752-8C1A-24E25EC148CC}", "Coach cargo open"),
        cnt_unit("{77348759-616D-4500-9AB8-701D9F8028CD}", "Coach a platform"),
        cnt_unit("{8B096AEA-9E18-4541-8120-0DAB3BC57170}", "Coach a passenger"),
        cnt_unit("{71AC463C-310A-41ce-B7E7-923AC3CA5EDC}", ".Block"),
        cnt_unit("{B54053A8-B054-4a0b-871C-6DDA65ED90EF}", ".Block on road"),
        cnt_unit("{20A1B146-07C6-4ee6-851C-DBBC92135446}", ".Bunker"),
        cnt_unit("{2848C193-6789-472c-8430-AF3D739BB6C8}", ".Pill-box"),
        cnt_unit("{64DE4673-7D3E-424f-AB29-F4336AC38F98}", ".Command Center"),
        cnt_unit("{85D3DBF2-05DF-48e1-9C49-FD104E65A76E}", ".Ammunition depot"),
        cnt_unit("{7c822c60-9885-4a44-8add-b87511ff0fc5}", "Hangar A"),
        cnt_unit("{f0f48213-396f-4cc2-9fec-2f308cb11154}", "Tank"),
        cnt_unit("{b0e8ef18-c50c-4695-ac6e-1033b3691ce2}", "Tech hangar A"),
        cnt_unit("{db4d86a5-f9d6-4db1-b6ff-72153d082fc8}", "Farm A"),
        cnt_unit("{d406d212-8425-41be-83a1-502864f221dd}", "Farm B"),
        cnt_unit("{e8f80c05-dd74-4ce4-a232-f29afa025c3b}", "Garage A"),
        cnt_unit("{c5f17833-f456-45be-8c7c-ab28996f0e85}", "Boiler-house A"),
        cnt_unit("{65c10c17-e726-46d4-a380-db42706b923f}", "Restaurant 1"),
        cnt_unit("{80af40db-22ac-4e42-ab24-a015d1a21311}", "Warehouse"),
        cnt_unit("{fe75a842-e794-4650-9197-22797513dc72}", "Comms tower M"),
        cnt_unit("{70bf5fc8-441f-47cb-b587-d8f36ab81600}", "Cafe"),
        cnt_unit("{bddc2805-fd70-47dd-90b0-0041ebd1eee3}", "Workshop A"),
        cnt_unit("{7d0fa1db-38a1-4bf8-9169-943e11d49001}", "Electric power box"),
        cnt_unit("{d161a6b7-3946-49b2-af4c-aef104809480}", "Supermarket A"),
        cnt_unit("{1a4b08df-98c6-45da-bfea-161d7ad0135f}", "Water tower A"),
        cnt_unit("{cc06c05a-da19-494c-8066-04bb6b2f375b}", "TV tower"),
        cnt_unit("{2fe5cb79-1395-4b34-a112-913e964534e9}", "Shelter"),
        cnt_unit("{56c3c279-31f6-4cb9-ba63-6025f14adb08}", "Repair workshop"),
        cnt_unit("{4d01350e-eac5-406a-8daf-a1e1cc74c03b}", "Railway station"),
        cnt_unit("{557eab86-9e3d-459f-880b-3bfbd3b397fe}", "Railway crossing A"),
        cnt_unit("{8ff4a140-121e-4b25-a7e1-72bf64a3645c}", "Railway crossing B"),
        cnt_unit("{044858e2-4d40-4702-a185-70ee80f07151}", "WC"),
        cnt_unit("{72c629a7-112d-4a3e-9032-ba62dab2e36d}", "Small house 1A area"),
        cnt_unit("{40cf54da-bdb2-4993-a619-f5504200c3f5}", "Small house 1A"),
        cnt_unit("{95dbcac0-35e6-4621-bb02-a500666e337e}", "Small house 1B area"),
        cnt_unit("{8b22a3fd-8d96-4320-81b5-04f2c9edb247}", "Small house 1B"),
        cnt_unit("{7ae8526a-0edc-46ca-bf03-a1dc10445fcd}", "Small house 1C area"),
        cnt_unit("{9f6a6842-f5a5-4953-871b-58e0a2278849}", "Small house 2C"),
        cnt_unit("{aa0f2150-ed5c-4b66-8c7a-39ab3bccf5e3}", "Shop"),
        cnt_unit("{0a4804d2-db83-4a18-bf2a-a253a9b17e33}", "Tech combine"),
        cnt_unit("{264c3fb6-7871-471a-8915-a68afe98fbb5}", "Chemical tank A"),
        cnt_unit("{2cca8015-d0a0-43f7-bc89-0bf1cf290246}", "Small werehouse 1"),
        cnt_unit("{14b9c61c-bf3a-4dff-939c-5f3d55351d4e}", "Small werehouse 2"),
        cnt_unit("{ffe9021e-7d44-4ab3-8df9-0696d2506148}", "Small werehouse 3"),
        cnt_unit("{4b6bcf8c-6e4c-485b-a8f3-ac4de3338b5f}", "Small werehouse 4"),
        cnt_unit("{e0b21ae2-029b-4c20-986c-9c469d69b2c8}", "Garage B"),
        cnt_unit("{70a0edf9-c9bd-42c8-b260-e97927ebaaaa}", "Garage small A"),
        cnt_unit("{e4322f04-ba0d-43db-afe9-16025738ebeb}", "Garage small B"),
        cnt_unit("{36ac22c8-9737-4bdc-b59e-fd0fb823daaa}", "Pump station"),
        cnt_unit("{7d517890-d7ea-4ede-9c73-5be252b96d3f}", "Oil derrick"),
        cnt_unit("{d4fd6053-a036-4adf-8395-beca84e9efbb}", "Container red 1"),
        cnt_unit("{edd392fd-f262-4609-84d3-c09f126478ee}", "Container red 2"),
        cnt_unit("{dc005e97-7820-4cce-bc0e-edd875baaf92}", "Container red 3"),
        cnt_unit("{662e6cea-5a59-473f-87e9-e34d01f1ddb7}", "Container white"),
        cnt_unit("{d55f444b-745a-4954-bd4c-0ea1781f67a7}", "Container brown"),
        cnt_unit("{7f3722ae-10bc-49c5-a3cc-68ab89878c5b}", "Barracks 1"),
        cnt_unit("{eb3bac2d-4c24-4ff8-8c8a-dcd3d0c98750}", "Barracks 2"),
        cnt_unit("{a056cc08-9b50-45b1-b798-e0eb4277ea86}", "Military staff"),
        cnt_unit("{2b1802df-c4f9-404f-afe1-5f291ef68d30}", "Watchtower"),
        cnt_unit("{e9e4e232-b0c8-4306-b013-2f9defbb04d1}", "Hangar B"),
        cnt_unit("{07a6695a-2373-489f-a0a0-e1e35dd03b85}", "Fuel tank"),
        cnt_unit("{25f698c7-ee7b-40be-bafb-d97e64c487f3}", "Shelter B"),
        cnt_unit("{e0f6d8f9-0692-4695-933b-6e87636c7acb}", "Oil platform"),
        cnt_unit("{6d518ff5-cfca-4a7c-921b-ee3621a4207d}", "Subsidiary structure 1"),
        cnt_unit("{47a39247-7989-4f6d-bbb8-2cdd40e012dd}", "Subsidiary structure 2"),
        cnt_unit("{e58952f4-d2e9-43bc-a5ea-854d4678ef96}", "Subsidiary structure 3"),
        cnt_unit("{394ff644-013b-4f88-bfe1-1277cbcba8cc}", "Subsidiary structure A"),
        cnt_unit("{c724c713-61ad-4fb0-807d-dc6eb4a89884}", "Subsidiary structure B"),
        cnt_unit("{162b2803-ddf1-4b0e-9b95-b45b2f35ee30}", "Subsidiary structure C"),
        cnt_unit("{9cbba4f7-7014-4f67-b69a-4a458e5f2420}", "Subsidiary structure D"),
        cnt_unit("{dbb8c3f5-f1ea-42e1-b486-482ef41a4e53}", "Subsidiary structure E"),
        cnt_unit("{74e14790-da2b-4269-bd94-0bfa2dee0031}", "Subsidiary structure F"),
        cnt_unit("{96fc5825-e329-468d-83d8-fc9326d8aa52}", "Subsidiary structure G"),
        cnt_unit("{30D37BB2-F438-45ae-B09D-F00B1EFCB790}", "Landmine"),
        cnt_unit("{7c9d05ea-0b54-4d5c-9d6f-fa2cde39e349}", "FARP Ammo Dump Coating"),
        cnt_unit("{80c39fb0-854f-461b-bc4b-b2b51d0c4139}", "FARP Tent"),
        cnt_unit("{a947d0fd-9268-4851-a885-cb59aebe9bbc}", "FARP CP Blindage"),
        cnt_unit("{3441baf3-7ff7-4d76-ab9e-77f768b7813f}", "FARP Fuel Depot"),
        cnt_unit("{7e58d67d-191e-4e2c-ad22-a9c50cd48f53}", "GeneratorF"),
      },
    },
  },
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Medaljen for udmarket lufttjeneste', _('Medaljen for udmarket lufttjeneste'), 200,  'DEN-01-Distinguished_Flying_Medal.png'),
    award('Dannebrogordenen Storkors', _('Dannebrogordenen Storkors'), 600,  'DEN-02-Silver_Cross_of_the_Order_of_Dannebrog.png'),
    award('Dannebrogordenen Ridderkors', _('Dannebrogordenen Ridderkors'), 1000, 'DEN-03-Order_of_Denneborg_Knight.png'),
    award('Dannebrogordenen Ridderkors af 1. grad', _('Dannebrogordenen Ridderkors af 1. grad'), 1400, 'DEN-04-Order_of_Danneburg_Knight_1st_Degree.png'),
    award('Hadertegnet for god tjeneste ved flyvevabnet', _('Hadertegnet for god tjeneste ved flyvevabnet'), 1800, 'DEN-05-Air_Force_Long_Service_Medal-25_years.png'),
    award('Forsvarets Medalje', _('Forsvarets Medalje'), 2200, 'DEN-06-Medal_of_the_Defence.png'),
    award('Dannebrogordenen Kommandorkors af 1. grad', _('Dannebrogordenen Kommandorkors af 1. grad'), 2600, 'DEN-07-Order_of_Danneburg_Commander_1st_Degree_Cross.png'),
    award('Forsvarets Medalje for Tapperhed', _('Forsvarets Medalje for Tapperhed'), 3000, 'DEN-08-Medal_for_Heroic_Deeds.png'),                       
  },                                         
  'Denmark.lua',
    {0,120,64,30}  
);

country("{12D14A19-81EA-437f-A119-E16EF4EAEBD0}", _("Georgia"), "Georgia", "GRG", "Georgia.png", 16,
  {
    Planes =
    {
      CATID = "{C168A850-3C0B-436a-95B5-C4A015552560}",
      Plane =
      {
        cnt_unit("{CC4276EE-EDB4-4EC0-BE13-4313ABDC7619}", "Su-25", {
          color_scheme("{4ADD5E62-787B-4571-AADA-47B586B3C0A8}", "Field Camo Scheme #1 (native)"),
          color_scheme("{3dc7de60-ce66-4069-bae4-321619ce8391}", "Field Camo Scheme #1 (worn-out)"),
          color_scheme("{d03f7f34-23b1-4595-8b77-65bbf0864a5d}", "\"Scorpion\" Demo Scheme (native)"),
        }),
        cnt_unit("{A5B4B173-F4C1-4331-9AB2-1ACDE185008F}", "An-26B", {
          color_scheme("{3FCBFB57-DD04-4F58-8CBC-3AF4E8C3E1AC}", "AF Standart"),
        }),
        cnt_unit("{31E68806-0891-4e12-9573-D1CFEA8C96F8}", "Su-25T", {
          color_scheme("{BA11B14F-6AF2-46c9-9D9A-99EEA6AC0AB0}", "AF Standard"),
          color_scheme("{3C91A83C-39F8-41f4-AFE8-2F0839C8ADFF}", "AF Standard 1"),
        }),
		cnt_unit("{{7061418E-5D0E-4b49-915D-ACEF1F2E6855}}", "Yak-40", {
          color_scheme("{{GEORGIA-STANDARD}}", "GE Standard"),  
        }),
      },
    },
    Heliports =
    {
      CATID = "{E6490BAB-7129-4d23-9023-1CFE810886EF}",
      Heliport =
      {
        cnt_unit("{24FC9197-F225-4f2a-8A31-BD51DC7BDAB6}", "FARP"),
      },
    },
    Ships =
    {
      CATID = "{AAFD44F1-C080-4572-9465-3A52C46F2A45}",
      Ship =
      {
        cnt_unit("{63CAFD18-C960-476B-BE9D-865C53A88146}", "ELNYA"),
        cnt_unit("{5CB43DA6-B4C1-498F-BB60-0EF0BA6D6BE7}", "ALBATROS"),
        cnt_unit("{C8459CF8-BD2E-4595-9C92-6625C0B8794E}", "MOLNIYA"),
        cnt_unit("{AD0D2B7F-EBB4-4415-AC14-B4D117D514D5}", "Dry-cargo ship-1"),
        cnt_unit("{21B074E6-780D-4ba5-963E-94D5C8436A4E}", "Dry-cargo ship-2"),
        cnt_unit("{843E23DF-8A61-40DD-8E33-41B1AEA7CF18}", "ZWEZDNY"),
        cnt_unit("{6449989a-2f92-48ed-89bf-d0ae87176cb3}", "speedboat"),
      },
    },
    Cars =
    {
      CATID = "{6CAE2420-8E36-40f3-8586-E853AADB9199}",
      Car =
      {
        cnt_unit("{10C3BD0E-4494-4bc4-BC37-2C544E33ADC7}", "BTR-80"),
        cnt_unit("{5C486AED-5DCE-4A0A-AF88-7343D3B2B43E}", "Strela-1 9P31"),
        cnt_unit("{DD80908D-C289-4AFA-A25E-A6697EC65FDE}", "Strela-10M3"),
        cnt_unit("{28704245-E952-427A-9C57-B2A6E0AB1E66}", "ZSU-23-4 Shilka"),
        cnt_unit("{AC6EAFDF-396C-4E27-8FED-BBB9B2868F2B}", "SA-11 Buk SR 9S18M1"),
        cnt_unit("{3EE3346E-9E4D-49FA-89CD-61D0151B3DB7}", "SA-11 Buk LN 9A310M1"),
        cnt_unit("{83485D57-2B11-4A83-9A7E-5FD47E9ADCEC}", "SAU Akatsia"),
        cnt_unit("{099A1146-4309-459F-A913-AAA515D70049}", "SAU 2-C9"),
        cnt_unit("{A97C0647-83EB-4B15-8B5B-BD2F8842DF91}", "ATMZ-5"),
        cnt_unit("{C0A5AA21-5A93-4707-9A9F-2AE24C4A22B0}", "ATZ-10"),
        cnt_unit("{82DAF699-2456-43F7-811D-76B922288915}", "Ural-375 APA-50"),
        cnt_unit("{A326AD1A-4820-4A5A-989D-5F3CCC174FCA}", "BMD-1"),
        cnt_unit("{A90A4A5B-5AF8-49CF-B363-BB81EF4A9256}", "BMP-1"),
        cnt_unit("{EBF0085E-E84E-401B-9F66-9C2B2BC7D214}", "BMP-2"),
        cnt_unit("{B33FB5B1-ABF0-48E6-A06B-6886A0132786}", "BRDM-2"),
        cnt_unit("{37DBF2AA-30C8-4FFA-A63A-D760623FF4E0}", "Grad-URAL"),
        cnt_unit("{1D6C2705-575C-4F35-A670-328ECBA007A3}", "UAZ-469"),
        cnt_unit("{85DF753A-0ECA-4143-88F8-5A46DEAB53C2}", "Ural-375"),
        cnt_unit("{20B6EAF4-E6D3-4FC2-A306-41951CAF1361}", "Ural-375 PBU"),
        cnt_unit("{4FC31476-127F-4608-876E-5D9B482F7E17}", "IKARUS Bus"),
        cnt_unit("{647DDAAC-CFB5-40AD-8394-042840EC4A6D}", "VAZ Car"),
        cnt_unit("{988392FB-77C0-461A-A738-DBEA8AB83030}", "Trolley bus"),
        cnt_unit("{254D09EB-5591-4D42-B513-3A15B9965B63}", "KAMAZ Truck"),
        cnt_unit("{D75AF34A-25E9-4BDE-A57A-E179AF185F2D}", "LAZ Bus"),
        cnt_unit("{672D3629-C30C-4ba5-A54D-68728E8C35E5}", "GAZ-3307"),
        cnt_unit("{DFABA701-5202-4d78-91FF-EAE6525099EC}", "GAZ-3308"),
        cnt_unit("{4CC190E5-CC9B-4c66-8071-C5A807B8DBB9}", "GAZ-66"),
        cnt_unit("{9A2584F4-2FEE-4f3c-A47F-35D97995FCE1}", "MAZ-6303"),
        cnt_unit("{4C763AC0-89AC-43a8-88D1-8FB710F42603}", "ZIL-4331"),
        cnt_unit("{8E5B2FB3-8845-4026-BC7F-16898FF9442B}", "Osa 9A33 ln"),
        cnt_unit("{693BB858-F64A-4af0-B4EF-0BE24B8406A6}", "SKP-11"),
        cnt_unit("{E8DC1D50-7463-4dfa-86D7-2F81C1214D06}", "Ural ATsP-6"),
        cnt_unit("{A207B91F-77F0-4647-8D74-88A9D3851EAD}", "ZiL-131 APA-80"),
        cnt_unit("{4D98849E-2A76-4017-9356-B9852B39EBA6}", "ZIL-131 KUNG"),
        cnt_unit("{B76231A9-4B8A-41e0-8EAD-65785077FC0C}", "ZU-23 Emplacement"),
        cnt_unit("{773F294C-4057-4789-892C-643BE8619778}", "ZU-23 Emplacement Closed"),
        cnt_unit("{96E2A468-E0D6-4e7f-A618-7C29E4DAD176}", "Ural-375 ZU-23"),
        cnt_unit("{C422DA78-1BC6-4FD7-BA48-CAE7674AA3A8}", "Dog Ear radar"),
        cnt_unit("{F16F5FBF-D121-47EC-9BFA-8140F30C8664}", "1L13 EWR"),
        cnt_unit("{B00A39DC-A02C-41ec-A041-51163608CB9C}", "MTLB"),
        cnt_unit("{40B742B7-3683-4fe5-A72A-A4E7E428159F}", "T-72B"),
        cnt_unit("{8C7CD125-65C9-44ec-BD3A-CC431263FF89}", "SA-18 Igla manpad"),
        cnt_unit("{CC83C3A7-4280-4018-9C45-2E4C6137C5E2}", "SA-18 Igla comm"),
        cnt_unit("{64066D8C-3785-4baf-A347-C585FE29746E}", "T-55"),
        cnt_unit("{B84C5FC5-9893-45e4-A712-E3D4D201A003}", "Stinger manpad"),
        cnt_unit("{DFC5C4AA-EFE7-4929-A305-B8785BCD6704}", "Stinger comm"),
        cnt_unit("{D3FE4F50-947B-4523-9176-F805EB4CEA7E}", "Soldier AK"),
        cnt_unit("{71866639-E9F9-4128-8AD0-B582FA3D27F4}", "Soldier RPG"),
        cnt_unit("{1e92e0f5-c183-4bc5-a4dd-2a437eff526b}", "Sandbox"),
        cnt_unit("{2dde8bcd-759c-4347-a4e3-eeec6c2c40a4}", "Bunker"),
      },
    },
    Helicopters =
    {
      CATID = "{828CEADE-3F1D-40aa-93CE-8CDB73FE2710}",
      Helicopter =
      {
        cnt_unit("{111132D6-F3AA-4C00-A53A-A6C5FB298572}", "UH-1H", {
          color_scheme("{18C2373D-414D-441B-9D1A-5CE4EBF02EB1}", "Standard"),
        }),
        cnt_unit("{C08CF845-F905-40F0-AF1B-554908BBE89E}", "Mi-8MT", {
          color_scheme("{CB825521-4034-4b46-A6A2-47B532BB5884}", "Standart1"),
        }),
        cnt_unit("{0903DF50-B9FA-441E-B94D-8F03DFF3E40D}", "Mi-24V", {
          color_scheme("{F0321615-E2F9-4c16-9D09-1166A1DF708E}", "Standard"),
        }),
        cnt_unit("{3457BB1E-523F-4C24-BBEA-58D028623F05}", "Ka-50", {
          color_scheme("{c9c17790-eb0b-11dd-ba2f-0800200c9a66}", "Georgia Camo"),
        }),
      },
    },
    Fortifications =
    {
      CATID = "{7F1597F0-88EB-41cb-A04E-E9A4D5EF7466}",
      Fortification =
      {
        cnt_unit("{79BEF6B1-03EE-40A5-9D67-FE369D67D8F3}", "Locomotive"),
        cnt_unit("{5D159ABA-28C6-4E6A-BD41-B295AFA4E108}", "Electric locomotive"),
        cnt_unit("{A65C983E-3615-4350-93B2-128CBA8B3569}", "Coach a tank"),
        cnt_unit("{066A8FCF-6591-457C-888A-AF443AF95084}", "Coach cargo"),
        cnt_unit("{AA5E677A-BE23-4752-8C1A-24E25EC148CC}", "Coach cargo open"),
        cnt_unit("{77348759-616D-4500-9AB8-701D9F8028CD}", "Coach a platform"),
        cnt_unit("{8B096AEA-9E18-4541-8120-0DAB3BC57170}", "Coach a passenger"),
        cnt_unit("{71AC463C-310A-41ce-B7E7-923AC3CA5EDC}", ".Block"),
        cnt_unit("{B54053A8-B054-4a0b-871C-6DDA65ED90EF}", ".Block on road"),
        cnt_unit("{20A1B146-07C6-4ee6-851C-DBBC92135446}", ".Bunker"),
        cnt_unit("{2848C193-6789-472c-8430-AF3D739BB6C8}", ".Pill-box"),
        cnt_unit("{64DE4673-7D3E-424f-AB29-F4336AC38F98}", ".Command Center"),
        cnt_unit("{85D3DBF2-05DF-48e1-9C49-FD104E65A76E}", ".Ammunition depot"),
        cnt_unit("{7c822c60-9885-4a44-8add-b87511ff0fc5}", "Hangar A"),
        cnt_unit("{f0f48213-396f-4cc2-9fec-2f308cb11154}", "Tank"),
        cnt_unit("{b0e8ef18-c50c-4695-ac6e-1033b3691ce2}", "Tech hangar A"),
        cnt_unit("{db4d86a5-f9d6-4db1-b6ff-72153d082fc8}", "Farm A"),
        cnt_unit("{d406d212-8425-41be-83a1-502864f221dd}", "Farm B"),
        cnt_unit("{e8f80c05-dd74-4ce4-a232-f29afa025c3b}", "Garage A"),
        cnt_unit("{c5f17833-f456-45be-8c7c-ab28996f0e85}", "Boiler-house A"),
        cnt_unit("{65c10c17-e726-46d4-a380-db42706b923f}", "Restaurant 1"),
        cnt_unit("{80af40db-22ac-4e42-ab24-a015d1a21311}", "Warehouse"),
        cnt_unit("{fe75a842-e794-4650-9197-22797513dc72}", "Comms tower M"),
        cnt_unit("{70bf5fc8-441f-47cb-b587-d8f36ab81600}", "Cafe"),
        cnt_unit("{bddc2805-fd70-47dd-90b0-0041ebd1eee3}", "Workshop A"),
        cnt_unit("{7d0fa1db-38a1-4bf8-9169-943e11d49001}", "Electric power box"),
        cnt_unit("{d161a6b7-3946-49b2-af4c-aef104809480}", "Supermarket A"),
        cnt_unit("{1a4b08df-98c6-45da-bfea-161d7ad0135f}", "Water tower A"),
        cnt_unit("{cc06c05a-da19-494c-8066-04bb6b2f375b}", "TV tower"),
        cnt_unit("{2fe5cb79-1395-4b34-a112-913e964534e9}", "Shelter"),
        cnt_unit("{56c3c279-31f6-4cb9-ba63-6025f14adb08}", "Repair workshop"),
        cnt_unit("{4d01350e-eac5-406a-8daf-a1e1cc74c03b}", "Railway station"),
        cnt_unit("{557eab86-9e3d-459f-880b-3bfbd3b397fe}", "Railway crossing A"),
        cnt_unit("{8ff4a140-121e-4b25-a7e1-72bf64a3645c}", "Railway crossing B"),
        cnt_unit("{044858e2-4d40-4702-a185-70ee80f07151}", "WC"),
        cnt_unit("{72c629a7-112d-4a3e-9032-ba62dab2e36d}", "Small house 1A area"),
        cnt_unit("{40cf54da-bdb2-4993-a619-f5504200c3f5}", "Small house 1A"),
        cnt_unit("{95dbcac0-35e6-4621-bb02-a500666e337e}", "Small house 1B area"),
        cnt_unit("{8b22a3fd-8d96-4320-81b5-04f2c9edb247}", "Small house 1B"),
        cnt_unit("{7ae8526a-0edc-46ca-bf03-a1dc10445fcd}", "Small house 1C area"),
        cnt_unit("{9f6a6842-f5a5-4953-871b-58e0a2278849}", "Small house 2C"),
        cnt_unit("{aa0f2150-ed5c-4b66-8c7a-39ab3bccf5e3}", "Shop"),
        cnt_unit("{0a4804d2-db83-4a18-bf2a-a253a9b17e33}", "Tech combine"),
        cnt_unit("{264c3fb6-7871-471a-8915-a68afe98fbb5}", "Chemical tank A"),
        cnt_unit("{2cca8015-d0a0-43f7-bc89-0bf1cf290246}", "Small werehouse 1"),
        cnt_unit("{14b9c61c-bf3a-4dff-939c-5f3d55351d4e}", "Small werehouse 2"),
        cnt_unit("{ffe9021e-7d44-4ab3-8df9-0696d2506148}", "Small werehouse 3"),
        cnt_unit("{4b6bcf8c-6e4c-485b-a8f3-ac4de3338b5f}", "Small werehouse 4"),
        cnt_unit("{e0b21ae2-029b-4c20-986c-9c469d69b2c8}", "Garage B"),
        cnt_unit("{70a0edf9-c9bd-42c8-b260-e97927ebaaaa}", "Garage small A"),
        cnt_unit("{e4322f04-ba0d-43db-afe9-16025738ebeb}", "Garage small B"),
        cnt_unit("{36ac22c8-9737-4bdc-b59e-fd0fb823daaa}", "Pump station"),
        cnt_unit("{7d517890-d7ea-4ede-9c73-5be252b96d3f}", "Oil derrick"),
        cnt_unit("{d4fd6053-a036-4adf-8395-beca84e9efbb}", "Container red 1"),
        cnt_unit("{edd392fd-f262-4609-84d3-c09f126478ee}", "Container red 2"),
        cnt_unit("{dc005e97-7820-4cce-bc0e-edd875baaf92}", "Container red 3"),
        cnt_unit("{662e6cea-5a59-473f-87e9-e34d01f1ddb7}", "Container white"),
        cnt_unit("{d55f444b-745a-4954-bd4c-0ea1781f67a7}", "Container brown"),
        cnt_unit("{7f3722ae-10bc-49c5-a3cc-68ab89878c5b}", "Barracks 1"),
        cnt_unit("{eb3bac2d-4c24-4ff8-8c8a-dcd3d0c98750}", "Barracks 2"),
        cnt_unit("{a056cc08-9b50-45b1-b798-e0eb4277ea86}", "Military staff"),
        cnt_unit("{2b1802df-c4f9-404f-afe1-5f291ef68d30}", "Watchtower"),
        cnt_unit("{e9e4e232-b0c8-4306-b013-2f9defbb04d1}", "Hangar B"),
        cnt_unit("{07a6695a-2373-489f-a0a0-e1e35dd03b85}", "Fuel tank"),
        cnt_unit("{25f698c7-ee7b-40be-bafb-d97e64c487f3}", "Shelter B"),
        cnt_unit("{e0f6d8f9-0692-4695-933b-6e87636c7acb}", "Oil platform"),
        cnt_unit("{6d518ff5-cfca-4a7c-921b-ee3621a4207d}", "Subsidiary structure 1"),
        cnt_unit("{47a39247-7989-4f6d-bbb8-2cdd40e012dd}", "Subsidiary structure 2"),
        cnt_unit("{e58952f4-d2e9-43bc-a5ea-854d4678ef96}", "Subsidiary structure 3"),
        cnt_unit("{394ff644-013b-4f88-bfe1-1277cbcba8cc}", "Subsidiary structure A"),
        cnt_unit("{c724c713-61ad-4fb0-807d-dc6eb4a89884}", "Subsidiary structure B"),
        cnt_unit("{162b2803-ddf1-4b0e-9b95-b45b2f35ee30}", "Subsidiary structure C"),
        cnt_unit("{9cbba4f7-7014-4f67-b69a-4a458e5f2420}", "Subsidiary structure D"),
        cnt_unit("{dbb8c3f5-f1ea-42e1-b486-482ef41a4e53}", "Subsidiary structure E"),
        cnt_unit("{74e14790-da2b-4269-bd94-0bfa2dee0031}", "Subsidiary structure F"),
        cnt_unit("{96fc5825-e329-468d-83d8-fc9326d8aa52}", "Subsidiary structure G"),
        cnt_unit("{30D37BB2-F438-45ae-B09D-F00B1EFCB790}", "Landmine"),
        cnt_unit("{7c9d05ea-0b54-4d5c-9d6f-fa2cde39e349}", "FARP Ammo Dump Coating"),
        cnt_unit("{80c39fb0-854f-461b-bc4b-b2b51d0c4139}", "FARP Tent"),
        cnt_unit("{a947d0fd-9268-4851-a885-cb59aebe9bbc}", "FARP CP Blindage"),
        cnt_unit("{3441baf3-7ff7-4d76-ab9e-77f768b7813f}", "FARP Fuel Depot"),
        cnt_unit("{7e58d67d-191e-4e2c-ad22-a9c50cd48f53}", "GeneratorF"),
      },
    },
  },
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('Medali "Sabrdzolo Damsakhurebisatvis"', _('Medali "Sabrdzolo Damsakhurebisatvis"'), 200,  'GR-01-Medal_for_the_Service_in_Battle.png'),
    award('Medali "Mkhedruli Mamatsobisatvis"', _('Medali "Mkhedruli Mamatsobisatvis"'), 600,  'GR-02-Medal_for_Military_Courage.png'),
    award('Vakhtang Gorgasalis Ordeni III', _('Vakhtang Gorgasalis Ordeni III'), 1000, 'GR-03-Order_of_Vakhtang_Gorgasali_III.png'),
    award('Vakhtang Gorgasalis Ordeni II', _('Vakhtang Gorgasalis Ordeni II'), 1400, 'GR-04-Order_of_Vakhtang_Gorgasali_II.png'),
    award('Vakhtang Gorgasalis Ordeni I', _('Vakhtang Gorgasalis Ordeni I'), 1800, 'GR-05-Order_of_Vakhtang_Gorgasali_I.png'),
    award('Girsebis Ordeni', _('Girsebis Ordeni'), 2200, 'GR-06-Order_of_Honour.png'),
    award('Girsebis Medali', _('Girsebis Medali'), 2600, 'GR-07-Medal_of_Valour.png'),
    award('Okros Satsmisis Ordeni', _('Okros Satsmisis Ordeni'), 3000, 'GR-08-Order_of_the_Gold_Fleece.png'),       
  },                                         
  'Georgia.lua',
    {0,180,64,30}
);

country("{9EAF1D3A-1F04-454c-A613-3422F8A59247}", _("Israel"), "Israel", "ISR", "Israel.png", 15,
  {
    Planes =
    {
      CATID = "{C168A850-3C0B-436a-95B5-C4A015552560}",
      Plane =
      {
        cnt_unit("{CD247E45-4702-4E3A-A659-4F5E0E645D2B}", "F-15C", {
          color_scheme("{A7C18417-3EA1-4B2B-B2FE-2D68E35ACCD1}", "IDF/AF F15 Standart"),
        }),
        cnt_unit("{082D2561-FB8B-11d5-9190-00A0249B6F00}", "F-16C bl.52d", {
          color_scheme("{E45A7ECE-4199-4257-937D-5207435A5786}", "IDF/AF F16C Standart"),
        }),
        cnt_unit("{0213FA86-978D-4586-BAC3-BD642AD52B96}", "C-130", {
          color_scheme("{1c4f5213-bed9-46c6-922f-b0018f23cdab}", "103 Squadron \"The Flying Elephants\""),
        }),
        cnt_unit("{4B75FEBA-9997-4D34-A0D6-0DB061350951}", "F-4E", {
          color_scheme("{D3697861-0EC9-47f2-A661-2E927D88AF66}", "AF Standart"),
        }),
      },
    },
    Heliports =
    {
      CATID = "{E6490BAB-7129-4d23-9023-1CFE810886EF}",
      Heliport =
      {
        cnt_unit("{24FC9197-F225-4f2a-8A31-BD51DC7BDAB6}", "FARP"),
      },
    },
    Ships =
    {
      CATID = "{AAFD44F1-C080-4572-9465-3A52C46F2A45}",
      Ship =
      {
        cnt_unit("{6449989a-2f92-48ed-89bf-d0ae87176cb3}", "speedboat"),
      },
    },
    Cars =
    {
      CATID = "{6CAE2420-8E36-40f3-8586-E853AADB9199}",
      Car =
      {
        cnt_unit("{3BDD3518-974C-49EB-8746-54A8DD91C14F}", "M-113"),
        cnt_unit("{B350FDB3-E7DA-4DF3-9F59-0DADD5933EEB}", "M1097 Avenger"),
        cnt_unit("{BDFF2359-B329-479A-A4D2-A14F3FB37DE4}", "Patriot str"),
        cnt_unit("{572AF10E-0FAC-4E2D-BA3F-96D6C08194FB}", "Patriot ln"),
        cnt_unit("{033A717B-2687-4d74-9A89-69C2535DAC48}", "Patriot cp"),
        cnt_unit("{6E93EACB-F7DB-4208-88C4-8D6465869A05}", "Hawk sr"),
        cnt_unit("{6FD50C44-10A0-458F-AF4E-0472EEFCD07E}", "Hawk tr"),
        cnt_unit("{DEAC9323-0320-482A-A4DC-DC7ABCB4B987}", "Hawk ln"),
        cnt_unit("{AC83CA0F-E7D9-4A25-9B1F-0CC163FA1684}", "Vulcan"),
        cnt_unit("{5A76E1FB-E73B-4D93-B61B-967AB6F87508}", "Hummer"),
        cnt_unit("{E982CA60-4C43-4C6A-A524-BF250D54E742}", "LAV-25"),
        cnt_unit("{E0B4364A-3E12-4DE3-84F2-F29EFAE17BED}", "AAV7"),
        cnt_unit("{A543AD97-7C33-4655-9A9A-FDB9F1D42248}", "M-109"),
        cnt_unit("{A3CA58E6-EBE9-4D9F-A6A2-0D295F85D306}", "M-60"),
        cnt_unit("{0EDE3912-F55C-402a-95AF-36BB3106BEA2}", "M 818"),
        cnt_unit("{6416E353-E50F-497f-9F7A-51A99788E18E}", "M48 Chaparral"),
        cnt_unit("{3C8BFE7F-E0B6-4FF7-8DCD-CC165BE5D5BC}", "MLRS"),
        cnt_unit("{53D43FFB-071F-4672-BBFA-7C4A8A28C0A1}", "Stinger manpad dsr"),
        cnt_unit("{07F01790-4301-4c9e-9D74-036D47B81076}", "Stinger comm dsr"),
      },
    },
    Helicopters =
    {
      CATID = "{828CEADE-3F1D-40aa-93CE-8CDB73FE2710}",
      Helicopter =
      {
        cnt_unit("{F324202D-A045-418B-86D0-7594454FDA81}", "AH-64A", {
          color_scheme("{50BCD3A5-1F57-4037-9FC4-708EF6F25442}", "Standard"),
        }),
        cnt_unit("{D49A54A7-1607-4779-88EE-7D4EF529CF5C}", "AH-1W", {
          color_scheme("{DD91959B-D828-4DBA-8437-BCE7930376A1}", "Standard"),
        }),
        cnt_unit("{8CC2AAFA-F5F6-498D-83E0-681561D691B8}", "UH-60A", {
          color_scheme("{FEA21BC0-A211-47E3-9FEF-A4043A04B6D3}", "Standard"),
        }),
        cnt_unit("{F939FD3E-229F-4A9F-AE99-5CD4D60DE5F9}", "AH-64D", {
          color_scheme("{181925D1-BF22-4260-A5CA-DE7A0AF57FB6}", "Standard"),
        }),
        cnt_unit("{3457BB1E-523F-4C24-BBEA-58D028623F05}", "Ka-50", {
          color_scheme("{b9363840-efaa-11dd-ba2f-0800200c9a66}", "IAF Camo 1"),
          color_scheme("{d2196210-efb9-11dd-ba2f-0800200c9a66}", "IAF Camo 2"),
          color_scheme("{1b9889f0-efdf-11dd-ba2f-0800200c9a66}", "IAF Camo 3"),
        }),
      },
    },
    Fortifications =
    {
      CATID = "{7F1597F0-88EB-41cb-A04E-E9A4D5EF7466}",
      Fortification =
      {
        cnt_unit("{79BEF6B1-03EE-40A5-9D67-FE369D67D8F3}", "Locomotive"),
        cnt_unit("{5D159ABA-28C6-4E6A-BD41-B295AFA4E108}", "Electric locomotive"),
        cnt_unit("{A65C983E-3615-4350-93B2-128CBA8B3569}", "Coach a tank"),
        cnt_unit("{066A8FCF-6591-457C-888A-AF443AF95084}", "Coach cargo"),
        cnt_unit("{AA5E677A-BE23-4752-8C1A-24E25EC148CC}", "Coach cargo open"),
        cnt_unit("{77348759-616D-4500-9AB8-701D9F8028CD}", "Coach a platform"),
        cnt_unit("{8B096AEA-9E18-4541-8120-0DAB3BC57170}", "Coach a passenger"),
        cnt_unit("{71AC463C-310A-41ce-B7E7-923AC3CA5EDC}", ".Block"),
        cnt_unit("{B54053A8-B054-4a0b-871C-6DDA65ED90EF}", ".Block on road"),
        cnt_unit("{20A1B146-07C6-4ee6-851C-DBBC92135446}", ".Bunker"),
        cnt_unit("{2848C193-6789-472c-8430-AF3D739BB6C8}", ".Pill-box"),
        cnt_unit("{64DE4673-7D3E-424f-AB29-F4336AC38F98}", ".Command Center"),
        cnt_unit("{85D3DBF2-05DF-48e1-9C49-FD104E65A76E}", ".Ammunition depot"),
        cnt_unit("{7c822c60-9885-4a44-8add-b87511ff0fc5}", "Hangar A"),
        cnt_unit("{f0f48213-396f-4cc2-9fec-2f308cb11154}", "Tank"),
        cnt_unit("{b0e8ef18-c50c-4695-ac6e-1033b3691ce2}", "Tech hangar A"),
        cnt_unit("{db4d86a5-f9d6-4db1-b6ff-72153d082fc8}", "Farm A"),
        cnt_unit("{d406d212-8425-41be-83a1-502864f221dd}", "Farm B"),
        cnt_unit("{e8f80c05-dd74-4ce4-a232-f29afa025c3b}", "Garage A"),
        cnt_unit("{c5f17833-f456-45be-8c7c-ab28996f0e85}", "Boiler-house A"),
        cnt_unit("{65c10c17-e726-46d4-a380-db42706b923f}", "Restaurant 1"),
        cnt_unit("{80af40db-22ac-4e42-ab24-a015d1a21311}", "Warehouse"),
        cnt_unit("{fe75a842-e794-4650-9197-22797513dc72}", "Comms tower M"),
        cnt_unit("{70bf5fc8-441f-47cb-b587-d8f36ab81600}", "Cafe"),
        cnt_unit("{bddc2805-fd70-47dd-90b0-0041ebd1eee3}", "Workshop A"),
        cnt_unit("{7d0fa1db-38a1-4bf8-9169-943e11d49001}", "Electric power box"),
        cnt_unit("{d161a6b7-3946-49b2-af4c-aef104809480}", "Supermarket A"),
        cnt_unit("{1a4b08df-98c6-45da-bfea-161d7ad0135f}", "Water tower A"),
        cnt_unit("{cc06c05a-da19-494c-8066-04bb6b2f375b}", "TV tower"),
        cnt_unit("{2fe5cb79-1395-4b34-a112-913e964534e9}", "Shelter"),
        cnt_unit("{56c3c279-31f6-4cb9-ba63-6025f14adb08}", "Repair workshop"),
        cnt_unit("{4d01350e-eac5-406a-8daf-a1e1cc74c03b}", "Railway station"),
        cnt_unit("{557eab86-9e3d-459f-880b-3bfbd3b397fe}", "Railway crossing A"),
        cnt_unit("{8ff4a140-121e-4b25-a7e1-72bf64a3645c}", "Railway crossing B"),
        cnt_unit("{044858e2-4d40-4702-a185-70ee80f07151}", "WC"),
        cnt_unit("{72c629a7-112d-4a3e-9032-ba62dab2e36d}", "Small house 1A area"),
        cnt_unit("{40cf54da-bdb2-4993-a619-f5504200c3f5}", "Small house 1A"),
        cnt_unit("{95dbcac0-35e6-4621-bb02-a500666e337e}", "Small house 1B area"),
        cnt_unit("{8b22a3fd-8d96-4320-81b5-04f2c9edb247}", "Small house 1B"),
        cnt_unit("{7ae8526a-0edc-46ca-bf03-a1dc10445fcd}", "Small house 1C area"),
        cnt_unit("{9f6a6842-f5a5-4953-871b-58e0a2278849}", "Small house 2C"),
        cnt_unit("{aa0f2150-ed5c-4b66-8c7a-39ab3bccf5e3}", "Shop"),
        cnt_unit("{0a4804d2-db83-4a18-bf2a-a253a9b17e33}", "Tech combine"),
        cnt_unit("{264c3fb6-7871-471a-8915-a68afe98fbb5}", "Chemical tank A"),
        cnt_unit("{2cca8015-d0a0-43f7-bc89-0bf1cf290246}", "Small werehouse 1"),
        cnt_unit("{14b9c61c-bf3a-4dff-939c-5f3d55351d4e}", "Small werehouse 2"),
        cnt_unit("{ffe9021e-7d44-4ab3-8df9-0696d2506148}", "Small werehouse 3"),
        cnt_unit("{4b6bcf8c-6e4c-485b-a8f3-ac4de3338b5f}", "Small werehouse 4"),
        cnt_unit("{e0b21ae2-029b-4c20-986c-9c469d69b2c8}", "Garage B"),
        cnt_unit("{70a0edf9-c9bd-42c8-b260-e97927ebaaaa}", "Garage small A"),
        cnt_unit("{e4322f04-ba0d-43db-afe9-16025738ebeb}", "Garage small B"),
        cnt_unit("{36ac22c8-9737-4bdc-b59e-fd0fb823daaa}", "Pump station"),
        cnt_unit("{7d517890-d7ea-4ede-9c73-5be252b96d3f}", "Oil derrick"),
        cnt_unit("{d4fd6053-a036-4adf-8395-beca84e9efbb}", "Container red 1"),
        cnt_unit("{edd392fd-f262-4609-84d3-c09f126478ee}", "Container red 2"),
        cnt_unit("{dc005e97-7820-4cce-bc0e-edd875baaf92}", "Container red 3"),
        cnt_unit("{662e6cea-5a59-473f-87e9-e34d01f1ddb7}", "Container white"),
        cnt_unit("{d55f444b-745a-4954-bd4c-0ea1781f67a7}", "Container brown"),
        cnt_unit("{7f3722ae-10bc-49c5-a3cc-68ab89878c5b}", "Barracks 1"),
        cnt_unit("{eb3bac2d-4c24-4ff8-8c8a-dcd3d0c98750}", "Barracks 2"),
        cnt_unit("{a056cc08-9b50-45b1-b798-e0eb4277ea86}", "Military staff"),
        cnt_unit("{2b1802df-c4f9-404f-afe1-5f291ef68d30}", "Watchtower"),
        cnt_unit("{e9e4e232-b0c8-4306-b013-2f9defbb04d1}", "Hangar B"),
        cnt_unit("{07a6695a-2373-489f-a0a0-e1e35dd03b85}", "Fuel tank"),
        cnt_unit("{25f698c7-ee7b-40be-bafb-d97e64c487f3}", "Shelter B"),
        cnt_unit("{e0f6d8f9-0692-4695-933b-6e87636c7acb}", "Oil platform"),
        cnt_unit("{6d518ff5-cfca-4a7c-921b-ee3621a4207d}", "Subsidiary structure 1"),
        cnt_unit("{47a39247-7989-4f6d-bbb8-2cdd40e012dd}", "Subsidiary structure 2"),
        cnt_unit("{e58952f4-d2e9-43bc-a5ea-854d4678ef96}", "Subsidiary structure 3"),
        cnt_unit("{394ff644-013b-4f88-bfe1-1277cbcba8cc}", "Subsidiary structure A"),
        cnt_unit("{c724c713-61ad-4fb0-807d-dc6eb4a89884}", "Subsidiary structure B"),
        cnt_unit("{162b2803-ddf1-4b0e-9b95-b45b2f35ee30}", "Subsidiary structure C"),
        cnt_unit("{9cbba4f7-7014-4f67-b69a-4a458e5f2420}", "Subsidiary structure D"),
        cnt_unit("{dbb8c3f5-f1ea-42e1-b486-482ef41a4e53}", "Subsidiary structure E"),
        cnt_unit("{74e14790-da2b-4269-bd94-0bfa2dee0031}", "Subsidiary structure F"),
        cnt_unit("{96fc5825-e329-468d-83d8-fc9326d8aa52}", "Subsidiary structure G"),
        cnt_unit("{30D37BB2-F438-45ae-B09D-F00B1EFCB790}", "Landmine"),
        cnt_unit("{7c9d05ea-0b54-4d5c-9d6f-fa2cde39e349}", "FARP Ammo Dump Coating"),
        cnt_unit("{80c39fb0-854f-461b-bc4b-b2b51d0c4139}", "FARP Tent"),
        cnt_unit("{a947d0fd-9268-4851-a885-cb59aebe9bbc}", "FARP CP Blindage"),
        cnt_unit("{3441baf3-7ff7-4d76-ab9e-77f768b7813f}", "FARP Fuel Depot"),
        cnt_unit("{7e58d67d-191e-4e2c-ad22-a9c50cd48f53}", "GeneratorF"),
      },
    },
  },
  {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
    award('ITUR HAGVURA', _('ITUR HAGVURA'), 1000,  'Distinguished_Service_Medal.png'),
    award([[ITUR HA'OZ]], _([[ITUR HA'OZ]]), 2000,  'Gallantry_Medal.png'),
    award('ITUR HAMOFET', _('ITUR HAMOFET'), 3000,  'Valor_Medal.png'),                
  },                                         
  'Israel.lua',
    {0,240,64,30} 
);


------------------------------------------------------------------------------------------------------------
-- Terorists side
------------------------------------------------------------------------------------------------------------
country("{12D14A19-81EA-437f-A119-E16EF4EAEBD1}", _("Insurgents"), "Insurgents", "INS", "Insurgents.png", 17,
  {
    Planes =
    {
      CATID = "{C168A850-3C0B-436a-95B5-C4A015552560}",
      Plane =
      {
      },
    },
    Heliports =
    {
      CATID = "{E6490BAB-7129-4d23-9023-1CFE810886EF}",
      Heliport =
      {
        cnt_unit("{24FC9197-F225-4f2a-8A31-BD51DC7BDAB6}", "FARP"),
      },
    },
    Ships =
    {
      CATID = "{AAFD44F1-C080-4572-9465-3A52C46F2A45}",
      Ship =
      {
        cnt_unit("{63CAFD18-C960-476B-BE9D-865C53A88146}", "ELNYA"),
        cnt_unit("{C8459CF8-BD2E-4595-9C92-6625C0B8794E}", "MOLNIYA"),
        cnt_unit("{AD0D2B7F-EBB4-4415-AC14-B4D117D514D5}", "Dry-cargo ship-1"),
        cnt_unit("{21B074E6-780D-4ba5-963E-94D5C8436A4E}", "Dry-cargo ship-2"),
        cnt_unit("{843E23DF-8A61-40DD-8E33-41B1AEA7CF18}", "ZWEZDNY"),
        cnt_unit("{6449989a-2f92-48ed-89bf-d0ae87176cb3}", "speedboat"),
      },
    },
    Cars =
    {
      CATID = "{6CAE2420-8E36-40f3-8586-E853AADB9199}",
      Car =
      {
        cnt_unit("{10C3BD0E-4494-4bc4-BC37-2C544E33ADC7}", "BTR-80"),
        cnt_unit("{5C486AED-5DCE-4A0A-AF88-7343D3B2B43E}", "Strela-1 9P31"),
        cnt_unit("{DD80908D-C289-4AFA-A25E-A6697EC65FDE}", "Strela-10M3"),
        cnt_unit("{28704245-E952-427A-9C57-B2A6E0AB1E66}", "ZSU-23-4 Shilka"),
        
        cnt_unit("{83485D57-2B11-4A83-9A7E-5FD47E9ADCEC}", "SAU Akatsia"),
        cnt_unit("{099A1146-4309-459F-A913-AAA515D70049}", "SAU 2-C9"),
        cnt_unit("{A97C0647-83EB-4B15-8B5B-BD2F8842DF91}", "ATMZ-5"),
        cnt_unit("{C0A5AA21-5A93-4707-9A9F-2AE24C4A22B0}", "ATZ-10"),
        
        cnt_unit("{A326AD1A-4820-4A5A-989D-5F3CCC174FCA}", "BMD-1"),
        cnt_unit("{A90A4A5B-5AF8-49CF-B363-BB81EF4A9256}", "BMP-1"),
        cnt_unit("{EBF0085E-E84E-401B-9F66-9C2B2BC7D214}", "BMP-2"),
        cnt_unit("{B33FB5B1-ABF0-48E6-A06B-6886A0132786}", "BRDM-2"),
        cnt_unit("{37DBF2AA-30C8-4FFA-A63A-D760623FF4E0}", "Grad-URAL"),
        cnt_unit("{1D6C2705-575C-4F35-A670-328ECBA007A3}", "UAZ-469"),
        cnt_unit("{85DF753A-0ECA-4143-88F8-5A46DEAB53C2}", "Ural-375"),
        cnt_unit("{20B6EAF4-E6D3-4FC2-A306-41951CAF1361}", "Ural-375 PBU"),
        cnt_unit("{4FC31476-127F-4608-876E-5D9B482F7E17}", "IKARUS Bus"),
        cnt_unit("{647DDAAC-CFB5-40AD-8394-042840EC4A6D}", "VAZ Car"),
        cnt_unit("{988392FB-77C0-461A-A738-DBEA8AB83030}", "Trolley bus"),
        cnt_unit("{254D09EB-5591-4D42-B513-3A15B9965B63}", "KAMAZ Truck"),
        cnt_unit("{D75AF34A-25E9-4BDE-A57A-E179AF185F2D}", "LAZ Bus"),
        cnt_unit("{672D3629-C30C-4ba5-A54D-68728E8C35E5}", "GAZ-3307"),
        cnt_unit("{DFABA701-5202-4d78-91FF-EAE6525099EC}", "GAZ-3308"),
        cnt_unit("{4CC190E5-CC9B-4c66-8071-C5A807B8DBB9}", "GAZ-66"),
        cnt_unit("{9A2584F4-2FEE-4f3c-A47F-35D97995FCE1}", "MAZ-6303"),
        cnt_unit("{4C763AC0-89AC-43a8-88D1-8FB710F42603}", "ZIL-4331"),
        
        cnt_unit("{5AD9D1CC-C7AB-4ee7-8110-028BB1D589B9}", "ZU-23 Insurgent"),
        cnt_unit("{3b1686ae-7783-4122-9f4c-899343f83181}", "ZU-23 Closed Insurgent"),
        cnt_unit("{91776447-a2f2-4b35-be80-8ae60da93e41}", "Ural-375 ZU-23 Insurgent"),
        
        cnt_unit("{A207B91F-77F0-4647-8D74-88A9D3851EAD}", "ZiL-131 APA-80"),
        cnt_unit("{4D98849E-2A76-4017-9356-B9852B39EBA6}", "ZIL-131 KUNG"),
        cnt_unit("{1e92e0f5-c183-4bc5-a4dd-2a437eff526b}", "Sandbox"),
        cnt_unit("{2dde8bcd-759c-4347-a4e3-eeec6c2c40a4}", "Bunker"),
        
        
        cnt_unit("{B00A39DC-A02C-41ec-A041-51163608CB9C}", "MTLB"),
        
        cnt_unit("{8C7CD125-65C9-44ec-BD3A-CC431263FF89}", "SA-18 Igla manpad"),
        cnt_unit("{CC83C3A7-4280-4018-9C45-2E4C6137C5E2}", "SA-18 Igla comm"),
        cnt_unit("{64066D8C-3785-4baf-A347-C585FE29746E}", "T-55"),
        cnt_unit("{B84C5FC5-9893-45e4-A712-E3D4D201A003}", "Stinger manpad"),
        cnt_unit("{DFC5C4AA-EFE7-4929-A305-B8785BCD6704}", "Stinger comm"),
        cnt_unit("{D3FE4F50-947B-4523-9176-F805EB4CEA7E}", "Soldier AK"),
        cnt_unit("{71866639-E9F9-4128-8AD0-B582FA3D27F4}", "Soldier RPG"),
      },
    },
    Helicopters =
    {
      CATID = "{828CEADE-3F1D-40aa-93CE-8CDB73FE2710}",
      Helicopter =
      {
        cnt_unit("{C08CF845-F905-40F0-AF1B-554908BBE89E}", "Mi-8MT", {
          color_scheme("{CB825521-4034-4b46-A6A2-47B532BB5884}", "Standart1"),
        })
      },
    },
    Fortifications =
    {
      CATID = "{7F1597F0-88EB-41cb-A04E-E9A4D5EF7466}",
      Fortification =
      {
        cnt_unit("{79BEF6B1-03EE-40A5-9D67-FE369D67D8F3}", "Locomotive"),
        cnt_unit("{5D159ABA-28C6-4E6A-BD41-B295AFA4E108}", "Electric locomotive"),
        cnt_unit("{A65C983E-3615-4350-93B2-128CBA8B3569}", "Coach a tank"),
        cnt_unit("{066A8FCF-6591-457C-888A-AF443AF95084}", "Coach cargo"),
        cnt_unit("{AA5E677A-BE23-4752-8C1A-24E25EC148CC}", "Coach cargo open"),
        cnt_unit("{77348759-616D-4500-9AB8-701D9F8028CD}", "Coach a platform"),
        cnt_unit("{8B096AEA-9E18-4541-8120-0DAB3BC57170}", "Coach a passenger"),
        cnt_unit("{71AC463C-310A-41ce-B7E7-923AC3CA5EDC}", ".Block"),
        cnt_unit("{B54053A8-B054-4a0b-871C-6DDA65ED90EF}", ".Block on road"),
        cnt_unit("{20A1B146-07C6-4ee6-851C-DBBC92135446}", ".Bunker"),
        cnt_unit("{2848C193-6789-472c-8430-AF3D739BB6C8}", ".Pill-box"),
        cnt_unit("{64DE4673-7D3E-424f-AB29-F4336AC38F98}", ".Command Center"),
        cnt_unit("{85D3DBF2-05DF-48e1-9C49-FD104E65A76E}", ".Ammunition depot"),
        cnt_unit("{7c822c60-9885-4a44-8add-b87511ff0fc5}", "Hangar A"),
        cnt_unit("{f0f48213-396f-4cc2-9fec-2f308cb11154}", "Tank"),
        cnt_unit("{b0e8ef18-c50c-4695-ac6e-1033b3691ce2}", "Tech hangar A"),
        cnt_unit("{db4d86a5-f9d6-4db1-b6ff-72153d082fc8}", "Farm A"),
        cnt_unit("{d406d212-8425-41be-83a1-502864f221dd}", "Farm B"),
        cnt_unit("{e8f80c05-dd74-4ce4-a232-f29afa025c3b}", "Garage A"),
        cnt_unit("{c5f17833-f456-45be-8c7c-ab28996f0e85}", "Boiler-house A"),
        cnt_unit("{65c10c17-e726-46d4-a380-db42706b923f}", "Restaurant 1"),
        cnt_unit("{80af40db-22ac-4e42-ab24-a015d1a21311}", "Warehouse"),
        cnt_unit("{fe75a842-e794-4650-9197-22797513dc72}", "Comms tower M"),
        cnt_unit("{70bf5fc8-441f-47cb-b587-d8f36ab81600}", "Cafe"),
        cnt_unit("{bddc2805-fd70-47dd-90b0-0041ebd1eee3}", "Workshop A"),
        cnt_unit("{7d0fa1db-38a1-4bf8-9169-943e11d49001}", "Electric power box"),
        cnt_unit("{d161a6b7-3946-49b2-af4c-aef104809480}", "Supermarket A"),
        cnt_unit("{1a4b08df-98c6-45da-bfea-161d7ad0135f}", "Water tower A"),
        cnt_unit("{cc06c05a-da19-494c-8066-04bb6b2f375b}", "TV tower"),
        cnt_unit("{2fe5cb79-1395-4b34-a112-913e964534e9}", "Shelter"),
        cnt_unit("{56c3c279-31f6-4cb9-ba63-6025f14adb08}", "Repair workshop"),
        cnt_unit("{4d01350e-eac5-406a-8daf-a1e1cc74c03b}", "Railway station"),
        cnt_unit("{557eab86-9e3d-459f-880b-3bfbd3b397fe}", "Railway crossing A"),
        cnt_unit("{8ff4a140-121e-4b25-a7e1-72bf64a3645c}", "Railway crossing B"),
        cnt_unit("{044858e2-4d40-4702-a185-70ee80f07151}", "WC"),
        cnt_unit("{72c629a7-112d-4a3e-9032-ba62dab2e36d}", "Small house 1A area"),
        cnt_unit("{40cf54da-bdb2-4993-a619-f5504200c3f5}", "Small house 1A"),
        cnt_unit("{95dbcac0-35e6-4621-bb02-a500666e337e}", "Small house 1B area"),
        cnt_unit("{8b22a3fd-8d96-4320-81b5-04f2c9edb247}", "Small house 1B"),
        cnt_unit("{7ae8526a-0edc-46ca-bf03-a1dc10445fcd}", "Small house 1C area"),
        cnt_unit("{9f6a6842-f5a5-4953-871b-58e0a2278849}", "Small house 2C"),
        cnt_unit("{aa0f2150-ed5c-4b66-8c7a-39ab3bccf5e3}", "Shop"),
        cnt_unit("{0a4804d2-db83-4a18-bf2a-a253a9b17e33}", "Tech combine"),
        cnt_unit("{264c3fb6-7871-471a-8915-a68afe98fbb5}", "Chemical tank A"),
        cnt_unit("{2cca8015-d0a0-43f7-bc89-0bf1cf290246}", "Small werehouse 1"),
        cnt_unit("{14b9c61c-bf3a-4dff-939c-5f3d55351d4e}", "Small werehouse 2"),
        cnt_unit("{ffe9021e-7d44-4ab3-8df9-0696d2506148}", "Small werehouse 3"),
        cnt_unit("{4b6bcf8c-6e4c-485b-a8f3-ac4de3338b5f}", "Small werehouse 4"),
        cnt_unit("{e0b21ae2-029b-4c20-986c-9c469d69b2c8}", "Garage B"),
        cnt_unit("{70a0edf9-c9bd-42c8-b260-e97927ebaaaa}", "Garage small A"),
        cnt_unit("{e4322f04-ba0d-43db-afe9-16025738ebeb}", "Garage small B"),
        cnt_unit("{36ac22c8-9737-4bdc-b59e-fd0fb823daaa}", "Pump station"),
        cnt_unit("{7d517890-d7ea-4ede-9c73-5be252b96d3f}", "Oil derrick"),
        cnt_unit("{d4fd6053-a036-4adf-8395-beca84e9efbb}", "Container red 1"),
        cnt_unit("{edd392fd-f262-4609-84d3-c09f126478ee}", "Container red 2"),
        cnt_unit("{dc005e97-7820-4cce-bc0e-edd875baaf92}", "Container red 3"),
        cnt_unit("{662e6cea-5a59-473f-87e9-e34d01f1ddb7}", "Container white"),
        cnt_unit("{d55f444b-745a-4954-bd4c-0ea1781f67a7}", "Container brown"),
        cnt_unit("{7f3722ae-10bc-49c5-a3cc-68ab89878c5b}", "Barracks 1"),
        cnt_unit("{eb3bac2d-4c24-4ff8-8c8a-dcd3d0c98750}", "Barracks 2"),
        cnt_unit("{a056cc08-9b50-45b1-b798-e0eb4277ea86}", "Military staff"),
        cnt_unit("{2b1802df-c4f9-404f-afe1-5f291ef68d30}", "Watchtower"),
        cnt_unit("{e9e4e232-b0c8-4306-b013-2f9defbb04d1}", "Hangar B"),
        cnt_unit("{07a6695a-2373-489f-a0a0-e1e35dd03b85}", "Fuel tank"),
        cnt_unit("{25f698c7-ee7b-40be-bafb-d97e64c487f3}", "Shelter B"),
        cnt_unit("{e0f6d8f9-0692-4695-933b-6e87636c7acb}", "Oil platform"),
        cnt_unit("{6d518ff5-cfca-4a7c-921b-ee3621a4207d}", "Subsidiary structure 1"),
        cnt_unit("{47a39247-7989-4f6d-bbb8-2cdd40e012dd}", "Subsidiary structure 2"),
        cnt_unit("{e58952f4-d2e9-43bc-a5ea-854d4678ef96}", "Subsidiary structure 3"),
        cnt_unit("{394ff644-013b-4f88-bfe1-1277cbcba8cc}", "Subsidiary structure A"),
        cnt_unit("{c724c713-61ad-4fb0-807d-dc6eb4a89884}", "Subsidiary structure B"),
        cnt_unit("{162b2803-ddf1-4b0e-9b95-b45b2f35ee30}", "Subsidiary structure C"),
        cnt_unit("{9cbba4f7-7014-4f67-b69a-4a458e5f2420}", "Subsidiary structure D"),
        cnt_unit("{dbb8c3f5-f1ea-42e1-b486-482ef41a4e53}", "Subsidiary structure E"),
        cnt_unit("{74e14790-da2b-4269-bd94-0bfa2dee0031}", "Subsidiary structure F"),
        cnt_unit("{96fc5825-e329-468d-83d8-fc9326d8aa52}", "Subsidiary structure G"),
        cnt_unit("{30D37BB2-F438-45ae-B09D-F00B1EFCB790}", "Landmine"),
        cnt_unit("{7c9d05ea-0b54-4d5c-9d6f-fa2cde39e349}", "FARP Ammo Dump Coating"),
        cnt_unit("{80c39fb0-854f-461b-bc4b-b2b51d0c4139}", "FARP Tent"),
        cnt_unit("{a947d0fd-9268-4851-a885-cb59aebe9bbc}", "FARP CP Blindage"),
        cnt_unit("{3441baf3-7ff7-4d76-ab9e-77f768b7813f}", "FARP Fuel Depot"),
        cnt_unit("{7e58d67d-191e-4e2c-ad22-a9c50cd48f53}", "GeneratorF"),
      },
    },
  },
    {
    callsign(1, "{F55E6D97-9C9E-417a-A275-B23ABC556414}", "Enfield"),
    callsign(2, "{3E4110CC-EB89-42af-B535-3AB7201529DF}", "Springfield"),
    callsign(3, "{6904A932-1CAA-4460-BB7F-1FEED0571BCA}", "Uzi"),
    callsign(4, "{7FB8D682-B0D9-436e-B01F-5825C148C523}", "Colt"),
    callsign(5, "{3923B2EB-31BF-4673-8100-4579CCE05EE4}", "Dodge"),
    callsign(6, "{E9E214E5-082B-40b9-9492-653A26BBB910}", "Ford"),
    callsign(7, "{883CDBA8-7332-409b-A97A-C6F1218154E0}", "Chevy"),
    callsign(8, "{4F817272-795B-437b-B488-208C462E2FAB}", "Pontiac"),
  },
  {
    rank('Second lieutenant', _('Second lieutenant'), 0, {0, 0, 64, 32}),
    rank('First lieutenant', _('First lieutenant'), 15, {0, 32, 64, 32}),
    rank('Captain', _('Captain'), 30, {0, 64, 64, 32}),
    rank('Major', _('Major'), 60, {0, 96, 64, 32}),
    rank('Lieutenant colonel', _('Lieutenant colonel'), 120, {0, 128, 64, 32}),
    rank('Colonel', _('Colonel'), 240, {0, 160, 64, 32}),
  },
  {
  },                                         
  'Insurgents.lua',
    {0,450,64,30} 

);
