require "Scripts/Database/wstypes"
require "warheads"


-- //    :
-- const int InfraredSeeker = 1;    //  IR (infrared seeker)
-- const int ActiveRadar        = 2;    // - (active radar (AR) (+)) 
-- const int AntiRadar          = 3;    //  (  +)
-- const int LaserHoming        = 4;    //   (+)
-- const int Autopilot          = 5;    //  (+, GPS,TV,IIR...)
-- const int SemiActiveRadar    = 6;    // - semi-active radar (SAR) -

-- struct WEAPONS_API Rocket_Const //       . 
            -- //  
    -- unsigned char Name_;     //   
    -- int           Escort_;   //  : 0 - , 1 -  , 2 -  , 3 - c 
    -- int           Head_Type_;//    ()(c ) 
    -- float         M_;        //     
    -- float         H_max_;    //    . 
    -- float         H_min_;    //    .  
    -- float         Diam_;     //      
    -- int           Cx_pil;    //  Cx  
    -- float         D_max_;    //       
    -- float         D_min_;    //    
    -- bool          Head_Form_;// false -   , 
                   -- // true   -  (~)
    -- float         Life_Time_;//   
    -- double        Nr_max_;   //    
    -- float         v_min_;    //  . 
    -- float    v_mid_;  //  
    -- float         Mach_max_; //   .
    -- float         t_b_;      //   
    -- float         t_acc_;    //   
    -- float         t_marsh_;  //     
    -- float         Range_max_;//      
    -- float         H_min_t_;  //     , .     
    -- float         Fi_start_; //        
    -- float         Fi_rak_;   //     (rad)
    -- float         Fi_excort_;//   (.)  .
    -- float          Fi_search_;//    
    -- float          OmViz_max_;//    
    -- float         Damage_;// ,    
-- /*   int           Engine_Type_; //  : 1 - ;
                             -- // 2 -   ()(); 
                             -- // 3 -    ; 
                             -- // 4 - -1+.
                             -- // 5 - 
                             -- // 6 -  +  
    -- int           Stage_;    //  .*/
    -- float         X_back_;   //      
    -- float         Y_back_; 
    -- float         Z_back_;
    -- float          Reflection;   //   

    -- // Kill distances - this distance is used to fire a fuze
    -- double        KillDistance;

    -- // These are warheads used to simulate explosions
    -- // Due to the architecture of blocksim we have to use two schemes - 
    -- // one for server object (which actually makes damage), and other for
    -- // client object (which does not make any damage)
	
	--    :
	--   +- 1 
	--   +- 5 

    
--Tail smoke color format {R, G, B, alpha}
--All values from 0 to 1
tail_solid = { 1, 1, 1, 1 };
tail_liquid = {0.9, 0.9, 0.9, 0.05 };

rockets = 
{
    {
        Name = R_550, --MIG-21 R-3S
        Escort = 0,
        Head_Type = 1,
        M = 89.0,
        H_max = 20000.0,
        H_min = 100.0,
        Diam = 127.0,
        Cx_pil = 2,
        D_max = 3500.0,
        D_min = 400.0,
        Head_Form = 0,
        Life_Time = 30.0,
        Nr_max = 18,
        v_min = 140.0,
        v_mid = 400.0,
        Mach_max = 2.0,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 0.0,
        Range_max = 7600.0,
        H_min_t = 10.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 0.79,
        Fi_search = 0.09,
        OmViz_max = 0.52,
        warhead = warheads["R_550"],
        exhaust = tail_solid,
        X_back = -0.815,
        Y_back = -0.1,
        Z_back = 0.0,
        Reflection = 0.0157,
        KillDistance = 5.0,
    },
    {
        Name = MICA_T, --MIG-21 R-13M
        Escort = 0,
        Head_Type = 1,
        M = 85.5,
        H_max = 18000.0,
        H_min = -1,
        Diam = 127.0,
        Cx_pil = 2.58,
        D_max = 7000.0,
        D_min = 300.0,
        Head_Form = 0,
        Life_Time = 30.0,
        Nr_max = 22,
        v_min = 140.0,
        v_mid = 350.0,
        Mach_max = 2.7,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 0.0,
        Range_max = 15000.0,
        H_min_t = 1.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 0.79,
        Fi_search = 0.09,
        OmViz_max = 0.61,
        warhead = warheads["AIM_9"],
        exhaust = { 0.7, 0.7, 0.7, 0.2 };
        X_back = -1.455,
        Y_back = -0.062,
        Z_back = 0.0,
        Reflection = 0.0182,
        KillDistance = 7.0,
    },
    {
        Name = MICA_R, --MIG-21 R-3R
        Escort = 0,
        Head_Type = 6,
        M = 85.5,
        H_max = 17000.0,
        H_min = 300.0,
        Diam = 200.0,
        Cx_pil = 2,
        D_max = 6000.0,
        D_min = 600.0,
        Head_Form = 1,
        Life_Time = 106.0,
        Nr_max = 18,
        v_min = 140.0,
        v_mid = 500.0,
        Mach_max = 4.0,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 4.0,
        Range_max = 5000.0,
        H_min_t = 10.0,
        Fi_start = 1.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 1.05,
        OmViz_max = 0.52,
        warhead = warheads["MICA_R"],
        exhaust = tail_solid,
        X_back = -1.072,
        Y_back = -0.1,
        Z_back = 0.0,
        Reflection = 0.0157,
        KillDistance = 6.0,
    },
    {
        Name = Super_530F, --MIG-21 RS2-US
        Escort = 1,
        Head_Type = 2,
        M = 270.0,
        H_max = 24400.0,
        H_min = 1.0,
        Diam = 263.0,
        Cx_pil = 3,
        D_max = 7000.0,
        D_min = 700.0,
        Head_Form = 1,
        Life_Time = 53.0,
        Nr_max = 18,
        v_min = 140.0,
        v_mid = 400.0,
        Mach_max = 3.0,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 0.0,
        Range_max = 25000.0,
        H_min_t = 20.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 0.87,
        Fi_search = 0.1,
        OmViz_max = 0.35,
        warhead = warheads["Super_530F"],
        exhaust = tail_solid,
        X_back = -1.202,
        Y_back = -0.1,
        Z_back = 0.0,
        Reflection = 0.0257,
        KillDistance = 6.0,
    },
    {
        Name = P_40T, --R-40T
        Escort = 0,
        Head_Type = 1,
        M = 475.0,
        H_max = 28000.0,
        H_min = 20.0,
        Diam = 355.0,
        Cx_pil = 4,
        D_max = 7000.0,
        D_min = 700.0,
        Head_Form = 0,
        Life_Time = 65.0,
        Nr_max = 5,
        v_min = 140.0,
        v_mid = 600.0,
        Mach_max = 3.8,
        t_b = 0.0,
        t_acc = 8.0,
        t_marsh = 0.0,
        Range_max = 32000.0,
        H_min_t = 20.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 0.87,
        Fi_search = 0.09,
        OmViz_max = 0.35,
        warhead = warheads["P_40T"],
        exhaust = tail_solid,
        X_back = -2.276,
        Y_back = -0.178,
        Z_back = 0.0,
        Reflection = 0.0257,
        KillDistance = 7.0,
    },
    {
        Name = P_40R, --R-40R
        Escort = 1,
        Head_Type = 6,
        M = 475.0,
        H_max = 28000.0,
        H_min = 20.0,
        Diam = 355.0,
        Cx_pil = 4,
        D_max = 15000.0,
        D_min = 700.0,
        Head_Form = 1,
        Life_Time = 75.0,
        Nr_max = 5,
        v_min = 140.0,
        v_mid = 600.0,
        Mach_max = 3.8,
        t_b = 0.0,
        t_acc = 8.0,
        t_marsh = 0.0,
        Range_max = 40000.0,
        H_min_t = 20.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 0.87,
        Fi_search = 0.1,
        OmViz_max = 0.35,
        warhead = warheads["P_40R"],
        exhaust = tail_solid,
        X_back = -2.276,
        Y_back = -0.178,
        Z_back = 0.0,
        Reflection = 0.0257,
        KillDistance = 7.0,
    },
    {
        Name = P_24R, --R-24R
        Escort = 1,
        Head_Type = 6,
        M = 215.0,
        H_max = 28000.0,
        H_min = 20.0,
        Diam = 200.0,
        Cx_pil = 3,
        D_max = 12000.0,
        D_min = 700.0,
        Head_Form = 1,
        Life_Time = 100.0,
        Nr_max = 18,
        v_min = 140.0,
        v_mid = 500.0,
        Mach_max = 3.0,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 0.0,
        Range_max = 35000.0,
        H_min_t = 20.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 0.87,
        Fi_search = 0.1,
        OmViz_max = 0.35,
        warhead = warheads["P_24R"],
        exhaust = tail_solid,
        X_back = -1.3281,
        Y_back = -0.102,
        Z_back = 0.0,
        Reflection = 0.036,
        KillDistance = 6.0,
    },
    {
        Name = P_24T, --R-24T
        Escort = 0,
        Head_Type = 1,
        M = 215.0,
        H_max = 28000.0,
        H_min = 20.0,
        Diam = 200.0,
        Cx_pil = 3,
        D_max = 10000.0,
        D_min = 700.0,
        Head_Form = 0,
        Life_Time = 100.0,
        Nr_max = 18,
        v_min = 140.0,
        v_mid = 500.0,
        Mach_max = 3.0,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 0.0,
        Range_max = 25000.0,
        H_min_t = 20.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 0.96,
        Fi_search = 0.09,
        OmViz_max = 0.35,
        warhead = warheads["P_24T"],
        exhaust = tail_solid,
        X_back = -1.328,
        Y_back = -0.101,
        Z_back = 0.0,
        Reflection = 0.0352,
        KillDistance = 6.0,
    },
    {
        Name = P_60, --R-60
        Escort = 0,
        Head_Type = 1,
        M = 44.0,
        H_max = 28000.0,
        H_min = -1,
        Diam = 130.0,
        Cx_pil = 2.18,
        D_max = 4000.0,
        D_min = 200.0,
        Head_Form = 0,
        Life_Time = 20.0,
        Nr_max = 18,
        v_min = 140.0,
        v_mid = 400.0,
        Mach_max = 2.5,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 0.0,
        Range_max = 12000.0,
        H_min_t = 1.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 0.79,
        Fi_search = 0.09,
        OmViz_max = 0.61,
        warhead = warheads["P_60"],
        exhaust = tail_solid,
        X_back = -1.166,
        Y_back = -0.069,
        Z_back = 0.0,
        Reflection = 0.0157,
        KillDistance = 3.0,
    },
    {
        Name = P_33E, --R-33
        Escort = 1,
        Head_Type = 6,
        M = 490.0,
        H_max = 28000.0,
        H_min = 10.0,
        Diam = 380.0,
        Cx_pil = 5,
        D_max = 40000.0,
        D_min = 6000.0,
        Head_Form = 1,
        Life_Time = 360.0,
        Nr_max = 5,
        v_min = 140.0,
        v_mid = 800.0,
        Mach_max = 4.5,
        t_b = 0.1,
        t_acc = 6.0,
        t_marsh = 25.0,
        Range_max = 120000.0,
        H_min_t = 25.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 0.87,
        Fi_search = 0.1,
        OmViz_max = 0.35,
        warhead = warheads["P_33E"],
        exhaust = tail_solid,
        X_back = -1.948,
        Y_back = -0.193,
        Z_back = 0.0,
        Reflection = 0.079,
        KillDistance = 12.0,
    },
    {
        Name = P_27AE, --R-27AE
        Escort = 0,
        Head_Type = 2,
        M = 350.0,
        H_max = 28000.0,
        H_min = 25.0,
        Diam = 260.0,
        Cx_pil = 2.21,
        D_max = 22000.0,
        D_min = 700.0,
        Head_Form = 1,
        Life_Time = 60.0,
        Nr_max = 1,
        v_min = 140.0,
        v_mid = 600.0,
        Mach_max = 3.5,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 6.0,
        Range_max = 66000.0,
        H_min_t = 20.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["P_27AE"],
        exhaust = tail_solid,
        X_back = -1.617,
        Y_back = -0.128,
        Z_back = 0.0,
        Reflection = 0.062,
        KillDistance = 10.0,
    },
    {
        Name = P_27P, --R-27R
        Escort = 1,
        Head_Type = 6,
        M = 253.0,
        H_max = 25000.0,
        H_min = 1.0,
        Diam = 230.0,
        Cx_pil = 2.21,
        D_max = 14000.0,
        D_min = 700.0,
        Head_Form = 1,
        Life_Time = 90.0,
        Nr_max = 18,
        v_min = 140.0,
        v_mid = 500.0,
        Mach_max = 3.2,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 4.0,
        Range_max = 35000.0,
        H_min_t = 20.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 0.1,
        OmViz_max = 0.35,
        warhead = warheads["P_27P"],
        exhaust = tail_solid,
        X_back = -1.227,
        Y_back = -0.128,
        Z_back = 0.0,
        Reflection = 0.0479,
        KillDistance = 11.0,
    },
    {
        Name = P_27PE, --R-27ER
        Escort = 1,
        Head_Type = 6,
        M = 350.0,
        H_max = 27000.0,
        H_min = 1.0,
        Diam = 265.0,
        Cx_pil = 2.21,
        D_max = 26000.0,
        D_min = 500.0,
        Head_Form = 1,
        Life_Time = 90.0,
        Nr_max = 18,
        v_min = 140.0,
        v_mid = 600.0,
        Mach_max = 4.0,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 6.0,
        Range_max = 66000.0,
        H_min_t = 20.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 0.1,
        OmViz_max = 0.35,
        warhead = warheads["P_27PE"],
        exhaust = tail_solid,
        X_back = -1.617,
        Y_back = -0.128,
        Z_back = 0.0,
        Reflection = 0.062,
        KillDistance = 11.0,
    },
    {
        Name = P_27T, --R-27T
        Escort = 0,
        Head_Type = 1,
        M = 254.0,
        H_max = 25000.0,
        H_min = 1.0,
        Diam = 230.0,
        Cx_pil = 2.23,
        D_max = 11000.0,
        D_min = 700.0,
        Head_Form = 0,
        Life_Time = 90.0,
        Nr_max = 18,
        v_min = 140.0,
        v_mid = 450.0,
        Mach_max = 3.2,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 4.0,
        Range_max = 25000.0,
        H_min_t = 1.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 0.96,
        Fi_search = 0.09,
        OmViz_max = 0.35,
        warhead = warheads["P_27T"],
        exhaust = tail_solid,
        X_back = -1.227,
        Y_back = -0.128,
        Z_back = 0.0,
        Reflection = 0.0445,
        KillDistance = 11.0,
    },
    {
        Name = P_27TE, --R-27ET
        Escort = 0,
        Head_Type = 1,
        M = 343.0,
        H_max = 25000.0,
        H_min = 1.0,
        Diam = 260.0,
        Cx_pil = 2.5,
        D_max = 20000.0,
        D_min = 700.0,
        Head_Form = 0,
        Life_Time = 90.0,
        Nr_max = 18,
        v_min = 140.0,
        v_mid = 550.0,
        Mach_max = 4.0,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 6.0,
        Range_max = 54000.0,
        H_min_t = 1.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 0.96,
        Fi_search = 0.09,
        OmViz_max = 0.35,
        warhead = warheads["P_27TE"],
        exhaust = tail_solid,
        X_back = -1.617,
        Y_back = -0.128,
        Z_back = 0.0,
        Reflection = 0.062,
        KillDistance = 11.0,
    },
    {
        Name = P_27EM, --R-27EM
        Escort = 1,
        Head_Type = 6,
        M = 350.0,
        H_max = 28000.0,
        H_min = 1.0,
        Diam = 265.0,
        Cx_pil = 2.5,
        D_max = 26000.0,
        D_min = 700.0,
        Head_Form = 1,
        Life_Time = 90.0,
        Nr_max = 22,
        v_min = 140.0,
        v_mid = 600.0,
        Mach_max = 4.0,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 6.0,
        Range_max = 66000.0,
        H_min_t = 10.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 0.1,
        OmViz_max = 0.35,
        warhead = warheads["P_27EM"],
        exhaust = tail_solid,
        X_back = -1.617,
        Y_back = -0.128,
        Z_back = 0.0,
        Reflection = 0.062,
        KillDistance = 11.0,
    },
    {
        Name = P_73, --R-73
        Escort = 0,
        Head_Type = 1,
        M = 110.0,
        H_max = 20000.0,
        H_min = -1,
        Diam = 170.0,
        Cx_pil = 1.9,
        D_max = 8000.0,
        D_min = 300.0,
        Head_Form = 0,
        Life_Time = 30.0,
        Nr_max = 45,
        v_min = 140.0,
        v_mid = 400.0,
        Mach_max = 2.8,
        t_b = 0.0,
        t_acc = 2.0,
        t_marsh = 3.0,
        Range_max = 18000.0,
        H_min_t = 1.0,
        Fi_start = 0.79,
        Fi_rak = 3.14152,
        Fi_excort = 1.31,
        Fi_search = 0.09,
        OmViz_max = 1.05,
        warhead = warheads["P_73"],
        exhaust = tail_solid,
        X_back = -0.963,
        Y_back = -0.09,
        Z_back = 0.0,
        Reflection = 0.0262,
        KillDistance = 5.0,
    },
    {
        Name = P_77, --R-77
        Escort = 0,
        Head_Type = 2,
        M = 175.0,
        H_max = 28000.0,
        H_min = 1.0,
        Diam = 190.0,
        Cx_pil = 3.44,
        D_max = 20000.0,
        D_min = 700.0,
        Head_Form = 1,
        Life_Time = 90.0,
        Nr_max = 30,
        v_min = 140.0,
        v_mid = 550.0,
        Mach_max = 3.7,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 5.0,
        Range_max = 60000.0,
        H_min_t = 3.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 1.05,
        OmViz_max = 0.52,
        warhead = warheads["P_77"],
        exhaust = tail_solid,
        X_back = -1.038,
        Y_back = -0.099,
        Z_back = 0.0,
        Reflection = 0.062,
        KillDistance = 15.0,
    },
    {
        Name = P_37, --R-37
        Escort = 0,
        Head_Type = 2,
        M = 600.0,
        H_max = 28000.0,
        H_min = 25.0,
        Diam = 380.0,
        Cx_pil = 5,
        D_max = 60000.0,
        D_min = 1000.0,
        Head_Form = 1,
        Life_Time = 200.0,
        Nr_max = 1,
        v_min = 140.0,
        v_mid = 650.0,
        Mach_max = 3.5,
        t_b = 0.1,
        t_acc = 6.0,
        t_marsh = 15.0,
        Range_max = 180000.0,
        H_min_t = 20.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["P_37"],
        exhaust = tail_solid,
        X_back = -1.751,
        Y_back = -0.193,
        Z_back = 0.0,
        Reflection = 0.081,
        KillDistance = 12.0,
    },
    {
        Name = AIM_7, --AIM-7
        Escort = 1,
        Head_Type = 6,
        M = 230.0,
        H_max = 24400.0,
        H_min = 1.0,
        Diam = 203.0,
        Cx_pil = 2.21,
        D_max = 23000.0,
        D_min = 700.0,
        Head_Form = 1,
        Life_Time = 90.0,
        Nr_max = 18,
        v_min = 140.0,
        v_mid = 500.0,
        Mach_max = 3.2,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 10.0,
        Range_max = 58000.0,
        H_min_t = 15.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 0.1,
        OmViz_max = 0.35,
        warhead = warheads["AIM_7"],
        exhaust = {0.78, 0.78, 0.78, 0.8};
        X_back = -1.422,
        Y_back = 0.0,
        Z_back = -0.1,
        Reflection = 0.0366,
        KillDistance = 12.0,
    },
    {
        Name = SeaSparrow, --RIM-7
        Escort = 1,
        Head_Type = 6,
        M = 230.0,
        H_max = 24400.0,
        H_min = 1.0,
        Diam = 203.0,
        Cx_pil = 4,
        D_max = 27000.0,
        D_min = 4000.0,
        Head_Form = 1,
        Life_Time = 160.0,
        Nr_max = 32,
        v_min = 70.0,
        v_mid = 500.0,
        Mach_max = 3.0,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 3.0,
        Range_max = 27500.0,
        H_min_t = 20.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 2.6,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SeaSparrow"],
        exhaust = tail_solid,
        X_back = -1.422,
        Y_back = 1.0,
        Z_back = 0.9,
        Reflection = 0.0366,
        KillDistance = 10.0,
    },
    {
        Name = AIM_9, --AIM-9M
        Escort = 0,
        Head_Type = 1,
        M = 85.5,
        H_max = 18000.0,
        H_min = -1,
        Diam = 127.0,
        Cx_pil = 2.58,
        D_max = 7000.0,
        D_min = 300.0,
        Head_Form = 0,
        Life_Time = 30.0,
        Nr_max = 22,
        v_min = 140.0,
        v_mid = 350.0,
        Mach_max = 2.7,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 0.0,
        Range_max = 14000.0,
        H_min_t = 1.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 0.79,
        Fi_search = 0.09,
        OmViz_max = 0.61,
        warhead = warheads["AIM_9"],
        exhaust = { 0.7, 0.7, 0.7, 0.2 };
        X_back = -1.455,
        Y_back = -0.062,
        Z_back = 0.0,
        Reflection = 0.0182,
        KillDistance = 7.0,
    },
    {
        Name = AIM_9P, --AIM-9P
        Escort = 0,
        Head_Type = 1,
        M = 85.5,
        H_max = 18000.0,
        H_min = -1,
        Diam = 127.0,
        Cx_pil = 2.58,
        D_max = 11000.0,
        D_min = 300.0,
        Head_Form = 0,
        Life_Time = 30.0,
        Nr_max = 16,
        v_min = 140.0,
        v_mid = 350.0,
        Mach_max = 2.0,
        t_b = 0.0,
        t_acc = 2.0,
        t_marsh = 0.0,
        Range_max = 4000.0,
        H_min_t = 1.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 0.79,
        Fi_search = 0.09,
        OmViz_max = 0.35,
        warhead = warheads["AIM_9P"],
        exhaust = tail_solid,
        X_back = -1.455,
        Y_back = -0.062,
        Z_back = 0.0,
        Reflection = 0.0182,
        KillDistance = 5.0,
    },
    {
        Name = AIM_9X, --AIM-9X
        Escort = 0,
        Head_Type = 1,
        M = 85.5,
        H_max = 18000.0,
        H_min = -1,
        Diam = 127.0,
        Cx_pil = 2.58,
        D_max = 7000.0,
        D_min = 300.0,
        Head_Form = 0,
        Life_Time = 30.0,
        Nr_max = 22,
        v_min = 140.0,
        v_mid = 350.0,
        Mach_max = 2.7,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 0.0,
        Range_max = 14000.0,
        H_min_t = 1.0,
        Fi_start = 1.0,
        Fi_rak = 3.14152,
        Fi_excort = 0.79,
        Fi_search = 0.09,
        OmViz_max = 0.61,
        warhead = warheads["AIM_9X"],
        exhaust = tail_solid,
        X_back = -1.455,
        Y_back = -0.062,
        Z_back = 0.0,
        Reflection = 0.0182,
        KillDistance = 5.0,
    },
    {
        Name = AIM_54, --AIM-54
        Escort = 0,
        Head_Type = 2,
        M = 463.0,
        H_max = 24400.0,
        H_min = 15.0,
        Diam = 380.0,
        Cx_pil = 5,
        D_max = 60000.0,
        D_min = 1000.0,
        Head_Form = 1,
        Life_Time = 200.0,
        Nr_max = 5,
        v_min = 140.0,
        v_mid = 780.0,
        Mach_max = 4.5,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 40.0,
        Range_max = 140000.0,
        H_min_t = 20.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 0.87,
        Fi_search = 0.87,
        OmViz_max = 0.35,
        warhead = warheads["AIM_54"],
        exhaust = tail_solid,
        X_back = -1.794,
        Y_back = -0.195,
        Z_back = 0.0,
        Reflection = 0.076,
        KillDistance = 14.0,
    },
    {
        Name = AIM_120, --AIM-120B
        Escort = 0,
        Head_Type = 2,
        M = 157.0,
        H_max = 26000.0,
        H_min = 1.0,
        Diam = 169.0,
        Cx_pil = 2.5,
        D_max = 19000.0,
        D_min = 700.0,
        Head_Form = 1,
        Life_Time = 90.0,
        Nr_max = 25,
        v_min = 140.0,
        v_mid = 540.0,
        Mach_max = 3.5,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 5.0,
        Range_max = 57000.0,
        H_min_t = 3.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 1.05,
        OmViz_max = 0.52,
        warhead = warheads["AIM_120"],
        exhaust = {0.8, 0.8, 0.8, 0.2 };
        X_back = -1.61,
        Y_back = -0.089,
        Z_back = 0.0,
        Reflection = 0.0329,
        KillDistance = 15.0,
    },
    {
        Name = AIM_120C, --AIM-120C
        Escort = 0,
        Head_Type = 2,
        M = 157.0,
        H_max = 26000.0,
        H_min = 1.0,
        Diam = 160.0,
        Cx_pil = 2.5,
        D_max = 22000.0,
        D_min = 700.0,
        Head_Form = 1,
        Life_Time = 90.0,
        Nr_max = 25,
        v_min = 140.0,
        v_mid = 540.0,
        Mach_max = 3.5,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 6.0,
        Range_max = 65000.0,
        H_min_t = 1.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 1.05,
        OmViz_max = 0.52,
        warhead = warheads["AIM_120C"],
        exhaust = {0.8, 0.8, 0.8, 0.2 };
        X_back = -1.61,
        Y_back = -0.089,
        Z_back = 0.0,
        Reflection = 0.0329,
        KillDistance = 15.0,
    },
    {
        Name = X_22, --Kh-22
        Escort = 0,
        Head_Type = 5,
        M = 6800.0,
        H_max = 28000.0,
        H_min = -1,
        Diam = 1000.0,
        Cx_pil = 8,
        D_max = 140000.0,
        D_min = 40000.0,
        Head_Form = 1,
        Life_Time = 1800.0,
        Nr_max = 6,
        v_min = 170.0,
        v_mid = 1000.0,
        Mach_max = 3.0,
        t_b = 0.0,
        t_acc = 10.0,
        t_marsh = 50.0,
        Range_max = 300000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_22"],
        exhaust = tail_liquid,
        X_back = -5.054,
        Y_back = -0.487,
        Z_back = 0.0,
        Reflection = 0.5866,
        KillDistance = 0.0,
    },
    {
        Name = X_23, --Kh-23
        Escort = 1,
        Head_Type = 6,
        M = 288.0,
        H_max = 28000.0,
        H_min = -1,
        Diam = 275.0,
        Cx_pil = 4,
        D_max = 5000.0,
        D_min = 1000.0,
        Head_Form = 1,
        Life_Time = 30.0,
        Nr_max = 2,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 2.0,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 5000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_23"],
        exhaust = tail_solid,
        X_back = -0.86,
        Y_back = -0.14,
        Z_back = 0.0,
        Reflection = 0.0795,
        KillDistance = 0.0,
    },
    {
        Name = X_23L, --Kh-23L
        Escort = 1,
        Head_Type = 4,
        M = 288.0,
        H_max = 28000.0,
        H_min = -1,
        Diam = 275.0,
        Cx_pil = 4,
        D_max = 5000.0,
        D_min = 1000.0,
        Head_Form = 0,
        Life_Time = 30.0,
        Nr_max = 2,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 2.0,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 5000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_23L"],
        exhaust = tail_solid,
        X_back = -0.86,
        Y_back = -0.14,
        Z_back = 0.0,
        Reflection = 0.0791,
        KillDistance = 0.0,
    },
    {
        Name = X_28, --Kh-28
        Escort = 0,
        Head_Type = 3,
        M = 715.0,
        H_max = 28000.0,
        H_min = -1,
        Diam = 430.0,
        Cx_pil = 5,
        D_max = 90000.0,
        D_min = 3000.0,
        Head_Form = 1,
        Life_Time = 500.0,
        Nr_max = 2,
        v_min = 170.0,
        v_mid = 250.0,
        Mach_max = 2.0,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 500.0,
        Range_max = 90000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_28"],
        exhaust = tail_liquid,
        X_back = -2.440,
        Y_back = -0.210,
        Z_back = 0.0,
        Reflection = 0.2289,
        KillDistance = 0.0,
    },
    {
        Name = X_25ML, --Kh-25ML
        Escort = 1,
        Head_Type = 4,
        M = 300.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 275.0,
        Cx_pil = 8.57,
        D_max = 8000.0,
        D_min = 1000.0,
        Head_Form = 0,
        Life_Time = 60.0,
        Nr_max = 4,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 2.5,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 4.0,
        Range_max = 20000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 0.7,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_25ML"],
        exhaust = tail_solid,
        X_back = -1.092,
        Y_back = -0.140,
        Z_back = 0.0,
        Reflection = 0.1504,
        KillDistance = 0.0,
    },
    {
        Name = X_25MP, --Kh-25MP
        Escort = 0,
        Head_Type = 3,
        M = 310.0,
        H_max = 15000.0,
        H_min = -1,
        Diam = 275.0,
        Cx_pil = 8.57,
        D_max = 27000.0,
        D_min = 1000.0,
        Head_Form = 1,
        Life_Time = 150.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 2.65,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 9.0,
        Range_max = 60000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 0.7,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_25MP"],
        exhaust = tail_solid,
        X_back = -1.092,
        Y_back = -0.140,
        Z_back = 0.0,
        Reflection = 0.158,
        KillDistance = 0.0,
    },
    {
        Name = X_25MR, --Kh-25MR
        Escort = 1,
        Head_Type = 6,
        M = 300.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 275.0,
        Cx_pil = 8.57,
        D_max = 8000.0,
        D_min = 1000.0,
        Head_Form = 0,
        Life_Time = 60.0,
        Nr_max = 2,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 2.5,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 4.0,
        Range_max = 20000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 0.7,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_25MR"],
        exhaust = tail_solid,
        X_back = -1.092,
        Y_back = -0.140,
        Z_back = 0.0,
        Reflection = 0.1512,
        KillDistance = 0.0,
    },
    {
        Name = X_58, --Kh-58
        Escort = 0,
        Head_Type = 3,
        M = 640.0,
        H_max = 15000.0,
        H_min = -1,
        Diam = 380.0,
        Cx_pil = 19.64,
        D_max = 40000.0,
        D_min = 5000.0,
        Head_Form = 1,
        Life_Time = 1000.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 3.6,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 15.0,
        Range_max = 100000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 0.7,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_58"],
        exhaust = tail_solid,
        X_back = -1.44,
        Y_back = -0.225,
        Z_back = 0.0,
        Reflection = 0.2036,
        KillDistance = 0.0,
    },
    {
        Name = X_59M, --Kh-59M
        Escort = 0,
        Head_Type = 5,
        M = 850.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 380.0,
        Cx_pil = 19.64,
        D_max = 115000.0,
        D_min = 10000.0,
        Head_Form = 0,
        Life_Time = 1800.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 250.0,
        Mach_max = 0.85,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 500.0,
        Range_max = 80000.0,
        H_min_t = 0.0,
        Fi_start = 0.37,
        Fi_rak = 3.14152,
        Fi_excort = 0.7,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_59M"],
        -- No exhaust (turbo)
        X_back = -3.615,
        Y_back = -0.212,
        Z_back = 0.0,
        Reflection = 0.1914,
        KillDistance = 0.0,
    },
    {
        Name = X_29L, --Kh-29L
        Escort = 1,
        Head_Type = 4,
        M = 657.0,
        H_max = 5000.0,
        H_min = 0.2,
        Diam = 380.0,
        Cx_pil = 16.37,
        D_max = 8000.0,
        D_min = 1000.0,
        Head_Form = 0,
        Life_Time = 60.0,
        Nr_max = 2,
        v_min = 170.0,
        v_mid = 220.0,
        Mach_max = 1.8,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 0.0,
        Range_max = 13000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_29L"],
        exhaust = {0.63, 0.71, 0.78, 0.5},
        X_back = -1.446,
        Y_back = -0.196,
        Z_back = 0.0,
        Reflection = 0.175,
        KillDistance = 0.0,
    },
    {
        Name = X_29T, --Kh-29T
        Escort = 0,
        Head_Type = 5,
        M = 670.0,
        H_max = 5000.0,
        H_min = 0.2,
        Diam = 380.0,
        Cx_pil = 16.37,
        D_max = 10000.0,
        D_min = 1000.0,
        Head_Form = 0,
        Life_Time = 120.0,
        Nr_max = 2,
        v_min = 170.0,
        v_mid = 250.0,
        Mach_max = 1.4,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 0.0,
        Range_max = 15000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_29T"],
        exhaust = {0.63, 0.71, 0.78, 0.5},
        X_back = -1.446,
        Y_back = -0.202,
        Z_back = 0.0,
        Reflection = 0.1729,
        KillDistance = 0.0,
    },
    {
        Name = X_29TE, --Kh-29TE
        Escort = 0,
        Head_Type = 5,
        M = 690.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 380.0,
        Cx_pil = 16.37,
        D_max = 20000.0,
        D_min = 1000.0,
        Head_Form = 0,
        Life_Time = 1800.0,
        Nr_max = 2,
        v_min = 170.0,
        v_mid = 250.0,
        Mach_max = 2.5,
        t_b = 0.0,
        t_acc = 16.0,
        t_marsh = 150.0,
        Range_max = 30000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_29TE"],
        exhaust = {0.63, 0.71, 0.78, 0.5},
        X_back = -1.446,
        Y_back = -0.202,
        Z_back = 0.0,
        Reflection = 0.1729,
        KillDistance = 0.0,
    },
    {
        Name = X_55, --Kh-55
        Escort = 0,
        Head_Type = 5,
        M = 1250.0,
        H_max = 12000.0,
        H_min = -1,
        Diam = 514.0,
        Cx_pil = 19.9,
        D_max = 600000.0,
        D_min = 9000.0,
        Head_Form = 0,
        Life_Time = 9200.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 230.0,
        Mach_max = 0.85,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 9200.0,
        Range_max = 600000.0,
        H_min_t = 0.0,
        Fi_start = 0.25,
        Fi_rak = 3.14152,
        Fi_excort = 0.35,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_55"],
        -- No exhaust (turbo)
        X_back = -2.356,
        Y_back = -0.618,
        Z_back = 0.0,
        Reflection = 0.1656,
        KillDistance = 0.0,
    },
    {
        Name = X_65, --Kh-65
        Escort = 0,
        Head_Type = 5,
        M = 1400.0,
        H_max = 28000.0,
        H_min = -1,
        Diam = 514.0,
        Cx_pil = 19.9,
        D_max = 2500000.0,
        D_min = 9000.0,
        Head_Form = 0,
        Life_Time = 12000.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 230.0,
        Mach_max = 0.85,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 12000.0,
        Range_max = 2500000.0,
        H_min_t = 0.0,
        Fi_start = 0.25,
        Fi_rak = 3.14152,
        Fi_excort = 0.35,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_65"],
        -- No exhaust (turbo)
        X_back = -2.356,
        Y_back = -0.618,
        Z_back = 0.0,
        Reflection = 0.1656,
        KillDistance = 0.0,
    },
    {
        Name = X_15, --Kh-15
        Escort = 0,
        Head_Type = 5,
        M = 1200.0,
        H_max = 40000.0,
        H_min = -1,
        Diam = 455.0,
        Cx_pil = 16.2,
        D_max = 100000.0,
        D_min = 40000.0,
        Head_Form = 1,
        Life_Time = 300.0,
        Nr_max = 10,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 5.0,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 24.0,
        Range_max = 140000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 0.7,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_15"],
        exhaust = tail_solid,
        X_back = -2.39,
        Y_back = -0.227,
        Z_back = 0.0,
        Reflection = 0.1749,
        KillDistance = 0.0,
    },
    {
        Name = X_31P, --Kh-31P
        Escort = 0,
        Head_Type = 3,
        M = 600.0,
        H_max = 15000.0,
        H_min = -1,
        Diam = 360.0,
        Cx_pil = 15.6,
        D_max = 80000.0,
        D_min = 15000.0,
        Head_Form = 1,
        Life_Time = 300.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 2.54,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 300.0,
        Range_max = 110000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 0.35,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_31P"],
        exhaust1 = tail_solid,
        X_back = -1.341,
        Y_back = -0.178,
        Z_back = 0.0,
        Reflection = 0.1945,
        KillDistance = 0.0,
    },
    {
        Name = X_31A, --Kh-31A
        Escort = 0,
        Head_Type = 5,
        M = 600.0,
        H_max = 15000.0,
        H_min = -1,
        Diam = 360.0,
        Cx_pil = 15.6,
        D_max = 50000.0,
        D_min = 7000.0,
        Head_Form = 1,
        Life_Time = 150.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 2.54,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 150.0,
        Range_max = 70000.0,
        H_min_t = 0.0,
        Fi_start = 0.25,
        Fi_rak = 3.14152,
        Fi_excort = 0.35,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_31A"],
        exhaust1 = tail_solid,
        X_back = -1.341,
        Y_back = -0.178,
        Z_back = 0.0,
        Reflection = 0.1945,
        KillDistance = 0.0,
    },
    {
        Name = X_35, --Kh-35
        Escort = 0,
        Head_Type = 5,
        M = 480.0,
        H_max = 30000.0,
        H_min = -1,
        Diam = 420.0,
        Cx_pil = 17.2,
        D_max = 130000.0,
        D_min = 4000.0,
        Head_Form = 0,
        Life_Time = 1800.0,
        Nr_max = 20,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 0.92,
        t_b = 0.0,
        t_acc = 0.0,
        t_marsh = 465.0,
        Range_max = 130000.0,
        H_min_t = 0.0,
        Fi_start = 0.25,
        Fi_rak = 3.14152,
        Fi_excort = 0.35,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_35"],
        exhaust1 = tail_solid,
        X_back = -1.636,
        Y_back = -0.196,
        Z_back = 0.0,
        Reflection = 0.191,
        KillDistance = 0.0,
    },
    {
        Name = X_41, --Kh-41
        Escort = 0,
        Head_Type = 5,
        M = 4500.0,
        H_max = 12000.0,
        H_min = -1,
        Diam = 760.0,
        Cx_pil = 7,
        D_max = 100000.0,
        D_min = 5000.0,
        Head_Form = 1,
        Life_Time = 1800.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 850.0,
        Mach_max = 2.8,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 250.0,
        Range_max = 250000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["X_41"],
        exhaust1 = tail_solid,
        X_back = -6.2,
        Y_back = -0.376,
        Z_back = 0.0,
        Reflection = 0.2067,
        KillDistance = 0.0,
    },
    {
        Name = Vikhr, --9A4172 Vikhr
        Escort = 1,
        Head_Type = 4,
        M = 43.0,
        H_max = 5000.0,
        H_min = 5.0,
        Diam = 130.0,
        Cx_pil = 1,
        D_max = 7000.0,
        D_min = 800.0,
        Head_Form = 0,
        Life_Time = 30.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 461.0,
        Mach_max = 2.2,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 5.0,
        Range_max = 8000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 0.8,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["Vikhr"],
        exhaust = tail_solid,
        X_back = 0.382,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0121,
        KillDistance = 0.0,
    },
    {
        Name = Vikhr_M, --9A4172M Vikhr-M
        Escort = 1,
        Head_Type = 4,
        M = 45.0,
        H_max = 5000.0,
        H_min = 5.0,
        Diam = 130.0,
        Cx_pil = 1,
        D_max = 7000.0,
        D_min = 800.0,
        Head_Form = 0,
        Life_Time = 30.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 461.0,
        Mach_max = 2.2,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 5.0,
        Range_max = 8000.0,
        H_min_t = 0.0,
        Fi_start = 0.0175,
        Fi_rak = 3.14152,
        Fi_excort = 0.8,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["Vikhr_M"],
        exhaust = tail_solid,
        X_back = 0.208,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.015,
        KillDistance = 0.0,
    },
    {
        Name = AT_6, --9M114 Shturm
        Escort = 1,
        Head_Type = 6,
        M = 40.0,
        H_max = 8000.0,
        H_min = -1,
        Diam = 126.0,
        Cx_pil = 2,
        D_max = 5000.0,
        D_min = 800.0,
        Head_Form = 1,
        Life_Time = 30.0,
        Nr_max = 1.2,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 1.8,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 0.0,
        Range_max = 5000.0,
        H_min_t = 0.0,
        Fi_start = 0.1,
        Fi_rak = 3.14152,
        Fi_excort = 0.4,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AT_6"],
        exhaust = {0.63, 0.67, 0.75, 0.3 };
        X_back = -0.922,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0495,
        KillDistance = 0.0,
    },
    {
        Name = AGM_114, --AGM-114L
        Escort = 1,
        Head_Type = 4,
        M = 48.25,
        H_max = 28000.0,
        H_min = -1,
        Diam = 178.0,
        Cx_pil = 2,
        D_max = 8000.0,
        D_min = 500.0,
        Head_Form = 1,
        Life_Time = 30.0,
        Nr_max = 2,
        v_min = 170.0,
        v_mid = 200.0,
        Mach_max = 1.8,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 0.0,
        Range_max = 8000.0,
        H_min_t = 0.0,
        Fi_start = 0.4,
        Fi_rak = 3.14152,
        Fi_excort = 0.8,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_114"],
        exhaust = {0.9, 0.9, 0.85, 0.3 };
        X_back = -0.813,
        Y_back = -0.089,
        Z_back = 0.0,
        Reflection = 0.015,
        KillDistance = 0.0,
    },
    {
        Name = AGM_114K, --AGM-114K
        Escort = 1,
        Head_Type = 4,
        M = 45.7,
        H_max = 28000.0,
        H_min = -1,
        Diam = 178.0,
        Cx_pil = 2,
        D_max = 9000.0,
        D_min = 500.0,
        Head_Form = 1,
        Life_Time = 35.0,
        Nr_max = 2,
        v_min = 170.0,
        v_mid = 200.0,
        Mach_max = 1.8,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 0.0,
        Range_max = 9000.0,
        H_min_t = 0.0,
        Fi_start = 0.4,
        Fi_rak = 3.14152,
        Fi_excort = 0.8,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_114K"],
        exhaust = {0.9, 0.9, 0.85, 0.3 };
        X_back = -0.813,
        Y_back = -0.089,
        Z_back = 0.0,
        Reflection = 0.015,
        KillDistance = 0.0,
    },
    {
        Name = AGM_45, --AGM-45
        Escort = 0,
        Head_Type = 3,
        M = 177.0,
        H_max = 24400.0,
        H_min = -1,
        Diam = 203.0,
        Cx_pil = 4,
        D_max = 12000.0,
        D_min = 1000.0,
        Head_Form = 1,
        Life_Time = 300.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 2.0,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 15.0,
        Range_max = 40000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_45"],
        exhaust = tail_solid,
        X_back = -1.065,
        Y_back = -0.101,
        Z_back = 0.0,
        Reflection = 0.17,
        KillDistance = 0.0,
    },
    {
        Name = AGM_65K, --AGM-65K
        Escort = 0,
        Head_Type = 5,
        M = 360.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 12964.0,
        D_min = 500.0,
        Head_Form = 0,
        Life_Time = 70.0,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 24076.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_65K"],
        exhaust = {0.75, 0.75, 0.75, 0.3},
        X_back = -0.9,
        Y_back = -0.15,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,
    },
    {
        Name = AGM_65D, --AGM-65D
        Escort = 0,
        Head_Type = 5,
        M = 220.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 12964.0,
        D_min = 500.0,
        Head_Form = 0,
        Life_Time = 70.0,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 24076.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_65D"],
        exhaust = {0.75, 0.75, 0.75, 0.3},
        X_back = -0.9,
        Y_back = -0.15,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,
    },
    {
        Name = AGM_65H, --AGM-65H
        Escort = 0,
        Head_Type = 5,
        M = 360.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 12964.0,
        D_min = 500.0,
        Head_Form = 0,
        Life_Time = 70.0,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 24076.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_65H"],
        exhaust = {0.75, 0.75, 0.75, 0.3},
        X_back = -0.9,
        Y_back = -0.15,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,
    },
    {
        Name = AGM_65G, --AGM-65G
        Escort = 0,
        Head_Type = 5,
        M = 220.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 12964.0,
        D_min = 500.0,
        Head_Form = 0,
        Life_Time = 70.0,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 24076.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_65G"],
        exhaust = {0.75, 0.75, 0.75, 0.3},
        X_back = -0.9,
        Y_back = -0.15,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,
    },
    {
        Name = TGM_65G, --TGM-65G
        Escort = 0,
        Head_Type = 5,
        M = 220.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 12964.0,
        D_min = 500.0,
        Head_Form = 0,
        Life_Time = 70.0,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 24076.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["TGM_65G"],
        exhaust = tail_solid,
        X_back = -0.879,
        Y_back = -0.155,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,
    },
    {
        Name = TGM_65D,  --TGM-65D
        Escort = 0,
        Head_Type = 5,
        M = 220.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 12964.0,
        D_min = 500.0,
        Head_Form = 0,
        Life_Time = 70.0,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 24076.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["TGM_65D"],
        exhaust = tail_solid,
        X_back = -0.879,
        Y_back = -0.155,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,
    },
    {
        Name = CATM_65K,  --CATM-65K
        Escort = 0,
        Head_Type = 5,
        M = 360.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 12964.0,
        D_min = 500.0,
        Head_Form = 0,
        Life_Time = 70.0,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 24076.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["CATM_65K"],
        exhaust = tail_solid,
        X_back = -0.879,
        Y_back = -0.155,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,
    },
    {
        Name = TGM_65H, --TGM-65H
        Escort = 0,
        Head_Type = 5,
        M = 360.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 12964.0,
        D_min = 500.0,
        Head_Form = 0,
        Life_Time = 70.0,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 24076.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["TGM_65H"],
        exhaust = tail_solid,
        X_back = -0.879,
        Y_back = -0.155,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,
    },
    {
        Name = AGM_65E, --AGM-65E
        Escort = 1,
        Head_Type = 4,
        M = 293.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 11112.0,
        D_min = 1000.0,
        Head_Form = 0,
        Life_Time = 85.0,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 11112.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_65E"],
        exhaust = {0.75, 0.75, 0.75, 0.3},
        X_back = -0.879,
        Y_back = -0.155,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,
    },
    {
        Name = AGM_84A, --AGM-84A
        Escort = 0,
        Head_Type = 5,
        M = 661.5,
        H_max = 10000.0,
        H_min = -1,
        Diam = 343.0,
        Cx_pil = 6,
        D_max = 95000.0,
        D_min = 2000.0,
        Head_Form = 1,
        Life_Time = 1850.0,
        Nr_max = 18,
        v_min = 170.0,
        v_mid = 272.0,
        Mach_max = 0.9,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 1800.0,
        Range_max = 106000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_84A"],
        -- No exhaust (turbo)
        X_back = -1.581,
        Y_back = -0.173,
        Z_back = 0.0,
        Reflection = 0.121,
        KillDistance = 0.0,
    },
    {
        Name = AGM_84E, --AGM-84E
        Escort = 0,
        Head_Type = 5,
        M = 628.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 343.0,
        Cx_pil = 6,
        D_max = 85000.0,
        D_min = 2000.0,
        Head_Form = 0,
        Life_Time = 1850.0,
        Nr_max = 18,
        v_min = 170.0,
        v_mid = 272.0,
        Mach_max = 0.9,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 1800.0,
        Range_max = 139000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_84E"],
        -- No exhaust (turbo)
        X_back = -1.581,
        Y_back = -0.173,
        Z_back = 0.0,
        Reflection = 0.121,
        KillDistance = 0.0,
    },
    {
        Name = AGM_86, --AGM-86
        Escort = 0,
        Head_Type = 5,
        M = 1500.0,
        H_max = 13000.0,
        H_min = -1,
        Diam = 697.0,
        Cx_pil = 8,
        D_max = 2500000.0,
        D_min = 10000.0,
        Head_Form = 0,
        Life_Time = 10000.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 272.0,
        Mach_max = 0.95,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 10000.0,
        Range_max = 2414000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 0.7,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_86"],
        -- No exhaust (turbo)
        X_back = -3.392,
        Y_back = 0.064,
        Z_back = 0.0,
        Reflection = 0.1691,
        KillDistance = 0.0,
    },
    {
        Name = AGM_88, --AGM-88
        Escort = 0,
        Head_Type = 3,
        M = 361.0,
        H_max = 24400.0,
        H_min = -1,
        Diam = 254.0,
        Cx_pil = 4,
        D_max = 48000.0,
        D_min = 10000.0,
        Head_Form = 1,
        Life_Time = 400.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 3.2,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 10.0,
        Range_max = 120000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_88"],
        exhaust = {0.9, 0.9, 0.9, 0.4 };
        X_back = -1.506,
        Y_back = -0.126,
        Z_back = 0.0,
        Reflection = 0.1741,
        KillDistance = 7.0,
    },
    {
        Name = AGM_122, --AGM-122
        Escort = 0,
        Head_Type = 3,
        M = 91.0,
        H_max = 24400.0,
        H_min = -1,
        Diam = 127.0,
        Cx_pil = 1,
        D_max = 3000.0,
        D_min = 1000.0,
        Head_Form = 0,
        Life_Time = 60.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 1.8,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 2.0,
        Range_max = 16500.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_122"],
        exhaust = tail_solid,
        X_back = -1.455,
        Y_back = -0.062,
        Z_back = 0.0,
        Reflection = 0.0784,
        KillDistance = 0.0,
    },
    {
        Name = AGM_123, --AGM-123
        Escort = 1,
        Head_Type = 4,
        M = 582.0,
        H_max = 24000.0,
        H_min = -1,
        Diam = 356.0,
        Cx_pil = 6,
        D_max = 10000.0,
        D_min = 1000.0,
        Head_Form = 1,
        Life_Time = 1800.0,
        Nr_max = 10,
        v_min = 170.0,
        v_mid = 250.0,
        Mach_max = 0.85,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 10.0,
        Range_max = 25000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 0.75,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_123"],
        exhaust = tail_solid,
        X_back = -1.832,
        Y_back = -0.201,
        Z_back = 0.0,
        Reflection = 0.075,
        KillDistance = 0.0,
    },
    {
        Name = AGM_130, --AGM-130
        Escort = 0,
        Head_Type = 5,
        M = 1312.65,
        H_max = 24000.0,
        H_min = -1,
        Diam = 460.0,
        Cx_pil = 4,
        D_max = 40000.0,
        D_min = 2000.0,
        Head_Form = 0,
        Life_Time = 250.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 272.0,
        Mach_max = 0.85,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 245.0,
        Range_max = 65000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 0.7,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_130"],
        -- No exhaust (turbo)
        X_back = -1.697,
        Y_back = -0.56,
        Z_back = 0.0,
        Reflection = 0.11,
        KillDistance = 0.0,
    },
    {
        Name = Sea_Eagle, --Sea Eagle
        Escort = 0,
        Head_Type = 5,
        M = 600.0,
        H_max = 28000.0,
        H_min = -1,
        Diam = 400.0,
        Cx_pil = 6,
        D_max = 100000.0,
        D_min = 4000.0,
        Head_Form = 0,
        Life_Time = 1800.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 0.85,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 465.0,
        Range_max = 110000.0,
        H_min_t = 0.0,
        Fi_start = 0.25,
        Fi_rak = 3.14152,
        Fi_excort = 0.35,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["Sea_Eagle"],
        -- No exhaust (turbo)
        X_back = -1.97,
        Y_back = -0.199,
        Z_back = 0.0,
        Reflection = 0.121,
        KillDistance = 0.0,
    },
    {
        Name = ALARM, --ALARM
        Escort = 0,
        Head_Type = 3,
        M = 268.0,
        H_max = 24400.0,
        H_min = -1,
        Diam = 224.0,
        Cx_pil = 4,
        D_max = 30000.0,
        D_min = 2000.0,
        Head_Form = 1,
        Life_Time = 400.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 2.1,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 10.0,
        Range_max = 45000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["ALARM"],
        exhaust = tail_solid,
        X_back = -1.97,
        Y_back = -0.109,
        Z_back = 0.0,
        Reflection = 0.0741,
        KillDistance = 0.0,
    },
    {
        Name = Kormoran, --Kormoran
        Escort = 0,
        Head_Type = 5,
        M = 600.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 345.0,
        Cx_pil = 6,
        D_max = 20000.0,
        D_min = 1000.0,
        Head_Form = 1,
        Life_Time = 400.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 272.0,
        Mach_max = 0.85,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 400.0,
        Range_max = 40000.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["Kormoran"],
        exhaust = tail_solid,
        X_back = -1.562,
        Y_back = -0.151,
        Z_back = 0.0,
        Reflection = 0.1758,
        KillDistance = 0.0,
    },
    {
        Name = AGM_119, --AGM-119
        Escort = 0,
        Head_Type = 5,
        M = 370.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 300.0,
        Cx_pil = 3,
        D_max = 30000.0,
        D_min = 4000.0,
        Head_Form = 0,
        Life_Time = 450.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 1.2,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 400.0,
        Range_max = 35000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_119"],
        exhaust = tail_solid,
        X_back = -1.046,
        Y_back = -0.159,
        Z_back = 0.0,
        Reflection = 0.1741,
        KillDistance = 0.0,
    },
    {
        Name = SM_2, --SM-2 Standard
        Escort = 3,
        Head_Type = 6,
        M = 615.0,
        H_max = 24400.0,
        H_min = 10.0,
        Diam = 340.0,
        Cx_pil = 5,
        D_max = 40000.0,
        D_min = 4000.0,
        Head_Form = 1,
        Life_Time = 120.0,
        Nr_max = 25,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 6.8,
        t_b = 0.0,
        t_acc = 15.0,
        t_marsh = 0.0,
        Range_max = 100000.0,
        H_min_t = 10.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 2.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SM_2"],
        exhaust = tail_solid,
        X_back = -1.507,
        Y_back = -0.0,
        Z_back = 0.0,
        Reflection = 0.1766,
        KillDistance = 15.0,
    },
    {
        Name = SA5B55, --5V55, S-300
        Escort = 3,
        Head_Type = 6,
        M = 1480.0,
        H_max = 30000.0,
        H_min = 25.0,
        Diam = 508.0,
        Cx_pil = 8,
        D_max = 48000.0,
        D_min = 5000.0,
        Head_Form = 1,
        Life_Time = 100.0,
        Nr_max = 25,
        v_min = 170.0,
        v_mid = 1000.0,
        Mach_max = 7.8,
        t_b = 0.0,
        t_acc = 10.0,
        t_marsh = 0.0,
        Range_max = 120000.0,
        H_min_t = 25.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 2.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA5B55"],
        exhaust = tail_solid,
        X_back = -3.681,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.178,
        KillDistance = 20.0,
    },
    {
        Name = SA48H6E2, --48N6
        Escort = 3,
        Head_Type = 6,
        M = 1900.0,
        H_max = 30000.0,
        H_min = 10.0,
        Diam = 519.0,
        Cx_pil = 8,
        D_max = 55000.0,
        D_min = 6000.0,
        Head_Form = 1,
        Life_Time = 200.0,
        Nr_max = 25,
        v_min = 170.0,
        v_mid = 1000.0,
        Mach_max = 8.6,
        t_b = 0.0,
        t_acc = 12.0,
        t_marsh = 0.0,
        Range_max = 190000.0,
        H_min_t = 25.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 2.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA48H6E2"],
        exhaust = tail_solid,
        X_back = -3.681,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.178,
        KillDistance = 25.0,
    },
    {
        Name = SA9M82, --9M82
        Escort = 3,
        Head_Type = 6,
        M = 4600.0,
        H_max = 30000.0,
        H_min = 1000.0,
        Diam = 810.0,
        Cx_pil = 8,
        D_max = 60000.0,
        D_min = 13000.0,
        Head_Form = 1,
        Life_Time = 100.0,
        Nr_max = 27,
        v_min = 170.0,
        v_mid = 1000.0,
        Mach_max = 5.0,
        t_b = 0.0,
        t_acc = 10.0,
        t_marsh = 0.0,
        Range_max = 100000.0,
        H_min_t = 10.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 2.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA9M82"],
        exhaust = tail_solid,
        X_back = -3.978,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.5099,
        KillDistance = 30.0,
    },
    {
        Name = SA9M83, --9M83
        Escort = 3,
        Head_Type = 6,
        M = 2400.0,
        H_max = 25000.0,
        H_min = 25.0,
        Diam = 810.0,
        Cx_pil = 8,
        D_max = 45000.0,
        D_min = 6000.0,
        Head_Form = 1,
        Life_Time = 75.0,
        Nr_max = 27,
        v_min = 170.0,
        v_mid = 1000.0,
        Mach_max = 5.3,
        t_b = 0.0,
        t_acc = 10.0,
        t_marsh = 0.0,
        Range_max = 75000.0,
        H_min_t = 250.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 2.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA9M83"],
        exhaust = tail_solid,
        X_back = -2.103,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.4212,
        KillDistance = 30.0,
    },
    {
        Name = SAV611, --V-611
        Escort = 3,
        Head_Type = 6,
        M = 1844.0,
        H_max = 25000.0,
        H_min = -1,
        Diam = 600.0,
        Cx_pil = 8,
        D_max = 10000.0,
        D_min = 3000.0,
        Head_Form = 1,
        Life_Time = 100.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 2.7,
        t_b = 0.0,
        t_acc = 10.0,
        t_marsh = 0.0,
        Range_max = 30000.0,
        H_min_t = 100.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SAV611"],
        exhaust = tail_solid,
        X_back = -1.917,
        Y_back = 0.121,
        Z_back = 0.0,
        Reflection = 0.178,
        KillDistance = 15.0,
    },
    {
        Name = SA3M9M, --3M9M Kub
        Escort = 3,
        Head_Type = 6,
        M = 600.0,
        H_max = 12000.0,
        H_min = 50.0,
        Diam = 330.0,
        Cx_pil = 4,
        D_max = 16000.0,
        D_min = 4000.0,
        Head_Form = 1,
        Life_Time = 60.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 450.0,
        Mach_max = 2.2,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 22.0,
        Range_max = 35000.0,
        H_min_t = 30.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA3M9M"],
        exhaust = tail_solid,
        X_back = -3.0,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.106,
        KillDistance = 12.0,
    },
    {
        Name = SA9M33, --9M33 Osa
        Escort = 3,
        Head_Type = 6,
        M = 126.3,
        H_max = 5000.0,
        H_min = 5.0,
        Diam = 206.0,
        Cx_pil = 2,
        D_max = 10000.0,
        D_min = 1500.0,
        Head_Form = 1,
        Life_Time = 60.0,
        Nr_max = 14,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 1.9,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 14.0,
        Range_max = 10000.0,
        H_min_t = 25.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA9M33"],
        exhaust = tail_solid,
        X_back = -1.593,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0404,
        KillDistance = 5.0,
    },
    {
        Name = SA9M31, --9M31 Strela-1
        Escort = 0,
        Head_Type = 1,
        M = 32.0,
        H_max = 3500.0,
        H_min = 30.0,
        Diam = 120.0,
        Cx_pil = 2,
        D_max = 4200.0,
        D_min = 800.0,
        Head_Form = 0,
        Life_Time = 30.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 250.0,
        Mach_max = 1.3,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 7.0,
        Range_max = 4200.0,
        H_min_t = 30.0,
        Fi_start = 0.75,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA9M31"],
        exhaust = tail_solid,
        X_back = -0.95,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0101,
        KillDistance = 2.5,
    },
    {
        Name = SA9M38M1, --9M38M1 Buk
        Escort = 3,
        Head_Type = 6,
        M = 685.0,
        H_max = 20000.0,
        H_min = 22.0,
        Diam = 400.0,
        Cx_pil = 4,
        D_max = 25000.0,
        D_min = 3000.0,
        Head_Form = 1,
        Life_Time = 80.0,
        Nr_max = 19,
        v_min = 170.0,
        v_mid = 430.0,
        Mach_max = 3.2,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 12.0,
        Range_max = 50000.0,
        H_min_t = 15.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA9M38M1"],
        exhaust = tail_solid,
        X_back = -2.85,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0918,
        KillDistance = 13.0,
    },
    {
        Name = SA9M333, --9M333 Strela-10
        Escort = 0,
        Head_Type = 1,
        M = 39.0,
        H_max = 3500.0,
        H_min = 25.0,
        Diam = 120.0,
        Cx_pil = 2,
        D_max = 5000.0,
        D_min = 800.0,
        Head_Form = 0,
        Life_Time = 30.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 2.0,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 5.0,
        Range_max = 5000.0,
        H_min_t = 10.0,
        Fi_start = 0.75,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA9M333"],
        exhaust = tail_solid,
        X_back = -1.126,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0149,
        KillDistance = 3.0,
    },
    {
        Name = SA9M330, --9M330 Tor
        Escort = 3,
        Head_Type = 6,
        M = 165.0,
        H_max = 6000.0,
        H_min = 10.0,
        Diam = 220.0,
        Cx_pil = 2,
        D_max = 6000.0,
        D_min = 1500.0,
        Head_Form = 1,
        Life_Time = 30.0,
        Nr_max = 30,
        v_min = 170.0,
        v_mid = 430.0,
        Mach_max = 3.0,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 6.0,
        Range_max = 12000.0,
        H_min_t = 10.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 2.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA9M330"],
        exhaust = tail_solid,
        X_back = -1.37,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0307,
        KillDistance = 7.0,
    },
    {
        Name = SA9M311, --9M311 Tunguska
        Escort = 3,
        Head_Type = 6,
        M = 57.0,
        H_max = 3500.0,
        H_min = 15.0,
        Diam = 100.0,
        Cx_pil = 6,
        D_max = 7000.0,
        D_min = 2000.0,
        Head_Form = 1,
        Life_Time = 30.0,
        Nr_max = 18,
        v_min = 170.0,
        v_mid = 600.0,
        Mach_max = 2.82,
        t_b = 0.0,
        t_acc = 2.0,
        t_marsh = 0.0,
        Range_max = 7000.0,
        H_min_t = 15.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA9M311"],
        exhaust = tail_solid,
        X_back = -1.1,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0102,
        KillDistance = 5.0,
    },
    {
        Name = Igla_1E, --9M39 Igla
        Escort = 0,
        Head_Type = 1,
        M = 10.8,
        H_max = 2500.0,
        H_min = 1.0,
        Diam = 72.0,
        Cx_pil = 1,
        D_max = 4500.0,
        D_min = 500.0,
        Head_Form = 1,
        Life_Time = 30.0,
        Nr_max = 16,
        v_min = 70.0,
        v_mid = 570.0,
        Mach_max = 2.2,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 3.0,
        Range_max = 4500.0,
        H_min_t = 10.0,
        Fi_start = 0.75,
        Fi_rak = 3.14152,
        Fi_excort = 0.7,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["Igla_1E"],
        exhaust = tail_solid,
        X_back = -0.781,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0044,
        KillDistance = 1.0,
    },
    {
        Name = MIM_104, --MIM-104 Patriot
        Escort = 3,
        Head_Type = 6,
        M = 700.0,
        H_max = 24240.0,
        H_min = 60.0,
        Diam = 410.0,
        Cx_pil = 4,
        D_max = 40000.0,
        D_min = 3000.0,
        Head_Form = 1,
        Life_Time = 300.0,
        Nr_max = 25,
        v_min = 170.0,
        v_mid = 600.0,
        Mach_max = 8.0,
        t_b = 0.0,
        t_acc = 12.0,
        t_marsh = 0.0,
        Range_max = 135000.0,
        H_min_t = 25.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 0.75,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["MIM_104"],
        exhaust = tail_solid,
        X_back = -2.474,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.1066,
        KillDistance = 13.0,
    },
    {
        Name = MIM_72G, --MIM-72G Chaparrel
        Escort = 0,
        Head_Type = 1,
        M = 84.0,
        H_max = 3000.0,
        H_min = -1,
        Diam = 127.0,
        Cx_pil = 1,
        D_max = 4000.0,
        D_min = 300.0,
        Head_Form = 0,
        Life_Time = 80.0,
        Nr_max = 22,
        v_min = 140.0,
        v_mid = 350.0,
        Mach_max = 2.5,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 0.0,
        Range_max = 8500.0,
        H_min_t = 5.0,
        Fi_start = 0.3,
        Fi_rak = 3.14152,
        Fi_excort = 0.79,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["MIM_72G"],
        exhaust = tail_solid,
        X_back = -1.455,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0182,
        KillDistance = 5.0,
    },
    {
        Name = FIM_92C, --FIM-92C
        Escort = 0,
        Head_Type = 1,
        M = 10.1,
        H_max = 3500.0,
        H_min = 1.0,
        Diam = 70.0,
        Cx_pil = 1,
        D_max = 4500.0,
        D_min = 200.0,
        Head_Form = 1,
        Life_Time = 30.0,
        Nr_max = 18,
        v_min = 70.0,
        v_mid = 300.0,
        Mach_max = 2.2,
        t_b = 0.0,
        t_acc = 3.0,
        t_marsh = 3.0,
        Range_max = 4500.0,
        H_min_t = 10.0,
        Fi_start = 0.75,
        Fi_rak = 3.14152,
        Fi_excort = 0.7,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["FIM_92C"],
        exhaust = tail_solid,
        X_back = -0.781,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0044,
        KillDistance = 0.0,
    },
    {
        Name = SA5B27, --5V27 S-125 -- beczl
        Escort = 3,
        Head_Type = 6,
        M = 700.0,
        H_max = 18000.0,
        H_min = 60, --20
        Diam = 400.0,
        Cx_pil = 4,
        D_max = 11000.0,
        D_min = 3500.0,
        Head_Form = 1,
        Life_Time = 80.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 430.0,
        Mach_max = 2.2,
        t_b = 0.0,
        t_acc = 6.0, --4.0
        t_marsh = 20.0,
        Range_max = 25000.0,
        H_min_t = 200.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["SA5B27"],
        exhaust = tail_solid,
        X_back = -1.643,
        Y_back = 0.0, ---0.257
        Z_back = 0.0,
        Reflection = 0.1676,
        KillDistance = 14.0,
    },
    {
        Name = HAWK_RAKETA, --MIM-23B Hawk
        Escort = 3,
        Head_Type = 6,
        M = 630.0,
        H_max = 17700.0,
        H_min = 60.0,
        Diam = 370.0,
        Cx_pil = 4,
        D_max = 30000.0,
        D_min = 1500.0,
        Head_Form = 1,
        Life_Time = 80.0,
        Nr_max = 16,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 2.3,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 25.0,
        Range_max = 60000.0,
        H_min_t = 25.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["HAWK_RAKETA"],
        exhaust = tail_solid,
        X_back = -2.6,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.1676,
        KillDistance = 12.0,
    },
    {
        Name = ROLAND_R, --Roland
        Escort = 3,
        Head_Type = 6,
        M = 75.0,
        H_max = 6000.0,
        H_min = 10,
        Diam = 150.0,
        Cx_pil = 2,
        D_max = 8000.0,
        D_min = 500.0,
        Head_Form = 1,
        Life_Time = 30.0,
        Nr_max = 14,
        v_min = 170.0,
        v_mid = 570.0,
        Mach_max = 2.0,
        t_b = 0.3,
        t_acc = 3.0,
        t_marsh = 10.0,
        Range_max = 8000.0,
        H_min_t = 10.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["ROLAND_R"],
        exhaust = tail_solid,
        X_back = -1.200,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0196,
        KillDistance = 5.0,
    },
    {
        Name = P_35, --P-35
        Escort = 0,
        Head_Type = 5,
        M = 4500.0,
        H_max = 12000.0,
        H_min = -1,
        Diam = 830.0,
        Cx_pil = 1,
        D_max = 300000.0,
        D_min = 3000.0,
        Head_Form = 1,
        Life_Time = 1800.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 442.0,
        Mach_max = 1.3,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 800.0,
        Range_max = 300000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["P_35"],
        exhaust1 = tail_solid,
        X_back = -4.712,
        Y_back = -0.354,
        Z_back = 0.0,
        Reflection = 0.3967,
        KillDistance = 0.0,
    },
    {
        Name = P_500, --P-500
        Escort = 0,
        Head_Type = 5,
        M = 4800.0,
        H_max = 12000.0,
        H_min = -1,
        Diam = 950.0,
        Cx_pil = 1,
        D_max = 550000.0,
        D_min = 13000.0,
        Head_Form = 1,
        Life_Time = 1800.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 986.0,
        Mach_max = 2.5,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 1800.0,
        Range_max = 550000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["P_500"],
        exhaust1 = tail_solid,
        X_back = -5.814,
        Y_back = 0.099,
        Z_back = 0.0,
        Reflection = 0.3967,
        KillDistance = 0.0,
    },
    {
        Name = P_700, --P-700
        Escort = 0,
        Head_Type = 5,
        M = 6900.0,
        H_max = 12000.0,
        H_min = -1,
        Diam = 850.0,
        Cx_pil = 1,
        D_max = 550000.0,
        D_min = 13000.0,
        Head_Form = 1,
        Life_Time = 1800.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 850.0,
        Mach_max = 2.5,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 1800.0,
        Range_max = 550000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["P_700"],
        exhaust1 = tail_solid,
        X_back = -5.101,
        Y_back = -0.149,
        Z_back = 0.0,
        Reflection = 0.3967,
        KillDistance = 0.0,
    },
    {
        Name = P_15U, --P-15U
        Escort = 0,
        Head_Type = 5,
        M = 2325.0,
        H_max = 12000.0,
        H_min = -1,
        Diam = 470.0,
        Cx_pil = 1,
        D_max = 40000.0,
        D_min = 3000.0,
        Head_Form = 1,
        Life_Time = 1800.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 374.0,
        Mach_max = 1.1,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 800.0,
        Range_max = 40000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["P_15U"],
        exhaust1 = tail_solid,
        X_back = -2.273,
        Y_back = -0.669,
        Z_back = 0.0,
        Reflection = 0.3967,
        KillDistance = 0.0,
    },
    {
        Name = P_120,
        Escort = 0,
        Head_Type = 5,
        M = 2500.0,
        H_max = 12000.0,
        H_min = -1,
        Diam = 720.0,
        Cx_pil = 1,
        D_max = 110000.0,
        D_min = 3000.0,
        Head_Form = 1,
        Life_Time = 1800.0,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 306.0,
        Mach_max = 0.9,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 250.0,
        Range_max = 110000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["P_120"],
        exhaust1 = tail_solid,
        X_back = -4.078,
        Y_back = -0.277,
        Z_back = 0.0,
        Reflection = 0.21,
        KillDistance = 0.0,
    },
    {
        Name = R_85,
        Escort = 0,
        Head_Type = 5,
        M = 1900.0,
        H_max = 12000.0,
        H_min = -1,
        Diam = 830.0,
        Cx_pil = 3,
        D_max = 350000.0,
        D_min = 5000.0,
        Head_Form = 1,
        Life_Time = 1800.0,
        Nr_max = 10,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 2.0,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 250.0,
        Range_max = 350000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["R_85"],
        exhaust1 = tail_solid,
        exhaust2 = tail_liquid,
        X_back = -6.521,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.3967,
        KillDistance = 0.0,
    },
    {
        Name = R_85U,
        Escort = 0,
        Head_Type = 5,
        M = 1900.0,
        H_max = 12000.0,
        H_min = -1,
        Diam = 830.0,
        Cx_pil = 3,
        D_max = 55000.0,
        D_min = 2000.0,
        Head_Form = 1,
        Life_Time = 1800.0,
        Nr_max = 10,
        v_min = 170.0,
        v_mid = 350.0,
        Mach_max = 1.0,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 250.0,
        Range_max = 55000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["R_85U"],
        exhaust1 = tail_solid,
        exhaust2 = tail_liquid,
        X_back = -3.577,
        Y_back = -0.041,
        Z_back = -0.403,
        Reflection = 0.3967,
        KillDistance = 0.0,
    },
    {
        Name = BGM_109B, --BGM-109B Tomahawk
        Escort = 0,
        Head_Type = 5,
        M = 1225.0,
        H_max = 12000.0,
        H_min = -1,
        Diam = 830.0,
        Cx_pil = 1,
        D_max = 460000.0,
        D_min = 3000.0,
        Head_Form = 1,
        Life_Time = 7200.0,
        Nr_max = 17,
        v_min = 170.0,
        v_mid = 238.0,
        Mach_max = 0.85,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 7200.0,
        Range_max = 460000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["BGM_109B"],
        exhaust1 = tail_solid,
        X_back = -3.463,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.3967,
        KillDistance = 0.0,
    },
    {
        Name = AGM_84S, --AGM-84S
        Escort = 0,
        Head_Type = 5,
        M = 661.5,
        H_max = 10000.0,
        H_min = -1,
        Diam = 343.0,
        Cx_pil = 6,
        D_max = 95000.0,
        D_min = 3000.0,
        Head_Form = 1,
        Life_Time = 1850.0,
        Nr_max = 18,
        v_min = 170.0,
        v_mid = 306.0,
        Mach_max = 0.9,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 1800.0,
        Range_max = 241401.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_84S"],
        exhaust1 = tail_solid,
        X_back = -2.235,
        Y_back = -0.173,
        Z_back = 0.0,
        Reflection = 0.1058,
        KillDistance = 0.0,
    },
    {
        Name = MALUTKA, --9M14 Malutka
        Escort = 1,
        Head_Type = 4,
        M = 40.0,
        H_max = 2000.0,
        H_min = -1,
        Diam = 100.0,
        Cx_pil = 6,
        D_max = 3000.0,
        D_min = 500.0,
        Head_Form = 1,
        Life_Time = 30.0,
        Nr_max = 1.1,
        v_min = 105.0,
        v_mid = 115.0,
        Mach_max = 0.45,
        t_b = 0.0,
        t_acc = 2.0,
        t_marsh = 30.0,
        Range_max = 3000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["MALUTKA"],
        exhaust = {0.9, 0.9, 0.9, 0.4 };
        X_back = -0.372,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0658,
        KillDistance = 0.0,
    },
    {
        Name = KONKURS, --9M113 Konkurs
        Escort = 1,
        Head_Type = 4,
        M = 40.0,
        H_max = 2000.0,
        H_min = -1,
        Diam = 100.0,
        Cx_pil = 6,
        D_max = 4000.0,
        D_min = 750.0,
        Head_Form = 1,
        Life_Time = 25.0,
        Nr_max = 1.2,
        v_min = 105.0,
        v_mid = 200.0,
        Mach_max = 0.7,
        t_b = 0.0,
        t_acc = 2.0,
        t_marsh = 30.0,
        Range_max = 4000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["KONKURS"],
        exhaust = {0.9, 0.9, 0.9, 0.2 };
        X_back = -0.405,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0658,
        KillDistance = 0.0,
    },
    {
        Name = P_9M117, --9M117 Bastion
        Escort = 1,
        Head_Type = 4,
        M = 40.0,
        H_max = 2000.0,
        H_min = -1,
        Diam = 100.0,
        Cx_pil = 6,
        D_max = 4000.0,
        D_min = 750.0,
        Head_Form = 1,
        Life_Time = 25.0,
        Nr_max = 1.1,
        v_min = 105.0,
        v_mid = 200.0,
        Mach_max = 0.7,
        t_b = 0.0,
        t_acc = 0.3,
        t_marsh = 30.0,
        Range_max = 4000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["P_9M117"],
        exhaust = {0.9, 0.9, 0.9, 0.2 };
        X_back = 0.05,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0658,
        KillDistance = 0.0,
    },
    {
        Name = TOW, --BGM-71D Tow
        Escort = 1,
        Head_Type = 4,
        M = 40.0,
        H_max = 2000.0,
        H_min = -1,
        Diam = 150.0,
        Cx_pil = 6,
        D_max = 4000.0,
        D_min = 750.0,
        Head_Form = 1,
        Life_Time = 25.0,
        Nr_max = 1.2,
        v_min = 105.0,
        v_mid = 150.0,
        Mach_max = 0.7,
        t_b = 0.0,
        t_acc = 0.5,
        t_marsh = 30.0,
        Range_max = 5000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["TOW"],
        exhaust = {0.9, 0.9, 0.8, 0.2 };
        X_back = 0.0,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0658,
        KillDistance = 0.0,
    },
    {
        Name = AGM_154, --AGM-154
        Escort = 0,
        Head_Type = 5,
        M = 450.0,
        H_max = 28000.0,
        H_min = -1,
        Diam = 1010.0,
        Cx_pil = 8,
        D_max = 27780.0,
        D_min = 750.0,
        Head_Form = 1,
        Life_Time = 6400.0,
        Nr_max = 10,
        v_min = 10.0,
        v_mid = 100.0,
        Mach_max = 0.7,
        t_b = 0.0,
        t_acc = 0.0,
        t_marsh = 600.0,
        Range_max = 74080.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 3.14152,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["AGM_154"],
        -- No exhaust (turbo)
        X_back = -2.552,
        Y_back = -0.252,
        Z_back = 0.0,
        Reflection = 0.0618,
        KillDistance = 0.0,
    },
    {
        Name = P_9M133, --9M133
        Escort = 1,
        Head_Type = 4,
        M = 27.0,
        H_max = 5000.0,
        H_min = -1,
        Diam = 152.0,
        Cx_pil = 6,
        D_max = 5000.0,
        D_min = 500.0,
        Head_Form = 1,
        Life_Time = 25.0,
        Nr_max = 1.2,
        v_min = 105.0,
        v_mid = 200.0,
        Mach_max = 0.7,
        t_b = 0.0,
        t_acc = 0.5,
        t_marsh = 20.0,
        Range_max = 5000.0,
        H_min_t = 0.0,
        Fi_start = 3.14152,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["P_9M133"],
		exhaust = {0.9, 0.9, 0.9, 0.2 };
        X_back = -0.5,
        Y_back = 0.0,
        Z_back = 0.0,
        Reflection = 0.0658,
        KillDistance = 0.0,
    },
    {
        Name = S_25L, --S-25L
        Escort = 1,
        Head_Type = 4,
        M = 485.0,
        H_max = 4000.0,
        H_min = -1,
        Diam = 340.0,
        Cx_pil = 6,
        D_max = 4000.0,
        D_min = 1000.0,
        Head_Form = 0,
        Life_Time = 60.0,
        Nr_max = 1,
        v_min = 170.0,
        v_mid = 300.0,
        Mach_max = 1.7,
        t_b = 0.0,
        t_acc = 6.0,
        t_marsh = 0.0,
        Range_max = 7000.0,
        H_min_t = 0.0,
        Fi_start = 0.15,
        Fi_rak = 3.14152,
        Fi_excort = 0.35,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["S_25L"],
        exhaust = {0.6, 0.6, 0.6, 0.7},
        X_back = -1.46,
        Y_back = -0.215,
        Z_back = 0.0,
        Reflection = 0.0704,
        KillDistance = 0.0,
    },
}


for _, v in pairs(rockets) do

   if ( v.warhead.cumulative_factor and
        v.warhead.cumulative_factor ~= 0) then
        v.Damage = v.warhead.cumulative_factor*v.warhead.expl_mass*2.5;
    elseif (v.warhead.expl_mass) then
        v.Damage = v.warhead.expl_mass*2.5;
    else
        v.Damage = 0.0;
    end
end
