dofile(LockOn_Options.script_path.."Multipurpose_Display_Group/HUD_AVQ32/indicator/HUD_page_defs.lua")

-- HUD_OPTICS_MOD ----------------------------------

-- NOTE: the purpose of this file is to render effects for the HUD that must not be displayed on the HUD repeater

-- Simulate the CRT display green glow by drawing a large green circle the size of the CRT
local Glow          = CreateElement "ceMeshPoly"
Glow.name           = "CRT_background"
Glow.init_pos       = nil
Glow.primitivetype  = "triangles"
set_circle(Glow, MilToDI(HUD_TFOV_mils),nil,nil,128)
Glow.isdraw         = true
Glow.material       = "HUD_GLOW_MATERIAL"
Glow.collimated      = true
Glow.additive_alpha	  = additive_alpha
Glow.h_clip_relation = h_clip_relations.COMPARE
Glow.level 		      = DEFAULT_LEVEL - 1
Add(Glow)

-- Now simulate the faint propagation/reflection of glow from the CRT on the lens tube by drawing an even larger green circle.
-- We use the same color as the CRT but because we're using additive blending the CRT glow will always be brighter then the tube glow.
local Glow22          = CreateElement "ceMeshPoly"
Glow22.name           = "CRT_background"
Glow22.init_pos       = nil
Glow22.primitivetype  = "triangles"
set_circle(Glow22, MilToDI(HUD_TFOV_mils)*10,nil,nil,128)
Glow22.isdraw         = true
Glow22.material       = "HUD_GLOW_MATERIAL"
Glow22.collimated      = true
Glow22.additive_alpha	  = additive_alpha
Glow22.h_clip_relation = h_clip_relations.COMPARE
Glow22.level 		      = DEFAULT_LEVEL - 1
Add(Glow22)

-- Now we'll do a trick do fake the border of the tube where the  lens sits. We do this because accoording to videos and pictures of
-- the real HUD this border seems to be quite visible when the HUD brightness is high. This is done in 3 steps:
--
-- 1 - Mask the area of the screen that corresponds to the reflection of the lens on the combiner glass
-- 2 - Draw a green ring on the same place as the reflection of the lens but slightly offset in depth, the parallax effect will combined with the mask from step 1 will appear as if we have drawn the inside of a cylinder
-- 3 - Undo the mask from step 1 so the rest of the rendering can proceed normally

-- Mask the area
local Glow2Mask          = CreateElement "ceMeshPoly"
Glow2Mask.name           = "Glow2Mask"
Glow2Mask.init_pos       = {0, -DegToDI(4),600}
Glow2Mask.primitivetype  = "triangles"
set_circle(Glow2Mask, DegToDI(6.5),nil,nil,128)
Glow2Mask.isdraw         = true
Glow2Mask.collimated      = false
Glow2Mask.additive_alpha	  = false
Glow2Mask.change_opacity = false
Glow2Mask.h_clip_relation  = h_clip_relations.INCREASE_IF_LEVEL
Glow2Mask.level 		      = DEFAULT_LEVEL  - 1
Add(Glow2Mask)
setAsInvisibleMask(Glow2Mask)

-- Draw the green ring to fake the inside of the cylinder
local Glow2          = CreateElement "ceMeshPoly"
Glow2.name           = "Glow2"
Glow2.init_pos       = {0, -DegToDI(4),650}
Glow2.primitivetype  = "triangles"
set_circle(Glow2, DegToDI(6.5)*1.1,DegToDI(6.5),nil,128)
Glow2.isdraw         = true
Glow2.material       = "HUD_GLOW_MATERIAL"
Glow2.collimated      = false
Glow2.additive_alpha	  = additive_alpha
Glow2.h_clip_relation = h_clip_relations.COMPARE
Glow2.level 		      = DEFAULT_LEVEL
Add(Glow2)

-- Unmask the area
local Glow2MaskUndo          = CreateElement "ceMeshPoly"
Glow2MaskUndo.name           = "Glow2MaskUndo"
Glow2MaskUndo.init_pos       = {0, -DegToDI(4),600}
Glow2MaskUndo.primitivetype  = "triangles"
set_circle(Glow2MaskUndo, DegToDI(6.5),nil,nil,128)
Glow2MaskUndo.isdraw         = true
Glow2MaskUndo.collimated      = false
Glow2MaskUndo.additive_alpha	  = false
Glow2MaskUndo.change_opacity = false
Glow2MaskUndo.h_clip_relation  = h_clip_relations.DECREASE_IF_LEVEL
Glow2MaskUndo.level 		      = DEFAULT_LEVEL
Add(Glow2MaskUndo)
setAsInvisibleMask(Glow2MaskUndo)

-- Now do the same as above for the reflection of the lens on the second combiner glass

-- Mask the area
local Glow3Mask          = CreateElement "ceMeshPoly"
Glow3Mask.name           = "Glow3Mask"
Glow3Mask.init_pos       = {0,DegToDI(2.11),1100}
Glow3Mask.primitivetype  = "triangles"
set_circle(Glow3Mask, DegToDI(6.5),nil,nil,128)
Glow3Mask.isdraw         = true
Glow3Mask.collimated      = false
Glow3Mask.additive_alpha	  = false
Glow3Mask.change_opacity = false
Glow3Mask.h_clip_relation  = h_clip_relations.INCREASE_IF_LEVEL
Glow3Mask.level 		      = DEFAULT_LEVEL - 1
Add(Glow3Mask)
setAsInvisibleMask(Glow3Mask)

-- Draw the green ring to fake the inside of the cylinder
local Glow3          = CreateElement "ceMeshPoly"
Glow3.name           = "Glow3"
Glow3.init_pos       = {0,DegToDI(2.11),1150}
Glow3.primitivetype  = "triangles"
set_circle(Glow3, DegToDI(6.5)*1.1,DegToDI(6.5),nil,128)
Glow3.isdraw         = true
Glow3.material       ="HUD_GLOW_MATERIAL"
Glow3.collimated      = false
Glow3.additive_alpha	  = additive_alpha
Glow3.h_clip_relation = h_clip_relations.COMPARE
Glow3.level 		      = DEFAULT_LEVEL
Add(Glow3)

-- Unmask the area
local Glow3MaskUndo          = CreateElement "ceMeshPoly"
Glow3MaskUndo.name           = "Glow3MaskUndo"
Glow3MaskUndo.init_pos       = {0,DegToDI(2.11),1100}
Glow3MaskUndo.primitivetype  = "triangles"
set_circle(Glow3MaskUndo, DegToDI(6.5),nil,nil,128)
Glow3MaskUndo.isdraw         = true
Glow3MaskUndo.collimated      = false
Glow3MaskUndo.additive_alpha	  = false
Glow3MaskUndo.change_opacity = false
Glow3MaskUndo.h_clip_relation  = h_clip_relations.DECREASE_IF_LEVEL
Glow3MaskUndo.level 		      = DEFAULT_LEVEL
Add(Glow3MaskUndo)
setAsInvisibleMask(Glow3MaskUndo)

-- Clip the symbology so that it is only rendered inside the CRT display area
local TFOVMask          = CreateElement "ceMeshPoly"
TFOVMask.name           = "TFOVMask"
TFOVMask.init_pos       = nil
TFOVMask.primitivetype  = "triangles"
set_circle(TFOVMask, MilToDI(HUD_TFOV_mils),nil,nil,128)
TFOVMask.isdraw         = true
TFOVMask.collimated      = true
TFOVMask.additive_alpha	  = false
TFOVMask.change_opacity = false
TFOVMask.h_clip_relation  = h_clip_relations.INCREASE_IF_LEVEL
TFOVMask.level 		      = DEFAULT_LEVEL - 1
Add(TFOVMask)
setAsInvisibleMask(TFOVMask)

-- HUD_OPTICS_MOD ----------------------------------