dofile(LockOn_Options.script_path .. "command_defs.lua")
dofile(LockOn_Options.script_path .. "devices.lua")

std_message_timeout = 5

local t_start = 0.0
local t_stop = 0.0
local delta_t_com = 2.0

start_sequence_full = {}
stop_sequence_full = {}

function push_command(sequence, run_t, command)
	sequence[#sequence + 1] =  command
	sequence[#sequence]["time"] = run_t
end

function push_start_command(delta_t, command)
	t_start = t_start + delta_t
	push_command(start_sequence_full,t_start, command)
end

function push_stop_command(delta_t, command)
	t_stop = t_stop + delta_t
	push_command(stop_sequence_full,t_stop, command)
end






-- --------------------------------------------------------------------------------------






push_start_command(0.0, {message = _("AUTOSTART SEQUENCE IS RUNNING"), message_timeout = std_message_timeout})



--Battery On
push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_178, value = 1.0, message = _("Battery ON"), message_timeout = std_message_timeout})

--APU Power On
push_start_command(0.1, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_180, value = 0.2, message = _("APU ON"), message_timeout = std_message_timeout})
push_start_command(0.5, {message = _("APU BIT in progress, Setting Lights ON"), message_timeout = 5})

											--Set lights while waiting for APU BIT
			--ADF Volume OFF
			push_start_command(0.5, {device = devices.COMM_PANEL_RIGHT, action = device_commands.Button_46, value = 0.0}) -- Pilots ADF Volume switch Pull to off
			push_start_command(0.0, {device = devices.COMM_PANEL_LEFT, action = device_commands.Button_46, value = 0.0}) -- CoPilots ADF Volume switch Pull to off
			push_start_command(0.0, {device = devices.COMM_PANEL_TROOP_COMMANDER, action = device_commands.Button_46, value = 0.0}) -- Troop Commander ADF Volume switch Pull to off
			
			--Radio panel volume knobs set to down and MAX Vol
			push_start_command(0.0, {device = devices.COMM_PANEL_RIGHT, action = device_commands.Button_1, value = 1.0,}) -- Pilots FM1 Volume switch Push Down
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_15, value = -1.0,}) -- Pilots FM1 Volume MAX
			push_start_command(0.0, {device = devices.COMM_PANEL_RIGHT, action = device_commands.Button_6, value = 1.0,}) -- Pilots UHF Volume switch Push Down
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_20, value = -1.0,}) -- Pilots UHF Volume MAX
			push_start_command(0.0, {device = devices.COMM_PANEL_RIGHT, action = device_commands.Button_11, value = 1.0,}) -- Pilots VHF Volume switch Push Down
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_25, value = -1.0,}) -- Pilots VHF Volume MAX
			push_start_command(0.0, {device = devices.COMM_PANEL_RIGHT, action = device_commands.Button_16, value = 1.0,}) -- Pilots HF Volume switch Push Down
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_30, value = -1.0,}) -- Pilots HF Volume MAX
			push_start_command(0.0, {device = devices.COMM_PANEL_RIGHT, action = device_commands.Button_21, value = 1.0,}) -- Pilots FM2 Volume switch Push Down
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_35, value = -1.0,}) -- Pilots FM2 Volume MAX
			push_start_command(0.0, {device = devices.COMM_PANEL_RIGHT, action = device_commands.Button_31, value = 1.0,}) -- Pilots RWR Volume switch Push Down
			--push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_45, value = -1.0,}) -- Pilots RWR Volume MAX
			
			--Rotate Audio Panel Master Volume to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			--push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			--push_start_command(0.0, {device = devices.TERTIARY_REFLECTS, action = device_commands.Button_67, value = 1.0,}) -- Pilots Master Volume knob to max
			
			--Hook Control
			push_start_command(0.5, {device = devices.EXTERNAL_CARGO_EQUIPMENT, action = device_commands.Button_5, value = 1.0}) --  Pilot cyclic stick Hook release cover switch Open
			push_start_command(0.0, {device = devices.EXTERNAL_CARGO_EQUIPMENT, action = device_commands.Button_5, value = 1.0}) --CoPilot cyclic stick Hook release cover switch Open
			push_start_command(0.5, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_159, value = 2.0}) --Hook Control to Arm
			push_start_command(0.5, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_162, value = 2.0}) --Hook Selector to ALL

			--Panel Lights NVG
			push_start_command(0.5, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_48, value = 2.0}) --Console Dimmer Knob
			push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_51, value = 2.0}) --Stick Dimmer Knob
			push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_94, value = 2.0}) --Centre Instruments Dimmer Knob
			push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_97, value = 2.0}) --Pilot Instruments Dimmer Knob
			push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_102, value = 2.0}) --CoPilots Instruments Dimmer Knob
			push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_105, value = 2.0}) --OVHD Console Dimmer Knob
			push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_64, value = 0.15}) --Panel Flood Lights Brightness Knob to Minimum for ON
			--push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_54, value = 2.0}) --Intrument Panel Flood Light
			--push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_56, value = 2.0}) --OVHD Panel Flood Light
			

			--Exterior Lights
			push_start_command(0.5, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_67, value = 2.0}) --Anti-Collision Mode Knob to Both
			push_start_command(0.5, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_84, value = 2.0}) --Position Light Switch 
			push_start_command(0.5, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_87, value = 2.0}) --Position Light Mode Switch
			
			--Searchlight Switch
			push_start_command(0.5, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_89, value = 1.0}) --Pilot Searchlight controls to ON
			push_start_command(0.5, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_100, value = 1.0}) --CoPilot Searchlight controls to ON

									
										-- If lights not required, 5 sec Pause must be added to APU to Start i.e. 
										--push_start_command(5.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_180, value = 0.1, message = _("Hold APU START for 3 seconds"), message_timeout = 3}) --APU TO START

--APU BIT Complete - Set to Start

--push_start_command(5.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_180, value = 0.1, message = _("Hold APU START for 3 seconds"), message_timeout = 3}) --APU TO START		uncomment this line if lights not required
push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_180, value = 0.1, message = _("Hold APU START for 3 seconds"), message_timeout = 3}) --APU TO START         comment this line when lights not required

push_start_command(3.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_180, value = 0.0}) --APU BACK TO RUN
push_start_command(1.0,{device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_177, value = 0.2, message = _("APU Generator ON"), message_timeout = std_message_timeout}) -- APU GEN ON


--Fuel pump Switches 
	push_start_command(0.2, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_7, value = 1.0, message = _("Fuel Pumps ON"), message_timeout = std_message_timeout}) --#1 Aft Aux
	push_start_command(0.0,{device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_15, value = 1.0,}) --#2 Aft Aux
	push_start_command(0.2,{device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_5, value = 1.0,}) --#1 Main 2
	push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_13, value = 1.0,}) --#2 Main 2
	push_start_command(0.2, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_3, value = 1.0}) -- #1 Main 1
	push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_11, value = 1.0}) --#2 Main 1
	push_start_command(0.2, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_1, value = 1.0}) --#1 Fwd Aux
	push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_9, value = 1.0}) --#2 Fwd Aux
	--push_start_command(2.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_19, value = 1.0, message = _("Fuel XFEED ON"), message_timeout = std_message_timeout})

--Backup Radio ON	
push_start_command(0.5, {device = devices.ARC_186, action = device_commands.Button_3, value = 0.1}) --Backup Radio set to T/R
push_start_command(0.0, {device = devices.ARC_186, action = device_commands.Button_5, value = 1.0}) --Backup Radio volume set to MAX
		
		--Tune Backup Radio Keys
		--push_start_command(0.0, {device = devices.ARC_186, action = device_commands.Button_9, value = 0.1}) --Backup Radio 1st Freq Up
		--push_start_command(0.0, {device = devices.ARC_186, action = device_commands.Button_9, value = -0.1}) --Backup Radio 1st Freq Down
		--push_start_command(0.0, {device = devices.ARC_186, action = device_commands.Button_11, value = 0.1}) --Backup Radio 2nd Freq UP
		--push_start_command(0.0, {device = devices.ARC_186, action = device_commands.Button_11, value = -0.1}) --Backup Radio 2nd Freq Down
		--push_start_command(0.0, {device = devices.ARC_186, action = device_commands.Button_13, value = 0.1}) --Backup Radio 3rd Freq Up
		--push_start_command(0.0, {device = devices.ARC_186, action = device_commands.Button_13, value = -0.1}) --Backup Radio 3rd Freq Down
		--push_start_command(0.0, {device = devices.ARC_186, action = device_commands.Button_15, value = 0.1}) --Backup Radio 4th Freq Up
		--push_start_command(0.0, {device = devices.ARC_186, action = device_commands.Button_15, value = -0.1}) --Backup Radio 4th Freq Down
		
--Backup Radio 124.0 to 121.5
--push_start_command(0.0, {device = devices.ARC_186, action = device_commands.Button_11, value = -0.1}) --Backup Radio 2nd Freq Down
--push_start_command(0.3, {device = devices.ARC_186, action = device_commands.Button_11, value = -0.1}) --Backup Radio 2nd Freq Down
--push_start_command(0.3, {device = devices.ARC_186, action = device_commands.Button_11, value = -0.1}) --Backup Radio 2nd Freq Down
	
--push_start_command(0.3, {device = devices.ARC_186, action = device_commands.Button_13, value = 0.1}) --Backup Radio 3rd Freq Up
--push_start_command(0.3, {device = devices.ARC_186, action = device_commands.Button_13, value = 0.1}) --Backup Radio 3rd Freq Up
--push_start_command(0.3, {device = devices.ARC_186, action = device_commands.Button_13, value = 0.1}) --Backup Radio 3rd Freq Up
--push_start_command(0.3, {device = devices.ARC_186, action = device_commands.Button_13, value = 0.1}) --Backup Radio 3rd Freq Up
--push_start_command(0.3, {device = devices.ARC_186, action = device_commands.Button_13, value = 0.1}) --Backup Radio 3rd Freq Up


--Power Switches
push_start_command(9.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_24, value = 1.0, message = _("PWR XFER ON"), message_timeout = std_message_timeout}) --10s Pause for APU to come online
push_start_command(0.2, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_26, value = 1.0}) --other power txfer switch
push_start_command(0.2, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_190, value = 1.0, message = _("FADEC B/U PWR ON"), message_timeout = std_message_timeout})

--MFD Centre to engine parameters
push_start_command(0.0, {device = devices.MFD_CENTER, action = device_commands.Button_6, value = 1.0}) --Centre MFD T6
push_start_command(0.1, {device = devices.MFD_CENTER, action = device_commands.Button_6, value = 0.0}) --Centre MFD T6 release

--MFD Pilot outboard, show WCA on lower half
push_start_command(0.0, {device = devices.MFD_PILOT_OUTBOARD, action = device_commands.Button_7, value = 1.0}) --Pilot Outboard MFD T7
push_start_command(0.1, {device = devices.MFD_PILOT_OUTBOARD, action = device_commands.Button_7, value = 0.0}) --Pilot Outboard MFD T7 release

--MFD Copilot inboard to flight plan summary
push_start_command(0.0, {device = devices.MFD_COPILOT_INBOARD, action = device_commands.Button_5, value = 1.0})--Copilot inboard MFD T5
push_start_command(0.1, {device = devices.MFD_COPILOT_INBOARD, action = device_commands.Button_5, value = 0.0}) -- Copilot inboard MFD T5 release
push_start_command(0.0, {device = devices.MFD_COPILOT_INBOARD, action = device_commands.Button_29, value = 1.0})--Copilot inboard MFD L6
push_start_command(0.1, {device = devices.MFD_COPILOT_INBOARD, action = device_commands.Button_29, value = 0.0}) --Copilot inboard MFD L6 release

--Engine Condition Levers to ground
	push_start_command(0.2, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_122, value = 1.0, message = _("ENG COND Levers to GROUND"), message_timeout = std_message_timeout})
	push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_116, value = 0.5})
	push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_123, value = 1.0,})
	push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_119, value = 0.5})

-- Engine 1 Start
push_start_command(5.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_195, value = -1.0, message = _("ENG START 1"), message_timeout = std_message_timeout})

--waiting for engine 1 spool up

-- CDU OPERATED POWER SWITCHES
--Power Page
push_start_command(0.0, {device = devices.CDU_LEFT, action = device_commands.Button_64, value = 1.0}) --Press IDX for Menu
push_start_command(0.2, {device = devices.CDU_LEFT, action = device_commands.Button_64, value = 0.0}) --release
push_start_command(0.5, {device = devices.CDU_LEFT, action = device_commands.Button_50, value = 1.0}) --Press L1 for power
push_start_command(0.2, {device = devices.CDU_LEFT, action = device_commands.Button_50, value = 0.0}) --release
--EGI 1+2 ON
push_start_command(0.5, {device = devices.CDU_LEFT, action = device_commands.Button_50, value = 1.0}) --Press L1 EGI1 Power
push_start_command(0.2, {device = devices.CDU_LEFT, action = device_commands.Button_50, value = 0.0}) --release
push_start_command(0.5, {device = devices.CDU_LEFT, action = device_commands.Button_50, value = 1.0}) --Press L1 EGI1 Power again (now on)
push_start_command(0.2, {device = devices.CDU_LEFT, action = device_commands.Button_50, value = 0.0}) --release
push_start_command(0.5, {device = devices.CDU_LEFT, action = device_commands.Button_56, value = 1.0}) --Press R1 EGI2 Power
push_start_command(0.2, {device = devices.CDU_LEFT, action = device_commands.Button_56, value = 0.0}) --release
push_start_command(0.5, {device = devices.CDU_LEFT, action = device_commands.Button_56, value = 1.0}) --Press R1 EGI2 Power again (now on)
push_start_command(0.2, {device = devices.CDU_LEFT, action = device_commands.Button_56, value = 0.0}) --release
--RWR ON
push_start_command(0.5, {device = devices.CDU_LEFT, action = device_commands.Button_52, value = 1.0}) --Press L3 for RWR power
push_start_command(0.2, {device = devices.CDU_LEFT, action = device_commands.Button_52, value = 0.0}) --release
--CMWS ON
push_start_command(0.5, {device = devices.CDU_LEFT, action = device_commands.Button_61, value = 1.0}) --Press R6 for CMWS power
push_start_command(0.2, {device = devices.CDU_LEFT, action = device_commands.Button_61, value = 0.0}) --release
--BACK TO MAIN PAGE
push_start_command(0.5, {device = devices.CDU_LEFT, action = device_commands.Button_64, value = 1.0}) --Press IDX for Menu
push_start_command(0.2, {device = devices.CDU_LEFT, action = device_commands.Button_64, value = 0.0, message = _("RWR ON"), message_timeout = std_message_timeout}) --release


--Engine 2 Start
push_start_command(4.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_195, value = 1.0, message = _("ENG START 2"), message_timeout = std_message_timeout})
push_start_command(10.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_195, value = 0.0}) --release


--DAFCS
push_start_command(2.0, {device = devices.CANTED_CONSOLE, action = device_commands.Button_37, value = 0.2, message = _("DAFCS SYSTEM Selector BOTH"), message_timeout = std_message_timeout})

--Pitot Heat
push_start_command(0.2, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_114, value = 1.0}) --Pitot Heat ON

--MFD Pilot outboard show HSD on lower half
push_start_command(0.0, {device = devices.MFD_PILOT_OUTBOARD, action = device_commands.Button_17, value = 1.0}) --Pilot Outboard B1
push_start_command(0.1, {device = devices.MFD_PILOT_OUTBOARD, action = device_commands.Button_17, value = 0.0}) --Pilot Outboard B1 release

--MFD Show NAV symbols and flight plan  on Lower HSD Pilot outboard
push_start_command(0.1, {device = devices.MFD_PILOT_OUTBOARD, action = device_commands.Button_20, value = 1.0}) --Pilot Outboard B4
push_start_command(0.1, {device = devices.MFD_PILOT_OUTBOARD, action = device_commands.Button_20, value = 0.0})
push_start_command(0.1, {device = devices.MFD_PILOT_OUTBOARD, action = device_commands.Button_29, value = 1.0}) --Pilot Outboard L6
push_start_command(0.1, {device = devices.MFD_PILOT_OUTBOARD, action = device_commands.Button_29, value = 0.0})
push_start_command(0.1, {device = devices.MFD_PILOT_OUTBOARD, action = device_commands.Button_25, value = 1.0}) --Pilot Outboard L2
push_start_command(0.1, {device = devices.MFD_PILOT_OUTBOARD, action = device_commands.Button_25, value = 0.0})
push_start_command(0.1, {device = devices.MFD_PILOT_OUTBOARD, action = device_commands.Button_20, value = 1.0}) --Pilot Outboard B4
push_start_command(0.1, {device = devices.MFD_PILOT_OUTBOARD, action = device_commands.Button_20, value = 0.0})
push_start_command(0.1, {device = devices.MFD_PILOT_OUTBOARD, action = device_commands.Button_20, value = 1.0}) --Pilot Outboard B4
push_start_command(0.1, {device = devices.MFD_PILOT_OUTBOARD, action = device_commands.Button_20, value = 0.0}) 

--MFD Show NAV symbols and flight plan on Lower HSD CoPilot outboard
push_start_command(0.1, {device = devices.MFD_COPILOT_OUTBOARD, action = device_commands.Button_20, value = 1.0}) --CoPilot Outboard B4
push_start_command(0.1, {device = devices.MFD_COPILOT_OUTBOARD, action = device_commands.Button_20, value = 0.0})
push_start_command(0.1, {device = devices.MFD_COPILOT_OUTBOARD, action = device_commands.Button_29, value = 1.0}) --CoPilot Outboard L6
push_start_command(0.1, {device = devices.MFD_COPILOT_OUTBOARD, action = device_commands.Button_29, value = 0.0})
push_start_command(0.1, {device = devices.MFD_COPILOT_OUTBOARD, action = device_commands.Button_25, value = 1.0}) --CoPilot Outboard L2
push_start_command(0.1, {device = devices.MFD_COPILOT_OUTBOARD, action = device_commands.Button_25, value = 0.0})
push_start_command(0.1, {device = devices.MFD_COPILOT_OUTBOARD, action = device_commands.Button_20, value = 1.0}) --CoPilot Outboard B4
push_start_command(0.1, {device = devices.MFD_COPILOT_OUTBOARD, action = device_commands.Button_20, value = 0.0})
push_start_command(0.1, {device = devices.MFD_COPILOT_OUTBOARD, action = device_commands.Button_20, value = 1.0}) --CoPilot Outboard B4
push_start_command(0.1, {device = devices.MFD_COPILOT_OUTBOARD, action = device_commands.Button_20, value = 0.0}) 

--Pilot inboard MFD to HSD, Map on, Nav sym on, FPLN on
push_start_command(0.1, {device = devices.MFD_PILOT_INBOARD, action = device_commands.Button_17, value = 1.0}) --Pilot INBOARD B1 HSD
push_start_command(0.1, {device = devices.MFD_PILOT_INBOARD, action = device_commands.Button_17, value = 0.0})
push_start_command(0.1, {device = devices.MFD_PILOT_INBOARD, action = device_commands.Button_20, value = 1.0}) --Pilot INBOARD B4 overlay
push_start_command(0.1, {device = devices.MFD_PILOT_INBOARD, action = device_commands.Button_20, value = 0.0})
push_start_command(0.1, {device = devices.MFD_PILOT_INBOARD, action = device_commands.Button_29, value = 1.0}) --Pilot INBOARD L6 nav sym
push_start_command(0.1, {device = devices.MFD_PILOT_INBOARD, action = device_commands.Button_29, value = 0.0})
push_start_command(0.1, {device = devices.MFD_PILOT_INBOARD, action = device_commands.Button_25, value = 1.0}) --Pilot INBOARD L2 fpln
push_start_command(0.1, {device = devices.MFD_PILOT_INBOARD, action = device_commands.Button_25, value = 0.0})
push_start_command(0.1, {device = devices.MFD_PILOT_INBOARD, action = device_commands.Button_20, value = 1.0}) --Pilot INBOARD B4 overlay 2
push_start_command(0.1, {device = devices.MFD_PILOT_INBOARD, action = device_commands.Button_20, value = 0.0})
push_start_command(0.1, {device = devices.MFD_PILOT_INBOARD, action = device_commands.Button_20, value = 1.0}) --Pilot INBOARD B4 overlay off
push_start_command(0.1, {device = devices.MFD_PILOT_INBOARD, action = device_commands.Button_20, value = 0.0})
push_start_command(0.5, {device = devices.MFD_PILOT_INBOARD, action = device_commands.Button_18, value = 1.0}) --Pilot INBOARD B2 Map on
push_start_command(0.1, {device = devices.MFD_PILOT_INBOARD, action = device_commands.Button_18, value = 0.0})

--Countermeasures
push_start_command(0.0, {device = devices.AN_ALE47, action = device_commands.Button_5, value = 1.0, message = _("Countermeasures ARMED"), message_timeout = std_message_timeout}) --Countermeasures ARM
push_start_command(0.0, {device = devices.AN_ALE47, action = device_commands.Button_7, value = 1.0}) --Selector to BYPASS


--Condition levers to flight
push_start_command(17.0,{device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_122, value = 1.0, message = _("ENG COND Levers to FLIGHT"), message_timeout = std_message_timeout})
push_start_command(0.1, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_116, value = 0.55}) --move power levers smoothly
push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_119, value = 0.55})
push_start_command(0.1, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_116, value = 0.60})
push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_119, value = 0.60})
push_start_command(0.1, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_116, value = 0.65})
push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_119, value = 0.65})
push_start_command(0.1, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_116, value = 0.70})
push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_119, value = 0.70})
push_start_command(0.1, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_116, value = 0.75})
push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_119, value = 0.75})
push_start_command(0.1, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_116, value = 0.80})
push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_119, value = 0.80})
push_start_command(0.1, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_116, value = 0.85})
push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_119, value = 0.85})
push_start_command(0.1, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_116, value = 0.90})
push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_119, value = 0.90})
push_start_command(0.1, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_116, value = 0.95})
push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_119, value = 0.95})
push_start_command(0.1, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_116, value = 1.00})
push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_119, value = 1.00})

-- Generators
push_start_command(2.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_171, value = 0.2, message = _("GEN 1 + 2 ON"), message_timeout = std_message_timeout}) --GEN 1
push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_174, value = 0.2}) --GEN 2

--APU OFF
push_start_command(6.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_177, value = 0.1,}) --APU GEN OFF
push_start_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_180, value = 0.3, message = _("APU OFF"), message_timeout = std_message_timeout})

--Power Xfer OFF
push_start_command(0.2, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_24, value = 0.0, message = _("PWR XFER OFF"), message_timeout = std_message_timeout})
push_start_command(0.2, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_26, value = 0.0}) --other power xfer switch off

--Caution Reset
push_start_command(1.0, {device = devices.GRIPS, action = device_commands.Button_26, value = 1.0, message = _("Master Caution Reset"), message_timeout = std_message_timeout})
push_start_command(0.3, {device = devices.GRIPS, action = device_commands.Button_26, value = 0.0,}) --release


push_start_command(2.0, {message = _("AUTOSTART COMPLETE"), message_timeout = std_message_timeout})






-------------------------------------------------------------------------------------------






push_stop_command(2.0, {message = _("AUTOSTOP SEQUENCE IS RUNNING"), message_timeout = std_message_timeout})

push_stop_command(2.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_180, value = 0.2, message = _("APU ON"), message_timeout = std_message_timeout})
push_stop_command(6.5, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_180, value = 0.1})
push_stop_command(3.5, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_180, value = 0.0})
push_stop_command(12.0,{device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_177, value = 0.2, message = _("GEN APU ON"), message_timeout = std_message_timeout})
push_stop_command(2.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_171, value = 0.1, message = _("GEN 1 + 2 OFF"), message_timeout = std_message_timeout})
push_stop_command(3.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_174, value = 0.1})

push_stop_command(2.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_24, value = 0.0, message = _("PWR XFER OFF"), message_timeout = std_message_timeout})
push_stop_command(0.3, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_26, value = 0.0})

push_stop_command(2.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_122, value = 1.0, message = _("ENG 1 COND Lever to STOP"), message_timeout = std_message_timeout})
push_stop_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_116, value = 0.0})
push_stop_command(2.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_123, value = 1.0, message = _("ENG 2 COND Lever to STOP"), message_timeout = std_message_timeout})
push_stop_command(0.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_119, value = 0.0})

push_stop_command(2.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_19, value = 0.0, message = _("Fuel XFEED OFF"), message_timeout = std_message_timeout})
push_stop_command(2.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_3, value = 0.0, message = _("ENG 1 MAIN Fuel Pumps OFF"), message_timeout = std_message_timeout})
push_stop_command(0.3, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_5, value = 0.0})
push_stop_command(2.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_11, value = 0.0, message = _("ENG 2 MAIN Fuel Pumps OFF"), message_timeout = std_message_timeout})
push_stop_command(0.3, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_13, value = 0.0})

push_stop_command(2.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_190, value = 0.0, message = _("FADEC B/U PWR OFF"), message_timeout = std_message_timeout})

push_stop_command(20.0,{device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_24, value = 0.0, message = _("PWR XFER OFF"), message_timeout = std_message_timeout})
push_stop_command(0.3, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_26, value = 0.0})

push_stop_command(2.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_177, value = 0.1, message = _("GEN APU OFF"), message_timeout = std_message_timeout})
push_stop_command(2.0, {device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_180, value = 0.3, message = _("APU OFF"), message_timeout = std_message_timeout})

push_stop_command(4.0,{device = devices.OVERHEAD_CONSOLE, action = device_commands.Button_178, value = 0.0, message = _("Battery OFF"), message_timeout = std_message_timeout})

push_stop_command(2.0, {message = _("AUTOSTOP COMPLETE"),message_timeout = std_message_timeout})



