local module = {} -- module init

module.random_image = true -- set to true if you want the script to randomly select an image
module.image_limit = 600 -- Increase if you have more than 600 images (may cause instability)

function module.info(message)
    log.write("BackgroundRotator", log.INFO, message)
end
function module.error(message)
    log.write("BackgroundRotator", log.INFO, message)
end
function module.file_exists(name)
    local f=io.open(name,"r")
    if f~=nil then io.close(f) return true else return false end
end
function module.round(x)
	return x>=0 and math.floor(x+0.5) or math.ceil(x-0.5)
end
function module.countTable(table)
    local num = 0
    for i,value in pairs(table) do
        num = num + 1
    end
    return num
end

module.info("Background Rotator Init")

module.dir = lfs.writedir() .. [[MissionEditor\themes\main\ME\]] -- Define working directory

for i=1,module.image_limit do -- Will loop x times or when it runs out of images
    if module.file_exists(module.dir .. [[background_]].. i ..[[.png]]) then -- If image is found
        module.backgroundImages = i
    elseif module.file_exists(module.dir .. [[base-menu-window.png]]) and not module.activeImage then -- If the current image is the active background
        module.activeImage = i
        module.backgroundImages = i
    else -- If no image is found
        break -- Stop the loop
    end
end

if module.backgroundImages and module.backgroundImages > 1 then -- If more than one background image has been found
    if module.file_exists(module.dir .. [[base-menu-window.png]]) then
        local activeImage = module.activeImage or 1
        os.execute(string.format('ren "%s" "%s"', module.dir..[[base-menu-window.png]], [[background_]].. activeImage ..[[.png]])) -- Deactivate / Rename current background image
    end

    if module.random_image then -- If the image has been set to be randomly selected
        module.info("Random image selection enabled")
        if not module.file_exists(module.dir ..[[sequence.lua]]) then
            module.info("Generating sequence.lua...")

            math.randomseed(os.clock()*100000000000)
            for _i=1,5 do
                math.random()
            end

            local sequence = {} -- randomly generate the numbers and list them
            for _i=1,module.backgroundImages do
                local rand

                for i=1,100 do -- check for and attempt to avoid duplicates
                    rand = module.round(math.random(module.backgroundImages))

                    local test
                    for _v,value in pairs(sequence) do
                        if value == rand then 
                            test = true 
                            break
                        end
                    end

                    if not test then break end
                end

                sequence[_i] = rand
            end

            local sequenceString = ""
            for _i,value in pairs(sequence) do -- Build string version of image sequence
                sequenceString = sequenceString .. "," .. tostring(value)
            end

            local file = io.open(module.dir ..[[sequence.lua]], "w+") -- Write sequence to file
            file:write("return {"..string.sub(sequenceString, 2).."}")
            file:close()

            module.activeImage = nil
        end

        if module.file_exists(module.dir ..[[sequence.lua]]) then -- Read sequence file 
            module.info("Reading sequence file...")
            module.sequence = dofile(module.dir ..[[sequence.lua]])
            if module.sequence then
                module.info("Sequence file read complete")
                if module.activeImage then
                    for i,value in pairs(module.sequence) do -- Find current position in sequence
                        if value == module.activeImage then 
                            module.activeImage = module.sequence[i + 1] -- Iterate sequence
                            module.info("Random Image Sequence: " .. i + 1 .. "/" .. tostring(module.countTable(module.sequence)))

                            if i == module.backgroundImages - 1 then
                                module.info("End of random sequence reached, new sequence file will be generated next start")
                                os.remove(module.dir ..[[sequence.lua]])
                            end
                            break
                        end
                    end
                else
                    module.activeImage = module.sequence[1]
                    module.info("Random Image Sequence: 1/" .. tostring(module.countTable(module.sequence)))
                end
            else
                module.error("There was an issue while reading sequence.lua (try deleting the file)")
            end
        else
            module.error("There was an issue while generating sequence.lua (try checking the permissions of the folder)")
        end
    else -- If the image will iterate instead of being randomly selected
        local activeImage = module.activeImage or 1
        if activeImage == module.backgroundImages then -- Prevent overflow
            module.activeImage = 1
        else
            module.activeImage = activeImage + 1
        end
    end

    module.info("Images found: " .. tostring(module.backgroundImages)) -- Debug log entry
    module.info("Active Image: " .. tostring(module.activeImage)) -- Debug log entry

    os.execute(string.format('ren "%s" "%s"', module.dir ..[[background_]].. module.activeImage ..[[.png]], [[base-menu-window.png]])) -- Activate / Rename new background image

    module.info("Background Successfully Rotated!")
else
    module.error("Not enough background images were found to run the script. Check the names of your images: [background_1.png, background_2.png etc.] (names are case sensitive!)")
end

module = nil -- sanatise module