-- View scripts
-- Copyright (C) 2004, Eagle Dynamics.

-- Don't change existing values, they are requested from ++!
-- Use these indices in Snap and CockpitLocalPoint tables.
dofile("Scripts/Database/wsTypes.lua")
PlaneIndex = {
iSu_27 = 1,
iSu_33 = 2,
iSu_25 = 3,
iSu_39 = 4,		-- Su-39 or Su-25T
iMiG_29 = 5,
iMiG_29K = 6,
iA_10 = 7,
iF_15 = 8,
iKA_50 = 9,
}
PlaneIndexByType =
{
	[MiG_29]  = PlaneIndex.iMiG_29,
	[Su_27]   = PlaneIndex.iSu_27,
	[Su_33]   = PlaneIndex.iSu_33,
	[F_15]    = PlaneIndex.iF_15,
	[Su_25]   = PlaneIndex.iSu_25,
	[A_10]    = PlaneIndex.iA_10,
	[MIG_29K] = PlaneIndex.iMiG_29K,
	[Su_39]   = PlaneIndex.iSu_39,
	[MiG_29G] = PlaneIndex.iMiG_29,
	[MiG_29C] = PlaneIndex.iMiG_29,
	[Su_25T]  = PlaneIndex.iSu_39,
	[KA_50]   = PlaneIndex.iKA_50,
}

function GetPlaneIndex(plane_type)
	if plane_type > 0 and 
	   plane_type < 10 then
	   return plane_type
	end
	return  1 --PlaneIndex[plane_type] or PlaneIndex.iSu_27
end

CockpitMouse = true
CockpitMouseSpeedSlow = 1.0
CockpitMouseSpeedNormal = 10.0
CockpitMouseSpeedFast = 20.0
CockpitKeyboardAccelerationSlow = 5.0
CockpitKeyboardAccelerationNormal = 30.0
CockpitKeyboardAccelerationFast = 80.0
CockpitKeyboardZoomAcceleration = 300.0
DisableSnapViewsSaving = false
UseDefaultSnapViews = true
CockpitPanStepHor = 45.0
CockpitPanStepVert = 30.0
CockpitNyMove = true

CockpitHAngleAccelerateTimeMax = 0.15
CockpitVAngleAccelerateTimeMax = 0.15
CockpitZoomAccelerateTimeMax = 0.2

function GetSnapView(iPlane, iKey)
	if UseDefaultSnapViews then
	      s = DefaultSnapView.Snap[GetPlaneIndex(iPlane)][iKey]
	else
		  s = 				  Snap[GetPlaneIndex(iPlane)][iKey]
	end
	return s.hAngle, 
		   s.vAngle,
		   s.viewAngle,
		   s.x_trans,
		   s.y_trans,
		   s.z_trans,
		   s.rollAngle
end

function SetSnapView(iPlane, iKey, hAngle, vAngle, viewAngle,x_trans,y_trans,z_trans,rollAngle)
	local s = nil
	if UseDefaultSnapViews then
	      s = DefaultSnapView.Snap[GetPlaneIndex(iPlane)][iKey]
	else
		  s = 				  Snap[GetPlaneIndex(iPlane)][iKey]
	end
	s.hAngle      = hAngle	
	s.vAngle      = vAngle	
	s.viewAngle   = viewAngle	
	s.x_trans     = x_trans
	s.y_trans     = y_trans
	s.z_trans     = z_trans
	s.rollAngle   = rollAngle
end

function WriteSnapViews(fileName)
	local file = io.open(fileName, "w")
	if file then
		io.output(file)
		local t = {}
	if UseDefaultSnapViews then
		Serialize("Snap", DefaultSnapView.Snap, t)
	else
		Serialize("Snap", Snap, t)
	end
		io.close(file)		
	end
end
-- Camera view angle limits {view angle min, view angle max}.
CameraViewAngleLimits = {}
CameraViewAngleLimits[PlaneIndex.iSu_27] = {20.0, 140.0}
CameraViewAngleLimits[PlaneIndex.iSu_33] = {20.0, 120.0}
CameraViewAngleLimits[PlaneIndex.iSu_25] = {20.0, 120.0}
CameraViewAngleLimits[PlaneIndex.iSu_39] = {20.0, 120.0}
CameraViewAngleLimits[PlaneIndex.iMiG_29] = {20.0, 120.0}
CameraViewAngleLimits[PlaneIndex.iMiG_29K] = {20.0, 120.0}
CameraViewAngleLimits[PlaneIndex.iA_10] = {20.0, 120.0}
CameraViewAngleLimits[PlaneIndex.iF_15] = {20.0, 140.0}
CameraViewAngleLimits[PlaneIndex.iKA_50] = {20.0, 120.0}

function GetCameraViewAngleLimits(iType)
	local p = CameraViewAngleLimits[iType]
	return p[1], p[2]
end

function SetCameraViewAngleLimits(iType, viewAngMin, viewAngMax)
	local p = CameraViewAngleLimits[iType]
	p[1] = viewAngMin
	p[2] = viewAngMax
end

CameraAngleRestriction = {}
CameraAngleRestriction[PlaneIndex.iSu_27] =  {1,60,0.4}
CameraAngleRestriction[PlaneIndex.iSu_33] =  {1,60,0.4}
CameraAngleRestriction[PlaneIndex.iSu_25] =  {1,60,0.4}
CameraAngleRestriction[PlaneIndex.iSu_39] =  {1,60,0.4}
CameraAngleRestriction[PlaneIndex.iMiG_29] = {1,60,0.4}
CameraAngleRestriction[PlaneIndex.iMiG_29K] ={1,60,0.4}
CameraAngleRestriction[PlaneIndex.iA_10]  =  {1,90,0.5}
CameraAngleRestriction[PlaneIndex.iF_15]  =  {1,60,0.4}
CameraAngleRestriction[PlaneIndex.iKA_50] =  {0,60,0.4}

function GetCameraAngleRestriction(iType)
	local p = CameraAngleRestriction[iType]
	return  p[1], p[2], p[3]
end 


-- HUD displacement for the HUD-only view (for cockpit builders).
-- Y-axis - up/down, Z-axis - left/right, in meters. X-axis (size) not implemented yet. 
HUDOnlyPoint = {}
HUDOnlyPoint[PlaneIndex.iSu_27] = {0.0, 0.0, 0.0}
HUDOnlyPoint[PlaneIndex.iSu_33] = {0.0, 0.0, 0.0}
HUDOnlyPoint[PlaneIndex.iSu_25] = {0.0, 0.0, 0.0}
HUDOnlyPoint[PlaneIndex.iSu_39] = {0.0, 0.0, 0.0}
HUDOnlyPoint[PlaneIndex.iMiG_29] = {0.0, 0.0, 0.0}
HUDOnlyPoint[PlaneIndex.iMiG_29K] = {0.0, 0.0, 0.0}
HUDOnlyPoint[PlaneIndex.iA_10] = {0.0, 0.0, 0.0}
HUDOnlyPoint[PlaneIndex.iF_15] = {0.0, 0.0, 0.0}
HUDOnlyPoint[PlaneIndex.iKA_50] = {0.0, 0.0, 0.0}

function GetHUDOnlyPoint(iType)
	local p = HUDOnlyPoint[iType]
	return p[1], p[2], p[3]
end

-- HUD RGB color 
HUDColor = {}
HUDColor[PlaneIndex.iSu_27] = {0, 255, 0}
HUDColor[PlaneIndex.iSu_33] = {0, 255, 0}
HUDColor[PlaneIndex.iSu_25] = {255, 255, 0}
HUDColor[PlaneIndex.iSu_39] = {0, 255, 0}
HUDColor[PlaneIndex.iMiG_29] = {0, 255, 0}
HUDColor[PlaneIndex.iMiG_29K] = {0, 255, 0}
HUDColor[PlaneIndex.iA_10] = {0, 255, 0}
HUDColor[PlaneIndex.iF_15] = {0, 255, 0}
HUDColor[PlaneIndex.iKA_50] = {0, 255, 0}

function GetHUDColor(iType)
	local p = HUDColor[iType]
	return p[1], p[2], p[3]
end

function NaturalHeadMoving(tang, roll, omz)
	local r = roll
	if r > 90.0 then
		r = 180.0 - r
	elseif roll < -90.0 then
		r = -180.0 - r
	end
	local hAngle = -0.25 * r
	local vAngle = math.min(math.max(0.0, 0.4 * tang + 45.0 * omz), 90.0)
	return hAngle, vAngle
end

ExternalMouse = true
ExternalMouseSpeedSlow = 1.0
ExternalMouseSpeedNormal = 5.0
ExternalMouseSpeedFast = 20.0
ExternalViewAngleMin = 3.0
ExternalViewAngleMax = 170.0
ExternalViewAngleDefault = 60.0
ExternalKeyboardZoomAcceleration = 30.0
ExternalKeyboardZoomAccelerateTimeMax = 1.0
ExplosionExpoTime = 4.0
ExternalKeyboardAccelerationSlow = 1.0
ExternalKeyboardAccelerationNormal = 10.0
ExternalKeyboardAccelerationFast = 30.0
ExternalHAngleAccelerateTimeMax = 3.0
ExternalVAngleAccelerateTimeMax = 3.0
ExternalDistAccelerateTimeMax = 3.0
ExternalHAngleLocalAccelerateTimeMax = 3.0
ExternalVAngleLocalAccelerateTimeMax = 3.0
ExternalAngleNormalDiscreteStep = 15.0/ExternalKeyboardAccelerationNormal -- When 'S' is pressed only
ChaseCameraNyMove = true
FreeCameraAngleIncrement = 3.0
FreeCameraDistanceIncrement = 200.0
FreeCameraLeftRightIncrement = 2.0
FreeCameraAltitudeIncrement = 2.0
FreeCameraScalarSpeedAcceleration = 0.1 
xMinMap = -300000
xMaxMap = 500000
yMinMap = -400000
yMaxMap = 200000
dxMap = 150000
dyMap = 100000

head_roll_shaking = false
head_roll_shaking_max = 45.0
head_roll_shaking_compensation_gain = 0.5

-- CameraJiggle() and CameraFloat() functions make camera position
-- dependent on FPS so be careful in using the Shift-J command with tracks, please.
function CameraJiggle(t)
	local rotX, rotY, rotZ
	rotX = 0.05 * math.random() * math.sin(37.0 * (t - 0.0))
	rotY = 0.05 * math.random() * math.sin(41.0 * (t - 1.0))
	rotZ = 0.05 * math.random() * math.sin(53.0 * (t - 2.0))
	return rotX, rotY, rotZ
end

function CameraFloat(t)
	local dX, dY, dZ
	dX = 0.61 * math.sin(0.7 * t) + 0.047 * math.sin(1.6 * t);
	dY = 0.43 * math.sin(0.6 * t) + 0.067 * math.sin(1.7 * t);
	dZ = 0.53 * math.sin(1.0 * t) + 0.083 * math.sin(1.9 * t);
	return dX, dY, dZ
end



