-----------------------------------------------------------------------------------------
declare_loadout	(
					{
						category			=	CAT_PODS,
						CLSID				=	"{SU-25SM3-L-370_L}",
						Picture				=	"L-370_Left.png",
						displayName			=	_("L-370 (Left)"),
						Weight				=	70,
						Cx_pil				=	0.000244140625,
						attribute			=	{
													wsType_Weapon,
													wsType_GContainer,
													wsType_Jam_Cont,
													WSTYPE_PLACEHOLDER
												},
						shape_table_data	=	{
													{
														name		=	"L-370_Left",
														file		=	"L-370_Left",
														life		=	1,
														fire		=	{0, 1},
														username	=	"L-370_Left",
														index		=	WSTYPE_PLACEHOLDER
													}
												},
						Elements			=	{
													[1]	=	{
																Position	=	{0,	0,	0},
																ShapeName	=	"L-370_Left.edm"
															}
												},
						Required			=	{
													"{SU-25SM3-L-370_R}"
												}
					}
				)
-----------------------------------------------------------------------------------------
declare_loadout	(
					{
						category			=	CAT_PODS,
						CLSID				=	"{SU-25SM3-L-370_R}",
						Picture				=	"L-370_Right.png",
						displayName			=	_("L-370 (Right)"),
						Weight				=	70,
						Cx_pil				=	0.000244140625,
						attribute			=	{
													wsType_Weapon,
													wsType_GContainer,
													wsType_Jam_Cont,
													WSTYPE_PLACEHOLDER
												},
						shape_table_data	=	{
													{
														name		=	"L-370_Right",
														file		=	"L-370_Right",
														life		=	1,
														fire		=	{0, 1},
														username	=	"L-370_Right",
														index		=	WSTYPE_PLACEHOLDER
													}
												},
						Elements			=	{
													[1]	=	{
																Position	=	{0,	0,	0},
																ShapeName	=	"L-370_Right.edm"
															}
												},
						Required			=	{
													"{SU-25SM3-L-370_L}"
												}
					}
				)
-----------------------------------------------------------------------------------------
declare_loadout	(
					{
						category			=	CAT_FUEL_TANKS,
						CLSID				=	"{SU-25SM3-PTB-800}",
						attribute			=  {wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
						Picture				=	"PTB_Sm3.png",
						displayName			=	_("PTB-800"),
						Weight_Empty		=	50,	
						Weight				=	850,	
						Capacity			=	800,
						Cx_pil				=	0.007,
						shape_table_data	=	{
													{
														name		=	"PTB-800";
														file		=	"Su-25sm3_PTB-800.edm";
														life		=	1;
														fire		=	{0, 1};
														username	=	"SU-25SM3-PTB-800";
														index		=	WSTYPE_PLACEHOLDER;
													},
												},
						Elements			=	{
													{
														ShapeName	=	"Su-25sm3_PTB-800.edm",
													},
												},
					}
				)
-----------------------------------------------------------------------------------------
declare_loadout	(
					{
						category			=	CAT_FUEL_TANKS,
						CLSID				=	"{SU-25SM3-PTB-800-EMPTY}",
						attribute			=	{wsType_Air,wsType_Free_Fall,wsType_FuelTank,WSTYPE_PLACEHOLDER},
						Picture				=	"PTB_Sm3.png",
						displayName			=	_("PTB-800 EMPTY"),
						Weight_Empty		=	50,	
						Weight				=	50,	
						Capacity			=	0,
						Cx_pil				=	0.007,
						shape_table_data	=	{
													{
														name		=	"PTB-800";
														file		=	"Su-25sm3_PTB-800.edm";
														life		=	1;
														fire		=	{0, 1};
														username	=	"SU-25SM3-PTB-800";
														index		=	WSTYPE_PLACEHOLDER;
													},
												},
						Elements			=	{
													{
														ShapeName	=	"Su-25sm3_PTB-800.edm",
													},
												},
					}
				)
-----------------------------------------------------------------------------------------
function	create_chaff_flare_dispenser (count_chaff_flare)
    local	chaff_flare_dispenser = {}
    for i = 1, count_chaff_flare do
        local base_index = (i - 1) * 3 + 1  
        chaff_flare_dispenser[base_index]	  = {
													dir = {0, 1, -0.22},
													pos = {-3.776, 1.0, -0.42},
												}
        chaff_flare_dispenser[base_index + 1] =	{
													dir = {0, 1, 0.22},
													pos = {-3.776, 1.0, 0.422},
												}
        chaff_flare_dispenser[base_index + 2] = {
													dir = {0, -1, 0},
													pos = {-3.776, 1.0, 0.422},
												}
    end
    return	chaff_flare_dispenser
end
-----------------------------------------------------------------------------------------
Su_25SM3	=	{
					Name 					=	'Su-25SM3',
					DisplayName				=	_('Su-25SM3'),
					Picture 				=	"Su-25SM3.png",
					Rate 					=	40,
-----------------------------------------------------------------------------------------
					Countries 				=	{
													"Russia",
												},
					country_of_origin		=	"RUS",
					date_of_introduction	=	2016.1,
-----------------------------------------------------------------------------------------
					Shape					=	"su-25sm3",
					shape_table_data		= 	{
													{
														file		=	'su-25sm3';
														life		=	30;	-- lifebar
														vis			=	3;	-- visibility gain.
														desrt		=	'su-25-oblomok';	-- Name of destroyed object file name
														fire		=	{ 300, 2};	-- Fire on the ground after destoyed: 300sec 2m
														username	=	'Su-25sm3';
														index		=	su_25sm3;	--WSTYPE_PLACEHOLDER;	
														classname	=	'lLandPlane',
														positioning	=	'BYNORMAL',
													},
													{
														name		=	"su-25-oblomok";
														file		=	"su-25-oblomok";
														fire		=	{ 240, 2};
													},
												},
-----------------------------------------------------------------------------------------
					mapclasskey				=	"P0091000025",
					attribute				=	{
													wsType_Air,
													wsType_Airplane,
													wsType_Battleplane,
													WSTYPE_PLACEHOLDER,
													"Battleplanes",
												},
					Categories				=	{
													"{C168A850-3C0B-436a-95B5-C4A015552560}",
													"Battleplane",
												},
					Tasks					=	{
													aircraft_task	(GroundAttack),
													aircraft_task	(CAS),
													aircraft_task	(AFAC),
													aircraft_task	(RunwayAttack),
													aircraft_task	(SEAD),
													aircraft_task	(PinpointStrike),
													aircraft_task	(AntishipStrike),
													aircraft_task	(Escort),
													aircraft_task	(Reconnaissance),
												},	
					DefaultTask				=	aircraft_task	(GroundAttack),
-----------------------------------------------------------------------------------------
	input_profile_entry			=	"Su-25SM3",
	WorldID						=	Su_25,
-----------------------------------------------------------------------------------------
	M_empty 					= 9315, -- kg
	wing_area 					= 30.1, -- wing area in m2
	M_nominal 					= 14600, -- kg
	M_fuel_max 					= 3000, -- kg --3500 л
	H_max 					 	= 7000, -- m
	M_max 						= 17600, -- kg
	average_fuel_consumption 	= 0.89, -- this is highly relative, but good estimates are 36-40l/min = 28-31kg/min = 0.47-0.52kg/s -- 45l/min = 35kg/min = 0.583kg/s
	has_afteburner 				= false, -- AFB yes/no
	has_speedbrake 				= true, -- Speedbrake yes/no
	wing_span 					= 9.7, -- wing spain in m
	wing_type 					= 0,
	thrust_sum_max 				= 4300, -- thrust in kg (44kN)
	thrust_sum_ab 				= 4500, -- thrust inkg (71kN)
	length 						= 14.59, -- full lenght in m
	height 						= 4.8, -- height in m
	RCS 						= 5, -- Radar Cross Section m2
	IR_emission_coeff 			= 0.34, -- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
	IR_emission_coeff_ab 		= 0.64, -- With afterburner
	wing_tip_pos 				= {-1.39302, 0.033959, -7.22018}, -- wingtip coords for visual effects
	brakeshute_name 			= 3, -- Landing - brake chute visual shape after separation
-----------------------------------------------------------------------------------------
	-- for AI
	CAS_min 					= 50, -- if this is not OVERAL FLIGHT TIME, but jus LOITER TIME, than it sholud be 10-15 minutes.....CAS capability in minute (for AI)
	V_opt 						= 208,-- Cruise speed (for AI)
	V_take_off 					= 69, -- Take off speed in m/s (for AI)
	V_land 						= 58, -- Land speed in m/s (for AI)
	V_max_sea_level 			= 263, -- Max speed at sea level in m/s (for AI)
	V_max_h 					= 282, -- Max speed at max altitude in m/s (for AI)
	Vy_max 						= 60, -- Max climb speed in m/s (for AI)
	Mach_max 					= 0.95, -- Max speed in Mach (for AI)
	Ny_min 						= -4, -- Min G (for AI)
	Ny_max 						= 6.5,  -- Max G (for AI)
	Ny_max_e 					= 7.0,  -- Max G (for AI)
	AOA_take_off 				= 0.12, -- AoA in take off (for AI)
	bank_angle_max 				= 85, -- Max bank angle (for AI)
	flaps_maneuver 				= 1.0, -- Max flaps in take-off and maneuver (0.5 = 1st stage; 1.0 = 2nd stage) (for AI)
	range 						= 2650, -- Max range in km (for AI)	
-----------------------------------------------------------------------------------------
	tand_gear_max 								=	0.3,	--Угол поворота носового колеса
	nose_gear_pos 								=	{2.6691, -2.1900, -0.04}, -- используется для первоначального размещения ЛА
	nose_gear_amortizer_direct_stroke			= 	0.11,	-- на сколько увеличить до самого нижнего положения
	nose_gear_amortizer_reversal_stroke			= 	-0.19,	-- сколько отнять до полного сжатия стойки 
	nose_gear_amortizer_normal_weight_stroke	= 	-0.05,	--хз, вероятно жесткость стойки (пружины/рессоры)	
	nose_gear_wheel_diameter					=	0.628, --диаметр носового колеса
	nose_gear_door_close_after_retract			=	false,
	main_gear_pos								=	{-0.7954, -2.0000, 1.2603},
	main_gear_amortizer_direct_stroke			=	0.1,
	main_gear_amortizer_reversal_stroke			= 	-0.2,
	main_gear_amortizer_normal_weight_stroke	= 	-0.05,
	main_gear_wheel_diameter					=	0.814,
	main_gear_door_close_after_retract			=	false,
-----------------------------------------------------------------------------------------
--[[	
			effects_presets		=	{
										{
											effect	=	"OVERWING_VAPOR",
											file	=	current_mod_path ..	"/Effects/Su-25SM3_overwingVapor.lua"
										},
									},
--]]
-----------------------------------------------------------------------------------------
			engines_count		=	2, -- Engines count
			engines_nozzles		=	{
										[1] =	{
													pos					=	{-3.33752,	-0.147934,	-0.712287}, -- nozzle coords
													elevation			=	0, -- AFB cone elevation
													diameter			=	1.29, -- AFB cone diameter
													exhaust_length_ab	=	7, -- lenght in m
													exhaust_length_ab_K	=	0.76, -- AB animation
													smokiness_level		=	0.4,
												},
										[2] =	{
													pos					=	{-3.33752,	-0.147934,	0.712295}, -- nozzle coords
													elevation			=	0, -- AFB cone elevation
													diameter			=	1.29, -- AFB cone diameter
													exhaust_length_ab	=	7, -- lenght in m
													exhaust_length_ab_K	=	0.76, -- AB animation
													smokiness_level		=	0.4,
												},
									},
-----------------------------------------------------------------------------------------								
			crew_size		=	1,
			crew_members	=	{
									[1] =	{
												ejection_seat_name = "pilot+ejectionseat",
												drop_canopy_name = 12,
												pos =  {4,	1,	0},
												canopy_pos = {4,	1,	0},
											}, -- end of [1]
								}, -- end of crew_members
			CanopyGeometry	=	makeAirplaneCanopyGeometry	(LOOK_AVERAGE,	LOOK_AVERAGE,	LOOK_AVERAGE),
-----------------------------------------------------------------------------------------	
fires_pos = 
		{
			[1] = 	{-2.117,	-0.9,	0},
			[2] = 	{-1.584,	0.176,	2.693},
			[3] = 	{-1.645,	0.213,	-2.182},
			[4] = 	{-0.82,	0.265,	2.774},
			[5] = 	{-0.82,	0.265,	-2.774},
			[6] = 	{-0.82,	0.255,	4.274},
			[7] = 	{-0.82,	0.255,	-4.274},
			[8] = 	{-6.548,	-0.248,	0},
			[9] = 	{-6.548,	-0.248,	0},
			[10] = 	{0.304,	-0.748,	0.442},
			[11] = 	{0.304,	-0.748,	-0.442},
		}, -- end of fires_pos
	
	Countermeasures = {
        --ECM = "AN/ALQ-165"
	},
	-- Countermeasures
	--[[chaff_flare_dispenser 	= {
		-- althought the index here starts from 1. When calling drop_flares or drop_chaff, the index begins from 0
		-- { dir =  {Z, Y, X}, pos =  {Z, Y, X}, }  -- Z=back/fwd,Y=down/up(+),X=left/right
		[1] = { dir =  {0, -0.7, 0.3}, pos =  {11.0, -3.80, 1.0225}, }, -- FWD_Left_Dispenser1
		[2] = { dir =  {0, -0.7, 0.3}, pos =  {11.01, -3.81, 1.0225}, }, -- FWD_Left_Dispenser2
		
		[3] = { dir =  {0, -0.7, -0.3}, pos =  {11.0, -3.80, -1.0225}, }, -- FWD_Right_Dispenser1
		[4] = { dir =  {0, -0.7, -0.3}, pos =  {11.01, -3.81, -1.0225}, }, -- FWD_Right_Dispenser2
		
		[5] = { dir =  {0, 0, 1}, pos =  {-1.01, -1.45, 2.2254}, }, -- MID_Left_Dispenser1
		[6] = { dir =  {0, 0, 1}, pos =  {-1.02, -1.46, 2.2254}, }, -- MID_Left_Dispenser2
		[7] = { dir =  {0, 0, 1}, pos =  {-1.03, -1.47, 2.2254}, }, -- MID_Left_Dispenser3
		[8] = { dir =  {0, 0, 1}, pos =  {-1.04, -1.48, 2.2254}, }, -- MID_Left_Dispenser4
		
		[9] = { dir =  {0, 0, -1}, pos =  {-1.01, -1.45, -2.2254}, }, -- MID_Right_Dispenser1
		[10] = { dir =  {0, 0, -1}, pos =  {-1.02, -1.46, -2.2254}, }, -- MID_Right_Dispenser2
		[11] = { dir =  {0, 0, -1}, pos =  {-1.03, -1.47, -2.2254}, }, -- MID_Right_Dispenser3
		[12] = { dir =  {0, 0, -1}, pos =  {-1.04, -1.48, -2.2254}, }, -- MID_Right_Dispenser4
		
		[13] = { dir =  {-0.1, -0.9, 0}, pos =  {-15.85, -0.66, 0}, }, -- TAIL_Dispenser1
		[14] = { dir =  {-0.1, -0.9, 0}, pos =  {-15.86, -0.67, 0}, }, -- TAIL_Dispenser2
	},
--]]
	
	



chaff_flare_dispenser = create_chaff_flare_dispenser(20),
	-- Countermeasures
	passivCounterm = {
		CMDS_Edit = true,
		SingleChargeTotal = 512,
		-- PPR-26
		chaff = {default = 256, increment = 15, chargeSz = 1},
		-- PPI-26
		flare = {default = 256, increment = 15, chargeSz = 1}
	},

	--sensors
	
	detection_range_max		 = 200,
	radar_can_see_ground 	 = false, -- this should be examined (what is this exactly?)
	CanopyGeometry = {
		azimuth   = {-160.0, 160.0}, -- pilot view horizontal (AI)
		elevation = {-50.0, 90.0} -- pilot view vertical (AI)
	},
-----------------------------------------------------------------------------------------
	Sensors	=	{
					RWR	=	"Abstract RWR",
				},
-----------------------------------------------------------------------------------------
	HumanRadio = {
		frequency = 127.5,  -- Radio Freq
		editable = true,
		minFrequency = 100.000,
		maxFrequency = 156.000,
		modulation = MODULATION_AM
	},
----------------------------------------------------------------------------------------------	
	mech_timing = {{0.0, 0.074; 0.11, 0.14}, -- CANOPY_OPEN_TIMES
                   {0.0, 0.18; 0.89, 0.074}, -- CANOPY_CLOSE_TIMES
                  },
-----------------------------------------------------------------------------------------------
	Guns	=	{
					gun_mount	(	"GSh_30_2",
									{count					=	250},
									{muzzle_pos_connector	=	"GUN_POINT"}
								)
				},
-----------------------------------------------------------------------------------------------
	Pylons	=	{
					pylon	(
								1,	0,	-1.36387,	0.108204,	-5.08553,
								{
									arg							=	308,
									arg_value					=	0,
									connector					=	"Pylon1",
									use_full_connector_position	=	false,
								},
								{
									{ CLSID	= "{SU-25SM3-L-370_L}", arg_value = 1,},
								}
							),
					pylon	(
								2,	0,	-0.747209,	-0.240513,	-4.33532,
								{
									arg							=	309,
									arg_value					=	0,
									connector					=	"Pylon2",
									use_full_connector_position	=	true,
									FiY							=	0,
									FiZ							=	-3,
									FiX							=	0,
								},
								{
								--Бомбы
									{ CLSID = "{BETAB-500M}", arg_value = 0.3,},							--BETAB-500M
									{ CLSID = "{BETAB-500S}", arg_value = 0.3,},							--BETAB-500S
									{ CLSID = "{FAB-250-M54-TU}", arg_value = 0.3,},						--FAB-250-ТУ
									{ CLSID = "{P-50T}", arg_value = 0.3,},									--P-50T
									{ CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}", arg_value = 0.3,},	--RBK-250 PTAB-2.5M
									{ CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}", arg_value = 0.3,},	--RBK-500 SPBE-D PTAB-1M
									{ CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", arg_value = 0.3,},	--RBK-500 PTAB-10-5
									{ CLSID = "{RBK_250_275_AO_1SCH}"},										--RBK-250-275 AO-1SCH
									{ CLSID = "{RBK_500U_OAB_2_5RT}"},										--RBK-500U OAB-2.5RT
									{ CLSID = "{FAB-100-4}", arg_value = 0.3,},								--FAB-100-MBD-2-67U
									{ CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}", arg_value = 0.3,},	--FAB-250
									{ CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}", arg_value = 0.3,},	--FAB-500 M62
									{ CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}"},					--FAB-100
									{ CLSID = "{0511E528-EA28-4caf-A212-00D1408DF10A}"},					--SAB-100
									{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}",arg_value = 0.5,},	--KMGU-2 - 96 AO-2.5RT
									{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}",arg_value = 0.5,},	--KMGU-2 - 96 PTAB-2.5KO
								--Нары
									{ CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}", arg_value = 0.3,},	--B-8M1 - 20 S-8KOM
									{ CLSID = "B-8M1 - 20 S-8OFP2", arg_value = 0.3,},						--B-8M1 - 20 S-8OFP2
									{ CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}", arg_value = 0.3,},	--B-8M1 - 20 S-8TsM
									{ CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}", arg_value = 0.5,},	--S-24B
									{ CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}", arg_value = 0.3,},	--B-13L - 5 S-13 OF
									{ CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}", arg_value = 0.3,},	--S-25OFM
									{ CLSID = "{S_25_O}", arg_value = 0.3,},								--S-25О
								--В-В
									{ CLSID = "{CBC29BFE-3D24-4C64-B81D-941239D12249}", arg_value = 0.5,},	--R-73
								--В-З
									{ CLSID = "{0180F983-C14A-11d8-9897-000476191836}", arg_value = 0.3,},	--S-25L
								}
							),
					pylon	(
								3,	0,	-0.51899,	-0.209927,	-3.55413,
								{
									arg							=	310,
									arg_value					=	0,
									connector					=	"Pylon3",
									use_full_connector_position	=	true,
									FiY							=	0,
									FiZ							=	-3,
									FiX							=	0,
								},
								{
								--Бомбы
									{ CLSID = "{BETAB-500M}", arg_value = 0.3,},							--BETAB-500M
									{ CLSID = "{BETAB-500S}", arg_value = 0.3,},							--BETAB-500S
									{ CLSID = "{FAB-250-M54-TU}", arg_value = 0.3,},						--FAB-250-ТУ
									{ CLSID = "{P-50T}", arg_value = 0.3,},									--P-50T
									{ CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}", arg_value = 0.3,},	--RBK-250 PTAB-2.5M
									{ CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}", arg_value = 0.3,},	--RBK-500 SPBE-D PTAB-1M
									{ CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", arg_value = 0.3,},	--RBK-500 PTAB-10-5
									{ CLSID = "{RBK_250_275_AO_1SCH}"},										--RBK-250-275 AO-1SCH
									{ CLSID = "{RBK_500U_OAB_2_5RT}"},										--RBK-500U OAB-2.5RT
									{ CLSID = "{FAB-100-4}", arg_value = 0.3,},								--FAB-100-MBD-2-67U
									{ CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}", arg_value = 0.3,},	--FAB-250
									{ CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}", arg_value = 0.3,},	--FAB-500 M62
									{ CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}"},					--FAB-100
									{ CLSID = "{0511E528-EA28-4caf-A212-00D1408DF10A}"},					--SAB-100
									{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}",arg_value = 0.5,},	--KMGU-2 - 96 AO-2.5RT
									{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}",arg_value = 0.5,},	--KMGU-2 - 96 PTAB-2.5KO
								--Нары
									{ CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}", arg_value = 0.3,},	--B-8M1 - 20 S-8KOM
									{ CLSID = "B-8M1 - 20 S-8OFP2", arg_value = 0.3,},						--B-8M1 - 20 S-8OFP2
									{ CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}", arg_value = 0.3,},	--B-8M1 - 20 S-8TsM
									{ CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}", arg_value = 0.5,},	--S-24B
									{ CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}", arg_value = 0.3,},	--B-13L - 5 S-13 OF
									{ CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}", arg_value = 0.3,},	--S-25OFM
									{ CLSID = "{S_25_O}", arg_value = 0.3,},								--S-25О
								--В-З
									{ CLSID = "{0180F983-C14A-11d8-9897-000476191836}", arg_value = 0.3,},	--S-25L
									{ CLSID = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}", arg_value = 0.3,},	--Kh-25Ml
								--Баки
									{ CLSID = "{SU-25SM3-PTB-800}", arg_value = 0.3,},						--PTB-800
									{ CLSID = "{SU-25SM3-PTB-800-EMPTY}", arg_value = 0.3,},				--PTB-800-EMPTY
								}
							),
					pylon	(
								4,	0,	-0.315826,	-0.184911,	-2.77714,
								{
									arg							=	311,
									arg_value					=	0,
									connector					=	"Pylon4",
									use_full_connector_position	=	true,
									FiY							=	0,
									FiZ							=	-3,
									FiX							=	0,
								},
								{
								--Бомбы
									{ CLSID = "{BETAB-500M}", arg_value = 0.3,},							--BETAB-500M
									{ CLSID = "{BETAB-500S}", arg_value = 0.3,},							--BETAB-500S
									{ CLSID = "{FAB-250-M54-TU}", arg_value = 0.3,},						--FAB-250-ТУ
									{ CLSID = "{P-50T}", arg_value = 0.3,},									--P-50T
									{ CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}", arg_value = 0.3,},	--RBK-250 PTAB-2.5M
									{ CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}", arg_value = 0.3,},	--RBK-500 SPBE-D PTAB-1M
									{ CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", arg_value = 0.3,},	--RBK-500 PTAB-10-5
									{ CLSID = "{RBK_250_275_AO_1SCH}"},										--RBK-250-275 AO-1SCH
									{ CLSID = "{RBK_500U_OAB_2_5RT}"},										--RBK-500U OAB-2.5RT
									{ CLSID = "{FAB-100-4}", arg_value = 0.3,},								--FAB-100-MBD-2-67U
									{ CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}", arg_value = 0.3,},	--FAB-250
									{ CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}", arg_value = 0.3,},	--FAB-500 M62
									{ CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}"},					--FAB-100
									{ CLSID = "{0511E528-EA28-4caf-A212-00D1408DF10A}"},					--SAB-100
									{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}",arg_value = 0.5,},	--KMGU-2 - 96 AO-2.5RT
									{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}",arg_value = 0.5,},	--KMGU-2 - 96 PTAB-2.5KO
									{ CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}", arg_value = 0.3,},	--KAB-500Kr
								--Нары
									{ CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}", arg_value = 0.3,},	--B-8M1 - 20 S-8KOM
									{ CLSID = "B-8M1 - 20 S-8OFP2", arg_value = 0.3,},						--B-8M1 - 20 S-8OFP2
									{ CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}", arg_value = 0.3,},	--B-8M1 - 20 S-8TsM
									{ CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}", arg_value = 0.5,},	--S-24B
									{ CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}", arg_value = 0.3,},	--B-13L - 5 S-13 OF
									{ CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}", arg_value = 0.3,},	--S-25OFM
									{ CLSID = "{S_25_O}", arg_value = 0.3,},								--S-25О
								--В-З
									{ CLSID = "{0180F983-C14A-11d8-9897-000476191836}", arg_value = 0.3,},	--S-25L
									{ CLSID = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}", arg_value = 0.3,},	--Kh-25Ml
									{ CLSID = "{D4A8D9B9-5C45-42e7-BBD2-0E54F8308432}", arg_value = 0.3,},	--Kh-29L
									{ CLSID = "{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}", arg_value = 0.3,},	--Lh-29T
								}
							),
					pylon	(
								5,	0,	-0.108813,	-0.156577,	-2.01286,
								{
									arg							=	312,
									arg_value					=	0,
									connector					=	"Pylon5",
									use_full_connector_position	=	true,
									FiY							=	0,
									FiZ							=	-3,
									FiX							=	0,
								},
								{
								--Бомбы
									{ CLSID = "{BETAB-500M}", arg_value = 0.3,},							--BETAB-500M
									{ CLSID = "{BETAB-500S}", arg_value = 0.3,},							--BETAB-500S
									{ CLSID = "{FAB-250-M54-TU}", arg_value = 0.3,},						--FAB-250-ТУ
									{ CLSID = "{P-50T}", arg_value = 0.3,},									--P-50T
									{ CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}", arg_value = 0.3,},	--RBK-250 PTAB-2.5M
									{ CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}", arg_value = 0.3,},	--RBK-500 SPBE-D PTAB-1M
									{ CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", arg_value = 0.3,},	--RBK-500 PTAB-10-5
									{ CLSID = "{RBK_250_275_AO_1SCH}"},										--RBK-250-275 AO-1SCH
									{ CLSID = "{RBK_500U_OAB_2_5RT}"},										--RBK-500U OAB-2.5RT
									{ CLSID = "{FAB-100-4}", arg_value = 0.3,},								--FAB-100-MBD-2-67U
									{ CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}", arg_value = 0.3,},	--FAB-250
									{ CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}", arg_value = 0.3,},	--FAB-500 M62
									{ CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}"},					--FAB-100
									{ CLSID = "{0511E528-EA28-4caf-A212-00D1408DF10A}"},					--SAB-100
									{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}",arg_value = 0.5,},	--KMGU-2 - 96 AO-2.5RT
									{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}",arg_value = 0.5,},	--KMGU-2 - 96 PTAB-2.5KO
									{ CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}", arg_value = 0.3,},	--KAB-500Kr
								--Нары
									{ CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}", arg_value = 0.3,},	--B-8M1 - 20 S-8KOM
									{ CLSID = "B-8M1 - 20 S-8OFP2", arg_value = 0.3,},						--B-8M1 - 20 S-8OFP2
									{ CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}", arg_value = 0.3,},	--B-8M1 - 20 S-8TsM
									{ CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}", arg_value = 0.5,},	--S-24B
									{ CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}", arg_value = 0.3,},	--B-13L - 5 S-13 OF
									{ CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}", arg_value = 0.3,},	--S-25OFM
									{ CLSID = "{S_25_O}", arg_value = 0.3,},								--S-25О
								--В-З
									{ CLSID = "{0180F983-C14A-11d8-9897-000476191836}", arg_value = 0.3,},	--S-25L
									{ CLSID = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}", arg_value = 0.3,},	--Kh-25Ml
									{ CLSID = "{D4A8D9B9-5C45-42e7-BBD2-0E54F8308432}", arg_value = 0.3,},	--Kh-29L
									{ CLSID = "{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}", arg_value = 0.3,},	--Lh-29T
								--Баки
									{ CLSID = "{SU-25SM3-PTB-800}", arg_value = 0.3,},						--PTB-800
									{ CLSID = "{SU-25SM3-PTB-800-EMPTY}", arg_value = 0.3,},				--PTB-800-EMPTY
								}
							),
					pylon	(
								6,	0,	-0.108813,	-0.156577,	2.01286,
								{
									arg							=	314,
									arg_value					=	0,
									connector					=	"Pylon6",
									use_full_connector_position	=	true,
									FiY							=	0,
									FiZ							=	-3,
									FiX							=	0,
								},
								{
								--Бомбы
									{ CLSID = "{BETAB-500M}", arg_value = 0.3,},							--BETAB-500M
									{ CLSID = "{BETAB-500S}", arg_value = 0.3,},							--BETAB-500S
									{ CLSID = "{FAB-250-M54-TU}", arg_value = 0.3,},						--FAB-250-ТУ
									{ CLSID = "{P-50T}", arg_value = 0.3,},									--P-50T
									{ CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}", arg_value = 0.3,},	--RBK-250 PTAB-2.5M
									{ CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}", arg_value = 0.3,},	--RBK-500 SPBE-D PTAB-1M
									{ CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", arg_value = 0.3,},	--RBK-500 PTAB-10-5
									{ CLSID = "{RBK_250_275_AO_1SCH}"},										--RBK-250-275 AO-1SCH
									{ CLSID = "{RBK_500U_OAB_2_5RT}"},										--RBK-500U OAB-2.5RT
									{ CLSID = "{FAB-100-4}", arg_value = 0.3,},								--FAB-100-MBD-2-67U
									{ CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}", arg_value = 0.3,},	--FAB-250
									{ CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}", arg_value = 0.3,},	--FAB-500 M62
									{ CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}"},					--FAB-100
									{ CLSID = "{0511E528-EA28-4caf-A212-00D1408DF10A}"},					--SAB-100
									{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}",arg_value = 0.5,},	--KMGU-2 - 96 AO-2.5RT
									{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}",arg_value = 0.5,},	--KMGU-2 - 96 PTAB-2.5KO
									{ CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}", arg_value = 0.3,},	--KAB-500Kr
								--Нары
									{ CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}", arg_value = 0.3,},	--B-8M1 - 20 S-8KOM
									{ CLSID = "B-8M1 - 20 S-8OFP2", arg_value = 0.3,},						--B-8M1 - 20 S-8OFP2
									{ CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}", arg_value = 0.3,},	--B-8M1 - 20 S-8TsM
									{ CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}", arg_value = 0.5,},	--S-24B
									{ CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}", arg_value = 0.3,},	--B-13L - 5 S-13 OF
									{ CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}", arg_value = 0.3,},	--S-25OFM
									{ CLSID = "{S_25_O}", arg_value = 0.3,},								--S-25О
								--В-З
									{ CLSID = "{0180F983-C14A-11d8-9897-000476191836}", arg_value = 0.3,},	--S-25L
									{ CLSID = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}", arg_value = 0.3,},	--Kh-25Ml
									{ CLSID = "{D4A8D9B9-5C45-42e7-BBD2-0E54F8308432}", arg_value = 0.3,},	--Kh-29L
									{ CLSID = "{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}", arg_value = 0.3,},	--Lh-29T
								--Баки
									{ CLSID = "{SU-25SM3-PTB-800}", arg_value = 0.3,},						--PTB-800
									{ CLSID = "{SU-25SM3-PTB-800-EMPTY}", arg_value = 0.3,},				--PTB-800-EMPTY
								}
							),
					pylon	(
								7,	0,	-0.315826,	-0.184911,	2.77714,
								{
									arg							=	315,
									arg_value					=	0,
									connector					=	"Pylon7",
									use_full_connector_position	=	true,
									FiY							=	0,
									FiZ							=	-3,
									FiX							=	0,
								},
								{
								--Бомбы
									{ CLSID = "{BETAB-500M}", arg_value = 0.3,},							--BETAB-500M
									{ CLSID = "{BETAB-500S}", arg_value = 0.3,},							--BETAB-500S
									{ CLSID = "{FAB-250-M54-TU}", arg_value = 0.3,},						--FAB-250-ТУ
									{ CLSID = "{P-50T}", arg_value = 0.3,},									--P-50T
									{ CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}", arg_value = 0.3,},	--RBK-250 PTAB-2.5M
									{ CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}", arg_value = 0.3,},	--RBK-500 SPBE-D PTAB-1M
									{ CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", arg_value = 0.3,},	--RBK-500 PTAB-10-5
									{ CLSID = "{RBK_250_275_AO_1SCH}"},										--RBK-250-275 AO-1SCH
									{ CLSID = "{RBK_500U_OAB_2_5RT}"},										--RBK-500U OAB-2.5RT
									{ CLSID = "{FAB-100-4}", arg_value = 0.3,},								--FAB-100-MBD-2-67U
									{ CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}", arg_value = 0.3,},	--FAB-250
									{ CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}", arg_value = 0.3,},	--FAB-500 M62
									{ CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}"},					--FAB-100
									{ CLSID = "{0511E528-EA28-4caf-A212-00D1408DF10A}"},					--SAB-100
									{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}",arg_value = 0.5,},	--KMGU-2 - 96 AO-2.5RT
									{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}",arg_value = 0.5,},	--KMGU-2 - 96 PTAB-2.5KO
									{ CLSID = "{E2C426E3-8B10-4E09-B733-9CDC26520F48}", arg_value = 0.3,},	--KAB-500Kr
								--Нары
									{ CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}", arg_value = 0.3,},	--B-8M1 - 20 S-8KOM
									{ CLSID = "B-8M1 - 20 S-8OFP2", arg_value = 0.3,},						--B-8M1 - 20 S-8OFP2
									{ CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}", arg_value = 0.3,},	--B-8M1 - 20 S-8TsM
									{ CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}", arg_value = 0.5,},	--S-24B
									{ CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}", arg_value = 0.3,},	--B-13L - 5 S-13 OF
									{ CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}", arg_value = 0.3,},	--S-25OFM
									{ CLSID = "{S_25_O}", arg_value = 0.3,},								--S-25О
								--В-З
									{ CLSID = "{0180F983-C14A-11d8-9897-000476191836}", arg_value = 0.3,},	--S-25L
									{ CLSID = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}", arg_value = 0.3,},	--Kh-25Ml
									{ CLSID = "{D4A8D9B9-5C45-42e7-BBD2-0E54F8308432}", arg_value = 0.3,},	--Kh-29L
									{ CLSID = "{601C99F7-9AF3-4ed7-A565-F8B8EC0D7AAC}", arg_value = 0.3,},	--Lh-29T
								}
							),

					pylon	(
								8,	0,	-0.51899,	-0.209927,	3.55413,
								{
									arg							=	316,
									arg_value					=	0,
									connector					=	"Pylon8",
									use_full_connector_position	=	true,
									FiY							=	0,
									FiZ							=	-3,
									FiX							=	0,
								},
								{
								--Бомбы
									{ CLSID = "{BETAB-500M}", arg_value = 0.3,},							--BETAB-500M
									{ CLSID = "{BETAB-500S}", arg_value = 0.3,},							--BETAB-500S
									{ CLSID = "{FAB-250-M54-TU}", arg_value = 0.3,},						--FAB-250-ТУ
									{ CLSID = "{P-50T}", arg_value = 0.3,},									--P-50T
									{ CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}", arg_value = 0.3,},	--RBK-250 PTAB-2.5M
									{ CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}", arg_value = 0.3,},	--RBK-500 SPBE-D PTAB-1M
									{ CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", arg_value = 0.3,},	--RBK-500 PTAB-10-5
									{ CLSID = "{RBK_250_275_AO_1SCH}"},										--RBK-250-275 AO-1SCH
									{ CLSID = "{RBK_500U_OAB_2_5RT}"},										--RBK-500U OAB-2.5RT
									{ CLSID = "{FAB-100-4}", arg_value = 0.3,},								--FAB-100-MBD-2-67U
									{ CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}", arg_value = 0.3,},	--FAB-250
									{ CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}", arg_value = 0.3,},	--FAB-500 M62
									{ CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}"},					--FAB-100
									{ CLSID = "{0511E528-EA28-4caf-A212-00D1408DF10A}"},					--SAB-100
									{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}",arg_value = 0.5,},	--KMGU-2 - 96 AO-2.5RT
									{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}",arg_value = 0.5,},	--KMGU-2 - 96 PTAB-2.5KO
								--Нары
									{ CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}", arg_value = 0.3,},	--B-8M1 - 20 S-8KOM
									{ CLSID = "B-8M1 - 20 S-8OFP2", arg_value = 0.3,},						--B-8M1 - 20 S-8OFP2
									{ CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}", arg_value = 0.3,},	--B-8M1 - 20 S-8TsM
									{ CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}", arg_value = 0.5,},	--S-24B
									{ CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}", arg_value = 0.3,},	--B-13L - 5 S-13 OF
									{ CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}", arg_value = 0.3,},	--S-25OFM
									{ CLSID = "{S_25_O}", arg_value = 0.3,},								--S-25О
								--В-З
									{ CLSID = "{0180F983-C14A-11d8-9897-000476191836}", arg_value = 0.3,},	--S-25L
									{ CLSID = "{79D73885-0801-45a9-917F-C90FE1CE3DFC}", arg_value = 0.3,},	--Kh-25Ml
								--Баки
									{ CLSID = "{SU-25SM3-PTB-800}", arg_value = 0.3,},						--PTB-800
									{ CLSID = "{SU-25SM3-PTB-800-EMPTY}", arg_value = 0.3,},				--PTB-800-EMPTY
								}
							),
					pylon	(
								9,	0,	-0.747209,	-0.240513,	4.33532,
								{
									arg							=	317,
									arg_value					=	0,
									connector					=	"Pylon9",
									use_full_connector_position	=	true,
									FiY							=	0,
									FiZ							=	-3,
									FiX							=	0,
								},
								{
								--Бомбы
									{ CLSID = "{BETAB-500M}", arg_value = 0.3,},							--BETAB-500M
									{ CLSID = "{BETAB-500S}", arg_value = 0.3,},							--BETAB-500S
									{ CLSID = "{FAB-250-M54-TU}", arg_value = 0.3,},						--FAB-250-ТУ
									{ CLSID = "{P-50T}", arg_value = 0.3,},									--P-50T
									{ CLSID = "{4203753F-8198-4E85-9924-6F8FF679F9FF}", arg_value = 0.3,},	--RBK-250 PTAB-2.5M
									{ CLSID = "{7AEC222D-C523-425e-B714-719C0D1EB14D}", arg_value = 0.3,},	--RBK-500 SPBE-D PTAB-1M
									{ CLSID = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}", arg_value = 0.3,},	--RBK-500 PTAB-10-5
									{ CLSID = "{RBK_250_275_AO_1SCH}"},										--RBK-250-275 AO-1SCH
									{ CLSID = "{RBK_500U_OAB_2_5RT}"},										--RBK-500U OAB-2.5RT
									{ CLSID = "{FAB-100-4}", arg_value = 0.3,},								--FAB-100-MBD-2-67U
									{ CLSID = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}", arg_value = 0.3,},	--FAB-250
									{ CLSID = "{37DCC01E-9E02-432F-B61D-10C166CA2798}", arg_value = 0.3,},	--FAB-500 M62
									{ CLSID = "{FB3CE165-BF07-4979-887C-92B87F13276B}"},					--FAB-100
									{ CLSID = "{0511E528-EA28-4caf-A212-00D1408DF10A}"},					--SAB-100
									{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74884}",arg_value = 0.5,},	--KMGU-2 - 96 AO-2.5RT
									{ CLSID = "{96A7F676-F956-404A-AD04-F33FB2C74881}",arg_value = 0.5,},	--KMGU-2 - 96 PTAB-2.5KO
								--Нары
									{ CLSID = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}", arg_value = 0.3,},	--B-8M1 - 20 S-8KOM
									{ CLSID = "B-8M1 - 20 S-8OFP2", arg_value = 0.3,},						--B-8M1 - 20 S-8OFP2
									{ CLSID = "{3DFB7320-AB0E-11d7-9897-000476191836}", arg_value = 0.3,},	--B-8M1 - 20 S-8TsM
									{ CLSID = "{3858707D-F5D5-4bbb-BDD8-ABB0530EBC7C}", arg_value = 0.5,},	--S-24B
									{ CLSID = "{FC56DF80-9B09-44C5-8976-DCFAFF219062}", arg_value = 0.3,},	--B-13L - 5 S-13 OF
									{ CLSID = "{A0648264-4BC0-4EE8-A543-D119F6BA4257}", arg_value = 0.3,},	--S-25OFM
									{ CLSID = "{S_25_O}", arg_value = 0.3,},								--S-25О
								--В-В
									{ CLSID = "{CBC29BFE-3D24-4C64-B81D-941239D12249}", arg_value = 0.5,},	--R-73
								--В-З
									{ CLSID = "{0180F983-C14A-11d8-9897-000476191836}", arg_value = 0.3,},	--S-25L
								}
							),
					pylon	(
								10,	0,	-1.36387,	0.108204,	5.08553,
								{
									arg							=	318,
									arg_value					=	0,
									connector					=	"Pylon10",
									use_full_connector_position	=	false,
								},
								{
									{ CLSID = "{SU-25SM3-L-370_R}", arg_value = 1,},						--L-370-RIGHT
								}
							),
				},
-----------------------------------------------------------------------------------------------
SFM_Data	= {
				aerodynamics	= {
									Cy0			=	0.1,
									Mzalfa		=	6.6,
									Mzalfadt	=	1,
									kjx			=	2.25,
									kjz			=	0.00125,
									Czbe		=	-0.016,
									cx_gear		=	0.012,
									cx_flap		=	0.06,
									cy_flap		=	0.65,
									cx_brk		=	0.06,
									table_data	= {
													[1] = 	{0,		0.0245,	0.0817,	0.052,	0.017,	0.5,	20,	1.21},
													[2] = 	{0.4,	0.0245,	0.0817,	0.052,	0.017,	3.5,	20,	1.21},
													[3] = 	{0.6,	0.0265,	0.0872,	0.048,	0.03,	3.5,	20,	1.26},
													[4] = 	{0.8,	0.0453,	0.0816,	0.13,	0.14,	3.5,	20,	0.755},
													[5] = 	{0.9,	0.0741,	0.08,	0.212,	0.25,	3.5,	20,	0.6},
													[6] = 	{1.5,	0.0741,	0.08,	0.212,	0.25,	3.5,	20,	0.6},
												  },
								  },
				engine			= {
									Nmg			=	60.00001,
									MinRUD		=	0,
									MaxRUD		=	1,
									MaksRUD		=	1,
									ForsRUD		=	1,
									type		=	"TurboJet",
									hMaxEng		=	23.5,
									dcx_eng		=	0.014,
									cemax		=	0.37,
									cefor		=	0.37,
									dpdh_m		=	4500,
									dpdh_f		=	12000,
									table_data	= {
													[1] 	= 	{0,		68952.8,	81967.2},
													[2] 	= 	{0.1,	66424.4,	72180},
													[3] 	= 	{0.2,	65130.8,	62600},
													[4] 	= 	{0.3,	64778,		53520},
													[5] 	= 	{0.4,	65130.8,	45160},
													[6] 	= 	{0.5,	66424.4,	37780},
													[7] 	= 	{0.6,	68952.8,	31860},
													[8] 	= 	{0.7,	74382,		27920},
													[9]		= 	{0.8,	86808.4,	26520},
													[10]	= 	{0.9,	94234.8,	26520},
													[11]	= 	{1,		94234.8,	26520},
												  },
								  },
			  },
-----------------------------------------------------------------------------------------------
Damage = {
				[0]		= {critical_damage = 5, args = {146}},
				[3]		= {critical_damage = 20,args = {65}}  ,
				[4]		= {critical_damage = 20, args = {150}},
				[5]		= {critical_damage = 20, args = {147}},
				[7]		= {critical_damage = 4, args = {249}} ,
				[9]		= {critical_damage = 3, args = {154}},
				[10]	= {critical_damage = 3, args = {153}},
				[11]	= {critical_damage = 3, args = {167}},
				[12]	= {critical_damage = 3, args = {161}},
				[15]	= {critical_damage = 5, args = {267}},
				[16]	= {critical_damage = 5, args = {266}},
				[23]	= {critical_damage = 8, args = {223}, deps_cells = {25}},
				[24]	= {critical_damage = 8, args = {213}, deps_cells = {26, 60}},
				[25]	= {critical_damage = 3, args = {226}},
				[26]	= {critical_damage = 3, args = {216}},
				[29]	= {critical_damage = 9, args = {224}, deps_cells = {31, 25, 23}},
				[30]	= {critical_damage = 9, args = {214}, deps_cells = {32, 26, 24, 60}},
				[31]	= {critical_damage = 4, args = {229}},
				[32]	= {critical_damage = 4, args = {219}},
				[35]	= {critical_damage = 10, args = {225}, deps_cells = {29, 31, 25, 23}},
				[36]	= {critical_damage = 10, args = {215}, deps_cells = {30, 32, 26, 24, 60}} ,
				[37]	= {critical_damage = 4, args = {227}},
				[38]	= {critical_damage = 4, args = {217}},
				[39]	= {critical_damage = 7,	args = {244}, deps_cells = {53}},
				[40]	= {critical_damage = 7, args = {241}, deps_cells = {54}},
				[45]	= {critical_damage = 9, args = {235}, deps_cells = {39, 51, 53}},
				[46]	= {critical_damage = 9, args = {233}, deps_cells = {40, 52, 54}},
				[51]	= {critical_damage = 3, args = {239}},
				[52]	= {critical_damage = 3, args = {237}},
				[53]	= {critical_damage = 3, args = {248}},
				[54]	= {critical_damage = 3, args = {247}},
				[55]	= {critical_damage = 20, args = {81}, deps_cells = {39, 40, 45, 46, 51, 52, 53, 54}},
			    [59]	= {critical_damage = 5, args = {148}},
				[60]	= {critical_damage = 1, args = {144}},

				[83]	= {critical_damage = 3, args = {134}} ,-- nose wheel
				[84]	= {critical_damage = 3, args = {136}}, -- left wheel
				[85]	= {critical_damage = 3, args = {135}} ,-- right wheel
	},
	
  DamageParts = 
  {  
    [1] = "su-25-oblomok-wing-r", -- wing R
    [2] = "su-25-oblomok-wing-l", -- wing L
    [3] = "su-25-nose", -- nose
    [4] = "su-25-tail", -- tail
  },
-----------------------------------------------------------------------------------------
	lights_data	=	{
						typename = "collection",
    lights = {
        [WOLALIGHT_NAVLIGHTS] = {
            typename = "collection",
            lights = {
                {
                    typename  = "omnilight",
                    connector = "BANO_0",
                    color     = {1.0, 1.0, 1.0, 0.17},
                    range     = 4.1,
                    argument  = 192,
                },
                {
                    typename  = "Spot",
                    connector = "BANO_1",
                    color     = {1.0, 0.05, 0.15, 0.17},
                    range     = 12.0,
                    argument  = 190,
                    angle_max = math.rad(160.0), angle_min = math.rad(150.0),
                    controller = "Strobe", mode = 0, power_up_t = 0.3, period = 2.5, reduced_flash_time = 0.333, phase_shift = 0.0,
                },
                {
                    typename  = "Spot",
                    connector = "BANO_2",
                    color     = {0.0, 0.894, 0.6, 0.17},
                    range     = 12.0,
                    argument  = 191,
                    angle_max = math.rad(160.0), angle_min = math.rad(150.0),
                    controller = "Strobe", mode = 0, power_up_t = 0.3, period = 2.5, reduced_flash_time = 0.333, phase_shift = 0.5,
                },
            }
        },
        [WOLALIGHT_SPOTS] = {
            typename = "collection",
            lights = {
                {typename = "Spot", connector = "MAIN_SPOT_PTR",   argument = -1, color = {255, 201, 125, 0.3},  intensity_max = 4000.0, angle_max = math.rad(20.0), angle_min = math.rad(15.0), angle_change_rate = math.rad(80.0), movable = true, power_up_t = 0.9, cooldown_t = 0.45, },
                {typename = "Spot", connector = "RESERV_SPOT_PTR", argument = -1, color = {255, 201, 125, 0.3},  intensity_max = 4000.0, angle_max = math.rad(20.0), angle_min = math.rad(15.0), angle_change_rate = math.rad(80.0), movable = true, power_up_t = 0.9, cooldown_t = 0.45, },
            }
        },
        [WOLALIGHT_TAXI_LIGHTS] = {
            typename = "collection",
            lights = {
                {typename = "Spot", connector = "MAIN_SPOT_PTR",   argument = -1, color = {255, 201, 125, 0.12}, intensity_max = 750.0,  angle_max = math.rad(100.0),                            angle_change_rate = math.rad(-80.0), movable = true, power_up_t = 0.9, cooldown_t = 0.45, },
                {typename = "Spot", connector = "RESERV_SPOT_PTR", argument = -1, color = {255, 201, 125, 0.12}, intensity_max = 750.0,  angle_max = math.rad(100.0),                            angle_change_rate = math.rad(-80.0), movable = true, power_up_t = 0.9, cooldown_t = 0.45, },
            }
        },
    },
					}
-----------------------------------------------------------------------------------------
		}
-----------------------------------------------------------------------------------------
add_aircraft(Su_25SM3)
-----------------------------------------------------------------------------------------