
dofile(LockOn_Options.script_path.."../../Common/command_defs.lua")
dofile(LockOn_Options.script_path.."../../Common/devices.lua")

std_message_timeout = 15

local t_start = 0.0
local t_stop = 0.0
local delta_t_com = 2.0

start_sequence_full	= {}
stop_sequence_full	= {}

function push_command(sequence, run_t, command)
	sequence[#sequence + 1] =  command
	sequence[#sequence]["time"] = run_t
end

function push_start_command(delta_t, command)
	t_start = t_start + delta_t
	push_command(start_sequence_full, t_start, command)
end

function push_stop_command(delta_t, command)
	t_stop = t_stop + delta_t
	push_command(stop_sequence_full, t_stop, command)
end

--
local count = 0
local function counter()
	count = count + 1
	return count
end



-- conditions to be added if pre auto start conditions are desired ie Thrust lever closed values

count = -1
MIRAGE_F1_AD_COMMON					= counter();
MIRAGE_F1_AD_ENGINE_START_RPM		= counter();
MIRAGE_F1_AD_ENGINE_RPM				= counter();
MIRAGE_F1_AD_THROTTLE_SET_TO_STOP	= counter();
MIRAGE_F1_AD_THROTTLE_SET_TO_IDLE	= counter();
MIRAGE_F1_AD_THROTTLE_AT_STOP		= counter();
MIRAGE_F1_AD_THROTTLE_AT_IDLE		= counter();
MIRAGE_F1_AD_ERROR					= counter();
MIRAGE_F1_AD_GROUND_SUPPLY_ON		= counter();
MIRAGE_F1_AD_GROUND_SUPPLY_OFF		= counter();
MIRAGE_F1_AD_GROUND_SUPPLY_IS_ON	= counter();

--
alert_messages = {}
alert_messages[MIRAGE_F1_AD_COMMON]					= { message = _("MIRAGE F1 ERROR"), message_timeout = 10}
alert_messages[MIRAGE_F1_AD_ENGINE_START_RPM]		= { message = _("ENGINE START RPM FAILURE"), message_timeout = 10}
alert_messages[MIRAGE_F1_AD_ENGINE_RPM]				= { message = _("ENGINE RPM FAILURE"), message_timeout = 10}
alert_messages[MIRAGE_F1_AD_THROTTLE_SET_TO_STOP]	= { message = _("THROTTLE MUST BE AT IDLE"), message_timeout = 10}
alert_messages[MIRAGE_F1_AD_THROTTLE_SET_TO_IDLE]	= { message = _("THROTTLE MUST BE AT IDLE"), message_timeout = 10}
alert_messages[MIRAGE_F1_AD_THROTTLE_AT_STOP]		= { message = _("THROTTLE MUST BE AT STOP"), message_timeout = 10}
alert_messages[MIRAGE_F1_AD_THROTTLE_AT_IDLE]		= { message = _("THROTTLE MUST BE AT IDLE"), message_timeout = 10}
alert_messages[MIRAGE_F1_AD_ERROR]					= { message = _("FM MODEL ERROR"), message_timeout = 10}
alert_messages[MIRAGE_F1_AD_GROUND_SUPPLY_ON]		= { message = _("GROUND SUPPLY ON"), message_timeout = 10}
alert_messages[MIRAGE_F1_AD_GROUND_SUPPLY_OFF]		= { message = _("GROUND SUPPLY OFF"), message_timeout = 10}
alert_messages[MIRAGE_F1_AD_GROUND_SUPPLY_IS_ON]	= { message = _("NO GROUND ELECTRIC POWER"), message_timeout = 10}

----------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------
-- Start sequence

function startup_stage1()
	push_start_command(2.0,		{message = _("AUTOSTART SEQUENCE IS RUNNING"), message_timeout = std_message_timeout})
	push_start_command(2.0,		{message = _("EXTERIOR INSPECTION PERFORMED")})
	push_start_command(1.0,		{message = _("ENTERING COCKPIT")})
	----- Entering cockpit	
	
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd178,	value = 0.0, message = _("Parking brake - Set")})	
	push_start_command(1.0,		{message = _("Rudder pedals - Adjusted")})
	push_start_command(1.0,		{message = _("Strap in, put on helmet, connect mask")})
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd223,	value = 1.0, message = _("Battery - On")})
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd253,	value = 1.0, message = _("Warning Horn - On")})
	--  Master failure warning light RESET	
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd231,	value = 1.0})	
	push_start_command(1.0, 	{message = _("Seat height - Adjust")})
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd320,	value = 1.0, message = _("Oxygen - Check")})
	push_start_command(1.0,		{message = _("CABIN CHECKS")})
	----- Cabin checks

	--- Cabin lighting rheostats - As required	
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd280,	value = 0.0})	
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd281,	value = 0.5})
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd283,	value = 0.5})
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd285,	value = 0.5})
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd287,	value = 0.5})	
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd289,	value = 0.5})
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd291,	value = 0.5})
	
	--- Emergency fuel transfer switch - Off	
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd71,	    value = 0.0})
	--- JPT emergency regulation switch - Off	
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd47,	    value = 0.0})
	--- A/B main cock switch - On (guarded)
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd48,	    value = -0.1})	
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd49,	    value = 0.0})
	--- In-flight relight control - Aft
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd38,	    value = 0.0})
	--- Combat flap lever - In
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd552,	value = 0.0})	
	--- Anti-skid (SPAD) switch - On (guarded)
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd179,	value = 0.0})	
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd180,	value = 0.0})
	--- High-lift device selector switch - Off
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd106,	value = 0.0})
	--- Ignition/Ventilation selector switch - L/H or R/H	(R/H)
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd40,	    value = 0.0})	
	--- Starting pump switch - Off
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd50,	    value = 0.0})
	--- R/H LP pump switch - Off
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd51,	    value = 0.0})	
	--- L/H LP pump switch - Off	
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd52,	    value = 0.0})
	--- LP main cock switch - Closed (unguarded)
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd43,	    value = 1.1})	
	push_start_command(0.1,		{device = devices.MAIN,	action = devCmds.Cmd44,	    value = 1.0})	
	--- Emergency regulation switch - Off (guarded)
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd154,	value = -0.1})	
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd155,	value = 0.0})
	--- Landing light control - Off
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd271,	value = 0.0})
	--- U/C control lever - Down
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd176,	value = 1.0})
	--- Yaw/Anti-slip switch - Anti-slip
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd17,	    value = 1.0})	
	--- Pitch switch - On
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd18,	    value = 1.0})
	--- ARTHUR selector switch-Auto (guarded)
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd15,	    value = -0.1})	
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd16,	    value = 0.0})
	--- Stick uncouple switch - Off (guarded)
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd13,	    value = 0.0})	
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd14,	    value = -0.1})
	--- Hydraulic pressure selector switch - 1 SERVOS 2
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd186,	value = 1.0})
	--- Brake chute control	- Forward                                           
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd160,	value = 0.0})
	--- Canopy embrittle control - Aft                                          
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd162,	value = 0.0})
	--- Shock-cone pushbutton - Depressed
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd55,	    value = 1.0})
	--- Shock-cone pushbutton - Released (is electromagnetically held in 'ON' position)
	push_start_command(0.15,	{device = devices.MAIN,	action = devCmds.Cmd56,	    value = 0.0})
	--- Nose wheel steering switch - On (guarded)
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd183,	value = 0.0})
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd184,	value = 0.0})
	--- Nose wheel steering high sensitivity button	- Depressed
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd181,	value = 1.0})
	--- Nose wheel steering high sensitivity button - Released (is electromagnetically held in 'ON' position)
	push_start_command(0.15,	{device = devices.MAIN,	action = devCmds.Cmd182,	value = 0.0})
	
	--- Armament control panel:
	--- Select pushbuttons - Released
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd510,	value = 0.0})
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd511,	value = 0.0})	
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd512,	value = 0.0})	
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd513,	value = 0.0})	
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd514,	value = 0.0})	
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd515,	value = 0.0})	
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd516,	value = 0.0})
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd517,	value = 0.0})
	--- Instantaneous/Delay/Safe selector switch - Safe
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd509,	value = 0.0})
	--- MATRA 550 missile switch - Off
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd505,	value = 0.0})
	--- Emergency transfer switch - Off
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd71,	    value = 0.0})
	--- Crossfeed switch
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd70,	    value = 0.0})
	--- Emergency U/C handle - In and folder back
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd185,	value = 0.0})
	--- Alternator 1 and alternator 2 switches - On	
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd224,	value = 1.0})
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd225,	value = 1.0})
	--- Inverter selector switch - Auto
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd227,	value = 0.0})
	--- Canopy seal valve control lever	- Inflate (forward)
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd164,	value = 0.0})
	--- Ram air switch - Off (guarded)
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd335,	value = 0.0})
	-- Cabin temperature control rheostat - Auto
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd329,	value = 0.5})
	--- Emergency cold switch - Off
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd327,	value = 1.0})
	--- Auto/Manual selector switch - Auto
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd331,	value = 0.0})
	push_start_command(1.0,		{message = _("Cabin checks - Performed")})
	push_start_command(1.0,		{message = _("STARTING")})

	----- Starting

	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd167,	value = 0.0, message = _("Canopy - Closed")})
	push_start_command(4.0,		{device = devices.MAIN,	action = devCmds.Cmd161,	value = 0.0, message = _("Canopy lock control - Forward")})	
	--- LP main cock switch - Open
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd44,	    value = 0.0, message = _("LP main cock switch - Open")})	
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd43,	    value = -0.1})	
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd52,	    value = 1.0, message = _("L/H LP pump switch - On")})
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd51,	    value = 1.0, message = _("R/H LP pump switch - On")})	
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd40,	    value = 1.0, message = _("Ignition/Ventilation selector switch - To the other plug")})
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd41,	    value = 1.1, message = _("Start button cover - Open")})
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd42,	    value = 1.0, message = _("Start button - Depress (for 1 sec approx.)")})
	push_start_command(1.2,		{device = devices.MAIN,	action = devCmds.Cmd42,	    value = 0.0})
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd41,	    value = -0.1})	
	
	--- Between 300 and 600 rpm - advance the throttle to IDLE
	push_start_command(6.0,		{device = devices.MAIN,	action = devCmds.Cmd35,	    value = 11.65 / 90.0, message = _("Advance throttle to IDLE")})	
	
	push_start_command(23.0,	{message = _("AFTER START CHECKS")})

	----- After start checks

	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd106,	value = 1.0, message = _("High-lift device selector switch - Normal")})	
	
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd552,	value = 0.0, message = _("Combat flap lever - In")})
		
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd389,	value = 0.0, message = _("UHF radio - On")})
		
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd105,	value = 1.0, message = _("Slat/Flap lever - Full aft")})
	
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd144,	value = 0.0, message = _("V/UHF radio - On")})
		
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd145,	value = 1.0, message = _("25W - 5W switch - 5W")})
		
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd228,	value = -1.0, message = _("Inverter selector switch - Reset")})
	push_start_command(0.5,		{device = devices.MAIN,	action = devCmds.Cmd228,	value = 0.0})	
		
	push_start_command(3.0,		{device = devices.MAIN,	action = devCmds.Cmd12,	    value = 1.0, message = _("Servos - Reset")})
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd12,	    value = 0.0})
		
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd458,	value = 0.3333, message = _("IFF - Sby")})

	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd479,	value = -1.0, message = _("Navigation indicator - As required")})
		
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd209,	value = 1.0, message = _("Standby horizon switch - On")})
		
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd187,	value = 1.0, message = _("Electro-pump switch - On")})
		
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd206,	value = 1.0, message = _("Probe heater switch - On")})
		
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd376,	value = 1.0, message = _("Radar detector switch - On")})
		
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd503,	value = 0.5, message = _("Sight selector - On")})
		
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd523,	value = 0.5, message = _("Radar selector - Standby")})
		
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd216,	value = 0.333, message = _("Heading and vertical reference system control switch - Gm")})
	
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd218,	value = 1.0, message = _("Emergency gyromagnetic compass switch - On")})
		
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd299,	value = 0.666, message = _("TACAN - Rec")})
	
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd302,	value = 1.0, message = _("VOR/ILS - On")})
	
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd328,	value = 1.0, message = _("Air conditioning - On")})
		
	-- Pull the knob
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd213,	value = 1.0, message = _("Standby horizon - Uncage")})
	-- Rotate the knob to the middile position. Effectively it will uncage the gyro
	push_start_command(0.5,		{device = devices.MAIN,	action = devCmds.Cmd215,	value = 0.5})
	-- Release the knob
	push_start_command(0.1,		{device = devices.MAIN,	action = devCmds.Cmd214,	value = 0.0})
		
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd562,	value = 1.0, message = _("Ejection handle safety pin - Removed (out of sequence)")})	

	push_start_command(1.0,		{message = _("WAIT FOR GYROSCOPIC SYSTEM ALIGNMENT..."), message_timeout = 46})
	
-- Need to add this to confirm that servos reset correctly (after C.AERO advisory goes off)
	push_start_command(6.0,		{device = devices.MAIN,	action = devCmds.Cmd12,	    value = 1.0})	
	push_start_command(0.5,		{device = devices.MAIN,	action = devCmds.Cmd12,	    value = 0.0})
	
	push_start_command(40.5,	{})
	
end

function startup_complete()
	push_start_command(1.0, 	{message = _("AUTOSTART COMPLETE"), message_timeout = std_message_timeout})
	
end	

function shut_down()
	push_stop_command(2.0,		{message = _("AUTOSTOP SEQUENCE IS RUNNING"), message_timeout = std_message_timeout})
	
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd562,	value = 0.0, message = _("Ejection handle safety pin - Installed (out of sequence)")})
		
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd389,	value = 0.75, message = _("UHF radio - Off")})
	
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd144,	value = 0.6, message = _("V/UHF radio - Off")})
		
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd113,	value = -1.0, message = _("AMPLI 2-1 selector switch - 1")})
		
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd175,	value = -1.0, message = _("U/C safety lever - Closed")})
		
	-- Pull the knob
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd213,	value = 1.0, message = _("Standby horizon - Cage")})
	-- Rotate the knob fully clockwise to block it in the 'caged' position
	push_stop_command(0.5,		{device = devices.MAIN,	action = devCmds.Cmd215,	value = 1.0})
	-- Release the knob - it will remain in the 'caged' position
	push_stop_command(0.5,		{device = devices.MAIN,	action = devCmds.Cmd214,	value = 0.0})
		
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd479,	value = 1.0, message = _("Navigation indicator - Off")})
	push_stop_command(0.2,		{device = devices.MAIN,	action = devCmds.Cmd479,	value = 1.0})
	push_stop_command(0.2,		{device = devices.MAIN,	action = devCmds.Cmd479,	value = 1.0})
		
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd209,	value = 0.0, message = _("Standby horizon switch - Off")})
		
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd187,	value = 0.0, message = _("Electro-pump switch - Off")})
		
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd253,	value = 0.0, message = _("Warning Horn - Off")})	
	
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd206,	value = 0.0, message = _("Probe heater switch - Off")})
		
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd376,	value = 0.0, message = _("Radar detector switch - Off")})
		
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd274,	value = 0.0, message = _("Search light control - Off")})
	
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd503,	value = 0.0, message = _("Sight selector - Off")})
		
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd523,	value = 0.0, message = _("Radar selector - Off")})
	
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd510,	value = 0.0, message = _("Armament control panel pushbutton selectors - Released")})
	push_stop_command(0.2,		{device = devices.MAIN,	action = devCmds.Cmd511,	value = 0.0})	
	push_stop_command(0.2,		{device = devices.MAIN,	action = devCmds.Cmd512,	value = 0.0})	
	push_stop_command(0.2,		{device = devices.MAIN,	action = devCmds.Cmd513,	value = 0.0})	
	push_stop_command(0.2,		{device = devices.MAIN,	action = devCmds.Cmd514,	value = 0.0})	
	push_stop_command(0.2,		{device = devices.MAIN,	action = devCmds.Cmd515,	value = 0.0})	
	push_stop_command(0.2,		{device = devices.MAIN,	action = devCmds.Cmd516,	value = 0.0})
	push_stop_command(0.2,		{device = devices.MAIN,	action = devCmds.Cmd517,	value = 0.0})
		
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd216,	value = 0.0, message = _("Heading and vertical reference system control switch - Off")})
	
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd218,	value = 0.0, message = _("Emergency gyromagnetic compass switch - Off")})
		
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd302,	value = 1.0, message = _("VOR/ILS - Off")})
		
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd328,	value = 0.0, message = _("Air conditioning - Off")})
		
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd37,	    value = 1.0, message = _("Throttle cut/idle switch - Stop")})
	push_stop_command(0.5,		{device = devices.MAIN,	action = devCmds.Cmd37,	    value = 0.0})
		
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd52,	    value = 0.0, message = _("L/H LP pump switch - Off")})
	
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd51,	    value = 0.0, message = _("R/H LP pump switch - Off")})
		
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd50,	    value = 0.0, message = _("Starting pump switch - Off")})
	
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd43,	    value = 1.1})
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd44,	    value = 1.0, message = _("LP main cock switch - Off")})	
	
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd223,	value = 0.0, message = _("Battery - Off")})
		
	push_stop_command(4.0,		{device = devices.MAIN,	action = devCmds.Cmd161,	value = 1.0, message = _("Canopy lock control - Aft")})		
		
	push_stop_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd167,	value = 1.0, message = _("Canopy - Open")})
		
	push_stop_command(3.0,  	{message = _("AUTOSTOP COMPLETE"),message_timeout = std_message_timeout})	

end	