
dofile(LockOn_Options.script_path.."../../Common/command_defs.lua")
dofile(LockOn_Options.script_path.."../../Common/devices.lua")

std_message_timeout = 15

local t_start = 0.0
local t_stop = 0.0
local delta_t_com = 2.0

-----------------------------------------------------------------
------------------------DISCLAIMER-------------------------------
-----------------------------------------------------------------
--This startup macro has been configured by "DJBscout"
--Feel free to use, modify, and/or redistribute this file
--However, if you do so, please credit me for the work done
--On that note, this script was inspired by /u/SlipHavoc's scripts
-----------------------------------------------------------------
-----------------------CONFIGURATION-----------------------------
-----------------------------------------------------------------
--LOADOUT:
local AutoJettConfig	= 1		-- determines whether macro shifts fuel amount 
								-- and selects proper jetison switch location to drop tanks

local DropTanks			= 2		-- number of drop tanks mounted, each is ~1155L
								-- sets fuel totalizer to amount in external tanks
								-- you have a fuelage gauge and tank panel to tell you how much you have internally, no need for the numbers to say that too	
--GENERAL:
local dt                = 0.1   -- Default interval between commands in the stack. Stock is 0.2s, 0.0 can break some things
local TotalRunTime      = 0   -- Total time from start to finish

--LIGHTING
local ExternalNav       = 1     --Nav Lights. 0 = DIM, 0.5 = off, 1.0 = BRT
local ExternalForm      = 1     --"Formation Lights." (actually the beacon) 0 = Steady, 0.5 = off, 1.0 = Flashing
local ExternalTaxi      = 1     --Taxi Light Switch. 0=off, 1=on 

--COMMS
local UHFMode			= 0.5	-- 0 = (M)anual, 0.5 = (P)reset, 1.0 = (G)uard
local UHFChannel		= 1		-- Preset # (1-20)
local UHF2Channel		= 1		-- Preset # (1-20) --freq varies between CE and EE

local UHFHundreds       = 1     -- Set as desired
local UHFTens           = 2     --  ""
local UHFOnes           = 6     --  ""
local UHFTenths         = 0     --  ""
local UHFHundreths      = 0     -- not actually hundreths, see next line for guide
                                --0 = .000, 1 = .025, 2 = .050, 3 = .075
--local UHFVolume			= 40	--% volume, not implemented
--local UHF2Volume		= 40	--% volume
local MissileVolume		= 50	--%

--RADIONAV
local VORMode			= 1		-- 0=off, 1=on
local VORHundreds       = 1     -- doesn't really do anything bc this number can't change
local VORUnits          = 12    -- Ranges from 08 to 17
local VORDecimal        = 60    -- Ranges from 00 to 95
local VORVolume			= 0		-- %

local TACANMode			= 0.333		-- 0=A/A, 0.333=T/R, .666=REC, 1.0=OFF
local TACANTens         = 8     --  Set as Desired
local TACANOnes         = 4     --  ""
local TACANXY           = "X"   --MUST BE CAPITAL FOR PROPER FUNCTION
local TACANVolume		= 0		--%

--NAVIGATION:
local NavMode			= .333	-- 0 = TT (RADAR/TACAN), .333 = TE (RADAR ONLY), .666 = VT (VOR/TACAN), 1 = OFF
local NavModeEE			= 0.8	-- 0 = NAV-VA, 0.2 = NAV-N, 0.4 = ρ, 0.6 = θ, 0.8 = RNAV-N, 1.0 = RNAV-VA
								-- okay, I'll try and break these down
								-- NAV-N: Direction and distance to next waypoint
								-- RNAV-N: Direction and distance to TACAN
								-- "-VA" adds the configured A.dditional V.ector to both modes above
								-- "ρ" is for setting additional vector distance in nautical miles
								-- "θ" is for setting additional vector angle in degrees

local AlignSpeed	 	= "FAST"-- "FAST" or "FULL" only
local EEConfigureWP		= 0		-- 0 = nothing. 1 = Macro will set waypoint 2 per your settings.
		--default coords are for Kobuleti (41°56'N 41°52'E)
local NorthSouth		= "N"	-- ONLY "N" or "S"
local LatDegTen			= 4
local LatDegOne			= 1
local LatMinTen			= 5
local LatMinOne			= 6
local LatMinDec			= 0
local EastWest			= "E"	-- ONLY "E" or "W"
local LongDegHun		= 0
local LongDegTen		= 4
local LongDegOne		= 1
local LongMinTen		= 5
local LongMinOne		= 2
local LongMinDec		= 0


--local HSICourse         = 270   --not yet implemented
--local HSIHeading        = 0     -- ""
----------------------------------------------------------------------------------------------------
--------------------------------IF YOU ARE AN IDIOT, GO NO LOWER------------------------------------
----------------------------------------------------------------------------------------------------
--------------------------------------YES, SERIOUSLY------------------------------------------------
----------------------------------------------------------------------------------------------------

----------------------------------------------------------------------------------------------------
-------HERE BE DRAGONS, DO NOT TOUCH (aka some guts that make config and readouts easier)-----------
----------------------------------------------------------------------------------------------------
local GyroTime			= 50 	--varies based on numerous factors (including date and map), if the script thinks the gyro is aligned before it is, feel free to increase. However,
								--it doesn't actually hurt anything if the alignment time is too short, the script just tells you that you can taxi a bit too early
local EmerGyroTime		= 90
local INS_fast_align 	= 110 --nominal time of 1.5 mins (90s), but actual required is 1m50s (109)
local INS_long_align 	= 388 --default time is 387s, nominal is 8 mins (480)
local EEdt = 0.1

local INSButtons		= {	[1] = devCmds.Cmd698, [2] = devCmds.Cmd699, [3] = devCmds.Cmd700, --1-3
							[4] = devCmds.Cmd701, [5] = devCmds.Cmd702, [6] = devCmds.Cmd703, --4-6
							[7] = devCmds.Cmd704, [8] = devCmds.Cmd705, [9] = devCmds.Cmd706, --7-9
							[0] = devCmds.Cmd697, ["N"]=devCmds.Cmd699, ["S"]=devCmds.Cmd705,
							["E"] = devCmds.Cmd703, ["W"] = devCmds.Cmd701}

local TACANXYConverted = 0
if TACANXY == "X"
    then TACANXYConverted = 0 
    else TACANXYConverted = 1
end

local FuelCapCE = 	-4250
local FuelCapEE	=	-4100

local ExternalTaxiYN    = {[0]="OFF","ON"}
local ExtFormTalkback   = {[0] = "FLASH", [0.5] = "OFF", [1.0] = "STEADY"}
local ExtNavTalkback   	= {[0] = "DIM", [0.5] = "OFF", [1.0] = "BRIGHT"}
local NavModeTalkback	= {[0]="TT (RADAR/TACAN)", [.333]="TE (RADAR ONLY)", [.666]="VT (VOR/TACAN)", [1]="OFF"}
local NavModeTalkbackEE	= {[0] = "NAV-VA", [0.2] = "NAV-N", [0.4] = "ρ", [0.6] = "θ", [0.8] = "RNAV-N", [1.0] = "RNAV-VA"}
local TACANModeTalkback	= {[0] = "A/A", [.333] = "T/R", [.666] = "REC", [1.0] = "OFF"}
local UHFModeTalkback	= {[0] = "(M)anual", [0.5] = "(P)reset", [1.0] = "(G)uard"}
local UHFHundrethsValue = {[0]=0,25,50,75}

local DeltaUHFTens      = UHFTens-2  	--  ""
local DeltaUHFOnes      = UHFOnes-7  	--  ""
local DeltaUHFTenths    = UHFTenths-5   --  ""

local VORDeltaUnits		= VORUnits-08

start_sequence_full	= {}
stop_sequence_full	= {}

function push_command(sequence, run_t, command)
	sequence[#sequence + 1] =  command
	sequence[#sequence]["time"] = run_t
end

function push_start_command(delta_t, command)
	t_start = t_start + delta_t
	push_command(start_sequence_full,t_start, command)
end

function push_stop_command(delta_t, command)
	t_stop = t_stop + delta_t
	push_command(stop_sequence_full,t_stop, command)
end

--
local count = 0
local function counter()
	count = count + 1
	return count
end



-- conditions to be added if pre auto start conditions are desired ie Thrust lever closed values

count = -1
MIRAGE_F1_AD_COMMON				= counter();
MIRAGE_F1_AD_ENGINE_START_RPM		= counter();
MIRAGE_F1_AD_ENGINE_RPM			= counter();
MIRAGE_F1_AD_THROTTLE_SET_TO_STOP	= counter();
MIRAGE_F1_AD_THROTTLE_SET_TO_IDLE	= counter();
MIRAGE_F1_AD_THROTTLE_AT_STOP		= counter();
MIRAGE_F1_AD_THROTTLE_AT_IDLE		= counter();
MIRAGE_F1_AD_ERROR				= counter();
MIRAGE_F1_AD_GROUND_SUPPLY_ON		= counter();
MIRAGE_F1_AD_GROUND_SUPPLY_OFF	= counter();
MIRAGE_F1_AD_GROUND_SUPPLY_IS_ON	= counter();

--
alert_messages = {}
alert_messages[MIRAGE_F1_AD_COMMON]				= { message = _("MIRAGE F1 ERROR"), message_timeout = 10}
alert_messages[MIRAGE_F1_AD_ENGINE_START_RPM]		= { message = _("ENGINE START RPM FAILURE"), message_timeout = 10}
alert_messages[MIRAGE_F1_AD_ENGINE_RPM]			= { message = _("ENGINE RPM FAILURE"), message_timeout = 10}
alert_messages[MIRAGE_F1_AD_THROTTLE_SET_TO_STOP]	= { message = _("THROTTLE MUST BE AT IDLE"), message_timeout = 10}
alert_messages[MIRAGE_F1_AD_THROTTLE_SET_TO_IDLE]	= { message = _("THROTTLE MUST BE AT IDLE"), message_timeout = 10}
alert_messages[MIRAGE_F1_AD_THROTTLE_AT_STOP]		= { message = _("THROTTLE MUST BE AT STOP"), message_timeout = 10}
alert_messages[MIRAGE_F1_AD_THROTTLE_AT_IDLE]		= { message = _("THROTTLE MUST BE AT IDLE"), message_timeout = 10}
alert_messages[MIRAGE_F1_AD_ERROR]				= { message = _("FM MODEL ERROR"), message_timeout = 10}
alert_messages[MIRAGE_F1_AD_GROUND_SUPPLY_ON]		= { message = _("GROUND SUPPLY ON"), message_timeout = 10}
alert_messages[MIRAGE_F1_AD_GROUND_SUPPLY_OFF]	= { message = _("GROUND SUPPLY OFF"), message_timeout = 10}
alert_messages[MIRAGE_F1_AD_GROUND_SUPPLY_IS_ON]	= { message = _("NO GROUND ELECTRIC POWER"), message_timeout = 10}

----------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------
-- Start sequence

function startup_prestart()--1
	push_start_command(dt,	{message = _("AUTOSTART SEQUENCE IS RUNNING"), message_timeout = std_message_timeout})
	push_start_command(dt,	{message = _("PRESTART SEQUENCE INITIATED"), message_timeout = std_message_timeout})
	push_start_command(dt,	{message = _("EXTERIOR INSPECTION PERFORMED")})
	push_start_command(dt,	{message = _("ENTERING COCKPIT")})
	----- Entering cockpit
	--push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd1,		    value = 1.0, message = _("Stick - Hidden")})
	--push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd628,	    value = 1.0, message = _("Radar Cover - Removed")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd178,	    value = 0.0, message = _("Parking brake - Set")})
	push_start_command(dt,{message = _("Rudder pedals - Adjusted")})
--	push_start_command(0.5,	{device = devices.SYSTEMS,	action = device_commands.Button_240,	value = 0.5})
	push_start_command(dt,{message = _("Strap in, put on helmet, connect mask")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd223,	    value = 1.0, message = _("Battery switch - On")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd253,	    value = 1.0, message = _("Warning horn switch - On")})
	--  Master failure warning light RESET	
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd231,	value = 1.0})	
	push_start_command(dt, 	{message = _("Seat height - Adjust")})
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd320,	value = 1.0, message = _("Oxygen - Check")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd562,	    value = 1.0, message = _("Ejection handle safety pin - Remove")})
	push_start_command(dt,	{message = _("CABIN CHECKS")})
	----- Cabin checks
	--- Cabin lighting rheostats - As required
	push_start_command(dt,	{message = _("Internal Lights - On")})
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd280,	value = 1.0})--Day/night switch		
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd281,	value = 0.50})--light+panel lighting rheostat (strength of warning and panel lights, e.g. airbrake light, flap/gear lights, master caution, etc)
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd283,	value = 1.0})--UV lighting rheostat (highlights flight intruments)
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd285,	value = 0.75})--instrument panel floodlights
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd287,	value = 1.0})--instrument panel backlights	
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd289,	value = 0.75})--console/pedestal floodlights
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd291,	value = 0.75})--console/pedestal backlights
	
--- Emergency fuel transfer switch - Off	
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd71,	    value = 0.0})
	--- JPT emergency regulation switch - AUTO	
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd47,	    value = 1.0})
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd47,	    value = 1.0})
	--- A/B main cock switch - On (guarded)
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd48,	    value = -0.1})	
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd49,	    value = 0.0})
	--- In-flight relight control - Aft
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd38,	    value = 0.0})
	--- Combat flap lever - In
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd552,	value = 0.0})	
	--- Anti-skid (SPAD) switch - On (guarded)
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd179,	value = 0.0})	
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd180,	value = 0.0})
	--- High-lift device selector switch - Off
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd106,	value = 0.0})
	--- Ignition/Ventilation selector switch - L/H or R/H	(R/H)
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd40,	    value = 0.0})	
	--- Starting pump switch - Off
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd50,	    value = 0.0})
	--- R/H LP pump switch - Off
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd51,	    value = 0.0})	
	--- L/H LP pump switch - Off	
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd52,	    value = 0.0})
	--- LP main cock switch - Closed (unguarded)
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd43,	    value = 1.1})	
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd44,	    value = 1.0})	
	--- Emergency regulation switch - Off (guarded)
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd154,	value = -0.1})	
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd155,	value = 0.0})
	--- Landing light control - Off
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd271,	value = 0.0})
	--- U/C control lever - Down
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd176,	value = 1.0})
	--- Yaw/Anti-slip switch - Anti-slip
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd17,	    value = 1.0})	
	--- Pitch switch - On
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd18,	    value = 1.0})
	--- ARTHUR selector switch-Auto (guarded)
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd15,	    value = -0.1})	
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd16,	    value = 0.0})
	--- Stick uncouple switch - Off (guarded)
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd13,	    value = 0.0})	
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd14,	    value = -0.1})
	--- Hydraulic pressure selector switch - 1 SERVOS 2
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd186,	value = 1.0})
	--- Brake chute control	- Forward                                           
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd160,	value = 0.0})
	--- Canopy embrittle control - Aft                                          
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd162,	value = 0.0})
	--- Shock-cone pushbutton - Depressed
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd55,	    value = 1.0})
	--- Shock-cone pushbutton - Released (is electromagnetically held in 'ON' position)
	push_start_command(0.15,	{device = devices.MAIN,	action = devCmds.Cmd56,	    value = 0.0})
	--- Nose wheel steering switch - On (guarded)
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd183,	value = 0.0})
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd184,	value = 0.0})
	--- Nose wheel steering high sensitivity button	- Depressed
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd181,	value = 1.0})
	--- Nose wheel steering high sensitivity button - Released (is electromagnetically held in 'ON' position)
	push_start_command(0.15,	{device = devices.MAIN,	action = devCmds.Cmd182,	value = 0.0})
	
	--- Armament control panel:
	--- Select pushbuttons - Released
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd510,	value = 0.0})
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd511,	value = 0.0})	
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd512,	value = 0.0})	
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd513,	value = 0.0})	
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd514,	value = 0.0})	
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd515,	value = 0.0})	
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd516,	value = 0.0})
	push_start_command(0.0,		{device = devices.MAIN,	action = devCmds.Cmd517,	value = 0.0})
	--- Instantaneous/Delay/Safe selector switch - Safe
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd509,	value = 0.0})
	--- MATRA 550 missile switch - Off
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd505,	value = 0.0})
	--- Emergency transfer switch - Off
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd71,	    value = 0.0})
	--- Crossfeed switch
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd70,	    value = 0.0})
	--- Emergency U/C handle - In and folder back
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd185,	value = 0.0})
	--- Alternator 1 and alternator 2 switches - On	
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd224,	value = 1.0})
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd225,	value = 1.0})
	--- Inverter selector switch - Auto
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd227,	value = 0.0})
	--- Canopy seal valve control lever	- Inflate (forward)
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd164,	value = 0.0})
	--- Ram air switch - Off (guarded)
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd335,	value = 0.0})
	-- Cabin temperature control rheostat - Auto
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd329,	value = 0.5})
	--- Emergency cold switch - Off
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd327,	value = 1.0})
	--- Auto/Manual selector switch - Auto
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd331,	value = 0.0})
	push_start_command(dt,		{message = _("Cabin checks - Performed")})
end
function startup_engine()--2
	push_start_command(dt,	{message = _("STARTUP SEQUENCE INITIATED"), message_timeout = std_message_timeout})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd123,	    value = 1.0, message = _("Ground Crew Intercom - Selected")}) --MKR/TP Pushbutton now required for ground crew comms
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd167,	    value = 0.0, message = _("Canopy - Closed")})
	push_start_command(4.0,	{device = devices.MAIN,	action = devCmds.Cmd161,	    value = 0.0, message = _("Canopy lock control - Forward")})	
	
	--- LP main cock switch - Open
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd44,	    value = 0.0, message = _("LP main cock switch - Open")})	
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd43,	    value = -0.1})	
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd52,	    value = 1.0, message = _("L/H LP pump switch - On")})
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd51,	    value = 1.0, message = _("R/H LP pump switch - On")})	
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd40,	    value = 1.0, message = _("Ignition/Ventilation selector switch - To the other plug")})
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd41,	    value = 1.1, message = _("Start button cover - Open")})
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd42,	    value = 1.0, message = _("Start button - Depress (for 1 sec approx.)")})
	push_start_command(1.2,		{device = devices.MAIN,	action = devCmds.Cmd42,	    value = 0.0})
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd41,	    value = -0.1})	
	push_start_command(dt,	{message = _("ENGINE STARTING"), message_timeout = 14}) --time not changed from old code, but still works
	--- Between 300 and 600 rpm - advance the throttle to IDLE
	push_start_command(6.0,		{device = devices.MAIN,	action = devCmds.Cmd35,	    value = 11.65 / 90.0, message = _("Advance throttle to IDLE")})	
	push_start_command(8,	{message = _("ENGINE START"), message_timeout = 8}) --timer adapted to simply adopt old time - delay to throttle.
end
function startup_poststart()--3
	push_start_command(dt,	{message = _("POST-START SEQUENCE INITIATED"), message_timeout = std_message_timeout})
	----- After start checks	
	push_start_command(4,	{message = _("AFTER START CHECKS")}) --need to check required time before power hits and initializing the INS
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd271,	    value = ExternalTaxi, message = _("Ldg/Taxi Light - ")..ExternalTaxiYN[ExternalTaxi]}) --landing/taxi light	push_start_command(dt,	{message = _("Internal Lights - On")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd272,	    value = ExternalForm, message = _("Beacon - ")..ExtFormTalkback[ExternalForm]}) --"formation aka beacon"
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd273,	    value = ExternalNav, message = _("Nav Lights - ")..ExtNavTalkback[ExternalNav]}) --Nav lights
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd328,		value = 1.0, message = _("Air conditioning - On")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd209,		value = 1.0, message = _("Standby horizon switch - On")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd187,		value = 1.0, message = _("Electro-pump switch - On")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd206,		value = 1.0, message = _("Probe heater switch - On")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd376,		value = 1.0, message = _("Radar detector switch - On")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd503,		value = 0.5, message = _("Sight selector - On")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd523,		value = 0.5, message = _("Radar selector - Standby")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd532,	    value = 1.0, message = _("IFF - Sby")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd62,	    	value = 0.0, message = _("JPT emergency regulation switch - Auto")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd106,		value = 1.0, message = _("High-lift device selector switch - Normal")})	
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd552,		value = 0.0, message = _("Combat flap lever - In")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd105,		value = 1.0, message = _("Slat/Flap lever - Full aft")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd228,		value = -1.0, message = _("Inverter selector switch - Reset")})
	push_start_command(0.5,	{device = devices.MAIN,	action = devCmds.Cmd255,	    value = -1.0, message = _("Inverter selector switch - Reset")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd228,		value = 0.0})	
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd12,	  	 	value = 1.0, message = _("Servos - Reset")})
	push_start_command(0.5,	{device = devices.MAIN,	action = devCmds.Cmd12,	    	value = 0.0})
end
function startup_comms()--4
	push_start_command(dt,	{message = _("COMMS SEQUENCE INITIATED"), message_timeout = std_message_timeout})
	--RADIO
	--Radio 1
--	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd142,	    value = 1.0, message = _("Green (V/UHF) radio - On")})--now cycled likethe channels because screw me I guess 
	for i = 1, 1, 1 do --starts at AR, rotates it 1 time to PAL
		push_start_command(0.2,	{device = devices.MAIN,  action = devCmds.Cmd142,             value = 0.2})--value doesn't really seem to matter, only if +-
	end
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd145,	    value = 1.0, message = _("25W - 5W switch - 5W")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd146,	    value = UHFMode, message = _("V/UHF Mode - "..UHFModeTalkback[UHFMode])})--actually "frequency slector"
	--preset
	push_start_command(dt,	{message = _("Preset Channel - "..UHFChannel),	message_timeout = 5.0})
		for i = 1, (UHFChannel-1), 1 do --tunes V/UHF Preset
		push_start_command(0.2, {device = devices.MAIN,  action = devCmds.Cmd148,             value = 0.1})--value doesn't matter, only positive or negative??
	end
	--manual
	push_start_command(dt,{message = _("Tuning Manuual Frequency to "..UHFHundreds..UHFTens..UHFOnes.."."..UHFTenths..UHFHundrethsValue[UHFHundreths]), message_timeout = 3})
	push_start_command(dt,  {device = devices.MAIN, action = devCmds.Cmd132,        value = UHFHundreds*0.1}) --0.1=100, 0.2=200, 0.3=300

	if (DeltaUHFTens) >= 0 --relative to starting location (127.500), so an absolute pain in the ass
		then 
			for i = 1, (DeltaUHFTens), 1 do --
				push_start_command(0.2,	{device = devices.MAIN,  action = devCmds.Cmd134,             value = 0.1})--value doesn't seem to matter, only if +-
			end
	else 
			for i = -1, (DeltaUHFTens), -1 do --
				push_start_command(0.2,	{device = devices.MAIN,  action = devCmds.Cmd134,             value = -0.1})--value doesn't seem to matter, only if +-
			end
	end
	if (DeltaUHFOnes) >= 0 --relative to starting location (127.500), so an absolute pain in the ass
		then 
			for i = 1, (DeltaUHFOnes), 1 do --
				push_start_command(0.2,	{device = devices.MAIN,  action = devCmds.Cmd136,             value = 0.1})--value doesn't seem to matter, only if +-
			end
	else 
			for i = -1, (DeltaUHFOnes), -1 do --
				push_start_command(0.2,	{device = devices.MAIN,  action = devCmds.Cmd136,             value = -0.1})--value doesn't seem to matter, only if +-
			end
	end
	if (DeltaUHFTenths) >= 0 --relative to starting location (127.500), so an absolute pain in the ass
		then 
			for i = 1, (DeltaUHFTenths), 1 do --
				push_start_command(0.2,	{device = devices.MAIN,  action = devCmds.Cmd138,             value = 0.1})--value doesn't seem to matter, only if +-
			end
	else 
			for i = -1, (DeltaUHFTenths), -1 do --
				push_start_command(0.2,	{device = devices.MAIN,  action = devCmds.Cmd138,             value = -0.1})--value doesn't seem to matter, only if +-
			end
	end
	push_start_command(dt,  {device = devices.MAIN, action = devCmds.Cmd140,        value = UHFHundreths*0.333})    --UHF .025 MHz Selctor
	push_start_command(dt,{message = _("V/UHF TUNED TO "..UHFHundreds..UHFTens..UHFOnes.."."..UHFTenths..UHFHundrethsValue[UHFHundreths]),      message_timeout = std_message_timeout})
	--push_start_command(dt,  {device = devices.MAIN, action = devCmds.Cmd131,    	value = UHFVolume*0.1,	message = _("Radio 1 Volume - "..UHFVolume.."%")})
	--Radio 2
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd389,	    value = 0.0, message = _("Red (UHF) Radio - On")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd383,	    value = 1.0, message = _("25W - 5W switch - 5W")})
	for i = 1, (UHF2Channel-1), 1 do --tunes UHF Preset
		push_start_command(0.2, {device = devices.MAIN,  action = devCmds.Cmd391,             value = 0.1})--value doesn't matter, only positive or negative??
	end
	push_start_command(dt,	{message = _("Radio 2: Channel - "..UHF2Channel), message_timeout = 5.0})
	--push_start_command(dt,  {device = devices.MAIN, action = devCmds.Cmd135,    value = UHF2Volume*0.1,	message = _("Radio 2 Volume - "..UHF2Volume.."%")})
end
function startup_radionav()--6
	push_start_command(dt,	{message = _("RADIONAV SEQUENCE INITIATED"), message_timeout = std_message_timeout})
	--TACAN
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd299,	    value = TACANMode, message = _("TACAN - "..TACANModeTalkback[TACANMode])})
	push_start_command(dt,{message = _("TUNING TACAN TO "..TACANTens..TACANOnes..TACANXY),    message_timeout = 1.0})
	push_start_command(0.5, {device = devices.MAIN,     action = devCmds.Cmd297,              value = TACANXYConverted})--relies on TACAN X/Y being at X by default. Otherwise it'll do the opposite
	for i = 1, (TACANTens), 1 do --tunes 10s from 0 to TACANTens
		push_start_command(0.2, {device = devices.MAIN,  action = devCmds.Cmd298,             value = 0.1})--value doesn't matter, only positive or negative??
	end
	for i = 1, (TACANOnes), 1 do --tunes 1s from 0 to TACANOnes
		push_start_command(0.2,	{device = devices.MAIN,  action = devCmds.Cmd301,             value = 0.1})--value doesn't seem to matter, only if +-
	end
	push_start_command(dt,      {message = _("TACAN TUNED TO "..TACANTens..TACANOnes..TACANXY),     message_timeout = 5})
	push_start_command(dt,      {device = devices.MAIN, action = devCmds.Cmd109,    value = 0.0,	message = _("TACAN VOLUME - "..TACANVolume.."%")})
	--VOR
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd302,	    value = VORMode, message = _("VOR/ILS - As set")})
	push_start_command(dt,{message = _("TUNING VOR TO 1"..VORUnits.."."..VORDecimal),    message_timeout = 1.0})
	for i = 1, (VORDeltaUnits), 1 do
		push_start_command(0.2, {device = devices.MAIN,  action = devCmds.Cmd303,             value = 0.1})--value doesn't matter, only positive or negative??
	end
	for i = 1, (VORDecimal/5), 1 do 
		push_start_command(0.2,	{device = devices.MAIN,  action = devCmds.Cmd306,             value = 0.1})--value doesn't seem to matter, only if +-
	end
	push_start_command(dt,      {message = _("VOR TUNED TO 1"..VORUnits.."."..VORDecimal),     message_timeout = 5})
	push_start_command(dt,      {device = devices.MAIN, action = devCmds.Cmd111,    value = VORVolume*.01,	message = _("VOR VOLUME - "..VORVolume.."%")})
end	
function startup_sortieprep()--7
	push_start_command(dt,	{message = _("FINAL PREP SEQUENCE INITIATED"), message_timeout = std_message_timeout})
		-- Need to add this to confirm that servos reset correctly (after C.AERO advisory goes off)
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd12,	    	value = 1.0, message = _("RESET SERVOS")})	
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd12,	    	value = 0.0})
	---COMBAT PREP
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd79,	    	value = 0.666, message = _("Radar Range Selector - 35nm")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd81,	    	value = 0.5, message = _("Radar Scan Selector - 30°")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd128,		value = 1.0, message = _("Master Arm Cover - Open")}) --"Armament master switch guard"
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd505,		value = 1.0, message = _("Matra R.550/Sidewinder Switch (MSL COOL) - ON")})
	push_start_command(dt,  {device = devices.MAIN, action = devCmds.Cmd107,    	value = MissileVolume*.01,	message = _("MSL VOLUME - "..MissileVolume.."%")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd506,		value = 1.0, message = _("Fore/Aft selector switch - Fore")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd57,			value = 1.0, message = _("Firing fuel dipper switch - On")})		
	--CMDS (Commands don't work, and I *CANNOT* figure out why. The entire CMDS panel seems to be inaccessible via macro.)
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cm371,		    value = 0.5, message = _("CMDS Selector - SGL")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cm374,		    value = 1.0, message = _("Flare Counter Reset - Push")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cm374,		    value = 0.0, message = _("Flare Counter Reset - Release")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd66,		    value = 1.0, message = _("Selective Jettison Cover - Open")})
end

--CE ONLY
function startup_nav_ce()--5
	push_start_command(dt,{message = _("CE NAV SEQUENCE INITIATED"), message_timeout = std_message_timeout})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd479,	    value = NavMode, message = _("Navigation indicator - ")..NavModeTalkback[NavMode]})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd217,	    value = 0.333, message = _("Heading and vertical reference system control switch - Gm")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd219,	    value = 1.0, message = _("Emergency gyromagnetic compass switch - On")})
	push_start_command(dt,{message = _("MAIN GYRO ALIGNING"), message_timeout = GyroTime})
	push_start_command(dt,{message = _("EMER GYRO ALIGNING"), message_timeout = EmerGyroTime})
	push_start_command(GyroTime,{message = _("MAIN GYRO ALIGNED"), message_timeout = std_message_timeout})
end
function startup_storesconfig_ce()--8
	if AutoJettConfig == 1 then
		if (DropTanks == 1)
			then
				push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd68,		    value = -1.0, message = _("Jettison Selector Switch - Fuselage")})
			else 
				push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd68,		    value = 0.0, message = _("Jettison Selector Switch - Wings 1 (inner pylons)")})
		end
		push_start_command(dt,	{message = _("FUEL TOTALIZER - ADJUSTING BY "..FuelCapCE.."L"), message_timeout = std_message_timeout})	
		for i = 1, (FuelCapCE/10), 1 do --the amount actually goes up by 100L for every 1.0 axis increase now (used to be 10L)
			push_start_command(.01,	{device = devices.MAIN,	action = devCmds.Cmd69,		value = 0.1})
		end
		for i = -1, (FuelCapCE/10), -1 do --the amount actually goes up by 10L for every 1.0 axis increase
			push_start_command(.01,	{device = devices.MAIN,	action = devCmds.Cmd69,		value = -0.1})
		end
	end
	-- Pull the knob
	push_start_command(1.0,		{device = devices.MAIN,	action = devCmds.Cmd213,	value = 1.0, message = _("Standby horizon - Uncage")})
	-- Rotate the knob to the middile position. Effectively it will uncage the gyro
	push_start_command(0.5,		{device = devices.MAIN,	action = devCmds.Cmd215,	value = 0.5})
	-- Release the knob
	push_start_command(0.1,		{device = devices.MAIN,	action = devCmds.Cmd214,	value = 0.0})
end

--EE ONLY
function startup_storesconfig_ee()--8
	if AutoJettConfig == 1 then
		if (DropTanks == 1)
			then
				push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd68,		    value = -1.0, message = _("Jettison Selector Switch - Fuselage")})
			else 
				push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd68,		    value = 0.0, message = _("Jettison Selector Switch - Wings 1 (inner pylons)")})
		end
		push_start_command(dt,	{message = _("FUEL TOTALIZER - ADJUSTING BY "..FuelCapEE.."L"), message_timeout = std_message_timeout})	
		for i = 1, (FuelCapEE/10), 1 do --the amount actually goes up by 100L for every 1.0 axis increase now (used to be 10L)
			push_start_command(.01,	{device = devices.MAIN,	action = devCmds.Cmd69,		value = 0.1})
		end
		for i = -1, (FuelCapEE/10), -1 do --the amount actually goes up by 10L for every 1.0 axis increase
			push_start_command(.01,	{device = devices.MAIN,	action = devCmds.Cmd69,		value = -0.1})
		end
	end
	-- Pull the knob
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd213,	value = 1.0, message = _("Standby horizon - Uncage")})
	-- Rotate the knob to the middile position. Effectively it will uncage the gyro
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd215,	value = 0.5})
	-- Release the knob
	push_start_command(dt,		{device = devices.MAIN,	action = devCmds.Cmd214,	value = 0.0})
end
function startup_nav_ee()--5
	push_start_command(dt,{message = _("EE NAV SEQUENCE INITIATED"), message_timeout = std_message_timeout})
	if (AlignSpeed == "FAST") then
		startup_INS_EE_FAST()
	else
		startup_INS_EE_FULL()
	end
	if EEConfigureWP == 1 then
			WaypointSet()
	end
end
function EEgyromag()
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd555,	    value = NavModeEE, message = _("Navigation indicator - ")..NavModeTalkbackEE[NavModeEE]})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd217,	    value = 0.333, message = _("Heading and vertical reference system control switch - Gm")})
	push_start_command(dt,	{device = devices.MAIN,	action = devCmds.Cmd219,	    value = 1.0, message = _("Emergency gyromagnetic compass switch - On")})
	push_start_command(dt,{message = _("MAIN GYRO ALIGNING"), message_timeout = GyroTime})
	push_start_command(dt,{message = _("EMER GYRO ALIGNING"), message_timeout = EmerGyroTime})
end
function startup_INS_EE_FAST()
	push_start_command(EEdt,	{message = _("INS SEQUENCE INITIATED"), message_timeout = std_message_timeout})
    push_start_command(EEdt,	{device = devices.MAIN,	action = devCmds.Cmd692,	value = 0.875, message = _("Modes selector - VEI")})
	push_start_command(0.2,		{device = devices.MAIN,	action = devCmds.Cmd692,	value = 0.500, message = _("Modes selector - ALCM")})	
	push_start_command(EEdt,	{device = devices.MAIN,	action = devCmds.Cmd690,	value = 0.0, message = _("Parameters selector - POS")})	
	push_start_command(EEdt,	{device = devices.MAIN,	action = devCmds.Cmd694,	value = 0.0, message = _("Waypoints selecting wheel - Waypoint 1")})
	push_start_command(EEdt,	{device = devices.MAIN,	action = devCmds.Cmd708,	value = 1.0, message = _("INS * pushbutton - Depress")}) --selects waypoint
	push_start_command(EEdt,	{device = devices.MAIN,	action = devCmds.Cmd708,	value = 0.0})	
	push_start_command(EEdt,	{device = devices.MAIN,	action = devCmds.Cmd690,	value = 0.4, message = _("Parameters selector - STS")})
	push_start_command(EEdt,{message = _("INS ALIGNING, DO NOT MOVE OR REARM"),	message_timeout = INS_fast_align})
	EEgyromag()
	push_start_command(INS_fast_align,{message = _("INS ALIGNED"),	message_timeout = 15})
	push_start_command(2.0,		{device = devices.MAIN,	action = devCmds.Cmd692,	value = 0.125, message = _("Modes selector - NAV")})
	push_start_command(EEdt,	{device = devices.MAIN,	action = devCmds.Cmd690,	value = 0.3, message = _("Parameters selector - VS/RT")})
end
function startup_INS_EE_FULL()
	push_start_command(EEdt,	{message = _("INS SEQUENCE INITIATED"), message_timeout = std_message_timeout})
    push_start_command(0.2,		{device = devices.MAIN,	action = devCmds.Cmd692,	value = 0.875, message = _("Modes selector - VEI")})
	push_start_command(EEdt,	{device = devices.MAIN,	action = devCmds.Cmd692,	value = 0.25, message = _("Modes selector - ALN")})	
	push_start_command(EEdt,	{device = devices.MAIN,	action = devCmds.Cmd690,	value = 0.0, message = _("Parameters selector - POS")})	
	push_start_command(EEdt,	{device = devices.MAIN,	action = devCmds.Cmd694,	value = 0.0, message = _("Waypoints selecting wheel - Waypoint 1")})
	push_start_command(EEdt,	{device = devices.MAIN,	action = devCmds.Cmd708,	value = 1.0, message = _("INS * pushbutton - Depress")})
	push_start_command(EEdt,	{device = devices.MAIN,	action = devCmds.Cmd708,	value = 0.0})	
	push_start_command(EEdt,	{device = devices.MAIN,	action = devCmds.Cmd690,	value = 0.4, message = _("Parameters selector - STS")})
	push_start_command(EEdt,{message = _("INS ALIGNING, DO NOT MOVE OR REARM"),message_timeout = INS_long_align})
	EEgyromag()
	push_start_command(INS_long_align,{message = _("INS ALIGNED"),	message_timeout = 15})
	push_start_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd692,	value = 0.125, message = _("Modes selector - NAV")})
	push_start_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd690,	value = 0.3, message = _("Parameters selector - VS/RT")})
end
function WaypointSet() --36 0.1s commands, 3.6s runtime
	push_start_command(EEdt,	{message = _("Setting Waypoint 2 "), message_timeout = std_message_timeout})
	push_start_command(EEdt,	{device = devices.MAIN,	action = devCmds.Cmd690,	value = 0.0, 	message = _("Parameters selector - POS")})
	--6 positions .1 apart. 0.0=Pos, .1=∆L/∆G, .2=PP, .3=VS/RT, .4=STS, .5=CDI
	push_start_command(EEdt,	{device = devices.MAIN,	action = devCmds.Cmd694,	value = 0.111,	message = _("Waypoints selecting wheel - Waypoint 2")})
	--9 positions 0.111 apart 0=WP1, .111=WP2, etc
	--Latitude
	push_start_command(EEdt,	{message = _("Latitude: "..LatDegTen..LatDegOne.."°"..LatMinTen..LatMinOne.."."..LatMinDec.."'"..NorthSouth), message_timeout = std_message_timeout})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[NorthSouth],value = 1.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[NorthSouth],value = 0.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[LatDegTen],	value = 1.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[LatDegTen],	value = 0.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[LatDegOne],	value = 1.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[LatDegOne],	value = 0.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[LatMinTen],	value = 1.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[LatMinTen],	value = 0.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[LatMinOne],	value = 1.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[LatMinOne],	value = 0.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[LatMinDec],	value = 1.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[LatMinDec],	value = 0.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = devCmds.Cmd711,	value = 1.0})--INSERT
	push_start_command(EEdt,	{device = devices.MAIN,	action = devCmds.Cmd711,	value = 0.0})
	--Longitude
	push_start_command(EEdt,	{message = _("Longitude: "..LongDegHun..LongDegTen..LongDegOne.."°"..LongMinTen..LongMinOne..LongMinDec.."'"..EastWest), message_timeout = std_message_timeout})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[EastWest],	value = 1.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[EastWest],	value = 0.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[LongDegHun],value = 1.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[LongDegHun],value = 0.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[LongDegTen],value = 1.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[LongDegTen],value = 0.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[LongDegOne],value = 1.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[LongDegOne],value = 0.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[LongMinTen],value = 1.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[LongMinTen],value = 0.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[LongMinOne],value = 1.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[LongMinOne],value = 0.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[LongMinDec],value = 1.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = INSButtons[LongMinDec],value = 0.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = devCmds.Cmd711,	value = 1.0})
	push_start_command(EEdt,	{device = devices.MAIN,	action = devCmds.Cmd711,	value = 0.0})
	
	push_start_command(EEdt,	{device = devices.MAIN,	action = devCmds.Cmd708,	value = 1.0, message = _("INS * pushbutton - Depress")})
	push_start_command(EEdt,{device = devices.MAIN,	action = devCmds.Cmd708,	value = 0.0})	
	
	push_start_command(EEdt,	{device = devices.MAIN,	action = devCmds.Cmd690,	value = 0.1, 	message = _("Parameters selector - ∆L/∆G")})
end

function startup_complete()
	push_start_command(1.0,{message = _("AUTOSTART COMPLETE"),message_timeout = std_message_timeout})
end	

function shut_down()
	push_stop_command(2.0,{message = _("AUTOSTOP SEQUENCE IS RUNNING"),message_timeout = std_message_timeout})
	
	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd459,	    value = -1.0, message = _("UHF radio - On")})

	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd143,	    value = -1.0, message = _("V/UHF radio - On")})
	
	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd125,	    value = -1.0, message = _("AMPLI 2-1 selector switch - 1")})
	
	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd190,	    value = -1.0, message = _("U/C safety lever - Closed")})
	
	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd234,	    value = 1.0, message = _("Standby horizon - Cage")})
	push_stop_command(0.5,	{device = devices.MAIN,	action = devCmds.Cmd235,	    value = 1.0})
	push_stop_command(0.5,	{device = devices.MAIN,	action = devCmds.Cmd234,	    value = 0.0})
	
	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd555,	    value = 1.0, message = _("Navigation indicator - Off")})
	push_stop_command(0.2,	{device = devices.MAIN,	action = devCmds.Cmd555,	    value = 1.0})
	push_stop_command(0.2,	{device = devices.MAIN,	action = devCmds.Cmd555,	    value = 1.0})
	
	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd230,	    value = 0.0, message = _("Standby horizon switch - Off")})
	
	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd202,	    value = 0.0, message = _("Electro-pump switch - Off")})
	
	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd283,	    value = 0.0, message = _("Warning Horn - Off")})	

	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd209,	    value = 0.0, message = _("Probe heater switch - Off")})
	
	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd442,	    value = 0.0, message = _("Radar detector switch - Off")})
	
	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd308,	    value = 0.0, message = _("Search light control - Off")})

	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd580,	    value = 0.0, message = _("Sight selector - Off")})
	
	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd605,	    value = 0.0, message = _("Radar selector - Off")})

	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd587,	    value = 0.0, message = _("Armament control panel pushbutton selectors - Released")})
	push_stop_command(0.2,	{device = devices.MAIN,	action = devCmds.Cmd588,	    value = 0.0})	
	push_stop_command(0.2,	{device = devices.MAIN,	action = devCmds.Cmd589,	    value = 0.0})	
	push_stop_command(0.2,	{device = devices.MAIN,	action = devCmds.Cmd590,	    value = 0.0})	
	push_stop_command(0.2,	{device = devices.MAIN,	action = devCmds.Cmd591,	    value = 0.0})	
	push_stop_command(0.2,	{device = devices.MAIN,	action = devCmds.Cmd592,	    value = 0.0})	
	push_stop_command(0.2,	{device = devices.MAIN,	action = devCmds.Cmd593,	    value = 0.0})
	push_stop_command(0.2,	{device = devices.MAIN,	action = devCmds.Cmd594,	    value = 0.0})
	
	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd236,	    value = 0.0, message = _("Heading and vertical reference system control switch - Off")})

	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd237,	    value = 0.0, message = _("Emergency gyromagnetic compass switch - Off")})
	
	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd339,	    value = 1.0, message = _("VOR/ILS - Off")})
	
	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd376,	    value = 0.0, message = _("Air conditioning - Off")})
	
	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd51,	    value = 1.0, message = _("Throttle cut/idle switch - Stop")})
	push_stop_command(0.5,	{device = devices.MAIN,	action = devCmds.Cmd51,	    value = 0.0})
	
	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd67,	    value = 0.0, message = _("L/H LP pump switch - Off")})

	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd66,	    value = 0.0, message = _("R/H LP pump switch - Off")})
	
	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd65,	    value = 0.0, message = _("Starting pump switch - Off")})

	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd56,	    value = 1.1})
	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd57,	    value = 1.0, message = _("LP main cock switch - Off")})	

	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd250,	    value = 0.0, message = _("Battery - Off")})
	
	push_stop_command(4.0,	{device = devices.MAIN,	action = devCmds.Cmd172,	    value = 1.0, message = _("Canopy lock control - Aft")})		
	
	push_stop_command(1.0,	{device = devices.MAIN,	action = devCmds.Cmd178,	    value = 1.0, message = _("Canopy - Open")})
	
	push_stop_command(3.0,{message = _("AUTOSTOP COMPLETE"),message_timeout = std_message_timeout})	

end	